/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2024 University of Muenster, Germany,                        *
 * Department of Computer Science.                                                 *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

#include "voreen/qt/mainwindow/menuentities/applicationmodeconfigmenuentity.h"

#include "voreen/qt/widgets/voreentoolwindow.h"
#include "voreen/qt/widgets/applicationmodeconfigdialog.h"
#include "voreen/qt/mainwindow/voreenqtmainwindow.h"

#include <QLayout>

namespace voreen {

ApplicationModeConfigMenuEntity::ApplicationModeConfigMenuEntity()
    : VoreenQtMenuEntity()
    , dialog_(0)
{}

ApplicationModeConfigMenuEntity::~ApplicationModeConfigMenuEntity() {
}

QWidget* ApplicationModeConfigMenuEntity::createWidget() const {
    dialog_ = new ApplicationModeConfigDialog(0, WsHndlr.getWorkspace()); //will be deleted by Qparent _> toolWindow
    //dialog_->resize(400, 600); //done in dialog
    //dialog_->setMinimumSize(275, 350);
    WsHndlr.registerWorkspaceUsingWidget(dialog_);
    dialog_->setMainWindow(mainWindow_);
    return dialog_;
}

void ApplicationModeConfigMenuEntity::deinitialize() {
    if(dialog_)
        WsHndlr.unregisterWorkspaceUsingWidget(dialog_);
    VoreenQtMenuEntity::deinitialize();
}

} //namespace
