/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2024 University of Muenster, Germany,                        *
 * Department of Computer Science.                                                 *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

#include "hdf5module.h"

#include "io/hdf5volumereader.h"
#include "io/hdf5volumewriter.h"

namespace voreen {

HDF5Module::HDF5Module(const std::string& modulePath)
    : VoreenModule(modulePath)
{
    setID("HDF5");
    setGuiName("HDF5");

    // The following reader spits out multiple multi-channel volumes whereas
    // the 'old' reader interprets them as multiple single-channel volumes.
    // However, the old behavior should remain, therefore we only provide the API
    // for internal purposes (such as VolumeFilterList).
    //registerVolumeReader(new HDF5VolumeReaderOriginal());

    registerVolumeReader(new HDF5VolumeReader());
    registerVolumeWriter(new HDF5VolumeWriter());

}

} // namespace
