/*  This file is part of the OpenLB library
 *
 *  Copyright (C) 2021 Adrian Kummerlaender
 *  E-mail contact: info@openlb.net
 *  The most recent release of OpenLB can be downloaded at
 *  <http://www.openlb.net/>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA  02110-1301, USA.
*/

#ifndef DYNAMICS_COLLISION_MRT_CSE_H
#define DYNAMICS_COLLISION_MRT_CSE_H


#ifndef DISABLE_CSE

#include "mrtLatticeDescriptors.h"

namespace olb {

namespace collision {

template <typename... FIELDS>
struct MRT::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x5 = V{0.05}*cell[0] + V{0.05}*cell[1] + V{0.05}*cell[2] + V{0.05}*cell[3] + V{0.05}*cell[4] + V{0.05};
auto x6 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + V{1};
auto x8 = V{1} / (x6);
auto x9 = V{3}*cell[4];
auto x10 = V{3}*cell[2];
auto x11 = V{1} / ((x6)*(x6));
auto x12 = V{3}*x11;
auto x13 = -cell[2] + cell[4];
auto x14 = x13*x13;
auto x15 = V{1.5}*x11;
auto x16 = -cell[1] + cell[3];
auto x17 = x15*(x16*x16) + V{-1};
auto x18 = -x12*x14 + x17 + x8*(-x10 + x9);
auto x19 = x8*(V{3}*cell[1] - V{3}*cell[3]);
auto x20 = cell[1] - cell[3];
auto x21 = x20*x20;
auto x22 = cell[2] - cell[4];
auto x23 = x22*x22;
auto x24 = x15*x23;
auto x25 = x12*x21 - x24 + V{1};
auto x26 = x19 + x25;
auto x27 = -x19 + x25;
auto x28 = x8*(x10 - x9);
auto x29 = -x28;
auto x30 = x12*x23;
auto x31 = x15*x21;
auto x32 = x29 + x30 - x31 + V{1};
auto x33 = V{0.5}*x7;
auto x34 = V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667};
auto x35 = x33*(-x26*x34 + x27*x34 + V{1}*cell[1] - V{1}*cell[3]);
auto x36 = V{0.075}*cell[0] + V{0.075}*cell[1] + V{0.075}*cell[2] + V{0.075}*cell[3] + V{0.075}*cell[4] + V{0.075};
auto x37 = V{0.05}*cell[0] + V{0.05}*cell[1] + V{0.05}*cell[2] + V{0.05}*cell[3] + V{0.05}*cell[4] + V{0.05};
auto x38 = x31 + V{-1};
auto x39 = -x30 + x38;
auto x40 = x28 + x39;
auto x41 = x29 + x39;
auto x42 = (x24 + x38)*(V{0.1}*cell[0] + V{0.1}*cell[1] + V{0.1}*cell[2] + V{0.1}*cell[3] + V{0.1}*cell[4] + V{0.1}) + V{0.3}*cell[0] + V{0.05};
auto x43 = x26*x36 + x27*x36 + x37*x40 + x37*x41 + x42 + V{0.3}*cell[2] + V{0.3}*cell[4];
auto x44 = x33*(x18*x34 + x32*x34 + V{1}*cell[2] - V{1}*cell[4]);
auto x45 = -x26*x37 - x27*x37 - x36*x40 - x36*x41 + x42 + V{0.3}*cell[1] + V{0.3}*cell[3];
auto x0 = x18*x5 - x26*x5 - x27*x5 - x32*x5 - (x14*x15 + x17)*(V{0.4}*cell[0] + V{0.4}*cell[1] + V{0.4}*cell[2] + V{0.4}*cell[3] + V{0.4}*cell[4] + V{0.4}) - V{0.2}*cell[0] + V{0.3}*cell[1] + V{0.3}*cell[2] + V{0.3}*cell[3] + V{0.3}*cell[4] + V{-0.2};
auto x1 = -x35 + x43 + V{0.55}*cell[1] - V{0.45}*cell[3];
auto x2 = -x44 + x45 + V{0.55}*cell[2] - V{0.45}*cell[4];
auto x3 = x35 + x43 - V{0.45}*cell[1] + V{0.55}*cell[3];
auto x4 = x44 + x45 - V{0.45}*cell[2] + V{0.55}*cell[4];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
return { x6, V{1}*x11*(x21 + x23) };
}

};

template <typename... FIELDS>
struct MRT::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = V{0.00339506172839506}*cell[0] + V{0.00339506172839506}*cell[1] + V{0.00339506172839506}*cell[2] + V{0.00339506172839506}*cell[3] + V{0.00339506172839506}*cell[4] + V{0.00339506172839506}*cell[5] + V{0.00339506172839506}*cell[6] + V{0.00339506172839506}*cell[7] + V{0.00339506172839506}*cell[8] + V{0.00339506172839506};
auto x10 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + V{1};
auto x12 = V{1} / (x10);
auto x13 = V{3}*cell[2];
auto x14 = V{3}*cell[3];
auto x15 = V{3}*cell[6];
auto x16 = V{3}*cell[7];
auto x17 = V{3}*cell[1];
auto x18 = V{3}*cell[5];
auto x19 = x17 - x18;
auto x20 = x12*(x13 + x14 - x15 - x16 + x19);
auto x21 = V{1} / ((x10)*(x10));
auto x22 = V{4.5}*x21;
auto x23 = V{2}*cell[5];
auto x24 = V{2}*cell[1];
auto x25 = -cell[4] + cell[8];
auto x26 = cell[2] - cell[6];
auto x27 = -x23 + x24 + x25 + x26;
auto x28 = x22*(x27*x27);
auto x29 = -x14 + x16;
auto x30 = x12*(x19 + x29 - V{3}*cell[4] + V{3}*cell[8]);
auto x31 = V{1.5}*x21;
auto x32 = cell[1] - cell[5];
auto x33 = x26 + x32 + cell[3] - cell[7];
auto x34 = x33*x33;
auto x35 = x31*x34;
auto x36 = -cell[3] + cell[7];
auto x37 = x25 + x32 + x36;
auto x38 = x37*x37;
auto x39 = x31*x38;
auto x40 = x39 + V{-1};
auto x41 = x35 + x40;
auto x42 = x30 + x41;
auto x43 = x20 - x28 + x42;
auto x44 = -x20;
auto x45 = V{2}*cell[3];
auto x46 = V{2}*cell[7];
auto x47 = -cell[2] + cell[6];
auto x48 = x25 - x45 + x46 + x47;
auto x49 = x22*(x48*x48);
auto x50 = -x49;
auto x51 = x42 + x44 + x50;
auto x52 = V{0.0135802469135802}*cell[0] + V{0.0135802469135802}*cell[1] + V{0.0135802469135802}*cell[2] + V{0.0135802469135802}*cell[3] + V{0.0135802469135802}*cell[4] + V{0.0135802469135802}*cell[5] + V{0.0135802469135802}*cell[6] + V{0.0135802469135802}*cell[7] + V{0.0135802469135802}*cell[8] + V{0.0135802469135802};
auto x53 = V{3}*x21;
auto x54 = x38*x53;
auto x55 = x30 - x54 + V{-1};
auto x56 = x35 + x55;
auto x57 = V{1} - x39;
auto x58 = -x35;
auto x59 = x30 + x58;
auto x60 = x57 + x59;
auto x61 = x20 + x60;
auto x62 = x28 + x61;
auto x63 = cell[4] - cell[8];
auto x64 = x26 + x45 - x46 + x63;
auto x65 = x44 + x60;
auto x66 = x22*(x64*x64) + x65;
auto x67 = x34*x53 + x57;
auto x68 = x20 + x67;
auto x69 = x54 + x59 + V{1};
auto x70 = x44 + x67;
auto x71 = V{0.00424382716049383}*cell[0] + V{0.00424382716049383}*cell[1] + V{0.00424382716049383}*cell[2] + V{0.00424382716049383}*cell[3] + V{0.00424382716049383}*cell[4] + V{0.00424382716049383}*cell[5] + V{0.00424382716049383}*cell[6] + V{0.00424382716049383}*cell[7] + V{0.00424382716049383}*cell[8] + V{0.00424382716049383};
auto x72 = x49 + x65;
auto x73 = V{0.00933641975308642}*cell[0] + V{0.00933641975308642}*cell[1] + V{0.00933641975308642}*cell[2] + V{0.00933641975308642}*cell[3] + V{0.00933641975308642}*cell[4] + V{0.00933641975308642}*cell[5] + V{0.00933641975308642}*cell[6] + V{0.00933641975308642}*cell[7] + V{0.00933641975308642}*cell[8] + V{0.00933641975308642};
auto x74 = x23 - x24 + x47 + x63;
auto x75 = x22*(x74*x74);
auto x76 = x61 + x75;
auto x77 = V{0.25}*x11;
auto x78 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x79 = x12*(-x13 + x15 - x17 + x18 + x29);
auto x80 = x30 + x79;
auto x81 = x36 + x47 - cell[1] + cell[5];
auto x82 = x31*(x81*x81);
auto x83 = -x82;
auto x84 = x49 + x57 + x83;
auto x85 = -x30;
auto x86 = -x79;
auto x87 = x57 + x83;
auto x88 = V{1}*cell[1] - V{1}*cell[3] + V{1}*cell[5] - V{1}*cell[7];
auto x89 = x40 + x82;
auto x90 = x50 + x80 + x89;
auto x91 = V{0.000848765432098765}*cell[0] + V{0.000848765432098765}*cell[1] + V{0.000848765432098765}*cell[2] + V{0.000848765432098765}*cell[3] + V{0.000848765432098765}*cell[4] + V{0.000848765432098765}*cell[5] + V{0.000848765432098765}*cell[6] + V{0.000848765432098765}*cell[7] + V{0.000848765432098765}*cell[8] + V{0.000848765432098765};
auto x92 = x28 + x44 + x57 + x58 + x85;
auto x93 = V{0.00679012345679012}*cell[0] + V{0.00679012345679012}*cell[1] + V{0.00679012345679012}*cell[2] + V{0.00679012345679012}*cell[3] + V{0.00679012345679012}*cell[4] + V{0.00679012345679012}*cell[5] + V{0.00679012345679012}*cell[6] + V{0.00679012345679012}*cell[7] + V{0.00679012345679012}*cell[8] + V{0.00679012345679012};
auto x94 = x55 + x82;
auto x95 = V{0.122222222222222}*cell[0];
auto x96 = V{0.054320987654321}*cell[0] + V{0.054320987654321}*cell[1] + V{0.054320987654321}*cell[2] + V{0.054320987654321}*cell[3] + V{0.054320987654321}*cell[4] + V{0.054320987654321}*cell[5] + V{0.054320987654321}*cell[6] + V{0.054320987654321}*cell[7] + V{0.054320987654321}*cell[8] + V{0.054320987654321};
auto x97 = x89*x96 + x95;
auto x98 = -V{0.152777777777778}*cell[3] - V{0.152777777777778}*cell[7] + V{0.0916666666666667};
auto x99 = V{0.0339506172839506}*cell[0] + V{0.0339506172839506}*cell[1] + V{0.0339506172839506}*cell[2] + V{0.0339506172839506}*cell[3] + V{0.0339506172839506}*cell[4] + V{0.0339506172839506}*cell[5] + V{0.0339506172839506}*cell[6] + V{0.0339506172839506}*cell[7] + V{0.0339506172839506}*cell[8] + V{0.0339506172839506};
auto x100 = -x69*x99 - V{0.0611111111111111}*cell[4] + V{0.305555555555556}*cell[8];
auto x101 = -x68*x99 + x70*x93 + V{0.305555555555556}*cell[2] - V{0.0611111111111111}*cell[6];
auto x102 = V{0.00848765432098765}*cell[0] + V{0.00848765432098765}*cell[1] + V{0.00848765432098765}*cell[2] + V{0.00848765432098765}*cell[3] + V{0.00848765432098765}*cell[4] + V{0.00848765432098765}*cell[5] + V{0.00848765432098765}*cell[6] + V{0.00848765432098765}*cell[7] + V{0.00848765432098765}*cell[8] + V{0.00848765432098765};
auto x103 = V{0.00169753086419753}*cell[0] + V{0.00169753086419753}*cell[1] + V{0.00169753086419753}*cell[2] + V{0.00169753086419753}*cell[3] + V{0.00169753086419753}*cell[4] + V{0.00169753086419753}*cell[5] + V{0.00169753086419753}*cell[6] + V{0.00169753086419753}*cell[7] + V{0.00169753086419753}*cell[8] + V{0.00169753086419753};
auto x104 = V{0.0577160493827161}*cell[0] + V{0.0577160493827161}*cell[1] + V{0.0577160493827161}*cell[2] + V{0.0577160493827161}*cell[3] + V{0.0577160493827161}*cell[4] + V{0.0577160493827161}*cell[5] + V{0.0577160493827161}*cell[6] + V{0.0577160493827161}*cell[7] + V{0.0577160493827161}*cell[8] + V{0.0577160493827161};
auto x105 = V{0.0237654320987654}*cell[0] + V{0.0237654320987654}*cell[1] + V{0.0237654320987654}*cell[2] + V{0.0237654320987654}*cell[3] + V{0.0237654320987654}*cell[4] + V{0.0237654320987654}*cell[5] + V{0.0237654320987654}*cell[6] + V{0.0237654320987654}*cell[7] + V{0.0237654320987654}*cell[8] + V{0.0237654320987654};
auto x106 = V{0.305555555555556}*cell[3] - V{0.0611111111111111}*cell[7];
auto x107 = V{0.305555555555556}*cell[1] - V{0.0611111111111111}*cell[5];
auto x108 = V{0.0169753086419753}*cell[0] + V{0.0169753086419753}*cell[1] + V{0.0169753086419753}*cell[2] + V{0.0169753086419753}*cell[3] + V{0.0169753086419753}*cell[4] + V{0.0169753086419753}*cell[5] + V{0.0169753086419753}*cell[6] + V{0.0169753086419753}*cell[7] + V{0.0169753086419753}*cell[8] + V{0.0169753086419753};
auto x109 = V{1}*cell[2];
auto x110 = V{1}*cell[6];
auto x111 = V{1}*cell[4];
auto x112 = V{1}*cell[8];
auto x113 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x114 = x113*x69;
auto x115 = x113*x68;
auto x116 = x113*x70;
auto x117 = x113*x94;
auto x118 = x108*x69 - x108*x94 - x77*(x109 + x110 - x111 - x112 + x114 - x115 - x116 - x117) + x97 - V{0.152777777777778}*cell[4] - V{0.152777777777778}*cell[8];
auto x119 = x41*x96 + x95;
auto x120 = x119 + x56*x99 + x69*x93 + V{0.305555555555556}*cell[4] - V{0.0611111111111111}*cell[8];
auto x121 = x77*(x72*x78 - x76*x78 - x78*x90 - x78*x92 + x88);
auto x122 = x121 - x43*x71 + x62*x71 - V{0.152777777777778}*cell[1] - V{0.152777777777778}*cell[5] + V{0.0916666666666667};
auto x123 = -V{0.0611111111111111}*cell[1] + V{0.305555555555556}*cell[5];
auto x124 = x108*x68 + x108*x70 + x119 - x77*(-x109 - x110 + x111 + x112 - x114 + x115 + x116 + x117) - V{0.152777777777778}*cell[2] - V{0.152777777777778}*cell[6] + V{-4.85722573273506e-17};
auto x125 = x68*x93 - x70*x99 - V{0.0611111111111111}*cell[2] + V{0.305555555555556}*cell[6];
auto x126 = -V{0.0611111111111111}*cell[3] + V{0.305555555555556}*cell[7];
auto x0 = -x41*(V{0.434567901234568}*cell[0] + V{0.434567901234568}*cell[1] + V{0.434567901234568}*cell[2] + V{0.434567901234568}*cell[3] + V{0.434567901234568}*cell[4] + V{0.434567901234568}*cell[5] + V{0.434567901234568}*cell[6] + V{0.434567901234568}*cell[7] + V{0.434567901234568}*cell[8] + V{0.434567901234568}) + x43*x9 + x51*x9 + x52*x56 - x52*x68 - x52*x69 - x52*x70 - x62*x9 - x66*x9 + V{0.0222222222222221}*cell[0] + V{0.122222222222222}*cell[1] + V{0.122222222222222}*cell[2] + V{0.122222222222222}*cell[3] + V{0.122222222222222}*cell[4] + V{0.122222222222222}*cell[5] + V{0.122222222222222}*cell[6] + V{0.122222222222222}*cell[7] + V{0.122222222222222}*cell[8] + V{-0.366666666666667};
auto x1 = x100 + x101 + x71*x72 - x71*x90 + x73*x76 - x77*(x78*(x80 + x84) + x78*(x84 + x85 + x86) - x78*(x28 + x30 + x86 + x87) - x78*(x75 + x79 + x85 + x87) + x88) - x91*x92 - x93*x94 + x97 + x98 + V{0.663888888888889}*cell[1] + V{0.0305555555555556}*cell[5];
auto x2 = -x102*x76 + x102*x90 + x103*x72 + x103*x92 + x104*x68 - x105*x70 + x106 + x107 + x118 + V{0.480555555555556}*cell[2] + V{0.213888888888889}*cell[6] + V{-4.60279962292513e-17};
auto x3 = x101 + x120 + x122 - x51*x73 - x66*x91 + V{0.663888888888889}*cell[3] + V{0.0305555555555556}*cell[7];
auto x4 = x102*x43 + x102*x51 + x103*x62 + x103*x66 - x104*x56 - x105*x69 + x106 + x123 + x124 + V{0.480555555555556}*cell[4] + V{0.213888888888889}*cell[8];
auto x5 = x120 - x121 + x125 - x43*x73 - x51*x71 - x62*x91 + x66*x71 + x98 + V{0.0305555555555556}*cell[1] + V{0.663888888888889}*cell[5];
auto x6 = -x102*x72 - x102*x92 + x103*x76 - x103*x90 + x104*x70 - x105*x68 + x118 + x123 + x126 + V{0.213888888888889}*cell[2] + V{0.480555555555556}*cell[6] + V{-5.11165184254499e-17};
auto x7 = x100 + x119 + x122 + x125 + x51*x91 - x56*x93 + x66*x73 + V{0.0305555555555556}*cell[3] + V{0.663888888888889}*cell[7];
auto x8 = -x102*x62 - x102*x66 - x103*x43 - x103*x51 + x104*x69 + x105*x56 + x107 + x124 + x126 + V{0.213888888888889}*cell[4] + V{0.480555555555556}*cell[8];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
cell[7] = x7;
cell[8] = x8;
return { x10, V{1}*x21*(x34 + x38) };
}

};

template <typename... FIELDS>
struct MRT::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x7 = V{0.0339285714285714}*cell[0] + V{0.0339285714285714}*cell[1] + V{0.0339285714285714}*cell[2] + V{0.0339285714285714}*cell[3] + V{0.0339285714285714}*cell[4] + V{0.0339285714285714}*cell[5] + V{0.0339285714285714}*cell[6] + V{0.0339285714285714};
auto x8 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1};
auto x9 = V{1} / (x8);
auto x11 = V{4}*cell[4];
auto x12 = V{4}*cell[1];
auto x13 = V{1} / ((x8)*(x8));
auto x14 = V{6}*x13;
auto x15 = -cell[1] + cell[4];
auto x16 = x15*x15;
auto x17 = V{2}*x13;
auto x18 = -cell[2] + cell[5];
auto x19 = x18*x18;
auto x20 = x17*x19;
auto x21 = -cell[3] + cell[6];
auto x22 = x21*x21;
auto x23 = x17*x22;
auto x24 = x20 + x23 + V{-1};
auto x25 = -x14*x16 + x24 + x9*(x11 - x12);
auto x26 = V{4}*cell[5];
auto x27 = V{4}*cell[2];
auto x28 = x16*x17;
auto x29 = x28 + V{-1};
auto x30 = -x14*x19 + x23 + x29 + x9*(x26 - x27);
auto x31 = V{4}*cell[6];
auto x32 = V{4}*cell[3];
auto x33 = -x14*x22 + x20 + x29 + x9*(x31 - x32);
auto x34 = x9*(-x11 + x12);
auto x35 = -x34;
auto x36 = cell[1] - cell[4];
auto x37 = x36*x36;
auto x38 = x14*x37;
auto x39 = cell[2] - cell[5];
auto x40 = x39*x39;
auto x41 = x17*x40;
auto x42 = -x41;
auto x43 = cell[3] - cell[6];
auto x44 = x43*x43;
auto x45 = x17*x44;
auto x46 = V{1} - x45;
auto x47 = x35 + x38 + x42 + x46;
auto x48 = x9*(-x26 + x27);
auto x49 = -x48;
auto x50 = x14*x40;
auto x51 = x17*x37;
auto x52 = -x51;
auto x53 = x46 + x49 + x50 + x52;
auto x54 = x9*(-x31 + x32);
auto x55 = -x54;
auto x56 = x14*x44;
auto x57 = x42 + x52 + x55 + x56 + V{1};
auto x58 = V{0.271428571428571}*cell[2];
auto x59 = V{0.271428571428571}*cell[3];
auto x60 = V{0.271428571428571}*cell[5];
auto x61 = V{0.271428571428571}*cell[6];
auto x62 = x58 + x59 + x60 + x61;
auto x63 = V{0.271428571428571}*cell[1] + V{0.271428571428571}*cell[4];
auto x64 = V{0.5}*x10;
auto x65 = V{0.125}*cell[0] + V{0.125}*cell[1] + V{0.125}*cell[2] + V{0.125}*cell[3] + V{0.125}*cell[4] + V{0.125}*cell[5] + V{0.125}*cell[6] + V{0.125};
auto x66 = x64*(x25*x65 + x47*x65 + V{1}*cell[1] - V{1}*cell[4]);
auto x67 = V{0.0848214285714286}*cell[0] + V{0.0848214285714286}*cell[1] + V{0.0848214285714286}*cell[2] + V{0.0848214285714286}*cell[3] + V{0.0848214285714286}*cell[4] + V{0.0848214285714286}*cell[5] + V{0.0848214285714286}*cell[6] + V{0.0848214285714286};
auto x68 = x41 + V{-1};
auto x69 = -x38 + x45 + x68;
auto x70 = x34 + x69;
auto x71 = x35 + x69;
auto x72 = V{0.271428571428571}*cell[0];
auto x73 = x45 + x51 + V{-1};
auto x74 = (x41 + x73)*(V{0.0678571428571428}*cell[0] + V{0.0678571428571428}*cell[1] + V{0.0678571428571428}*cell[2] + V{0.0678571428571428}*cell[3] + V{0.0678571428571428}*cell[4] + V{0.0678571428571428}*cell[5] + V{0.0678571428571428}*cell[6] + V{0.0678571428571428});
auto x75 = x51 - x56 + x68;
auto x76 = x54 + x75;
auto x77 = x55 + x75;
auto x78 = x7*x76 + x7*x77 + x72 + x74 + V{0.0339285714285714};
auto x79 = -x50 + x73;
auto x80 = x48 + x79;
auto x81 = x49 + x79;
auto x82 = x7*x80 + x7*x81;
auto x83 = x62 - x67*x70 - x67*x71 + x78 + x82;
auto x84 = x64*(x30*x65 + x53*x65 + V{1}*cell[2] - V{1}*cell[5]);
auto x85 = V{0.0848214285714286}*cell[0] + V{0.0848214285714286}*cell[1] + V{0.0848214285714286}*cell[2] + V{0.0848214285714286}*cell[3] + V{0.0848214285714286}*cell[4] + V{0.0848214285714286}*cell[5] + V{0.0848214285714286}*cell[6] + V{0.0848214285714286};
auto x86 = x63 + x7*x70 + x7*x71;
auto x87 = x59 + x61 + x78 - x80*x85 - x81*x85 + x86;
auto x88 = x64*(x33*x65 + x57*x65 + V{1}*cell[3] - V{1}*cell[6]);
auto x89 = x58 + x60 + x72 + x74 - x76*x85 - x77*x85 + x82 + x86 + V{0.0339285714285714};
auto x0 = x25*x7 + x30*x7 + x33*x7 - x47*x7 - x53*x7 - x57*x7 + x62 + x63 - (x24 + x28)*(V{0.407142857142857}*cell[0] + V{0.407142857142857}*cell[1] + V{0.407142857142857}*cell[2] + V{0.407142857142857}*cell[3] + V{0.407142857142857}*cell[4] + V{0.407142857142857}*cell[5] + V{0.407142857142857}*cell[6] + V{0.407142857142857}) - V{0.628571428571429}*cell[0] + V{-0.203571428571429};
auto x1 = -x66 + x83 + V{0.321428571428572}*cell[1] - V{0.678571428571428}*cell[4];
auto x2 = -x84 + x87 + V{0.321428571428571}*cell[2] - V{0.678571428571429}*cell[5];
auto x3 = -x88 + x89 + V{0.321428571428571}*cell[3] - V{0.678571428571429}*cell[6];
auto x4 = x66 + x83 - V{0.678571428571428}*cell[1] + V{0.321428571428572}*cell[4];
auto x5 = x84 + x87 - V{0.678571428571429}*cell[2] + V{0.321428571428571}*cell[5];
auto x6 = x88 + x89 - V{0.678571428571429}*cell[3] + V{0.321428571428571}*cell[6];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
return { x8, V{1}*x13*(x37 + x40 + x44) };
}

};

template <typename... FIELDS>
struct MRT::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = V{0.00146198830409357}*cell[0] + V{0.00146198830409357}*cell[10] + V{0.00146198830409357}*cell[11] + V{0.00146198830409357}*cell[12] + V{0.00146198830409357}*cell[13] + V{0.00146198830409357}*cell[14] + V{0.00146198830409357}*cell[15] + V{0.00146198830409357}*cell[16] + V{0.00146198830409357}*cell[17] + V{0.00146198830409357}*cell[18] + V{0.00146198830409357}*cell[1] + V{0.00146198830409357}*cell[2] + V{0.00146198830409357}*cell[3] + V{0.00146198830409357}*cell[4] + V{0.00146198830409357}*cell[5] + V{0.00146198830409357}*cell[6] + V{0.00146198830409357}*cell[7] + V{0.00146198830409357}*cell[8] + V{0.00146198830409357}*cell[9] + V{0.00146198830409357};
auto x20 = cell[10] + cell[12];
auto x21 = x20 + cell[0] + cell[11] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x23 = V{1} / (x21);
auto x24 = V{3}*cell[7];
auto x25 = V{3}*cell[9];
auto x26 = V{3}*cell[16];
auto x27 = V{3}*cell[18];
auto x28 = V{3}*cell[17] - V{3}*cell[8];
auto x29 = V{3}*cell[15] - V{3}*cell[6];
auto x30 = x23*(x24 + x25 - x26 - x27 + x28 + x29 + V{3}*cell[12] - V{3}*cell[3]);
auto x31 = V{1} / ((x21)*(x21));
auto x32 = V{4.5}*x31;
auto x33 = cell[13] - cell[4];
auto x34 = cell[15] - cell[6];
auto x35 = x33 + x34;
auto x36 = -cell[2];
auto x37 = -cell[14];
auto x38 = x36 + x37 + cell[11] + cell[5];
auto x39 = -cell[3];
auto x40 = -cell[16] + cell[7];
auto x41 = x39 + x40 + cell[12];
auto x42 = x35 + x38 + x41 + V{2}*cell[17] - V{2}*cell[8];
auto x43 = x32*(x42*x42);
auto x44 = V{3}*cell[5];
auto x45 = V{3}*cell[14];
auto x46 = V{3}*cell[13] - V{3}*cell[4];
auto x47 = x23*(-x25 + x27 + x28 + x44 - x45 + x46 + V{3}*cell[11] - V{3}*cell[2]);
auto x48 = V{1.5}*x31;
auto x49 = cell[17] - cell[8];
auto x50 = x33 + x49;
auto x51 = cell[18] - cell[9];
auto x52 = x38 + x50 + x51;
auto x53 = x52*x52;
auto x54 = x48*x53;
auto x55 = cell[14] - cell[5];
auto x56 = -cell[1];
auto x57 = cell[16] - cell[7];
auto x58 = x56 + x57 + cell[10];
auto x59 = x35 + x55 + x58;
auto x60 = x59*x59;
auto x61 = x48*x60;
auto x62 = x34 + x49;
auto x63 = -cell[18] + cell[9];
auto x64 = x41 + x62 + x63;
auto x65 = x64*x64;
auto x66 = x48*x65;
auto x67 = x61 + x66 + V{-1};
auto x68 = x54 + x67;
auto x69 = x47 + x68;
auto x70 = x30 - x43 + x69;
auto x71 = x23*(-x24 + x26 + x29 - x44 + x45 + x46 + V{3}*cell[10] - V{3}*cell[1]);
auto x72 = x36 + x51 + cell[11];
auto x73 = x58 + x62 + x72 + V{2}*cell[13] - V{2}*cell[4];
auto x74 = x32*(x73*x73);
auto x75 = x69 + x71 - x74;
auto x76 = V{2}*cell[18];
auto x77 = V{2}*cell[9];
auto x78 = -cell[13] + cell[4];
auto x79 = x34 - cell[11] + cell[2];
auto x80 = x41 + x55 - x76 + x77 + x78 + x79;
auto x81 = -x30;
auto x82 = x69 + x81;
auto x83 = -x32*x80*x80 + x82;
auto x84 = -x71;
auto x85 = V{2}*cell[5];
auto x86 = V{2}*cell[14];
auto x87 = -cell[17] + cell[8];
auto x88 = x58 + x63 + x79 - x85 + x86 + x87;
auto x89 = x32*(x88*x88);
auto x90 = -x89;
auto x91 = x69 + x84 + x90;
auto x92 = x55 + x56;
auto x93 = x39 + x63;
auto x94 = x20 + x50 + x92 + x93 + V{2}*cell[15] - V{2}*cell[6];
auto x95 = x32*(x94*x94);
auto x96 = x30 + x68;
auto x97 = x71 - x95 + x96;
auto x98 = -x47;
auto x99 = -cell[15] + cell[6];
auto x100 = x33 - cell[12] + cell[3];
auto x101 = x100 + x38 + x57 + x76 - x77 + x99;
auto x102 = -x32*x101*x101;
auto x103 = x102 + x96 + x98;
auto x104 = V{2}*cell[7];
auto x105 = V{2}*cell[16];
auto x106 = x100 - x104 + x105 + x51 + x87 + x92 + cell[10];
auto x107 = -x32*x106*x106;
auto x108 = x107 + x84 + x96;
auto x109 = x49 - cell[10] + cell[1];
auto x110 = x109 + x40 + x72 + x85 - x86 + x99;
auto x111 = x32*(x110*x110);
auto x112 = x68 + x71;
auto x113 = x112 + x98;
auto x114 = -x111 + x113;
auto x115 = x104 - x105 + x109 + x37 + x78 + x93 + cell[12] + cell[5];
auto x116 = x112 + x81;
auto x117 = x116 - x32*x115*x115;
auto x118 = V{0.00570175438596491}*cell[0] + V{0.00570175438596491}*cell[10] + V{0.00570175438596491}*cell[11] + V{0.00570175438596491}*cell[12] + V{0.00570175438596491}*cell[13] + V{0.00570175438596491}*cell[14] + V{0.00570175438596491}*cell[15] + V{0.00570175438596491}*cell[16] + V{0.00570175438596491}*cell[17] + V{0.00570175438596491}*cell[18] + V{0.00570175438596491}*cell[1] + V{0.00570175438596491}*cell[2] + V{0.00570175438596491}*cell[3] + V{0.00570175438596491}*cell[4] + V{0.00570175438596491}*cell[5] + V{0.00570175438596491}*cell[6] + V{0.00570175438596491}*cell[7] + V{0.00570175438596491}*cell[8] + V{0.00570175438596491}*cell[9] + V{0.00570175438596491};
auto x119 = V{3}*x31;
auto x120 = x119*x53;
auto x121 = -x120 + x47 + x67;
auto x122 = x119*x65;
auto x123 = x54 + V{-1};
auto x124 = -x122 + x123 + x30 + x61;
auto x125 = x119*x60;
auto x126 = x123 - x125 + x66 + x71;
auto x127 = -x66;
auto x128 = V{1} - x61;
auto x129 = x127 + x128;
auto x130 = x129 + x47;
auto x131 = -x54;
auto x132 = x131 + x30;
auto x133 = x130 + x132 + x43;
auto x134 = x131 + x71;
auto x135 = x130 + x134 + x74;
auto x136 = x129 + x132 + x71 + x95;
auto x137 = x120 + x130;
auto x138 = x122 + x128 + x132;
auto x139 = x125 + x127 + x134 + V{1};
auto x140 = V{0.00110298895386615}*cell[0] + V{0.00110298895386615}*cell[10] + V{0.00110298895386615}*cell[11] + V{0.00110298895386615}*cell[12] + V{0.00110298895386615}*cell[13] + V{0.00110298895386615}*cell[14] + V{0.00110298895386615}*cell[15] + V{0.00110298895386615}*cell[16] + V{0.00110298895386615}*cell[17] + V{0.00110298895386615}*cell[18] + V{0.00110298895386615}*cell[1] + V{0.00110298895386615}*cell[2] + V{0.00110298895386615}*cell[3] + V{0.00110298895386615}*cell[4] + V{0.00110298895386615}*cell[5] + V{0.00110298895386615}*cell[6] + V{0.00110298895386615}*cell[7] + V{0.00110298895386615}*cell[8] + V{0.00110298895386615}*cell[9] + V{0.00110298895386615};
auto x141 = V{0.0522303443794672}*cell[0] + V{0.0522303443794672}*cell[10] + V{0.0522303443794672}*cell[11] + V{0.0522303443794672}*cell[12] + V{0.0522303443794672}*cell[13] + V{0.0522303443794672}*cell[14] + V{0.0522303443794672}*cell[15] + V{0.0522303443794672}*cell[16] + V{0.0522303443794672}*cell[17] + V{0.0522303443794672}*cell[18] + V{0.0522303443794672}*cell[1] + V{0.0522303443794672}*cell[2] + V{0.0522303443794672}*cell[3] + V{0.0522303443794672}*cell[4] + V{0.0522303443794672}*cell[5] + V{0.0522303443794672}*cell[6] + V{0.0522303443794672}*cell[7] + V{0.0522303443794672}*cell[8] + V{0.0522303443794672}*cell[9] + V{0.0522303443794672};
auto x142 = V{0.00652046783625729}*cell[3];
auto x143 = V{0.00652046783625729}*cell[12];
auto x144 = V{0.102631578947368}*cell[0];
auto x145 = x68*(V{0.0342105263157895}*cell[0] + V{0.0342105263157895}*cell[10] + V{0.0342105263157895}*cell[11] + V{0.0342105263157895}*cell[12] + V{0.0342105263157895}*cell[13] + V{0.0342105263157895}*cell[14] + V{0.0342105263157895}*cell[15] + V{0.0342105263157895}*cell[16] + V{0.0342105263157895}*cell[17] + V{0.0342105263157895}*cell[18] + V{0.0342105263157895}*cell[1] + V{0.0342105263157895}*cell[2] + V{0.0342105263157895}*cell[3] + V{0.0342105263157895}*cell[4] + V{0.0342105263157895}*cell[5] + V{0.0342105263157895}*cell[6] + V{0.0342105263157895}*cell[7] + V{0.0342105263157895}*cell[8] + V{0.0342105263157895}*cell[9] + V{0.0342105263157895});
auto x146 = V{0.00732618583495776}*cell[0] + V{0.00732618583495776}*cell[10] + V{0.00732618583495776}*cell[11] + V{0.00732618583495776}*cell[12] + V{0.00732618583495776}*cell[13] + V{0.00732618583495776}*cell[14] + V{0.00732618583495776}*cell[15] + V{0.00732618583495776}*cell[16] + V{0.00732618583495776}*cell[17] + V{0.00732618583495776}*cell[18] + V{0.00732618583495776}*cell[1] + V{0.00732618583495776}*cell[2] + V{0.00732618583495776}*cell[3] + V{0.00732618583495776}*cell[4] + V{0.00732618583495776}*cell[5] + V{0.00732618583495776}*cell[6] + V{0.00732618583495776}*cell[7] + V{0.00732618583495776}*cell[8] + V{0.00732618583495776}*cell[9] + V{0.00732618583495776};
auto x147 = V{0.000362248213125405}*cell[0] + V{0.000362248213125405}*cell[10] + V{0.000362248213125405}*cell[11] + V{0.000362248213125405}*cell[12] + V{0.000362248213125405}*cell[13] + V{0.000362248213125405}*cell[14] + V{0.000362248213125405}*cell[15] + V{0.000362248213125405}*cell[16] + V{0.000362248213125405}*cell[17] + V{0.000362248213125405}*cell[18] + V{0.000362248213125405}*cell[1] + V{0.000362248213125405}*cell[2] + V{0.000362248213125405}*cell[3] + V{0.000362248213125405}*cell[4] + V{0.000362248213125405}*cell[5] + V{0.000362248213125405}*cell[6] + V{0.000362248213125405}*cell[7] + V{0.000362248213125405}*cell[8] + V{0.000362248213125405}*cell[9] + V{0.000362248213125405};
auto x148 = x124*x147;
auto x149 = V{0.000659519168291098}*cell[0] + V{0.000659519168291098}*cell[10] + V{0.000659519168291098}*cell[11] + V{0.000659519168291098}*cell[12] + V{0.000659519168291098}*cell[13] + V{0.000659519168291098}*cell[14] + V{0.000659519168291098}*cell[15] + V{0.000659519168291098}*cell[16] + V{0.000659519168291098}*cell[17] + V{0.000659519168291098}*cell[18] + V{0.000659519168291098}*cell[1] + V{0.000659519168291098}*cell[2] + V{0.000659519168291098}*cell[3] + V{0.000659519168291098}*cell[4] + V{0.000659519168291098}*cell[5] + V{0.000659519168291098}*cell[6] + V{0.000659519168291098}*cell[7] + V{0.000659519168291098}*cell[8] + V{0.000659519168291098}*cell[9] + V{0.000659519168291098};
auto x150 = -x138*x147;
auto x151 = -x135*x149 + x142 + x143 + x144 + x145 + x146*x75 + x148 + x150 + V{0.0237426900584795}*cell[13] + V{0.26374269005848}*cell[4];
auto x152 = V{0.00652046783625729}*cell[2];
auto x153 = V{0.00652046783625729}*cell[11];
auto x154 = x121*x147;
auto x155 = -x137*x147;
auto x156 = -x136*x149 + x146*x97 + x152 + x153 + x154 + x155 + V{0.0237426900584795}*cell[15] + V{0.26374269005848}*cell[6];
auto x157 = x113 + x90;
auto x158 = x146*x157 + x149*x91 + V{0.0237426900584795}*cell[14] + V{0.26374269005848}*cell[5];
auto x159 = x107 + x116;
auto x160 = x108*x149 + x146*x159 + V{0.0237426900584795}*cell[16] + V{0.26374269005848}*cell[7];
auto x161 = V{0.00248862897985705}*cell[0] + V{0.00248862897985705}*cell[10] + V{0.00248862897985705}*cell[11] + V{0.00248862897985705}*cell[12] + V{0.00248862897985705}*cell[13] + V{0.00248862897985705}*cell[14] + V{0.00248862897985705}*cell[15] + V{0.00248862897985705}*cell[16] + V{0.00248862897985705}*cell[17] + V{0.00248862897985705}*cell[18] + V{0.00248862897985705}*cell[1] + V{0.00248862897985705}*cell[2] + V{0.00248862897985705}*cell[3] + V{0.00248862897985705}*cell[4] + V{0.00248862897985705}*cell[5] + V{0.00248862897985705}*cell[6] + V{0.00248862897985705}*cell[7] + V{0.00248862897985705}*cell[8] + V{0.00248862897985705}*cell[9] + V{0.00248862897985705};
auto x162 = x102 + x82;
auto x163 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x164 = x159*x163;
auto x165 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x166 = V{1}*cell[7];
auto x167 = V{1}*cell[16];
auto x168 = x108*x163;
auto x169 = x166 + x167 + x168;
auto x170 = x163*x91;
auto x171 = V{1}*cell[4];
auto x172 = V{1}*cell[13];
auto x173 = x163*x75;
auto x174 = x135*x163;
auto x175 = V{1}*cell[14] + V{1}*cell[5];
auto x176 = -x124*x165 + x138*x165 + x171 + x172 + x173 - x174 + x175 - V{1}*cell[12] - V{1}*cell[3];
auto x177 = x157*x163 + x170 + x176;
auto x178 = V{1}*cell[6];
auto x179 = V{1}*cell[15];
auto x180 = V{1}*cell[2];
auto x181 = V{1}*cell[11];
auto x182 = x163*x97;
auto x183 = x137*x165;
auto x184 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[10] + V{0.111111111111111}*cell[11] + V{0.111111111111111}*cell[12] + V{0.111111111111111}*cell[13] + V{0.111111111111111}*cell[14] + V{0.111111111111111}*cell[15] + V{0.111111111111111}*cell[16] + V{0.111111111111111}*cell[17] + V{0.111111111111111}*cell[18] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111}*cell[9] + V{0.111111111111111};
auto x185 = x136*x163;
auto x186 = x121*x165;
auto x187 = -x103*x165 + x126*x184 + x133*x165 - x139*x184 - x165*x70 + x178 + x179 - x180 - x181 + x182 + x183 - x185 - x186 + V{2}*cell[10] - V{2}*cell[17] - V{2}*cell[18] + V{2}*cell[1] - V{2}*cell[8] - V{2}*cell[9];
auto x188 = -x162*x165 + x164 + x169 + x177 + x187;
auto x189 = V{0.0555555555555556}*x188*x22;
auto x190 = -x103*x161 + x133*x161 - x161*x162 - x161*x70 - x189 - V{0.0895906432748538}*cell[17] - V{0.0895906432748538}*cell[18] - V{0.0895906432748538}*cell[8] - V{0.0895906432748538}*cell[9];
auto x191 = V{0.00110298895386615}*cell[0] + V{0.00110298895386615}*cell[10] + V{0.00110298895386615}*cell[11] + V{0.00110298895386615}*cell[12] + V{0.00110298895386615}*cell[13] + V{0.00110298895386615}*cell[14] + V{0.00110298895386615}*cell[15] + V{0.00110298895386615}*cell[16] + V{0.00110298895386615}*cell[17] + V{0.00110298895386615}*cell[18] + V{0.00110298895386615}*cell[1] + V{0.00110298895386615}*cell[2] + V{0.00110298895386615}*cell[3] + V{0.00110298895386615}*cell[4] + V{0.00110298895386615}*cell[5] + V{0.00110298895386615}*cell[6] + V{0.00110298895386615}*cell[7] + V{0.00110298895386615}*cell[8] + V{0.00110298895386615}*cell[9] + V{0.00110298895386615};
auto x192 = V{0.0522303443794672}*cell[0] + V{0.0522303443794672}*cell[10] + V{0.0522303443794672}*cell[11] + V{0.0522303443794672}*cell[12] + V{0.0522303443794672}*cell[13] + V{0.0522303443794672}*cell[14] + V{0.0522303443794672}*cell[15] + V{0.0522303443794672}*cell[16] + V{0.0522303443794672}*cell[17] + V{0.0522303443794672}*cell[18] + V{0.0522303443794672}*cell[1] + V{0.0522303443794672}*cell[2] + V{0.0522303443794672}*cell[3] + V{0.0522303443794672}*cell[4] + V{0.0522303443794672}*cell[5] + V{0.0522303443794672}*cell[6] + V{0.0522303443794672}*cell[7] + V{0.0522303443794672}*cell[8] + V{0.0522303443794672}*cell[9] + V{0.0522303443794672};
auto x193 = x146*x91 + x149*x157 + V{0.26374269005848}*cell[14] + V{0.0237426900584795}*cell[5];
auto x194 = V{0.00652046783625729}*cell[1];
auto x195 = V{0.00652046783625729}*cell[10];
auto x196 = V{0.0277777777777778}*x22;
auto x197 = x188*x196;
auto x198 = x126*x147;
auto x199 = -x139*x147;
auto x200 = -x133*x149 + x146*x70 + x194 + x195 + x197 + x198 + x199 + V{0.0237426900584795}*cell[17] + V{0.26374269005848}*cell[8];
auto x201 = x103*x149 + x146*x162 + V{0.0237426900584795}*cell[18] + V{0.26374269005848}*cell[9];
auto x202 = V{0.0833333333333333}*x22;
auto x203 = -x178 - x179 - x182 + x185;
auto x204 = -x166 - x167 - x168 + x180 + x181 - x183 + x186 + x203;
auto x205 = x202*(-x164 + x177 + x204);
auto x206 = -x205;
auto x207 = -x108*x161 + x136*x161 - x159*x161 - x161*x97 + x206 - V{0.0895906432748538}*cell[15] - V{0.0895906432748538}*cell[16] - V{0.0895906432748538}*cell[6] - V{0.0895906432748538}*cell[7];
auto x208 = x108*x146 + x144 + x145 + x149*x159 + V{0.26374269005848}*cell[16] + V{0.0237426900584795}*cell[7];
auto x209 = x103*x146 + x149*x162 + V{0.26374269005848}*cell[18] + V{0.0237426900584795}*cell[9];
auto x210 = x135*x161 - x157*x161 - x161*x75 - x161*x91 + x205 - V{0.0895906432748538}*cell[13] - V{0.0895906432748538}*cell[14] - V{0.0895906432748538}*cell[4] - V{0.0895906432748538}*cell[5] + V{0.00652046783625723};
auto x211 = V{0.00608390188434048}*cell[0] + V{0.00608390188434048}*cell[10] + V{0.00608390188434048}*cell[11] + V{0.00608390188434048}*cell[12] + V{0.00608390188434048}*cell[13] + V{0.00608390188434048}*cell[14] + V{0.00608390188434048}*cell[15] + V{0.00608390188434048}*cell[16] + V{0.00608390188434048}*cell[17] + V{0.00608390188434048}*cell[18] + V{0.00608390188434048}*cell[1] + V{0.00608390188434048}*cell[2] + V{0.00608390188434048}*cell[3] + V{0.00608390188434048}*cell[4] + V{0.00608390188434048}*cell[5] + V{0.00608390188434048}*cell[6] + V{0.00608390188434048}*cell[7] + V{0.00608390188434048}*cell[8] + V{0.00608390188434048}*cell[9] + V{0.00608390188434048};
auto x212 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x213 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x214 = V{0.0186151721897336}*cell[0] + V{0.0186151721897336}*cell[10] + V{0.0186151721897336}*cell[11] + V{0.0186151721897336}*cell[12] + V{0.0186151721897336}*cell[13] + V{0.0186151721897336}*cell[14] + V{0.0186151721897336}*cell[15] + V{0.0186151721897336}*cell[16] + V{0.0186151721897336}*cell[17] + V{0.0186151721897336}*cell[18] + V{0.0186151721897336}*cell[1] + V{0.0186151721897336}*cell[2] + V{0.0186151721897336}*cell[3] + V{0.0186151721897336}*cell[4] + V{0.0186151721897336}*cell[5] + V{0.0186151721897336}*cell[6] + V{0.0186151721897336}*cell[7] + V{0.0186151721897336}*cell[8] + V{0.0186151721897336}*cell[9] + V{0.0186151721897336};
auto x215 = V{0.0122181611435997}*cell[0] + V{0.0122181611435997}*cell[10] + V{0.0122181611435997}*cell[11] + V{0.0122181611435997}*cell[12] + V{0.0122181611435997}*cell[13] + V{0.0122181611435997}*cell[14] + V{0.0122181611435997}*cell[15] + V{0.0122181611435997}*cell[16] + V{0.0122181611435997}*cell[17] + V{0.0122181611435997}*cell[18] + V{0.0122181611435997}*cell[1] + V{0.0122181611435997}*cell[2] + V{0.0122181611435997}*cell[3] + V{0.0122181611435997}*cell[4] + V{0.0122181611435997}*cell[5] + V{0.0122181611435997}*cell[6] + V{0.0122181611435997}*cell[7] + V{0.0122181611435997}*cell[8] + V{0.0122181611435997}*cell[9] + V{0.0122181611435997};
auto x216 = V{0.0237426900584795}*cell[11];
auto x217 = V{0.26374269005848}*cell[2];
auto x218 = V{0.0146523716699155}*cell[0] + V{0.0146523716699155}*cell[10] + V{0.0146523716699155}*cell[11] + V{0.0146523716699155}*cell[12] + V{0.0146523716699155}*cell[13] + V{0.0146523716699155}*cell[14] + V{0.0146523716699155}*cell[15] + V{0.0146523716699155}*cell[16] + V{0.0146523716699155}*cell[17] + V{0.0146523716699155}*cell[18] + V{0.0146523716699155}*cell[1] + V{0.0146523716699155}*cell[2] + V{0.0146523716699155}*cell[3] + V{0.0146523716699155}*cell[4] + V{0.0146523716699155}*cell[5] + V{0.0146523716699155}*cell[6] + V{0.0146523716699155}*cell[7] + V{0.0146523716699155}*cell[8] + V{0.0146523716699155}*cell[9] + V{0.0146523716699155};
auto x219 = x121*x218;
auto x220 = V{0.0013190383365822}*cell[0] + V{0.0013190383365822}*cell[10] + V{0.0013190383365822}*cell[11] + V{0.0013190383365822}*cell[12] + V{0.0013190383365822}*cell[13] + V{0.0013190383365822}*cell[14] + V{0.0013190383365822}*cell[15] + V{0.0013190383365822}*cell[16] + V{0.0013190383365822}*cell[17] + V{0.0013190383365822}*cell[18] + V{0.0013190383365822}*cell[1] + V{0.0013190383365822}*cell[2] + V{0.0013190383365822}*cell[3] + V{0.0013190383365822}*cell[4] + V{0.0013190383365822}*cell[5] + V{0.0013190383365822}*cell[6] + V{0.0013190383365822}*cell[7] + V{0.0013190383365822}*cell[8] + V{0.0013190383365822}*cell[9] + V{0.0013190383365822};
auto x221 = -x137*x220;
auto x222 = V{0.00599943144899285}*cell[0] + V{0.00599943144899285}*cell[10] + V{0.00599943144899285}*cell[11] + V{0.00599943144899285}*cell[12] + V{0.00599943144899285}*cell[13] + V{0.00599943144899285}*cell[14] + V{0.00599943144899285}*cell[15] + V{0.00599943144899285}*cell[16] + V{0.00599943144899285}*cell[17] + V{0.00599943144899285}*cell[18] + V{0.00599943144899285}*cell[1] + V{0.00599943144899285}*cell[2] + V{0.00599943144899285}*cell[3] + V{0.00599943144899285}*cell[4] + V{0.00599943144899285}*cell[5] + V{0.00599943144899285}*cell[6] + V{0.00599943144899285}*cell[7] + V{0.00599943144899285}*cell[8] + V{0.00599943144899285}*cell[9] + V{0.00599943144899285};
auto x223 = x136*x222 + x211*x97 - V{0.215979532163743}*cell[15] + V{0.219020467836257}*cell[6];
auto x224 = x216 + x217 + x219 + x221 + x223;
auto x225 = V{0.0526315789473684}*cell[0];
auto x226 = x68*(V{0.0175438596491228}*cell[0] + V{0.0175438596491228}*cell[10] + V{0.0175438596491228}*cell[11] + V{0.0175438596491228}*cell[12] + V{0.0175438596491228}*cell[13] + V{0.0175438596491228}*cell[14] + V{0.0175438596491228}*cell[15] + V{0.0175438596491228}*cell[16] + V{0.0175438596491228}*cell[17] + V{0.0175438596491228}*cell[18] + V{0.0175438596491228}*cell[1] + V{0.0175438596491228}*cell[2] + V{0.0175438596491228}*cell[3] + V{0.0175438596491228}*cell[4] + V{0.0175438596491228}*cell[5] + V{0.0175438596491228}*cell[6] + V{0.0175438596491228}*cell[7] + V{0.0175438596491228}*cell[8] + V{0.0175438596491228}*cell[9] + V{0.0175438596491228});
auto x227 = x225 + x226 + V{0.0270760233918129};
auto x228 = -x108*x222 - V{0.215979532163743}*cell[16] + V{0.219020467836257}*cell[7];
auto x229 = x133*x222 + x211*x70 - V{0.215979532163743}*cell[17] + V{0.219020467836257}*cell[8];
auto x230 = V{0.0237426900584795}*cell[10];
auto x231 = V{0.26374269005848}*cell[1];
auto x232 = x126*x218;
auto x233 = -x139*x220;
auto x234 = -x103*x222 - V{0.215979532163743}*cell[18] + V{0.219020467836257}*cell[9];
auto x235 = x230 + x231 + x232 + x233 + x234;
auto x236 = -V{0.0895906432748538}*cell[3];
auto x237 = -V{0.0895906432748538}*cell[12];
auto x238 = V{0.25}*x22;
auto x239 = x131 + x84;
auto x240 = x129 + x98;
auto x241 = -x171 - x172 + x174 + x175;
auto x242 = V{0.0049772579597141}*cell[0] + V{0.0049772579597141}*cell[10] + V{0.0049772579597141}*cell[11] + V{0.0049772579597141}*cell[12] + V{0.0049772579597141}*cell[13] + V{0.0049772579597141}*cell[14] + V{0.0049772579597141}*cell[15] + V{0.0049772579597141}*cell[16] + V{0.0049772579597141}*cell[17] + V{0.0049772579597141}*cell[18] + V{0.0049772579597141}*cell[1] + V{0.0049772579597141}*cell[2] + V{0.0049772579597141}*cell[3] + V{0.0049772579597141}*cell[4] + V{0.0049772579597141}*cell[5] + V{0.0049772579597141}*cell[6] + V{0.0049772579597141}*cell[7] + V{0.0049772579597141}*cell[8] + V{0.0049772579597141}*cell[9] + V{0.0049772579597141};
auto x243 = x138*x242;
auto x244 = -x124*x242;
auto x245 = x117*x163;
auto x246 = x169 + x245;
auto x247 = x114*x163 + x170;
auto x248 = x176 + x247;
auto x249 = -x196*(-x165*x83 + x187 + x246 + x248) - x202*(x204 - x245 + x248) + x236 + x237 + x238*(-x163*(x111 + x130 + x239) - x163*(x134 + x240 + x89) + x163*(x239 + x240 + x74) + x241) + x243 + x244;
auto x250 = x159*x211 + x228;
auto x251 = V{0.0237426900584795}*cell[2];
auto x252 = V{0.26374269005848}*cell[11];
auto x253 = x121*x220;
auto x254 = -x137*x218;
auto x255 = x223 + x251 + x252 + x253 + x254;
auto x256 = V{0.219020467836257}*cell[17];
auto x257 = -V{0.215979532163743}*cell[8];
auto x258 = -x197;
auto x259 = -x133*x211;
auto x260 = -x222*x70;
auto x261 = x256 + x257 + x258 + x259 + x260;
auto x262 = x206 + x236 + x237 - x238*(-x173 + x241 + x247) + x243 + x244;
auto x263 = V{0.219020467836257}*cell[18];
auto x264 = -V{0.215979532163743}*cell[9];
auto x265 = x103*x211;
auto x266 = -x162*x222 + x263 + x264 + x265;
auto x267 = x230 + x231 + x232 + x233 + x266;
auto x268 = x238*(x203 + x246);
auto x269 = V{0.0237426900584795}*cell[12];
auto x270 = V{0.26374269005848}*cell[3];
auto x271 = x124*x218;
auto x272 = -x138*x220;
auto x273 = x135*x222 + x211*x75 - V{0.215979532163743}*cell[13] + V{0.219020467836257}*cell[4];
auto x274 = x269 + x270 + x271 + x272 + x273;
auto x275 = x229 + x258;
auto x276 = -V{0.0895906432748538}*cell[2];
auto x277 = -V{0.0895906432748538}*cell[11];
auto x278 = x137*x242;
auto x279 = -x121*x242;
auto x280 = V{0.219020467836257}*cell[5];
auto x281 = -V{0.215979532163743}*cell[14];
auto x282 = x157*x211;
auto x283 = -x222*x91;
auto x284 = x227 + x280 + x281 + x282 + x283;
auto x285 = x205 + x276 + x277 + x278 + x279 + x284;
auto x286 = -x268;
auto x287 = V{0.0237426900584795}*cell[3];
auto x288 = V{0.26374269005848}*cell[12];
auto x289 = x124*x220;
auto x290 = -x138*x218;
auto x291 = x273 + x287 + x288 + x289 + x290;
auto x292 = x162*x211;
auto x293 = x261 + x292;
auto x294 = -x157*x222 + x211*x91 + V{0.219020467836257}*cell[14] - V{0.215979532163743}*cell[5];
auto x295 = x108*x211 + x225 + x226 + V{0.219020467836257}*cell[16] - V{0.215979532163743}*cell[7] + V{0.0270760233918129};
auto x296 = -x159*x222 + x295;
auto x297 = -V{0.0895906432748538}*cell[1];
auto x298 = -V{0.0895906432748538}*cell[10];
auto x299 = x238*(x103*x163 + x133*x163 - x163*x70 + x163*x83 - V{1}*cell[17] + V{1}*cell[18] - V{1}*cell[8] + V{1}*cell[9]);
auto x300 = x139*x242;
auto x301 = -x126*x242;
auto x302 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x303 = -x103*x302 - x162*x302 + x189 + x297 + x298 + x299 + x300 + x301 - V{0.115146198830409}*cell[18] - V{0.115146198830409}*cell[9];
auto x304 = x227 + x294;
auto x305 = -x136*x211 - x222*x97 + V{0.219020467836257}*cell[15] - V{0.215979532163743}*cell[6];
auto x306 = x216 + x217 + x219 + x221 + x305;
auto x307 = x133*x302 + x189 + x297 + x298 - x299 + x300 + x301 - x302*x70 - V{0.115146198830409}*cell[17] - V{0.115146198830409}*cell[8];
auto x308 = -x135*x146 + x142 + x143 + x148 + x149*x75 + x150 + V{0.26374269005848}*cell[13] + V{0.0237426900584795}*cell[4];
auto x309 = -x136*x146 + x149*x97 + x152 + x153 + x154 + x155 + V{0.26374269005848}*cell[15] + V{0.0237426900584795}*cell[6];
auto x310 = -x133*x146 + x144 + x145 + x149*x70 + x194 + x195 + x197 + x198 + x199 + V{0.26374269005848}*cell[17] + V{0.0237426900584795}*cell[8];
auto x311 = x251 + x252 + x253 + x254 + x305;
auto x312 = x126*x220 - x139*x218 + V{0.26374269005848}*cell[10] + V{0.0237426900584795}*cell[1];
auto x313 = x234 + x312;
auto x314 = -x135*x211 - x222*x75 + V{0.219020467836257}*cell[13] - V{0.215979532163743}*cell[4];
auto x315 = x287 + x288 + x289 + x290 + x314;
auto x316 = x205 + x276 + x277 + x278 + x279 + x304;
auto x317 = x269 + x270 + x271 + x272 + x314;
auto x0 = x103*x19 + x108*x19 + x114*x19 + x117*x19 + x118*x121 + x118*x124 + x118*x126 - x118*x137 - x118*x138 - x118*x139 - x133*x19 - x135*x19 - x136*x19 + x19*x70 + x19*x75 + x19*x83 + x19*x91 + x19*x97 - x68*(V{0.41578947368421}*cell[0] + V{0.41578947368421}*cell[10] + V{0.41578947368421}*cell[11] + V{0.41578947368421}*cell[12] + V{0.41578947368421}*cell[13] + V{0.41578947368421}*cell[14] + V{0.41578947368421}*cell[15] + V{0.41578947368421}*cell[16] + V{0.41578947368421}*cell[17] + V{0.41578947368421}*cell[18] + V{0.41578947368421}*cell[1] + V{0.41578947368421}*cell[2] + V{0.41578947368421}*cell[3] + V{0.41578947368421}*cell[4] + V{0.41578947368421}*cell[5] + V{0.41578947368421}*cell[6] + V{0.41578947368421}*cell[7] + V{0.41578947368421}*cell[8] + V{0.41578947368421}*cell[9] + V{0.41578947368421}) - V{0.247368421052631}*cell[0] + V{0.102631578947368}*cell[10] + V{0.102631578947368}*cell[11] + V{0.102631578947368}*cell[12] + V{0.0526315789473684}*cell[13] + V{0.0526315789473684}*cell[14] + V{0.0526315789473684}*cell[15] + V{0.0526315789473684}*cell[16] + V{0.0526315789473684}*cell[17] + V{0.0526315789473684}*cell[18] + V{0.102631578947368}*cell[1] + V{0.102631578947368}*cell[2] + V{0.102631578947368}*cell[3] + V{0.0526315789473684}*cell[4] + V{0.0526315789473684}*cell[5] + V{0.0526315789473684}*cell[6] + V{0.0526315789473684}*cell[7] + V{0.0526315789473684}*cell[8] + V{0.0526315789473684}*cell[9] + V{-0.364035087719298};
auto x1 = -x126*x141 - x139*x140 + x151 + x156 + x158 + x160 + x190 + V{0.0198538011695907}*cell[10] + V{0.0598538011695906}*cell[1] + V{0.00652046783625724};
auto x2 = -x121*x192 - x137*x191 + x151 + x193 + x200 + x201 + x207 + V{0.0198538011695907}*cell[11] + V{0.0598538011695907}*cell[2] + V{0.00652046783625724};
auto x3 = -x124*x192 - x138*x191 + x156 + x200 + x208 + x209 + x210 + V{0.0198538011695907}*cell[12] + V{0.0598538011695907}*cell[3];
auto x4 = -x114*x212 + x117*x211 - x135*x215 + x211*x83 - x213*x91 - x214*x75 + x224 + x227 + x228 + x229 + x235 + x249 + V{0.439853801169591}*cell[13] - V{0.115146198830409}*cell[14] + V{0.329853801169591}*cell[4] - V{0.115146198830409}*cell[5];
auto x5 = x135*x213 - x157*x214 - x212*x75 + x215*x91 + x227 + x250 + x255 + x261 + x262 + x267 - V{0.115146198830409}*cell[13] + V{0.439853801169591}*cell[14] - V{0.115146198830409}*cell[4] + V{0.329853801169591}*cell[5];
auto x6 = -x108*x213 - x136*x215 - x159*x212 - x214*x97 + x267 + x268 + x274 + x275 + x285 + V{0.439853801169591}*cell[15] - V{0.115146198830409}*cell[16] + V{0.329853801169591}*cell[6] - V{0.115146198830409}*cell[7];
auto x7 = x108*x215 + x136*x213 - x159*x214 - x212*x97 + x235 + x285 + x286 + x291 + x293 - V{0.115146198830409}*cell[15] + V{0.439853801169591}*cell[16] - V{0.115146198830409}*cell[6] + V{0.329853801169591}*cell[7];
auto x8 = -x133*x215 - x214*x70 + x224 + x274 + x294 + x296 + x303 + V{0.439853801169591}*cell[17] + V{0.329853801169591}*cell[8];
auto x9 = x103*x215 - x162*x214 + x250 + x291 + x304 + x306 + x307 + V{0.439853801169591}*cell[18] + V{0.329853801169591}*cell[9];
auto x10 = x126*x140 + x139*x141 + x190 + x193 + x208 + x308 + x309 + V{0.0598538011695906}*cell[10] + V{0.0198538011695907}*cell[1] + V{0.00652046783625723};
auto x11 = x121*x191 + x137*x192 + x158 + x207 + x209 + x308 + x310 + V{0.0598538011695907}*cell[11] + V{0.0198538011695907}*cell[2] + V{0.00652046783625723};
auto x12 = x124*x191 + x138*x192 + x160 + x201 + x210 + x309 + x310 + V{0.0598538011695907}*cell[12] + V{0.0198538011695907}*cell[3];
auto x13 = -x114*x213 - x117*x222 + x135*x214 - x212*x91 + x215*x75 - x222*x83 + x249 + x256 + x257 + x259 + x260 + x263 + x264 + x265 + x295 + x311 + x312 + V{0.329853801169591}*cell[13] - V{0.115146198830409}*cell[14] + V{0.439853801169591}*cell[4] - V{0.115146198830409}*cell[5];
auto x14 = x135*x212 + x157*x215 - x213*x75 - x214*x91 + x262 + x275 + x292 + x296 + x306 + x313 - V{0.115146198830409}*cell[13] + V{0.329853801169591}*cell[14] - V{0.115146198830409}*cell[4] + V{0.439853801169591}*cell[5];
auto x15 = -x108*x212 + x136*x214 - x159*x213 + x215*x97 + x268 + x293 + x313 + x315 + x316 + V{0.329853801169591}*cell[15] - V{0.115146198830409}*cell[16] + V{0.439853801169591}*cell[6] - V{0.115146198830409}*cell[7];
auto x16 = -x108*x214 + x136*x212 + x159*x215 - x213*x97 + x266 + x275 + x286 + x312 + x316 + x317 - V{0.115146198830409}*cell[15] + V{0.329853801169591}*cell[16] - V{0.115146198830409}*cell[6] + V{0.439853801169591}*cell[7];
auto x17 = x133*x214 + x215*x70 + x250 + x284 + x303 + x311 + x315 + V{0.329853801169591}*cell[17] + V{0.439853801169591}*cell[8];
auto x18 = -x103*x214 + x162*x215 + x255 + x280 + x281 + x282 + x283 + x296 + x307 + x317 + V{0.329853801169591}*cell[18] + V{0.439853801169591}*cell[9];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
cell[7] = x7;
cell[8] = x8;
cell[9] = x9;
cell[10] = x10;
cell[11] = x11;
cell[12] = x12;
cell[13] = x13;
cell[14] = x14;
cell[15] = x15;
cell[16] = x16;
cell[17] = x17;
cell[18] = x18;
return { x21, V{1}*x31*(x53 + x60 + x65) };
}

};


}

namespace forcing {

template <typename... FIELDS>
struct forcing::LaddVerberg::combined_collision<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder,collision::MRT> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x6 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x5 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x8 = V{0.05}*cell[0] + V{0.05}*cell[1] + V{0.05}*cell[2] + V{0.05}*cell[3] + V{0.05}*cell[4] + V{0.05};
auto x9 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4];
auto x10 = x9 + V{1};
auto x11 = V{1} / (x10);
auto x12 = V{3}*cell[4];
auto x13 = V{3}*cell[2];
auto x14 = V{1} / ((x10)*(x10));
auto x15 = V{3}*x14;
auto x16 = -cell[2] + cell[4];
auto x17 = x16*x16;
auto x18 = V{1.5}*x14;
auto x19 = -cell[1] + cell[3];
auto x20 = x18*(x19*x19) + V{-1};
auto x21 = x11*(x12 - x13) - x15*x17 + x20;
auto x22 = x11*(V{3}*cell[1] - V{3}*cell[3]);
auto x23 = cell[1] - cell[3];
auto x24 = x23*x23;
auto x25 = cell[2] - cell[4];
auto x26 = x25*x25;
auto x27 = x18*x26;
auto x28 = x15*x24 - x27 + V{1};
auto x29 = x22 + x28;
auto x30 = -x22 + x28;
auto x31 = x11*(-x12 + x13);
auto x32 = -x31;
auto x33 = x15*x26;
auto x34 = x18*x24;
auto x35 = x32 + x33 - x34 + V{1};
auto x36 = x9 + V{1};
auto x37 = x11*x36;
auto x38 = V{0.5}*x36;
auto x39 = x38*x5;
auto x40 = V{0.5}*x7;
auto x41 = V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667};
auto x42 = x40*(-x29*x41 + x30*x41 + V{1}*cell[1] - V{1}*cell[3]);
auto x43 = V{0.075}*cell[0] + V{0.075}*cell[1] + V{0.075}*cell[2] + V{0.075}*cell[3] + V{0.075}*cell[4] + V{0.075};
auto x44 = V{0.05}*cell[0] + V{0.05}*cell[1] + V{0.05}*cell[2] + V{0.05}*cell[3] + V{0.05}*cell[4] + V{0.05};
auto x45 = x34 + V{-1};
auto x46 = -x33 + x45;
auto x47 = x31 + x46;
auto x48 = x32 + x46;
auto x49 = x23*x5;
auto x50 = x25*x6;
auto x51 = V{2}*x49 - V{1}*x50;
auto x52 = x11*x38;
auto x53 = V{0.25}*x37*(x40 + V{0.45});
auto x54 = (x27 + x45)*(V{0.1}*cell[0] + V{0.1}*cell[1] + V{0.1}*cell[2] + V{0.1}*cell[3] + V{0.1}*cell[4] + V{0.1}) + V{0.3}*cell[0] + V{0.05};
auto x55 = x29*x43 + x30*x43 + x44*x47 + x44*x48 - x51*x52 + x51*x53 + x54 + V{0.3}*cell[2] + V{0.3}*cell[4];
auto x56 = x38*x6;
auto x57 = x40*(x21*x41 + x35*x41 + V{1}*cell[2] - V{1}*cell[4]);
auto x58 = -V{1}*x49 + V{2}*x50;
auto x59 = -x29*x44 - x30*x44 - x43*x47 - x43*x48 - x52*x58 + x53*x58 + x54 + V{0.3}*cell[1] + V{0.3}*cell[3];
auto x0 = x21*x8 - x29*x8 - x30*x8 - x35*x8 - V{0.4}*x37*(x16*x6 + x19*x5) - (x17*x18 + x20)*(V{0.4}*cell[0] + V{0.4}*cell[1] + V{0.4}*cell[2] + V{0.4}*cell[3] + V{0.4}*cell[4] + V{0.4}) - V{0.2}*cell[0] + V{0.3}*cell[1] + V{0.3}*cell[2] + V{0.3}*cell[3] + V{0.3}*cell[4] + V{-0.2};
auto x1 = -x39 - x42 + x55 + V{0.55}*cell[1] - V{0.45}*cell[3];
auto x2 = -x56 - x57 + x59 + V{0.55}*cell[2] - V{0.45}*cell[4];
auto x3 = x39 + x42 + x55 - V{0.45}*cell[1] + V{0.55}*cell[3];
auto x4 = x56 + x57 + x59 - V{0.45}*cell[2] + V{0.55}*cell[4];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
return { x10, V{1}*x14*(x24 + x26) };
}

};

template <typename... FIELDS>
struct forcing::LaddVerberg::combined_collision<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder,collision::MRT> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x9 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x10 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x12 = V{0.00339506172839506}*cell[0] + V{0.00339506172839506}*cell[1] + V{0.00339506172839506}*cell[2] + V{0.00339506172839506}*cell[3] + V{0.00339506172839506}*cell[4] + V{0.00339506172839506}*cell[5] + V{0.00339506172839506}*cell[6] + V{0.00339506172839506}*cell[7] + V{0.00339506172839506}*cell[8] + V{0.00339506172839506};
auto x13 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8];
auto x14 = x13 + V{1};
auto x15 = V{1} / (x14);
auto x16 = V{3}*cell[2];
auto x17 = V{3}*cell[3];
auto x18 = V{3}*cell[6];
auto x19 = V{3}*cell[7];
auto x20 = V{3}*cell[1];
auto x21 = V{3}*cell[5];
auto x22 = x20 - x21;
auto x23 = x15*(x16 + x17 - x18 - x19 + x22);
auto x24 = V{1} / ((x14)*(x14));
auto x25 = V{4.5}*x24;
auto x26 = V{2}*cell[5];
auto x27 = V{2}*cell[1];
auto x28 = -cell[4] + cell[8];
auto x29 = cell[2] - cell[6];
auto x30 = -x26 + x27 + x28 + x29;
auto x31 = x25*(x30*x30);
auto x32 = -x17 + x19;
auto x33 = x15*(x22 + x32 - V{3}*cell[4] + V{3}*cell[8]);
auto x34 = V{1.5}*x24;
auto x35 = cell[1] - cell[5];
auto x36 = x29 + x35 + cell[3] - cell[7];
auto x37 = x36*x36;
auto x38 = x34*x37;
auto x39 = -cell[3] + cell[7];
auto x40 = x28 + x35 + x39;
auto x41 = x40*x40;
auto x42 = x34*x41;
auto x43 = x42 + V{-1};
auto x44 = x38 + x43;
auto x45 = x33 + x44;
auto x46 = x23 - x31 + x45;
auto x47 = -x23;
auto x48 = V{2}*cell[3];
auto x49 = V{2}*cell[7];
auto x50 = -cell[2] + cell[6];
auto x51 = x28 - x48 + x49 + x50;
auto x52 = x25*(x51*x51);
auto x53 = -x52;
auto x54 = x45 + x47 + x53;
auto x55 = V{0.0135802469135802}*cell[0] + V{0.0135802469135802}*cell[1] + V{0.0135802469135802}*cell[2] + V{0.0135802469135802}*cell[3] + V{0.0135802469135802}*cell[4] + V{0.0135802469135802}*cell[5] + V{0.0135802469135802}*cell[6] + V{0.0135802469135802}*cell[7] + V{0.0135802469135802}*cell[8] + V{0.0135802469135802};
auto x56 = V{3}*x24;
auto x57 = x41*x56;
auto x58 = x33 - x57 + V{-1};
auto x59 = x38 + x58;
auto x60 = V{1} - x42;
auto x61 = -x38;
auto x62 = x33 + x61;
auto x63 = x60 + x62;
auto x64 = x23 + x63;
auto x65 = x31 + x64;
auto x66 = cell[4] - cell[8];
auto x67 = x29 + x48 - x49 + x66;
auto x68 = x47 + x63;
auto x69 = x25*(x67*x67) + x68;
auto x70 = x37*x56 + x60;
auto x71 = x23 + x70;
auto x72 = x57 + x62 + V{1};
auto x73 = x47 + x70;
auto x74 = x10*x40;
auto x75 = x36*x9;
auto x76 = x13 + V{1};
auto x77 = x15*x76;
auto x78 = V{0.000848765432098765}*cell[0] + V{0.000848765432098765}*cell[1] + V{0.000848765432098765}*cell[2] + V{0.000848765432098765}*cell[3] + V{0.000848765432098765}*cell[4] + V{0.000848765432098765}*cell[5] + V{0.000848765432098765}*cell[6] + V{0.000848765432098765}*cell[7] + V{0.000848765432098765}*cell[8] + V{0.000848765432098765};
auto x79 = V{0.00933641975308642}*cell[0] + V{0.00933641975308642}*cell[1] + V{0.00933641975308642}*cell[2] + V{0.00933641975308642}*cell[3] + V{0.00933641975308642}*cell[4] + V{0.00933641975308642}*cell[5] + V{0.00933641975308642}*cell[6] + V{0.00933641975308642}*cell[7] + V{0.00933641975308642}*cell[8] + V{0.00933641975308642};
auto x80 = x10 - x9;
auto x81 = V{0.0833333333333333}*x76;
auto x82 = x80*x81;
auto x83 = x26 - x27 + x50 + x66;
auto x84 = V{3}*x80;
auto x85 = V{1}*x74;
auto x86 = V{1}*x75;
auto x87 = x85 - x86;
auto x88 = x83*x84 + x87;
auto x89 = x15*x81;
auto x90 = V{0.25}*x11;
auto x91 = V{0.0416666666666667}*x77*(x90 + V{0.336111111111111});
auto x92 = V{0.00679012345679012}*cell[0] + V{0.00679012345679012}*cell[1] + V{0.00679012345679012}*cell[2] + V{0.00679012345679012}*cell[3] + V{0.00679012345679012}*cell[4] + V{0.00679012345679012}*cell[5] + V{0.00679012345679012}*cell[6] + V{0.00679012345679012}*cell[7] + V{0.00679012345679012}*cell[8] + V{0.00679012345679012};
auto x93 = V{0.0339506172839506}*cell[0] + V{0.0339506172839506}*cell[1] + V{0.0339506172839506}*cell[2] + V{0.0339506172839506}*cell[3] + V{0.0339506172839506}*cell[4] + V{0.0339506172839506}*cell[5] + V{0.0339506172839506}*cell[6] + V{0.0339506172839506}*cell[7] + V{0.0339506172839506}*cell[8] + V{0.0339506172839506};
auto x94 = V{0.122222222222222}*cell[0];
auto x95 = V{0.054320987654321}*cell[0] + V{0.054320987654321}*cell[1] + V{0.054320987654321}*cell[2] + V{0.054320987654321}*cell[3] + V{0.054320987654321}*cell[4] + V{0.054320987654321}*cell[5] + V{0.054320987654321}*cell[6] + V{0.054320987654321}*cell[7] + V{0.054320987654321}*cell[8] + V{0.054320987654321};
auto x96 = x44*x95 + x94;
auto x97 = -x71*x93 + x73*x92 + x96 + V{0.305555555555556}*cell[2] - V{0.0611111111111111}*cell[6] + V{0.0916666666666667};
auto x98 = -x59*x92 - x72*x93 - V{0.0611111111111111}*cell[4] + V{0.305555555555556}*cell[8];
auto x99 = V{0.00424382716049383}*cell[0] + V{0.00424382716049383}*cell[1] + V{0.00424382716049383}*cell[2] + V{0.00424382716049383}*cell[3] + V{0.00424382716049383}*cell[4] + V{0.00424382716049383}*cell[5] + V{0.00424382716049383}*cell[6] + V{0.00424382716049383}*cell[7] + V{0.00424382716049383}*cell[8] + V{0.00424382716049383};
auto x100 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x101 = x52 + x68;
auto x102 = x25*(x83*x83) + x64;
auto x103 = x31 - x33 + x47 + x60 + x61;
auto x104 = x39 + x50 - cell[1] + cell[5];
auto x105 = x34*(x104*x104);
auto x106 = x105 + x43;
auto x107 = x106 + x15*(-x16 + x18 - x20 + x21 + x32) + x33 + x53;
auto x108 = x90*(x100*x101 - x100*x102 - x100*x103 - x100*x107 + V{1}*cell[1] - V{1}*cell[3] + V{1}*cell[5] - V{1}*cell[7]);
auto x109 = -x108 - x54*x99 + x69*x99 - V{0.152777777777778}*cell[3] - V{0.152777777777778}*cell[7];
auto x110 = V{0.00848765432098765}*cell[0] + V{0.00848765432098765}*cell[1] + V{0.00848765432098765}*cell[2] + V{0.00848765432098765}*cell[3] + V{0.00848765432098765}*cell[4] + V{0.00848765432098765}*cell[5] + V{0.00848765432098765}*cell[6] + V{0.00848765432098765}*cell[7] + V{0.00848765432098765}*cell[8] + V{0.00848765432098765};
auto x111 = V{0.00169753086419753}*cell[0] + V{0.00169753086419753}*cell[1] + V{0.00169753086419753}*cell[2] + V{0.00169753086419753}*cell[3] + V{0.00169753086419753}*cell[4] + V{0.00169753086419753}*cell[5] + V{0.00169753086419753}*cell[6] + V{0.00169753086419753}*cell[7] + V{0.00169753086419753}*cell[8] + V{0.00169753086419753};
auto x112 = V{0.0577160493827161}*cell[0] + V{0.0577160493827161}*cell[1] + V{0.0577160493827161}*cell[2] + V{0.0577160493827161}*cell[3] + V{0.0577160493827161}*cell[4] + V{0.0577160493827161}*cell[5] + V{0.0577160493827161}*cell[6] + V{0.0577160493827161}*cell[7] + V{0.0577160493827161}*cell[8] + V{0.0577160493827161};
auto x113 = V{0.333333333333333}*x76;
auto x114 = x113*x9;
auto x115 = V{0.0237654320987654}*cell[0] + V{0.0237654320987654}*cell[1] + V{0.0237654320987654}*cell[2] + V{0.0237654320987654}*cell[3] + V{0.0237654320987654}*cell[4] + V{0.0237654320987654}*cell[5] + V{0.0237654320987654}*cell[6] + V{0.0237654320987654}*cell[7] + V{0.0237654320987654}*cell[8] + V{0.0237654320987654};
auto x116 = V{0.305555555555556}*cell[3] - V{0.0611111111111111}*cell[7];
auto x117 = V{0.305555555555556}*cell[1] - V{0.0611111111111111}*cell[5];
auto x118 = V{0.0169753086419753}*cell[0] + V{0.0169753086419753}*cell[1] + V{0.0169753086419753}*cell[2] + V{0.0169753086419753}*cell[3] + V{0.0169753086419753}*cell[4] + V{0.0169753086419753}*cell[5] + V{0.0169753086419753}*cell[6] + V{0.0169753086419753}*cell[7] + V{0.0169753086419753}*cell[8] + V{0.0169753086419753};
auto x119 = V{1}*cell[2];
auto x120 = V{1}*cell[6];
auto x121 = V{1}*cell[4];
auto x122 = V{1}*cell[8];
auto x123 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x124 = x123*x72;
auto x125 = x123*x71;
auto x126 = x123*x73;
auto x127 = x105 + x58;
auto x128 = x123*x127;
auto x129 = -V{2}*x104*x9 + x85;
auto x130 = x113*x15;
auto x131 = V{0.166666666666667}*x77*(x90 + V{0.519444444444444});
auto x132 = x106*x95 - x118*x127 + x118*x72 - x129*x130 + x129*x131 - x90*(x119 + x120 - x121 - x122 + x124 - x125 - x126 - x128) + x94 - V{0.152777777777778}*cell[4] - V{0.152777777777778}*cell[8];
auto x133 = x10 + x9;
auto x134 = x133*x81;
auto x135 = x59*x93 + x72*x92 + V{0.305555555555556}*cell[4] - V{0.0611111111111111}*cell[8];
auto x136 = -V{3}*x133*x51 + x87;
auto x137 = x108 - x136*x89 + x136*x91 - x46*x99 + x65*x99 - V{0.152777777777778}*cell[1] - V{0.152777777777778}*cell[5];
auto x138 = x10*x113;
auto x139 = -V{0.0611111111111111}*cell[1] + V{0.305555555555556}*cell[5];
auto x140 = V{2}*x74 + x86;
auto x141 = x118*x71 + x118*x73 + x130*x140 - x131*x140 - x90*(-x119 - x120 + x121 + x122 - x124 + x125 + x126 + x128) + x96 - V{0.152777777777778}*cell[2] - V{0.152777777777778}*cell[6] + V{-4.85722573273506e-17};
auto x142 = -x30*x84 + x87;
auto x143 = x71*x92 - x73*x93 + x96 - V{0.0611111111111111}*cell[2] + V{0.305555555555556}*cell[6] + V{0.0916666666666667};
auto x144 = -V{0.0611111111111111}*cell[3] + V{0.305555555555556}*cell[7];
auto x0 = x12*x46 + x12*x54 - x12*x65 - x12*x69 - x44*(V{0.434567901234568}*cell[0] + V{0.434567901234568}*cell[1] + V{0.434567901234568}*cell[2] + V{0.434567901234568}*cell[3] + V{0.434567901234568}*cell[4] + V{0.434567901234568}*cell[5] + V{0.434567901234568}*cell[6] + V{0.434567901234568}*cell[7] + V{0.434567901234568}*cell[8] + V{0.434567901234568}) + x55*x59 - x55*x71 - x55*x72 - x55*x73 - V{0.681481481481481}*x77*(x74 - x75) + V{0.0222222222222221}*cell[0] + V{0.122222222222222}*cell[1] + V{0.122222222222222}*cell[2] + V{0.122222222222222}*cell[3] + V{0.122222222222222}*cell[4] + V{0.122222222222222}*cell[5] + V{0.122222222222222}*cell[6] + V{0.122222222222222}*cell[7] + V{0.122222222222222}*cell[8] + V{-0.366666666666667};
auto x1 = x109 + x46*x78 + x65*x79 + x82 - x88*x89 + x88*x91 + x97 + x98 + V{0.663888888888889}*cell[1] + V{0.0305555555555556}*cell[5];
auto x2 = x101*x111 - x102*x110 + x103*x111 + x107*x110 + x112*x71 - x114 - x115*x73 + x116 + x117 + x132 + V{0.480555555555556}*cell[2] + V{0.213888888888889}*cell[6] + V{-4.60279962292513e-17};
auto x3 = -x134 + x135 + x137 - x54*x79 - x69*x78 + x97 + V{0.663888888888889}*cell[3] + V{0.0305555555555556}*cell[7];
auto x4 = x110*x46 + x110*x54 + x111*x65 + x111*x69 - x112*x59 - x115*x72 + x116 - x138 + x139 + x141 + V{0.480555555555556}*cell[4] + V{0.213888888888889}*cell[8];
auto x5 = x109 + x135 - x142*x89 + x142*x91 + x143 - x46*x79 - x65*x78 - x82 + V{0.0305555555555556}*cell[1] + V{0.663888888888889}*cell[5];
auto x6 = -x101*x110 + x102*x111 - x103*x110 - x107*x111 + x112*x73 + x114 - x115*x71 + x132 + x139 + x144 + V{0.213888888888889}*cell[2] + V{0.480555555555556}*cell[6] + V{-5.11165184254499e-17};
auto x7 = x134 + x137 + x143 + x54*x78 + x69*x79 + x98 + V{0.0305555555555556}*cell[3] + V{0.663888888888889}*cell[7];
auto x8 = -x110*x65 - x110*x69 - x111*x46 - x111*x54 + x112*x72 + x115*x59 + x117 + x138 + x141 + x144 + V{0.213888888888889}*cell[4] + V{0.480555555555556}*cell[8];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
cell[7] = x7;
cell[8] = x8;
return { x14, V{1}*x24*(x37 + x41) };
}

};

template <typename... FIELDS>
struct forcing::LaddVerberg::combined_collision<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder,collision::MRT> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x9 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x8 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x7 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x11 = V{0.0339285714285714}*cell[0] + V{0.0339285714285714}*cell[1] + V{0.0339285714285714}*cell[2] + V{0.0339285714285714}*cell[3] + V{0.0339285714285714}*cell[4] + V{0.0339285714285714}*cell[5] + V{0.0339285714285714}*cell[6] + V{0.0339285714285714};
auto x12 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6];
auto x13 = x12 + V{1};
auto x14 = V{1} / (x13);
auto x15 = V{4}*cell[4];
auto x16 = V{4}*cell[1];
auto x17 = V{1} / ((x13)*(x13));
auto x18 = V{6}*x17;
auto x19 = -cell[1] + cell[4];
auto x20 = x19*x19;
auto x21 = V{2}*x17;
auto x22 = -cell[2] + cell[5];
auto x23 = x22*x22;
auto x24 = x21*x23;
auto x25 = -cell[3] + cell[6];
auto x26 = x25*x25;
auto x27 = x21*x26;
auto x28 = x24 + x27 + V{-1};
auto x29 = x14*(x15 - x16) - x18*x20 + x28;
auto x30 = V{4}*cell[5];
auto x31 = V{4}*cell[2];
auto x32 = x20*x21;
auto x33 = x32 + V{-1};
auto x34 = x14*(x30 - x31) - x18*x23 + x27 + x33;
auto x35 = V{4}*cell[6];
auto x36 = V{4}*cell[3];
auto x37 = x14*(x35 - x36) - x18*x26 + x24 + x33;
auto x38 = x14*(-x15 + x16);
auto x39 = -x38;
auto x40 = cell[1] - cell[4];
auto x41 = x40*x40;
auto x42 = x18*x41;
auto x43 = cell[2] - cell[5];
auto x44 = x43*x43;
auto x45 = x21*x44;
auto x46 = -x45;
auto x47 = cell[3] - cell[6];
auto x48 = x47*x47;
auto x49 = x21*x48;
auto x50 = V{1} - x49;
auto x51 = x39 + x42 + x46 + x50;
auto x52 = x14*(-x30 + x31);
auto x53 = -x52;
auto x54 = x18*x44;
auto x55 = x21*x41;
auto x56 = -x55;
auto x57 = x50 + x53 + x54 + x56;
auto x58 = x14*(-x35 + x36);
auto x59 = -x58;
auto x60 = x18*x48;
auto x61 = x46 + x56 + x59 + x60 + V{1};
auto x62 = x12 + V{1};
auto x63 = x14*x62;
auto x64 = V{0.271428571428571}*cell[2];
auto x65 = V{0.271428571428571}*cell[3];
auto x66 = V{0.271428571428571}*cell[5];
auto x67 = V{0.271428571428571}*cell[6];
auto x68 = x64 + x65 + x66 + x67;
auto x69 = V{0.271428571428571}*cell[1] + V{0.271428571428571}*cell[4];
auto x70 = V{0.5}*x10;
auto x71 = V{0.125}*cell[0] + V{0.125}*cell[1] + V{0.125}*cell[2] + V{0.125}*cell[3] + V{0.125}*cell[4] + V{0.125}*cell[5] + V{0.125}*cell[6] + V{0.125};
auto x72 = x70*(x29*x71 + x51*x71 + V{1}*cell[1] - V{1}*cell[4]);
auto x73 = V{0.5}*x62;
auto x74 = x7*x73;
auto x75 = V{0.0848214285714286}*cell[0] + V{0.0848214285714286}*cell[1] + V{0.0848214285714286}*cell[2] + V{0.0848214285714286}*cell[3] + V{0.0848214285714286}*cell[4] + V{0.0848214285714286}*cell[5] + V{0.0848214285714286}*cell[6] + V{0.0848214285714286};
auto x76 = x45 + V{-1};
auto x77 = -x42 + x49 + x76;
auto x78 = x38 + x77;
auto x79 = x39 + x77;
auto x80 = x40*x7;
auto x81 = x43*x8;
auto x82 = -V{1}*x81;
auto x83 = x47*x9;
auto x84 = -V{1}*x83;
auto x85 = V{3}*x80 + x82 + x84;
auto x86 = x14*x73;
auto x87 = V{0.25}*x63;
auto x88 = V{0.271428571428571}*cell[0];
auto x89 = x49 + x55 + V{-1};
auto x90 = (x45 + x89)*(V{0.0678571428571428}*cell[0] + V{0.0678571428571428}*cell[1] + V{0.0678571428571428}*cell[2] + V{0.0678571428571428}*cell[3] + V{0.0678571428571428}*cell[4] + V{0.0678571428571428}*cell[5] + V{0.0678571428571428}*cell[6] + V{0.0678571428571428});
auto x91 = x55 - x60 + x76;
auto x92 = x58 + x91;
auto x93 = x59 + x91;
auto x94 = x11*x92 + x11*x93 + x88 + x90 + V{0.0339285714285714};
auto x95 = -x54 + x89;
auto x96 = x52 + x95;
auto x97 = x53 + x95;
auto x98 = x11*x96 + x11*x97;
auto x99 = x68 - x75*x78 - x75*x79 - x85*x86 + x85*x87*(x70 + V{0.678571428571428}) + x94 + x98;
auto x100 = x70*(x34*x71 + x57*x71 + V{1}*cell[2] - V{1}*cell[5]);
auto x101 = x73*x8;
auto x102 = V{0.0848214285714286}*cell[0] + V{0.0848214285714286}*cell[1] + V{0.0848214285714286}*cell[2] + V{0.0848214285714286}*cell[3] + V{0.0848214285714286}*cell[4] + V{0.0848214285714286}*cell[5] + V{0.0848214285714286}*cell[6] + V{0.0848214285714286};
auto x103 = -V{1}*x80;
auto x104 = x103 + V{3}*x81 + x84;
auto x105 = x87*(x70 + V{0.678571428571429});
auto x106 = x11*x78 + x11*x79 + x69;
auto x107 = -x102*x96 - x102*x97 + x104*x105 - x104*x86 + x106 + x65 + x67 + x94;
auto x108 = x70*(x37*x71 + x61*x71 + V{1}*cell[3] - V{1}*cell[6]);
auto x109 = x73*x9;
auto x110 = x103 + x82 + V{3}*x83;
auto x111 = -x102*x92 - x102*x93 + x105*x110 + x106 - x110*x86 + x64 + x66 + x88 + x90 + x98 + V{0.0339285714285714};
auto x0 = x11*x29 + x11*x34 + x11*x37 - x11*x51 - x11*x57 - x11*x61 - V{0.185714285714286}*x63*(x19*x7 + x22*x8 + x25*x9) + x68 + x69 - (x28 + x32)*(V{0.407142857142857}*cell[0] + V{0.407142857142857}*cell[1] + V{0.407142857142857}*cell[2] + V{0.407142857142857}*cell[3] + V{0.407142857142857}*cell[4] + V{0.407142857142857}*cell[5] + V{0.407142857142857}*cell[6] + V{0.407142857142857}) - V{0.628571428571429}*cell[0] + V{-0.203571428571429};
auto x1 = -x72 - x74 + x99 + V{0.321428571428572}*cell[1] - V{0.678571428571428}*cell[4];
auto x2 = -x100 - x101 + x107 + V{0.321428571428571}*cell[2] - V{0.678571428571429}*cell[5];
auto x3 = -x108 - x109 + x111 + V{0.321428571428571}*cell[3] - V{0.678571428571429}*cell[6];
auto x4 = x72 + x74 + x99 - V{0.678571428571428}*cell[1] + V{0.321428571428572}*cell[4];
auto x5 = x100 + x101 + x107 - V{0.678571428571429}*cell[2] + V{0.321428571428571}*cell[5];
auto x6 = x108 + x109 + x111 - V{0.678571428571429}*cell[3] + V{0.321428571428571}*cell[6];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
return { x13, V{1}*x17*(x41 + x44 + x48) };
}

};

template <typename... FIELDS>
struct forcing::LaddVerberg::combined_collision<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder,collision::MRT> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x19 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x20 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x23 = V{0.00146198830409357}*cell[0] + V{0.00146198830409357}*cell[10] + V{0.00146198830409357}*cell[11] + V{0.00146198830409357}*cell[12] + V{0.00146198830409357}*cell[13] + V{0.00146198830409357}*cell[14] + V{0.00146198830409357}*cell[15] + V{0.00146198830409357}*cell[16] + V{0.00146198830409357}*cell[17] + V{0.00146198830409357}*cell[18] + V{0.00146198830409357}*cell[1] + V{0.00146198830409357}*cell[2] + V{0.00146198830409357}*cell[3] + V{0.00146198830409357}*cell[4] + V{0.00146198830409357}*cell[5] + V{0.00146198830409357}*cell[6] + V{0.00146198830409357}*cell[7] + V{0.00146198830409357}*cell[8] + V{0.00146198830409357}*cell[9] + V{0.00146198830409357};
auto x24 = cell[10] + cell[12];
auto x25 = x24 + cell[0] + cell[11] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x26 = x25 + V{1};
auto x27 = V{1} / (x26);
auto x28 = V{3}*cell[7];
auto x29 = V{3}*cell[9];
auto x30 = V{3}*cell[16];
auto x31 = V{3}*cell[18];
auto x32 = V{3}*cell[17] - V{3}*cell[8];
auto x33 = V{3}*cell[15] - V{3}*cell[6];
auto x34 = x27*(x28 + x29 - x30 - x31 + x32 + x33 + V{3}*cell[12] - V{3}*cell[3]);
auto x35 = V{1} / ((x26)*(x26));
auto x36 = V{4.5}*x35;
auto x37 = cell[13] - cell[4];
auto x38 = cell[15] - cell[6];
auto x39 = x37 + x38;
auto x40 = -cell[2];
auto x41 = -cell[14];
auto x42 = x40 + x41 + cell[11] + cell[5];
auto x43 = -cell[3];
auto x44 = -cell[16] + cell[7];
auto x45 = x43 + x44 + cell[12];
auto x46 = x39 + x42 + x45 + V{2}*cell[17] - V{2}*cell[8];
auto x47 = x36*(x46*x46);
auto x48 = V{3}*cell[5];
auto x49 = V{3}*cell[14];
auto x50 = V{3}*cell[13] - V{3}*cell[4];
auto x51 = x27*(-x29 + x31 + x32 + x48 - x49 + x50 + V{3}*cell[11] - V{3}*cell[2]);
auto x52 = V{1.5}*x35;
auto x53 = cell[17] - cell[8];
auto x54 = x37 + x53;
auto x55 = cell[18] - cell[9];
auto x56 = x42 + x54 + x55;
auto x57 = x56*x56;
auto x58 = x52*x57;
auto x59 = cell[14] - cell[5];
auto x60 = -cell[1];
auto x61 = cell[16] - cell[7];
auto x62 = x60 + x61 + cell[10];
auto x63 = x39 + x59 + x62;
auto x64 = x63*x63;
auto x65 = x52*x64;
auto x66 = x38 + x53;
auto x67 = -cell[18] + cell[9];
auto x68 = x45 + x66 + x67;
auto x69 = x68*x68;
auto x70 = x52*x69;
auto x71 = x65 + x70 + V{-1};
auto x72 = x58 + x71;
auto x73 = x51 + x72;
auto x74 = x34 - x47 + x73;
auto x75 = x27*(-x28 + x30 + x33 - x48 + x49 + x50 + V{3}*cell[10] - V{3}*cell[1]);
auto x76 = x40 + x55 + cell[11];
auto x77 = x62 + x66 + x76 + V{2}*cell[13] - V{2}*cell[4];
auto x78 = x36*(x77*x77);
auto x79 = x73 + x75 - x78;
auto x80 = V{2}*cell[18];
auto x81 = V{2}*cell[9];
auto x82 = -cell[13] + cell[4];
auto x83 = x38 - cell[11] + cell[2];
auto x84 = x45 + x59 - x80 + x81 + x82 + x83;
auto x85 = -x34;
auto x86 = x73 + x85;
auto x87 = -x36*x84*x84 + x86;
auto x88 = -x75;
auto x89 = V{2}*cell[5];
auto x90 = V{2}*cell[14];
auto x91 = -cell[17] + cell[8];
auto x92 = x62 + x67 + x83 - x89 + x90 + x91;
auto x93 = x36*(x92*x92);
auto x94 = -x93;
auto x95 = x73 + x88 + x94;
auto x96 = x59 + x60;
auto x97 = x43 + x67;
auto x98 = x24 + x54 + x96 + x97 + V{2}*cell[15] - V{2}*cell[6];
auto x99 = x36*(x98*x98);
auto x100 = x34 + x72;
auto x101 = x100 + x75 - x99;
auto x102 = -x51;
auto x103 = -cell[15] + cell[6];
auto x104 = x37 - cell[12] + cell[3];
auto x105 = x103 + x104 + x42 + x61 + x80 - x81;
auto x106 = -x36*x105*x105;
auto x107 = x100 + x102 + x106;
auto x108 = V{2}*cell[7];
auto x109 = V{2}*cell[16];
auto x110 = x104 - x108 + x109 + x55 + x91 + x96 + cell[10];
auto x111 = -x36*x110*x110;
auto x112 = x100 + x111 + x88;
auto x113 = x53 - cell[10] + cell[1];
auto x114 = x103 + x113 + x44 + x76 + x89 - x90;
auto x115 = x36*(x114*x114);
auto x116 = x72 + x75;
auto x117 = x102 + x116;
auto x118 = -x115 + x117;
auto x119 = x108 - x109 + x113 + x41 + x82 + x97 + cell[12] + cell[5];
auto x120 = x116 + x85;
auto x121 = x120 - x36*x119*x119;
auto x122 = V{0.00570175438596491}*cell[0] + V{0.00570175438596491}*cell[10] + V{0.00570175438596491}*cell[11] + V{0.00570175438596491}*cell[12] + V{0.00570175438596491}*cell[13] + V{0.00570175438596491}*cell[14] + V{0.00570175438596491}*cell[15] + V{0.00570175438596491}*cell[16] + V{0.00570175438596491}*cell[17] + V{0.00570175438596491}*cell[18] + V{0.00570175438596491}*cell[1] + V{0.00570175438596491}*cell[2] + V{0.00570175438596491}*cell[3] + V{0.00570175438596491}*cell[4] + V{0.00570175438596491}*cell[5] + V{0.00570175438596491}*cell[6] + V{0.00570175438596491}*cell[7] + V{0.00570175438596491}*cell[8] + V{0.00570175438596491}*cell[9] + V{0.00570175438596491};
auto x123 = V{3}*x35;
auto x124 = x123*x57;
auto x125 = -x124 + x51 + x71;
auto x126 = x123*x69;
auto x127 = x58 + V{-1};
auto x128 = -x126 + x127 + x34 + x65;
auto x129 = x123*x64;
auto x130 = x127 - x129 + x70 + x75;
auto x131 = -x70;
auto x132 = V{1} - x65;
auto x133 = x131 + x132;
auto x134 = x133 + x51;
auto x135 = -x58;
auto x136 = x135 + x34;
auto x137 = x134 + x136 + x47;
auto x138 = x135 + x75;
auto x139 = x134 + x138 + x78;
auto x140 = x133 + x136 + x75 + x99;
auto x141 = x124 + x134;
auto x142 = x126 + x132 + x136;
auto x143 = x129 + x131 + x138 + V{1};
auto x144 = x19*x63;
auto x145 = x20*x56;
auto x146 = x21*x68;
auto x147 = x25 + V{1};
auto x148 = x147*x27;
auto x149 = V{0.00110298895386615}*cell[0] + V{0.00110298895386615}*cell[10] + V{0.00110298895386615}*cell[11] + V{0.00110298895386615}*cell[12] + V{0.00110298895386615}*cell[13] + V{0.00110298895386615}*cell[14] + V{0.00110298895386615}*cell[15] + V{0.00110298895386615}*cell[16] + V{0.00110298895386615}*cell[17] + V{0.00110298895386615}*cell[18] + V{0.00110298895386615}*cell[1] + V{0.00110298895386615}*cell[2] + V{0.00110298895386615}*cell[3] + V{0.00110298895386615}*cell[4] + V{0.00110298895386615}*cell[5] + V{0.00110298895386615}*cell[6] + V{0.00110298895386615}*cell[7] + V{0.00110298895386615}*cell[8] + V{0.00110298895386615}*cell[9] + V{0.00110298895386615};
auto x150 = V{0.166666666666667}*x147;
auto x151 = x150*x19;
auto x152 = V{0.0522303443794672}*cell[0] + V{0.0522303443794672}*cell[10] + V{0.0522303443794672}*cell[11] + V{0.0522303443794672}*cell[12] + V{0.0522303443794672}*cell[13] + V{0.0522303443794672}*cell[14] + V{0.0522303443794672}*cell[15] + V{0.0522303443794672}*cell[16] + V{0.0522303443794672}*cell[17] + V{0.0522303443794672}*cell[18] + V{0.0522303443794672}*cell[1] + V{0.0522303443794672}*cell[2] + V{0.0522303443794672}*cell[3] + V{0.0522303443794672}*cell[4] + V{0.0522303443794672}*cell[5] + V{0.0522303443794672}*cell[6] + V{0.0522303443794672}*cell[7] + V{0.0522303443794672}*cell[8] + V{0.0522303443794672}*cell[9] + V{0.0522303443794672};
auto x153 = V{0.00652046783625729}*cell[3];
auto x154 = V{0.00652046783625729}*cell[12];
auto x155 = V{0.102631578947368}*cell[0];
auto x156 = x72*(V{0.0342105263157895}*cell[0] + V{0.0342105263157895}*cell[10] + V{0.0342105263157895}*cell[11] + V{0.0342105263157895}*cell[12] + V{0.0342105263157895}*cell[13] + V{0.0342105263157895}*cell[14] + V{0.0342105263157895}*cell[15] + V{0.0342105263157895}*cell[16] + V{0.0342105263157895}*cell[17] + V{0.0342105263157895}*cell[18] + V{0.0342105263157895}*cell[1] + V{0.0342105263157895}*cell[2] + V{0.0342105263157895}*cell[3] + V{0.0342105263157895}*cell[4] + V{0.0342105263157895}*cell[5] + V{0.0342105263157895}*cell[6] + V{0.0342105263157895}*cell[7] + V{0.0342105263157895}*cell[8] + V{0.0342105263157895}*cell[9] + V{0.0342105263157895});
auto x157 = V{0.00732618583495776}*cell[0] + V{0.00732618583495776}*cell[10] + V{0.00732618583495776}*cell[11] + V{0.00732618583495776}*cell[12] + V{0.00732618583495776}*cell[13] + V{0.00732618583495776}*cell[14] + V{0.00732618583495776}*cell[15] + V{0.00732618583495776}*cell[16] + V{0.00732618583495776}*cell[17] + V{0.00732618583495776}*cell[18] + V{0.00732618583495776}*cell[1] + V{0.00732618583495776}*cell[2] + V{0.00732618583495776}*cell[3] + V{0.00732618583495776}*cell[4] + V{0.00732618583495776}*cell[5] + V{0.00732618583495776}*cell[6] + V{0.00732618583495776}*cell[7] + V{0.00732618583495776}*cell[8] + V{0.00732618583495776}*cell[9] + V{0.00732618583495776};
auto x158 = V{0.000362248213125405}*cell[0] + V{0.000362248213125405}*cell[10] + V{0.000362248213125405}*cell[11] + V{0.000362248213125405}*cell[12] + V{0.000362248213125405}*cell[13] + V{0.000362248213125405}*cell[14] + V{0.000362248213125405}*cell[15] + V{0.000362248213125405}*cell[16] + V{0.000362248213125405}*cell[17] + V{0.000362248213125405}*cell[18] + V{0.000362248213125405}*cell[1] + V{0.000362248213125405}*cell[2] + V{0.000362248213125405}*cell[3] + V{0.000362248213125405}*cell[4] + V{0.000362248213125405}*cell[5] + V{0.000362248213125405}*cell[6] + V{0.000362248213125405}*cell[7] + V{0.000362248213125405}*cell[8] + V{0.000362248213125405}*cell[9] + V{0.000362248213125405};
auto x159 = x128*x158;
auto x160 = V{0.000659519168291098}*cell[0] + V{0.000659519168291098}*cell[10] + V{0.000659519168291098}*cell[11] + V{0.000659519168291098}*cell[12] + V{0.000659519168291098}*cell[13] + V{0.000659519168291098}*cell[14] + V{0.000659519168291098}*cell[15] + V{0.000659519168291098}*cell[16] + V{0.000659519168291098}*cell[17] + V{0.000659519168291098}*cell[18] + V{0.000659519168291098}*cell[1] + V{0.000659519168291098}*cell[2] + V{0.000659519168291098}*cell[3] + V{0.000659519168291098}*cell[4] + V{0.000659519168291098}*cell[5] + V{0.000659519168291098}*cell[6] + V{0.000659519168291098}*cell[7] + V{0.000659519168291098}*cell[8] + V{0.000659519168291098}*cell[9] + V{0.000659519168291098};
auto x161 = -x142*x158;
auto x162 = -x139*x160 + x153 + x154 + x155 + x156 + x157*x79 + x159 + x161 + V{0.0237426900584795}*cell[13] + V{0.26374269005848}*cell[4];
auto x163 = V{0.00652046783625729}*cell[2];
auto x164 = V{0.00652046783625729}*cell[11];
auto x165 = x125*x158;
auto x166 = -x141*x158;
auto x167 = x101*x157 - x140*x160 + x163 + x164 + x165 + x166 + V{0.0237426900584795}*cell[15] + V{0.26374269005848}*cell[6];
auto x168 = x117 + x94;
auto x169 = x157*x168 + x160*x95 + V{0.0237426900584795}*cell[14] + V{0.26374269005848}*cell[5];
auto x170 = x111 + x120;
auto x171 = x112*x160 + x157*x170 + V{0.0237426900584795}*cell[16] + V{0.26374269005848}*cell[7];
auto x172 = V{0.00248862897985705}*cell[0] + V{0.00248862897985705}*cell[10] + V{0.00248862897985705}*cell[11] + V{0.00248862897985705}*cell[12] + V{0.00248862897985705}*cell[13] + V{0.00248862897985705}*cell[14] + V{0.00248862897985705}*cell[15] + V{0.00248862897985705}*cell[16] + V{0.00248862897985705}*cell[17] + V{0.00248862897985705}*cell[18] + V{0.00248862897985705}*cell[1] + V{0.00248862897985705}*cell[2] + V{0.00248862897985705}*cell[3] + V{0.00248862897985705}*cell[4] + V{0.00248862897985705}*cell[5] + V{0.00248862897985705}*cell[6] + V{0.00248862897985705}*cell[7] + V{0.00248862897985705}*cell[8] + V{0.00248862897985705}*cell[9] + V{0.00248862897985705};
auto x173 = x106 + x86;
auto x174 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x175 = x170*x174;
auto x176 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x177 = V{1}*cell[7];
auto x178 = V{1}*cell[16];
auto x179 = x112*x174;
auto x180 = x177 + x178 + x179;
auto x181 = x174*x95;
auto x182 = V{1}*cell[4];
auto x183 = V{1}*cell[13];
auto x184 = x174*x79;
auto x185 = x139*x174;
auto x186 = V{1}*cell[14] + V{1}*cell[5];
auto x187 = -x128*x176 + x142*x176 + x182 + x183 + x184 - x185 + x186 - V{1}*cell[12] - V{1}*cell[3];
auto x188 = x168*x174 + x181 + x187;
auto x189 = V{1}*cell[6];
auto x190 = V{1}*cell[15];
auto x191 = V{1}*cell[2];
auto x192 = V{1}*cell[11];
auto x193 = x101*x174;
auto x194 = x141*x176;
auto x195 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[10] + V{0.111111111111111}*cell[11] + V{0.111111111111111}*cell[12] + V{0.111111111111111}*cell[13] + V{0.111111111111111}*cell[14] + V{0.111111111111111}*cell[15] + V{0.111111111111111}*cell[16] + V{0.111111111111111}*cell[17] + V{0.111111111111111}*cell[18] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111}*cell[9] + V{0.111111111111111};
auto x196 = x140*x174;
auto x197 = x125*x176;
auto x198 = -x107*x176 + x130*x195 + x137*x176 - x143*x195 - x176*x74 + x189 + x190 - x191 - x192 + x193 + x194 - x196 - x197 + V{2}*cell[10] - V{2}*cell[17] - V{2}*cell[18] + V{2}*cell[1] - V{2}*cell[8] - V{2}*cell[9];
auto x199 = -x173*x176 + x175 + x180 + x188 + x198;
auto x200 = V{0.0555555555555556}*x199*x22;
auto x201 = V{1}*x145;
auto x202 = V{1}*x146;
auto x203 = x201 + x202;
auto x204 = -V{2}*x144 + x203;
auto x205 = x150*x27;
auto x206 = V{0.111111111111111}*x22;
auto x207 = V{0.0833333333333333}*x147;
auto x208 = x207*x27;
auto x209 = -x107*x172 + x137*x172 - x172*x173 - x172*x74 - x200 - x204*x205 + x204*x208*(x206 + V{0.940146198830409}) - V{0.0895906432748538}*cell[17] - V{0.0895906432748538}*cell[18] - V{0.0895906432748538}*cell[8] - V{0.0895906432748538}*cell[9];
auto x210 = V{0.00110298895386615}*cell[0] + V{0.00110298895386615}*cell[10] + V{0.00110298895386615}*cell[11] + V{0.00110298895386615}*cell[12] + V{0.00110298895386615}*cell[13] + V{0.00110298895386615}*cell[14] + V{0.00110298895386615}*cell[15] + V{0.00110298895386615}*cell[16] + V{0.00110298895386615}*cell[17] + V{0.00110298895386615}*cell[18] + V{0.00110298895386615}*cell[1] + V{0.00110298895386615}*cell[2] + V{0.00110298895386615}*cell[3] + V{0.00110298895386615}*cell[4] + V{0.00110298895386615}*cell[5] + V{0.00110298895386615}*cell[6] + V{0.00110298895386615}*cell[7] + V{0.00110298895386615}*cell[8] + V{0.00110298895386615}*cell[9] + V{0.00110298895386615};
auto x211 = V{0.0522303443794672}*cell[0] + V{0.0522303443794672}*cell[10] + V{0.0522303443794672}*cell[11] + V{0.0522303443794672}*cell[12] + V{0.0522303443794672}*cell[13] + V{0.0522303443794672}*cell[14] + V{0.0522303443794672}*cell[15] + V{0.0522303443794672}*cell[16] + V{0.0522303443794672}*cell[17] + V{0.0522303443794672}*cell[18] + V{0.0522303443794672}*cell[1] + V{0.0522303443794672}*cell[2] + V{0.0522303443794672}*cell[3] + V{0.0522303443794672}*cell[4] + V{0.0522303443794672}*cell[5] + V{0.0522303443794672}*cell[6] + V{0.0522303443794672}*cell[7] + V{0.0522303443794672}*cell[8] + V{0.0522303443794672}*cell[9] + V{0.0522303443794672};
auto x212 = x150*x20;
auto x213 = x157*x95 + x160*x168 + V{0.26374269005848}*cell[14] + V{0.0237426900584795}*cell[5];
auto x214 = V{0.00652046783625729}*cell[1];
auto x215 = V{0.00652046783625729}*cell[10];
auto x216 = V{0.0277777777777778}*x22;
auto x217 = x199*x216;
auto x218 = x130*x158;
auto x219 = -x143*x158;
auto x220 = -x137*x160 + x157*x74 + x214 + x215 + x217 + x218 + x219 + V{0.0237426900584795}*cell[17] + V{0.26374269005848}*cell[8];
auto x221 = x107*x160 + x157*x173 + V{0.0237426900584795}*cell[18] + V{0.26374269005848}*cell[9];
auto x222 = V{0.0833333333333333}*x22;
auto x223 = -x189 - x190 - x193 + x196;
auto x224 = -x177 - x178 - x179 + x191 + x192 - x194 + x197 + x223;
auto x225 = x222*(-x175 + x188 + x224);
auto x226 = -x225;
auto x227 = V{1}*x144;
auto x228 = -V{2}*x145 + x202 + x227;
auto x229 = x208*(x206 + V{0.940146198830409});
auto x230 = -x101*x172 - x112*x172 + x140*x172 - x170*x172 - x205*x228 + x226 + x228*x229 - V{0.0895906432748538}*cell[15] - V{0.0895906432748538}*cell[16] - V{0.0895906432748538}*cell[6] - V{0.0895906432748538}*cell[7];
auto x231 = x150*x21;
auto x232 = x112*x157 + x155 + x156 + x160*x170 + V{0.26374269005848}*cell[16] + V{0.0237426900584795}*cell[7];
auto x233 = x107*x157 + x160*x173 + V{0.26374269005848}*cell[18] + V{0.0237426900584795}*cell[9];
auto x234 = -V{2}*x146 + x201 + x227;
auto x235 = x139*x172 - x168*x172 - x172*x79 - x172*x95 - x205*x234 + x225 + x229*x234 - V{0.0895906432748538}*cell[13] - V{0.0895906432748538}*cell[14] - V{0.0895906432748538}*cell[4] - V{0.0895906432748538}*cell[5] + V{0.00652046783625723};
auto x236 = V{0.25}*x22;
auto x237 = x135 + x88;
auto x238 = x102 + x133;
auto x239 = -x182 - x183 + x185 + x186;
auto x240 = V{0.00608390188434048}*cell[0] + V{0.00608390188434048}*cell[10] + V{0.00608390188434048}*cell[11] + V{0.00608390188434048}*cell[12] + V{0.00608390188434048}*cell[13] + V{0.00608390188434048}*cell[14] + V{0.00608390188434048}*cell[15] + V{0.00608390188434048}*cell[16] + V{0.00608390188434048}*cell[17] + V{0.00608390188434048}*cell[18] + V{0.00608390188434048}*cell[1] + V{0.00608390188434048}*cell[2] + V{0.00608390188434048}*cell[3] + V{0.00608390188434048}*cell[4] + V{0.00608390188434048}*cell[5] + V{0.00608390188434048}*cell[6] + V{0.00608390188434048}*cell[7] + V{0.00608390188434048}*cell[8] + V{0.00608390188434048}*cell[9] + V{0.00608390188434048};
auto x241 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x242 = x121*x174;
auto x243 = x180 + x242;
auto x244 = x118*x174 + x181;
auto x245 = x187 + x244;
auto x246 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x247 = V{0.0186151721897336}*cell[0] + V{0.0186151721897336}*cell[10] + V{0.0186151721897336}*cell[11] + V{0.0186151721897336}*cell[12] + V{0.0186151721897336}*cell[13] + V{0.0186151721897336}*cell[14] + V{0.0186151721897336}*cell[15] + V{0.0186151721897336}*cell[16] + V{0.0186151721897336}*cell[17] + V{0.0186151721897336}*cell[18] + V{0.0186151721897336}*cell[1] + V{0.0186151721897336}*cell[2] + V{0.0186151721897336}*cell[3] + V{0.0186151721897336}*cell[4] + V{0.0186151721897336}*cell[5] + V{0.0186151721897336}*cell[6] + V{0.0186151721897336}*cell[7] + V{0.0186151721897336}*cell[8] + V{0.0186151721897336}*cell[9] + V{0.0186151721897336};
auto x248 = x19 + x20;
auto x249 = x207*x248;
auto x250 = V{0.0122181611435997}*cell[0] + V{0.0122181611435997}*cell[10] + V{0.0122181611435997}*cell[11] + V{0.0122181611435997}*cell[12] + V{0.0122181611435997}*cell[13] + V{0.0122181611435997}*cell[14] + V{0.0122181611435997}*cell[15] + V{0.0122181611435997}*cell[16] + V{0.0122181611435997}*cell[17] + V{0.0122181611435997}*cell[18] + V{0.0122181611435997}*cell[1] + V{0.0122181611435997}*cell[2] + V{0.0122181611435997}*cell[3] + V{0.0122181611435997}*cell[4] + V{0.0122181611435997}*cell[5] + V{0.0122181611435997}*cell[6] + V{0.0122181611435997}*cell[7] + V{0.0122181611435997}*cell[8] + V{0.0122181611435997}*cell[9] + V{0.0122181611435997};
auto x251 = V{0.0237426900584795}*cell[11];
auto x252 = V{0.26374269005848}*cell[2];
auto x253 = V{0.0146523716699155}*cell[0] + V{0.0146523716699155}*cell[10] + V{0.0146523716699155}*cell[11] + V{0.0146523716699155}*cell[12] + V{0.0146523716699155}*cell[13] + V{0.0146523716699155}*cell[14] + V{0.0146523716699155}*cell[15] + V{0.0146523716699155}*cell[16] + V{0.0146523716699155}*cell[17] + V{0.0146523716699155}*cell[18] + V{0.0146523716699155}*cell[1] + V{0.0146523716699155}*cell[2] + V{0.0146523716699155}*cell[3] + V{0.0146523716699155}*cell[4] + V{0.0146523716699155}*cell[5] + V{0.0146523716699155}*cell[6] + V{0.0146523716699155}*cell[7] + V{0.0146523716699155}*cell[8] + V{0.0146523716699155}*cell[9] + V{0.0146523716699155};
auto x254 = x125*x253;
auto x255 = V{0.0013190383365822}*cell[0] + V{0.0013190383365822}*cell[10] + V{0.0013190383365822}*cell[11] + V{0.0013190383365822}*cell[12] + V{0.0013190383365822}*cell[13] + V{0.0013190383365822}*cell[14] + V{0.0013190383365822}*cell[15] + V{0.0013190383365822}*cell[16] + V{0.0013190383365822}*cell[17] + V{0.0013190383365822}*cell[18] + V{0.0013190383365822}*cell[1] + V{0.0013190383365822}*cell[2] + V{0.0013190383365822}*cell[3] + V{0.0013190383365822}*cell[4] + V{0.0013190383365822}*cell[5] + V{0.0013190383365822}*cell[6] + V{0.0013190383365822}*cell[7] + V{0.0013190383365822}*cell[8] + V{0.0013190383365822}*cell[9] + V{0.0013190383365822};
auto x256 = -x141*x255;
auto x257 = V{0.0526315789473684}*cell[0];
auto x258 = x72*(V{0.0175438596491228}*cell[0] + V{0.0175438596491228}*cell[10] + V{0.0175438596491228}*cell[11] + V{0.0175438596491228}*cell[12] + V{0.0175438596491228}*cell[13] + V{0.0175438596491228}*cell[14] + V{0.0175438596491228}*cell[15] + V{0.0175438596491228}*cell[16] + V{0.0175438596491228}*cell[17] + V{0.0175438596491228}*cell[18] + V{0.0175438596491228}*cell[1] + V{0.0175438596491228}*cell[2] + V{0.0175438596491228}*cell[3] + V{0.0175438596491228}*cell[4] + V{0.0175438596491228}*cell[5] + V{0.0175438596491228}*cell[6] + V{0.0175438596491228}*cell[7] + V{0.0175438596491228}*cell[8] + V{0.0175438596491228}*cell[9] + V{0.0175438596491228});
auto x259 = V{0.00599943144899285}*cell[0] + V{0.00599943144899285}*cell[10] + V{0.00599943144899285}*cell[11] + V{0.00599943144899285}*cell[12] + V{0.00599943144899285}*cell[13] + V{0.00599943144899285}*cell[14] + V{0.00599943144899285}*cell[15] + V{0.00599943144899285}*cell[16] + V{0.00599943144899285}*cell[17] + V{0.00599943144899285}*cell[18] + V{0.00599943144899285}*cell[1] + V{0.00599943144899285}*cell[2] + V{0.00599943144899285}*cell[3] + V{0.00599943144899285}*cell[4] + V{0.00599943144899285}*cell[5] + V{0.00599943144899285}*cell[6] + V{0.00599943144899285}*cell[7] + V{0.00599943144899285}*cell[8] + V{0.00599943144899285}*cell[9] + V{0.00599943144899285};
auto x260 = x101*x240 + x140*x259 + x257 + x258 - V{0.215979532163743}*cell[15] + V{0.219020467836257}*cell[6] + V{0.0270760233918129};
auto x261 = x251 + x252 + x254 + x256 + x260;
auto x262 = -x112*x259 - V{0.215979532163743}*cell[16] + V{0.219020467836257}*cell[7];
auto x263 = x137*x259 + x240*x74 - V{0.215979532163743}*cell[17] + V{0.219020467836257}*cell[8];
auto x264 = -V{0.0895906432748538}*cell[3];
auto x265 = -V{0.0895906432748538}*cell[12];
auto x266 = V{0.0049772579597141}*cell[0] + V{0.0049772579597141}*cell[10] + V{0.0049772579597141}*cell[11] + V{0.0049772579597141}*cell[12] + V{0.0049772579597141}*cell[13] + V{0.0049772579597141}*cell[14] + V{0.0049772579597141}*cell[15] + V{0.0049772579597141}*cell[16] + V{0.0049772579597141}*cell[17] + V{0.0049772579597141}*cell[18] + V{0.0049772579597141}*cell[1] + V{0.0049772579597141}*cell[2] + V{0.0049772579597141}*cell[3] + V{0.0049772579597141}*cell[4] + V{0.0049772579597141}*cell[5] + V{0.0049772579597141}*cell[6] + V{0.0049772579597141}*cell[7] + V{0.0049772579597141}*cell[8] + V{0.0049772579597141}*cell[9] + V{0.0049772579597141};
auto x267 = x142*x266;
auto x268 = -x128*x266;
auto x269 = x203 + x227;
auto x270 = -V{3}*x248*x77 + x269;
auto x271 = V{0.0416666666666667}*x148*(V{0.361111111111111}*x22 + V{0.670146198830409});
auto x272 = -x208*x270 + x264 + x265 + x267 + x268 + x270*x271;
auto x273 = V{0.0237426900584795}*cell[10];
auto x274 = V{0.26374269005848}*cell[1];
auto x275 = x130*x253;
auto x276 = -x143*x255;
auto x277 = -x107*x259 - V{0.215979532163743}*cell[18] + V{0.219020467836257}*cell[9];
auto x278 = x273 + x274 + x275 + x276 + x277;
auto x279 = x19 - x20;
auto x280 = x207*x279;
auto x281 = V{0.0237426900584795}*cell[2];
auto x282 = V{0.26374269005848}*cell[11];
auto x283 = x125*x255;
auto x284 = -x141*x253;
auto x285 = x170*x240 + x262;
auto x286 = x281 + x282 + x283 + x284 + x285;
auto x287 = -x217;
auto x288 = -x137*x240 - x259*x74 + x287 + V{0.219020467836257}*cell[17] - V{0.215979532163743}*cell[8];
auto x289 = x107*x240 - x173*x259 + V{0.219020467836257}*cell[18] - V{0.215979532163743}*cell[9];
auto x290 = x273 + x274 + x275 + x276 + x289;
auto x291 = x236*(-x184 + x239 + x244);
auto x292 = x269 - V{3}*x279*x92;
auto x293 = -x208*x292 + x226 + x264 + x265 + x267 + x268 + x271*x292 - x291;
auto x294 = x19 + x21;
auto x295 = x207*x294;
auto x296 = V{0.0237426900584795}*cell[12];
auto x297 = V{0.26374269005848}*cell[3];
auto x298 = x128*x253;
auto x299 = -x142*x255;
auto x300 = x139*x259 + x240*x79 - V{0.215979532163743}*cell[13] + V{0.219020467836257}*cell[4];
auto x301 = x296 + x297 + x298 + x299 + x300;
auto x302 = x263 + x287;
auto x303 = -V{0.0895906432748538}*cell[2];
auto x304 = -V{0.0895906432748538}*cell[11];
auto x305 = x141*x266;
auto x306 = -x125*x266;
auto x307 = V{0.219020467836257}*cell[5];
auto x308 = -V{0.215979532163743}*cell[14];
auto x309 = x168*x240;
auto x310 = -x259*x95;
auto x311 = x257 + x258 + V{0.0270760233918129};
auto x312 = x307 + x308 + x309 + x310 + x311;
auto x313 = x225 + x303 + x304 + x305 + x306 + x312;
auto x314 = x236*(x223 + x243);
auto x315 = x269 - V{3}*x294*x98;
auto x316 = -x208*x315 + x271*x315 + x314;
auto x317 = -x21;
auto x318 = x19 + x317;
auto x319 = x207*x318;
auto x320 = V{0.0237426900584795}*cell[3];
auto x321 = V{0.26374269005848}*cell[12];
auto x322 = x128*x255;
auto x323 = -x142*x253;
auto x324 = x300 + x320 + x321 + x322 + x323;
auto x325 = x173*x240;
auto x326 = x288 + x325;
auto x327 = -V{3}*x110*x318 + x269;
auto x328 = -x208*x327 + x271*x327 - x314;
auto x329 = x20 + x21;
auto x330 = x207*x329;
auto x331 = x112*x240 - x170*x259 + V{0.219020467836257}*cell[16] - V{0.215979532163743}*cell[7];
auto x332 = -x168*x259 + x240*x95 + V{0.219020467836257}*cell[14] - V{0.215979532163743}*cell[5];
auto x333 = -V{0.0895906432748538}*cell[1];
auto x334 = -V{0.0895906432748538}*cell[10];
auto x335 = x236*(x107*x174 + x137*x174 - x174*x74 + x174*x87 - V{1}*cell[17] + V{1}*cell[18] - V{1}*cell[8] + V{1}*cell[9]);
auto x336 = x143*x266;
auto x337 = -x130*x266;
auto x338 = V{0.00319850552306693}*cell[0] + V{0.00319850552306693}*cell[10] + V{0.00319850552306693}*cell[11] + V{0.00319850552306693}*cell[12] + V{0.00319850552306693}*cell[13] + V{0.00319850552306693}*cell[14] + V{0.00319850552306693}*cell[15] + V{0.00319850552306693}*cell[16] + V{0.00319850552306693}*cell[17] + V{0.00319850552306693}*cell[18] + V{0.00319850552306693}*cell[1] + V{0.00319850552306693}*cell[2] + V{0.00319850552306693}*cell[3] + V{0.00319850552306693}*cell[4] + V{0.00319850552306693}*cell[5] + V{0.00319850552306693}*cell[6] + V{0.00319850552306693}*cell[7] + V{0.00319850552306693}*cell[8] + V{0.00319850552306693}*cell[9] + V{0.00319850552306693};
auto x339 = x269 - V{3}*x329*x46;
auto x340 = -x107*x338 - x173*x338 + x200 - x208*x339 + x271*x339 + x333 + x334 + x335 + x336 + x337 - V{0.115146198830409}*cell[18] - V{0.115146198830409}*cell[9];
auto x341 = x20 + x317;
auto x342 = x207*x341;
auto x343 = x311 + x332;
auto x344 = -x101*x259 - x140*x240 + V{0.219020467836257}*cell[15] - V{0.215979532163743}*cell[6];
auto x345 = x251 + x252 + x254 + x256 + x344;
auto x346 = -V{3}*x105*x341 + x269;
auto x347 = x137*x338 + x200 - x208*x346 + x271*x346 + x333 + x334 - x335 + x336 + x337 - x338*x74 - V{0.115146198830409}*cell[17] - V{0.115146198830409}*cell[8];
auto x348 = -x139*x157 + x153 + x154 + x159 + x160*x79 + x161 + V{0.26374269005848}*cell[13] + V{0.0237426900584795}*cell[4];
auto x349 = x101*x160 - x140*x157 + x163 + x164 + x165 + x166 + V{0.26374269005848}*cell[15] + V{0.0237426900584795}*cell[6];
auto x350 = -x137*x157 + x155 + x156 + x160*x74 + x214 + x215 + x217 + x218 + x219 + V{0.26374269005848}*cell[17] + V{0.0237426900584795}*cell[8];
auto x351 = x281 + x282 + x283 + x284 + x331;
auto x352 = x130*x255 - x143*x253 + V{0.26374269005848}*cell[10] + V{0.0237426900584795}*cell[1];
auto x353 = x311 + x352;
auto x354 = -x139*x240 - x259*x79 + V{0.219020467836257}*cell[13] - V{0.215979532163743}*cell[4];
auto x355 = x320 + x321 + x322 + x323 + x354;
auto x356 = x225 + x303 + x304 + x305 + x306 + x343 + x352;
auto x357 = x296 + x297 + x298 + x299 + x354;
auto x0 = x101*x23 + x107*x23 + x112*x23 + x118*x23 + x121*x23 + x122*x125 + x122*x128 + x122*x130 - x122*x141 - x122*x142 - x122*x143 - x137*x23 - x139*x23 - x140*x23 - V{0.376315789473684}*x148*(x144 + x145 + x146) + x23*x74 + x23*x79 + x23*x87 + x23*x95 - x72*(V{0.41578947368421}*cell[0] + V{0.41578947368421}*cell[10] + V{0.41578947368421}*cell[11] + V{0.41578947368421}*cell[12] + V{0.41578947368421}*cell[13] + V{0.41578947368421}*cell[14] + V{0.41578947368421}*cell[15] + V{0.41578947368421}*cell[16] + V{0.41578947368421}*cell[17] + V{0.41578947368421}*cell[18] + V{0.41578947368421}*cell[1] + V{0.41578947368421}*cell[2] + V{0.41578947368421}*cell[3] + V{0.41578947368421}*cell[4] + V{0.41578947368421}*cell[5] + V{0.41578947368421}*cell[6] + V{0.41578947368421}*cell[7] + V{0.41578947368421}*cell[8] + V{0.41578947368421}*cell[9] + V{0.41578947368421}) - V{0.247368421052631}*cell[0] + V{0.102631578947368}*cell[10] + V{0.102631578947368}*cell[11] + V{0.102631578947368}*cell[12] + V{0.0526315789473684}*cell[13] + V{0.0526315789473684}*cell[14] + V{0.0526315789473684}*cell[15] + V{0.0526315789473684}*cell[16] + V{0.0526315789473684}*cell[17] + V{0.0526315789473684}*cell[18] + V{0.102631578947368}*cell[1] + V{0.102631578947368}*cell[2] + V{0.102631578947368}*cell[3] + V{0.0526315789473684}*cell[4] + V{0.0526315789473684}*cell[5] + V{0.0526315789473684}*cell[6] + V{0.0526315789473684}*cell[7] + V{0.0526315789473684}*cell[8] + V{0.0526315789473684}*cell[9] + V{-0.364035087719298};
auto x1 = -x130*x152 - x143*x149 - x151 + x162 + x167 + x169 + x171 + x209 + V{0.0198538011695907}*cell[10] + V{0.0598538011695906}*cell[1] + V{0.00652046783625724};
auto x2 = -x125*x211 - x141*x210 + x162 - x212 + x213 + x220 + x221 + x230 + V{0.0198538011695907}*cell[11] + V{0.0598538011695907}*cell[2] + V{0.00652046783625724};
auto x3 = -x128*x211 - x142*x210 + x167 + x220 - x231 + x232 + x233 + x235 + V{0.0198538011695907}*cell[12] + V{0.0598538011695907}*cell[3];
auto x4 = -x118*x241 + x121*x240 - x139*x250 - x216*(-x176*x87 + x198 + x243 + x245) - x222*(x224 - x242 + x245) + x236*(-x174*(x115 + x134 + x237) - x174*(x138 + x238 + x93) + x174*(x237 + x238 + x78) + x239) + x240*x87 - x246*x95 - x247*x79 - x249 + x261 + x262 + x263 + x272 + x278 + V{0.439853801169591}*cell[13] - V{0.115146198830409}*cell[14] + V{0.329853801169591}*cell[4] - V{0.115146198830409}*cell[5];
auto x5 = x139*x246 - x168*x247 - x241*x79 + x250*x95 + x260 - x280 + x286 + x288 + x290 + x293 - V{0.115146198830409}*cell[13] + V{0.439853801169591}*cell[14] - V{0.115146198830409}*cell[4] + V{0.329853801169591}*cell[5];
auto x6 = -x101*x247 - x112*x246 - x140*x250 - x170*x241 + x290 - x295 + x301 + x302 + x313 + x316 + V{0.439853801169591}*cell[15] - V{0.115146198830409}*cell[16] + V{0.329853801169591}*cell[6] - V{0.115146198830409}*cell[7];
auto x7 = -x101*x241 + x112*x250 + x140*x246 - x170*x247 + x278 + x313 - x319 + x324 + x326 + x328 - V{0.115146198830409}*cell[15] + V{0.439853801169591}*cell[16] - V{0.115146198830409}*cell[6] + V{0.329853801169591}*cell[7];
auto x8 = -x137*x250 - x247*x74 + x261 + x301 - x330 + x331 + x332 + x340 + V{0.439853801169591}*cell[17] + V{0.329853801169591}*cell[8];
auto x9 = x107*x250 - x173*x247 + x285 + x324 - x342 + x343 + x345 + x347 + V{0.439853801169591}*cell[18] + V{0.329853801169591}*cell[9];
auto x10 = x130*x149 + x143*x152 + x151 + x209 + x213 + x232 + x348 + x349 + V{0.0598538011695906}*cell[10] + V{0.0198538011695907}*cell[1] + V{0.00652046783625723};
auto x11 = x125*x210 + x141*x211 + x169 + x212 + x230 + x233 + x348 + x350 + V{0.0598538011695907}*cell[11] + V{0.0198538011695907}*cell[2] + V{0.00652046783625723};
auto x12 = x128*x210 + x142*x211 + x171 + x221 + x231 + x235 + x349 + x350 + V{0.0598538011695907}*cell[12] + V{0.0198538011695907}*cell[3];
auto x13 = x139*x247 - x168*x246 + x226 - x241*x95 + x249 + x250*x79 + x272 + x288 + x289 + x291 + x344 + x351 + x353 + V{0.329853801169591}*cell[13] - V{0.115146198830409}*cell[14] + V{0.439853801169591}*cell[4] - V{0.115146198830409}*cell[5];
auto x14 = x139*x241 + x168*x250 - x246*x79 - x247*x95 + x277 + x280 + x293 + x302 + x325 + x331 + x345 + x353 - V{0.115146198830409}*cell[13] + V{0.329853801169591}*cell[14] - V{0.115146198830409}*cell[4] + V{0.439853801169591}*cell[5];
auto x15 = x101*x250 - x112*x241 + x140*x247 - x170*x246 + x277 + x295 + x316 + x326 + x355 + x356 + V{0.329853801169591}*cell[15] - V{0.115146198830409}*cell[16] + V{0.439853801169591}*cell[6] - V{0.115146198830409}*cell[7];
auto x16 = -x101*x246 - x112*x247 + x140*x241 + x170*x250 + x289 + x302 + x319 + x328 + x356 + x357 - V{0.115146198830409}*cell[15] + V{0.329853801169591}*cell[16] - V{0.115146198830409}*cell[6] + V{0.439853801169591}*cell[7];
auto x17 = x137*x247 + x250*x74 + x286 + x312 + x330 + x340 + x344 + x355 + V{0.329853801169591}*cell[17] + V{0.439853801169591}*cell[8];
auto x18 = -x107*x247 + x173*x250 + x260 + x307 + x308 + x309 + x310 + x342 + x347 + x351 + x357 + V{0.329853801169591}*cell[18] + V{0.439853801169591}*cell[9];
cell[0] = x0;
cell[1] = x1;
cell[2] = x2;
cell[3] = x3;
cell[4] = x4;
cell[5] = x5;
cell[6] = x6;
cell[7] = x7;
cell[8] = x8;
cell[9] = x9;
cell[10] = x10;
cell[11] = x11;
cell[12] = x12;
cell[13] = x13;
cell[14] = x14;
cell[15] = x15;
cell[16] = x16;
cell[17] = x17;
cell[18] = x18;
return { x26, V{1}*x35*(x57 + x64 + x69) };
}

};


}

}

#endif

#endif
