/*  This file is part of the OpenLB library
 *
 *  Copyright (C) 2021 Adrian Kummerlaender
 *  E-mail contact: info@openlb.net
 *  The most recent release of OpenLB can be downloaded at
 *  <http://www.openlb.net/>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA  02110-1301, USA.
*/

#ifndef DYNAMICS_COLLISION_LES_CSE_H
#define DYNAMICS_COLLISION_LES_CSE_H


#ifndef DISABLE_CSE

#include "equilibrium.h"
#include "collision.h"
#include "latticeDescriptors.h"

namespace olb {

namespace collision {

namespace detail {

template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = cell[1] + cell[7];
auto x10 = x9 + cell[0] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[8] + V{1};
auto x11 = V{1} / (x10);
auto x14 = V{1}*x11;
auto x15 = -cell[5];
auto x16 = cell[1] - cell[7];
auto x17 = cell[2] - cell[6];
auto x18 = x15 + x16 + x17 + cell[3];
auto x19 = x18*x18;
auto x20 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x21 = -x14*x19 + x20 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x22 = -cell[3];
auto x23 = -cell[4] + cell[8];
auto x24 = x15 + x22 + x23 + x9;
auto x25 = x24*x24;
auto x26 = -x14*x25 + x20 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x27 = x22 + cell[5];
auto x28 = -x11*x18*x24 + x16 + x27;
auto x29 = V{1} / (V{3.00000046417339}*util::sqrt(x11*(x13*x13)*util::sqrt(V{0.5}*(x21*x21) + V{0.5}*(x26*x26) + x28*x28) + V{0.0277777691819762}/((x12)*(x12))) + V{0.5}/x12);
auto x30 = V{1} / ((x10)*(x10));
auto x31 = V{1.5}*x30;
auto x32 = x25*x31;
auto x33 = -cell[2] + cell[6];
auto x34 = x27 + x33 - cell[1] + cell[7];
auto x35 = x31*(x34*x34) + V{-1};
auto x36 = x32 + x35;
auto x37 = V{1} - x29;
auto x38 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x39 = V{3}*cell[2];
auto x40 = V{3}*cell[3];
auto x41 = V{3}*cell[6];
auto x42 = V{3}*cell[7];
auto x43 = V{3}*cell[1];
auto x44 = V{3}*cell[5];
auto x45 = x43 - x44;
auto x46 = x11*(x39 + x40 - x41 - x42 + x45);
auto x47 = V{4.5}*x30;
auto x48 = x17 + x23 + V{2}*cell[1] - V{2}*cell[5];
auto x49 = x47*(x48*x48);
auto x50 = V{1} - x32;
auto x51 = -x40 + x42;
auto x52 = x11*(x45 + x51 - V{3}*cell[4] + V{3}*cell[8]);
auto x53 = x19*x31;
auto x54 = x52 - x53;
auto x55 = x50 + x54;
auto x56 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x57 = V{3}*x30;
auto x58 = x19*x57 + x50;
auto x59 = V{2}*cell[3];
auto x60 = V{2}*cell[7];
auto x61 = x23 + x33 - x59 + x60;
auto x62 = x25*x57;
auto x63 = -x46;
auto x64 = x17 + x59 - x60 + cell[4] - cell[8];
cell[0] = -x29*(x36*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + V{0.444444444444444}) + V{1}*x37*cell[0];
cell[1] = x29*(x38*(x46 + x49 + x55) + V{-0.0277777777777778}) + V{1}*x37*cell[1];
cell[2] = x29*(x56*(x46 + x58) + V{-0.111111111111111}) + V{1}*x37*cell[2];
cell[3] = -x29*(x38*(x11*(-x39 + x41 - x43 + x44 + x51) + x36 - x47*x61*x61 + x52) + V{0.0277777777777778}) + V{1}*x37*cell[3];
cell[4] = -x29*(x56*(x35 + x52 - x62) + V{0.111111111111111}) + V{1}*x37*cell[4];
cell[5] = -x29*(x38*(x32 + x46 - x49 + x52 + x53 + V{-1}) + V{0.0277777777777778}) + V{1}*x37*cell[5];
cell[6] = x29*(x56*(x58 + x63) + V{-0.111111111111111}) + V{1}*x37*cell[6];
cell[7] = x29*(x38*(x47*(x64*x64) + x55 + x63) + V{-0.0277777777777778}) + V{1}*x37*cell[7];
cell[8] = x29*(x56*(x54 + x62 + V{1}) + V{-0.111111111111111}) + V{1}*x37*cell[8];
return { x10, V{1}*x30*(x19 + x25) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = cell[2] + cell[3];
auto x1 = cell[1] + cell[7] + cell[8];
auto x2 = V{1} / (x0 + x1 + cell[0] + cell[4] + cell[5] + cell[6] + V{1});
auto x3 = V{1}*x2;
auto x4 = -cell[5];
auto x5 = cell[1] - cell[7];
auto x6 = x0 + x4 + x5 - cell[6];
auto x7 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x8 = -x3*x6*x6 + x7 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x9 = -cell[3];
auto x10 = x1 + x4 + x9 - cell[4];
auto x11 = -x3*x10*x10 + x7 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x14 = -x10*x2*x6 + x5 + x9 + cell[5];
return V{1} / (V{3.00000046417339}*util::sqrt(x2*(x13*x13)*util::sqrt(V{0.5}*(x11*x11) + x14*x14 + V{0.5}*(x8*x8)) + V{0.0277777691819762}/((x12)*(x12))) + V{0.5}/x12);
}

};

template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell[15] + cell[17];
auto x20 = x19 + cell[12];
auto x21 = cell[11] + cell[18];
auto x22 = cell[10] + cell[14] + cell[16];
auto x25 = cell[6] + cell[7];
auto x26 = cell[4] + cell[5];
auto x27 = cell[8] + cell[9];
auto x28 = cell[13] + cell[3];
auto x29 = x20 + x21 + x22 + x25 + x26 + x27 + x28 + cell[0] + cell[1] + cell[2] + V{1};
auto x30 = V{1} / (x29);
auto x31 = V{0.333333333333333}*cell[4];
auto x32 = V{0.333333333333333}*cell[5];
auto x33 = V{0.333333333333333}*cell[13];
auto x34 = V{0.333333333333333}*cell[14];
auto x35 = V{1}*x30;
auto x36 = -cell[3];
auto x37 = -cell[18];
auto x38 = -cell[8];
auto x39 = x38 + cell[9];
auto x40 = x36 + x37 + x39;
auto x41 = -cell[16];
auto x42 = -cell[6];
auto x43 = x42 + cell[7];
auto x44 = x41 + x43;
auto x45 = x20 + x40 + x44;
auto x46 = x45*x45;
auto x47 = V{0.333333333333333}*cell[0];
auto x48 = V{0.333333333333333}*cell[1];
auto x49 = V{0.333333333333333}*cell[10];
auto x50 = x47 + x48 + x49 - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x51 = V{0.333333333333333}*cell[2];
auto x52 = V{0.333333333333333}*cell[11];
auto x53 = x51 + x52 - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x54 = x31 + x32 + x33 + x34 + x35*x46 + x50 + x53 - V{0.666666666666667}*cell[12] - V{0.666666666666667}*cell[3];
auto x55 = V{0.333333333333333}*cell[6];
auto x56 = V{0.333333333333333}*cell[7];
auto x57 = V{0.333333333333333}*cell[15];
auto x58 = V{0.333333333333333}*cell[16];
auto x59 = cell[13] + cell[17];
auto x60 = -cell[2];
auto x61 = -cell[9];
auto x62 = x21 + x38 + x60 + x61;
auto x63 = -cell[14];
auto x64 = -cell[4];
auto x65 = x64 + cell[5];
auto x66 = x63 + x65;
auto x67 = x59 + x62 + x66;
auto x68 = x67*x67;
auto x69 = V{0.333333333333333}*cell[3];
auto x70 = V{0.333333333333333}*cell[12];
auto x71 = x69 + x70 - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x72 = x35*x68 + x50 + x55 + x56 + x57 + x58 + x71 - V{0.666666666666667}*cell[11] - V{0.666666666666667}*cell[2];
auto x73 = V{0.333333333333333}*cell[8];
auto x74 = V{0.333333333333333}*cell[9];
auto x75 = V{0.333333333333333}*cell[17];
auto x76 = V{0.333333333333333}*cell[18];
auto x77 = cell[13] + cell[15];
auto x78 = -cell[1];
auto x79 = -cell[7];
auto x80 = x42 + x78 + x79;
auto x81 = -cell[5];
auto x82 = x64 + x81;
auto x83 = x22 + x77 + x80 + x82;
auto x84 = x83*x83;
auto x85 = x35*x84 + x47 + x53 + x71 + x73 + x74 + x75 + x76 - V{0.666666666666667}*cell[10] - V{0.666666666666667}*cell[1];
auto x86 = x30*x83;
auto x87 = -cell[13];
auto x88 = x87 + cell[14];
auto x89 = x65 + x67*x86 + x88;
auto x90 = -cell[15];
auto x91 = x90 + cell[16];
auto x92 = x43 + x45*x86 + x91;
auto x93 = -cell[17];
auto x94 = x93 + cell[18];
auto x95 = x30*x45*x67 + x39 + x94;
auto x96 = V{1} / (V{3.00000046417339}*util::sqrt(x30*(x24*x24)*util::sqrt(V{0.5}*(x54*x54) + V{0.5}*(x72*x72) + V{0.5}*(x85*x85) + x89*x89 + x92*x92 + x95*x95) + V{0.0277777691819762}/((x23)*(x23))) + V{0.5}/x23);
auto x97 = V{1} / ((x29)*(x29));
auto x98 = V{1.5}*x97;
auto x99 = x84*x98;
auto x100 = x68*x98;
auto x101 = x46*x98;
auto x102 = x100 + x101 + V{-1};
auto x103 = x102 + x99;
auto x104 = V{1} - x96;
auto x105 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x106 = V{3}*cell[14];
auto x107 = V{3}*cell[16];
auto x108 = V{3}*cell[5];
auto x109 = V{3}*cell[7];
auto x110 = V{3}*cell[13] - V{3}*cell[4];
auto x111 = V{3}*cell[15] - V{3}*cell[6];
auto x112 = x30*(x106 + x107 - x108 - x109 + x110 + x111 + V{3}*cell[10] - V{3}*cell[1]);
auto x113 = V{3}*x97;
auto x114 = x113*x84;
auto x115 = V{3}*cell[18];
auto x116 = V{3}*cell[9];
auto x117 = V{3}*cell[17] - V{3}*cell[8];
auto x118 = x30*(-x106 + x108 + x110 + x115 - x116 + x117 + V{3}*cell[11] - V{3}*cell[2]);
auto x119 = x113*x68;
auto x120 = x99 + V{-1};
auto x121 = x30*(-x107 + x109 + x111 - x115 + x116 + x117 + V{3}*cell[12] - V{3}*cell[3]);
auto x122 = x113*x46;
auto x123 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x124 = V{4.5}*x97;
auto x125 = x80 + cell[10] + cell[16];
auto x126 = x125 + x19 + x62 + V{2}*cell[13] - V{2}*cell[4];
auto x127 = x124*(x126*x126);
auto x128 = x103 + x112;
auto x129 = -x118;
auto x130 = V{2}*cell[14];
auto x131 = V{2}*cell[5];
auto x132 = -cell[10] + cell[17] + cell[1];
auto x133 = -x130 + x131 + x132 + x25 + x41 + x62 + x90;
auto x134 = x40 + cell[12];
auto x135 = x78 + x82 + cell[10] + cell[14];
auto x136 = x134 + x135 + x59 + V{2}*cell[15] - V{2}*cell[6];
auto x137 = x124*(x136*x136);
auto x138 = -x121;
auto x139 = V{2}*cell[16];
auto x140 = V{2}*cell[7];
auto x141 = x132 + x134 - x139 + x140 + x26 + x63 + x87;
auto x142 = x36 + x44 + cell[12];
auto x143 = x60 + x66 + cell[11];
auto x144 = x142 + x143 + x77 + V{2}*cell[17] - V{2}*cell[8];
auto x145 = x124*(x144*x144);
auto x146 = x103 + x118;
auto x147 = V{2}*cell[18];
auto x148 = V{2}*cell[9];
auto x149 = -cell[11] + cell[15] + cell[2];
auto x150 = x142 - x147 + x148 + x149 + x81 + x88 + cell[4];
auto x151 = -x100;
auto x152 = V{1} - x101;
auto x153 = x151 + x152;
auto x154 = x112 + x153;
auto x155 = -x99;
auto x156 = x118 + x155;
auto x157 = x121 + x155;
auto x158 = -x112;
auto x159 = x125 + x130 - x131 + x149 + x27 + x37 + x93;
auto x160 = x28 - cell[12];
auto x161 = x135 + x139 - x140 + x160 + x61 + x94 + cell[8];
auto x162 = x103 + x121;
auto x163 = x143 + x147 - x148 + x160 + x79 + x91 + cell[6];
cell[0] = V{1}*x104*cell[0] - x96*(x103*(x31 + x32 + x33 + x34 + x47 + x48 + x49 + x51 + x52 + x55 + x56 + x57 + x58 + x69 + x70 + x73 + x74 + x75 + x76 + V{0.333333333333333}) + V{0.333333333333333});
cell[1] = V{1}*x104*cell[1] - x96*(x105*(x102 + x112 - x114) + V{0.0555555555555556});
cell[2] = V{1}*x104*cell[2] - x96*(x105*(x101 + x118 - x119 + x120) + V{0.0555555555555556});
cell[3] = V{1}*x104*cell[3] - x96*(x105*(x100 + x120 + x121 - x122) + V{0.0555555555555556});
cell[4] = V{1}*x104*cell[4] - x96*(x123*(x118 - x127 + x128) + V{0.0277777777777778});
cell[5] = V{1}*x104*cell[5] - x96*(x123*(-x124*x133*x133 + x128 + x129) + V{0.0277777777777778});
cell[6] = V{1}*x104*cell[6] - x96*(x123*(x121 + x128 - x137) + V{0.0277777777777778});
cell[7] = V{1}*x104*cell[7] - x96*(x123*(-x124*x141*x141 + x128 + x138) + V{0.0277777777777778});
cell[8] = V{1}*x104*cell[8] - x96*(x123*(x121 - x145 + x146) + V{0.0277777777777778});
cell[9] = V{1}*x104*cell[9] - x96*(x123*(-x124*x150*x150 + x138 + x146) + V{0.0277777777777778});
cell[10] = V{1}*x104*cell[10] + x96*(x105*(x114 + x154) + V{-0.0555555555555556});
cell[11] = V{1}*x104*cell[11] + x96*(x105*(x119 + x152 + x156) + V{-0.0555555555555556});
cell[12] = V{1}*x104*cell[12] + x96*(x105*(x122 + x151 + x157 + V{1}) + V{-0.0555555555555556});
cell[13] = V{1}*x104*cell[13] + x96*(x123*(x127 + x154 + x156) + V{-0.0277777777777778});
cell[14] = V{1}*x104*cell[14] - x96*(x123*(-x124*x159*x159 + x146 + x158) + V{0.0277777777777778});
cell[15] = V{1}*x104*cell[15] + x96*(x123*(x137 + x154 + x157) + V{-0.0277777777777778});
cell[16] = V{1}*x104*cell[16] - x96*(x123*(-x124*x161*x161 + x158 + x162) + V{0.0277777777777778});
cell[17] = V{1}*x104*cell[17] + x96*(x123*(x121 + x145 + x153 + x156) + V{-0.0277777777777778});
cell[18] = V{1}*x104*cell[18] - x96*(x123*(-x124*x163*x163 + x129 + x162) + V{0.0277777777777778});
return { x29, V{1}*x97*(x46 + x68 + x84) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = cell[12] + cell[15] + cell[17];
auto x1 = cell[11] + cell[13] + cell[18];
auto x2 = cell[10] + cell[14] + cell[16];
auto x3 = V{1} / (x0 + x1 + x2 + cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1});
auto x4 = V{1}*x3;
auto x5 = -cell[6];
auto x6 = x5 + cell[7];
auto x7 = -cell[8];
auto x8 = x7 + cell[9];
auto x9 = x0 + x6 + x8 - cell[16] - cell[18] - cell[3];
auto x10 = V{0.333333333333333}*cell[0];
auto x11 = x10 + V{0.333333333333333}*cell[10] - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] + V{0.333333333333333}*cell[1] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x12 = V{0.333333333333333}*cell[11] - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] + V{0.333333333333333}*cell[2] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x13 = x11 + x12 + x4*(x9*x9) - V{0.666666666666667}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] - V{0.666666666666667}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5];
auto x14 = -cell[4];
auto x15 = x14 + cell[5];
auto x16 = x1 + x15 + x7 - cell[14] + cell[17] - cell[2] - cell[9];
auto x17 = V{0.333333333333333}*cell[12] - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] + V{0.333333333333333}*cell[3] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x18 = x11 + x17 + x4*(x16*x16) - V{0.666666666666667}*cell[11] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] - V{0.666666666666667}*cell[2] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7];
auto x19 = x14 + x2 + x5 + cell[13] + cell[15] - cell[1] - cell[5] - cell[7];
auto x20 = x10 + x12 + x17 + x4*(x19*x19) - V{0.666666666666667}*cell[10] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] - V{0.666666666666667}*cell[1] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9];
auto x21 = x19*x3;
auto x22 = x15 + x16*x21 - cell[13] + cell[14];
auto x25 = x21*x9 + x6 - cell[15] + cell[16];
auto x26 = x16*x3*x9 + x8 - cell[17] + cell[18];
return V{1} / (V{3.00000046417339}*util::sqrt(x3*(x24*x24)*util::sqrt(V{0.5}*(x13*x13) + V{0.5}*(x18*x18) + V{0.5}*(x20*x20) + x22*x22 + x25*x25 + x26*x26) + V{0.0277777691819762}/((x23)*(x23))) + V{0.5}/x23);
}

};

template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = cell[10] + cell[6];
auto x28 = x27 + cell[24];
auto x29 = cell[17] + cell[23];
auto x30 = cell[19] + cell[21];
auto x33 = x28 + x29 + x30 + cell[0] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[18] + cell[1] + cell[20] + cell[22] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[7] + cell[8] + cell[9] + V{1};
auto x34 = V{1} / (x33);
auto x35 = V{1}*x34;
auto x36 = -cell[17];
auto x37 = x36 + cell[5];
auto x38 = -cell[19];
auto x39 = x38 + cell[7];
auto x40 = -cell[25];
auto x41 = x40 + cell[11];
auto x42 = x39 + x41;
auto x43 = -cell[18];
auto x44 = -cell[20];
auto x45 = x43 + x44;
auto x46 = -cell[24];
auto x47 = x46 + cell[4];
auto x48 = -cell[26];
auto x49 = x48 + cell[12];
auto x50 = -cell[23];
auto x51 = -cell[14] + cell[1];
auto x52 = x51 + cell[13];
auto x53 = x50 + x52;
auto x54 = x27 + x37 + x42 + x45 + x47 + x49 + x53;
auto x55 = x54*x54;
auto x56 = V{0.666666666666667}*cell[10];
auto x57 = V{0.666666666666667}*cell[11];
auto x58 = V{0.666666666666667}*cell[12];
auto x59 = V{0.666666666666667}*cell[13];
auto x60 = V{0.666666666666667}*cell[23];
auto x61 = V{0.666666666666667}*cell[24];
auto x62 = V{0.666666666666667}*cell[25];
auto x63 = V{0.666666666666667}*cell[26];
auto x64 = -V{0.333333333333333}*cell[0];
auto x65 = x56 + x57 + x58 + x59 + x60 + x61 + x62 + x63 + x64 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x66 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x67 = -x35*x55 + x65 + x66 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x68 = -cell[21];
auto x69 = x68 + cell[9];
auto x70 = x69 + cell[11];
auto x71 = x50 + cell[26];
auto x72 = x71 + cell[8];
auto x73 = -cell[5];
auto x74 = -cell[22];
auto x75 = x73 + x74;
auto x76 = -cell[13];
auto x77 = x76 + cell[25];
auto x78 = -cell[12];
auto x79 = -cell[15] + cell[2];
auto x80 = x79 + cell[10];
auto x81 = x78 + x80;
auto x82 = x36 + cell[18];
auto x83 = x47 + x70 + x72 + x75 + x77 + x81 + x82;
auto x84 = x83*x83;
auto x85 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x86 = -x35*x84 + x65 + x85 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x87 = -cell[11];
auto x88 = -cell[7];
auto x89 = x87 + x88;
auto x90 = -cell[9];
auto x91 = x40 + x90;
auto x92 = -cell[16];
auto x93 = x76 + cell[12];
auto x94 = x92 + x93 + cell[3];
auto x95 = x68 + cell[22];
auto x96 = x38 + cell[20];
auto x97 = x28 + x72 + x89 + x91 + x94 + x95 + x96;
auto x98 = x97*x97;
auto x99 = -x35*x98 + x56 + x57 + x58 + x59 + x60 + x61 + x62 + x63 + x64 + x66 + x85 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x100 = x34*x54;
auto x101 = -cell[4];
auto x102 = x101 + cell[18];
auto x103 = x87 + cell[13] + cell[25];
auto x104 = -cell[10];
auto x105 = x104 + x46 + cell[12];
auto x106 = x100*x83 + x102 + x103 + x105 + x37 + x71;
auto x107 = x104 + cell[13];
auto x108 = -cell[6];
auto x109 = x108 + cell[20];
auto x110 = x78 + cell[24];
auto x111 = x109 + x110;
auto x112 = x100*x97 + x107 + x111 + x42 + x71;
auto x113 = x50 + cell[25];
auto x114 = x113 + x48;
auto x115 = x104 + x93;
auto x116 = -cell[8];
auto x117 = x116 + cell[22];
auto x118 = x117 + cell[24];
auto x119 = x114 + x115 + x118 + x34*x83*x97 + x70;
auto x120 = V{1} / (V{3.00000046417339}*util::sqrt(x34*(x32*x32)*util::sqrt(x106*x106 + x112*x112 + x119*x119 + V{0.5}*(x67*x67) + V{0.5}*(x86*x86) + V{0.5}*(x99*x99)) + V{0.0277777691819762}/((x31)*(x31))) + V{0.5}/x31);
auto x121 = V{1} / ((x33)*(x33));
auto x122 = V{1.5}*x121;
auto x123 = x73 + cell[19];
auto x124 = cell[14] - cell[1];
auto x125 = x102 + x124;
auto x126 = x104 + cell[26];
auto x127 = x111 + x123 + x125 + x126 + x29 + x77 + x89;
auto x128 = x127*x127;
auto x129 = x122*x128;
auto x130 = x107 + cell[21];
auto x131 = cell[15] - cell[2];
auto x132 = x131 + x87;
auto x133 = x101 + cell[5];
auto x134 = x133 + x43;
auto x135 = x118 + x130 + x132 + x134 + x29 + x49 + x91;
auto x136 = x135*x135;
auto x137 = x122*x136;
auto x138 = x44 + x74;
auto x139 = cell[16] - cell[3];
auto x140 = x139 + x48;
auto x141 = x116 + cell[9];
auto x142 = x108 + cell[19] + cell[7];
auto x143 = x46 + cell[11] + cell[23];
auto x144 = x130 + x138 + x140 + x141 + x142 + x143 + x78 + cell[25];
auto x145 = x144*x144;
auto x146 = x122*x145;
auto x147 = x137 + x146 + V{-1};
auto x148 = x129 + x147;
auto x149 = V{1} - x120;
auto x150 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x151 = V{3}*cell[14];
auto x152 = V{3}*cell[1];
auto x153 = V{3}*cell[17];
auto x154 = V{3}*cell[23];
auto x155 = V{3}*cell[24];
auto x156 = V{3}*cell[4];
auto x157 = V{3}*cell[10];
auto x158 = -x157;
auto x159 = V{3}*cell[11];
auto x160 = -x159;
auto x161 = x153 + x154 + x155 - x156 + x158 + x160;
auto x162 = V{3}*cell[19];
auto x163 = V{3}*cell[25];
auto x164 = V{3}*cell[6];
auto x165 = V{3}*cell[12];
auto x166 = -x165;
auto x167 = x162 + x163 - x164 + x166;
auto x168 = V{3}*cell[18];
auto x169 = V{3}*cell[26];
auto x170 = V{3}*cell[5];
auto x171 = V{3}*cell[13];
auto x172 = -x171;
auto x173 = x168 + x169 - x170 + x172;
auto x174 = V{3}*cell[20];
auto x175 = V{3}*cell[7];
auto x176 = x174 - x175;
auto x177 = x34*(x151 - x152 + x161 + x167 + x173 + x176);
auto x178 = V{3}*x121;
auto x179 = V{3}*cell[15];
auto x180 = V{3}*cell[2];
auto x181 = V{3}*cell[21];
auto x182 = V{3}*cell[8];
auto x183 = -x169;
auto x184 = x171 + x181 - x182 + x183;
auto x185 = V{3}*cell[22];
auto x186 = V{3}*cell[9];
auto x187 = -x163;
auto x188 = x165 + x185 - x186 + x187;
auto x189 = -x168 + x170;
auto x190 = x34*(x161 + x179 - x180 + x184 + x188 + x189);
auto x191 = x129 + V{-1};
auto x192 = V{3}*cell[16];
auto x193 = V{3}*cell[3];
auto x194 = -x155;
auto x195 = x159 - x185 + x186 + x194;
auto x196 = -x174 + x175;
auto x197 = x34*(x154 + x158 + x167 + x184 + x192 - x193 + x195 + x196);
auto x198 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x199 = V{4.5}*x121;
auto x200 = V{2}*cell[10];
auto x201 = V{2}*cell[23];
auto x202 = -x200 + x201;
auto x203 = x131 + x202;
auto x204 = V{2}*cell[11];
auto x205 = -x204;
auto x206 = V{2}*cell[24];
auto x207 = x205 + x206 + x90;
auto x208 = x109 + x124 + x88;
auto x209 = V{2}*cell[4];
auto x210 = V{2}*cell[17];
auto x211 = -x209 + x210;
auto x212 = x117 + x203 + x207 + x208 + x211 + x30;
auto x213 = x148 + x177;
auto x214 = x190 + x213;
auto x215 = x39 + x51 + cell[6];
auto x216 = V{2}*cell[26];
auto x217 = V{2}*cell[13];
auto x218 = -x216 + x217;
auto x219 = x218 + cell[21];
auto x220 = V{2}*cell[25];
auto x221 = -x220;
auto x222 = V{2}*cell[12];
auto x223 = x221 + x222 + x90;
auto x224 = V{2}*cell[18];
auto x225 = V{2}*cell[5];
auto x226 = -x224 + x225;
auto x227 = x131 + x226;
auto x228 = x117 + x215 + x219 + x223 + x227 + x44;
auto x229 = -x190;
auto x230 = x213 + x229;
auto x231 = x139 + x141;
auto x232 = x220 - x222;
auto x233 = x125 + cell[17];
auto x234 = V{2}*cell[6];
auto x235 = V{2}*cell[19];
auto x236 = -x234 + x235;
auto x237 = x202 + x231 + x232 + x233 + x236 + x75 + cell[21];
auto x238 = -x197;
auto x239 = x204 - x206;
auto x240 = x239 + cell[4];
auto x241 = V{2}*cell[20];
auto x242 = V{2}*cell[7];
auto x243 = -x241 + x242;
auto x244 = x243 + x51;
auto x245 = x37 + x43;
auto x246 = x219 + x231 + x240 + x244 + x245 + x74;
auto x247 = V{2}*cell[8];
auto x248 = V{2}*cell[21];
auto x249 = -x247 + x248;
auto x250 = x139 + x249;
auto x251 = x133 + x142 + x203 + x218 + x250 + x45 + cell[17];
auto x252 = x148 + x190;
auto x253 = x197 + x252;
auto x254 = x232 + x79;
auto x255 = V{2}*cell[22];
auto x256 = V{2}*cell[9];
auto x257 = x139 - x255 + x256;
auto x258 = x108 + x123 + x240 + x254 + x257 + x44 + x82 + cell[7];
auto x259 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x260 = V{3}*cell[10];
auto x261 = V{3}*cell[23];
auto x262 = x124 + x236;
auto x263 = x131 + x211;
auto x264 = x103 + x110 + x140 + x249 - x260 + x261 + x262 + x263;
auto x265 = V{3}*cell[24];
auto x266 = V{3}*cell[11];
auto x267 = x209 - x210;
auto x268 = x114 + x243 + x257 - x265 + x266 + x267 + x52 + x81;
auto x269 = -x235;
auto x270 = V{3}*cell[25];
auto x271 = V{3}*cell[12];
auto x272 = -x256;
auto x273 = x92 + cell[3];
auto x274 = x255 + x272 + x273;
auto x275 = x132 + x226 + x234 + x269 - x270 + x271 + x274 + x48 + x53 + cell[10] + cell[24];
auto x276 = -x154;
auto x277 = -x153 + x156;
auto x278 = -x162 + x164;
auto x279 = x34*(-x151 + x152 + x157 + x159 + x165 + x171 + x183 + x187 + x189 + x194 + x196 + x276 + x277 + x278);
auto x280 = V{3}*cell[26];
auto x281 = V{3}*cell[13];
auto x282 = x105 + x227 + x244 + x250 - x280 + x281 + x41 + cell[23];
auto x283 = x157 - x181 + x182 + x276;
auto x284 = x34*(x155 + x160 + x169 + x172 + x176 + x188 - x192 + x193 + x278 + x283);
auto x285 = x122*x84;
auto x286 = x122*x98 + V{-1};
auto x287 = x285 + x286;
auto x288 = x34*(x163 + x166 + x173 - x179 + x180 + x195 + x277 + x283);
auto x289 = x122*x55;
auto x290 = x288 + x289;
auto x291 = x284 + x287 + x290;
auto x292 = x279 + x287;
auto x293 = x284 + x289;
auto x294 = x69 + cell[8];
auto x295 = x200 - x201;
auto x296 = x295 + x79;
auto x297 = x138 + x215 + x239 + x267 + x294 + x296;
auto x298 = x290 + x292;
auto x299 = -x177;
auto x300 = x216 - x217;
auto x301 = x224 - x225;
auto x302 = x208 + x254 + x294 + x300 + x301 + x74 + cell[19];
auto x303 = x273 + cell[4];
auto x304 = x234 + x269 + x51;
auto x305 = x95 + cell[8];
auto x306 = x223 + x245 + x295 + x303 + x304 + x305;
auto x307 = x292 + x293;
auto x308 = x300 + x73;
auto x309 = x241 - x242 + x273;
auto x310 = x207 + x233 + x305 + x308 + x309;
auto x311 = x148 + x197;
auto x312 = x247 - x248;
auto x313 = x88 + x96 + cell[6];
auto x314 = x296 + x303 + x308 + x312 + x313 + x82;
auto x315 = x131 + x134 + x205 + x206 + x221 + x222 + x274 + x313 + cell[17];
auto x316 = x260 - x261 + x267 + x304 + x312 + x41 + x46 + x79 + x94 + cell[26];
auto x317 = x124 + x309;
auto x318 = x115 + x255 + x263 + x265 - x266 + x272 + x317 + x40 + cell[23] + cell[26];
auto x319 = x126 + x143 + x257 + x262 + x270 - x271 + x301 + x76 + x79;
auto x320 = x110 + x113 + x280 - x281 + x301 + x312 + x317 + x80 + x87;
cell[0] = -x120*(x148*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{0.296296296296296}) + V{1}*x149*cell[0];
cell[1] = -x120*(x150*(-x128*x178 + x147 + x177) + V{0.0740740740740741}) + V{1}*x149*cell[1];
cell[2] = -x120*(x150*(-x136*x178 + x146 + x190 + x191) + V{0.0740740740740741}) + V{1}*x149*cell[2];
cell[3] = -x120*(x150*(x137 - x145*x178 + x191 + x197) + V{0.0740740740740741}) + V{1}*x149*cell[3];
cell[4] = -x120*(x198*(-x199*x212*x212 + x214) + V{0.0185185185185185}) + V{1}*x149*cell[4];
cell[5] = -x120*(x198*(-x199*x228*x228 + x230) + V{0.0185185185185185}) + V{1}*x149*cell[5];
cell[6] = -x120*(x198*(x197 - x199*x237*x237 + x213) + V{0.0185185185185185}) + V{1}*x149*cell[6];
cell[7] = -x120*(x198*(-x199*x246*x246 + x213 + x238) + V{0.0185185185185185}) + V{1}*x149*cell[7];
cell[8] = -x120*(x198*(-x199*x251*x251 + x253) + V{0.0185185185185185}) + V{1}*x149*cell[8];
cell[9] = -x120*(x198*(-x199*x258*x258 + x238 + x252) + V{0.0185185185185185}) + V{1}*x149*cell[9];
cell[10] = -x120*(x259*(x197 - x199*x264*x264 + x214) + V{0.00462962962962963}) + V{1}*x149*cell[10];
cell[11] = -x120*(x259*(-x199*x268*x268 + x214 + x238) + V{0.00462962962962963}) + V{1}*x149*cell[11];
cell[12] = -x120*(x259*(x197 - x199*x275*x275 + x230) + V{0.00462962962962963}) + V{1}*x149*cell[12];
cell[13] = -x120*(x259*(-x199*x282*x282 - x279 + x291) + V{0.00462962962962963}) + V{1}*x149*cell[13];
cell[14] = -x120*(x150*(-x178*x55 + x292) + V{0.0740740740740741}) + V{1}*x149*cell[14];
cell[15] = -x120*(x150*(-x178*x84 + x286 + x290) + V{0.0740740740740741}) + V{1}*x149*cell[15];
cell[16] = -x120*(x150*(-x178*x98 + x285 + x293 + V{-1}) + V{0.0740740740740741}) + V{1}*x149*cell[16];
cell[17] = -x120*(x198*(-x199*x297*x297 + x298) + V{0.0185185185185185}) + V{1}*x149*cell[17];
cell[18] = -x120*(x198*(-x199*x302*x302 + x252 + x299) + V{0.0185185185185185}) + V{1}*x149*cell[18];
cell[19] = -x120*(x198*(-x199*x306*x306 + x307) + V{0.0185185185185185}) + V{1}*x149*cell[19];
cell[20] = -x120*(x198*(-x199*x310*x310 + x299 + x311) + V{0.0185185185185185}) + V{1}*x149*cell[20];
cell[21] = -x120*(x198*(-x199*x314*x314 + x291) + V{0.0185185185185185}) + V{1}*x149*cell[21];
cell[22] = -x120*(x198*(-x199*x315*x315 + x229 + x311) + V{0.0185185185185185}) + V{1}*x149*cell[22];
cell[23] = -x120*(x259*(-x199*x316*x316 + x284 + x298) + V{0.00462962962962963}) + V{1}*x149*cell[23];
cell[24] = -x120*(x259*(-x199*x318*x318 - x284 + x298) + V{0.00462962962962963}) + V{1}*x149*cell[24];
cell[25] = -x120*(x259*(-x199*x319*x319 - x288 + x307) + V{0.00462962962962963}) + V{1}*x149*cell[25];
cell[26] = -x120*(x259*(-x199*x320*x320 + x253 + x299) + V{0.00462962962962963}) + V{1}*x149*cell[26];
return { x33, V{1}*x121*(x55 + x84 + x98) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x0 = cell[12] + cell[25];
auto x1 = x0 + cell[18];
auto x2 = cell[11] + cell[24];
auto x3 = x2 + cell[20];
auto x4 = cell[22] + cell[9];
auto x5 = cell[13] + cell[1];
auto x6 = cell[26] + cell[2] + cell[8];
auto x7 = cell[10] + cell[3];
auto x8 = V{1} / (x1 + x3 + x4 + x5 + x6 + x7 + cell[0] + cell[14] + cell[15] + cell[16] + cell[17] + cell[19] + cell[21] + cell[23] + cell[4] + cell[5] + cell[6] + cell[7] + V{1});
auto x9 = V{1}*x8;
auto x10 = -cell[17];
auto x11 = -cell[24];
auto x12 = x10 + x11 + cell[5];
auto x13 = -cell[19];
auto x14 = -cell[25];
auto x15 = x13 + x14 + cell[7];
auto x16 = -cell[23];
auto x17 = x16 - cell[26];
auto x18 = cell[10] + cell[11] + cell[4];
auto x19 = cell[12] + cell[6];
auto x20 = x12 + x15 + x17 + x18 + x19 + x5 - cell[14] - cell[18] - cell[20];
auto x21 = V{0.666666666666667}*cell[10];
auto x22 = V{0.666666666666667}*cell[11];
auto x23 = V{0.666666666666667}*cell[12];
auto x24 = V{0.666666666666667}*cell[13];
auto x25 = V{0.666666666666667}*cell[23];
auto x26 = V{0.666666666666667}*cell[24];
auto x27 = V{0.666666666666667}*cell[25];
auto x28 = V{0.666666666666667}*cell[26];
auto x29 = -V{0.333333333333333}*cell[0];
auto x30 = x21 + x22 + x23 + x24 + x25 + x26 + x27 + x28 + x29 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x33 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x34 = x30 + x33 - x9*x20*x20 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x35 = -cell[12];
auto x36 = -cell[13] - cell[21];
auto x37 = x16 + x36;
auto x38 = x10 + x11 + x18 + x35 + x37 + x6 - cell[15] + cell[18] - cell[22] + cell[25] - cell[5] + cell[9];
auto x39 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x40 = x30 + x39 - x9*x38*x38 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x41 = -cell[11];
auto x42 = x13 + x14 + x19 + x37 + x41 + x7 - cell[16] + cell[20] + cell[22] + cell[24] + cell[26] - cell[7] + cell[8] - cell[9];
auto x43 = x21 + x22 + x23 + x24 + x25 + x26 + x27 + x28 + x29 + x33 + x39 - x9*x42*x42 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x44 = x20*x8;
auto x45 = -cell[10];
auto x46 = x16 + x45 + cell[13] + cell[26];
auto x47 = x1 + x12 + x38*x44 + x41 + x46 - cell[4];
auto x48 = x15 + x3 + x35 + x42*x44 + x46 - cell[6];
auto x49 = x0 + x17 + x2 + x36 + x38*x42*x8 + x4 + x45 - cell[8];
return V{1} / (V{3.00000046417339}*util::sqrt(x8*(x32*x32)*util::sqrt(V{0.5}*(x34*x34) + V{0.5}*(x40*x40) + V{0.5}*(x43*x43) + x47*x47 + x48*x48 + x49*x49) + V{0.0277777691819762}/((x31)*(x31))) + V{0.5}/x31);
}

};


template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D2Q9<FIELDS...>,momenta::ForcedWithStress<momenta::BulkTuple>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x10 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x9 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x11 = cell[7] + cell[8];
auto x14 = cell[2] + cell[3];
auto x15 = x11 + x14 + cell[0] + cell[1] + cell[4] + cell[5] + cell[6];
auto x16 = x15 + V{1};
auto x17 = V{1} / (x16);
auto x18 = V{1}*cell[3];
auto x19 = V{1}*cell[1];
auto x20 = -x19;
auto x21 = V{1}*x17;
auto x22 = cell[1] - cell[5];
auto x23 = x14 + x22 - cell[6] - cell[7];
auto x24 = x11 + x22 - cell[3] - cell[4];
auto x25 = x23*x24;
auto x26 = x15 + V{1};
auto x27 = x26*(x10*x23 - x24*x9);
auto x28 = V{1}*cell[7];
auto x29 = V{1}*cell[5];
auto x30 = -x29;
auto x31 = x28 + x30;
auto x32 = x17*x26;
auto x33 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x34 = -x17*x23*x23 - x23*x32*x9 + x33 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x35 = x10*x24*x32 - x17*x24*x24 + x33 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x36 = V{1} / (V{2.52268963608289}*util::sqrt(x17*(x13*x13)*util::sqrt((-V{0.5}*x17*x27 + x18 + x20 + x21*x25 + x31)*(V{2}*x17*x25 - x21*x27 - V{2}*cell[1] + V{2}*cell[3] - V{2}*cell[5] + V{2}*cell[7]) + x34*x34 + x35*x35) + V{0.0392836979096202}/((x12)*(x12))) + V{0.5}/x12);
auto x37 = V{0.5}*x10;
auto x38 = V{1}*cell[8];
auto x39 = -x18;
auto x40 = V{1}*cell[4];
auto x41 = x17*(x19 + x31 + x38 + x39 - x40);
auto x42 = x37 + x41;
auto x43 = x42*x42;
auto x44 = V{1.5}*x43;
auto x45 = V{0.5}*x9;
auto x46 = V{1}*cell[6];
auto x47 = V{1}*cell[2];
auto x48 = x17*(x20 + x28 + x29 + x39 + x46 - x47) + x45;
auto x49 = x44 + V{-1} + V{1.5}*(x48*x48);
auto x50 = V{1} - x36;
auto x51 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x52 = V{1.5}*x9;
auto x53 = -x52;
auto x54 = V{3}*cell[2];
auto x55 = V{3}*cell[3];
auto x56 = V{3}*cell[6];
auto x57 = V{3}*cell[7];
auto x58 = V{3}*cell[1];
auto x59 = V{3}*cell[5];
auto x60 = x58 - x59;
auto x61 = x17*(x54 + x55 - x56 - x57 + x60);
auto x62 = x17*(x18 + x19 - x28 + x30 - x46 + x47);
auto x63 = V{2.25}*x9;
auto x64 = V{4.5}*cell[2];
auto x65 = V{4.5}*cell[3];
auto x66 = V{4.5}*cell[6];
auto x67 = V{4.5}*cell[7];
auto x68 = V{4.5}*cell[1];
auto x69 = V{4.5}*cell[5];
auto x70 = x68 - x69;
auto x71 = x17*(x64 + x65 - x66 - x67 + x70);
auto x72 = V{2.25}*x10;
auto x73 = -x65 + x67;
auto x74 = x17*(x70 + x73 - V{4.5}*cell[4] + V{4.5}*cell[8]);
auto x75 = x72 + x74;
auto x76 = -x55 + x57;
auto x77 = V{1.5}*x10 + x17*(x60 + x76 - V{3}*cell[4] + V{3}*cell[8]);
auto x78 = x45 - x62;
auto x79 = x78*x78;
auto x80 = -x44 - V{1.5}*x79 + V{1};
auto x81 = x77 + x80;
auto x82 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x83 = x17*(-x64 + x66 - x68 + x69 + x73) + x63;
auto x84 = x17*(-x54 + x56 - x58 + x59 + x76);
auto x85 = x49 + x52 + x84;
auto x86 = x42*x75;
auto x87 = x49 + x77;
auto x88 = x63 - x71;
auto x89 = x52 - x61 + x80;
cell[0] = -x36*(x49*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + V{0.444444444444444}) + V{1}*x50*cell[0];
cell[1] = x19*x50 + x36*(x51*(x53 + x61 + x81 + (x42 - x45 + x62)*(-x63 + x71 + x75)) + V{-0.0277777777777778});
cell[2] = -x36*(x82*(-x48*x83 + x85) + V{0.111111111111111}) + x47*x50;
cell[3] = x18*x50 - x36*(x51*(x77 + x85 - (x42 + x48)*(x75 + x83)) + V{0.0277777777777778});
cell[4] = -x36*(x82*(-x86 + x87) + V{0.111111111111111}) + x40*x50;
cell[5] = x29*x50 - x36*(x51*(x53 - x84 + x87 - (-x37 - x41 + x48)*(-x72 - x74 + x83)) + V{0.0277777777777778});
cell[6] = x36*(x82*(x78*x88 + x89) + V{-0.111111111111111}) + x46*x50;
cell[7] = x28*x50 + x36*(x51*(x77 + x89 + (x42 + x78)*(x75 + x88)) + V{-0.0277777777777778});
cell[8] = x36*(x82*(x81 + x86) + V{-0.111111111111111}) + x38*x50;
return { x16, x43 + x79 };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x10 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x9 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = cell[7] + cell[8];
auto x1 = cell[2] + cell[3];
auto x2 = x0 + x1 + cell[0] + cell[1] + cell[4] + cell[5] + cell[6];
auto x3 = V{1} / (x2 + V{1});
auto x4 = V{1}*x3;
auto x5 = cell[1] - cell[5];
auto x6 = x1 + x5 - cell[6] - cell[7];
auto x7 = x0 + x5 - cell[3] - cell[4];
auto x8 = x6*x7;
auto x11 = x2 + V{1};
auto x14 = x11*(x10*x6 - x7*x9);
auto x15 = x11*x3;
auto x16 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x17 = -x15*x6*x9 + x16 - x3*x6*x6 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x18 = x10*x15*x7 + x16 - x3*x7*x7 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
return V{1} / (V{2.52268963608289}*util::sqrt(x3*(x13*x13)*util::sqrt((-V{0.5}*x14*x3 + x4*x8 - V{1}*cell[1] + V{1}*cell[3] - V{1}*cell[5] + V{1}*cell[7])*(-x14*x4 + V{2}*x3*x8 - V{2}*cell[1] + V{2}*cell[3] - V{2}*cell[5] + V{2}*cell[7]) + x17*x17 + x18*x18) + V{0.0392836979096202}/((x12)*(x12))) + V{0.5}/x12);
}

};

template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D3Q19<FIELDS...>,momenta::ForcedWithStress<momenta::BulkTuple>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x19 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x20 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x22 = cell[12] + cell[7] + cell[9];
auto x25 = cell[10] + cell[14] + cell[16];
auto x26 = cell[11] + cell[18] + cell[5];
auto x27 = x22 + x25 + x26 + cell[0] + cell[13] + cell[15] + cell[17] + cell[1] + cell[2] + cell[3] + cell[4] + cell[6] + cell[8];
auto x28 = x27 + V{1};
auto x29 = V{1} / (x28);
auto x30 = V{1}*cell[6];
auto x31 = V{1}*cell[16];
auto x32 = -x31;
auto x33 = cell[15] - cell[6];
auto x34 = cell[17] - cell[8];
auto x35 = x22 + x33 + x34 - cell[16] - cell[18] - cell[3];
auto x36 = cell[13] - cell[4];
auto x37 = x25 + x33 + x36 - cell[1] - cell[5] - cell[7];
auto x38 = x29*(x27 + V{1});
auto x39 = V{0.5}*x38;
auto x40 = x29*x37;
auto x41 = V{1}*x40;
auto x42 = V{1}*cell[15];
auto x43 = V{1}*cell[7];
auto x44 = x42 - x43;
auto x45 = x30 + x32 - x35*x41 + x39*(x19*x35 + x21*x37) + x44;
auto x46 = V{1}*cell[4];
auto x47 = V{1}*cell[14];
auto x48 = -x47;
auto x49 = x26 + x34 + x36 - cell[14] - cell[2] - cell[9];
auto x50 = x19*x49 + x20*x37;
auto x51 = V{1}*cell[13];
auto x52 = V{1}*cell[5];
auto x53 = x51 - x52;
auto x54 = V{1}*x38;
auto x55 = V{2}*x49;
auto x56 = V{1}*cell[8];
auto x57 = V{1}*cell[18];
auto x58 = -x57;
auto x59 = x20*x35 + x21*x49;
auto x60 = x29*x35;
auto x61 = V{1}*cell[17];
auto x62 = V{1}*cell[9];
auto x63 = x61 - x62;
auto x64 = V{0.333333333333333}*cell[8];
auto x65 = V{0.333333333333333}*cell[9];
auto x66 = V{0.333333333333333}*cell[17];
auto x67 = V{0.333333333333333}*cell[18];
auto x68 = V{0.333333333333333}*cell[0];
auto x69 = -x68;
auto x70 = V{0.333333333333333}*cell[3];
auto x71 = V{0.333333333333333}*cell[12];
auto x72 = x69 - x70 - x71 + V{0.666666666666667}*cell[13] + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x73 = V{0.333333333333333}*cell[2];
auto x74 = V{0.333333333333333}*cell[11];
auto x75 = -x73 - x74 + V{0.666666666666667}*cell[15] + V{0.666666666666667}*cell[16] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x76 = x19*x37*x38 - x29*x37*x37 - x64 - x65 - x66 - x67 + x72 + x75 + V{0.666666666666667}*cell[10] + V{0.666666666666667}*cell[1];
auto x77 = V{0.333333333333333}*cell[6];
auto x78 = V{0.333333333333333}*cell[7];
auto x79 = V{0.333333333333333}*cell[15];
auto x80 = V{0.333333333333333}*cell[16];
auto x81 = V{0.333333333333333}*cell[1];
auto x82 = V{0.333333333333333}*cell[10];
auto x83 = -x81 - x82 + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x84 = x20*x38*x49 - x29*x49*x49 + x72 - x77 - x78 - x79 - x80 + x83 + V{0.666666666666667}*cell[11] + V{0.666666666666667}*cell[2];
auto x85 = V{0.333333333333333}*cell[4];
auto x86 = V{0.333333333333333}*cell[5];
auto x87 = V{0.333333333333333}*cell[13];
auto x88 = V{0.333333333333333}*cell[14];
auto x89 = x21*x35*x38 - x29*x35*x35 + x69 + x75 + x83 - x85 - x86 - x87 - x88 + V{0.666666666666667}*cell[12] + V{0.666666666666667}*cell[3];
auto x90 = V{1} / (V{3.00000046417339}*util::sqrt(x29*(x24*x24)*util::sqrt(V{0.5}*(x39*x50 - x41*x49 + x46 + x48 + x53)*(-x40*x55 + x50*x54 + V{2}*cell[13] - V{2}*cell[14] + V{2}*cell[4] - V{2}*cell[5]) + V{0.5}*(x39*x59 - V{1}*x49*x60 + x56 + x58 + x63)*(x54*x59 - x55*x60 + V{2}*cell[17] - V{2}*cell[18] + V{2}*cell[8] - V{2}*cell[9]) + x45*x45 + V{0.5}*(x76*x76) + V{0.5}*(x84*x84) + V{0.5}*(x89*x89)) + V{0.0277777691819762}/((x23)*(x23))) + V{0.5}/x23);
auto x91 = V{0.5}*x19;
auto x92 = V{1}*cell[10];
auto x93 = V{1}*cell[1];
auto x94 = -x46;
auto x95 = -x30;
auto x96 = x29*(x31 + x44 + x47 + x53 + x92 - x93 + x94 + x95);
auto x97 = x91 + x96;
auto x98 = x97*x97;
auto x99 = V{1.5}*x98;
auto x100 = V{0.5}*x20;
auto x101 = V{1}*cell[11];
auto x102 = V{1}*cell[2];
auto x103 = -x56;
auto x104 = x29*(x101 - x102 + x103 + x48 + x51 + x52 + x57 + x63 + x94);
auto x105 = x100 + x104;
auto x106 = x105*x105;
auto x107 = V{1.5}*x106;
auto x108 = V{0.5}*x21;
auto x109 = V{1}*cell[12];
auto x110 = V{1}*cell[3];
auto x111 = x29*(x103 + x109 - x110 + x32 + x42 + x43 + x58 + x61 + x62 + x95);
auto x112 = x108 + x111;
auto x113 = x112*x112;
auto x114 = V{1.5}*x113;
auto x115 = x107 + x114 + x99 + V{-1};
auto x116 = V{1} - x90;
auto x117 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x118 = V{2.25}*x19;
auto x119 = V{4.5}*cell[14];
auto x120 = V{4.5}*cell[16];
auto x121 = V{4.5}*cell[5];
auto x122 = V{4.5}*cell[7];
auto x123 = V{4.5}*cell[13] - V{4.5}*cell[4];
auto x124 = V{4.5}*cell[15] - V{4.5}*cell[6];
auto x125 = x29*(x119 + x120 - x121 - x122 + x123 + x124 + V{4.5}*cell[10] - V{4.5}*cell[1]);
auto x126 = x118 + x125;
auto x127 = x126*x97;
auto x128 = V{1.5}*x19;
auto x129 = V{3}*cell[14];
auto x130 = V{3}*cell[16];
auto x131 = V{3}*cell[5];
auto x132 = V{3}*cell[7];
auto x133 = V{3}*cell[13] - V{3}*cell[4];
auto x134 = V{3}*cell[15] - V{3}*cell[6];
auto x135 = x29*(x129 + x130 - x131 - x132 + x133 + x134 + V{3}*cell[10] - V{3}*cell[1]);
auto x136 = x128 + x135;
auto x137 = x115 + x136;
auto x138 = V{2.25}*x20;
auto x139 = V{4.5}*cell[18];
auto x140 = V{4.5}*cell[9];
auto x141 = V{4.5}*cell[17] - V{4.5}*cell[8];
auto x142 = x29*(-x119 + x121 + x123 + x139 - x140 + x141 + V{4.5}*cell[11] - V{4.5}*cell[2]);
auto x143 = x138 + x142;
auto x144 = x105*x143;
auto x145 = V{1.5}*x20;
auto x146 = V{3}*cell[18];
auto x147 = V{3}*cell[9];
auto x148 = V{3}*cell[17] - V{3}*cell[8];
auto x149 = x29*(-x129 + x131 + x133 + x146 - x147 + x148 + V{3}*cell[11] - V{3}*cell[2]);
auto x150 = x145 + x149;
auto x151 = x115 + x150;
auto x152 = V{2.25}*x21;
auto x153 = x29*(-x120 + x122 + x124 - x139 + x140 + x141 + V{4.5}*cell[12] - V{4.5}*cell[3]);
auto x154 = x152 + x153;
auto x155 = x112*x154;
auto x156 = V{1.5}*x21;
auto x157 = x29*(-x130 + x132 + x134 - x146 + x147 + x148 + V{3}*cell[12] - V{3}*cell[3]);
auto x158 = x156 + x157;
auto x159 = x115 + x158;
auto x160 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x161 = (x105 + x97)*(x126 + x143);
auto x162 = -x91 - x96;
auto x163 = -x118 - x125;
auto x164 = -x145 - x149;
auto x165 = (x112 + x97)*(x126 + x154);
auto x166 = -x156 - x157;
auto x167 = (x105 + x112)*(x143 + x154);
auto x168 = -x100 - x104;
auto x169 = -x138 - x142;
auto x170 = -x107 - x114 - x99 + V{1};
auto x171 = x136 + x170;
auto x172 = x150 + x170;
auto x173 = -x128 - x135;
auto x174 = -x108 - x111;
auto x175 = -x152 - x153;
cell[0] = V{1}*x116*cell[0] - x90*(x115*(x64 + x65 + x66 + x67 + x68 + x70 + x71 + x73 + x74 + x77 + x78 + x79 + x80 + x81 + x82 + x85 + x86 + x87 + x88 + V{0.333333333333333}) + V{0.333333333333333});
cell[1] = x116*x93 - x90*(x117*(-x127 + x137) + V{0.0555555555555556});
cell[2] = x102*x116 - x90*(x117*(-x144 + x151) + V{0.0555555555555556});
cell[3] = x110*x116 - x90*(x117*(-x155 + x159) + V{0.0555555555555556});
cell[4] = x116*x46 - x90*(x160*(x137 + x150 - x161) + V{0.0277777777777778});
cell[5] = x116*x52 - x90*(x160*(x137 + x164 - (x105 + x162)*(x143 + x163)) + V{0.0277777777777778});
cell[6] = x116*x30 - x90*(x160*(x137 + x158 - x165) + V{0.0277777777777778});
cell[7] = x116*x43 - x90*(x160*(x137 + x166 - (x112 + x162)*(x154 + x163)) + V{0.0277777777777778});
cell[8] = x116*x56 - x90*(x160*(x151 + x158 - x167) + V{0.0277777777777778});
cell[9] = x116*x62 - x90*(x160*(x151 + x166 - (x112 + x168)*(x154 + x169)) + V{0.0277777777777778});
cell[10] = x116*x92 + x90*(x117*(x127 + x171) + V{-0.0555555555555556});
cell[11] = x101*x116 + x90*(x117*(x144 + x172) + V{-0.0555555555555556});
cell[12] = x109*x116 + x90*(x117*(x155 + x158 + x170) + V{-0.0555555555555556});
cell[13] = x116*x51 + x90*(x160*(x150 + x161 + x171) + V{-0.0277777777777778});
cell[14] = x116*x47 - x90*(x160*(x151 + x173 - (x126 + x169)*(x168 + x97)) + V{0.0277777777777778});
cell[15] = x116*x42 + x90*(x160*(x158 + x165 + x171) + V{-0.0277777777777778});
cell[16] = x116*x31 - x90*(x160*(x159 + x173 - (x126 + x175)*(x174 + x97)) + V{0.0277777777777778});
cell[17] = x116*x61 + x90*(x160*(x158 + x167 + x172) + V{-0.0277777777777778});
cell[18] = x116*x57 - x90*(x160*(x159 + x164 - (x105 + x174)*(x143 + x175)) + V{0.0277777777777778});
return { x28, x106 + x113 + x98 };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x21 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x19 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x20 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x0 = cell[12] + cell[7] + cell[9];
auto x1 = cell[10] + cell[14] + cell[16];
auto x2 = cell[11] + cell[18] + cell[5];
auto x3 = x0 + x1 + x2 + cell[0] + cell[13] + cell[15] + cell[17] + cell[1] + cell[2] + cell[3] + cell[4] + cell[6] + cell[8];
auto x4 = V{1} / (x3 + V{1});
auto x5 = cell[15] - cell[6];
auto x6 = cell[17] - cell[8];
auto x7 = x0 + x5 + x6 - cell[16] - cell[18] - cell[3];
auto x8 = cell[13] - cell[4];
auto x9 = x1 + x5 + x8 - cell[1] - cell[5] - cell[7];
auto x10 = x4*(x3 + V{1});
auto x11 = V{0.5}*x10;
auto x12 = x4*x9;
auto x13 = V{1}*x12;
auto x14 = x11*(x19*x7 + x21*x9) - x13*x7 + V{1}*cell[15] - V{1}*cell[16] + V{1}*cell[6] - V{1}*cell[7];
auto x15 = x2 + x6 + x8 - cell[14] - cell[2] - cell[9];
auto x16 = x15*x19 + x20*x9;
auto x17 = V{1}*x10;
auto x18 = V{2}*x15;
auto x22 = x15*x21 + x20*x7;
auto x25 = x4*x7;
auto x26 = -V{0.333333333333333}*cell[0];
auto x27 = x26 - V{0.333333333333333}*cell[12] + V{0.666666666666667}*cell[13] + V{0.666666666666667}*cell[14] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x28 = -V{0.333333333333333}*cell[11] + V{0.666666666666667}*cell[15] + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x29 = x10*x19*x9 + x27 + x28 - x4*x9*x9 + V{0.666666666666667}*cell[10] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x30 = -V{0.333333333333333}*cell[10] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x31 = x10*x15*x20 + x27 + x30 - x4*x15*x15 + V{0.666666666666667}*cell[11] - V{0.333333333333333}*cell[15] - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x32 = x10*x21*x7 + x26 + x28 + x30 - x4*x7*x7 + V{0.666666666666667}*cell[12] - V{0.333333333333333}*cell[13] - V{0.333333333333333}*cell[14] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
return V{1} / (V{2.52268963608289}*util::sqrt(x4*(x24*x24)*util::sqrt((x11*x16 - x13*x15 + V{1}*cell[13] - V{1}*cell[14] + V{1}*cell[4] - V{1}*cell[5])*(-x12*x18 + x16*x17 + V{2}*cell[13] - V{2}*cell[14] + V{2}*cell[4] - V{2}*cell[5]) + (x11*x22 - V{1}*x15*x25 + V{1}*cell[17] - V{1}*cell[18] + V{1}*cell[8] - V{1}*cell[9])*(x17*x22 - x18*x25 + V{2}*cell[17] - V{2}*cell[18] + V{2}*cell[8] - V{2}*cell[9]) + 2*(x14*x14) + x29*x29 + x31*x31 + x32*x32) + V{0.0392836979096202}/((x23)*(x23))) + V{0.5}/x23);
}

};

template <typename... FIELDS>
struct SmagorinskyEffectiveOmega<BGK,descriptors::D3Q27<FIELDS...>,momenta::ForcedWithStress<momenta::BulkTuple>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x29 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x27 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x28 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x30 = cell[20] + cell[22] + cell[24] + cell[3];
auto x33 = cell[13] + cell[1] + cell[5] + cell[7];
auto x34 = cell[10] + cell[18] + cell[25] + cell[2] + cell[9];
auto x35 = x30 + x33 + x34 + cell[0] + cell[11] + cell[12] + cell[14] + cell[15] + cell[16] + cell[17] + cell[19] + cell[21] + cell[23] + cell[26] + cell[4] + cell[6] + cell[8];
auto x36 = x35 + V{1};
auto x37 = V{1} / (x36);
auto x38 = -cell[23];
auto x39 = x38 + cell[10] + cell[12] - cell[19] - cell[25] + cell[6];
auto x40 = -cell[13] - cell[21] + cell[26] + cell[8];
auto x41 = x30 + x39 + x40 - cell[11] - cell[16] - cell[7] - cell[9];
auto x42 = cell[11] - cell[17] - cell[24] + cell[4];
auto x43 = x33 + x39 + x42 - cell[14] - cell[18] - cell[20] - cell[26];
auto x44 = x37*(x35 + V{1});
auto x45 = V{0.5}*x44;
auto x46 = x37*x43;
auto x47 = V{1}*x46;
auto x48 = V{1}*cell[13];
auto x49 = V{1}*cell[26];
auto x50 = V{1}*cell[10];
auto x51 = -x50;
auto x52 = V{1}*cell[23];
auto x53 = -x52;
auto x54 = x48 + x49 + x51 + x53;
auto x55 = V{1}*cell[11];
auto x56 = V{1}*cell[24];
auto x57 = x55 + x56;
auto x58 = V{1}*cell[20];
auto x59 = V{1}*cell[6];
auto x60 = -x59;
auto x61 = V{1}*cell[12];
auto x62 = -x61;
auto x63 = x58 + x60 + x62;
auto x64 = V{1}*cell[7];
auto x65 = V{1}*cell[19];
auto x66 = -x65;
auto x67 = V{1}*cell[25];
auto x68 = -x67;
auto x69 = x64 + x66 + x68;
auto x70 = x41*x47 + x45*(x27*x41 + x29*x43) + x54 + x57 + x63 + x69;
auto x71 = x34 + x38 + x40 + x42 - cell[12] - cell[15] - cell[22] - cell[5];
auto x72 = x27*x71 + x28*x43;
auto x73 = x61 + x67;
auto x74 = V{1}*cell[18];
auto x75 = V{1}*cell[4];
auto x76 = -x75;
auto x77 = -x55;
auto x78 = x74 + x76 + x77;
auto x79 = V{1}*cell[5];
auto x80 = V{1}*cell[17];
auto x81 = -x80;
auto x82 = -x56;
auto x83 = x79 + x81 + x82;
auto x84 = V{2}*cell[13];
auto x85 = V{2}*cell[26];
auto x86 = V{2}*cell[11];
auto x87 = V{2}*cell[24];
auto x88 = V{1}*x44;
auto x89 = V{2}*x71;
auto x90 = -V{2}*cell[10] + V{2}*cell[12] - V{2}*cell[23] + V{2}*cell[25];
auto x91 = x28*x41 + x29*x71;
auto x92 = x37*x41;
auto x93 = -x48;
auto x94 = x51 + x93;
auto x95 = -x49;
auto x96 = x53 + x95;
auto x97 = V{1}*cell[22];
auto x98 = V{1}*cell[8];
auto x99 = -x98;
auto x100 = x97 + x99;
auto x101 = V{1}*cell[9];
auto x102 = V{1}*cell[21];
auto x103 = -x102;
auto x104 = x101 + x103;
auto x105 = V{0.666666666666667}*cell[10];
auto x106 = V{0.666666666666667}*cell[11];
auto x107 = V{0.666666666666667}*cell[12];
auto x108 = V{0.666666666666667}*cell[13];
auto x109 = V{0.666666666666667}*cell[23];
auto x110 = V{0.666666666666667}*cell[24];
auto x111 = V{0.666666666666667}*cell[25];
auto x112 = V{0.666666666666667}*cell[26];
auto x113 = -V{0.333333333333333}*cell[0];
auto x114 = x105 + x106 + x107 + x108 + x109 + x110 + x111 + x112 + x113 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x115 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x116 = x114 + x115 - x27*x43*x44 - x37*x43*x43 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x117 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x118 = x114 + x117 - x28*x44*x71 - x37*x71*x71 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x119 = x105 + x106 + x107 + x108 + x109 + x110 + x111 + x112 + x113 + x115 + x117 - x29*x41*x44 - x37*x41*x41 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x120 = V{1} / (V{3.00000046417339}*util::sqrt(x37*(x32*x32)*util::sqrt(V{0.5}*(x45*x72 + x47*x71 + x54 + x73 + x78 + x83)*(x46*x89 + x72*x88 + x84 + x85 - x86 - x87 + x90 - V{2}*cell[17] + V{2}*cell[18] - V{2}*cell[4] + V{2}*cell[5]) + V{0.5}*(x100 + x104 + x45*x91 + x57 + V{1}*x71*x92 + x73 + x94 + x96)*(-x84 - x85 + x86 + x87 + x88*x91 + x89*x92 + x90 - V{2}*cell[21] + V{2}*cell[22] - V{2}*cell[8] + V{2}*cell[9]) + V{0.5}*(x116*x116) + V{0.5}*(x118*x118) + V{0.5}*(x119*x119) + x70*x70) + V{0.0277777691819762}/((x31)*(x31))) + V{0.5}/x31);
auto x121 = V{0.5}*x27;
auto x122 = V{1}*cell[14];
auto x123 = V{1}*cell[1];
auto x124 = -x64;
auto x125 = x52 + x56 + x80;
auto x126 = x65 + x67;
auto x127 = x49 - x79;
auto x128 = x37*(x122 - x123 + x124 + x125 + x126 + x127 + x63 + x78 + x94);
auto x129 = x121 + x128;
auto x130 = V{0.5}*x28;
auto x131 = V{1}*cell[15];
auto x132 = V{1}*cell[2];
auto x133 = x48 + x61 - x74;
auto x134 = x102 + x51 + x95;
auto x135 = -x101 + x68 + x77;
auto x136 = x37*(x100 + x125 + x131 - x132 + x133 + x134 + x135 + x76 + x79);
auto x137 = x130 + x136;
auto x138 = V{0.5}*x29;
auto x139 = V{1}*cell[16];
auto x140 = V{1}*cell[3];
auto x141 = x55 - x58;
auto x142 = x62 + x82 - x97;
auto x143 = x37*(x101 + x126 + x134 + x139 - x140 + x141 + x142 + x48 + x52 + x60 + x64 + x99);
auto x144 = x138 + x143;
auto x145 = V{-1} + V{1.5}*(x129*x129) + V{1.5}*(x137*x137) + V{1.5}*(x144*x144);
auto x146 = V{1} - x120;
auto x147 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x148 = V{2.25}*x27;
auto x149 = V{4.5}*cell[14];
auto x150 = V{4.5}*cell[1];
auto x151 = V{4.5}*cell[17];
auto x152 = V{4.5}*cell[23];
auto x153 = V{4.5}*cell[24];
auto x154 = V{4.5}*cell[4];
auto x155 = V{4.5}*cell[10];
auto x156 = -x155;
auto x157 = V{4.5}*cell[11];
auto x158 = -x157;
auto x159 = x151 + x152 + x153 - x154 + x156 + x158;
auto x160 = V{4.5}*cell[19];
auto x161 = V{4.5}*cell[25];
auto x162 = V{4.5}*cell[6];
auto x163 = V{4.5}*cell[12];
auto x164 = -x163;
auto x165 = x160 + x161 - x162 + x164;
auto x166 = V{4.5}*cell[18];
auto x167 = V{4.5}*cell[26];
auto x168 = V{4.5}*cell[5];
auto x169 = V{4.5}*cell[13];
auto x170 = -x169;
auto x171 = x166 + x167 - x168 + x170;
auto x172 = V{4.5}*cell[20];
auto x173 = V{4.5}*cell[7];
auto x174 = x172 - x173;
auto x175 = x37*(x149 - x150 + x159 + x165 + x171 + x174);
auto x176 = x148 + x175;
auto x177 = V{1.5}*x27;
auto x178 = V{3}*cell[14];
auto x179 = V{3}*cell[1];
auto x180 = V{3}*cell[17];
auto x181 = V{3}*cell[23];
auto x182 = V{3}*cell[24];
auto x183 = V{3}*cell[4];
auto x184 = V{3}*cell[10];
auto x185 = -x184;
auto x186 = V{3}*cell[11];
auto x187 = -x186;
auto x188 = x180 + x181 + x182 - x183 + x185 + x187;
auto x189 = V{3}*cell[19];
auto x190 = V{3}*cell[25];
auto x191 = V{3}*cell[6];
auto x192 = V{3}*cell[12];
auto x193 = -x192;
auto x194 = x189 + x190 - x191 + x193;
auto x195 = V{3}*cell[18];
auto x196 = V{3}*cell[26];
auto x197 = V{3}*cell[5];
auto x198 = V{3}*cell[13];
auto x199 = -x198;
auto x200 = x195 + x196 - x197 + x199;
auto x201 = V{3}*cell[20];
auto x202 = V{3}*cell[7];
auto x203 = x201 - x202;
auto x204 = x37*(x178 - x179 + x188 + x194 + x200 + x203);
auto x205 = x145 + x177 + x204;
auto x206 = V{2.25}*x28;
auto x207 = V{4.5}*cell[15];
auto x208 = V{4.5}*cell[2];
auto x209 = V{4.5}*cell[21];
auto x210 = V{4.5}*cell[8];
auto x211 = -x167;
auto x212 = x169 + x209 - x210 + x211;
auto x213 = V{4.5}*cell[22];
auto x214 = V{4.5}*cell[9];
auto x215 = -x161;
auto x216 = x163 + x213 - x214 + x215;
auto x217 = -x166 + x168;
auto x218 = x37*(x159 + x207 - x208 + x212 + x216 + x217);
auto x219 = x206 + x218;
auto x220 = V{1.5}*x28;
auto x221 = V{3}*cell[15];
auto x222 = V{3}*cell[2];
auto x223 = V{3}*cell[21];
auto x224 = V{3}*cell[8];
auto x225 = -x196;
auto x226 = x198 + x223 - x224 + x225;
auto x227 = V{3}*cell[22];
auto x228 = V{3}*cell[9];
auto x229 = -x190;
auto x230 = x192 + x227 - x228 + x229;
auto x231 = -x195 + x197;
auto x232 = x37*(x188 + x221 - x222 + x226 + x230 + x231);
auto x233 = x220 + x232;
auto x234 = x145 + x233;
auto x235 = V{2.25}*x29;
auto x236 = V{4.5}*cell[16];
auto x237 = V{4.5}*cell[3];
auto x238 = -x153;
auto x239 = x157 - x172 + x173 + x238;
auto x240 = -x213 + x214;
auto x241 = x37*(x152 + x156 + x165 + x212 + x236 - x237 + x239 + x240);
auto x242 = x235 + x241;
auto x243 = V{1.5}*x29;
auto x244 = V{3}*cell[16];
auto x245 = V{3}*cell[3];
auto x246 = -x182;
auto x247 = x186 - x227 + x228 + x246;
auto x248 = -x201 + x202;
auto x249 = x37*(x181 + x185 + x194 + x226 + x244 - x245 + x247 + x248);
auto x250 = x243 + x249;
auto x251 = x145 + x250;
auto x252 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x253 = x129 + x137;
auto x254 = x176 + x219;
auto x255 = x205 + x233;
auto x256 = -x121;
auto x257 = -x128 + x256;
auto x258 = x137 + x257;
auto x259 = -x148;
auto x260 = -x175 + x259;
auto x261 = x219 + x260;
auto x262 = -x220;
auto x263 = -x232 + x262;
auto x264 = x205 + x263;
auto x265 = x144 + x257;
auto x266 = x242 + x260;
auto x267 = -x243;
auto x268 = -x249 + x267;
auto x269 = x234 + x250;
auto x270 = -x130;
auto x271 = -x136 + x270;
auto x272 = -x206;
auto x273 = -x218 + x272;
auto x274 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x275 = -x138;
auto x276 = -x143 + x275;
auto x277 = -x235;
auto x278 = -x241 + x277;
auto x279 = -x181;
auto x280 = -x180 + x183;
auto x281 = -x189 + x191;
auto x282 = x37*(-x178 + x179 + x184 + x186 + x192 + x198 + x225 + x229 + x231 + x246 + x248 + x279 + x280 + x281);
auto x283 = x50 + x75;
auto x284 = x37*(-x122 + x123 + x133 + x141 + x283 + x59 + x69 + x83 + x96);
auto x285 = x53 + x93 + x98;
auto x286 = x37*(x104 + x127 - x131 + x132 + x142 + x283 + x285 + x55 + x67 + x74 + x81);
auto x287 = x130 - x286;
auto x288 = x37*(x103 + x124 + x135 - x139 + x140 + x285 + x49 + x50 + x56 + x58 + x59 + x61 + x66 + x97);
auto x289 = x138 - x288;
auto x290 = x287 + x289;
auto x291 = -x152;
auto x292 = -x151 + x154 + x155 + x291;
auto x293 = -x160 + x162;
auto x294 = x37*(-x149 + x150 + x163 + x169 + x211 + x215 + x217 + x239 + x292 + x293);
auto x295 = -x209 + x210;
auto x296 = x37*(x157 + x161 + x164 + x171 - x207 + x208 + x238 + x240 + x292 + x295);
auto x297 = x206 - x296;
auto x298 = x37*(x153 + x155 + x158 + x167 + x170 + x174 + x216 - x236 + x237 + x291 + x293 + x295);
auto x299 = x235 - x298;
auto x300 = x297 + x299;
auto x301 = x121 - x284;
auto x302 = x301*x301;
auto x303 = x287*x287;
auto x304 = x289*x289;
auto x305 = V{1.5}*x302 + V{1.5}*x303 + V{1.5}*x304 + V{-1};
auto x306 = x184 - x223 + x224 + x279;
auto x307 = x37*(x190 + x193 + x200 - x221 + x222 + x247 + x280 + x306);
auto x308 = x262 + x307;
auto x309 = x305 + x308;
auto x310 = x37*(x182 + x187 + x196 + x199 + x203 + x230 - x244 + x245 + x281 + x306);
auto x311 = x267 + x310;
auto x312 = x309 + x311;
auto x313 = x148 - x294;
auto x314 = -x177;
auto x315 = x282 + x305 + x314;
auto x316 = x287 + x301;
auto x317 = x297 + x313;
auto x318 = x308 + x315;
auto x319 = x129 + x271;
auto x320 = x176 + x273;
auto x321 = -x204 + x314;
auto x322 = x289 + x301;
auto x323 = x299 + x313;
auto x324 = x311 + x315;
cell[0] = -x120*(x145*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{0.296296296296296}) + V{1}*x146*cell[0];
cell[1] = -x120*(x147*(-x129*x176 + x205) + V{0.0740740740740741}) + x123*x146;
cell[2] = -x120*(x147*(-x137*x219 + x234) + V{0.0740740740740741}) + x132*x146;
cell[3] = -x120*(x147*(-x144*x242 + x251) + V{0.0740740740740741}) + x140*x146;
cell[4] = -x120*(x252*(-x253*x254 + x255) + V{0.0185185185185185}) + x146*x75;
cell[5] = -x120*(x252*(-x258*x261 + x264) + V{0.0185185185185185}) + x146*x79;
cell[6] = -x120*(x252*(x205 + x250 - (x129 + x144)*(x176 + x242)) + V{0.0185185185185185}) + x146*x59;
cell[7] = -x120*(x252*(x205 - x265*x266 + x268) + V{0.0185185185185185}) + x146*x64;
cell[8] = -x120*(x252*(x269 - (x137 + x144)*(x219 + x242)) + V{0.0185185185185185}) + x146*x98;
cell[9] = x101*x146 - x120*(x252*(x234 + x268 - (x144 + x271)*(x242 + x273)) + V{0.0185185185185185});
cell[10] = -x120*(x274*(x250 + x255 - (x144 + x253)*(x242 + x254)) + V{0.00462962962962963}) + x146*x50;
cell[11] = -x120*(x274*(x255 + x268 - (x265 + x271)*(x266 + x273)) + V{0.00462962962962963}) + x146*x55;
cell[12] = -x120*(x274*(x250 + x264 - (x258 + x276)*(x261 + x278)) + V{0.00462962962962963}) + x146*x61;
cell[13] = -x120*(x274*(x177 - x282 + x312 - (x256 + x284 + x290)*(x259 + x294 + x300)) + V{0.00462962962962963}) + x146*x48;
cell[14] = -x120*(x147*(-x301*x313 + x315) + V{0.0740740740740741}) + x122*x146;
cell[15] = -x120*(x147*(-x287*x297 + x309) + V{0.0740740740740741}) + x131*x146;
cell[16] = -x120*(x147*(-x289*x299 + x305 + x311) + V{0.0740740740740741}) + x139*x146;
cell[17] = -x120*(x252*(-x316*x317 + x318) + V{0.0185185185185185}) + x146*x80;
cell[18] = -x120*(x252*(x234 - x319*x320 + x321) + V{0.0185185185185185}) + x146*x74;
cell[19] = -x120*(x252*(-x322*x323 + x324) + V{0.0185185185185185}) + x146*x65;
cell[20] = -x120*(x252*(x251 + x321 - (x129 + x276)*(x176 + x278)) + V{0.0185185185185185}) + x146*x58;
cell[21] = x102*x146 - x120*(x252*(-x290*x300 + x312) + V{0.0185185185185185});
cell[22] = -x120*(x252*(x251 + x263 - (x137 + x276)*(x219 + x278)) + V{0.0185185185185185}) + x146*x97;
cell[23] = -x120*(x274*(x311 + x318 - (x289 + x316)*(x299 + x317)) + V{0.00462962962962963}) + x146*x52;
cell[24] = -x120*(x274*(x243 - x310 + x318 - (x275 + x288 + x316)*(x277 + x298 + x317)) + V{0.00462962962962963}) + x146*x56;
cell[25] = -x120*(x274*(x220 - x307 + x324 - (x270 + x286 + x322)*(x272 + x296 + x323)) + V{0.00462962962962963}) + x146*x67;
cell[26] = -x120*(x274*(x269 + x321 - (x276 + x319)*(x278 + x320)) + V{0.00462962962962963}) + x146*x49;
return { x36, x302 + x303 + x304 };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x29 = cell.template getFieldComponent<olb::descriptors::FORCE>(2);
auto x27 = cell.template getFieldComponent<olb::descriptors::FORCE>(0);
auto x28 = cell.template getFieldComponent<olb::descriptors::FORCE>(1);
auto x0 = cell[20] + cell[22] + cell[24] + cell[3];
auto x1 = cell[13] + cell[1] + cell[5] + cell[7];
auto x2 = cell[10] + cell[18] + cell[25] + cell[2] + cell[9];
auto x3 = x0 + x1 + x2 + cell[0] + cell[11] + cell[12] + cell[14] + cell[15] + cell[16] + cell[17] + cell[19] + cell[21] + cell[23] + cell[26] + cell[4] + cell[6] + cell[8];
auto x4 = V{1} / (x3 + V{1});
auto x5 = V{1}*cell[12];
auto x6 = V{1}*cell[25];
auto x7 = -cell[23];
auto x8 = x7 + cell[10] + cell[12] - cell[19] - cell[25] + cell[6];
auto x9 = -cell[13] - cell[21] + cell[26] + cell[8];
auto x10 = x0 + x8 + x9 - cell[11] - cell[16] - cell[7] - cell[9];
auto x11 = cell[11] - cell[17] - cell[24] + cell[4];
auto x12 = x1 + x11 + x8 - cell[14] - cell[18] - cell[20] - cell[26];
auto x13 = x4*(x3 + V{1});
auto x14 = V{0.5}*x13;
auto x15 = x12*x4;
auto x16 = V{1}*x15;
auto x17 = V{1}*cell[13];
auto x18 = V{1}*cell[26];
auto x19 = -V{1}*cell[10];
auto x20 = -V{1}*cell[23];
auto x21 = x17 + x18 + x19 + x20;
auto x22 = V{1}*cell[11];
auto x23 = V{1}*cell[24];
auto x24 = x22 + x23;
auto x25 = x10*x16 + x14*(x10*x27 + x12*x29) + x21 + x24 - x5 - x6 - V{1}*cell[19] + V{1}*cell[20] - V{1}*cell[6] + V{1}*cell[7];
auto x26 = x11 + x2 + x7 + x9 - cell[12] - cell[15] - cell[22] - cell[5];
auto x30 = x12*x28 + x26*x27;
auto x33 = x5 + x6;
auto x34 = V{2}*cell[13];
auto x35 = V{2}*cell[26];
auto x36 = V{2}*cell[11];
auto x37 = V{2}*cell[24];
auto x38 = V{1}*x13;
auto x39 = V{2}*x26;
auto x40 = -V{2}*cell[10] + V{2}*cell[12] - V{2}*cell[23] + V{2}*cell[25];
auto x41 = x10*x28 + x26*x29;
auto x42 = x10*x4;
auto x43 = V{0.666666666666667}*cell[10];
auto x44 = V{0.666666666666667}*cell[11];
auto x45 = V{0.666666666666667}*cell[12];
auto x46 = V{0.666666666666667}*cell[13];
auto x47 = V{0.666666666666667}*cell[23];
auto x48 = V{0.666666666666667}*cell[24];
auto x49 = V{0.666666666666667}*cell[25];
auto x50 = V{0.666666666666667}*cell[26];
auto x51 = -V{0.333333333333333}*cell[0];
auto x52 = x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x53 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x54 = -x12*x13*x27 - x4*x12*x12 + x52 + x53 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x55 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x56 = -x13*x26*x28 - x4*x26*x26 + x52 + x55 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x57 = -x10*x13*x29 - x4*x10*x10 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x53 + x55 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
return V{1} / (V{2.52268963608289}*util::sqrt(x4*(x32*x32)*util::sqrt((x14*x30 + x16*x26 + x21 - x22 - x23 + x33 - V{1}*cell[17] + V{1}*cell[18] - V{1}*cell[4] + V{1}*cell[5])*(x15*x39 + x30*x38 + x34 + x35 - x36 - x37 + x40 - V{2}*cell[17] + V{2}*cell[18] - V{2}*cell[4] + V{2}*cell[5]) + (-x34 - x35 + x36 + x37 + x38*x41 + x39*x42 + x40 - V{2}*cell[21] + V{2}*cell[22] - V{2}*cell[8] + V{2}*cell[9])*(x14*x41 - x17 - x18 + x19 + x20 + x24 + V{1}*x26*x42 + x33 - V{1}*cell[21] + V{1}*cell[22] - V{1}*cell[8] + V{1}*cell[9]) + 2*(x25*x25) + x54*x54 + x56*x56 + x57*x57) + V{0.0392836979096202}/((x31)*(x31))) + V{0.5}/x31);
}

};


template <typename... FIELDS>
struct ShearSmagorinskyEffectiveOmega<BGK,descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x14 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x11 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x13 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x9 = cell[1] + cell[7];
auto x10 = x9 + cell[0] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[8] + V{1};
auto x15 = V{1} / (x10);
auto x16 = V{1}*x15;
auto x17 = -cell[5];
auto x18 = cell[1] - cell[7];
auto x19 = cell[2] - cell[6];
auto x20 = x17 + x18 + x19 + cell[3];
auto x21 = x20*x20;
auto x22 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x23 = -x16*x21 + x22 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x24 = -cell[3];
auto x25 = -cell[4] + cell[8];
auto x26 = x17 + x24 + x25 + x9;
auto x27 = x26*x26;
auto x28 = -x16*x27 + x22 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x29 = x24 + cell[5];
auto x30 = -x15*x20*x26 + x18 + x29;
auto x31 = V{1.4142135623731}*util::sqrt(V{0.5}*(x23*x23) + V{0.5}*(x28*x28) + x30*x30);
auto x32 = (x11*x13 + x31)/(x13 + V{1});
auto x33 = V{1} / (V{2.52268963608289}*util::sqrt(x15*(x31 - x32)*(x14*x14) + V{0.0392836979096202}/((x12)*(x12))) + V{0.5}/x12);
auto x34 = V{1} / ((x10)*(x10));
auto x35 = V{1.5}*x34;
auto x36 = x27*x35;
auto x37 = -cell[2] + cell[6];
auto x38 = x29 + x37 - cell[1] + cell[7];
auto x39 = x35*(x38*x38) + V{-1};
auto x40 = x36 + x39;
auto x41 = V{1} - x33;
auto x42 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x43 = V{3}*cell[2];
auto x44 = V{3}*cell[3];
auto x45 = V{3}*cell[6];
auto x46 = V{3}*cell[7];
auto x47 = V{3}*cell[1];
auto x48 = V{3}*cell[5];
auto x49 = x47 - x48;
auto x50 = x15*(x43 + x44 - x45 - x46 + x49);
auto x51 = V{4.5}*x34;
auto x52 = x19 + x25 + V{2}*cell[1] - V{2}*cell[5];
auto x53 = x51*(x52*x52);
auto x54 = V{1} - x36;
auto x55 = -x44 + x46;
auto x56 = x15*(x49 + x55 - V{3}*cell[4] + V{3}*cell[8]);
auto x57 = x21*x35;
auto x58 = x56 - x57;
auto x59 = x54 + x58;
auto x60 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x61 = V{3}*x34;
auto x62 = x21*x61 + x54;
auto x63 = V{2}*cell[3];
auto x64 = V{2}*cell[7];
auto x65 = x25 + x37 - x63 + x64;
auto x66 = x27*x61;
auto x67 = -x50;
auto x68 = x19 + x63 - x64 + cell[4] - cell[8];
cell[0] = -x33*(x40*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + V{0.444444444444444}) + V{1}*x41*cell[0];
cell[1] = x33*(x42*(x50 + x53 + x59) + V{-0.0277777777777778}) + V{1}*x41*cell[1];
cell[2] = x33*(x60*(x50 + x62) + V{-0.111111111111111}) + V{1}*x41*cell[2];
cell[3] = -x33*(x42*(x15*(-x43 + x45 - x47 + x48 + x55) + x40 - x51*x65*x65 + x56) + V{0.0277777777777778}) + V{1}*x41*cell[3];
cell[4] = -x33*(x60*(x39 + x56 - x66) + V{0.111111111111111}) + V{1}*x41*cell[4];
cell[5] = -x33*(x42*(x36 + x50 - x53 + x56 + x57 + V{-1}) + V{0.0277777777777778}) + V{1}*x41*cell[5];
cell[6] = x33*(x60*(x62 + x67) + V{-0.111111111111111}) + V{1}*x41*cell[6];
cell[7] = x33*(x42*(x51*(x68*x68) + x59 + x67) + V{-0.0277777777777778}) + V{1}*x41*cell[7];
cell[8] = x33*(x60*(x58 + x66 + V{1}) + V{-0.111111111111111}) + V{1}*x41*cell[8];
cell.template getFieldPointer<olb::descriptors::AV_SHEAR>()[0] = x32;
return { x10, V{1}*x34*(x21 + x27) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x14 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x11 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x13 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x0 = cell[2] + cell[3];
auto x1 = cell[1] + cell[7] + cell[8];
auto x2 = V{1} / (x0 + x1 + cell[0] + cell[4] + cell[5] + cell[6] + V{1});
auto x3 = V{1}*x2;
auto x4 = -cell[5];
auto x5 = cell[1] - cell[7];
auto x6 = x0 + x4 + x5 - cell[6];
auto x7 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x8 = -x3*x6*x6 + x7 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x9 = -cell[3];
auto x10 = x1 + x4 + x9 - cell[4];
auto x15 = -x3*x10*x10 + x7 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x16 = -x10*x2*x6 + x5 + x9 + cell[5];
auto x17 = V{1.4142135623731}*util::sqrt(V{0.5}*(x15*x15) + x16*x16 + V{0.5}*(x8*x8));
return V{1} / (V{2.52268963608289}*util::sqrt(x2*(x17 - (x11*x13 + x17)/(x13 + V{1}))*(x14*x14) + V{0.0392836979096202}/((x12)*(x12))) + V{0.5}/x12);
}

};

template <typename... FIELDS>
struct ShearSmagorinskyEffectiveOmega<BGK,descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x25 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x24 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x22 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x19 = cell[15] + cell[17];
auto x20 = x19 + cell[12];
auto x21 = cell[11] + cell[18];
auto x26 = cell[10] + cell[14] + cell[16];
auto x27 = cell[6] + cell[7];
auto x28 = cell[4] + cell[5];
auto x29 = cell[8] + cell[9];
auto x30 = cell[13] + cell[3];
auto x31 = x20 + x21 + x26 + x27 + x28 + x29 + x30 + cell[0] + cell[1] + cell[2] + V{1};
auto x32 = V{1} / (x31);
auto x33 = V{0.333333333333333}*cell[4];
auto x34 = V{0.333333333333333}*cell[5];
auto x35 = V{0.333333333333333}*cell[13];
auto x36 = V{0.333333333333333}*cell[14];
auto x37 = V{1}*x32;
auto x38 = -cell[3];
auto x39 = -cell[18];
auto x40 = -cell[8];
auto x41 = x40 + cell[9];
auto x42 = x38 + x39 + x41;
auto x43 = -cell[16];
auto x44 = -cell[6];
auto x45 = x44 + cell[7];
auto x46 = x43 + x45;
auto x47 = x20 + x42 + x46;
auto x48 = x47*x47;
auto x49 = V{0.333333333333333}*cell[0];
auto x50 = V{0.333333333333333}*cell[1];
auto x51 = V{0.333333333333333}*cell[10];
auto x52 = x49 + x50 + x51 - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x53 = V{0.333333333333333}*cell[2];
auto x54 = V{0.333333333333333}*cell[11];
auto x55 = x53 + x54 - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x56 = x33 + x34 + x35 + x36 + x37*x48 + x52 + x55 - V{0.666666666666667}*cell[12] - V{0.666666666666667}*cell[3];
auto x57 = V{0.333333333333333}*cell[6];
auto x58 = V{0.333333333333333}*cell[7];
auto x59 = V{0.333333333333333}*cell[15];
auto x60 = V{0.333333333333333}*cell[16];
auto x61 = cell[13] + cell[17];
auto x62 = -cell[2];
auto x63 = -cell[9];
auto x64 = x21 + x40 + x62 + x63;
auto x65 = -cell[14];
auto x66 = -cell[4];
auto x67 = x66 + cell[5];
auto x68 = x65 + x67;
auto x69 = x61 + x64 + x68;
auto x70 = x69*x69;
auto x71 = V{0.333333333333333}*cell[3];
auto x72 = V{0.333333333333333}*cell[12];
auto x73 = x71 + x72 - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x74 = x37*x70 + x52 + x57 + x58 + x59 + x60 + x73 - V{0.666666666666667}*cell[11] - V{0.666666666666667}*cell[2];
auto x75 = V{0.333333333333333}*cell[8];
auto x76 = V{0.333333333333333}*cell[9];
auto x77 = V{0.333333333333333}*cell[17];
auto x78 = V{0.333333333333333}*cell[18];
auto x79 = cell[13] + cell[15];
auto x80 = -cell[1];
auto x81 = -cell[7];
auto x82 = x44 + x80 + x81;
auto x83 = -cell[5];
auto x84 = x66 + x83;
auto x85 = x26 + x79 + x82 + x84;
auto x86 = x85*x85;
auto x87 = x37*x86 + x49 + x55 + x73 + x75 + x76 + x77 + x78 - V{0.666666666666667}*cell[10] - V{0.666666666666667}*cell[1];
auto x88 = x32*x85;
auto x89 = -cell[13];
auto x90 = x89 + cell[14];
auto x91 = x67 + x69*x88 + x90;
auto x92 = -cell[15];
auto x93 = x92 + cell[16];
auto x94 = x45 + x47*x88 + x93;
auto x95 = -cell[17];
auto x96 = x95 + cell[18];
auto x97 = x32*x47*x69 + x41 + x96;
auto x98 = V{1.4142135623731}*util::sqrt(V{0.5}*(x56*x56) + V{0.5}*(x74*x74) + V{0.5}*(x87*x87) + x91*x91 + x94*x94 + x97*x97);
auto x99 = (x22*x24 + x98)/(x24 + V{1});
auto x100 = V{1} / (V{2.52268963608289}*util::sqrt(x32*(x98 - x99)*(x25*x25) + V{0.0392836979096202}/((x23)*(x23))) + V{0.5}/x23);
auto x101 = V{1} / ((x31)*(x31));
auto x102 = V{1.5}*x101;
auto x103 = x102*x86;
auto x104 = x102*x70;
auto x105 = x102*x48;
auto x106 = x104 + x105 + V{-1};
auto x107 = x103 + x106;
auto x108 = V{1} - x100;
auto x109 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x110 = V{3}*cell[14];
auto x111 = V{3}*cell[16];
auto x112 = V{3}*cell[5];
auto x113 = V{3}*cell[7];
auto x114 = V{3}*cell[13] - V{3}*cell[4];
auto x115 = V{3}*cell[15] - V{3}*cell[6];
auto x116 = x32*(x110 + x111 - x112 - x113 + x114 + x115 + V{3}*cell[10] - V{3}*cell[1]);
auto x117 = V{3}*x101;
auto x118 = x117*x86;
auto x119 = V{3}*cell[18];
auto x120 = V{3}*cell[9];
auto x121 = V{3}*cell[17] - V{3}*cell[8];
auto x122 = x32*(-x110 + x112 + x114 + x119 - x120 + x121 + V{3}*cell[11] - V{3}*cell[2]);
auto x123 = x117*x70;
auto x124 = x103 + V{-1};
auto x125 = x32*(-x111 + x113 + x115 - x119 + x120 + x121 + V{3}*cell[12] - V{3}*cell[3]);
auto x126 = x117*x48;
auto x127 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x128 = V{4.5}*x101;
auto x129 = x82 + cell[10] + cell[16];
auto x130 = x129 + x19 + x64 + V{2}*cell[13] - V{2}*cell[4];
auto x131 = x128*(x130*x130);
auto x132 = x107 + x116;
auto x133 = -x122;
auto x134 = V{2}*cell[14];
auto x135 = V{2}*cell[5];
auto x136 = -cell[10] + cell[17] + cell[1];
auto x137 = -x134 + x135 + x136 + x27 + x43 + x64 + x92;
auto x138 = x42 + cell[12];
auto x139 = x80 + x84 + cell[10] + cell[14];
auto x140 = x138 + x139 + x61 + V{2}*cell[15] - V{2}*cell[6];
auto x141 = x128*(x140*x140);
auto x142 = -x125;
auto x143 = V{2}*cell[16];
auto x144 = V{2}*cell[7];
auto x145 = x136 + x138 - x143 + x144 + x28 + x65 + x89;
auto x146 = x38 + x46 + cell[12];
auto x147 = x62 + x68 + cell[11];
auto x148 = x146 + x147 + x79 + V{2}*cell[17] - V{2}*cell[8];
auto x149 = x128*(x148*x148);
auto x150 = x107 + x122;
auto x151 = V{2}*cell[18];
auto x152 = V{2}*cell[9];
auto x153 = -cell[11] + cell[15] + cell[2];
auto x154 = x146 - x151 + x152 + x153 + x83 + x90 + cell[4];
auto x155 = -x104;
auto x156 = V{1} - x105;
auto x157 = x155 + x156;
auto x158 = x116 + x157;
auto x159 = -x103;
auto x160 = x122 + x159;
auto x161 = x125 + x159;
auto x162 = -x116;
auto x163 = x129 + x134 - x135 + x153 + x29 + x39 + x95;
auto x164 = x30 - cell[12];
auto x165 = x139 + x143 - x144 + x164 + x63 + x96 + cell[8];
auto x166 = x107 + x125;
auto x167 = x147 + x151 - x152 + x164 + x81 + x93 + cell[6];
cell[0] = -x100*(x107*(x33 + x34 + x35 + x36 + x49 + x50 + x51 + x53 + x54 + x57 + x58 + x59 + x60 + x71 + x72 + x75 + x76 + x77 + x78 + V{0.333333333333333}) + V{0.333333333333333}) + V{1}*x108*cell[0];
cell[1] = -x100*(x109*(x106 + x116 - x118) + V{0.0555555555555556}) + V{1}*x108*cell[1];
cell[2] = -x100*(x109*(x105 + x122 - x123 + x124) + V{0.0555555555555556}) + V{1}*x108*cell[2];
cell[3] = -x100*(x109*(x104 + x124 + x125 - x126) + V{0.0555555555555556}) + V{1}*x108*cell[3];
cell[4] = -x100*(x127*(x122 - x131 + x132) + V{0.0277777777777778}) + V{1}*x108*cell[4];
cell[5] = -x100*(x127*(-x128*x137*x137 + x132 + x133) + V{0.0277777777777778}) + V{1}*x108*cell[5];
cell[6] = -x100*(x127*(x125 + x132 - x141) + V{0.0277777777777778}) + V{1}*x108*cell[6];
cell[7] = -x100*(x127*(-x128*x145*x145 + x132 + x142) + V{0.0277777777777778}) + V{1}*x108*cell[7];
cell[8] = -x100*(x127*(x125 - x149 + x150) + V{0.0277777777777778}) + V{1}*x108*cell[8];
cell[9] = -x100*(x127*(-x128*x154*x154 + x142 + x150) + V{0.0277777777777778}) + V{1}*x108*cell[9];
cell[10] = x100*(x109*(x118 + x158) + V{-0.0555555555555556}) + V{1}*x108*cell[10];
cell[11] = x100*(x109*(x123 + x156 + x160) + V{-0.0555555555555556}) + V{1}*x108*cell[11];
cell[12] = x100*(x109*(x126 + x155 + x161 + V{1}) + V{-0.0555555555555556}) + V{1}*x108*cell[12];
cell[13] = x100*(x127*(x131 + x158 + x160) + V{-0.0277777777777778}) + V{1}*x108*cell[13];
cell[14] = -x100*(x127*(-x128*x163*x163 + x150 + x162) + V{0.0277777777777778}) + V{1}*x108*cell[14];
cell[15] = x100*(x127*(x141 + x158 + x161) + V{-0.0277777777777778}) + V{1}*x108*cell[15];
cell[16] = -x100*(x127*(-x128*x165*x165 + x162 + x166) + V{0.0277777777777778}) + V{1}*x108*cell[16];
cell[17] = x100*(x127*(x125 + x149 + x157 + x160) + V{-0.0277777777777778}) + V{1}*x108*cell[17];
cell[18] = -x100*(x127*(-x128*x167*x167 + x133 + x166) + V{0.0277777777777778}) + V{1}*x108*cell[18];
cell.template getFieldPointer<olb::descriptors::AV_SHEAR>()[0] = x99;
return { x31, V{1}*x101*(x48 + x70 + x86) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x24 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x22 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x25 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = cell[12] + cell[15] + cell[17];
auto x1 = cell[11] + cell[13] + cell[18];
auto x2 = cell[10] + cell[14] + cell[16];
auto x3 = V{1} / (x0 + x1 + x2 + cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1});
auto x4 = V{1}*x3;
auto x5 = -cell[6];
auto x6 = x5 + cell[7];
auto x7 = -cell[8];
auto x8 = x7 + cell[9];
auto x9 = x0 + x6 + x8 - cell[16] - cell[18] - cell[3];
auto x10 = V{0.333333333333333}*cell[0];
auto x11 = x10 + V{0.333333333333333}*cell[10] - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] + V{0.333333333333333}*cell[1] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x12 = V{0.333333333333333}*cell[11] - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] + V{0.333333333333333}*cell[2] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x13 = x11 + x12 + x4*(x9*x9) - V{0.666666666666667}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] - V{0.666666666666667}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5];
auto x14 = -cell[4];
auto x15 = x14 + cell[5];
auto x16 = x1 + x15 + x7 - cell[14] + cell[17] - cell[2] - cell[9];
auto x17 = V{0.333333333333333}*cell[12] - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] + V{0.333333333333333}*cell[3] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x18 = x11 + x17 + x4*(x16*x16) - V{0.666666666666667}*cell[11] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] - V{0.666666666666667}*cell[2] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7];
auto x19 = x14 + x2 + x5 + cell[13] + cell[15] - cell[1] - cell[5] - cell[7];
auto x20 = x10 + x12 + x17 + x4*(x19*x19) - V{0.666666666666667}*cell[10] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] - V{0.666666666666667}*cell[1] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9];
auto x21 = x19*x3;
auto x26 = x15 + x16*x21 - cell[13] + cell[14];
auto x27 = x21*x9 + x6 - cell[15] + cell[16];
auto x28 = x16*x3*x9 + x8 - cell[17] + cell[18];
auto x29 = V{1.4142135623731}*util::sqrt(V{0.5}*(x13*x13) + V{0.5}*(x18*x18) + V{0.5}*(x20*x20) + x26*x26 + x27*x27 + x28*x28);
return V{1} / (V{2.52268963608289}*util::sqrt(x3*(x29 - (x22*x24 + x29)/(x24 + V{1}))*(x25*x25) + V{0.0392836979096202}/((x23)*(x23))) + V{0.5}/x23);
}

};

template <typename... FIELDS>
struct ShearSmagorinskyEffectiveOmega<BGK,descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x30 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x33 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x27 = cell[10] + cell[6];
auto x28 = x27 + cell[24];
auto x29 = cell[17] + cell[23];
auto x34 = cell[19] + cell[21];
auto x35 = x28 + x29 + x34 + cell[0] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[18] + cell[1] + cell[20] + cell[22] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[7] + cell[8] + cell[9] + V{1};
auto x36 = V{1} / (x35);
auto x37 = V{1}*x36;
auto x38 = -cell[17];
auto x39 = x38 + cell[5];
auto x40 = -cell[19];
auto x41 = x40 + cell[7];
auto x42 = -cell[25];
auto x43 = x42 + cell[11];
auto x44 = x41 + x43;
auto x45 = -cell[18];
auto x46 = -cell[20];
auto x47 = x45 + x46;
auto x48 = -cell[24];
auto x49 = x48 + cell[4];
auto x50 = -cell[26];
auto x51 = x50 + cell[12];
auto x52 = -cell[23];
auto x53 = -cell[14] + cell[1];
auto x54 = x53 + cell[13];
auto x55 = x52 + x54;
auto x56 = x27 + x39 + x44 + x47 + x49 + x51 + x55;
auto x57 = x56*x56;
auto x58 = V{0.666666666666667}*cell[10];
auto x59 = V{0.666666666666667}*cell[11];
auto x60 = V{0.666666666666667}*cell[12];
auto x61 = V{0.666666666666667}*cell[13];
auto x62 = V{0.666666666666667}*cell[23];
auto x63 = V{0.666666666666667}*cell[24];
auto x64 = V{0.666666666666667}*cell[25];
auto x65 = V{0.666666666666667}*cell[26];
auto x66 = -V{0.333333333333333}*cell[0];
auto x67 = x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x68 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x69 = -x37*x57 + x67 + x68 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x70 = -cell[21];
auto x71 = x70 + cell[9];
auto x72 = x71 + cell[11];
auto x73 = x52 + cell[26];
auto x74 = x73 + cell[8];
auto x75 = -cell[5];
auto x76 = -cell[22];
auto x77 = x75 + x76;
auto x78 = -cell[13];
auto x79 = x78 + cell[25];
auto x80 = -cell[12];
auto x81 = -cell[15] + cell[2];
auto x82 = x81 + cell[10];
auto x83 = x80 + x82;
auto x84 = x38 + cell[18];
auto x85 = x49 + x72 + x74 + x77 + x79 + x83 + x84;
auto x86 = x85*x85;
auto x87 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x88 = -x37*x86 + x67 + x87 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x89 = -cell[11];
auto x90 = -cell[7];
auto x91 = x89 + x90;
auto x92 = -cell[9];
auto x93 = x42 + x92;
auto x94 = -cell[16];
auto x95 = x78 + cell[12];
auto x96 = x94 + x95 + cell[3];
auto x97 = x70 + cell[22];
auto x98 = x40 + cell[20];
auto x99 = x28 + x74 + x91 + x93 + x96 + x97 + x98;
auto x100 = x99*x99;
auto x101 = -x100*x37 + x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x68 + x87 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x102 = x36*x56;
auto x103 = -cell[4];
auto x104 = x103 + cell[18];
auto x105 = x89 + cell[13] + cell[25];
auto x106 = -cell[10];
auto x107 = x106 + x48 + cell[12];
auto x108 = x102*x85 + x104 + x105 + x107 + x39 + x73;
auto x109 = x106 + cell[13];
auto x110 = -cell[6];
auto x111 = x110 + cell[20];
auto x112 = x80 + cell[24];
auto x113 = x111 + x112;
auto x114 = x102*x99 + x109 + x113 + x44 + x73;
auto x115 = x52 + cell[25];
auto x116 = x115 + x50;
auto x117 = x106 + x95;
auto x118 = -cell[8];
auto x119 = x118 + cell[22];
auto x120 = x119 + cell[24];
auto x121 = x116 + x117 + x120 + x36*x85*x99 + x72;
auto x122 = V{1.4142135623731}*util::sqrt(V{0.5}*(x101*x101) + x108*x108 + x114*x114 + x121*x121 + V{0.5}*(x69*x69) + V{0.5}*(x88*x88));
auto x123 = (x122 + x30*x32)/(x32 + V{1});
auto x124 = V{1} / (V{2.52268963608289}*util::sqrt(x36*(x122 - x123)*(x33*x33) + V{0.0392836979096202}/((x31)*(x31))) + V{0.5}/x31);
auto x125 = V{1} / ((x35)*(x35));
auto x126 = V{1.5}*x125;
auto x127 = x75 + cell[19];
auto x128 = cell[14] - cell[1];
auto x129 = x104 + x128;
auto x130 = x106 + cell[26];
auto x131 = x113 + x127 + x129 + x130 + x29 + x79 + x91;
auto x132 = x131*x131;
auto x133 = x126*x132;
auto x134 = x109 + cell[21];
auto x135 = cell[15] - cell[2];
auto x136 = x135 + x89;
auto x137 = x103 + cell[5];
auto x138 = x137 + x45;
auto x139 = x120 + x134 + x136 + x138 + x29 + x51 + x93;
auto x140 = x139*x139;
auto x141 = x126*x140;
auto x142 = x46 + x76;
auto x143 = cell[16] - cell[3];
auto x144 = x143 + x50;
auto x145 = x118 + cell[9];
auto x146 = x110 + cell[19] + cell[7];
auto x147 = x48 + cell[11] + cell[23];
auto x148 = x134 + x142 + x144 + x145 + x146 + x147 + x80 + cell[25];
auto x149 = x148*x148;
auto x150 = x126*x149;
auto x151 = x141 + x150 + V{-1};
auto x152 = x133 + x151;
auto x153 = V{1} - x124;
auto x154 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x155 = V{3}*cell[14];
auto x156 = V{3}*cell[1];
auto x157 = V{3}*cell[17];
auto x158 = V{3}*cell[23];
auto x159 = V{3}*cell[24];
auto x160 = V{3}*cell[4];
auto x161 = V{3}*cell[10];
auto x162 = -x161;
auto x163 = V{3}*cell[11];
auto x164 = -x163;
auto x165 = x157 + x158 + x159 - x160 + x162 + x164;
auto x166 = V{3}*cell[19];
auto x167 = V{3}*cell[25];
auto x168 = V{3}*cell[6];
auto x169 = V{3}*cell[12];
auto x170 = -x169;
auto x171 = x166 + x167 - x168 + x170;
auto x172 = V{3}*cell[18];
auto x173 = V{3}*cell[26];
auto x174 = V{3}*cell[5];
auto x175 = V{3}*cell[13];
auto x176 = -x175;
auto x177 = x172 + x173 - x174 + x176;
auto x178 = V{3}*cell[20];
auto x179 = V{3}*cell[7];
auto x180 = x178 - x179;
auto x181 = x36*(x155 - x156 + x165 + x171 + x177 + x180);
auto x182 = V{3}*x125;
auto x183 = V{3}*cell[15];
auto x184 = V{3}*cell[2];
auto x185 = V{3}*cell[21];
auto x186 = V{3}*cell[8];
auto x187 = -x173;
auto x188 = x175 + x185 - x186 + x187;
auto x189 = V{3}*cell[22];
auto x190 = V{3}*cell[9];
auto x191 = -x167;
auto x192 = x169 + x189 - x190 + x191;
auto x193 = -x172 + x174;
auto x194 = x36*(x165 + x183 - x184 + x188 + x192 + x193);
auto x195 = x133 + V{-1};
auto x196 = V{3}*cell[16];
auto x197 = V{3}*cell[3];
auto x198 = -x159;
auto x199 = x163 - x189 + x190 + x198;
auto x200 = -x178 + x179;
auto x201 = x36*(x158 + x162 + x171 + x188 + x196 - x197 + x199 + x200);
auto x202 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x203 = V{4.5}*x125;
auto x204 = V{2}*cell[10];
auto x205 = V{2}*cell[23];
auto x206 = -x204 + x205;
auto x207 = x135 + x206;
auto x208 = V{2}*cell[11];
auto x209 = -x208;
auto x210 = V{2}*cell[24];
auto x211 = x209 + x210 + x92;
auto x212 = x111 + x128 + x90;
auto x213 = V{2}*cell[4];
auto x214 = V{2}*cell[17];
auto x215 = -x213 + x214;
auto x216 = x119 + x207 + x211 + x212 + x215 + x34;
auto x217 = x152 + x181;
auto x218 = x194 + x217;
auto x219 = x41 + x53 + cell[6];
auto x220 = V{2}*cell[26];
auto x221 = V{2}*cell[13];
auto x222 = -x220 + x221;
auto x223 = x222 + cell[21];
auto x224 = V{2}*cell[25];
auto x225 = -x224;
auto x226 = V{2}*cell[12];
auto x227 = x225 + x226 + x92;
auto x228 = V{2}*cell[18];
auto x229 = V{2}*cell[5];
auto x230 = -x228 + x229;
auto x231 = x135 + x230;
auto x232 = x119 + x219 + x223 + x227 + x231 + x46;
auto x233 = -x194;
auto x234 = x217 + x233;
auto x235 = x143 + x145;
auto x236 = x224 - x226;
auto x237 = x129 + cell[17];
auto x238 = V{2}*cell[6];
auto x239 = V{2}*cell[19];
auto x240 = -x238 + x239;
auto x241 = x206 + x235 + x236 + x237 + x240 + x77 + cell[21];
auto x242 = -x201;
auto x243 = x208 - x210;
auto x244 = x243 + cell[4];
auto x245 = V{2}*cell[20];
auto x246 = V{2}*cell[7];
auto x247 = -x245 + x246;
auto x248 = x247 + x53;
auto x249 = x39 + x45;
auto x250 = x223 + x235 + x244 + x248 + x249 + x76;
auto x251 = V{2}*cell[8];
auto x252 = V{2}*cell[21];
auto x253 = -x251 + x252;
auto x254 = x143 + x253;
auto x255 = x137 + x146 + x207 + x222 + x254 + x47 + cell[17];
auto x256 = x152 + x194;
auto x257 = x201 + x256;
auto x258 = x236 + x81;
auto x259 = V{2}*cell[22];
auto x260 = V{2}*cell[9];
auto x261 = x143 - x259 + x260;
auto x262 = x110 + x127 + x244 + x258 + x261 + x46 + x84 + cell[7];
auto x263 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x264 = V{3}*cell[10];
auto x265 = V{3}*cell[23];
auto x266 = x128 + x240;
auto x267 = x135 + x215;
auto x268 = x105 + x112 + x144 + x253 - x264 + x265 + x266 + x267;
auto x269 = V{3}*cell[24];
auto x270 = V{3}*cell[11];
auto x271 = x213 - x214;
auto x272 = x116 + x247 + x261 - x269 + x270 + x271 + x54 + x83;
auto x273 = -x239;
auto x274 = V{3}*cell[25];
auto x275 = V{3}*cell[12];
auto x276 = -x260;
auto x277 = x94 + cell[3];
auto x278 = x259 + x276 + x277;
auto x279 = x136 + x230 + x238 + x273 - x274 + x275 + x278 + x50 + x55 + cell[10] + cell[24];
auto x280 = -x158;
auto x281 = -x157 + x160;
auto x282 = -x166 + x168;
auto x283 = x36*(-x155 + x156 + x161 + x163 + x169 + x175 + x187 + x191 + x193 + x198 + x200 + x280 + x281 + x282);
auto x284 = V{3}*cell[26];
auto x285 = V{3}*cell[13];
auto x286 = x107 + x231 + x248 + x254 - x284 + x285 + x43 + cell[23];
auto x287 = x161 - x185 + x186 + x280;
auto x288 = x36*(x159 + x164 + x173 + x176 + x180 + x192 - x196 + x197 + x282 + x287);
auto x289 = x126*x86;
auto x290 = x100*x126 + V{-1};
auto x291 = x289 + x290;
auto x292 = x36*(x167 + x170 + x177 - x183 + x184 + x199 + x281 + x287);
auto x293 = x126*x57;
auto x294 = x292 + x293;
auto x295 = x288 + x291 + x294;
auto x296 = x283 + x291;
auto x297 = x288 + x293;
auto x298 = x71 + cell[8];
auto x299 = x204 - x205;
auto x300 = x299 + x81;
auto x301 = x142 + x219 + x243 + x271 + x298 + x300;
auto x302 = x294 + x296;
auto x303 = -x181;
auto x304 = x220 - x221;
auto x305 = x228 - x229;
auto x306 = x212 + x258 + x298 + x304 + x305 + x76 + cell[19];
auto x307 = x277 + cell[4];
auto x308 = x238 + x273 + x53;
auto x309 = x97 + cell[8];
auto x310 = x227 + x249 + x299 + x307 + x308 + x309;
auto x311 = x296 + x297;
auto x312 = x304 + x75;
auto x313 = x245 - x246 + x277;
auto x314 = x211 + x237 + x309 + x312 + x313;
auto x315 = x152 + x201;
auto x316 = x251 - x252;
auto x317 = x90 + x98 + cell[6];
auto x318 = x300 + x307 + x312 + x316 + x317 + x84;
auto x319 = x135 + x138 + x209 + x210 + x225 + x226 + x278 + x317 + cell[17];
auto x320 = x264 - x265 + x271 + x308 + x316 + x43 + x48 + x81 + x96 + cell[26];
auto x321 = x128 + x313;
auto x322 = x117 + x259 + x267 + x269 - x270 + x276 + x321 + x42 + cell[23] + cell[26];
auto x323 = x130 + x147 + x261 + x266 + x274 - x275 + x305 + x78 + x81;
auto x324 = x112 + x115 + x284 - x285 + x305 + x316 + x321 + x82 + x89;
cell[0] = -x124*(x152*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{0.296296296296296}) + V{1}*x153*cell[0];
cell[1] = -x124*(x154*(-x132*x182 + x151 + x181) + V{0.0740740740740741}) + V{1}*x153*cell[1];
cell[2] = -x124*(x154*(-x140*x182 + x150 + x194 + x195) + V{0.0740740740740741}) + V{1}*x153*cell[2];
cell[3] = -x124*(x154*(x141 - x149*x182 + x195 + x201) + V{0.0740740740740741}) + V{1}*x153*cell[3];
cell[4] = -x124*(x202*(-x203*x216*x216 + x218) + V{0.0185185185185185}) + V{1}*x153*cell[4];
cell[5] = -x124*(x202*(-x203*x232*x232 + x234) + V{0.0185185185185185}) + V{1}*x153*cell[5];
cell[6] = -x124*(x202*(x201 - x203*x241*x241 + x217) + V{0.0185185185185185}) + V{1}*x153*cell[6];
cell[7] = -x124*(x202*(-x203*x250*x250 + x217 + x242) + V{0.0185185185185185}) + V{1}*x153*cell[7];
cell[8] = -x124*(x202*(-x203*x255*x255 + x257) + V{0.0185185185185185}) + V{1}*x153*cell[8];
cell[9] = -x124*(x202*(-x203*x262*x262 + x242 + x256) + V{0.0185185185185185}) + V{1}*x153*cell[9];
cell[10] = -x124*(x263*(x201 - x203*x268*x268 + x218) + V{0.00462962962962963}) + V{1}*x153*cell[10];
cell[11] = -x124*(x263*(-x203*x272*x272 + x218 + x242) + V{0.00462962962962963}) + V{1}*x153*cell[11];
cell[12] = -x124*(x263*(x201 - x203*x279*x279 + x234) + V{0.00462962962962963}) + V{1}*x153*cell[12];
cell[13] = -x124*(x263*(-x203*x286*x286 - x283 + x295) + V{0.00462962962962963}) + V{1}*x153*cell[13];
cell[14] = -x124*(x154*(-x182*x57 + x296) + V{0.0740740740740741}) + V{1}*x153*cell[14];
cell[15] = -x124*(x154*(-x182*x86 + x290 + x294) + V{0.0740740740740741}) + V{1}*x153*cell[15];
cell[16] = -x124*(x154*(-x100*x182 + x289 + x297 + V{-1}) + V{0.0740740740740741}) + V{1}*x153*cell[16];
cell[17] = -x124*(x202*(-x203*x301*x301 + x302) + V{0.0185185185185185}) + V{1}*x153*cell[17];
cell[18] = -x124*(x202*(-x203*x306*x306 + x256 + x303) + V{0.0185185185185185}) + V{1}*x153*cell[18];
cell[19] = -x124*(x202*(-x203*x310*x310 + x311) + V{0.0185185185185185}) + V{1}*x153*cell[19];
cell[20] = -x124*(x202*(-x203*x314*x314 + x303 + x315) + V{0.0185185185185185}) + V{1}*x153*cell[20];
cell[21] = -x124*(x202*(-x203*x318*x318 + x295) + V{0.0185185185185185}) + V{1}*x153*cell[21];
cell[22] = -x124*(x202*(-x203*x319*x319 + x233 + x315) + V{0.0185185185185185}) + V{1}*x153*cell[22];
cell[23] = -x124*(x263*(-x203*x320*x320 + x288 + x302) + V{0.00462962962962963}) + V{1}*x153*cell[23];
cell[24] = -x124*(x263*(-x203*x322*x322 - x288 + x302) + V{0.00462962962962963}) + V{1}*x153*cell[24];
cell[25] = -x124*(x263*(-x203*x323*x323 - x292 + x311) + V{0.00462962962962963}) + V{1}*x153*cell[25];
cell[26] = -x124*(x263*(-x203*x324*x324 + x257 + x303) + V{0.00462962962962963}) + V{1}*x153*cell[26];
cell.template getFieldPointer<olb::descriptors::AV_SHEAR>()[0] = x123;
return { x35, V{1}*x125*(x100 + x57 + x86) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::descriptors::LATTICE_TIME>();
auto x33 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x30 = cell.template getFieldComponent<olb::descriptors::AV_SHEAR>(0);
auto x0 = cell[12] + cell[25];
auto x1 = x0 + cell[18];
auto x2 = cell[11] + cell[24];
auto x3 = x2 + cell[20];
auto x4 = cell[22] + cell[9];
auto x5 = cell[13] + cell[1];
auto x6 = cell[26] + cell[2] + cell[8];
auto x7 = cell[10] + cell[3];
auto x8 = V{1} / (x1 + x3 + x4 + x5 + x6 + x7 + cell[0] + cell[14] + cell[15] + cell[16] + cell[17] + cell[19] + cell[21] + cell[23] + cell[4] + cell[5] + cell[6] + cell[7] + V{1});
auto x9 = V{1}*x8;
auto x10 = -cell[17];
auto x11 = -cell[24];
auto x12 = x10 + x11 + cell[5];
auto x13 = -cell[19];
auto x14 = -cell[25];
auto x15 = x13 + x14 + cell[7];
auto x16 = -cell[23];
auto x17 = x16 - cell[26];
auto x18 = cell[10] + cell[11] + cell[4];
auto x19 = cell[12] + cell[6];
auto x20 = x12 + x15 + x17 + x18 + x19 + x5 - cell[14] - cell[18] - cell[20];
auto x21 = V{0.666666666666667}*cell[10];
auto x22 = V{0.666666666666667}*cell[11];
auto x23 = V{0.666666666666667}*cell[12];
auto x24 = V{0.666666666666667}*cell[13];
auto x25 = V{0.666666666666667}*cell[23];
auto x26 = V{0.666666666666667}*cell[24];
auto x27 = V{0.666666666666667}*cell[25];
auto x28 = V{0.666666666666667}*cell[26];
auto x29 = -V{0.333333333333333}*cell[0];
auto x34 = x21 + x22 + x23 + x24 + x25 + x26 + x27 + x28 + x29 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x35 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x36 = x34 + x35 - x9*x20*x20 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x37 = -cell[12];
auto x38 = -cell[13] - cell[21];
auto x39 = x16 + x38;
auto x40 = x10 + x11 + x18 + x37 + x39 + x6 - cell[15] + cell[18] - cell[22] + cell[25] - cell[5] + cell[9];
auto x41 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x42 = x34 + x41 - x9*x40*x40 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x43 = -cell[11];
auto x44 = x13 + x14 + x19 + x39 + x43 + x7 - cell[16] + cell[20] + cell[22] + cell[24] + cell[26] - cell[7] + cell[8] - cell[9];
auto x45 = x21 + x22 + x23 + x24 + x25 + x26 + x27 + x28 + x29 + x35 + x41 - x9*x44*x44 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x46 = x20*x8;
auto x47 = -cell[10];
auto x48 = x16 + x47 + cell[13] + cell[26];
auto x49 = x1 + x12 + x40*x46 + x43 + x48 - cell[4];
auto x50 = x15 + x3 + x37 + x44*x46 + x48 - cell[6];
auto x51 = x0 + x17 + x2 + x38 + x4 + x40*x44*x8 + x47 - cell[8];
auto x52 = V{1.4142135623731}*util::sqrt(V{0.5}*(x36*x36) + V{0.5}*(x42*x42) + V{0.5}*(x45*x45) + x49*x49 + x50*x50 + x51*x51);
return V{1} / (V{2.52268963608289}*util::sqrt(x8*(x52 - (x30*x32 + x52)/(x32 + V{1}))*(x33*x33) + V{0.0392836979096202}/((x31)*(x31))) + V{0.5}/x31);
}

};


template <typename... FIELDS>
struct ConSmagorinskyEffectiveOmega<BGK,descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = cell[1] + cell[7];
auto x10 = x9 + cell[0] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[8];
auto x11 = x10 + V{1};
auto x14 = V{1} / (x11);
auto x15 = V{1} / ((x11)*(x11));
auto x16 = x15/util::pow(x13, 4);
auto x17 = (V{0.0392837100659193}*cell[0] + V{0.0392837100659193}*cell[1] + V{0.0392837100659193}*cell[2] + V{0.0392837100659193}*cell[3] + V{0.0392837100659193}*cell[4] + V{0.0392837100659193}*cell[5] + V{0.0392837100659193}*cell[6] + V{0.0392837100659193}*cell[7] + V{0.0392837100659193}*cell[8] + V{0.0392837100659193})/((x12)*(x12));
auto x18 = x13*x13;
auto x19 = V{1}*x14;
auto x20 = -cell[1] + cell[7];
auto x21 = -cell[3];
auto x22 = x21 + cell[5];
auto x23 = -cell[2] + cell[6];
auto x24 = x20 + x22 + x23;
auto x25 = x24*x24;
auto x26 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x27 = x26 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x28 = -x19*x25 + x27;
auto x29 = -cell[5];
auto x30 = -cell[4] + cell[8];
auto x31 = x21 + x29 + x30 + x9;
auto x32 = x31*x31;
auto x33 = -x19*x32;
auto x34 = x26 + x33 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x35 = x34*x34;
auto x36 = V{0.5}*x35;
auto x37 = x14*x31;
auto x38 = x24*x37;
auto x39 = x29 + cell[3];
auto x40 = x20 - x38 + x39;
auto x41 = util::sqrt(x11*(x17 + V{1.4142135623731}*x18*util::sqrt(x36 + V{0.5}*(x28*x28) + x40*x40)));
auto x42 = V{1} / (x12);
auto x43 = -x42*(V{0.198201185833787}*cell[0] + V{0.198201185833787}*cell[1] + V{0.198201185833787}*cell[2] + V{0.198201185833787}*cell[3] + V{0.198201185833787}*cell[4] + V{0.198201185833787}*cell[5] + V{0.198201185833787}*cell[6] + V{0.198201185833787}*cell[7] + V{0.198201185833787}*cell[8] + V{0.198201185833787});
auto x44 = x41 + x43;
auto x45 = cell[1] - cell[7];
auto x46 = x22 + x45;
auto x47 = x38 + x46;
auto x48 = x47*x47;
auto x49 = x48;
auto x50 = cell[2] - cell[6];
auto x51 = x39 + x45 + x50;
auto x52 = x51*x51;
auto x53 = -x19*x52;
auto x54 = x27 + x53;
auto x55 = x54*x54;
auto x56 = x35 + x55;
auto x57 = x36 + V{0.5}*x55;
auto x58 = util::sqrt(x49 + x57);
auto x59 = -V{0.166666666666667}*x42*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667});
auto x60 = x33 + x53 - V{0.666666666666667}*cell[0] + V{1.33333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{1.33333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{1.33333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{1.33333333333333}*cell[7] + V{0.333333333333333}*cell[8];
auto x61 = V{13.4543468074917}*x14*x60*(V{0.140149402542286}*x41 + x59)*util::sqrt(x16*(x44*x44)*(x57 + x48)/(V{2}*x49 + x56))/x58 + V{-1};
auto x62 = util::sqrt(x11*(x17 + V{1.4142135623731}*x18*x58));
auto x63 = x43 + x62;
auto x64 = -x37*x51 + x46;
auto x65 = x64*x64;
auto x66 = x65;
auto x67 = util::sqrt(x16*(x63*x63)*(x57 + x65)/(x56 + V{2}*x66));
auto x68 = V{1} / util::sqrt(x57 + x66);
auto x69 = x10 + V{1};
auto x70 = V{1.5}*x15;
auto x71 = x32*x70;
auto x72 = x25*x70 + V{-1};
auto x73 = x71 + x72;
auto x74 = x59 + V{0.140149402542286}*x62;
auto x75 = V{0.373731855763657}*x14;
auto x76 = V{3}*cell[2];
auto x77 = V{3}*cell[3];
auto x78 = V{3}*cell[6];
auto x79 = V{3}*cell[7];
auto x80 = V{3}*cell[1];
auto x81 = V{3}*cell[5];
auto x82 = x80 - x81;
auto x83 = x14*(x76 + x77 - x78 - x79 + x82);
auto x84 = V{4.5}*x15;
auto x85 = x30 + x50 + V{2}*cell[1] - V{2}*cell[5];
auto x86 = x84*(x85*x85);
auto x87 = V{1} - x71;
auto x88 = -x77 + x79;
auto x89 = x14*(x82 + x88 - V{3}*cell[4] + V{3}*cell[8]);
auto x90 = x52*x70;
auto x91 = x89 - x90;
auto x92 = x87 + x91;
auto x93 = V{1.49492742305463}*x14;
auto x94 = V{3}*x15;
auto x95 = x52*x94 + x87;
auto x96 = V{2}*cell[3];
auto x97 = V{2}*cell[7];
auto x98 = x23 + x30 - x96 + x97;
auto x99 = x32*x94;
auto x100 = -x83;
auto x101 = x50 + x96 - x97 + cell[4] - cell[8];
cell[0] = -V{5.97970969221852}*x14*x60*x67*x68*x74*(x69*x73 + V{1}) - x61*cell[0];
cell[1] = x60*x67*x68*x74*x75*(x69*(x83 + x86 + x92) + V{-1}) - x61*cell[1];
cell[2] = x60*x67*x68*x74*x93*(x69*(x83 + x95) + V{-1}) - x61*cell[2];
cell[3] = -x60*x67*x68*x74*x75*(x69*(x14*(-x76 + x78 - x80 + x81 + x88) + x73 - x84*x98*x98 + x89) + V{1}) - x61*cell[3];
cell[4] = -x60*x67*x68*x74*x93*(x69*(x72 + x89 - x99) + V{1}) - x61*cell[4];
cell[5] = -x60*x67*x68*x74*x75*(x69*(x71 + x83 - x86 + x89 + x90 + V{-1}) + V{1}) - x61*cell[5];
cell[6] = x60*x67*x68*x74*x93*(x69*(x100 + x95) + V{-1}) - x61*cell[6];
cell[7] = x60*x67*x68*x74*x75*(x69*(x100 + x84*(x101*x101) + x92) + V{-1}) - x61*cell[7];
cell[8] = x60*x67*x68*x74*x93*(x69*(x91 + x99 + V{1}) + V{-1}) - x61*cell[8];
return { x11, V{1}*x15*(x32 + x52) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = cell[2] + cell[3];
auto x1 = cell[1] + cell[7] + cell[8];
auto x2 = x0 + x1 + cell[0] + cell[4] + cell[5] + cell[6] + V{1};
auto x3 = V{1} / (x2);
auto x4 = -cell[3];
auto x5 = x4 + cell[5];
auto x6 = -cell[5];
auto x7 = x1 + x4 + x6 - cell[4];
auto x8 = x3*x7;
auto x9 = cell[1] - cell[7];
auto x10 = x5 + x9;
auto x11 = x10 + x8*(x5 - cell[1] - cell[2] + cell[6] + cell[7]);
auto x14 = V{1}*x3;
auto x15 = x0 + x6 + x9 - cell[6];
auto x16 = -x14*x15*x15;
auto x17 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x18 = x16 + x17 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x19 = x18*x18;
auto x20 = -x14*x7*x7;
auto x21 = x17 + x20 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x22 = x21*x21;
auto x23 = V{0.5}*x19 + V{0.5}*x22;
auto x24 = util::sqrt(x2*(V{1.4142135623731}*(x13*x13)*util::sqrt(x23 + x11*x11) + (V{0.0392837100659193}*cell[0] + V{0.0392837100659193}*cell[1] + V{0.0392837100659193}*cell[2] + V{0.0392837100659193}*cell[3] + V{0.0392837100659193}*cell[4] + V{0.0392837100659193}*cell[5] + V{0.0392837100659193}*cell[6] + V{0.0392837100659193}*cell[7] + V{0.0392837100659193}*cell[8] + V{0.0392837100659193})/((x12)*(x12))));
auto x25 = V{1} / (x12);
auto x26 = x24 - x25*(V{0.198201185833787}*cell[0] + V{0.198201185833787}*cell[1] + V{0.198201185833787}*cell[2] + V{0.198201185833787}*cell[3] + V{0.198201185833787}*cell[4] + V{0.198201185833787}*cell[5] + V{0.198201185833787}*cell[6] + V{0.198201185833787}*cell[7] + V{0.198201185833787}*cell[8] + V{0.198201185833787});
auto x27 = x10 - x15*x8;
auto x28 = x27*x27;
auto x29 = x28;
return V{13.4543468074917}*x3*(V{0.140149402542286}*x24 - V{0.166666666666667}*x25*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}))*(x16 + x20 - V{0.666666666666667}*cell[0] + V{1.33333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{1.33333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{1.33333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{1.33333333333333}*cell[7] + V{0.333333333333333}*cell[8])*util::sqrt((x26*x26)*(x23 + x28)/(util::pow(x13, 4)*((x2)*(x2))*(x19 + x22 + V{2}*x29)))/util::sqrt(x23 + x29);
}

};

template <typename... FIELDS>
struct ConSmagorinskyEffectiveOmega<BGK,descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell[11] + cell[17] + cell[18];
auto x20 = cell[10] + cell[13] + cell[14] + cell[15] + cell[16];
auto x21 = cell[6] + cell[7];
auto x22 = cell[4] + cell[5];
auto x25 = cell[8] + cell[9];
auto x26 = x19 + x20 + x21 + x22 + x25 + cell[0] + cell[12] + cell[1] + cell[2] + cell[3];
auto x27 = x26 + V{1};
auto x28 = V{1} / (x27);
auto x29 = V{1} / ((x27)*(x27));
auto x30 = (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x23)*(x23));
auto x31 = x24*x24;
auto x32 = V{0.333333333333333}*cell[4];
auto x33 = V{0.333333333333333}*cell[5];
auto x34 = V{0.333333333333333}*cell[13];
auto x35 = V{0.333333333333333}*cell[14];
auto x36 = V{0.666666666666667}*cell[3];
auto x37 = V{0.666666666666667}*cell[12];
auto x38 = V{1}*x28;
auto x39 = -cell[3];
auto x40 = -cell[8];
auto x41 = x40 + cell[9];
auto x42 = -cell[18];
auto x43 = x42 + cell[17];
auto x44 = x39 + x41 + x43 + cell[12];
auto x45 = -cell[6];
auto x46 = x45 + cell[7];
auto x47 = -cell[16];
auto x48 = x47 + cell[15];
auto x49 = x46 + x48;
auto x50 = x44 + x49;
auto x51 = x50*x50;
auto x52 = x38*x51;
auto x53 = V{0.333333333333333}*cell[0];
auto x54 = V{0.333333333333333}*cell[1];
auto x55 = V{0.333333333333333}*cell[10];
auto x56 = V{0.666666666666667}*cell[8];
auto x57 = V{0.666666666666667}*cell[9];
auto x58 = V{0.666666666666667}*cell[17];
auto x59 = V{0.666666666666667}*cell[18];
auto x60 = x53 + x54 + x55 - x56 - x57 - x58 - x59;
auto x61 = V{0.333333333333333}*cell[2];
auto x62 = V{0.333333333333333}*cell[11];
auto x63 = V{0.666666666666667}*cell[6];
auto x64 = V{0.666666666666667}*cell[7];
auto x65 = V{0.666666666666667}*cell[15];
auto x66 = V{0.666666666666667}*cell[16];
auto x67 = x61 + x62 - x63 - x64 - x65 - x66;
auto x68 = x32 + x33 + x34 + x35 - x36 - x37 + x52 + x60 + x67;
auto x69 = V{0.333333333333333}*cell[6];
auto x70 = V{0.333333333333333}*cell[7];
auto x71 = V{0.333333333333333}*cell[15];
auto x72 = V{0.333333333333333}*cell[16];
auto x73 = V{0.666666666666667}*cell[2];
auto x74 = V{0.666666666666667}*cell[11];
auto x75 = -cell[2];
auto x76 = -cell[4];
auto x77 = x76 + cell[5];
auto x78 = -cell[14];
auto x79 = x78 + cell[13];
auto x80 = x75 + x77 + x79;
auto x81 = -cell[9];
auto x82 = x19 + x40 + x81;
auto x83 = x80 + x82;
auto x84 = x83*x83;
auto x85 = x38*x84;
auto x86 = V{0.333333333333333}*cell[3];
auto x87 = V{0.333333333333333}*cell[12];
auto x88 = V{0.666666666666667}*cell[4];
auto x89 = V{0.666666666666667}*cell[5];
auto x90 = V{0.666666666666667}*cell[13];
auto x91 = V{0.666666666666667}*cell[14];
auto x92 = x86 + x87 - x88 - x89 - x90 - x91;
auto x93 = x60 + x69 + x70 + x71 + x72 - x73 - x74 + x85 + x92;
auto x94 = V{0.333333333333333}*cell[8];
auto x95 = V{0.333333333333333}*cell[9];
auto x96 = V{0.333333333333333}*cell[17];
auto x97 = V{0.333333333333333}*cell[18];
auto x98 = V{0.666666666666667}*cell[1];
auto x99 = V{0.666666666666667}*cell[10];
auto x100 = -cell[7];
auto x101 = -cell[1];
auto x102 = x100 + x101 + x45;
auto x103 = -cell[5];
auto x104 = x103 + x76;
auto x105 = x102 + x104 + x20;
auto x106 = x105*x105;
auto x107 = x106*x38;
auto x108 = x107 + x53 + x67 + x92 + x94 + x95 + x96 + x97 - x98 - x99;
auto x109 = x105*x28;
auto x110 = x109*x83;
auto x111 = -cell[13];
auto x112 = x111 + cell[14];
auto x113 = x110 + x112 + x77;
auto x114 = x109*x50;
auto x115 = -cell[15];
auto x116 = x115 + cell[16];
auto x117 = x114 + x116 + x46;
auto x118 = x28*x50*x83;
auto x119 = -cell[17];
auto x120 = x119 + cell[18];
auto x121 = x118 + x120 + x41;
auto x122 = util::sqrt(V{0.5}*(x108*x108) + x113*x113 + x117*x117 + x121*x121 + V{0.5}*(x68*x68) + V{0.5}*(x93*x93));
auto x123 = (V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667})/x23;
auto x124 = -x123 + util::sqrt(x27*(x122*x31 + x30));
auto x125 = util::sqrt(x29*(x124*x124)/util::pow(x24, 4));
auto x126 = V{1} / (x122);
auto x127 = -x53;
auto x128 = x127 - x86 - x87 + x88 + x89 + x90 + x91;
auto x129 = -x61 - x62 + x63 + x64 + x65 + x66;
auto x130 = -x107 + x128 + x129 - x94 - x95 - x96 - x97 + x98 + x99;
auto x131 = -x54 - x55 + x56 + x57 + x58 + x59;
auto x132 = x128 + x131 - x69 - x70 - x71 - x72 + x73 + x74 - x85;
auto x133 = x127 + x129 + x131 - x32 - x33 - x34 - x35 + x36 + x37 - x52;
auto x134 = x103 + cell[4];
auto x135 = -x110 + x134 + x79;
auto x136 = x100 + cell[6];
auto x137 = -x114 + x136 + x48;
auto x138 = x81 + cell[8];
auto x139 = -x118 + x138 + x43;
auto x140 = -V{0.166666666666667}*x123 + V{0.166666666666667}*util::sqrt(x27*(x30 + x31*util::sqrt(V{0.5}*(x130*x130) + V{0.5}*(x132*x132) + V{0.5}*(x133*x133) + x135*x135 + x137*x137 + x139*x139)));
auto x141 = x107 + x52 + x85 + V{1}*cell[0] - V{1.11022302462516e-16}*cell[10] - V{1.11022302462516e-16}*cell[11] - V{1.11022302462516e-16}*cell[12] - V{1}*cell[13] - V{1}*cell[14] - V{1}*cell[15] - V{1}*cell[16] - V{1}*cell[17] - V{1}*cell[18] - V{1.11022302462516e-16}*cell[1] - V{1.11022302462516e-16}*cell[2] - V{1.11022302462516e-16}*cell[3] - V{1}*cell[4] - V{1}*cell[5] - V{1}*cell[6] - V{1}*cell[7] - V{1}*cell[8] - V{1}*cell[9];
auto x142 = V{8.485284}*x125*x126*x140*x141*x28 + V{1};
auto x143 = x26 + V{1};
auto x144 = V{1.5}*x29;
auto x145 = x106*x144;
auto x146 = x144*x84;
auto x147 = x144*x51;
auto x148 = x146 + x147 + V{-1};
auto x149 = x145 + x148;
auto x150 = V{0.471404666666667}*x28;
auto x151 = V{3}*cell[14];
auto x152 = V{3}*cell[16];
auto x153 = V{3}*cell[5];
auto x154 = V{3}*cell[7];
auto x155 = V{3}*cell[13] - V{3}*cell[4];
auto x156 = V{3}*cell[15] - V{3}*cell[6];
auto x157 = x28*(x151 + x152 - x153 - x154 + x155 + x156 + V{3}*cell[10] - V{3}*cell[1]);
auto x158 = V{3}*x29;
auto x159 = x106*x158;
auto x160 = V{3}*cell[18];
auto x161 = V{3}*cell[9];
auto x162 = V{3}*cell[17] - V{3}*cell[8];
auto x163 = x28*(-x151 + x153 + x155 + x160 - x161 + x162 + V{3}*cell[11] - V{3}*cell[2]);
auto x164 = x158*x84;
auto x165 = x145 + V{-1};
auto x166 = x28*(-x152 + x154 + x156 - x160 + x161 + x162 + V{3}*cell[12] - V{3}*cell[3]);
auto x167 = x158*x51;
auto x168 = V{0.235702333333333}*x28;
auto x169 = V{4.5}*x29;
auto x170 = x75 + x82;
auto x171 = x102 + cell[10] + cell[15] + cell[16];
auto x172 = x170 + x171 + V{2}*cell[13] - V{2}*cell[4];
auto x173 = x169*(x172*x172);
auto x174 = x149 + x157;
auto x175 = -x163;
auto x176 = V{2}*cell[14];
auto x177 = V{2}*cell[5];
auto x178 = -cell[10] + cell[1];
auto x179 = x115 + x170 - x176 + x177 + x178 + x21 + x47;
auto x180 = x101 + x104 + cell[10] + cell[13] + cell[14];
auto x181 = x180 + x44 + V{2}*cell[15] - V{2}*cell[6];
auto x182 = x169*(x181*x181);
auto x183 = -x166;
auto x184 = V{2}*cell[16];
auto x185 = V{2}*cell[7];
auto x186 = x111 + x178 - x184 + x185 + x22 + x44 + x78;
auto x187 = x80 + cell[11];
auto x188 = x39 + x49 + cell[12];
auto x189 = x187 + x188 + V{2}*cell[17] - V{2}*cell[8];
auto x190 = x169*(x189*x189);
auto x191 = x149 + x163;
auto x192 = V{2}*cell[18];
auto x193 = V{2}*cell[9];
auto x194 = -cell[11] + cell[2];
auto x195 = x112 + x134 + x188 - x192 + x193 + x194;
auto x196 = -x146;
auto x197 = V{1} - x147;
auto x198 = x196 + x197;
auto x199 = x157 + x198;
auto x200 = -x145;
auto x201 = x163 + x200;
auto x202 = x166 + x200;
auto x203 = -x157;
auto x204 = x119 + x171 + x176 - x177 + x194 + x25 + x42;
auto x205 = -cell[12] + cell[3];
auto x206 = x120 + x138 + x180 + x184 - x185 + x205;
auto x207 = x149 + x166;
auto x208 = x116 + x136 + x187 + x192 - x193 + x205;
cell[0] = V{2.828428}*x125*x126*x140*x141*x28*(x143*x149 + V{1}) + x142*cell[0];
cell[1] = x125*x126*x140*x141*x150*(x143*(x148 + x157 - x159) + V{1}) + x142*cell[1];
cell[2] = x125*x126*x140*x141*x150*(x143*(x147 + x163 - x164 + x165) + V{1}) + x142*cell[2];
cell[3] = x125*x126*x140*x141*x150*(x143*(x146 + x165 + x166 - x167) + V{1}) + x142*cell[3];
cell[4] = x125*x126*x140*x141*x168*(x143*(x163 - x173 + x174) + V{1}) + x142*cell[4];
cell[5] = x125*x126*x140*x141*x168*(x143*(-x169*x179*x179 + x174 + x175) + V{1}) + x142*cell[5];
cell[6] = x125*x126*x140*x141*x168*(x143*(x166 + x174 - x182) + V{1}) + x142*cell[6];
cell[7] = x125*x126*x140*x141*x168*(x143*(-x169*x186*x186 + x174 + x183) + V{1}) + x142*cell[7];
cell[8] = x125*x126*x140*x141*x168*(x143*(x166 - x190 + x191) + V{1}) + x142*cell[8];
cell[9] = x125*x126*x140*x141*x168*(x143*(-x169*x195*x195 + x183 + x191) + V{1}) + x142*cell[9];
cell[10] = -x125*x126*x140*x141*x150*(x143*(x159 + x199) + V{-1}) + x142*cell[10];
cell[11] = -x125*x126*x140*x141*x150*(x143*(x164 + x197 + x201) + V{-1}) + x142*cell[11];
cell[12] = -x125*x126*x140*x141*x150*(x143*(x167 + x196 + x202 + V{1}) + V{-1}) + x142*cell[12];
cell[13] = -x125*x126*x140*x141*x168*(x143*(x173 + x199 + x201) + V{-1}) + x142*cell[13];
cell[14] = x125*x126*x140*x141*x168*(x143*(-x169*x204*x204 + x191 + x203) + V{1}) + x142*cell[14];
cell[15] = -x125*x126*x140*x141*x168*(x143*(x182 + x199 + x202) + V{-1}) + x142*cell[15];
cell[16] = x125*x126*x140*x141*x168*(x143*(-x169*x206*x206 + x203 + x207) + V{1}) + x142*cell[16];
cell[17] = -x125*x126*x140*x141*x168*(x143*(x166 + x190 + x198 + x201) + V{-1}) + x142*cell[17];
cell[18] = x125*x126*x140*x141*x168*(x143*(-x169*x208*x208 + x175 + x207) + V{1}) + x142*cell[18];
return { x27, V{1}*x29*(x106 + x51 + x84) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x0 = cell[11] + cell[17] + cell[18];
auto x1 = cell[10] + cell[13] + cell[14] + cell[15] + cell[16];
auto x2 = x0 + x1 + cell[0] + cell[12] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x3 = V{1} / (x2);
auto x4 = (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x23)*(x23));
auto x5 = x24*x24;
auto x6 = V{0.333333333333333}*cell[4];
auto x7 = V{0.333333333333333}*cell[5];
auto x8 = V{0.333333333333333}*cell[13];
auto x9 = V{0.333333333333333}*cell[14];
auto x10 = V{0.666666666666667}*cell[3];
auto x11 = V{0.666666666666667}*cell[12];
auto x12 = V{1}*x3;
auto x13 = -cell[6];
auto x14 = x13 + cell[7];
auto x15 = -cell[8];
auto x16 = x15 + cell[9];
auto x17 = cell[15] - cell[16];
auto x18 = cell[17] - cell[18];
auto x19 = x14 + x16 + x17 + x18 + cell[12] - cell[3];
auto x20 = x12*(x19*x19);
auto x21 = V{0.333333333333333}*cell[0];
auto x22 = V{0.333333333333333}*cell[1];
auto x25 = V{0.333333333333333}*cell[10];
auto x26 = V{0.666666666666667}*cell[8];
auto x27 = V{0.666666666666667}*cell[9];
auto x28 = V{0.666666666666667}*cell[17];
auto x29 = V{0.666666666666667}*cell[18];
auto x30 = x21 + x22 + x25 - x26 - x27 - x28 - x29;
auto x31 = V{0.333333333333333}*cell[2];
auto x32 = V{0.333333333333333}*cell[11];
auto x33 = V{0.666666666666667}*cell[6];
auto x34 = V{0.666666666666667}*cell[7];
auto x35 = V{0.666666666666667}*cell[15];
auto x36 = V{0.666666666666667}*cell[16];
auto x37 = x31 + x32 - x33 - x34 - x35 - x36;
auto x38 = -x10 - x11 + x20 + x30 + x37 + x6 + x7 + x8 + x9;
auto x39 = V{0.333333333333333}*cell[6];
auto x40 = V{0.333333333333333}*cell[7];
auto x41 = V{0.333333333333333}*cell[15];
auto x42 = V{0.333333333333333}*cell[16];
auto x43 = V{0.666666666666667}*cell[2];
auto x44 = V{0.666666666666667}*cell[11];
auto x45 = -cell[9];
auto x46 = -cell[4];
auto x47 = x46 + cell[5];
auto x48 = cell[13] - cell[14];
auto x49 = x0 + x15 + x45 + x47 + x48 - cell[2];
auto x50 = x12*(x49*x49);
auto x51 = V{0.333333333333333}*cell[3];
auto x52 = V{0.333333333333333}*cell[12];
auto x53 = V{0.666666666666667}*cell[4];
auto x54 = V{0.666666666666667}*cell[5];
auto x55 = V{0.666666666666667}*cell[13];
auto x56 = V{0.666666666666667}*cell[14];
auto x57 = x51 + x52 - x53 - x54 - x55 - x56;
auto x58 = x30 + x39 + x40 + x41 + x42 - x43 - x44 + x50 + x57;
auto x59 = V{0.333333333333333}*cell[8];
auto x60 = V{0.333333333333333}*cell[9];
auto x61 = V{0.333333333333333}*cell[17];
auto x62 = V{0.333333333333333}*cell[18];
auto x63 = V{0.666666666666667}*cell[1];
auto x64 = V{0.666666666666667}*cell[10];
auto x65 = -cell[5];
auto x66 = -cell[7];
auto x67 = x1 + x13 + x46 + x65 + x66 - cell[1];
auto x68 = x12*(x67*x67);
auto x69 = x21 + x37 + x57 + x59 + x60 + x61 + x62 - x63 - x64 + x68;
auto x70 = x3*x67;
auto x71 = x49*x70;
auto x72 = x47 + x71 - cell[13] + cell[14];
auto x73 = x19*x70;
auto x74 = x14 + x73 - cell[15] + cell[16];
auto x75 = x19*x3*x49;
auto x76 = x16 + x75 - cell[17] + cell[18];
auto x77 = util::sqrt(V{0.5}*(x38*x38) + V{0.5}*(x58*x58) + V{0.5}*(x69*x69) + x72*x72 + x74*x74 + x76*x76);
auto x78 = (V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667})/x23;
auto x79 = -x78 + util::sqrt(x2*(x4 + x5*x77));
auto x80 = -x21;
auto x81 = -x51 - x52 + x53 + x54 + x55 + x56 + x80;
auto x82 = -x31 - x32 + x33 + x34 + x35 + x36;
auto x83 = -x59 - x60 - x61 - x62 + x63 + x64 - x68 + x81 + x82;
auto x84 = -x22 - x25 + x26 + x27 + x28 + x29;
auto x85 = -x39 - x40 - x41 - x42 + x43 + x44 - x50 + x81 + x84;
auto x86 = x10 + x11 - x20 - x6 - x7 - x8 + x80 + x82 + x84 - x9;
auto x87 = x48 + x65 - x71 + cell[4];
auto x88 = x17 + x66 - x73 + cell[6];
auto x89 = x18 + x45 - x75 + cell[8];
return -V{8.485284}*x3*(x20 + x50 + x68 + V{1}*cell[0] - V{1.11022302462516e-16}*cell[10] - V{1.11022302462516e-16}*cell[11] - V{1.11022302462516e-16}*cell[12] - V{1}*cell[13] - V{1}*cell[14] - V{1}*cell[15] - V{1}*cell[16] - V{1}*cell[17] - V{1}*cell[18] - V{1.11022302462516e-16}*cell[1] - V{1.11022302462516e-16}*cell[2] - V{1.11022302462516e-16}*cell[3] - V{1}*cell[4] - V{1}*cell[5] - V{1}*cell[6] - V{1}*cell[7] - V{1}*cell[8] - V{1}*cell[9])*util::sqrt((x79*x79)/(((x2)*(x2))*util::pow(x24, 4)))*(-V{0.166666666666667}*x78 + V{0.166666666666667}*util::sqrt(x2*(x4 + x5*util::sqrt(V{0.5}*(x83*x83) + V{0.5}*(x85*x85) + V{0.5}*(x86*x86) + x87*x87 + x88*x88 + x89*x89))))/x77;
}

};

template <typename... FIELDS>
struct ConSmagorinskyEffectiveOmega<BGK,descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = cell[13] + cell[26];
auto x28 = cell[11] + cell[24];
auto x29 = cell[14] + cell[23];
auto x30 = cell[17] + cell[5];
auto x33 = cell[10] + cell[1];
auto x34 = cell[18] + cell[4];
auto x35 = cell[20] + cell[22] + cell[6] + cell[8];
auto x36 = x27 + x28 + x29 + x30 + x33 + x34 + x35 + cell[0] + cell[12] + cell[15] + cell[16] + cell[19] + cell[21] + cell[25] + cell[2] + cell[3] + cell[7] + cell[9];
auto x37 = x36 + V{1};
auto x38 = V{1} / (x37);
auto x39 = V{1} / ((x37)*(x37));
auto x40 = x39/util::pow(x32, 4);
auto x41 = (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[19] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[20] + V{0.0277777777777778}*cell[21] + V{0.0277777777777778}*cell[22] + V{0.0277777777777778}*cell[23] + V{0.0277777777777778}*cell[24] + V{0.0277777777777778}*cell[25] + V{0.0277777777777778}*cell[26] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x31)*(x31));
auto x42 = x32*x32;
auto x43 = V{1}*x38;
auto x44 = -cell[11];
auto x45 = x44 + cell[25];
auto x46 = -cell[12];
auto x47 = -cell[6];
auto x48 = x47 + cell[20];
auto x49 = x46 + x48;
auto x50 = -cell[10];
auto x51 = x50 + cell[24];
auto x52 = -cell[1];
auto x53 = -cell[7];
auto x54 = x53 + cell[19];
auto x55 = x52 + x54;
auto x56 = -cell[5];
auto x57 = x56 + cell[17];
auto x58 = -cell[4];
auto x59 = x58 + cell[18];
auto x60 = x57 + x59;
auto x61 = -cell[13];
auto x62 = x61 + cell[26];
auto x63 = x29 + x62;
auto x64 = x45 + x49 + x51 + x55 + x60 + x63;
auto x65 = x64*x64;
auto x66 = V{0.666666666666667}*cell[10];
auto x67 = V{0.666666666666667}*cell[11];
auto x68 = V{0.666666666666667}*cell[12];
auto x69 = V{0.666666666666667}*cell[13];
auto x70 = V{0.666666666666667}*cell[23];
auto x71 = V{0.666666666666667}*cell[24];
auto x72 = V{0.666666666666667}*cell[25];
auto x73 = V{0.666666666666667}*cell[26];
auto x74 = -V{0.333333333333333}*cell[0];
auto x75 = x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x76 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x77 = x75 + x76 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x78 = -x43*x65 + x77;
auto x79 = -cell[9];
auto x80 = x79 + cell[21];
auto x81 = x44 + x80;
auto x82 = -cell[26];
auto x83 = x82 + cell[23];
auto x84 = x83 + cell[13];
auto x85 = -cell[25];
auto x86 = x85 + cell[12];
auto x87 = -cell[8];
auto x88 = x87 + cell[22];
auto x89 = cell[15] - cell[2];
auto x90 = x88 + x89;
auto x91 = -cell[18];
auto x92 = x30 + x58 + x91;
auto x93 = x51 + x81 + x84 + x86 + x90 + x92;
auto x94 = x93*x93;
auto x95 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x96 = x75 + x95 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x97 = -x43*x94 + x96;
auto x98 = x46 + cell[11] + cell[25];
auto x99 = -cell[24];
auto x100 = cell[16] - cell[3];
auto x101 = x100 + x50;
auto x102 = x101 + x99;
auto x103 = -cell[22];
auto x104 = x103 + x87 + cell[21] + cell[9];
auto x105 = -cell[20];
auto x106 = x105 + x47 + cell[19] + cell[7];
auto x107 = x102 + x104 + x106 + x84 + x98;
auto x108 = x107*x107;
auto x109 = x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x76 + x95 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x110 = -x108*x43 + x109;
auto x111 = x38*x64;
auto x112 = x111*x93;
auto x113 = x91 + cell[4];
auto x114 = x46 + x82 + cell[24];
auto x115 = x85 + cell[11] + cell[23];
auto x116 = x61 + cell[10];
auto x117 = -x112 + x113 + x114 + x115 + x116 + x57;
auto x118 = x107*x111;
auto x119 = x105 + cell[6];
auto x120 = x99 + cell[12];
auto x121 = x120 + x45;
auto x122 = x116 - x118 + x119 + x121 + x54 + x83;
auto x123 = x107*x38*x93;
auto x124 = x46 + cell[10];
auto x125 = x85 + cell[23];
auto x126 = x103 + cell[8];
auto x127 = x126 + x99;
auto x128 = -x123 + x124 + x125 + x127 + x27 + x81;
auto x129 = x37*(x41 + x42*util::sqrt(V{0.5}*(x110*x110) + x117*x117 + x122*x122 + x128*x128 + V{0.5}*(x78*x78) + V{0.5}*(x97*x97)));
auto x130 = (V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[19] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[20] + V{0.166666666666667}*cell[21] + V{0.166666666666667}*cell[22] + V{0.166666666666667}*cell[23] + V{0.166666666666667}*cell[24] + V{0.166666666666667}*cell[25] + V{0.166666666666667}*cell[26] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667})/x31;
auto x131 = -x130;
auto x132 = util::sqrt(x129) + x131;
auto x133 = -cell[17];
auto x134 = x133 + cell[5];
auto x135 = -cell[23];
auto x136 = x135 + x50;
auto x137 = x136 + x27;
auto x138 = x121 + x134 + x137 + x59;
auto x139 = x112 + x138;
auto x140 = -cell[19];
auto x141 = x140 + cell[7];
auto x142 = x141 + x85;
auto x143 = x137 + x142 + x28 + x49;
auto x144 = x118 + x143;
auto x145 = -cell[21];
auto x146 = x145 + cell[9];
auto x147 = x82 + cell[25];
auto x148 = x61 + cell[12];
auto x149 = x136 + x146 + x147 + x148 + x28 + x88;
auto x150 = x123 + x149;
auto x151 = -cell[14];
auto x152 = x119 + x151;
auto x153 = x113 + x134;
auto x154 = x120 + cell[11];
auto x155 = x135 + cell[13];
auto x156 = x155 + x33 + x82;
auto x157 = x142 + x152 + x153 + x154 + x156;
auto x158 = x157*x157;
auto x159 = -x158*x43;
auto x160 = x159 + x77;
auto x161 = x116 + x135 + cell[26];
auto x162 = -cell[15] + cell[2];
auto x163 = x146 + x162;
auto x164 = x133 + x34 + x56;
auto x165 = x127 + x161 + x163 + x164 + x98;
auto x166 = x165*x165;
auto x167 = -x166*x43;
auto x168 = x167 + x96;
auto x169 = -cell[16] + cell[3];
auto x170 = x169 + cell[24];
auto x171 = x170 + x44;
auto x172 = x145 + x79;
auto x173 = x140 + x53;
auto x174 = x161 + x171 + x172 + x173 + x35 + x86;
auto x175 = x174*x174;
auto x176 = -x175*x43;
auto x177 = x109 + x176;
auto x178 = V{0.5}*(x160*x160) + V{0.5}*(x168*x168) + V{0.5}*(x177*x177);
auto x179 = util::sqrt(x178 + x139*x139 + x144*x144 + x150*x150);
auto x180 = -V{0.166666666666667}*x130;
auto x181 = x159 + x167 + x176 - V{1}*cell[0] + V{2}*cell[10] + V{2}*cell[11] + V{2}*cell[12] + V{2}*cell[13] + V{1.11022302462516e-16}*cell[14] + V{1.11022302462516e-16}*cell[15] + V{1.11022302462516e-16}*cell[16] + V{1}*cell[17] + V{1}*cell[18] + V{1}*cell[19] + V{1.11022302462516e-16}*cell[1] + V{1}*cell[20] + V{1}*cell[21] + V{1}*cell[22] + V{2}*cell[23] + V{2}*cell[24] + V{2}*cell[25] + V{2}*cell[26] + V{1.11022302462516e-16}*cell[2] + V{1.11022302462516e-16}*cell[3] + V{1}*cell[4] + V{1}*cell[5] + V{1}*cell[6] + V{1}*cell[7] + V{1}*cell[8] + V{1}*cell[9];
auto x182 = V{-1} + V{7.54247466666667}*x181*x38*(V{0.166666666666667}*util::sqrt(x129) + x180)*util::sqrt(x40*(x132*x132))/x179;
auto x183 = x37*(x179*x42 + x41);
auto x184 = x131 + util::sqrt(x183);
auto x185 = util::sqrt(x40*(x184*x184));
auto x186 = x157*x38;
auto x187 = x138 + x165*x186;
auto x188 = x143 + x174*x186;
auto x189 = x149 + x165*x174*x38;
auto x190 = V{1} / util::sqrt(x178 + x187*x187 + x188*x188 + x189*x189);
auto x191 = x36 + V{1};
auto x192 = V{1.5}*x39;
auto x193 = x192*x65;
auto x194 = x192*x94;
auto x195 = x108*x192;
auto x196 = x194 + x195 + V{-1};
auto x197 = x193 + x196;
auto x198 = x180 + V{0.166666666666667}*util::sqrt(x183);
auto x199 = V{0.558701827160494}*x38;
auto x200 = V{3}*cell[14];
auto x201 = V{3}*cell[1];
auto x202 = V{3}*cell[17];
auto x203 = V{3}*cell[23];
auto x204 = V{3}*cell[24];
auto x205 = V{3}*cell[4];
auto x206 = V{3}*cell[10];
auto x207 = -x206;
auto x208 = V{3}*cell[11];
auto x209 = -x208;
auto x210 = x202 + x203 + x204 - x205 + x207 + x209;
auto x211 = V{3}*cell[19];
auto x212 = V{3}*cell[25];
auto x213 = V{3}*cell[6];
auto x214 = V{3}*cell[12];
auto x215 = -x214;
auto x216 = x211 + x212 - x213 + x215;
auto x217 = V{3}*cell[18];
auto x218 = V{3}*cell[26];
auto x219 = V{3}*cell[5];
auto x220 = V{3}*cell[13];
auto x221 = -x220;
auto x222 = x217 + x218 - x219 + x221;
auto x223 = V{3}*cell[20];
auto x224 = V{3}*cell[7];
auto x225 = x223 - x224;
auto x226 = x38*(x200 - x201 + x210 + x216 + x222 + x225);
auto x227 = V{3}*x39;
auto x228 = V{3}*cell[15];
auto x229 = V{3}*cell[2];
auto x230 = V{3}*cell[21];
auto x231 = V{3}*cell[8];
auto x232 = -x218;
auto x233 = x220 + x230 - x231 + x232;
auto x234 = V{3}*cell[22];
auto x235 = V{3}*cell[9];
auto x236 = -x212;
auto x237 = x214 + x234 - x235 + x236;
auto x238 = -x217 + x219;
auto x239 = x38*(x210 + x228 - x229 + x233 + x237 + x238);
auto x240 = x193 + V{-1};
auto x241 = V{3}*cell[16];
auto x242 = V{3}*cell[3];
auto x243 = -x204;
auto x244 = x208 - x234 + x235 + x243;
auto x245 = -x223 + x224;
auto x246 = x38*(x203 + x207 + x216 + x233 + x241 - x242 + x244 + x245);
auto x247 = V{0.139675456790123}*x38;
auto x248 = V{4.5}*x39;
auto x249 = x80 + x90;
auto x250 = V{2}*cell[11];
auto x251 = V{2}*cell[24];
auto x252 = -x250 + x251;
auto x253 = V{2}*cell[10];
auto x254 = V{2}*cell[23];
auto x255 = -x253 + x254;
auto x256 = x255 + cell[14];
auto x257 = x48 + x55;
auto x258 = V{2}*cell[4];
auto x259 = V{2}*cell[17];
auto x260 = -x258 + x259;
auto x261 = x249 + x252 + x256 + x257 + x260;
auto x262 = x197 + x226;
auto x263 = x239 + x262;
auto x264 = V{2}*cell[25];
auto x265 = V{2}*cell[12];
auto x266 = -x264 + x265;
auto x267 = V{2}*cell[18];
auto x268 = V{2}*cell[5];
auto x269 = -x267 + x268;
auto x270 = V{2}*cell[26];
auto x271 = V{2}*cell[13];
auto x272 = -x270 + x271;
auto x273 = x272 + cell[1];
auto x274 = x141 + x152;
auto x275 = x249 + x266 + x269 + x273 + x274;
auto x276 = -x239;
auto x277 = x262 + x276;
auto x278 = x100 + x104;
auto x279 = x264 - x265;
auto x280 = x52 + x60;
auto x281 = V{2}*cell[6];
auto x282 = V{2}*cell[19];
auto x283 = -x281 + x282;
auto x284 = x256 + x278 + x279 + x280 + x283;
auto x285 = -x246;
auto x286 = x250 - x251;
auto x287 = x151 + x153;
auto x288 = V{2}*cell[20];
auto x289 = V{2}*cell[7];
auto x290 = -x288 + x289;
auto x291 = x273 + x278 + x286 + x287 + x290;
auto x292 = x100 + x106;
auto x293 = x89 + x92;
auto x294 = V{2}*cell[8];
auto x295 = V{2}*cell[21];
auto x296 = -x294 + x295;
auto x297 = x255 + x272 + x292 + x293 + x296;
auto x298 = x197 + x239;
auto x299 = x246 + x298;
auto x300 = x162 + x164;
auto x301 = V{2}*cell[22];
auto x302 = V{2}*cell[9];
auto x303 = -x301 + x302;
auto x304 = x279 + x286 + x292 + x300 + x303;
auto x305 = V{0.0349188641975309}*x38;
auto x306 = V{3}*cell[10];
auto x307 = V{3}*cell[23];
auto x308 = x296 + x89;
auto x309 = x283 + x52;
auto x310 = x45 + cell[14];
auto x311 = x100 + x114 + x260 - x306 + x307 + x308 + x309 + x310 + cell[13];
auto x312 = V{3}*cell[24];
auto x313 = V{3}*cell[11];
auto x314 = x258 - x259;
auto x315 = x162 + x303;
auto x316 = x151 + x290 + cell[1];
auto x317 = x100 + x124 + x147 + x155 - x312 + x313 + x314 + x315 + x316;
auto x318 = V{3}*cell[25];
auto x319 = V{3}*cell[12];
auto x320 = x281 - x282;
auto x321 = x151 + x320;
auto x322 = x301 - x302;
auto x323 = x322 + x89;
auto x324 = x156 + x171 + x269 - x318 + x319 + x321 + x323;
auto x325 = -x203;
auto x326 = -x202 + x205;
auto x327 = -x211 + x213;
auto x328 = x38*(-x200 + x201 + x206 + x208 + x214 + x220 + x232 + x236 + x238 + x243 + x245 + x325 + x326 + x327);
auto x329 = V{3}*cell[26];
auto x330 = V{3}*cell[13];
auto x331 = x101 + x115 + x120 + x269 + x308 + x316 - x329 + x330;
auto x332 = x206 - x230 + x231 + x325;
auto x333 = x38*(x204 + x209 + x218 + x221 + x225 + x237 - x241 + x242 + x327 + x332);
auto x334 = x166*x192;
auto x335 = x175*x192 + V{-1};
auto x336 = x334 + x335;
auto x337 = x38*(x212 + x215 + x222 - x228 + x229 + x244 + x326 + x332);
auto x338 = x158*x192;
auto x339 = x337 + x338;
auto x340 = x333 + x336 + x339;
auto x341 = x328 + x336;
auto x342 = x333 + x338;
auto x343 = x126 + x163;
auto x344 = x253 - x254;
auto x345 = x344 + cell[1];
auto x346 = x274 + x286 + x314 + x343 + x345;
auto x347 = x339 + x341;
auto x348 = -x226;
auto x349 = x267 - x268;
auto x350 = x270 - x271;
auto x351 = x350 + cell[14];
auto x352 = x257 + x279 + x343 + x349 + x351;
auto x353 = x169 + x266;
auto x354 = x172 + cell[22] + cell[8];
auto x355 = x287 + x320 + x345 + x353 + x354;
auto x356 = x341 + x342;
auto x357 = x288 - x289;
auto x358 = x169 + x357;
auto x359 = x252 + x280 + x351 + x354 + x358;
auto x360 = x197 + x246;
auto x361 = x173 + cell[20] + cell[6];
auto x362 = x294 - x295;
auto x363 = x169 + x362;
auto x364 = x300 + x344 + x350 + x361 + x363;
auto x365 = x252 + x293 + x322 + x353 + x361;
auto x366 = x154 + x162 + x306 - x307 + x314 + x321 + x363 + x62 + x85 + cell[1];
auto x367 = x125 + x148 + x260 + x312 - x313 + x323 + x358 + x50 + x52 + cell[14] + cell[26];
auto x368 = x102 + x309 + x315 + x318 - x319 + x349 + x63 + cell[11];
auto x369 = x124 + x135 + x162 + x170 + x310 + x329 - x330 + x349 + x357 + x362 + x52;
cell[0] = -V{2.23480730864198}*x181*x185*x190*x198*x38*(x191*x197 + V{1}) - x182*cell[0];
cell[1] = -x181*x185*x190*x198*x199*(x191*(x196 + x226 - x227*x65) + V{1}) - x182*cell[1];
cell[2] = -x181*x185*x190*x198*x199*(x191*(x195 - x227*x94 + x239 + x240) + V{1}) - x182*cell[2];
cell[3] = -x181*x185*x190*x198*x199*(x191*(-x108*x227 + x194 + x240 + x246) + V{1}) - x182*cell[3];
cell[4] = -x181*x185*x190*x198*x247*(x191*(-x248*x261*x261 + x263) + V{1}) - x182*cell[4];
cell[5] = -x181*x185*x190*x198*x247*(x191*(-x248*x275*x275 + x277) + V{1}) - x182*cell[5];
cell[6] = -x181*x185*x190*x198*x247*(x191*(x246 - x248*x284*x284 + x262) + V{1}) - x182*cell[6];
cell[7] = -x181*x185*x190*x198*x247*(x191*(-x248*x291*x291 + x262 + x285) + V{1}) - x182*cell[7];
cell[8] = -x181*x185*x190*x198*x247*(x191*(-x248*x297*x297 + x299) + V{1}) - x182*cell[8];
cell[9] = -x181*x185*x190*x198*x247*(x191*(-x248*x304*x304 + x285 + x298) + V{1}) - x182*cell[9];
cell[10] = -x181*x185*x190*x198*x305*(x191*(x246 - x248*x311*x311 + x263) + V{1}) - x182*cell[10];
cell[11] = -x181*x185*x190*x198*x305*(x191*(-x248*x317*x317 + x263 + x285) + V{1}) - x182*cell[11];
cell[12] = -x181*x185*x190*x198*x305*(x191*(x246 - x248*x324*x324 + x277) + V{1}) - x182*cell[12];
cell[13] = -x181*x185*x190*x198*x305*(x191*(-x248*x331*x331 - x328 + x340) + V{1}) - x182*cell[13];
cell[14] = -x181*x185*x190*x198*x199*(x191*(-x158*x227 + x341) + V{1}) - x182*cell[14];
cell[15] = -x181*x185*x190*x198*x199*(x191*(-x166*x227 + x335 + x339) + V{1}) - x182*cell[15];
cell[16] = -x181*x185*x190*x198*x199*(x191*(-x175*x227 + x334 + x342 + V{-1}) + V{1}) - x182*cell[16];
cell[17] = -x181*x185*x190*x198*x247*(x191*(-x248*x346*x346 + x347) + V{1}) - x182*cell[17];
cell[18] = -x181*x185*x190*x198*x247*(x191*(-x248*x352*x352 + x298 + x348) + V{1}) - x182*cell[18];
cell[19] = -x181*x185*x190*x198*x247*(x191*(-x248*x355*x355 + x356) + V{1}) - x182*cell[19];
cell[20] = -x181*x185*x190*x198*x247*(x191*(-x248*x359*x359 + x348 + x360) + V{1}) - x182*cell[20];
cell[21] = -x181*x185*x190*x198*x247*(x191*(-x248*x364*x364 + x340) + V{1}) - x182*cell[21];
cell[22] = -x181*x185*x190*x198*x247*(x191*(-x248*x365*x365 + x276 + x360) + V{1}) - x182*cell[22];
cell[23] = -x181*x185*x190*x198*x305*(x191*(-x248*x366*x366 + x333 + x347) + V{1}) - x182*cell[23];
cell[24] = -x181*x185*x190*x198*x305*(x191*(-x248*x367*x367 - x333 + x347) + V{1}) - x182*cell[24];
cell[25] = -x181*x185*x190*x198*x305*(x191*(-x248*x368*x368 - x337 + x356) + V{1}) - x182*cell[25];
cell[26] = -x181*x185*x190*x198*x305*(x191*(-x248*x369*x369 + x299 + x348) + V{1}) - x182*cell[26];
return { x37, V{1}*x39*(x158 + x166 + x175) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x0 = cell[12] + cell[25];
auto x1 = cell[11] + cell[24];
auto x2 = x0 + x1;
auto x3 = cell[18] + cell[2];
auto x4 = cell[10] + cell[20] + cell[22] + cell[26] + cell[3];
auto x5 = cell[17] + cell[23];
auto x6 = x5 + cell[14] + cell[19];
auto x7 = cell[15] + cell[5];
auto x8 = cell[13] + cell[16] + cell[7] + cell[9];
auto x9 = x2 + x3 + x4 + x6 + x7 + x8 + cell[0] + cell[1] + cell[21] + cell[4] + cell[6] + cell[8] + V{1};
auto x10 = V{1} / (x9);
auto x11 = -cell[4];
auto x12 = -cell[8];
auto x13 = x12 + cell[22];
auto x14 = cell[13] - cell[18];
auto x15 = -cell[11];
auto x16 = -cell[25];
auto x17 = x15 + x16 - cell[9];
auto x18 = -cell[10];
auto x19 = -cell[26];
auto x20 = x18 + x19 + cell[21];
auto x21 = x11 + x13 + x14 + x17 + x20 + x5 + x7 + cell[12] + cell[24] - cell[2];
auto x22 = x11 + x15 + cell[18];
auto x23 = -cell[6];
auto x24 = -cell[12];
auto x25 = x23 + x24 + cell[20];
auto x26 = -cell[13];
auto x27 = x18 + x26;
auto x28 = cell[25] + cell[26] - cell[5];
auto x29 = cell[24] - cell[7];
auto x30 = x10*(x22 + x25 + x27 + x28 + x29 + x6 - cell[1]);
auto x33 = -cell[23];
auto x34 = x18 + x33 + cell[13] + cell[26];
auto x35 = -cell[17];
auto x36 = -cell[24];
auto x37 = x35 + x36 + cell[5];
auto x38 = x0 + x22 + x34 + x37;
auto x39 = x21*x30 + x38;
auto x40 = -cell[20];
auto x41 = x24 + x36 - cell[22];
auto x42 = x12 + x20 + x23 + x40 + x41 + x8 + cell[11] + cell[19] + cell[23] + cell[25] - cell[3];
auto x43 = -cell[19];
auto x44 = x16 + x43 + cell[7];
auto x45 = x1 + x25 + x34 + x44;
auto x46 = x30*x42 + x45;
auto x47 = x19 + x33;
auto x48 = -cell[21];
auto x49 = x48 + cell[9];
auto x50 = x13 + x2 + x27 + x47 + x49;
auto x51 = x10*x21*x42 + x50;
auto x52 = V{1}*x10;
auto x53 = cell[10] + cell[11] + cell[4];
auto x54 = cell[12] + cell[6];
auto x55 = x14 + x37 + x40 + x44 + x47 + x53 + x54 - cell[14] + cell[1];
auto x56 = -x52*x55*x55;
auto x57 = V{0.666666666666667}*cell[10];
auto x58 = V{0.666666666666667}*cell[11];
auto x59 = V{0.666666666666667}*cell[12];
auto x60 = V{0.666666666666667}*cell[13];
auto x61 = V{0.666666666666667}*cell[23];
auto x62 = V{0.666666666666667}*cell[24];
auto x63 = V{0.666666666666667}*cell[25];
auto x64 = V{0.666666666666667}*cell[26];
auto x65 = -V{0.333333333333333}*cell[0];
auto x66 = x57 + x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x67 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x68 = x56 + x66 + x67 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x69 = x26 + x33 + cell[8];
auto x70 = x28 + x3 + x35 + x41 + x49 + x53 + x69 - cell[15];
auto x71 = -x52*x70*x70;
auto x72 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x73 = x66 + x71 + x72 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x74 = x17 + x29 + x4 + x43 + x48 + x54 + x69 - cell[16];
auto x75 = -x52*x74*x74;
auto x76 = x57 + x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x67 + x72 + x75 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x77 = V{0.5}*(x68*x68) + V{0.5}*(x73*x73) + V{0.5}*(x76*x76);
auto x78 = x9*((x32*x32)*util::sqrt(x77 + x39*x39 + x46*x46 + x51*x51) + (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[19] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[20] + V{0.0277777777777778}*cell[21] + V{0.0277777777777778}*cell[22] + V{0.0277777777777778}*cell[23] + V{0.0277777777777778}*cell[24] + V{0.0277777777777778}*cell[25] + V{0.0277777777777778}*cell[26] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x31)*(x31)));
auto x79 = (V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[19] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[20] + V{0.166666666666667}*cell[21] + V{0.166666666666667}*cell[22] + V{0.166666666666667}*cell[23] + V{0.166666666666667}*cell[24] + V{0.166666666666667}*cell[25] + V{0.166666666666667}*cell[26] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667})/x31;
auto x80 = util::sqrt(x78) - x79;
auto x81 = x10*x55;
auto x82 = x38 + x70*x81;
auto x83 = x45 + x74*x81;
auto x84 = x10*x70*x74 + x50;
return V{7.54247466666667}*x10*(V{0.166666666666667}*util::sqrt(x78) - V{0.166666666666667}*x79)*(x56 + x71 + x75 - V{1}*cell[0] + V{2}*cell[10] + V{2}*cell[11] + V{2}*cell[12] + V{2}*cell[13] + V{1.11022302462516e-16}*cell[14] + V{1.11022302462516e-16}*cell[15] + V{1.11022302462516e-16}*cell[16] + V{1}*cell[17] + V{1}*cell[18] + V{1}*cell[19] + V{1.11022302462516e-16}*cell[1] + V{1}*cell[20] + V{1}*cell[21] + V{1}*cell[22] + V{2}*cell[23] + V{2}*cell[24] + V{2}*cell[25] + V{2}*cell[26] + V{1.11022302462516e-16}*cell[2] + V{1.11022302462516e-16}*cell[3] + V{1}*cell[4] + V{1}*cell[5] + V{1}*cell[6] + V{1}*cell[7] + V{1}*cell[8] + V{1}*cell[9])*util::sqrt((x80*x80)/(util::pow(x32, 4)*((x9)*(x9))))*V{1} / util::sqrt(x77 + x82*x82 + x83*x83 + x84*x84);
}

};


template <typename... FIELDS>
struct ConStrainSmagorinskyEffectiveOmega<BGK,descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = V{1} / (x12);
auto x10 = x13*x13;
auto x11 = cell[1] + cell[7];
auto x14 = x11 + cell[0] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[8] + V{1};
auto x15 = V{1} / ((x14)*(x14));
auto x16 = -cell[3];
auto x17 = x16 + cell[5];
auto x18 = -cell[2] + cell[6];
auto x19 = x17 + x18 - cell[1] + cell[7];
auto x20 = V{1} / (x14);
auto x21 = -cell[5];
auto x22 = -cell[4] + cell[8];
auto x23 = x11 + x16 + x21 + x22;
auto x24 = x20*x23;
auto x25 = cell[1] - cell[7];
auto x26 = x17 + x25;
auto x27 = x19*x24 + x26;
auto x28 = V{1}*x20;
auto x29 = cell[2] - cell[6];
auto x30 = x21 + x25 + x29 + cell[3];
auto x31 = x30*x30;
auto x32 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x33 = -x28*x31 + x32 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x34 = x33*x33;
auto x35 = x23*x23;
auto x36 = -x28*x35 + x32 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x37 = x36*x36;
auto x38 = V{0.5}*x34 + V{0.5}*x37;
auto x39 = -x9*(V{0.198201185833787}*cell[0] + V{0.198201185833787}*cell[1] + V{0.198201185833787}*cell[2] + V{0.198201185833787}*cell[3] + V{0.198201185833787}*cell[4] + V{0.198201185833787}*cell[5] + V{0.198201185833787}*cell[6] + V{0.198201185833787}*cell[7] + V{0.198201185833787}*cell[8] + V{0.198201185833787}) + util::sqrt(x14*(V{1.4142135623731}*x10*util::sqrt(x38 + x27*x27) + (V{0.0392837100659193}*cell[0] + V{0.0392837100659193}*cell[1] + V{0.0392837100659193}*cell[2] + V{0.0392837100659193}*cell[3] + V{0.0392837100659193}*cell[4] + V{0.0392837100659193}*cell[5] + V{0.0392837100659193}*cell[6] + V{0.0392837100659193}*cell[7] + V{0.0392837100659193}*cell[8] + V{0.0392837100659193})/((x12)*(x12))));
auto x40 = -x24*x30 + x26;
auto x41 = x40*x40;
auto x42 = V{1} / (V{3.56762134500816}*x10*util::sqrt(x15*(x39*x39)*V{1} / (x34 + x37 + V{2}*x41)*(x38 + x41)/util::pow(x13, 4)) + V{1}*x9);
auto x43 = V{1.5}*x15;
auto x44 = x35*x43;
auto x45 = x43*(x19*x19) + V{-1};
auto x46 = x44 + x45;
auto x47 = V{1} - x42;
auto x48 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x49 = V{3}*cell[2];
auto x50 = V{3}*cell[3];
auto x51 = V{3}*cell[6];
auto x52 = V{3}*cell[7];
auto x53 = V{3}*cell[1];
auto x54 = V{3}*cell[5];
auto x55 = x53 - x54;
auto x56 = x20*(x49 + x50 - x51 - x52 + x55);
auto x57 = V{4.5}*x15;
auto x58 = x22 + x29 + V{2}*cell[1] - V{2}*cell[5];
auto x59 = x57*(x58*x58);
auto x60 = V{1} - x44;
auto x61 = -x50 + x52;
auto x62 = x20*(x55 + x61 - V{3}*cell[4] + V{3}*cell[8]);
auto x63 = x31*x43;
auto x64 = x62 - x63;
auto x65 = x60 + x64;
auto x66 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x67 = V{3}*x15;
auto x68 = x31*x67 + x60;
auto x69 = V{2}*cell[3];
auto x70 = V{2}*cell[7];
auto x71 = x18 + x22 - x69 + x70;
auto x72 = x35*x67;
auto x73 = -x56;
auto x74 = x29 + x69 - x70 + cell[4] - cell[8];
cell[0] = -x42*(x46*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + V{0.444444444444444}) + V{1}*x47*cell[0];
cell[1] = x42*(x48*(x56 + x59 + x65) + V{-0.0277777777777778}) + V{1}*x47*cell[1];
cell[2] = x42*(x66*(x56 + x68) + V{-0.111111111111111}) + V{1}*x47*cell[2];
cell[3] = -x42*(x48*(x20*(-x49 + x51 - x53 + x54 + x61) + x46 - x57*x71*x71 + x62) + V{0.0277777777777778}) + V{1}*x47*cell[3];
cell[4] = -x42*(x66*(x45 + x62 - x72) + V{0.111111111111111}) + V{1}*x47*cell[4];
cell[5] = -x42*(x48*(x44 + x56 - x59 + x62 + x63 + V{-1}) + V{0.0277777777777778}) + V{1}*x47*cell[5];
cell[6] = x42*(x66*(x68 + x73) + V{-0.111111111111111}) + V{1}*x47*cell[6];
cell[7] = x42*(x48*(x57*(x74*x74) + x65 + x73) + V{-0.0277777777777778}) + V{1}*x47*cell[7];
cell[8] = x42*(x66*(x64 + x72 + V{1}) + V{-0.111111111111111}) + V{1}*x47*cell[8];
return { x14, V{1}*x15*(x31 + x35) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::descriptors::OMEGA>();
auto x13 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = V{1} / (x12);
auto x1 = x13*x13;
auto x2 = cell[2] + cell[3];
auto x3 = cell[1] + cell[7] + cell[8];
auto x4 = x2 + x3 + cell[0] + cell[4] + cell[5] + cell[6] + V{1};
auto x5 = -cell[3];
auto x6 = x5 + cell[5];
auto x7 = V{1} / (x4);
auto x8 = -cell[5];
auto x9 = x3 + x5 + x8 - cell[4];
auto x10 = x7*x9;
auto x11 = cell[1] - cell[7];
auto x14 = x11 + x6;
auto x15 = x10*(x6 - cell[1] - cell[2] + cell[6] + cell[7]) + x14;
auto x16 = V{1}*x7;
auto x17 = x11 + x2 + x8 - cell[6];
auto x18 = -V{0.333333333333333}*cell[0] + V{0.666666666666667}*cell[1] + V{0.666666666666667}*cell[3] + V{0.666666666666667}*cell[5] + V{0.666666666666667}*cell[7];
auto x19 = -x16*x17*x17 + x18 + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[4] + V{0.666666666666667}*cell[6] - V{0.333333333333333}*cell[8];
auto x20 = x19*x19;
auto x21 = -x16*x9*x9 + x18 - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[4] - V{0.333333333333333}*cell[6] + V{0.666666666666667}*cell[8];
auto x22 = x21*x21;
auto x23 = V{0.5}*x20 + V{0.5}*x22;
auto x24 = -x0*(V{0.198201185833787}*cell[0] + V{0.198201185833787}*cell[1] + V{0.198201185833787}*cell[2] + V{0.198201185833787}*cell[3] + V{0.198201185833787}*cell[4] + V{0.198201185833787}*cell[5] + V{0.198201185833787}*cell[6] + V{0.198201185833787}*cell[7] + V{0.198201185833787}*cell[8] + V{0.198201185833787}) + util::sqrt(x4*(V{1.4142135623731}*x1*util::sqrt(x23 + x15*x15) + (V{0.0392837100659193}*cell[0] + V{0.0392837100659193}*cell[1] + V{0.0392837100659193}*cell[2] + V{0.0392837100659193}*cell[3] + V{0.0392837100659193}*cell[4] + V{0.0392837100659193}*cell[5] + V{0.0392837100659193}*cell[6] + V{0.0392837100659193}*cell[7] + V{0.0392837100659193}*cell[8] + V{0.0392837100659193})/((x12)*(x12))));
auto x25 = -x10*x17 + x14;
auto x26 = x25*x25;
return V{1} / (V{1}*x0 + V{3.56762134500816}*x1*util::sqrt((x24*x24)*V{1} / (x20 + x22 + V{2}*x26)*(x23 + x26)/(util::pow(x13, 4)*((x4)*(x4)))));
}

};

template <typename... FIELDS>
struct ConStrainSmagorinskyEffectiveOmega<BGK,descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x19 = V{1} / (x23);
auto x20 = x24*x24;
auto x21 = cell[15] + cell[17];
auto x22 = x21 + cell[12];
auto x25 = cell[11] + cell[18];
auto x26 = cell[10] + cell[14] + cell[16];
auto x27 = cell[6] + cell[7];
auto x28 = cell[4] + cell[5];
auto x29 = cell[8] + cell[9];
auto x30 = cell[13] + cell[3];
auto x31 = x22 + x25 + x26 + x27 + x28 + x29 + x30 + cell[0] + cell[1] + cell[2] + V{1};
auto x32 = V{1} / ((x31)*(x31));
auto x33 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x34 = V{0.333333333333333}*cell[4];
auto x35 = V{0.333333333333333}*cell[5];
auto x36 = V{0.333333333333333}*cell[13];
auto x37 = V{0.333333333333333}*cell[14];
auto x38 = V{1} / (x31);
auto x39 = V{1}*x38;
auto x40 = -cell[3];
auto x41 = -cell[18];
auto x42 = -cell[8];
auto x43 = x42 + cell[9];
auto x44 = x40 + x41 + x43;
auto x45 = -cell[16];
auto x46 = -cell[6];
auto x47 = x46 + cell[7];
auto x48 = x45 + x47;
auto x49 = x22 + x44 + x48;
auto x50 = x49*x49;
auto x51 = V{0.333333333333333}*cell[0];
auto x52 = V{0.333333333333333}*cell[1];
auto x53 = V{0.333333333333333}*cell[10];
auto x54 = x51 + x52 + x53 - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x55 = V{0.333333333333333}*cell[2];
auto x56 = V{0.333333333333333}*cell[11];
auto x57 = x55 + x56 - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x58 = x34 + x35 + x36 + x37 + x39*x50 + x54 + x57 - V{0.666666666666667}*cell[12] - V{0.666666666666667}*cell[3];
auto x59 = V{0.333333333333333}*cell[6];
auto x60 = V{0.333333333333333}*cell[7];
auto x61 = V{0.333333333333333}*cell[15];
auto x62 = V{0.333333333333333}*cell[16];
auto x63 = cell[13] + cell[17];
auto x64 = -cell[2];
auto x65 = -cell[9];
auto x66 = x25 + x42 + x64 + x65;
auto x67 = -cell[14];
auto x68 = -cell[4];
auto x69 = x68 + cell[5];
auto x70 = x67 + x69;
auto x71 = x63 + x66 + x70;
auto x72 = x71*x71;
auto x73 = V{0.333333333333333}*cell[3];
auto x74 = V{0.333333333333333}*cell[12];
auto x75 = x73 + x74 - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x76 = x39*x72 + x54 + x59 + x60 + x61 + x62 + x75 - V{0.666666666666667}*cell[11] - V{0.666666666666667}*cell[2];
auto x77 = V{0.333333333333333}*cell[8];
auto x78 = V{0.333333333333333}*cell[9];
auto x79 = V{0.333333333333333}*cell[17];
auto x80 = V{0.333333333333333}*cell[18];
auto x81 = cell[13] + cell[15];
auto x82 = -cell[1];
auto x83 = -cell[7];
auto x84 = x46 + x82 + x83;
auto x85 = -cell[5];
auto x86 = x68 + x85;
auto x87 = x26 + x81 + x84 + x86;
auto x88 = x87*x87;
auto x89 = x39*x88 + x51 + x57 + x75 + x77 + x78 + x79 + x80 - V{0.666666666666667}*cell[10] - V{0.666666666666667}*cell[1];
auto x90 = x38*x87;
auto x91 = -cell[13];
auto x92 = x91 + cell[14];
auto x93 = x69 + x71*x90 + x92;
auto x94 = -cell[15];
auto x95 = x94 + cell[16];
auto x96 = x47 + x49*x90 + x95;
auto x97 = -cell[17];
auto x98 = x97 + cell[18];
auto x99 = x38*x49*x71 + x43 + x98;
auto x100 = -x19*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667}) + util::sqrt(x31*(x20*util::sqrt(V{0.5}*(x58*x58) + V{0.5}*(x76*x76) + V{0.5}*(x89*x89) + x93*x93 + x96*x96 + x99*x99) + x33/((x23)*(x23))));
auto x101 = V{1} / (V{1}*x19 + V{3}*x20*util::sqrt(x32*(x100*x100)/util::pow(x24, 4)));
auto x102 = V{1.5}*x32;
auto x103 = x102*x88;
auto x104 = x102*x72;
auto x105 = x102*x50;
auto x106 = x104 + x105 + V{-1};
auto x107 = x103 + x106;
auto x108 = V{1} - x101;
auto x109 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x110 = V{3}*cell[14];
auto x111 = V{3}*cell[16];
auto x112 = V{3}*cell[5];
auto x113 = V{3}*cell[7];
auto x114 = V{3}*cell[13] - V{3}*cell[4];
auto x115 = V{3}*cell[15] - V{3}*cell[6];
auto x116 = x38*(x110 + x111 - x112 - x113 + x114 + x115 + V{3}*cell[10] - V{3}*cell[1]);
auto x117 = V{3}*x32;
auto x118 = x117*x88;
auto x119 = V{3}*cell[18];
auto x120 = V{3}*cell[9];
auto x121 = V{3}*cell[17] - V{3}*cell[8];
auto x122 = x38*(-x110 + x112 + x114 + x119 - x120 + x121 + V{3}*cell[11] - V{3}*cell[2]);
auto x123 = x117*x72;
auto x124 = x103 + V{-1};
auto x125 = x38*(-x111 + x113 + x115 - x119 + x120 + x121 + V{3}*cell[12] - V{3}*cell[3]);
auto x126 = x117*x50;
auto x127 = V{4.5}*x32;
auto x128 = x84 + cell[10] + cell[16];
auto x129 = x128 + x21 + x66 + V{2}*cell[13] - V{2}*cell[4];
auto x130 = x127*(x129*x129);
auto x131 = x107 + x116;
auto x132 = -x122;
auto x133 = V{2}*cell[14];
auto x134 = V{2}*cell[5];
auto x135 = -cell[10] + cell[17] + cell[1];
auto x136 = -x133 + x134 + x135 + x27 + x45 + x66 + x94;
auto x137 = x44 + cell[12];
auto x138 = x82 + x86 + cell[10] + cell[14];
auto x139 = x137 + x138 + x63 + V{2}*cell[15] - V{2}*cell[6];
auto x140 = x127*(x139*x139);
auto x141 = -x125;
auto x142 = V{2}*cell[16];
auto x143 = V{2}*cell[7];
auto x144 = x135 + x137 - x142 + x143 + x28 + x67 + x91;
auto x145 = x40 + x48 + cell[12];
auto x146 = x64 + x70 + cell[11];
auto x147 = x145 + x146 + x81 + V{2}*cell[17] - V{2}*cell[8];
auto x148 = x127*(x147*x147);
auto x149 = x107 + x122;
auto x150 = V{2}*cell[18];
auto x151 = V{2}*cell[9];
auto x152 = -cell[11] + cell[15] + cell[2];
auto x153 = x145 - x150 + x151 + x152 + x85 + x92 + cell[4];
auto x154 = -x104;
auto x155 = V{1} - x105;
auto x156 = x154 + x155;
auto x157 = x116 + x156;
auto x158 = -x103;
auto x159 = x122 + x158;
auto x160 = x125 + x158;
auto x161 = -x116;
auto x162 = x128 + x133 - x134 + x152 + x29 + x41 + x97;
auto x163 = x30 - cell[12];
auto x164 = x138 + x142 - x143 + x163 + x65 + x98 + cell[8];
auto x165 = x107 + x125;
auto x166 = x146 + x150 - x151 + x163 + x83 + x95 + cell[6];
cell[0] = -x101*(x107*(x34 + x35 + x36 + x37 + x51 + x52 + x53 + x55 + x56 + x59 + x60 + x61 + x62 + x73 + x74 + x77 + x78 + x79 + x80 + V{0.333333333333333}) + V{0.333333333333333}) + V{1}*x108*cell[0];
cell[1] = -x101*(x109*(x106 + x116 - x118) + V{0.0555555555555556}) + V{1}*x108*cell[1];
cell[2] = -x101*(x109*(x105 + x122 - x123 + x124) + V{0.0555555555555556}) + V{1}*x108*cell[2];
cell[3] = -x101*(x109*(x104 + x124 + x125 - x126) + V{0.0555555555555556}) + V{1}*x108*cell[3];
cell[4] = -x101*(x33*(x122 - x130 + x131) + V{0.0277777777777778}) + V{1}*x108*cell[4];
cell[5] = -x101*(x33*(-x127*x136*x136 + x131 + x132) + V{0.0277777777777778}) + V{1}*x108*cell[5];
cell[6] = -x101*(x33*(x125 + x131 - x140) + V{0.0277777777777778}) + V{1}*x108*cell[6];
cell[7] = -x101*(x33*(-x127*x144*x144 + x131 + x141) + V{0.0277777777777778}) + V{1}*x108*cell[7];
cell[8] = -x101*(x33*(x125 - x148 + x149) + V{0.0277777777777778}) + V{1}*x108*cell[8];
cell[9] = -x101*(x33*(-x127*x153*x153 + x141 + x149) + V{0.0277777777777778}) + V{1}*x108*cell[9];
cell[10] = x101*(x109*(x118 + x157) + V{-0.0555555555555556}) + V{1}*x108*cell[10];
cell[11] = x101*(x109*(x123 + x155 + x159) + V{-0.0555555555555556}) + V{1}*x108*cell[11];
cell[12] = x101*(x109*(x126 + x154 + x160 + V{1}) + V{-0.0555555555555556}) + V{1}*x108*cell[12];
cell[13] = x101*(x33*(x130 + x157 + x159) + V{-0.0277777777777778}) + V{1}*x108*cell[13];
cell[14] = -x101*(x33*(-x127*x162*x162 + x149 + x161) + V{0.0277777777777778}) + V{1}*x108*cell[14];
cell[15] = x101*(x33*(x140 + x157 + x160) + V{-0.0277777777777778}) + V{1}*x108*cell[15];
cell[16] = -x101*(x33*(-x127*x164*x164 + x161 + x165) + V{0.0277777777777778}) + V{1}*x108*cell[16];
cell[17] = x101*(x33*(x125 + x148 + x156 + x159) + V{-0.0277777777777778}) + V{1}*x108*cell[17];
cell[18] = -x101*(x33*(-x127*x166*x166 + x132 + x165) + V{0.0277777777777778}) + V{1}*x108*cell[18];
return { x31, V{1}*x32*(x50 + x72 + x88) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::descriptors::OMEGA>();
auto x24 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x0 = V{1} / (x23);
auto x1 = x24*x24;
auto x2 = cell[12] + cell[15] + cell[17];
auto x3 = cell[11] + cell[13] + cell[18];
auto x4 = cell[10] + cell[14] + cell[16];
auto x5 = x2 + x3 + x4 + cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x6 = V{1} / (x5);
auto x7 = V{1}*x6;
auto x8 = -cell[6];
auto x9 = x8 + cell[7];
auto x10 = -cell[8];
auto x11 = x10 + cell[9];
auto x12 = x11 + x2 + x9 - cell[16] - cell[18] - cell[3];
auto x13 = V{0.333333333333333}*cell[0];
auto x14 = x13 + V{0.333333333333333}*cell[10] - V{0.666666666666667}*cell[17] - V{0.666666666666667}*cell[18] + V{0.333333333333333}*cell[1] - V{0.666666666666667}*cell[8] - V{0.666666666666667}*cell[9];
auto x15 = V{0.333333333333333}*cell[11] - V{0.666666666666667}*cell[15] - V{0.666666666666667}*cell[16] + V{0.333333333333333}*cell[2] - V{0.666666666666667}*cell[6] - V{0.666666666666667}*cell[7];
auto x16 = x14 + x15 + x7*(x12*x12) - V{0.666666666666667}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] - V{0.666666666666667}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5];
auto x17 = -cell[4];
auto x18 = x17 + cell[5];
auto x19 = x10 + x18 + x3 - cell[14] + cell[17] - cell[2] - cell[9];
auto x20 = V{0.333333333333333}*cell[12] - V{0.666666666666667}*cell[13] - V{0.666666666666667}*cell[14] + V{0.333333333333333}*cell[3] - V{0.666666666666667}*cell[4] - V{0.666666666666667}*cell[5];
auto x21 = x14 + x20 + x7*(x19*x19) - V{0.666666666666667}*cell[11] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] - V{0.666666666666667}*cell[2] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7];
auto x22 = x17 + x4 + x8 + cell[13] + cell[15] - cell[1] - cell[5] - cell[7];
auto x25 = x13 + x15 + x20 + x7*(x22*x22) - V{0.666666666666667}*cell[10] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] - V{0.666666666666667}*cell[1] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9];
auto x26 = x22*x6;
auto x27 = x18 + x19*x26 - cell[13] + cell[14];
auto x28 = x12*x26 + x9 - cell[15] + cell[16];
auto x29 = x11 + x12*x19*x6 - cell[17] + cell[18];
auto x30 = -x0*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667}) + util::sqrt(x5*(x1*util::sqrt(V{0.5}*(x16*x16) + V{0.5}*(x21*x21) + V{0.5}*(x25*x25) + x27*x27 + x28*x28 + x29*x29) + (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x23)*(x23))));
return V{1} / (V{1}*x0 + V{3}*x1*util::sqrt((x30*x30)/(util::pow(x24, 4)*((x5)*(x5)))));
}

};

template <typename... FIELDS>
struct ConStrainSmagorinskyEffectiveOmega<BGK,descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = V{1} / (x31);
auto x28 = x32*x32;
auto x29 = cell[10] + cell[6];
auto x30 = x29 + cell[24];
auto x33 = cell[17] + cell[23];
auto x34 = cell[19] + cell[21];
auto x35 = x30 + x33 + x34 + cell[0] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[18] + cell[1] + cell[20] + cell[22] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[7] + cell[8] + cell[9] + V{1};
auto x36 = V{1} / ((x35)*(x35));
auto x37 = V{1} / (x35);
auto x38 = V{1}*x37;
auto x39 = -cell[17];
auto x40 = x39 + cell[5];
auto x41 = -cell[19];
auto x42 = x41 + cell[7];
auto x43 = -cell[25];
auto x44 = x43 + cell[11];
auto x45 = x42 + x44;
auto x46 = -cell[18];
auto x47 = -cell[20];
auto x48 = x46 + x47;
auto x49 = -cell[24];
auto x50 = x49 + cell[4];
auto x51 = -cell[26];
auto x52 = x51 + cell[12];
auto x53 = -cell[23];
auto x54 = -cell[14] + cell[1];
auto x55 = x54 + cell[13];
auto x56 = x53 + x55;
auto x57 = x29 + x40 + x45 + x48 + x50 + x52 + x56;
auto x58 = x57*x57;
auto x59 = V{0.666666666666667}*cell[10];
auto x60 = V{0.666666666666667}*cell[11];
auto x61 = V{0.666666666666667}*cell[12];
auto x62 = V{0.666666666666667}*cell[13];
auto x63 = V{0.666666666666667}*cell[23];
auto x64 = V{0.666666666666667}*cell[24];
auto x65 = V{0.666666666666667}*cell[25];
auto x66 = V{0.666666666666667}*cell[26];
auto x67 = -V{0.333333333333333}*cell[0];
auto x68 = x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x69 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x70 = -x38*x58 + x68 + x69 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x71 = -cell[21];
auto x72 = x71 + cell[9];
auto x73 = x72 + cell[11];
auto x74 = x53 + cell[26];
auto x75 = x74 + cell[8];
auto x76 = -cell[5];
auto x77 = -cell[22];
auto x78 = x76 + x77;
auto x79 = -cell[13];
auto x80 = x79 + cell[25];
auto x81 = -cell[12];
auto x82 = -cell[15] + cell[2];
auto x83 = x82 + cell[10];
auto x84 = x81 + x83;
auto x85 = x39 + cell[18];
auto x86 = x50 + x73 + x75 + x78 + x80 + x84 + x85;
auto x87 = x86*x86;
auto x88 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x89 = -x38*x87 + x68 + x88 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x90 = -cell[11];
auto x91 = -cell[7];
auto x92 = x90 + x91;
auto x93 = -cell[9];
auto x94 = x43 + x93;
auto x95 = -cell[16];
auto x96 = x79 + cell[12];
auto x97 = x95 + x96 + cell[3];
auto x98 = x71 + cell[22];
auto x99 = x41 + cell[20];
auto x100 = x30 + x75 + x92 + x94 + x97 + x98 + x99;
auto x101 = x100*x100;
auto x102 = -x101*x38 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 + x69 + x88 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x103 = -cell[8];
auto x104 = x103 + cell[22];
auto x105 = x104 + cell[24];
auto x106 = -cell[10];
auto x107 = x106 + cell[13];
auto x108 = x107 + cell[21];
auto x109 = cell[15] - cell[2];
auto x110 = x109 + x90;
auto x111 = -cell[4];
auto x112 = x111 + cell[5];
auto x113 = x112 + x46;
auto x114 = x105 + x108 + x110 + x113 + x33 + x52 + x94;
auto x115 = -cell[6];
auto x116 = x115 + cell[20];
auto x117 = x81 + cell[24];
auto x118 = x116 + x117;
auto x119 = x76 + cell[19];
auto x120 = x111 + cell[18];
auto x121 = cell[14] - cell[1];
auto x122 = x120 + x121;
auto x123 = x106 + cell[26];
auto x124 = x118 + x119 + x122 + x123 + x33 + x80 + x92;
auto x125 = x124*x37;
auto x126 = x90 + cell[13] + cell[25];
auto x127 = x106 + x49 + cell[12];
auto x128 = x114*x125 + x120 + x126 + x127 + x40 + x74;
auto x129 = x47 + x77;
auto x130 = cell[16] - cell[3];
auto x131 = x130 + x51;
auto x132 = x103 + cell[9];
auto x133 = x115 + cell[19] + cell[7];
auto x134 = x49 + cell[11] + cell[23];
auto x135 = x108 + x129 + x131 + x132 + x133 + x134 + x81 + cell[25];
auto x136 = x107 + x118 + x125*x135 + x45 + x74;
auto x137 = x53 + cell[25];
auto x138 = x137 + x51;
auto x139 = x106 + x96;
auto x140 = x105 + x114*x135*x37 + x138 + x139 + x73;
auto x141 = -x27*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[19] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[20] + V{0.166666666666667}*cell[21] + V{0.166666666666667}*cell[22] + V{0.166666666666667}*cell[23] + V{0.166666666666667}*cell[24] + V{0.166666666666667}*cell[25] + V{0.166666666666667}*cell[26] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667}) + util::sqrt(x35*(x28*util::sqrt(V{0.5}*(x102*x102) + x128*x128 + x136*x136 + x140*x140 + V{0.5}*(x70*x70) + V{0.5}*(x89*x89)) + (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[19] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[20] + V{0.0277777777777778}*cell[21] + V{0.0277777777777778}*cell[22] + V{0.0277777777777778}*cell[23] + V{0.0277777777777778}*cell[24] + V{0.0277777777777778}*cell[25] + V{0.0277777777777778}*cell[26] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x31)*(x31))));
auto x142 = V{1} / (V{1}*x27 + V{3}*x28*util::sqrt(x36*(x141*x141)/util::pow(x32, 4)));
auto x143 = V{1.5}*x36;
auto x144 = x124*x124;
auto x145 = x143*x144;
auto x146 = x114*x114;
auto x147 = x143*x146;
auto x148 = x135*x135;
auto x149 = x143*x148;
auto x150 = x147 + x149 + V{-1};
auto x151 = x145 + x150;
auto x152 = V{1} - x142;
auto x153 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x154 = V{3}*cell[14];
auto x155 = V{3}*cell[1];
auto x156 = V{3}*cell[17];
auto x157 = V{3}*cell[23];
auto x158 = V{3}*cell[24];
auto x159 = V{3}*cell[4];
auto x160 = V{3}*cell[10];
auto x161 = -x160;
auto x162 = V{3}*cell[11];
auto x163 = -x162;
auto x164 = x156 + x157 + x158 - x159 + x161 + x163;
auto x165 = V{3}*cell[19];
auto x166 = V{3}*cell[25];
auto x167 = V{3}*cell[6];
auto x168 = V{3}*cell[12];
auto x169 = -x168;
auto x170 = x165 + x166 - x167 + x169;
auto x171 = V{3}*cell[18];
auto x172 = V{3}*cell[26];
auto x173 = V{3}*cell[5];
auto x174 = V{3}*cell[13];
auto x175 = -x174;
auto x176 = x171 + x172 - x173 + x175;
auto x177 = V{3}*cell[20];
auto x178 = V{3}*cell[7];
auto x179 = x177 - x178;
auto x180 = x37*(x154 - x155 + x164 + x170 + x176 + x179);
auto x181 = V{3}*x36;
auto x182 = V{3}*cell[15];
auto x183 = V{3}*cell[2];
auto x184 = V{3}*cell[21];
auto x185 = V{3}*cell[8];
auto x186 = -x172;
auto x187 = x174 + x184 - x185 + x186;
auto x188 = V{3}*cell[22];
auto x189 = V{3}*cell[9];
auto x190 = -x166;
auto x191 = x168 + x188 - x189 + x190;
auto x192 = -x171 + x173;
auto x193 = x37*(x164 + x182 - x183 + x187 + x191 + x192);
auto x194 = x145 + V{-1};
auto x195 = V{3}*cell[16];
auto x196 = V{3}*cell[3];
auto x197 = -x158;
auto x198 = x162 - x188 + x189 + x197;
auto x199 = -x177 + x178;
auto x200 = x37*(x157 + x161 + x170 + x187 + x195 - x196 + x198 + x199);
auto x201 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x202 = V{4.5}*x36;
auto x203 = V{2}*cell[10];
auto x204 = V{2}*cell[23];
auto x205 = -x203 + x204;
auto x206 = x109 + x205;
auto x207 = V{2}*cell[11];
auto x208 = -x207;
auto x209 = V{2}*cell[24];
auto x210 = x208 + x209 + x93;
auto x211 = x116 + x121 + x91;
auto x212 = V{2}*cell[4];
auto x213 = V{2}*cell[17];
auto x214 = -x212 + x213;
auto x215 = x104 + x206 + x210 + x211 + x214 + x34;
auto x216 = x151 + x180;
auto x217 = x193 + x216;
auto x218 = x42 + x54 + cell[6];
auto x219 = V{2}*cell[26];
auto x220 = V{2}*cell[13];
auto x221 = -x219 + x220;
auto x222 = x221 + cell[21];
auto x223 = V{2}*cell[25];
auto x224 = -x223;
auto x225 = V{2}*cell[12];
auto x226 = x224 + x225 + x93;
auto x227 = V{2}*cell[18];
auto x228 = V{2}*cell[5];
auto x229 = -x227 + x228;
auto x230 = x109 + x229;
auto x231 = x104 + x218 + x222 + x226 + x230 + x47;
auto x232 = -x193;
auto x233 = x216 + x232;
auto x234 = x130 + x132;
auto x235 = x223 - x225;
auto x236 = x122 + cell[17];
auto x237 = V{2}*cell[6];
auto x238 = V{2}*cell[19];
auto x239 = -x237 + x238;
auto x240 = x205 + x234 + x235 + x236 + x239 + x78 + cell[21];
auto x241 = -x200;
auto x242 = x207 - x209;
auto x243 = x242 + cell[4];
auto x244 = V{2}*cell[20];
auto x245 = V{2}*cell[7];
auto x246 = -x244 + x245;
auto x247 = x246 + x54;
auto x248 = x40 + x46;
auto x249 = x222 + x234 + x243 + x247 + x248 + x77;
auto x250 = V{2}*cell[8];
auto x251 = V{2}*cell[21];
auto x252 = -x250 + x251;
auto x253 = x130 + x252;
auto x254 = x112 + x133 + x206 + x221 + x253 + x48 + cell[17];
auto x255 = x151 + x193;
auto x256 = x200 + x255;
auto x257 = x235 + x82;
auto x258 = V{2}*cell[22];
auto x259 = V{2}*cell[9];
auto x260 = x130 - x258 + x259;
auto x261 = x115 + x119 + x243 + x257 + x260 + x47 + x85 + cell[7];
auto x262 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x263 = V{3}*cell[10];
auto x264 = V{3}*cell[23];
auto x265 = x121 + x239;
auto x266 = x109 + x214;
auto x267 = x117 + x126 + x131 + x252 - x263 + x264 + x265 + x266;
auto x268 = V{3}*cell[24];
auto x269 = V{3}*cell[11];
auto x270 = x212 - x213;
auto x271 = x138 + x246 + x260 - x268 + x269 + x270 + x55 + x84;
auto x272 = -x238;
auto x273 = V{3}*cell[25];
auto x274 = V{3}*cell[12];
auto x275 = -x259;
auto x276 = x95 + cell[3];
auto x277 = x258 + x275 + x276;
auto x278 = x110 + x229 + x237 + x272 - x273 + x274 + x277 + x51 + x56 + cell[10] + cell[24];
auto x279 = -x157;
auto x280 = -x156 + x159;
auto x281 = -x165 + x167;
auto x282 = x37*(-x154 + x155 + x160 + x162 + x168 + x174 + x186 + x190 + x192 + x197 + x199 + x279 + x280 + x281);
auto x283 = V{3}*cell[26];
auto x284 = V{3}*cell[13];
auto x285 = x127 + x230 + x247 + x253 - x283 + x284 + x44 + cell[23];
auto x286 = x160 - x184 + x185 + x279;
auto x287 = x37*(x158 + x163 + x172 + x175 + x179 + x191 - x195 + x196 + x281 + x286);
auto x288 = x143*x87;
auto x289 = x101*x143 + V{-1};
auto x290 = x288 + x289;
auto x291 = x37*(x166 + x169 + x176 - x182 + x183 + x198 + x280 + x286);
auto x292 = x143*x58;
auto x293 = x291 + x292;
auto x294 = x287 + x290 + x293;
auto x295 = x282 + x290;
auto x296 = x287 + x292;
auto x297 = x72 + cell[8];
auto x298 = x203 - x204;
auto x299 = x298 + x82;
auto x300 = x129 + x218 + x242 + x270 + x297 + x299;
auto x301 = x293 + x295;
auto x302 = -x180;
auto x303 = x219 - x220;
auto x304 = x227 - x228;
auto x305 = x211 + x257 + x297 + x303 + x304 + x77 + cell[19];
auto x306 = x276 + cell[4];
auto x307 = x237 + x272 + x54;
auto x308 = x98 + cell[8];
auto x309 = x226 + x248 + x298 + x306 + x307 + x308;
auto x310 = x295 + x296;
auto x311 = x303 + x76;
auto x312 = x244 - x245 + x276;
auto x313 = x210 + x236 + x308 + x311 + x312;
auto x314 = x151 + x200;
auto x315 = x250 - x251;
auto x316 = x91 + x99 + cell[6];
auto x317 = x299 + x306 + x311 + x315 + x316 + x85;
auto x318 = x109 + x113 + x208 + x209 + x224 + x225 + x277 + x316 + cell[17];
auto x319 = x263 - x264 + x270 + x307 + x315 + x44 + x49 + x82 + x97 + cell[26];
auto x320 = x121 + x312;
auto x321 = x139 + x258 + x266 + x268 - x269 + x275 + x320 + x43 + cell[23] + cell[26];
auto x322 = x123 + x134 + x260 + x265 + x273 - x274 + x304 + x79 + x82;
auto x323 = x117 + x137 + x283 - x284 + x304 + x315 + x320 + x83 + x90;
cell[0] = -x142*(x151*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{0.296296296296296}) + V{1}*x152*cell[0];
cell[1] = -x142*(x153*(-x144*x181 + x150 + x180) + V{0.0740740740740741}) + V{1}*x152*cell[1];
cell[2] = -x142*(x153*(-x146*x181 + x149 + x193 + x194) + V{0.0740740740740741}) + V{1}*x152*cell[2];
cell[3] = -x142*(x153*(x147 - x148*x181 + x194 + x200) + V{0.0740740740740741}) + V{1}*x152*cell[3];
cell[4] = -x142*(x201*(-x202*x215*x215 + x217) + V{0.0185185185185185}) + V{1}*x152*cell[4];
cell[5] = -x142*(x201*(-x202*x231*x231 + x233) + V{0.0185185185185185}) + V{1}*x152*cell[5];
cell[6] = -x142*(x201*(x200 - x202*x240*x240 + x216) + V{0.0185185185185185}) + V{1}*x152*cell[6];
cell[7] = -x142*(x201*(-x202*x249*x249 + x216 + x241) + V{0.0185185185185185}) + V{1}*x152*cell[7];
cell[8] = -x142*(x201*(-x202*x254*x254 + x256) + V{0.0185185185185185}) + V{1}*x152*cell[8];
cell[9] = -x142*(x201*(-x202*x261*x261 + x241 + x255) + V{0.0185185185185185}) + V{1}*x152*cell[9];
cell[10] = -x142*(x262*(x200 - x202*x267*x267 + x217) + V{0.00462962962962963}) + V{1}*x152*cell[10];
cell[11] = -x142*(x262*(-x202*x271*x271 + x217 + x241) + V{0.00462962962962963}) + V{1}*x152*cell[11];
cell[12] = -x142*(x262*(x200 - x202*x278*x278 + x233) + V{0.00462962962962963}) + V{1}*x152*cell[12];
cell[13] = -x142*(x262*(-x202*x285*x285 - x282 + x294) + V{0.00462962962962963}) + V{1}*x152*cell[13];
cell[14] = -x142*(x153*(-x181*x58 + x295) + V{0.0740740740740741}) + V{1}*x152*cell[14];
cell[15] = -x142*(x153*(-x181*x87 + x289 + x293) + V{0.0740740740740741}) + V{1}*x152*cell[15];
cell[16] = -x142*(x153*(-x101*x181 + x288 + x296 + V{-1}) + V{0.0740740740740741}) + V{1}*x152*cell[16];
cell[17] = -x142*(x201*(-x202*x300*x300 + x301) + V{0.0185185185185185}) + V{1}*x152*cell[17];
cell[18] = -x142*(x201*(-x202*x305*x305 + x255 + x302) + V{0.0185185185185185}) + V{1}*x152*cell[18];
cell[19] = -x142*(x201*(-x202*x309*x309 + x310) + V{0.0185185185185185}) + V{1}*x152*cell[19];
cell[20] = -x142*(x201*(-x202*x313*x313 + x302 + x314) + V{0.0185185185185185}) + V{1}*x152*cell[20];
cell[21] = -x142*(x201*(-x202*x317*x317 + x294) + V{0.0185185185185185}) + V{1}*x152*cell[21];
cell[22] = -x142*(x201*(-x202*x318*x318 + x232 + x314) + V{0.0185185185185185}) + V{1}*x152*cell[22];
cell[23] = -x142*(x262*(-x202*x319*x319 + x287 + x301) + V{0.00462962962962963}) + V{1}*x152*cell[23];
cell[24] = -x142*(x262*(-x202*x321*x321 - x287 + x301) + V{0.00462962962962963}) + V{1}*x152*cell[24];
cell[25] = -x142*(x262*(-x202*x322*x322 - x291 + x310) + V{0.00462962962962963}) + V{1}*x152*cell[25];
cell[26] = -x142*(x262*(-x202*x323*x323 + x256 + x302) + V{0.00462962962962963}) + V{1}*x152*cell[26];
return { x35, V{1}*x36*(x101 + x58 + x87) };
}

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
auto computeEffectiveOmega(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x32 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x31 = parameters.template get<olb::descriptors::OMEGA>();
auto x0 = V{1} / (x31);
auto x1 = x32*x32;
auto x2 = cell[12] + cell[25];
auto x3 = cell[11] + cell[24];
auto x4 = x2 + x3;
auto x5 = cell[18] + cell[2];
auto x6 = cell[10] + cell[20] + cell[22] + cell[26] + cell[3];
auto x7 = cell[17] + cell[23];
auto x8 = x7 + cell[14] + cell[19];
auto x9 = cell[15] + cell[5];
auto x10 = cell[13] + cell[16] + cell[7] + cell[9];
auto x11 = x10 + x4 + x5 + x6 + x8 + x9 + cell[0] + cell[1] + cell[21] + cell[4] + cell[6] + cell[8] + V{1};
auto x12 = V{1} / (x11);
auto x13 = V{1}*x12;
auto x14 = -cell[20];
auto x15 = -cell[17];
auto x16 = -cell[24];
auto x17 = x15 + x16 + cell[5];
auto x18 = -cell[19];
auto x19 = -cell[25];
auto x20 = x18 + x19 + cell[7];
auto x21 = -cell[23];
auto x22 = -cell[26];
auto x23 = x21 + x22;
auto x24 = cell[10] + cell[11] + cell[4];
auto x25 = cell[12] + cell[6];
auto x26 = cell[13] - cell[18];
auto x27 = x14 + x17 + x20 + x23 + x24 + x25 + x26 - cell[14] + cell[1];
auto x28 = V{0.666666666666667}*cell[10];
auto x29 = V{0.666666666666667}*cell[11];
auto x30 = V{0.666666666666667}*cell[12];
auto x33 = V{0.666666666666667}*cell[13];
auto x34 = V{0.666666666666667}*cell[23];
auto x35 = V{0.666666666666667}*cell[24];
auto x36 = V{0.666666666666667}*cell[25];
auto x37 = V{0.666666666666667}*cell[26];
auto x38 = -V{0.333333333333333}*cell[0];
auto x39 = x28 + x29 + x30 + x33 + x34 + x35 + x36 + x37 + x38 - V{0.333333333333333}*cell[16] + V{0.666666666666667}*cell[17] + V{0.666666666666667}*cell[18] - V{0.333333333333333}*cell[3] + V{0.666666666666667}*cell[4] + V{0.666666666666667}*cell[5];
auto x40 = -V{0.333333333333333}*cell[15] + V{0.666666666666667}*cell[19] + V{0.666666666666667}*cell[20] - V{0.333333333333333}*cell[2] + V{0.666666666666667}*cell[6] + V{0.666666666666667}*cell[7];
auto x41 = -x13*x27*x27 + x39 + x40 + V{0.666666666666667}*cell[14] + V{0.666666666666667}*cell[1] - V{0.333333333333333}*cell[21] - V{0.333333333333333}*cell[22] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9];
auto x42 = -cell[21];
auto x43 = x42 + cell[9];
auto x44 = cell[25] + cell[26] - cell[5];
auto x45 = -cell[13];
auto x46 = x21 + x45 + cell[8];
auto x47 = -cell[12];
auto x48 = x16 + x47 - cell[22];
auto x49 = x15 + x24 + x43 + x44 + x46 + x48 + x5 - cell[15];
auto x50 = -V{0.333333333333333}*cell[14] - V{0.333333333333333}*cell[1] + V{0.666666666666667}*cell[21] + V{0.666666666666667}*cell[22] + V{0.666666666666667}*cell[8] + V{0.666666666666667}*cell[9];
auto x51 = -x13*x49*x49 + x39 + x50 + V{0.666666666666667}*cell[15] - V{0.333333333333333}*cell[19] - V{0.333333333333333}*cell[20] + V{0.666666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7];
auto x52 = cell[24] - cell[7];
auto x53 = -cell[11];
auto x54 = x19 + x53 - cell[9];
auto x55 = x18 + x25 + x42 + x46 + x52 + x54 + x6 - cell[16];
auto x56 = -x13*x55*x55 + x28 + x29 + x30 + x33 + x34 + x35 + x36 + x37 + x38 + x40 + x50 + V{0.666666666666667}*cell[16] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.666666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5];
auto x57 = -cell[4];
auto x58 = -cell[8];
auto x59 = x58 + cell[22];
auto x60 = -cell[10];
auto x61 = x22 + x60 + cell[21];
auto x62 = x26 + x54 + x57 + x59 + x61 + x7 + x9 + cell[12] + cell[24] - cell[2];
auto x63 = x53 + x57 + cell[18];
auto x64 = -cell[6];
auto x65 = x47 + x64 + cell[20];
auto x66 = x45 + x60;
auto x67 = x12*(x44 + x52 + x63 + x65 + x66 + x8 - cell[1]);
auto x68 = x21 + x60 + cell[13] + cell[26];
auto x69 = x17 + x2 + x62*x67 + x63 + x68;
auto x70 = x10 + x14 + x48 + x58 + x61 + x64 + cell[11] + cell[19] + cell[23] + cell[25] - cell[3];
auto x71 = x20 + x3 + x65 + x67*x70 + x68;
auto x72 = x12*x62*x70 + x23 + x4 + x43 + x59 + x66;
auto x73 = -x0*(V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[19] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[20] + V{0.166666666666667}*cell[21] + V{0.166666666666667}*cell[22] + V{0.166666666666667}*cell[23] + V{0.166666666666667}*cell[24] + V{0.166666666666667}*cell[25] + V{0.166666666666667}*cell[26] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9] + V{0.166666666666667}) + util::sqrt(x11*(x1*util::sqrt(V{0.5}*(x41*x41) + V{0.5}*(x51*x51) + V{0.5}*(x56*x56) + x69*x69 + x71*x71 + x72*x72) + (V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[19] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[20] + V{0.0277777777777778}*cell[21] + V{0.0277777777777778}*cell[22] + V{0.0277777777777778}*cell[23] + V{0.0277777777777778}*cell[24] + V{0.0277777777777778}*cell[25] + V{0.0277777777777778}*cell[26] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778})/((x31)*(x31))));
return V{1} / (V{1}*x0 + V{3}*x1*util::sqrt((x73*x73)/(((x11)*(x11))*util::pow(x32, 4))));
}

};


template <typename... FIELDS>
struct KrauseEffectiveOmega<PerPopulationBGK,descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x21 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = V{0.5}/x21;
auto x10 = V{0.0130945659698734}/((x21)*(x21));
auto x11 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + V{1};
auto x12 = V{1} / (x11);
auto x13 = V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444};
auto x14 = V{1} / ((x11)*(x11));
auto x15 = V{1.5}*x14;
auto x16 = cell[1] - cell[5];
auto x17 = cell[2] - cell[6];
auto x18 = x16 + x17 + cell[3] - cell[7];
auto x19 = x18*x18;
auto x20 = x15*x19;
auto x23 = -cell[3] + cell[7];
auto x24 = -cell[4] + cell[8];
auto x25 = x16 + x23 + x24;
auto x26 = x25*x25;
auto x27 = x15*x26;
auto x28 = x27 + V{-1};
auto x29 = x20 + x28;
auto x30 = x22*x22;
auto x31 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(x13*x29 + cell[0] + V{0.444444444444444})));
auto x32 = -cell[2] + cell[6];
auto x33 = x23 + x32 - cell[1] + cell[5];
auto x34 = x15*(x33*x33);
auto x35 = x28 + x34;
auto x36 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x37 = V{3}*cell[2];
auto x38 = V{3}*cell[3];
auto x39 = V{3}*cell[6];
auto x40 = V{3}*cell[7];
auto x41 = V{3}*cell[1];
auto x42 = V{3}*cell[5];
auto x43 = x41 - x42;
auto x44 = x12*(x37 + x38 - x39 - x40 + x43);
auto x45 = V{4.5}*x14;
auto x46 = x17 + x24 + V{2}*cell[1] - V{2}*cell[5];
auto x47 = x45*(x46*x46);
auto x48 = V{1} - x27;
auto x49 = -x38 + x40;
auto x50 = x12*(x43 + x49 - V{3}*cell[4] + V{3}*cell[8]);
auto x51 = -x20 + x50;
auto x52 = x48 + x51;
auto x53 = x36*(x44 + x47 + x52);
auto x54 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(-x53 + cell[1] + V{0.0277777777777778})));
auto x55 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x56 = V{3}*x14;
auto x57 = x19*x56 + x48;
auto x58 = x55*(x44 + x57);
auto x59 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(-x58 + cell[2] + V{0.111111111111111})));
auto x60 = -x44;
auto x61 = V{2}*cell[3];
auto x62 = V{2}*cell[7];
auto x63 = x24 + x32 - x61 + x62;
auto x64 = -x45*x63*x63 + x50;
auto x65 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(x36*(x29 + x60 + x64) + cell[3] + V{0.0277777777777778})));
auto x66 = x26*x56;
auto x67 = x50 - x66 + V{-1};
auto x68 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(x55*(x20 + x67) + cell[4] + V{0.111111111111111})));
auto x69 = x36*(x29 + x44 - x47 + x50) + V{0.0277777777777778};
auto x70 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(x69 + cell[5])));
auto x71 = x55*(x57 + x60);
auto x72 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(-x71 + cell[6] + V{0.111111111111111})));
auto x73 = x17 + x61 - x62 + cell[4] - cell[8];
auto x74 = x36*(x45*(x73*x73) + x52 + x60);
auto x75 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(-x74 + cell[7] + V{0.0277777777777778})));
auto x76 = x55*(x51 + x66 + V{1});
auto x77 = V{1} / (x9 + V{4.369426621423}*util::sqrt(x10 + x12*x30*util::fabs(-x76 + cell[8] + V{0.111111111111111})));
cell[0] = -x31*(x13*x35 + V{0.444444444444444}) + V{1}*(V{1} - x31)*cell[0];
cell[1] = x54*(x53 + V{-0.0277777777777778}) + V{1}*(V{1} - x54)*cell[1];
cell[2] = x59*(x58 + V{-0.111111111111111}) + V{1}*(V{1} - x59)*cell[2];
cell[3] = -x65*(x36*(x12*(-x37 + x39 - x41 + x42 + x49) + x35 + x64) + V{0.0277777777777778}) + V{1}*(V{1} - x65)*cell[3];
cell[4] = -x68*(x55*(x34 + x67) + V{0.111111111111111}) + V{1}*(V{1} - x68)*cell[4];
cell[5] = -x69*x70 + V{1}*(V{1} - x70)*cell[5];
cell[6] = x72*(x71 + V{-0.111111111111111}) + V{1}*(V{1} - x72)*cell[6];
cell[7] = x75*(x74 + V{-0.0277777777777778}) + V{1}*(V{1} - x75)*cell[7];
cell[8] = x77*(x76 + V{-0.111111111111111}) + V{1}*(V{1} - x77)*cell[8];
return { x11, V{1}*x14*(x19 + x26) };
}

};

template <typename... FIELDS>
struct KrauseEffectiveOmega<PerPopulationBGK,descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x43 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x42 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = V{0.5}/x42;
auto x20 = V{0.0130945659698734}/((x42)*(x42));
auto x21 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x22 = V{1} / (x21);
auto x23 = V{1} / ((x21)*(x21));
auto x24 = V{1.5}*x23;
auto x25 = cell[13] - cell[4];
auto x26 = cell[15] - cell[6];
auto x27 = x25 + x26;
auto x28 = cell[14] - cell[5];
auto x29 = -cell[1];
auto x30 = cell[16] - cell[7];
auto x31 = x29 + x30 + cell[10];
auto x32 = x27 + x28 + x31;
auto x33 = x32*x32;
auto x34 = x24*x33;
auto x35 = cell[17] - cell[8];
auto x36 = x25 + x35;
auto x37 = cell[18] - cell[9];
auto x38 = -cell[2];
auto x39 = -cell[14] + cell[5];
auto x40 = x38 + x39 + cell[11];
auto x41 = x36 + x37 + x40;
auto x44 = x41*x41;
auto x45 = x24*x44;
auto x46 = x26 + x35;
auto x47 = -cell[16] + cell[7];
auto x48 = -cell[3];
auto x49 = -cell[18] + cell[9];
auto x50 = x48 + x49 + cell[12];
auto x51 = x46 + x47 + x50;
auto x52 = x51*x51;
auto x53 = x24*x52;
auto x54 = x45 + x53 + V{-1};
auto x55 = x34 + x54;
auto x56 = x55*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9] + V{0.333333333333333}) + V{0.333333333333333};
auto x57 = x43*x43;
auto x58 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x56 + cell[0])));
auto x59 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x60 = V{3}*cell[14];
auto x61 = V{3}*cell[16];
auto x62 = V{3}*cell[5];
auto x63 = V{3}*cell[7];
auto x64 = V{3}*cell[13] - V{3}*cell[4];
auto x65 = V{3}*cell[15] - V{3}*cell[6];
auto x66 = x22*(x60 + x61 - x62 - x63 + x64 + x65 + V{3}*cell[10] - V{3}*cell[1]);
auto x67 = V{3}*x23;
auto x68 = x33*x67;
auto x69 = x59*(x54 + x66 - x68) + V{0.0555555555555556};
auto x70 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x69 + cell[1])));
auto x71 = V{3}*cell[18];
auto x72 = V{3}*cell[9];
auto x73 = V{3}*cell[17] - V{3}*cell[8];
auto x74 = x22*(-x60 + x62 + x64 + x71 - x72 + x73 + V{3}*cell[11] - V{3}*cell[2]);
auto x75 = x44*x67;
auto x76 = x34 + V{-1};
auto x77 = x59*(x53 + x74 - x75 + x76) + V{0.0555555555555556};
auto x78 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x77 + cell[2])));
auto x79 = x22*(-x61 + x63 + x65 - x71 + x72 + x73 + V{3}*cell[12] - V{3}*cell[3]);
auto x80 = x52*x67;
auto x81 = x59*(x45 + x76 + x79 - x80) + V{0.0555555555555556};
auto x82 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x81 + cell[3])));
auto x83 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x84 = V{4.5}*x23;
auto x85 = x37 + x38 + cell[11];
auto x86 = x31 + x46 + x85 + V{2}*cell[13] - V{2}*cell[4];
auto x87 = x84*(x86*x86);
auto x88 = x55 + x66;
auto x89 = x83*(x74 - x87 + x88) + V{0.0277777777777778};
auto x90 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x89 + cell[4])));
auto x91 = V{2}*cell[5];
auto x92 = V{2}*cell[14];
auto x93 = -cell[17] + cell[8];
auto x94 = x26 - cell[11] + cell[2];
auto x95 = x31 + x49 - x91 + x92 + x93 + x94;
auto x96 = -x84*x95*x95;
auto x97 = -x74;
auto x98 = x88 + x97;
auto x99 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x83*(x96 + x98) + cell[5] + V{0.0277777777777778})));
auto x100 = -cell[15] + cell[6];
auto x101 = x35 - cell[10] + cell[1];
auto x102 = x100 + x101 + x47 + x85 + x91 - x92;
auto x103 = x28 + x29 + cell[10];
auto x104 = x103 + x36 + x50 + V{2}*cell[15] - V{2}*cell[6];
auto x105 = x84*(x104*x104);
auto x106 = x83*(-x105 + x79 + x88) + V{0.0277777777777778};
auto x107 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x106 + cell[6])));
auto x108 = V{2}*cell[7];
auto x109 = V{2}*cell[16];
auto x110 = x25 - cell[12] + cell[3];
auto x111 = x103 - x108 + x109 + x110 + x37 + x93;
auto x112 = -x84*x111*x111;
auto x113 = -x79;
auto x114 = x113 + x88;
auto x115 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x83*(x112 + x114) + cell[7] + V{0.0277777777777778})));
auto x116 = -cell[13] + cell[4];
auto x117 = x101 + x108 - x109 + x116 + x39 + x50;
auto x118 = x47 + x48 + cell[12];
auto x119 = x118 + x27 + x40 + V{2}*cell[17] - V{2}*cell[8];
auto x120 = x84*(x119*x119);
auto x121 = x55 + x74;
auto x122 = x83*(-x120 + x121 + x79) + V{0.0277777777777778};
auto x123 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x122 + cell[8])));
auto x124 = V{2}*cell[9];
auto x125 = V{2}*cell[18];
auto x126 = x100 + x110 - x124 + x125 + x30 + x40;
auto x127 = -x84*x126*x126;
auto x128 = x113 + x121;
auto x129 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x83*(x127 + x128) + cell[9] + V{0.0277777777777778})));
auto x130 = x116 + x118 + x124 - x125 + x28 + x94;
auto x131 = -x45;
auto x132 = V{1} - x53;
auto x133 = x131 + x132;
auto x134 = x133 + x66;
auto x135 = x59*(x134 + x68);
auto x136 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x135 + cell[10] + V{0.0555555555555556})));
auto x137 = -x34;
auto x138 = x137 + x74;
auto x139 = x59*(x132 + x138 + x75);
auto x140 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x139 + cell[11] + V{0.0555555555555556})));
auto x141 = x137 + x79;
auto x142 = x59*(x131 + x141 + x80 + V{1});
auto x143 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x142 + cell[12] + V{0.0555555555555556})));
auto x144 = x83*(x134 + x138 + x87);
auto x145 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x144 + cell[13] + V{0.0277777777777778})));
auto x146 = -x66;
auto x147 = x83*(x121 + x146 + x96) + V{0.0277777777777778};
auto x148 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x147 + cell[14])));
auto x149 = x83*(x105 + x134 + x141);
auto x150 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x149 + cell[15] + V{0.0277777777777778})));
auto x151 = x55 + x79;
auto x152 = x83*(x112 + x146 + x151) + V{0.0277777777777778};
auto x153 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x152 + cell[16])));
auto x154 = x83*(x120 + x133 + x138 + x79);
auto x155 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(-x154 + cell[17] + V{0.0277777777777778})));
auto x156 = x83*(x127 + x151 + x97) + V{0.0277777777777778};
auto x157 = V{1} / (x19 + V{4.369426621423}*util::sqrt(x20 + x22*x57*util::fabs(x156 + cell[18])));
cell[0] = -x56*x58 + V{1}*(V{1} - x58)*cell[0];
cell[1] = -x69*x70 + V{1}*(V{1} - x70)*cell[1];
cell[2] = -x77*x78 + V{1}*(V{1} - x78)*cell[2];
cell[3] = -x81*x82 + V{1}*(V{1} - x82)*cell[3];
cell[4] = -x89*x90 + V{1}*(V{1} - x90)*cell[4];
cell[5] = -x99*(x83*(-x84*x102*x102 + x98) + V{0.0277777777777778}) + V{1}*(V{1} - x99)*cell[5];
cell[6] = -x106*x107 + V{1}*(V{1} - x107)*cell[6];
cell[7] = -x115*(x83*(x114 - x84*x117*x117) + V{0.0277777777777778}) + V{1}*(V{1} - x115)*cell[7];
cell[8] = -x122*x123 + V{1}*(V{1} - x123)*cell[8];
cell[9] = -x129*(x83*(x128 - x84*x130*x130) + V{0.0277777777777778}) + V{1}*(V{1} - x129)*cell[9];
cell[10] = x136*(x135 + V{-0.0555555555555556}) + V{1}*(V{1} - x136)*cell[10];
cell[11] = x140*(x139 + V{-0.0555555555555556}) + V{1}*(V{1} - x140)*cell[11];
cell[12] = x143*(x142 + V{-0.0555555555555556}) + V{1}*(V{1} - x143)*cell[12];
cell[13] = x145*(x144 + V{-0.0277777777777778}) + V{1}*(V{1} - x145)*cell[13];
cell[14] = -x147*x148 + V{1}*(V{1} - x148)*cell[14];
cell[15] = x150*(x149 + V{-0.0277777777777778}) + V{1}*(V{1} - x150)*cell[15];
cell[16] = -x152*x153 + V{1}*(V{1} - x153)*cell[16];
cell[17] = x155*(x154 + V{-0.0277777777777778}) + V{1}*(V{1} - x155)*cell[17];
cell[18] = -x156*x157 + V{1}*(V{1} - x157)*cell[18];
return { x21, V{1}*x23*(x33 + x44 + x52) };
}

};

template <typename... FIELDS>
struct KrauseEffectiveOmega<PerPopulationBGK,descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x59 = parameters.template get<olb::collision::LES::Smagorinsky>();
auto x58 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = V{0.5}/x58;
auto x28 = V{0.0130945659698734}/((x58)*(x58));
auto x29 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x30 = V{1} / (x29);
auto x31 = V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296};
auto x32 = V{1} / ((x29)*(x29));
auto x33 = V{1.5}*x32;
auto x34 = cell[10] - cell[23];
auto x35 = cell[12] - cell[25];
auto x36 = -cell[19] + cell[6];
auto x37 = x35 + x36;
auto x38 = -cell[20];
auto x39 = -cell[17] + cell[4];
auto x40 = x38 + x39 + cell[7];
auto x41 = -cell[14];
auto x42 = cell[11] - cell[24];
auto x43 = x41 + x42 + cell[1];
auto x44 = -cell[18] + cell[5];
auto x45 = cell[13] - cell[26];
auto x46 = x44 + x45;
auto x47 = x34 + x37 + x40 + x43 + x46;
auto x48 = x47*x47;
auto x49 = x33*x48;
auto x50 = -cell[5];
auto x51 = -cell[22];
auto x52 = x50 + x51 + cell[18] + cell[9];
auto x53 = -cell[21] + cell[8];
auto x54 = x39 + x53;
auto x55 = -cell[13] + cell[26];
auto x56 = x34 + x55;
auto x57 = -cell[12] + cell[25];
auto x60 = x42 + x57;
auto x61 = -cell[15] + cell[2];
auto x62 = x52 + x54 + x56 + x60 + x61;
auto x63 = x62*x62;
auto x64 = x33*x63;
auto x65 = -cell[11] + cell[24];
auto x66 = -cell[7];
auto x67 = x53 + x66 + cell[20];
auto x68 = -cell[16];
auto x69 = cell[22] - cell[9];
auto x70 = x68 + x69 + cell[3];
auto x71 = x37 + x56 + x65 + x67 + x70;
auto x72 = x71*x71;
auto x73 = x33*x72;
auto x74 = x64 + x73 + V{-1};
auto x75 = x49 + x74;
auto x76 = x59*x59;
auto x77 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x31*x75 + cell[0] + V{0.296296296296296})));
auto x78 = -cell[6];
auto x79 = -cell[10] + cell[23];
auto x80 = x78 + x79 + cell[19];
auto x81 = -cell[4];
auto x82 = cell[14] - cell[1];
auto x83 = x81 + x82 + cell[17];
auto x84 = x66 + cell[20];
auto x85 = x50 + cell[18];
auto x86 = x84 + x85;
auto x87 = x57 + x65;
auto x88 = x55 + x80 + x83 + x86 + x87;
auto x89 = x88*x88;
auto x90 = x33*x89;
auto x91 = cell[15] - cell[2];
auto x92 = x65 + x91;
auto x93 = x81 + cell[17];
auto x94 = x35 + x79;
auto x95 = cell[21] - cell[8];
auto x96 = x69 + x95;
auto x97 = x46 + x92 + x93 + x94 + x96;
auto x98 = x97*x97;
auto x99 = x33*x98;
auto x100 = cell[16] - cell[3];
auto x101 = x100 + x95;
auto x102 = x51 + cell[9];
auto x103 = x38 + cell[7];
auto x104 = x102 + x103;
auto x105 = x101 + x104 + x45 + x60 + x80;
auto x106 = x105*x105;
auto x107 = x106*x33;
auto x108 = x107 + x99 + V{-1};
auto x109 = x108 + x90;
auto x110 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x111 = V{3}*cell[1];
auto x112 = V{3}*cell[14];
auto x113 = V{3}*cell[4];
auto x114 = V{3}*cell[10];
auto x115 = V{3}*cell[11];
auto x116 = V{3}*cell[17];
auto x117 = V{3}*cell[23];
auto x118 = -x117;
auto x119 = V{3}*cell[24];
auto x120 = -x119;
auto x121 = x113 + x114 + x115 - x116 + x118 + x120;
auto x122 = V{3}*cell[5];
auto x123 = V{3}*cell[12];
auto x124 = V{3}*cell[13];
auto x125 = V{3}*cell[18];
auto x126 = V{3}*cell[25];
auto x127 = -x126;
auto x128 = V{3}*cell[26];
auto x129 = -x128;
auto x130 = x122 + x123 + x124 - x125 + x127 + x129;
auto x131 = V{3}*cell[6];
auto x132 = V{3}*cell[19];
auto x133 = x131 - x132;
auto x134 = V{3}*cell[7];
auto x135 = V{3}*cell[20];
auto x136 = x134 - x135;
auto x137 = x30*(x111 - x112 + x121 + x130 + x133 + x136);
auto x138 = -x137;
auto x139 = V{3}*x32;
auto x140 = -x139*x48 + x74;
auto x141 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x110*(x138 + x140) + cell[1] + V{0.0740740740740741})));
auto x142 = -x123;
auto x143 = -x124;
auto x144 = -x122 + x125 + x126 + x128 + x142 + x143;
auto x145 = -x114;
auto x146 = -x115;
auto x147 = -x113 + x116 + x117 + x119 + x145 + x146;
auto x148 = -x134 + x135;
auto x149 = -x131 + x132;
auto x150 = x30*(-x111 + x112 + x144 + x147 + x148 + x149);
auto x151 = V{3}*cell[2];
auto x152 = V{3}*cell[15];
auto x153 = V{3}*cell[8];
auto x154 = V{3}*cell[21];
auto x155 = x153 - x154;
auto x156 = V{3}*cell[9];
auto x157 = V{3}*cell[22];
auto x158 = x156 - x157;
auto x159 = x30*(x121 + x144 + x151 - x152 + x155 + x158);
auto x160 = -x159;
auto x161 = x49 + V{-1};
auto x162 = -x139*x63 + x161 + x73;
auto x163 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x110*(x160 + x162) + cell[2] + V{0.0740740740740741})));
auto x164 = -x156 + x157;
auto x165 = -x153 + x154;
auto x166 = x30*(x130 + x147 - x151 + x152 + x164 + x165);
auto x167 = x90 + V{-1};
auto x168 = V{3}*cell[3];
auto x169 = V{3}*cell[16];
auto x170 = x30*(x114 + x118 + x119 + x123 + x127 + x128 + x133 + x143 + x146 + x148 + x155 + x164 + x168 - x169);
auto x171 = -x170;
auto x172 = -x139*x72 + x161 + x64;
auto x173 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x110*(x171 + x172) + cell[3] + V{0.0740740740740741})));
auto x174 = x30*(x115 + x117 + x120 + x124 + x126 + x129 + x136 + x142 + x145 + x149 + x158 + x165 - x168 + x169);
auto x175 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x176 = V{4.5}*x32;
auto x177 = x91 + x96;
auto x178 = V{2}*cell[10];
auto x179 = V{2}*cell[23];
auto x180 = -x178 + x179;
auto x181 = x78 + cell[19];
auto x182 = x181 + x82;
auto x183 = V{2}*cell[11];
auto x184 = V{2}*cell[24];
auto x185 = -x183 + x184;
auto x186 = x185 + x84;
auto x187 = V{2}*cell[4];
auto x188 = V{2}*cell[17];
auto x189 = -x187 + x188;
auto x190 = x177 + x180 + x182 + x186 + x189;
auto x191 = -x176*x190*x190;
auto x192 = x138 + x75;
auto x193 = x160 + x192;
auto x194 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x191 + x193) + cell[4] + V{0.0185185185185185})));
auto x195 = x109 + x150;
auto x196 = x166 + x195;
auto x197 = V{2}*cell[13];
auto x198 = V{2}*cell[26];
auto x199 = -x197 + x198;
auto x200 = V{2}*cell[12];
auto x201 = V{2}*cell[25];
auto x202 = -x200 + x201;
auto x203 = x202 + x61;
auto x204 = V{2}*cell[5];
auto x205 = V{2}*cell[18];
auto x206 = -x204 + x205;
auto x207 = x102 + x182 + x199 + x203 + x206 + x67;
auto x208 = -x176*x207*x207;
auto x209 = x159 + x192;
auto x210 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x208 + x209) + cell[5] + V{0.0185185185185185})));
auto x211 = -x198;
auto x212 = x103 + x197 + x211;
auto x213 = -x201;
auto x214 = x200 + x213 + x36;
auto x215 = x41 + cell[1];
auto x216 = x204 - x205;
auto x217 = x215 + x216;
auto x218 = x177 + x212 + x214 + x217;
auto x219 = -x166;
auto x220 = x195 + x219;
auto x221 = V{2}*cell[6];
auto x222 = V{2}*cell[19];
auto x223 = -x221 + x222;
auto x224 = x101 + x180 + x202 + x223 + x52 + x83;
auto x225 = -x176*x224*x224;
auto x226 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x171 + x192 + x225) + cell[6] + V{0.0185185185185185})));
auto x227 = V{2}*cell[7];
auto x228 = V{2}*cell[20];
auto x229 = -x227 + x228;
auto x230 = x185 + x199 + x229 + x53 + x70 + x83 + x85;
auto x231 = -x176*x230*x230;
auto x232 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x170 + x192 + x231) + cell[7] + V{0.0185185185185185})));
auto x233 = -x174;
auto x234 = x183 - x184;
auto x235 = x215 + x44;
auto x236 = x227 - x228;
auto x237 = x101 + x102 + x197 + x211 + x234 + x235 + x236 + x39;
auto x238 = x100 + x181;
auto x239 = x44 + x91 + x93;
auto x240 = V{2}*cell[8];
auto x241 = V{2}*cell[21];
auto x242 = -x240 + x241;
auto x243 = x180 + x212 + x238 + x239 + x242;
auto x244 = -x176*x243*x243;
auto x245 = x160 + x75;
auto x246 = x171 + x245;
auto x247 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x244 + x246) + cell[8] + V{0.0185185185185185})));
auto x248 = x109 + x166;
auto x249 = x174 + x248;
auto x250 = V{2}*cell[9];
auto x251 = V{2}*cell[22];
auto x252 = x68 + cell[3];
auto x253 = -x250 + x251 + x252;
auto x254 = x186 + x214 + x239 + x253;
auto x255 = -x176*x254*x254;
auto x256 = x170 + x245;
auto x257 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x255 + x256) + cell[9] + V{0.0185185185185185})));
auto x258 = x250 - x251;
auto x259 = x203 + x234 + x238 + x258 + x40 + x85;
auto x260 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x261 = V{3}*cell[10];
auto x262 = V{3}*cell[23];
auto x263 = x100 + x45;
auto x264 = x82 + x87;
auto x265 = x189 + x91;
auto x266 = x223 + x242 - x261 + x262 + x263 + x264 + x265;
auto x267 = -x176*x266*x266;
auto x268 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x260*(x171 + x193 + x267) + cell[10] + V{0.00462962962962963})));
auto x269 = V{3}*cell[11];
auto x270 = V{3}*cell[24];
auto x271 = x55 + x82;
auto x272 = x229 + x253 + x265 - x269 + x270 + x271 + x94;
auto x273 = -x176*x272*x272;
auto x274 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x260*(x170 + x193 + x273) + cell[11] + V{0.00462962962962963})));
auto x275 = x187 - x188 + x61;
auto x276 = x215 + x275;
auto x277 = x236 + x258 + x263 + x269 - x270 + x276 + x34 + x57;
auto x278 = V{3}*cell[12];
auto x279 = V{3}*cell[25];
auto x280 = x100 + x206 + x223 + x258 + x271 - x278 + x279 + x42 + x61 + x79;
auto x281 = -x176*x280*x280;
auto x282 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x260*(x171 + x209 + x281) + cell[12] + V{0.00462962962962963})));
auto x283 = x221 - x222;
auto x284 = x217 + x253 + x278 - x279 + x283 + x34 + x45 + x92;
auto x285 = V{3}*cell[26];
auto x286 = V{3}*cell[13];
auto x287 = x100 + x216 + x236 + x242 - x285 + x286 + x43 + x91 + x94;
auto x288 = -x176*x287*x287;
auto x289 = x260*(x170 + x209 + x288) + V{0.00462962962962963};
auto x290 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x289 + cell[13])));
auto x291 = x110*(x137 + x140) + V{0.0740740740740741};
auto x292 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x291 + cell[14])));
auto x293 = x110*(x159 + x162) + V{0.0740740740740741};
auto x294 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x293 + cell[15])));
auto x295 = x110*(x170 + x172) + V{0.0740740740740741};
auto x296 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x295 + cell[16])));
auto x297 = x178 - x179;
auto x298 = x297 + x36;
auto x299 = x104 + x234 + x276 + x298 + x53;
auto x300 = x137 + x75;
auto x301 = x159 + x300;
auto x302 = x175*(-x176*x299*x299 + x301) + V{0.0185185185185185};
auto x303 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x302 + cell[17])));
auto x304 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x137 + x208 + x245) + cell[18] + V{0.0185185185185185})));
auto x305 = -x150;
auto x306 = x200 + x213 + x235 + x283 + x297 + x54 + x70;
auto x307 = x175*(x170 - x176*x306*x306 + x300) + V{0.0185185185185185};
auto x308 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x307 + cell[19])));
auto x309 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x171 + x231 + x300) + cell[20] + V{0.0185185185185185})));
auto x310 = x109 + x174;
auto x311 = x240 - x241 + x252;
auto x312 = x311 + x61;
auto x313 = x199 + x298 + x312 + x39 + x86;
auto x314 = x159 + x75;
auto x315 = x175*(x170 - x176*x313*x313 + x314) + V{0.0185185185185185};
auto x316 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x315 + cell[21])));
auto x317 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x175*(x171 + x255 + x314) + cell[22] + V{0.0185185185185185})));
auto x318 = x261 - x262 + x275 + x283 + x311 + x35 + x43 + x55;
auto x319 = x260*(x170 - x176*x318*x318 + x301) + V{0.00462962962962963};
auto x320 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x319 + cell[23])));
auto x321 = x260*(x171 + x273 + x301) + V{0.00462962962962963};
auto x322 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x321 + cell[24])));
auto x323 = x260*(x137 + x256 + x281) + V{0.00462962962962963};
auto x324 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x323 + cell[25])));
auto x325 = V{1} / (x27 + V{4.369426621423}*util::sqrt(x28 + x30*x76*util::fabs(x260*(x137 + x246 + x288) + cell[26] + V{0.00462962962962963})));
auto x326 = x206 + x229 + x264 + x285 - x286 + x312 + x34;
cell[0] = -x77*(x109*x31 + V{0.296296296296296}) + V{1}*(V{1} - x77)*cell[0];
cell[1] = -x141*(x110*(x108 - x139*x89 + x150) + V{0.0740740740740741}) + V{1}*(V{1} - x141)*cell[1];
cell[2] = -x163*(x110*(x107 - x139*x98 + x166 + x167) + V{0.0740740740740741}) + V{1}*(V{1} - x163)*cell[2];
cell[3] = -x173*(x110*(-x106*x139 + x167 + x174 + x99) + V{0.0740740740740741}) + V{1}*(V{1} - x173)*cell[3];
cell[4] = -x194*(x175*(x191 + x196) + V{0.0185185185185185}) + V{1}*(V{1} - x194)*cell[4];
cell[5] = -x210*(x175*(-x176*x218*x218 + x220) + V{0.0185185185185185}) + V{1}*(V{1} - x210)*cell[5];
cell[6] = -x226*(x175*(x174 + x195 + x225) + V{0.0185185185185185}) + V{1}*(V{1} - x226)*cell[6];
cell[7] = -x232*(x175*(-x176*x237*x237 + x195 + x233) + V{0.0185185185185185}) + V{1}*(V{1} - x232)*cell[7];
cell[8] = -x247*(x175*(x244 + x249) + V{0.0185185185185185}) + V{1}*(V{1} - x247)*cell[8];
cell[9] = -x257*(x175*(-x176*x259*x259 + x233 + x248) + V{0.0185185185185185}) + V{1}*(V{1} - x257)*cell[9];
cell[10] = -x268*(x260*(x174 + x196 + x267) + V{0.00462962962962963}) + V{1}*(V{1} - x268)*cell[10];
cell[11] = -x274*(x260*(-x176*x277*x277 + x196 + x233) + V{0.00462962962962963}) + V{1}*(V{1} - x274)*cell[11];
cell[12] = -x282*(x260*(x174 - x176*x284*x284 + x220) + V{0.00462962962962963}) + V{1}*(V{1} - x282)*cell[12];
cell[13] = -x289*x290 + V{1}*(V{1} - x290)*cell[13];
cell[14] = -x291*x292 + V{1}*(V{1} - x292)*cell[14];
cell[15] = -x293*x294 + V{1}*(V{1} - x294)*cell[15];
cell[16] = -x295*x296 + V{1}*(V{1} - x296)*cell[16];
cell[17] = -x302*x303 + V{1}*(V{1} - x303)*cell[17];
cell[18] = -x304*(x175*(x208 + x248 + x305) + V{0.0185185185185185}) + V{1}*(V{1} - x304)*cell[18];
cell[19] = -x307*x308 + V{1}*(V{1} - x308)*cell[19];
cell[20] = -x309*(x175*(x231 + x305 + x310) + V{0.0185185185185185}) + V{1}*(V{1} - x309)*cell[20];
cell[21] = -x315*x316 + V{1}*(V{1} - x316)*cell[21];
cell[22] = -x317*(x175*(x219 + x255 + x310) + V{0.0185185185185185}) + V{1}*(V{1} - x317)*cell[22];
cell[23] = -x319*x320 + V{1}*(V{1} - x320)*cell[23];
cell[24] = -x321*x322 + V{1}*(V{1} - x322)*cell[24];
cell[25] = -x323*x324 + V{1}*(V{1} - x324)*cell[25];
cell[26] = -x325*(x260*(-x176*x326*x326 + x249 + x305) + V{0.00462962962962963}) + V{1}*(V{1} - x325)*cell[26];
return { x29, V{1}*x32*(x48 + x63 + x72) };
}

};


}

}

}

#endif

#endif
