/*  This file is part of the OpenLB library
 *
 *  Copyright (C) 2021 Adrian Kummerlaender
 *  E-mail contact: info@openlb.net
 *  The most recent release of OpenLB can be downloaded at
 *  <http://www.openlb.net/>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA  02110-1301, USA.
*/

#ifndef DYNAMICS_COLLISION_CSE_H
#define DYNAMICS_COLLISION_CSE_H


#ifndef DISABLE_CSE

#include "equilibrium.h"
#include "latticeDescriptors.h"

namespace olb {

namespace collision {

template <typename... FIELDS>
struct BGK::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x5 = x7 + V{-1};
auto x6 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4];
auto x8 = x6 + V{1};
auto x9 = x6 + V{1};
auto x10 = V{1} / ((x9)*(x9));
auto x11 = V{1.5}*x10;
auto x12 = -cell[2] + cell[4];
auto x13 = x12*x12;
auto x14 = -cell[1] + cell[3];
auto x15 = x11*(x14*x14) + V{-1};
auto x16 = V{0.166666666666667}*x7;
auto x17 = V{1} / (x9);
auto x18 = x17*(V{3}*cell[1] - V{3}*cell[3]);
auto x19 = V{3}*x10;
auto x20 = cell[1] - cell[3];
auto x21 = x20*x20;
auto x22 = cell[2] - cell[4];
auto x23 = x22*x22;
auto x24 = -x11*x23 + x19*x21 + V{1};
auto x25 = V{3}*cell[4];
auto x26 = V{3}*cell[2];
cell[0] = -x5*cell[0] - V{0.333333333333333}*x7*(x8*(x11*x13 + x15) + V{1});
cell[1] = x16*(x8*(x18 + x24) + V{-1}) - x5*cell[1];
cell[2] = -x16*(x8*(-x13*x19 + x15 + x17*(x25 - x26)) + V{1}) - x5*cell[2];
cell[3] = x16*(x8*(-x18 + x24) + V{-1}) - x5*cell[3];
cell[4] = -x16*(x8*(x11*x21 + x17*(-x25 + x26) - x19*x23 + V{-1}) + V{1}) - x5*cell[4];
return { x9, V{1}*x10*(x21 + x23) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::Incompressible> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x5 = V{0.333333333333333}*cell[1];
auto x6 = V{0.333333333333333}*cell[2];
auto x8 = V{0.333333333333333}*cell[3];
auto x9 = V{0.333333333333333}*cell[4];
auto x10 = cell[1] - cell[3];
auto x11 = x10*x10;
auto x12 = V{0.5}*x11;
auto x13 = cell[2] - cell[4];
auto x14 = x13*x13;
auto x15 = V{0.5}*x14;
auto x16 = x7 + V{-1};
auto x17 = V{0.166666666666667}*cell[0];
auto x18 = x12 - V{0.25}*x14 + x17 + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[4];
auto x19 = -V{0.25}*x11 + x15 + x17 + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[3];
auto x20 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + V{1};
cell[0] = -x16*cell[0] + x7*(-x12 - x15 + x5 + x6 + x8 + x9 + V{0.333333333333333}*cell[0]);
cell[1] = -x16*cell[1] + x7*(x18 - x8 + V{0.666666666666667}*cell[1]);
cell[2] = -x16*cell[2] + x7*(x19 - x9 + V{0.666666666666667}*cell[2]);
cell[3] = -x16*cell[3] + x7*(x18 - x5 + V{0.666666666666667}*cell[3]);
cell[4] = -x16*cell[4] + x7*(x19 - x6 + V{0.666666666666667}*cell[4]);
return { x20, V{1}*(x11 + x14)/((x20)*(x20)) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = x11 + V{-1};
auto x10 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8];
auto x12 = x10 + V{1};
auto x13 = x10 + V{1};
auto x14 = V{1} / ((x13)*(x13));
auto x15 = V{1.5}*x14;
auto x16 = -cell[3] + cell[7];
auto x17 = -cell[4] + cell[8];
auto x18 = cell[1] - cell[5];
auto x19 = x16 + x17 + x18;
auto x20 = x19*x19;
auto x21 = x15*x20;
auto x22 = -cell[2] + cell[6];
auto x23 = x16 + x22 - cell[1] + cell[5];
auto x24 = x15*(x23*x23) + V{-1};
auto x25 = x21 + x24;
auto x26 = V{0.0277777777777778}*x11;
auto x27 = V{1} / (x13);
auto x28 = V{3}*cell[2];
auto x29 = V{3}*cell[3];
auto x30 = V{3}*cell[6];
auto x31 = V{3}*cell[7];
auto x32 = V{3}*cell[1];
auto x33 = V{3}*cell[5];
auto x34 = x32 - x33;
auto x35 = x27*(x28 + x29 - x30 - x31 + x34);
auto x36 = V{4.5}*x14;
auto x37 = cell[2] - cell[6];
auto x38 = x17 + x37 + V{2}*cell[1] - V{2}*cell[5];
auto x39 = x36*(x38*x38);
auto x40 = V{1} - x21;
auto x41 = -x29 + x31;
auto x42 = x27*(x34 + x41 - V{3}*cell[4] + V{3}*cell[8]);
auto x43 = x18 + x37 + cell[3] - cell[7];
auto x44 = x43*x43;
auto x45 = x15*x44;
auto x46 = x42 - x45;
auto x47 = x40 + x46;
auto x48 = V{0.111111111111111}*x11;
auto x49 = V{3}*x14;
auto x50 = x40 + x44*x49;
auto x51 = V{2}*cell[3];
auto x52 = V{2}*cell[7];
auto x53 = x17 + x22 - x51 + x52;
auto x54 = x20*x49;
auto x55 = -x35;
auto x56 = x37 + x51 - x52 + cell[4] - cell[8];
cell[0] = -V{0.444444444444444}*x11*(x12*x25 + V{1}) - x9*cell[0];
cell[1] = x26*(x12*(x35 + x39 + x47) + V{-1}) - x9*cell[1];
cell[2] = x48*(x12*(x35 + x50) + V{-1}) - x9*cell[2];
cell[3] = -x26*(x12*(x25 + x27*(-x28 + x30 - x32 + x33 + x41) - x36*x53*x53 + x42) + V{1}) - x9*cell[3];
cell[4] = -x48*(x12*(x24 + x42 - x54) + V{1}) - x9*cell[4];
cell[5] = -x26*(x12*(x21 + x35 - x39 + x42 + x45 + V{-1}) + V{1}) - x9*cell[5];
cell[6] = x48*(x12*(x50 + x55) + V{-1}) - x9*cell[6];
cell[7] = x26*(x12*(x36*(x56*x56) + x47 + x55) + V{-1}) - x9*cell[7];
cell[8] = x48*(x12*(x46 + x54 + V{1}) + V{-1}) - x9*cell[8];
return { x13, V{1}*x14*(x20 + x44) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::Incompressible> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = V{0.444444444444444}*cell[8];
auto x10 = cell[1] - cell[5];
auto x12 = cell[7] + cell[8];
auto x13 = x10 + x12 - cell[3] - cell[4];
auto x14 = x13*x13;
auto x15 = cell[2] + cell[3];
auto x16 = x10 + x15 - cell[6] - cell[7];
auto x17 = x16*x16;
auto x18 = V{0.444444444444444}*cell[1];
auto x19 = V{0.444444444444444}*cell[3];
auto x20 = x18 + x19 + V{0.444444444444444}*cell[2];
auto x21 = V{0.444444444444444}*cell[5];
auto x22 = x21 + V{0.444444444444444}*cell[4];
auto x23 = V{0.444444444444444}*cell[7];
auto x24 = x23 + V{0.444444444444444}*cell[6];
auto x25 = x11 + V{-1};
auto x26 = V{0.111111111111111}*cell[2];
auto x27 = V{0.0277777777777778}*cell[0];
auto x28 = -V{0.0416666666666667}*x14;
auto x29 = -V{0.0416666666666667}*x17;
auto x30 = x26 + x27 + x28 + x29 - V{0.0555555555555556}*cell[6];
auto x31 = V{0.111111111111111}*cell[8];
auto x32 = x31 - V{0.0555555555555556}*cell[4];
auto x33 = V{1}*cell[8];
auto x34 = V{1}*cell[4];
auto x35 = V{1}*cell[2] - V{1}*cell[6];
auto x36 = V{4.5}*cell[8];
auto x37 = V{4.5}*cell[4];
auto x38 = V{4.5}*cell[2] - V{4.5}*cell[6];
auto x39 = V{0.0277777777777778}*(x33 - x34 + x35 + V{2}*cell[1] - V{2}*cell[5])*(x36 - x37 + x38 + V{9}*cell[1] - V{9}*cell[5]) + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[7];
auto x40 = -V{0.222222222222222}*cell[5];
auto x41 = V{0.111111111111111}*cell[0];
auto x42 = x41 - V{0.222222222222222}*cell[7];
auto x43 = V{0.111111111111111}*cell[4];
auto x44 = -V{0.166666666666667}*x14 + V{0.333333333333333}*x17 + x31 + x43;
auto x45 = x43 - V{0.0555555555555556}*cell[8];
auto x46 = V{0.0277777777777778}*(-x33 + x34 + x35 + V{2}*cell[3] - V{2}*cell[7])*(-x36 + x37 + x38 + V{9}*cell[3] - V{9}*cell[7]) + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[5];
auto x47 = -V{0.222222222222222}*cell[1];
auto x48 = V{0.111111111111111}*cell[6];
auto x49 = V{0.333333333333333}*x14 - V{0.166666666666667}*x17 + x26 + x48;
auto x50 = x27 + x28 + x29 + x48 - V{0.0555555555555556}*cell[2];
auto x51 = x41 - V{0.222222222222222}*cell[3];
auto x52 = x12 + x15 + cell[0] + cell[1] + cell[4] + cell[5] + cell[6] + V{1};
cell[0] = x11*(-V{0.666666666666667}*x14 - V{0.666666666666667}*x17 + x20 + x22 + x24 + x9 + V{0.444444444444444}*cell[0]) - x25*cell[0];
cell[1] = x11*(x30 + x32 + x39 + V{0.194444444444444}*cell[1] - V{0.138888888888889}*cell[5]) - x25*cell[1];
cell[2] = x11*(x20 + x40 + x42 + x44 - V{0.222222222222222}*cell[6]) - x25*cell[2];
cell[3] = x11*(x30 + x45 + x46 + V{0.194444444444444}*cell[3] - V{0.138888888888889}*cell[7]) - x25*cell[3];
cell[4] = x11*(x19 + x22 + x42 + x47 + x49 - V{0.222222222222222}*cell[8]) - x25*cell[4];
cell[5] = x11*(x39 + x45 + x50 - V{0.138888888888889}*cell[1] + V{0.194444444444444}*cell[5]) - x25*cell[5];
cell[6] = x11*(x21 + x24 + x44 + x47 + x51 - V{0.222222222222222}*cell[2]) - x25*cell[6];
cell[7] = x11*(x32 + x46 + x50 - V{0.138888888888889}*cell[3] + V{0.194444444444444}*cell[7]) - x25*cell[7];
cell[8] = x11*(x18 + x23 + x40 + x49 + x51 + x9 - V{0.222222222222222}*cell[4]) - x25*cell[8];
return { x52, V{1}*(x14 + x17)/((x52)*(x52)) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x7 = x10 + V{-1};
auto x8 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6];
auto x9 = x8 + V{1};
auto x11 = x8 + V{1};
auto x12 = V{1} / ((x11)*(x11));
auto x13 = V{2}*x12;
auto x14 = -cell[1] + cell[4];
auto x15 = x14*x14;
auto x16 = x13*x15;
auto x17 = -cell[2] + cell[5];
auto x18 = x17*x17;
auto x19 = x13*x18;
auto x20 = -cell[3] + cell[6];
auto x21 = x20*x20;
auto x22 = x13*x21;
auto x23 = x19 + x22 + V{-1};
auto x24 = V{0.125}*x10;
auto x25 = V{1} / (x11);
auto x26 = V{4}*cell[4];
auto x27 = V{4}*cell[1];
auto x28 = V{6}*x12;
auto x29 = V{4}*cell[5];
auto x30 = V{4}*cell[2];
auto x31 = x16 + V{-1};
auto x32 = V{4}*cell[6];
auto x33 = V{4}*cell[3];
auto x34 = cell[2] - cell[5];
auto x35 = x34*x34;
auto x36 = x13*x35;
auto x37 = cell[1] - cell[4];
auto x38 = x37*x37;
auto x39 = cell[3] - cell[6];
auto x40 = x39*x39;
auto x41 = x13*x40 + V{-1};
auto x42 = x13*x38;
cell[0] = -V{0.25}*x10*(x9*(x16 + x23) + V{1}) - x7*cell[0];
cell[1] = -x24*(x9*(-x15*x28 + x23 + x25*(x26 - x27)) + V{1}) - x7*cell[1];
cell[2] = -x24*(x9*(-x18*x28 + x22 + x25*(x29 - x30) + x31) + V{1}) - x7*cell[2];
cell[3] = -x24*(x9*(x19 - x21*x28 + x25*(x32 - x33) + x31) + V{1}) - x7*cell[3];
cell[4] = -x24*(x9*(x25*(-x26 + x27) - x28*x38 + x36 + x41) + V{1}) - x7*cell[4];
cell[5] = -x24*(x9*(x25*(-x29 + x30) - x28*x35 + x41 + x42) + V{1}) - x7*cell[5];
cell[6] = -x24*(x9*(x25*(-x32 + x33) - x28*x40 + x36 + x42 + V{-1}) + V{1}) - x7*cell[6];
return { x11, V{1}*x12*(x35 + x38 + x40) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::Incompressible> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x7 = cell[1] - cell[4];
auto x8 = x7*x7;
auto x9 = cell[2] - cell[5];
auto x11 = x9*x9;
auto x12 = cell[3] - cell[6];
auto x13 = x12*x12;
auto x14 = x10 + V{-1};
auto x15 = V{0.125}*cell[0];
auto x16 = -V{0.25}*x13 + x15 + V{0.125}*cell[3] + V{0.125}*cell[6];
auto x17 = -V{0.25}*x11 + V{0.125}*cell[2] + V{0.125}*cell[5];
auto x18 = x16 + x17 + V{0.75}*x8;
auto x19 = -V{0.25}*x8 + V{0.125}*cell[1] + V{0.125}*cell[4];
auto x20 = V{0.75}*x11 + x16 + x19;
auto x21 = V{0.75}*x13 + x15 + x17 + x19;
auto x22 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1};
cell[0] = x10*(-V{0.5}*x11 - V{0.5}*x13 - V{0.5}*x8 + V{0.25}*cell[0] + V{0.25}*cell[1] + V{0.25}*cell[2] + V{0.25}*cell[3] + V{0.25}*cell[4] + V{0.25}*cell[5] + V{0.25}*cell[6]) - x14*cell[0];
cell[1] = x10*(x18 + V{0.625}*cell[1] - V{0.375}*cell[4]) - x14*cell[1];
cell[2] = x10*(x20 + V{0.625}*cell[2] - V{0.375}*cell[5]) - x14*cell[2];
cell[3] = x10*(x21 + V{0.625}*cell[3] - V{0.375}*cell[6]) - x14*cell[3];
cell[4] = x10*(x18 - V{0.375}*cell[1] + V{0.625}*cell[4]) - x14*cell[4];
cell[5] = x10*(x20 - V{0.375}*cell[2] + V{0.625}*cell[5]) - x14*cell[5];
cell[6] = x10*(x21 - V{0.375}*cell[3] + V{0.625}*cell[6]) - x14*cell[6];
return { x22, V{1}*(x11 + x13 + x8)/((x22)*(x22)) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = x22 + V{-1};
auto x20 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x21 = x20 + V{1};
auto x23 = x20 + V{1};
auto x24 = V{1} / ((x23)*(x23));
auto x25 = V{1.5}*x24;
auto x26 = cell[13] - cell[4];
auto x27 = cell[15] - cell[6];
auto x28 = x26 + x27;
auto x29 = cell[14] - cell[5];
auto x30 = -cell[1];
auto x31 = cell[16] - cell[7];
auto x32 = x30 + x31 + cell[10];
auto x33 = x28 + x29 + x32;
auto x34 = x33*x33;
auto x35 = x25*x34;
auto x36 = cell[17] - cell[8];
auto x37 = x26 + x36;
auto x38 = cell[18] - cell[9];
auto x39 = -cell[2];
auto x40 = -cell[14] + cell[5];
auto x41 = x39 + x40 + cell[11];
auto x42 = x37 + x38 + x41;
auto x43 = x42*x42;
auto x44 = x25*x43;
auto x45 = x27 + x36;
auto x46 = -cell[16] + cell[7];
auto x47 = -cell[3];
auto x48 = -cell[18] + cell[9];
auto x49 = x47 + x48 + cell[12];
auto x50 = x45 + x46 + x49;
auto x51 = x50*x50;
auto x52 = x25*x51;
auto x53 = x44 + x52 + V{-1};
auto x54 = x35 + x53;
auto x55 = V{0.0555555555555556}*x22;
auto x56 = V{1} / (x23);
auto x57 = V{3}*cell[14];
auto x58 = V{3}*cell[16];
auto x59 = V{3}*cell[5];
auto x60 = V{3}*cell[7];
auto x61 = V{3}*cell[13] - V{3}*cell[4];
auto x62 = V{3}*cell[15] - V{3}*cell[6];
auto x63 = x56*(x57 + x58 - x59 - x60 + x61 + x62 + V{3}*cell[10] - V{3}*cell[1]);
auto x64 = V{3}*x24;
auto x65 = x34*x64;
auto x66 = V{3}*cell[18];
auto x67 = V{3}*cell[9];
auto x68 = V{3}*cell[17] - V{3}*cell[8];
auto x69 = x56*(-x57 + x59 + x61 + x66 - x67 + x68 + V{3}*cell[11] - V{3}*cell[2]);
auto x70 = x43*x64;
auto x71 = x35 + V{-1};
auto x72 = x56*(-x58 + x60 + x62 - x66 + x67 + x68 + V{3}*cell[12] - V{3}*cell[3]);
auto x73 = x51*x64;
auto x74 = V{0.0277777777777778}*x22;
auto x75 = V{4.5}*x24;
auto x76 = x38 + x39 + cell[11];
auto x77 = x32 + x45 + x76 + V{2}*cell[13] - V{2}*cell[4];
auto x78 = x75*(x77*x77);
auto x79 = x54 + x63;
auto x80 = -x69;
auto x81 = V{2}*cell[14];
auto x82 = V{2}*cell[5];
auto x83 = -cell[15] + cell[6];
auto x84 = x36 - cell[10] + cell[1];
auto x85 = x46 + x76 - x81 + x82 + x83 + x84;
auto x86 = x29 + x30 + cell[10];
auto x87 = x37 + x49 + x86 + V{2}*cell[15] - V{2}*cell[6];
auto x88 = x75*(x87*x87);
auto x89 = -x72;
auto x90 = V{2}*cell[16];
auto x91 = V{2}*cell[7];
auto x92 = -cell[13] + cell[4];
auto x93 = x40 + x49 + x84 - x90 + x91 + x92;
auto x94 = x46 + x47 + cell[12];
auto x95 = x28 + x41 + x94 + V{2}*cell[17] - V{2}*cell[8];
auto x96 = x75*(x95*x95);
auto x97 = x54 + x69;
auto x98 = V{2}*cell[18];
auto x99 = V{2}*cell[9];
auto x100 = x27 - cell[11] + cell[2];
auto x101 = x100 + x29 + x92 + x94 - x98 + x99;
auto x102 = -x44;
auto x103 = V{1} - x52;
auto x104 = x102 + x103;
auto x105 = x104 + x63;
auto x106 = -x35;
auto x107 = x106 + x69;
auto x108 = x106 + x72;
auto x109 = -x63;
auto x110 = -cell[17] + cell[8];
auto x111 = x100 + x110 + x32 + x48 + x81 - x82;
auto x112 = x26 - cell[12] + cell[3];
auto x113 = x110 + x112 + x38 + x86 + x90 - x91;
auto x114 = x54 + x72;
auto x115 = x112 + x31 + x41 + x83 + x98 - x99;
cell[0] = -x19*cell[0] - V{0.333333333333333}*x22*(x21*x54 + V{1});
cell[1] = -x19*cell[1] - x55*(x21*(x53 + x63 - x65) + V{1});
cell[2] = -x19*cell[2] - x55*(x21*(x52 + x69 - x70 + x71) + V{1});
cell[3] = -x19*cell[3] - x55*(x21*(x44 + x71 + x72 - x73) + V{1});
cell[4] = -x19*cell[4] - x74*(x21*(x69 - x78 + x79) + V{1});
cell[5] = -x19*cell[5] - x74*(x21*(-x75*x85*x85 + x79 + x80) + V{1});
cell[6] = -x19*cell[6] - x74*(x21*(x72 + x79 - x88) + V{1});
cell[7] = -x19*cell[7] - x74*(x21*(-x75*x93*x93 + x79 + x89) + V{1});
cell[8] = -x19*cell[8] - x74*(x21*(x72 - x96 + x97) + V{1});
cell[9] = -x19*cell[9] - x74*(x21*(-x75*x101*x101 + x89 + x97) + V{1});
cell[10] = -x19*cell[10] + x55*(x21*(x105 + x65) + V{-1});
cell[11] = -x19*cell[11] + x55*(x21*(x103 + x107 + x70) + V{-1});
cell[12] = -x19*cell[12] + x55*(x21*(x102 + x108 + x73 + V{1}) + V{-1});
cell[13] = -x19*cell[13] + x74*(x21*(x105 + x107 + x78) + V{-1});
cell[14] = -x19*cell[14] - x74*(x21*(x109 - x75*x111*x111 + x97) + V{1});
cell[15] = -x19*cell[15] + x74*(x21*(x105 + x108 + x88) + V{-1});
cell[16] = -x19*cell[16] - x74*(x21*(x109 + x114 - x75*x113*x113) + V{1});
cell[17] = -x19*cell[17] + x74*(x21*(x104 + x107 + x72 + x96) + V{-1});
cell[18] = -x19*cell[18] - x74*(x21*(x114 - x75*x115*x115 + x80) + V{1});
return { x23, V{1}*x24*(x34 + x43 + x51) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::Incompressible> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell[13] - cell[4];
auto x20 = cell[15] - cell[6];
auto x21 = cell[10] + cell[14] + cell[16];
auto x23 = x19 + x20 + x21 - cell[1] - cell[5] - cell[7];
auto x24 = x23*x23;
auto x25 = cell[17] - cell[8];
auto x26 = cell[11] + cell[18] + cell[5];
auto x27 = x19 + x25 + x26 - cell[14] - cell[2] - cell[9];
auto x28 = x27*x27;
auto x29 = cell[12] + cell[7] + cell[9];
auto x30 = x20 + x25 + x29 - cell[16] - cell[18] - cell[3];
auto x31 = x30*x30;
auto x32 = x22 + V{-1};
auto x33 = V{0.111111111111111}*cell[10];
auto x34 = V{0.0555555555555556}*cell[0];
auto x35 = V{0.0555555555555556}*cell[3];
auto x36 = V{0.0555555555555556}*cell[12];
auto x37 = V{0.111111111111111}*cell[13];
auto x38 = -V{0.0833333333333333}*x31;
auto x39 = x34 + x35 + x36 - x37 + x38 + V{0.222222222222222}*cell[4];
auto x40 = V{0.0555555555555556}*cell[2];
auto x41 = V{0.0555555555555556}*cell[11];
auto x42 = V{0.111111111111111}*cell[15];
auto x43 = -V{0.0833333333333333}*x28;
auto x44 = x40 + x41 - x42 + x43 + V{0.222222222222222}*cell[6];
auto x45 = V{0.111111111111111}*cell[14];
auto x46 = -x45 + V{0.222222222222222}*cell[5];
auto x47 = V{0.111111111111111}*cell[16];
auto x48 = -x47 + V{0.222222222222222}*cell[7];
auto x49 = V{0.0555555555555556}*cell[8];
auto x50 = V{0.0555555555555556}*cell[9];
auto x51 = V{0.0555555555555556}*cell[17];
auto x52 = V{0.0555555555555556}*cell[18];
auto x53 = V{0.166666666666667}*x24 + x49 + x50 + x51 + x52;
auto x54 = V{0.111111111111111}*cell[11];
auto x55 = V{0.111111111111111}*cell[5];
auto x56 = -x55 + V{0.222222222222222}*cell[14];
auto x57 = V{0.0555555555555556}*cell[1];
auto x58 = V{0.0555555555555556}*cell[10];
auto x59 = V{0.111111111111111}*cell[17];
auto x60 = -V{0.0833333333333333}*x24;
auto x61 = x57 + x58 - x59 + x60 + V{0.222222222222222}*cell[8];
auto x62 = V{0.111111111111111}*cell[18];
auto x63 = -x62 + V{0.222222222222222}*cell[9];
auto x64 = V{0.0555555555555556}*cell[6];
auto x65 = V{0.0555555555555556}*cell[7];
auto x66 = V{0.0555555555555556}*cell[15];
auto x67 = V{0.0555555555555556}*cell[16];
auto x68 = V{0.166666666666667}*x28 + x64 + x65 + x66 + x67;
auto x69 = V{0.111111111111111}*cell[12];
auto x70 = V{0.111111111111111}*cell[7];
auto x71 = x34 - x70 + V{0.222222222222222}*cell[16];
auto x72 = V{0.111111111111111}*cell[9];
auto x73 = -x72 + V{0.222222222222222}*cell[18];
auto x74 = V{0.0555555555555556}*cell[4];
auto x75 = V{0.0555555555555556}*cell[5];
auto x76 = V{0.0555555555555556}*cell[13];
auto x77 = V{0.0555555555555556}*cell[14];
auto x78 = V{0.166666666666667}*x31 + x74 + x75 + x76 + x77;
auto x79 = V{0.0277777777777778}*cell[0];
auto x80 = -V{0.0416666666666667}*x24;
auto x81 = -V{0.0416666666666667}*x28;
auto x82 = -V{0.0416666666666667}*x31;
auto x83 = -x52 + x72 + x79 + x80 + x81 + x82;
auto x84 = -x67 + x70;
auto x85 = V{0.111111111111111}*cell[1];
auto x86 = -x58;
auto x87 = V{0.111111111111111}*cell[8];
auto x88 = -x51 + x87;
auto x89 = x85 + x86 + x88;
auto x90 = V{0.111111111111111}*cell[2];
auto x91 = -x41;
auto x92 = V{0.111111111111111}*cell[6];
auto x93 = -x66 + x92;
auto x94 = x90 + x91 + x93;
auto x95 = V{0.0277777777777778}*cell[3];
auto x96 = V{0.0277777777777778}*cell[12];
auto x97 = V{1}*cell[10];
auto x98 = V{1}*cell[17];
auto x99 = -V{1}*cell[1];
auto x100 = V{1}*cell[8];
auto x101 = -x100 + x97 + x98 + x99;
auto x102 = V{1}*cell[18];
auto x103 = V{1}*cell[9];
auto x104 = x102 - x103;
auto x105 = V{1}*cell[11];
auto x106 = V{1}*cell[15];
auto x107 = V{1}*cell[2];
auto x108 = -x107;
auto x109 = V{1}*cell[6];
auto x110 = -x109;
auto x111 = x105 + x106 + x108 + x110;
auto x112 = V{1}*cell[16];
auto x113 = V{1}*cell[7];
auto x114 = x112 - x113;
auto x115 = V{4.5}*cell[10];
auto x116 = V{4.5}*cell[17];
auto x117 = -V{4.5}*cell[1];
auto x118 = V{4.5}*cell[8];
auto x119 = x115 + x116 + x117 - x118;
auto x120 = V{4.5}*cell[18];
auto x121 = V{4.5}*cell[9];
auto x122 = x120 - x121;
auto x123 = V{4.5}*cell[11];
auto x124 = V{4.5}*cell[15];
auto x125 = V{4.5}*cell[2];
auto x126 = -x125;
auto x127 = V{4.5}*cell[6];
auto x128 = -x127;
auto x129 = x123 + x124 + x126 + x128;
auto x130 = V{4.5}*cell[16];
auto x131 = V{4.5}*cell[7];
auto x132 = x130 - x131;
auto x133 = x95 + x96 + V{0.0277777777777778}*(x101 + x104 + x111 + x114 + V{2}*cell[13] - V{2}*cell[4])*(x119 + x122 + x129 + x132 + V{9}*cell[13] - V{9}*cell[4]) + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[5];
auto x134 = -x49 + x59;
auto x135 = x134 + x85 + x86;
auto x136 = -x102 + x103;
auto x137 = x100 + x97 - x98 + x99;
auto x138 = -x120 + x121;
auto x139 = x115 - x116 + x117 + x118;
auto x140 = x95 + x96 + V{0.0277777777777778}*(-x105 + x106 + x107 + x110 + x114 + x136 + x137 + V{2}*cell[14] - V{2}*cell[5])*(-x123 + x124 + x125 + x128 + x132 + x138 + x139 + V{9}*cell[14] - V{9}*cell[5]) + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[4];
auto x141 = -x50 + x62;
auto x142 = -x40;
auto x143 = x79 + x80 + x81 + x82;
auto x144 = x143 + x84;
auto x145 = x142 + x144 + x54;
auto x146 = x141 + x143;
auto x147 = x55 - x77;
auto x148 = V{0.111111111111111}*cell[3];
auto x149 = -x36;
auto x150 = V{0.111111111111111}*cell[4];
auto x151 = x150 - x76;
auto x152 = x148 + x149 + x151;
auto x153 = V{0.0277777777777778}*cell[2];
auto x154 = V{0.0277777777777778}*cell[11];
auto x155 = V{1}*cell[14];
auto x156 = V{1}*cell[5];
auto x157 = V{1}*cell[13] - V{1}*cell[4];
auto x158 = x155 - x156 + x157;
auto x159 = V{1}*cell[12];
auto x160 = V{1}*cell[3];
auto x161 = x159 - x160;
auto x162 = V{4.5}*cell[14];
auto x163 = V{4.5}*cell[5];
auto x164 = V{4.5}*cell[13] - V{4.5}*cell[4];
auto x165 = x162 - x163 + x164;
auto x166 = V{4.5}*cell[12];
auto x167 = V{4.5}*cell[3];
auto x168 = x166 - x167;
auto x169 = x153 + x154 + V{0.0277777777777778}*(x101 + x136 + x158 + x161 + V{2}*cell[15] - V{2}*cell[6])*(x119 + x138 + x165 + x168 + V{9}*cell[15] - V{9}*cell[6]) + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[7];
auto x170 = -x35;
auto x171 = x151 + x170 + x69;
auto x172 = -x159 + x160;
auto x173 = -x166 + x167;
auto x174 = x153 + x154 + V{0.0277777777777778}*(x104 + x137 + x158 + x172 + V{2}*cell[16] - V{2}*cell[7])*(x122 + x139 + x165 + x173 + V{9}*cell[16] - V{9}*cell[7]) + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[6];
auto x175 = V{0.0277777777777778}*cell[1];
auto x176 = V{0.0277777777777778}*cell[10];
auto x177 = x45 - x75;
auto x178 = x175 + x176 + x177;
auto x179 = -x155 + x156 + x157;
auto x180 = -x162 + x163 + x164;
auto x181 = V{0.0277777777777778}*(x111 - x112 + x113 + x161 + x179 + V{2}*cell[17] - V{2}*cell[8])*(x129 - x130 + x131 + x168 + x180 + V{9}*cell[17] - V{9}*cell[8]) + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[9];
auto x182 = x47 - x65;
auto x183 = x143 + x182;
auto x184 = V{0.0277777777777778}*(x105 - x106 + x108 + x109 + x114 + x172 + x179 + V{2}*cell[18] - V{2}*cell[9])*(x123 - x124 + x126 + x127 + x132 + x173 + x180 + V{9}*cell[18] - V{9}*cell[9]) + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[8];
auto x185 = x42 - x64;
auto x186 = x185 + x90 + x91;
auto x187 = -x150 + x35 + x36 + x38 + V{0.222222222222222}*cell[13];
auto x188 = x40 + x41 + x43 - x92 + V{0.222222222222222}*cell[15];
auto x189 = x34 + x57 + x58 + x60 - x87 + V{0.222222222222222}*cell[17];
auto x190 = x142 + x54;
auto x191 = -x57;
auto x192 = x182 + x191 + x33;
auto x193 = x37 - x74;
auto x194 = x170 + x193 + x69;
auto x195 = x177 + x191 + x33;
auto x196 = x148 + x149 + x193;
auto x197 = x147 + x175 + x176;
auto x198 = x21 + x26 + x29 + cell[0] + cell[13] + cell[15] + cell[17] + cell[1] + cell[2] + cell[3] + cell[4] + cell[6] + cell[8] + V{1};
cell[0] = x22*(-V{0.5}*x24 - V{0.5}*x28 - V{0.5}*x31 + V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9]) - x32*cell[0];
cell[1] = x22*(-x33 + x39 + x44 + x46 + x48 + x53 + V{0.222222222222222}*cell[1]) - x32*cell[1];
cell[2] = x22*(x39 - x54 + x56 + x61 + x63 + x68 + V{0.222222222222222}*cell[2]) - x32*cell[2];
cell[3] = x22*(x44 + x61 - x69 + x71 + x73 + x78 + V{0.222222222222222}*cell[3]) - x32*cell[3];
cell[4] = x22*(x133 + x83 + x84 + x89 + x94 - V{0.138888888888889}*cell[13] + V{0.194444444444444}*cell[4]) - x32*cell[4];
cell[5] = x22*(x135 + x140 + x141 + x145 + x93 - V{0.138888888888889}*cell[14] + V{0.194444444444444}*cell[5]) - x32*cell[5];
cell[6] = x22*(x146 + x147 + x152 + x169 + x89 - V{0.138888888888889}*cell[15] + V{0.194444444444444}*cell[6]) - x32*cell[6];
cell[7] = x22*(x135 + x147 + x171 + x174 + x83 - V{0.138888888888889}*cell[16] + V{0.194444444444444}*cell[7]) - x32*cell[7];
cell[8] = x22*(x152 + x178 + x181 + x183 + x94 - V{0.138888888888889}*cell[17] + V{0.194444444444444}*cell[8]) - x32*cell[8];
cell[9] = x22*(x144 + x171 + x178 + x184 + x186 - V{0.138888888888889}*cell[18] + V{0.194444444444444}*cell[9]) - x32*cell[9];
cell[10] = x22*(x187 + x188 + x53 + x56 + x71 - x85 + V{0.222222222222222}*cell[10]) - x32*cell[10];
cell[11] = x22*(x187 + x189 + x46 + x68 + x73 - x90 + V{0.222222222222222}*cell[11]) - x32*cell[11];
cell[12] = x22*(-x148 + x188 + x189 + x48 + x63 + x78 + V{0.222222222222222}*cell[12]) - x32*cell[12];
cell[13] = x22*(x133 + x134 + x146 + x185 + x190 + x192 + V{0.194444444444444}*cell[13] - V{0.138888888888889}*cell[4]) - x32*cell[13];
cell[14] = x22*(x140 + x186 + x192 + x83 + x88 + V{0.194444444444444}*cell[14] - V{0.138888888888889}*cell[5]) - x32*cell[14];
cell[15] = x22*(x134 + x169 + x194 + x195 + x83 + V{0.194444444444444}*cell[15] - V{0.138888888888889}*cell[6]) - x32*cell[15];
cell[16] = x22*(x146 + x174 + x195 + x196 + x88 + V{0.194444444444444}*cell[16] - V{0.138888888888889}*cell[7]) - x32*cell[16];
cell[17] = x22*(x145 + x181 + x185 + x194 + x197 + V{0.194444444444444}*cell[17] - V{0.138888888888889}*cell[8]) - x32*cell[17];
cell[18] = x22*(x183 + x184 + x190 + x196 + x197 + x93 + V{0.194444444444444}*cell[18] - V{0.138888888888889}*cell[9]) - x32*cell[18];
return { x198, V{1}*(x24 + x28 + x31)/((x198)*(x198)) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = x30 + V{-1};
auto x28 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x29 = x28 + V{1};
auto x31 = x28 + V{1};
auto x32 = V{1} / ((x31)*(x31));
auto x33 = V{1.5}*x32;
auto x34 = -cell[4];
auto x35 = -cell[6];
auto x36 = x34 + x35 + cell[17] + cell[19];
auto x37 = -cell[7];
auto x38 = cell[18] - cell[5];
auto x39 = x37 + x38 + cell[20];
auto x40 = -cell[11] + cell[24];
auto x41 = -cell[10] + cell[23];
auto x42 = x40 + x41;
auto x43 = cell[14] - cell[1];
auto x44 = -cell[12] + cell[25];
auto x45 = -cell[13] + cell[26];
auto x46 = x44 + x45;
auto x47 = x36 + x39 + x42 + x43 + x46;
auto x48 = x47*x47;
auto x49 = x33*x48;
auto x50 = -cell[8];
auto x51 = cell[13] - cell[26];
auto x52 = x50 + x51 + cell[21];
auto x53 = -cell[9];
auto x54 = cell[12] - cell[25];
auto x55 = x53 + x54 + cell[22];
auto x56 = x34 + cell[17];
auto x57 = -cell[2];
auto x58 = -cell[18] + cell[5];
auto x59 = x57 + x58 + cell[15];
auto x60 = x56 + x59;
auto x61 = x42 + x52 + x55 + x60;
auto x62 = x61*x61;
auto x63 = x33*x62;
auto x64 = -cell[3];
auto x65 = x44 + x64 + cell[16];
auto x66 = cell[11] - cell[24];
auto x67 = -cell[22] + cell[9];
auto x68 = x66 + x67;
auto x69 = x35 + cell[19];
auto x70 = -cell[20] + cell[7];
auto x71 = x69 + x70;
auto x72 = x41 + x52 + x65 + x68 + x71;
auto x73 = x72*x72;
auto x74 = x33*x73;
auto x75 = x63 + x74 + V{-1};
auto x76 = x49 + x75;
auto x77 = V{0.0740740740740741}*x30;
auto x78 = V{1} / (x31);
auto x79 = V{3}*cell[14];
auto x80 = V{3}*cell[1];
auto x81 = V{3}*cell[17];
auto x82 = V{3}*cell[23];
auto x83 = V{3}*cell[24];
auto x84 = V{3}*cell[4];
auto x85 = V{3}*cell[10];
auto x86 = -x85;
auto x87 = V{3}*cell[11];
auto x88 = -x87;
auto x89 = x81 + x82 + x83 - x84 + x86 + x88;
auto x90 = V{3}*cell[19];
auto x91 = V{3}*cell[25];
auto x92 = V{3}*cell[6];
auto x93 = V{3}*cell[12];
auto x94 = -x93;
auto x95 = x90 + x91 - x92 + x94;
auto x96 = V{3}*cell[18];
auto x97 = V{3}*cell[26];
auto x98 = V{3}*cell[5];
auto x99 = V{3}*cell[13];
auto x100 = -x99;
auto x101 = x100 + x96 + x97 - x98;
auto x102 = V{3}*cell[20];
auto x103 = V{3}*cell[7];
auto x104 = x102 - x103;
auto x105 = x78*(x101 + x104 + x79 - x80 + x89 + x95);
auto x106 = V{3}*x32;
auto x107 = V{3}*cell[15];
auto x108 = V{3}*cell[2];
auto x109 = V{3}*cell[21];
auto x110 = V{3}*cell[8];
auto x111 = -x97;
auto x112 = x109 - x110 + x111 + x99;
auto x113 = V{3}*cell[22];
auto x114 = V{3}*cell[9];
auto x115 = -x91;
auto x116 = x113 - x114 + x115 + x93;
auto x117 = -x96 + x98;
auto x118 = x78*(x107 - x108 + x112 + x116 + x117 + x89);
auto x119 = x49 + V{-1};
auto x120 = V{3}*cell[16];
auto x121 = V{3}*cell[3];
auto x122 = -x83;
auto x123 = -x113 + x114 + x122 + x87;
auto x124 = -x102 + x103;
auto x125 = x78*(x112 + x120 - x121 + x123 + x124 + x82 + x86 + x95);
auto x126 = V{0.0185185185185185}*x30;
auto x127 = V{4.5}*x32;
auto x128 = x37 + cell[20];
auto x129 = x128 + x43 + x69;
auto x130 = x50 + cell[21];
auto x131 = V{2}*cell[10];
auto x132 = V{2}*cell[23];
auto x133 = -x131 + x132;
auto x134 = x130 + x133;
auto x135 = x53 + cell[22];
auto x136 = V{2}*cell[11];
auto x137 = V{2}*cell[24];
auto x138 = -x136 + x137;
auto x139 = x135 + x138;
auto x140 = V{2}*cell[4];
auto x141 = V{2}*cell[17];
auto x142 = x57 + cell[15];
auto x143 = -x140 + x141 + x142;
auto x144 = x129 + x134 + x139 + x143;
auto x145 = x105 + x76;
auto x146 = x118 + x145;
auto x147 = V{2}*cell[26];
auto x148 = -x147;
auto x149 = V{2}*cell[13];
auto x150 = x148 + x149 + x70;
auto x151 = V{2}*cell[25];
auto x152 = -x151;
auto x153 = V{2}*cell[12];
auto x154 = -cell[19] + cell[6];
auto x155 = x152 + x153 + x154;
auto x156 = -cell[14] + cell[1];
auto x157 = x130 + x156;
auto x158 = V{2}*cell[18];
auto x159 = V{2}*cell[5];
auto x160 = x142 - x158 + x159;
auto x161 = x135 + x150 + x155 + x157 + x160;
auto x162 = -x118;
auto x163 = x145 + x162;
auto x164 = x64 + cell[16];
auto x165 = x164 + x67;
auto x166 = x151 - x153;
auto x167 = x38 + x43 + x56;
auto x168 = V{2}*cell[6];
auto x169 = V{2}*cell[19];
auto x170 = -x168 + x169;
auto x171 = x134 + x165 + x166 + x167 + x170;
auto x172 = -x125;
auto x173 = x136 - x137;
auto x174 = V{2}*cell[20];
auto x175 = V{2}*cell[7];
auto x176 = -x174 + x175;
auto x177 = -cell[17] + cell[4];
auto x178 = x177 + x58;
auto x179 = x148 + x149 + x157 + x165 + x173 + x176 + x178;
auto x180 = V{2}*cell[8];
auto x181 = V{2}*cell[21];
auto x182 = -x180 + x181;
auto x183 = x164 + x182;
auto x184 = x133 + x150 + x183 + x36 + x59;
auto x185 = x118 + x76;
auto x186 = x125 + x185;
auto x187 = -cell[15] + cell[2];
auto x188 = x173 + x187;
auto x189 = x177 + x38;
auto x190 = V{2}*cell[22];
auto x191 = V{2}*cell[9];
auto x192 = -x190 + x191;
auto x193 = x164 + x192;
auto x194 = x166 + x188 + x189 + x193 + x71;
auto x195 = V{0.00462962962962963}*x30;
auto x196 = V{3}*cell[10];
auto x197 = V{3}*cell[23];
auto x198 = x51 + x65;
auto x199 = x143 + x43;
auto x200 = x170 + x182 - x196 + x197 + x198 + x199 + x40;
auto x201 = V{3}*cell[24];
auto x202 = V{3}*cell[11];
auto x203 = cell[10] - cell[23];
auto x204 = x140 - x141;
auto x205 = x156 + x176;
auto x206 = x187 + x192 + x198 - x201 + x202 + x203 + x204 + x205;
auto x207 = V{3}*cell[25];
auto x208 = V{3}*cell[12];
auto x209 = x156 + x168 - x169;
auto x210 = -cell[16];
auto x211 = x210 + cell[3];
auto x212 = x190 - x191 + x211;
auto x213 = x203 + x40;
auto x214 = x160 - x207 + x208 + x209 + x212 + x213 + x51;
auto x215 = -x82;
auto x216 = -x81 + x84;
auto x217 = -x90 + x92;
auto x218 = x78*(x111 + x115 + x117 + x122 + x124 + x215 + x216 + x217 - x79 + x80 + x85 + x87 + x93 + x99);
auto x219 = V{3}*cell[26];
auto x220 = V{3}*cell[13];
auto x221 = x54 + x66;
auto x222 = x160 + x183 + x205 - x219 + x220 + x221 + x41;
auto x223 = -x109 + x110 + x215 + x85;
auto x224 = x78*(x100 + x104 + x116 - x120 + x121 + x217 + x223 + x83 + x88 + x97);
auto x225 = -cell[21] + cell[8];
auto x226 = x187 + x225;
auto x227 = x189 + x203 + x226 + x46 + x68;
auto x228 = x227*x227;
auto x229 = x228*x33;
auto x230 = x154 + x203;
auto x231 = x210 + x225 + cell[3];
auto x232 = x128 + x230 + x231 + x40 + x45 + x55;
auto x233 = x232*x232;
auto x234 = x233*x33 + V{-1};
auto x235 = x229 + x234;
auto x236 = x78*(x101 - x107 + x108 + x123 + x216 + x223 + x91 + x94);
auto x237 = x156 + x70;
auto x238 = x178 + x221 + x230 + x237 + x51;
auto x239 = x238*x238;
auto x240 = x239*x33;
auto x241 = x236 + x240;
auto x242 = x224 + x235 + x241;
auto x243 = x218 + x235;
auto x244 = x224 + x240;
auto x245 = x131 - x132;
auto x246 = x154 + x245;
auto x247 = x188 + x204 + x225 + x237 + x246 + x67;
auto x248 = x241 + x243;
auto x249 = -x105;
auto x250 = x147 - x149;
auto x251 = x158 - x159;
auto x252 = x129 + x166 + x226 + x250 + x251 + x67;
auto x253 = x135 + x152 + x153 + x178 + x209 + x231 + x245;
auto x254 = x243 + x244;
auto x255 = x174 - x175;
auto x256 = x139 + x167 + x231 + x250 + x255;
auto x257 = x125 + x76;
auto x258 = x180 - x181 + x187 + x211;
auto x259 = x177 + x246 + x250 + x258 + x39;
auto x260 = x128 + x138 + x155 + x212 + x60;
auto x261 = x196 - x197 + x204 + x209 + x221 + x258 + x45;
auto x262 = x41 + x45;
auto x263 = x199 + x201 - x202 + x212 + x255 + x262 + x54;
auto x264 = x251 + x43;
auto x265 = x170 + x187 + x193 + x207 - x208 + x262 + x264 + x66;
auto x266 = x213 + x219 - x220 + x255 + x258 + x264 + x44;
cell[0] = -x27*cell[0] - V{0.296296296296296}*x30*(x29*x76 + V{1});
cell[1] = -x27*cell[1] - x77*(x29*(x105 - x106*x48 + x75) + V{1});
cell[2] = -x27*cell[2] - x77*(x29*(-x106*x62 + x118 + x119 + x74) + V{1});
cell[3] = -x27*cell[3] - x77*(x29*(-x106*x73 + x119 + x125 + x63) + V{1});
cell[4] = -x126*(x29*(-x127*x144*x144 + x146) + V{1}) - x27*cell[4];
cell[5] = -x126*(x29*(-x127*x161*x161 + x163) + V{1}) - x27*cell[5];
cell[6] = -x126*(x29*(x125 - x127*x171*x171 + x145) + V{1}) - x27*cell[6];
cell[7] = -x126*(x29*(-x127*x179*x179 + x145 + x172) + V{1}) - x27*cell[7];
cell[8] = -x126*(x29*(-x127*x184*x184 + x186) + V{1}) - x27*cell[8];
cell[9] = -x126*(x29*(-x127*x194*x194 + x172 + x185) + V{1}) - x27*cell[9];
cell[10] = -x195*(x29*(x125 - x127*x200*x200 + x146) + V{1}) - x27*cell[10];
cell[11] = -x195*(x29*(-x127*x206*x206 + x146 + x172) + V{1}) - x27*cell[11];
cell[12] = -x195*(x29*(x125 - x127*x214*x214 + x163) + V{1}) - x27*cell[12];
cell[13] = -x195*(x29*(-x127*x222*x222 - x218 + x242) + V{1}) - x27*cell[13];
cell[14] = -x27*cell[14] - x77*(x29*(-x106*x239 + x243) + V{1});
cell[15] = -x27*cell[15] - x77*(x29*(-x106*x228 + x234 + x241) + V{1});
cell[16] = -x27*cell[16] - x77*(x29*(-x106*x233 + x229 + x244 + V{-1}) + V{1});
cell[17] = -x126*(x29*(-x127*x247*x247 + x248) + V{1}) - x27*cell[17];
cell[18] = -x126*(x29*(-x127*x252*x252 + x185 + x249) + V{1}) - x27*cell[18];
cell[19] = -x126*(x29*(-x127*x253*x253 + x254) + V{1}) - x27*cell[19];
cell[20] = -x126*(x29*(-x127*x256*x256 + x249 + x257) + V{1}) - x27*cell[20];
cell[21] = -x126*(x29*(-x127*x259*x259 + x242) + V{1}) - x27*cell[21];
cell[22] = -x126*(x29*(-x127*x260*x260 + x162 + x257) + V{1}) - x27*cell[22];
cell[23] = -x195*(x29*(-x127*x261*x261 + x224 + x248) + V{1}) - x27*cell[23];
cell[24] = -x195*(x29*(-x127*x263*x263 - x224 + x248) + V{1}) - x27*cell[24];
cell[25] = -x195*(x29*(-x127*x265*x265 - x236 + x254) + V{1}) - x27*cell[25];
cell[26] = -x195*(x29*(-x127*x266*x266 + x186 + x249) + V{1}) - x27*cell[26];
return { x31, V{1}*x32*(x228 + x233 + x239) };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::Incompressible> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = V{0.296296296296296}*cell[16];
auto x28 = -cell[23];
auto x29 = x28 + cell[10] - cell[13] - cell[21] + cell[26] + cell[8];
auto x31 = cell[11] - cell[17] - cell[24] + cell[4];
auto x32 = cell[18] + cell[25] + cell[2] + cell[9];
auto x33 = x29 + x31 + x32 - cell[12] - cell[15] - cell[22] - cell[5];
auto x34 = x33*x33;
auto x35 = cell[12] - cell[19] - cell[25] + cell[6];
auto x36 = cell[20] + cell[22] + cell[24] + cell[3];
auto x37 = x29 + x35 + x36 - cell[11] - cell[16] - cell[7] - cell[9];
auto x38 = x37*x37;
auto x39 = cell[10] + cell[13] + cell[1] + cell[5] + cell[7];
auto x40 = x28 + x31 + x35 + x39 - cell[14] - cell[18] - cell[20] - cell[26];
auto x41 = x40*x40;
auto x42 = V{0.296296296296296}*cell[4];
auto x43 = V{0.296296296296296}*cell[5];
auto x44 = V{0.296296296296296}*cell[6];
auto x45 = V{0.296296296296296}*cell[7];
auto x46 = V{0.296296296296296}*cell[10];
auto x47 = V{0.296296296296296}*cell[11];
auto x48 = V{0.296296296296296}*cell[12];
auto x49 = V{0.296296296296296}*cell[13];
auto x50 = x42 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + V{0.296296296296296}*cell[1];
auto x51 = V{0.296296296296296}*cell[8];
auto x52 = V{0.296296296296296}*cell[9];
auto x53 = V{0.296296296296296}*cell[18];
auto x54 = V{0.296296296296296}*cell[25];
auto x55 = V{0.296296296296296}*cell[26];
auto x56 = x51 + x52 + x53 + x54 + x55 + V{0.296296296296296}*cell[2];
auto x57 = V{0.296296296296296}*cell[20];
auto x58 = V{0.296296296296296}*cell[22];
auto x59 = V{0.296296296296296}*cell[24];
auto x60 = x57 + x58 + x59 + V{0.296296296296296}*cell[3];
auto x61 = V{0.296296296296296}*cell[17];
auto x62 = V{0.296296296296296}*cell[19];
auto x63 = V{0.296296296296296}*cell[23];
auto x64 = x61 + x62 + x63 + V{0.296296296296296}*cell[14];
auto x65 = V{0.296296296296296}*cell[21];
auto x66 = x65 + V{0.296296296296296}*cell[15];
auto x67 = x30 + V{-1};
auto x68 = -V{0.148148148148148}*cell[20];
auto x69 = V{0.0740740740740741}*cell[0];
auto x70 = -V{0.148148148148148}*cell[23];
auto x71 = -V{0.148148148148148}*cell[24];
auto x72 = -V{0.111111111111111}*x38;
auto x73 = x69 + x70 + x71 + x72 - V{0.148148148148148}*cell[17];
auto x74 = -V{0.148148148148148}*cell[25];
auto x75 = -V{0.111111111111111}*x34;
auto x76 = x74 + x75 - V{0.148148148148148}*cell[19];
auto x77 = -V{0.148148148148148}*cell[26];
auto x78 = x77 - V{0.148148148148148}*cell[18];
auto x79 = V{0.0740740740740741}*cell[2];
auto x80 = V{0.0740740740740741}*cell[3];
auto x81 = x79 + x80;
auto x82 = V{0.0740740740740741}*cell[15];
auto x83 = V{0.0740740740740741}*cell[16];
auto x84 = x82 + x83;
auto x85 = V{0.0740740740740741}*cell[8];
auto x86 = V{0.0740740740740741}*cell[9];
auto x87 = x85 + x86;
auto x88 = V{0.0740740740740741}*cell[21];
auto x89 = V{0.0740740740740741}*cell[22];
auto x90 = x88 + x89;
auto x91 = V{0.222222222222222}*x41 + x81 + x84 + x87 + x90;
auto x92 = -V{0.148148148148148}*cell[12];
auto x93 = -V{0.148148148148148}*cell[13];
auto x94 = x92 + x93 - V{0.148148148148148}*cell[5];
auto x95 = -V{0.111111111111111}*x41;
auto x96 = x46 + x95 - V{0.148148148148148}*cell[21];
auto x97 = x47 - V{0.148148148148148}*cell[22];
auto x98 = V{0.0740740740740741}*cell[1];
auto x99 = x80 + x98;
auto x100 = V{0.0740740740740741}*cell[6];
auto x101 = V{0.0740740740740741}*cell[20];
auto x102 = x100 + x101;
auto x103 = V{0.0740740740740741}*cell[14];
auto x104 = x103 + x83;
auto x105 = V{0.0740740740740741}*cell[7];
auto x106 = V{0.0740740740740741}*cell[19];
auto x107 = x105 + x106;
auto x108 = x102 + x104 + x107 + V{0.222222222222222}*x34 + x99;
auto x109 = -V{0.148148148148148}*cell[11];
auto x110 = x109 + x55 + x69 - V{0.148148148148148}*cell[7];
auto x111 = x48 - V{0.148148148148148}*cell[9];
auto x112 = x79 + x98;
auto x113 = V{0.0740740740740741}*cell[4];
auto x114 = V{0.0740740740740741}*cell[5];
auto x115 = x113 + x114;
auto x116 = x103 + x82;
auto x117 = V{0.0740740740740741}*cell[17];
auto x118 = V{0.0740740740740741}*cell[18];
auto x119 = x117 + x118;
auto x120 = x112 + x115 + x116 + x119 + V{0.222222222222222}*x38;
auto x121 = V{0.0185185185185185}*cell[0];
auto x122 = V{0.0185185185185185}*cell[26];
auto x123 = -V{0.037037037037037}*cell[22];
auto x124 = -V{0.0277777777777778}*x34;
auto x125 = -V{0.0277777777777778}*x38;
auto x126 = -V{0.0277777777777778}*x41;
auto x127 = x121 + x122 + x123 + x124 + x125 + x126;
auto x128 = V{0.0185185185185185}*cell[25];
auto x129 = -V{0.037037037037037}*cell[21];
auto x130 = x128 + x129;
auto x131 = V{0.12962962962963}*cell[10];
auto x132 = -V{0.037037037037037}*cell[14];
auto x133 = -V{0.0925925925925926}*cell[23];
auto x134 = x131 + x132 + x133;
auto x135 = -V{0.037037037037037}*cell[15];
auto x136 = -V{0.037037037037037}*cell[19];
auto x137 = x135 + x136;
auto x138 = -V{0.037037037037037}*cell[20];
auto x139 = V{0.12962962962963}*cell[11] - V{0.0925925925925926}*cell[24];
auto x140 = x138 + x139;
auto x141 = x100 + x105;
auto x142 = V{1}*cell[6];
auto x143 = V{1}*cell[7];
auto x144 = V{1}*cell[19];
auto x145 = -x144;
auto x146 = V{1}*cell[20];
auto x147 = -x146;
auto x148 = V{1}*cell[1];
auto x149 = V{1}*cell[14];
auto x150 = x148 - x149;
auto x151 = x142 + x143 + x145 + x147 + x150;
auto x152 = V{1}*cell[8];
auto x153 = V{2}*cell[10];
auto x154 = V{1}*cell[21];
auto x155 = -V{2}*cell[23];
auto x156 = x152 + x153 - x154 + x155;
auto x157 = V{1}*cell[9];
auto x158 = V{2}*cell[11];
auto x159 = V{1}*cell[22];
auto x160 = -V{2}*cell[24];
auto x161 = x157 + x158 - x159 + x160;
auto x162 = V{1}*cell[2];
auto x163 = V{1}*cell[15];
auto x164 = x162 - x163;
auto x165 = x164 - V{2}*cell[17] + V{2}*cell[4];
auto x166 = V{4.5}*cell[6];
auto x167 = V{4.5}*cell[7];
auto x168 = V{4.5}*cell[19];
auto x169 = -x168;
auto x170 = V{4.5}*cell[20];
auto x171 = -x170;
auto x172 = V{4.5}*cell[1];
auto x173 = V{4.5}*cell[14];
auto x174 = x172 - x173;
auto x175 = x166 + x167 + x169 + x171 + x174;
auto x176 = V{4.5}*cell[8];
auto x177 = V{9}*cell[10];
auto x178 = V{4.5}*cell[21];
auto x179 = -V{9}*cell[23];
auto x180 = x176 + x177 - x178 + x179;
auto x181 = V{4.5}*cell[9];
auto x182 = V{9}*cell[11];
auto x183 = V{4.5}*cell[22];
auto x184 = -V{9}*cell[24];
auto x185 = x181 + x182 - x183 + x184;
auto x186 = V{4.5}*cell[2];
auto x187 = V{4.5}*cell[15];
auto x188 = x186 - x187;
auto x189 = x188 - V{9}*cell[17] + V{9}*cell[4];
auto x190 = V{0.0185185185185185}*cell[3];
auto x191 = V{0.0185185185185185}*cell[13];
auto x192 = x190 + x191;
auto x193 = V{0.0185185185185185}*cell[12];
auto x194 = V{0.0185185185185185}*cell[16];
auto x195 = x193 + x194;
auto x196 = x192 + x195 + V{0.0185185185185185}*(x151 + x156 + x161 + x165)*(x175 + x180 + x185 + x189) + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[5];
auto x197 = V{0.0185185185185185}*cell[24];
auto x198 = -V{0.037037037037037}*cell[8];
auto x199 = x197 + x198;
auto x200 = -V{0.037037037037037}*cell[9];
auto x201 = V{0.0185185185185185}*cell[23];
auto x202 = x121 + x124 + x125 + x126;
auto x203 = x201 + x202;
auto x204 = x200 + x203;
auto x205 = -V{0.037037037037037}*cell[2];
auto x206 = x205 + x90;
auto x207 = V{0.12962962962963}*cell[13];
auto x208 = -V{0.0925925925925926}*cell[26];
auto x209 = x138 + x207 + x208;
auto x210 = x132 + x98;
auto x211 = V{0.12962962962963}*cell[12] - V{0.0925925925925926}*cell[25];
auto x212 = x136 + x211 + x82;
auto x213 = V{2}*cell[12];
auto x214 = V{2}*cell[25];
auto x215 = -x157 + x159 + x213 - x214;
auto x216 = V{2}*cell[13];
auto x217 = V{2}*cell[26];
auto x218 = -x152 + x154 + x216 - x217;
auto x219 = V{2}*cell[5];
auto x220 = V{2}*cell[18];
auto x221 = -x162 + x163 + x219 - x220;
auto x222 = V{9}*cell[12];
auto x223 = V{9}*cell[25];
auto x224 = -x181 + x183 + x222 - x223;
auto x225 = V{9}*cell[13];
auto x226 = V{9}*cell[26];
auto x227 = -x176 + x178 + x225 - x226;
auto x228 = V{9}*cell[5];
auto x229 = V{9}*cell[18];
auto x230 = -x186 + x187 + x228 - x229;
auto x231 = V{0.0185185185185185}*cell[11];
auto x232 = x190 + x231;
auto x233 = V{0.0185185185185185}*cell[10];
auto x234 = x194 + x233;
auto x235 = x232 + x234 + V{0.0185185185185185}*(x151 + x215 + x218 + x221)*(x175 + x224 + x227 + x230) + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[4];
auto x236 = V{0.0185185185185185}*cell[15];
auto x237 = x197 + x236;
auto x238 = -V{0.037037037037037}*cell[17];
auto x239 = x191 + x238;
auto x240 = x200 + x202;
auto x241 = V{0.0185185185185185}*cell[2];
auto x242 = x122 + x241;
auto x243 = x231 + x242;
auto x244 = -V{0.037037037037037}*cell[16];
auto x245 = -V{0.037037037037037}*cell[18];
auto x246 = x244 + x245;
auto x247 = x85 + x89;
auto x248 = -V{1}*cell[17] + V{1}*cell[4];
auto x249 = V{1}*cell[3];
auto x250 = V{1}*cell[16];
auto x251 = x249 - x250;
auto x252 = x248 + x251;
auto x253 = V{1}*cell[5];
auto x254 = V{1}*cell[18];
auto x255 = x150 + x253 - x254;
auto x256 = -V{2}*cell[19] + V{2}*cell[6];
auto x257 = -V{4.5}*cell[17] + V{4.5}*cell[4];
auto x258 = V{4.5}*cell[3];
auto x259 = V{4.5}*cell[16];
auto x260 = x258 - x259;
auto x261 = x257 + x260;
auto x262 = V{4.5}*cell[5];
auto x263 = V{4.5}*cell[18];
auto x264 = x174 + x262 - x263;
auto x265 = -V{9}*cell[19] + V{9}*cell[6];
auto x266 = V{0.0185185185185185}*(x156 + x215 + x252 + x255 + x256)*(x180 + x224 + x261 + x264 + x265) + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[7];
auto x267 = x123 + x203;
auto x268 = x128 + x241;
auto x269 = x233 + x268;
auto x270 = -V{0.037037037037037}*cell[3];
auto x271 = x270 + x83;
auto x272 = x86 + x88;
auto x273 = -x249;
auto x274 = x248 + x250 + x273;
auto x275 = V{2}*cell[7];
auto x276 = V{2}*cell[20];
auto x277 = x275 - x276;
auto x278 = -x258;
auto x279 = x257 + x259 + x278;
auto x280 = V{9}*cell[7];
auto x281 = V{9}*cell[20];
auto x282 = x280 - x281;
auto x283 = x193 + x236;
auto x284 = x283 + V{0.0185185185185185}*(x161 + x218 + x255 + x274 + x277)*(x185 + x227 + x264 + x279 + x282) + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[6];
auto x285 = -V{0.037037037037037}*cell[7];
auto x286 = x128 + x285;
auto x287 = -V{0.037037037037037}*cell[5];
auto x288 = x231 + x287;
auto x289 = -V{0.0925925925925926}*cell[13] + V{0.12962962962963}*cell[26];
auto x290 = x244 + x289;
auto x291 = x113 + x118;
auto x292 = -V{2}*cell[21] + V{2}*cell[8];
auto x293 = x164 - x253 + x254;
auto x294 = -V{9}*cell[21] + V{9}*cell[8];
auto x295 = x188 - x262 + x263;
auto x296 = V{0.0185185185185185}*cell[1];
auto x297 = x193 + x296;
auto x298 = V{0.0185185185185185}*cell[14];
auto x299 = x197 + x298;
auto x300 = x202 + x297 + x299 + V{0.0185185185185185}*(x142 - x143 + x145 + x146 + x153 + x155 - x216 + x217 + x252 + x292 + x293)*(x166 - x167 + x169 + x170 + x177 + x179 - x225 + x226 + x261 + x294 + x295) + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[9];
auto x301 = -V{0.037037037037037}*cell[6];
auto x302 = x122 + x301;
auto x303 = -V{0.0925925925925926}*cell[12] + V{0.12962962962963}*cell[25];
auto x304 = x135 + x303 + x79;
auto x305 = V{2}*cell[9];
auto x306 = V{2}*cell[22];
auto x307 = x305 - x306;
auto x308 = V{9}*cell[9];
auto x309 = V{9}*cell[22];
auto x310 = x308 - x309;
auto x311 = x233 + x296;
auto x312 = x203 + x298 + x311 + V{0.0185185185185185}*(-x142 + x143 + x144 + x147 + x158 + x160 - x213 + x214 + x274 + x293 + x307)*(-x166 + x167 + x168 + x171 + x182 + x184 - x222 + x223 + x279 + x295 + x310) + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[8];
auto x313 = V{1}*cell[11];
auto x314 = V{1}*cell[12];
auto x315 = V{1}*cell[26];
auto x316 = V{1}*cell[13];
auto x317 = V{1}*cell[24];
auto x318 = V{1}*cell[25];
auto x319 = x150 + x165;
auto x320 = x251 + x292;
auto x321 = V{4.5}*cell[11];
auto x322 = V{4.5}*cell[12];
auto x323 = V{4.5}*cell[26];
auto x324 = V{4.5}*cell[13];
auto x325 = V{4.5}*cell[24];
auto x326 = V{4.5}*cell[25];
auto x327 = x174 + x189;
auto x328 = x260 + x294;
auto x329 = V{0.00462962962962963}*(x256 + x313 + x314 + x315 - x316 - x317 - x318 + x319 + x320 + V{3}*cell[10] - V{3}*cell[23])*(x265 + x321 + x322 + x323 - x324 - x325 - x326 + x327 + x328 + V{13.5}*cell[10] - V{13.5}*cell[23]);
auto x330 = V{0.00462962962962963}*cell[0];
auto x331 = V{0.00462962962962963}*cell[9];
auto x332 = V{0.00462962962962963}*cell[22];
auto x333 = -V{0.00925925925925926}*cell[14];
auto x334 = -V{0.00925925925925926}*cell[24];
auto x335 = -V{0.00925925925925926}*cell[25];
auto x336 = -V{0.00694444444444444}*x34;
auto x337 = -V{0.00694444444444444}*x38;
auto x338 = -V{0.00694444444444444}*x41;
auto x339 = x330 + x331 + x332 + x333 + x334 + x335 + x336 + x337 + x338;
auto x340 = V{0.00462962962962963}*cell[5];
auto x341 = V{0.00462962962962963}*cell[18];
auto x342 = -V{0.00925925925925926}*cell[13];
auto x343 = -V{0.00925925925925926}*cell[16];
auto x344 = x340 + x341 + x342 + x343;
auto x345 = V{0.00462962962962963}*cell[7];
auto x346 = V{0.00462962962962963}*cell[20];
auto x347 = -V{0.00925925925925926}*cell[15];
auto x348 = x345 + x346 + x347;
auto x349 = -V{0.0231481481481481}*cell[17] + V{0.0324074074074074}*cell[4];
auto x350 = -V{0.0231481481481481}*cell[19] + V{0.0324074074074074}*cell[6];
auto x351 = -V{0.0231481481481481}*cell[21] + V{0.0324074074074074}*cell[8];
auto x352 = V{1}*cell[10];
auto x353 = -V{1}*cell[23];
auto x354 = -x315 + x316 + x352 + x353;
auto x355 = -x314 + x318;
auto x356 = V{4.5}*cell[10];
auto x357 = -V{4.5}*cell[23];
auto x358 = -x323 + x324 + x356 + x357;
auto x359 = -x322 + x326;
auto x360 = V{0.00462962962962963}*(x250 + x273 + x277 + x307 + x319 + x354 + x355 + V{3}*cell[11] - V{3}*cell[24])*(x259 + x278 + x282 + x310 + x327 + x358 + x359 + V{13.5}*cell[11] - V{13.5}*cell[24]);
auto x361 = V{0.00462962962962963}*cell[6];
auto x362 = V{0.00462962962962963}*cell[19];
auto x363 = -V{0.00925925925925926}*cell[3];
auto x364 = x296 + x361 + x362 + x363 - V{0.0231481481481481}*cell[20] + V{0.0324074074074074}*cell[7];
auto x365 = V{0.00462962962962963}*cell[8];
auto x366 = V{0.00462962962962963}*cell[21];
auto x367 = -V{0.00925925925925926}*cell[23];
auto x368 = -V{0.00925925925925926}*cell[26];
auto x369 = x330 + x333 + x336 + x337 + x338 + x365 + x366 + x367 + x368;
auto x370 = -V{0.0231481481481481}*cell[22] + V{0.0324074074074074}*cell[9];
auto x371 = -V{0.00925925925925926}*cell[12];
auto x372 = x347 + x371;
auto x373 = x191 + x340 + x341;
auto x374 = -V{0.00925925925925926}*cell[2];
auto x375 = x374 + V{0.0324074074074074}*cell[22] - V{0.0231481481481481}*cell[9];
auto x376 = V{0.00462962962962963}*cell[4];
auto x377 = V{0.00462962962962963}*cell[17];
auto x378 = -x313 + x317;
auto x379 = -x321 + x325;
auto x380 = x376 + x377 + V{0.00462962962962963}*(x150 + x221 + x251 + x256 - x305 + x306 + x354 + x378 + V{3}*cell[12] - V{3}*cell[25])*(x174 + x230 + x260 + x265 - x308 + x309 + x358 + x379 + V{13.5}*cell[12] - V{13.5}*cell[25]);
auto x381 = -V{0.00925925925925926}*cell[11];
auto x382 = x343 + x381;
auto x383 = -V{0.0231481481481481}*cell[18] + V{0.0324074074074074}*cell[5];
auto x384 = x237 + x345 + x346;
auto x385 = x201 - V{0.00925925925925926}*cell[10];
auto x386 = x374 + V{0.0324074074074074}*cell[21] - V{0.0231481481481481}*cell[8];
auto x387 = x376 + x377 + V{0.00462962962962963}*(-x148 + x149 + x164 - x219 + x220 - x275 + x276 + x320 + x352 + x353 + x355 + x378 - V{3}*cell[13] + V{3}*cell[26])*(-x172 + x173 + x188 - x228 + x229 - x280 + x281 + x328 + x356 + x357 + x359 + x379 - V{13.5}*cell[13] + V{13.5}*cell[26]);
auto x388 = -V{0.148148148148148}*cell[10];
auto x389 = x388 + x59 + x72 - V{0.148148148148148}*cell[4];
auto x390 = x54 + x75 - V{0.148148148148148}*cell[6];
auto x391 = x49 + x63 + x69 + x95 - V{0.148148148148148}*cell[8];
auto x392 = -V{0.0925925925925926}*cell[10] + V{0.12962962962963}*cell[23];
auto x393 = -V{0.0925925925925926}*cell[11] + V{0.12962962962963}*cell[24];
auto x394 = -V{0.037037037037037}*cell[1];
auto x395 = x101 + x106 + x394;
auto x396 = -V{0.037037037037037}*cell[4];
auto x397 = x191 + x396;
auto x398 = x270 + x392;
auto x399 = x119 + x241 + x394;
auto x400 = x393 + x80;
auto x401 = x114 + x117 + x205;
auto x402 = -V{0.00925925925925926}*cell[1];
auto x403 = x330 + x331 + x332 + x336 + x337 + x338 + x402;
auto x404 = x298 + V{0.0324074074074074}*cell[17] - V{0.0231481481481481}*cell[4];
auto x405 = x194 + x363 + V{0.0324074074074074}*cell[19] - V{0.0231481481481481}*cell[6];
auto x406 = x190 + x361 + x362 + V{0.0324074074074074}*cell[20] - V{0.0231481481481481}*cell[7];
auto x407 = x330 + x336 + x337 + x338 + x365 + x366 + x385 + x402;
auto x408 = V{0.0324074074074074}*cell[18] - V{0.0231481481481481}*cell[5];
auto x409 = x32 + x36 + x39 + cell[0] + cell[11] + cell[12] + cell[14] + cell[15] + cell[16] + cell[17] + cell[19] + cell[21] + cell[23] + cell[26] + cell[4] + cell[6] + cell[8] + V{1};
cell[0] = x30*(x27 - V{0.444444444444444}*x34 - V{0.444444444444444}*x38 - V{0.444444444444444}*x41 + x50 + x56 + x60 + x64 + x66 + V{0.296296296296296}*cell[0]) - x67*cell[0];
cell[1] = x30*(x50 + x68 + x73 + x76 + x78 + x91 - V{0.148148148148148}*cell[14]) - x67*cell[1];
cell[2] = x30*(x108 + x42 + x56 + x73 + x94 + x96 + x97 - V{0.148148148148148}*cell[15]) - x67*cell[2];
cell[3] = x30*(x110 + x111 + x120 + x44 + x51 + x60 + x70 + x76 + x93 + x96 - V{0.148148148148148}*cell[16]) - x67*cell[3];
cell[4] = x30*(x112 + x127 + x130 + x134 + x137 + x140 + x141 + x196 + x87 - V{0.0925925925925926}*cell[17] + V{0.12962962962963}*cell[4]) - x67*cell[4];
cell[5] = x30*(x141 + x199 + x204 + x206 + x209 + x210 + x212 + x235 - V{0.0925925925925926}*cell[18] + V{0.12962962962963}*cell[5]) - x67*cell[5];
cell[6] = x30*(x115 + x129 + x134 + x211 + x237 + x239 + x240 + x243 + x246 + x247 + x266 + x99 - V{0.0925925925925926}*cell[19] + V{0.12962962962963}*cell[6]) - x67*cell[6];
cell[7] = x30*(x115 + x139 + x198 + x207 + x208 + x210 + x238 + x245 + x267 + x269 + x271 + x272 + x284 - V{0.0925925925925926}*cell[20] + V{0.12962962962963}*cell[7]) - x67*cell[7];
cell[8] = x30*(x102 + x131 + x133 + x137 + x238 + x286 + x288 + x290 + x291 + x300 + x81 - V{0.0925925925925926}*cell[21] + V{0.12962962962963}*cell[8]) - x67*cell[8];
cell[9] = x30*(x107 + x140 + x239 + x271 + x287 + x291 + x302 + x304 + x312 - V{0.0925925925925926}*cell[22] + V{0.12962962962963}*cell[9]) - x67*cell[9];
cell[10] = x30*(x232 + x242 + x297 + x329 + x339 + x344 + x348 + x349 + x350 + x351 + V{0.0462962962962963}*cell[10] - V{0.037037037037037}*cell[23]) - x67*cell[10];
cell[11] = x30*(x234 + x268 + x349 + x360 + x364 + x369 + x370 + x372 + x373 + V{0.0462962962962963}*cell[11] - V{0.037037037037037}*cell[24]) - x67*cell[11];
cell[12] = x30*(x192 + x311 + x350 + x369 + x375 + x380 + x382 + x383 + x384 + V{0.0462962962962963}*cell[12] - V{0.037037037037037}*cell[25]) - x67*cell[12];
cell[13] = x30*(x195 + x231 + x236 + x339 + x364 + x383 + x385 + x386 + x387 + V{0.0462962962962963}*cell[13] - V{0.037037037037037}*cell[26]) - x67*cell[13];
cell[14] = x30*(x110 + x389 + x390 + x53 + x57 + x64 + x91 + x94 - V{0.148148148148148}*cell[1]) - x67*cell[14];
cell[15] = x30*(x108 + x109 + x111 + x389 + x391 + x43 + x58 + x61 + x66 + x74 + x78 - V{0.148148148148148}*cell[2]) - x67*cell[15];
cell[16] = x30*(x120 + x27 + x388 + x390 + x391 + x45 + x52 + x62 + x65 + x68 + x71 + x77 + x92 + x97 - V{0.148148148148148}*cell[3]) - x67*cell[16];
cell[17] = x30*(x116 + x196 + x198 + x206 + x240 + x286 + x302 + x392 + x393 + x395 + V{0.12962962962963}*cell[17] - V{0.0925925925925926}*cell[4]) - x67*cell[17];
cell[18] = x30*(x103 + x129 + x197 + x235 + x267 + x285 + x289 + x301 + x304 + x395 + x87 + V{0.12962962962963}*cell[18] - V{0.0925925925925926}*cell[5]) - x67*cell[18];
cell[19] = x30*(x104 + x127 + x199 + x236 + x266 + x272 + x288 + x303 + x397 + x398 + x399 + V{0.12962962962963}*cell[19] - V{0.0925925925925926}*cell[6]) - x67*cell[19];
cell[20] = x30*(x103 + x130 + x204 + x233 + x247 + x284 + x287 + x290 + x396 + x399 + x400 + V{0.12962962962963}*cell[20] - V{0.0925925925925926}*cell[7]) - x67*cell[20];
cell[21] = x30*(x107 + x128 + x209 + x231 + x245 + x300 + x301 + x396 + x398 + x401 + x84 + V{0.12962962962963}*cell[21] - V{0.0925925925925926}*cell[8]) - x67*cell[21];
cell[22] = x30*(x102 + x122 + x212 + x246 + x285 + x312 + x397 + x400 + x401 + V{0.12962962962963}*cell[22] - V{0.0925925925925926}*cell[9]) - x67*cell[22];
cell[23] = x30*(x128 + x329 + x368 + x371 + x373 + x381 + x384 + x386 + x403 + x404 + x405 - V{0.037037037037037}*cell[10] + V{0.0462962962962963}*cell[23]) - x67*cell[23];
cell[24] = x30*(x122 + x283 + x335 + x344 + x360 + x375 + x404 + x406 + x407 - V{0.037037037037037}*cell[11] + V{0.0462962962962963}*cell[24]) - x67*cell[24];
cell[25] = x30*(x243 + x298 + x334 + x342 + x348 + x370 + x380 + x405 + x407 + x408 - V{0.037037037037037}*cell[12] + V{0.0462962962962963}*cell[25]) - x67*cell[25];
cell[26] = x30*(x269 + x299 + x351 + x367 + x372 + x382 + x387 + x403 + x406 + x408 - V{0.037037037037037}*cell[13] + V{0.0462962962962963}*cell[26]) - x67*cell[26];
return { x409, V{1}*(x34 + x38 + x41)/((x409)*(x409)) };
}

};


template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x8 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x5 = x7 + V{-1};
auto x6 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4];
auto x9 = x6 + V{1};
auto x10 = V{1} / ((x9)*(x9));
auto x11 = V{1.5}*x10;
auto x12 = -cell[2] + cell[4];
auto x13 = x12*x12;
auto x14 = -cell[1] + cell[3];
auto x15 = x11*(x14*x14) + V{-1};
auto x16 = x11*x13 + x15;
auto x17 = V{1} / (x9);
auto x18 = (x6 + V{1})*(-x17*(x8 + V{-1}) + V{1});
auto x19 = V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667};
auto x20 = x17*(V{3}*cell[1] - V{3}*cell[3]);
auto x21 = V{3}*x10;
auto x22 = cell[1] - cell[3];
auto x23 = x22*x22;
auto x24 = cell[2] - cell[4];
auto x25 = x24*x24;
auto x26 = -x11*x25 + x21*x23 + V{1};
auto x27 = x20 + x26;
auto x28 = V{0.166666666666667}*x18;
auto x29 = V{3}*cell[4];
auto x30 = V{3}*cell[2];
auto x31 = -x13*x21 + x15 + x17*(x29 - x30);
auto x32 = -x20 + x26;
auto x33 = -x11*x23 - x17*(-x29 + x30) + x21*x25 + V{1};
cell[0] = -V{0.333333333333333}*x16*x18 - x5*(x16*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}) + cell[0] + V{0.333333333333333}) + V{-0.333333333333333};
cell[1] = x27*x28 - x5*(-x19*x27 + cell[1] + V{0.166666666666667}) + V{-0.166666666666667};
cell[2] = -x28*x31 - x5*(x19*x31 + cell[2] + V{0.166666666666667}) + V{-0.166666666666667};
cell[3] = x28*x32 - x5*(-x19*x32 + cell[3] + V{0.166666666666667}) + V{-0.166666666666667};
cell[4] = x28*x33 - x5*(-x19*x33 + cell[4] + V{0.166666666666667}) + V{-0.166666666666667};
return { x6 - x8 + V{2}, V{1}*x10*(x23 + x25) };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = x11 + V{-1};
auto x10 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8];
auto x13 = x10 + V{1};
auto x14 = V{1} / ((x13)*(x13));
auto x15 = V{1.5}*x14;
auto x16 = -cell[3] + cell[7];
auto x17 = cell[1] - cell[5];
auto x18 = -cell[4] + cell[8];
auto x19 = x16 + x17 + x18;
auto x20 = x19*x19;
auto x21 = x15*x20;
auto x22 = -cell[2] + cell[6];
auto x23 = x16 + x22 - cell[1] + cell[5];
auto x24 = x15*(x23*x23) + V{-1};
auto x25 = x21 + x24;
auto x26 = V{1} / (x13);
auto x27 = (x10 + V{1})*(-x26*(x12 + V{-1}) + V{1});
auto x28 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x29 = V{3}*cell[2];
auto x30 = V{3}*cell[3];
auto x31 = V{3}*cell[6];
auto x32 = V{3}*cell[7];
auto x33 = V{3}*cell[1];
auto x34 = V{3}*cell[5];
auto x35 = x33 - x34;
auto x36 = x26*(x29 + x30 - x31 - x32 + x35);
auto x37 = V{4.5}*x14;
auto x38 = V{2}*cell[1];
auto x39 = V{2}*cell[5];
auto x40 = x22 - x38 + x39 + cell[4] - cell[8];
auto x41 = V{1} - x21;
auto x42 = -x30 + x32;
auto x43 = x26*(x35 + x42 - V{3}*cell[4] + V{3}*cell[8]);
auto x44 = cell[2] - cell[6];
auto x45 = x17 + x44 + cell[3] - cell[7];
auto x46 = x45*x45;
auto x47 = -x15*x46;
auto x48 = x43 + x47;
auto x49 = x41 + x48;
auto x50 = x36 + x37*(x40*x40) + x49;
auto x51 = V{0.0277777777777778}*x27;
auto x52 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x53 = V{3}*x14;
auto x54 = x41 + x46*x53;
auto x55 = x36 + x54;
auto x56 = V{0.111111111111111}*x27;
auto x57 = x18 + x22 - V{2}*cell[3] + V{2}*cell[7];
auto x58 = x37*(x57*x57);
auto x59 = x25 + x26*(-x29 + x31 - x33 + x34 + x42) + x43 - x58;
auto x60 = x20*x53;
auto x61 = x24 + x43 - x60;
auto x62 = -x36;
auto x63 = x18 + x38 - x39 + x44;
auto x64 = x37*(x63*x63) + x41 - x43 + x47 + x62;
auto x65 = x54 + x62;
auto x66 = x49 + x58 + x62;
auto x67 = x48 + x60 + V{1};
cell[0] = -V{0.444444444444444}*x25*x27 - x9*(x25*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + cell[0] + V{0.444444444444444}) + V{-0.444444444444444};
cell[1] = x50*x51 - x9*(-x28*x50 + cell[1] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[2] = x55*x56 - x9*(-x52*x55 + cell[2] + V{0.111111111111111}) + V{-0.111111111111111};
cell[3] = -x51*x59 - x9*(x28*x59 + cell[3] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[4] = -x56*x61 - x9*(x52*x61 + cell[4] + V{0.111111111111111}) + V{-0.111111111111111};
cell[5] = x51*x64 - x9*(-x28*x64 + cell[5] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[6] = x56*x65 - x9*(-x52*x65 + cell[6] + V{0.111111111111111}) + V{-0.111111111111111};
cell[7] = x51*x66 - x9*(-x28*x66 + cell[7] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[8] = x56*x67 - x9*(-x52*x67 + cell[8] + V{0.111111111111111}) + V{-0.111111111111111};
return { x10 - x12 + V{2}, V{1}*x14*(x20 + x46) };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x11 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x7 = x10 + V{-1};
auto x8 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6];
auto x9 = x8 + V{1};
auto x12 = V{1} / ((x9)*(x9));
auto x13 = V{2}*x12;
auto x14 = -cell[1] + cell[4];
auto x15 = x14*x14;
auto x16 = x13*x15;
auto x17 = -cell[2] + cell[5];
auto x18 = x17*x17;
auto x19 = x13*x18;
auto x20 = -cell[3] + cell[6];
auto x21 = x20*x20;
auto x22 = x13*x21;
auto x23 = x19 + x22 + V{-1};
auto x24 = x16 + x23;
auto x25 = V{1} / (x9);
auto x26 = (x8 + V{1})*(-x25*(x11 + V{-1}) + V{1});
auto x27 = V{0.125}*cell[0] + V{0.125}*cell[1] + V{0.125}*cell[2] + V{0.125}*cell[3] + V{0.125}*cell[4] + V{0.125}*cell[5] + V{0.125}*cell[6] + V{0.125};
auto x28 = V{4}*cell[4];
auto x29 = V{4}*cell[1];
auto x30 = V{6}*x12;
auto x31 = -x15*x30 + x23 + x25*(x28 - x29);
auto x32 = V{0.125}*x26;
auto x33 = V{4}*cell[5];
auto x34 = V{4}*cell[2];
auto x35 = x16 + V{-1};
auto x36 = -x18*x30 + x22 + x25*(x33 - x34) + x35;
auto x37 = V{4}*cell[6];
auto x38 = V{4}*cell[3];
auto x39 = x19 - x21*x30 + x25*(x37 - x38) + x35;
auto x40 = cell[1] - cell[4];
auto x41 = x40*x40;
auto x42 = cell[2] - cell[5];
auto x43 = x42*x42;
auto x44 = -x13*x43;
auto x45 = cell[3] - cell[6];
auto x46 = x45*x45;
auto x47 = -x13*x46 + V{1};
auto x48 = -x25*(-x28 + x29) + x30*x41 + x44 + x47;
auto x49 = -x13*x41;
auto x50 = -x25*(-x33 + x34) + x30*x43 + x47 + x49;
auto x51 = -x25*(-x37 + x38) + x30*x46 + x44 + x49 + V{1};
cell[0] = -V{0.25}*x24*x26 - x7*(x24*(V{0.25}*cell[0] + V{0.25}*cell[1] + V{0.25}*cell[2] + V{0.25}*cell[3] + V{0.25}*cell[4] + V{0.25}*cell[5] + V{0.25}*cell[6] + V{0.25}) + cell[0] + V{0.25}) + V{-0.25};
cell[1] = -x31*x32 - x7*(x27*x31 + cell[1] + V{0.125}) + V{-0.125};
cell[2] = -x32*x36 - x7*(x27*x36 + cell[2] + V{0.125}) + V{-0.125};
cell[3] = -x32*x39 - x7*(x27*x39 + cell[3] + V{0.125}) + V{-0.125};
cell[4] = x32*x48 - x7*(-x27*x48 + cell[4] + V{0.125}) + V{-0.125};
cell[5] = x32*x50 - x7*(-x27*x50 + cell[5] + V{0.125}) + V{-0.125};
cell[6] = x32*x51 - x7*(-x27*x51 + cell[6] + V{0.125}) + V{-0.125};
return { -x11 + x8 + V{2}, V{1}*x12*(x41 + x43 + x46) };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x19 = x22 + V{-1};
auto x20 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x21 = x20 + V{1};
auto x24 = V{1} / ((x21)*(x21));
auto x25 = V{1.5}*x24;
auto x26 = cell[13] - cell[4];
auto x27 = cell[15] - cell[6];
auto x28 = x26 + x27;
auto x29 = cell[14] - cell[5];
auto x30 = -cell[1];
auto x31 = cell[16] - cell[7];
auto x32 = x30 + x31 + cell[10];
auto x33 = x28 + x29 + x32;
auto x34 = x33*x33;
auto x35 = x25*x34;
auto x36 = cell[17] - cell[8];
auto x37 = x26 + x36;
auto x38 = cell[18] - cell[9];
auto x39 = -cell[2];
auto x40 = -cell[14] + cell[5];
auto x41 = x39 + x40 + cell[11];
auto x42 = x37 + x38 + x41;
auto x43 = x42*x42;
auto x44 = x25*x43;
auto x45 = x27 + x36;
auto x46 = -cell[16] + cell[7];
auto x47 = -cell[3];
auto x48 = -cell[18] + cell[9];
auto x49 = x47 + x48 + cell[12];
auto x50 = x45 + x46 + x49;
auto x51 = x50*x50;
auto x52 = x25*x51;
auto x53 = x44 + x52 + V{-1};
auto x54 = x35 + x53;
auto x55 = V{1} / (x21);
auto x56 = (x20 + V{1})*(-x55*(x23 + V{-1}) + V{1});
auto x57 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x58 = V{3}*cell[14];
auto x59 = V{3}*cell[16];
auto x60 = V{3}*cell[5];
auto x61 = V{3}*cell[7];
auto x62 = V{3}*cell[13] - V{3}*cell[4];
auto x63 = V{3}*cell[15] - V{3}*cell[6];
auto x64 = x55*(x58 + x59 - x60 - x61 + x62 + x63 + V{3}*cell[10] - V{3}*cell[1]);
auto x65 = V{3}*x24;
auto x66 = x34*x65;
auto x67 = x53 + x64 - x66;
auto x68 = V{0.0555555555555556}*x56;
auto x69 = V{3}*cell[18];
auto x70 = V{3}*cell[9];
auto x71 = V{3}*cell[17] - V{3}*cell[8];
auto x72 = x55*(-x58 + x60 + x62 + x69 - x70 + x71 + V{3}*cell[11] - V{3}*cell[2]);
auto x73 = x43*x65;
auto x74 = x35 + V{-1};
auto x75 = x52 + x72 - x73 + x74;
auto x76 = x55*(-x59 + x61 + x63 - x69 + x70 + x71 + V{3}*cell[12] - V{3}*cell[3]);
auto x77 = x51*x65;
auto x78 = x44 + x74 + x76 - x77;
auto x79 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x80 = V{4.5}*x24;
auto x81 = x38 + x39 + cell[11];
auto x82 = x32 + x45 + x81 + V{2}*cell[13] - V{2}*cell[4];
auto x83 = x80*(x82*x82);
auto x84 = x54 + x64;
auto x85 = x72 - x83 + x84;
auto x86 = V{0.0277777777777778}*x56;
auto x87 = -x72;
auto x88 = V{2}*cell[14];
auto x89 = V{2}*cell[5];
auto x90 = -cell[15] + cell[6];
auto x91 = x36 - cell[10] + cell[1];
auto x92 = x46 + x81 - x88 + x89 + x90 + x91;
auto x93 = -x80*x92*x92 + x84 + x87;
auto x94 = x29 + x30 + cell[10];
auto x95 = x37 + x49 + x94 + V{2}*cell[15] - V{2}*cell[6];
auto x96 = x80*(x95*x95);
auto x97 = x76 + x84 - x96;
auto x98 = -x76;
auto x99 = V{2}*cell[16];
auto x100 = V{2}*cell[7];
auto x101 = -cell[13] + cell[4];
auto x102 = x100 + x101 + x40 + x49 + x91 - x99;
auto x103 = -x80*x102*x102 + x84 + x98;
auto x104 = x46 + x47 + cell[12];
auto x105 = x104 + x28 + x41 + V{2}*cell[17] - V{2}*cell[8];
auto x106 = x80*(x105*x105);
auto x107 = x54 + x72;
auto x108 = -x106 + x107 + x76;
auto x109 = V{2}*cell[18];
auto x110 = V{2}*cell[9];
auto x111 = x27 - cell[11] + cell[2];
auto x112 = x101 + x104 - x109 + x110 + x111 + x29;
auto x113 = x107 - x80*x112*x112 + x98;
auto x114 = -x44;
auto x115 = V{1} - x52;
auto x116 = x114 + x115;
auto x117 = x116 + x64;
auto x118 = x117 + x66;
auto x119 = -x35;
auto x120 = x119 + x72;
auto x121 = x115 + x120 + x73;
auto x122 = x119 + x76;
auto x123 = x114 + x122 + x77 + V{1};
auto x124 = x117 + x120 + x83;
auto x125 = -x64;
auto x126 = -cell[17] + cell[8];
auto x127 = x111 + x126 + x32 + x48 + x88 - x89;
auto x128 = x107 + x125 - x80*x127*x127;
auto x129 = x117 + x122 + x96;
auto x130 = x26 - cell[12] + cell[3];
auto x131 = -x100 + x126 + x130 + x38 + x94 + x99;
auto x132 = x54 + x76;
auto x133 = x125 + x132 - x80*x131*x131;
auto x134 = x106 + x116 + x120 + x76;
auto x135 = x109 - x110 + x130 + x31 + x41 + x90;
auto x136 = x132 - x80*x135*x135 + x87;
cell[0] = -x19*(x54*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9] + V{0.333333333333333}) + cell[0] + V{0.333333333333333}) - V{0.333333333333333}*x54*x56 + V{-0.333333333333333};
cell[1] = -x19*(x57*x67 + cell[1] + V{0.0555555555555556}) - x67*x68 + V{-0.0555555555555556};
cell[2] = -x19*(x57*x75 + cell[2] + V{0.0555555555555556}) - x68*x75 + V{-0.0555555555555556};
cell[3] = -x19*(x57*x78 + cell[3] + V{0.0555555555555556}) - x68*x78 + V{-0.0555555555555556};
cell[4] = -x19*(x79*x85 + cell[4] + V{0.0277777777777778}) - x85*x86 + V{-0.0277777777777778};
cell[5] = -x19*(x79*x93 + cell[5] + V{0.0277777777777778}) - x86*x93 + V{-0.0277777777777778};
cell[6] = -x19*(x79*x97 + cell[6] + V{0.0277777777777778}) - x86*x97 + V{-0.0277777777777778};
cell[7] = -x103*x86 - x19*(x103*x79 + cell[7] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[8] = -x108*x86 - x19*(x108*x79 + cell[8] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[9] = -x113*x86 - x19*(x113*x79 + cell[9] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[10] = x118*x68 - x19*(-x118*x57 + cell[10] + V{0.0555555555555556}) + V{-0.0555555555555556};
cell[11] = x121*x68 - x19*(-x121*x57 + cell[11] + V{0.0555555555555556}) + V{-0.0555555555555556};
cell[12] = x123*x68 - x19*(-x123*x57 + cell[12] + V{0.0555555555555556}) + V{-0.0555555555555556};
cell[13] = x124*x86 - x19*(-x124*x79 + cell[13] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[14] = -x128*x86 - x19*(x128*x79 + cell[14] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[15] = x129*x86 - x19*(-x129*x79 + cell[15] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[16] = -x133*x86 - x19*(x133*x79 + cell[16] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[17] = x134*x86 - x19*(-x134*x79 + cell[17] + V{0.0277777777777778}) + V{-0.0277777777777778};
cell[18] = -x136*x86 - x19*(x136*x79 + cell[18] + V{0.0277777777777778}) + V{-0.0277777777777778};
return { x20 - x23 + V{2}, V{1}*x24*(x34 + x43 + x51) };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x31 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x27 = x30 + V{-1};
auto x28 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x29 = x28 + V{1};
auto x32 = V{1} / ((x29)*(x29));
auto x33 = V{1.5}*x32;
auto x34 = -cell[4];
auto x35 = -cell[6];
auto x36 = x34 + x35 + cell[17] + cell[19];
auto x37 = -cell[7];
auto x38 = cell[18] - cell[5];
auto x39 = x37 + x38 + cell[20];
auto x40 = -cell[11] + cell[24];
auto x41 = -cell[10] + cell[23];
auto x42 = x40 + x41;
auto x43 = cell[14] - cell[1];
auto x44 = -cell[12] + cell[25];
auto x45 = -cell[13] + cell[26];
auto x46 = x44 + x45;
auto x47 = x36 + x39 + x42 + x43 + x46;
auto x48 = x47*x47;
auto x49 = x33*x48;
auto x50 = -cell[8];
auto x51 = cell[13] - cell[26];
auto x52 = x50 + x51 + cell[21];
auto x53 = -cell[9];
auto x54 = cell[12] - cell[25];
auto x55 = x53 + x54 + cell[22];
auto x56 = x34 + cell[17];
auto x57 = -cell[2];
auto x58 = -cell[18] + cell[5];
auto x59 = x57 + x58 + cell[15];
auto x60 = x56 + x59;
auto x61 = x42 + x52 + x55 + x60;
auto x62 = x61*x61;
auto x63 = x33*x62;
auto x64 = -cell[3];
auto x65 = x44 + x64 + cell[16];
auto x66 = cell[11] - cell[24];
auto x67 = -cell[22] + cell[9];
auto x68 = x66 + x67;
auto x69 = x35 + cell[19];
auto x70 = -cell[20] + cell[7];
auto x71 = x69 + x70;
auto x72 = x41 + x52 + x65 + x68 + x71;
auto x73 = x72*x72;
auto x74 = x33*x73;
auto x75 = x63 + x74 + V{-1};
auto x76 = x49 + x75;
auto x77 = V{1} / (x29);
auto x78 = (x28 + V{1})*(-x77*(x31 + V{-1}) + V{1});
auto x79 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x80 = V{3}*cell[14];
auto x81 = V{3}*cell[1];
auto x82 = V{3}*cell[17];
auto x83 = V{3}*cell[23];
auto x84 = V{3}*cell[24];
auto x85 = V{3}*cell[4];
auto x86 = V{3}*cell[10];
auto x87 = -x86;
auto x88 = V{3}*cell[11];
auto x89 = -x88;
auto x90 = x82 + x83 + x84 - x85 + x87 + x89;
auto x91 = V{3}*cell[19];
auto x92 = V{3}*cell[25];
auto x93 = V{3}*cell[6];
auto x94 = V{3}*cell[12];
auto x95 = -x94;
auto x96 = x91 + x92 - x93 + x95;
auto x97 = V{3}*cell[18];
auto x98 = V{3}*cell[26];
auto x99 = V{3}*cell[5];
auto x100 = V{3}*cell[13];
auto x101 = -x100;
auto x102 = x101 + x97 + x98 - x99;
auto x103 = V{3}*cell[20];
auto x104 = V{3}*cell[7];
auto x105 = x103 - x104;
auto x106 = x77*(x102 + x105 + x80 - x81 + x90 + x96);
auto x107 = V{3}*x32;
auto x108 = x106 - x107*x48 + x75;
auto x109 = V{0.0740740740740741}*x78;
auto x110 = V{3}*cell[15];
auto x111 = V{3}*cell[2];
auto x112 = V{3}*cell[21];
auto x113 = V{3}*cell[8];
auto x114 = -x98;
auto x115 = x100 + x112 - x113 + x114;
auto x116 = V{3}*cell[22];
auto x117 = V{3}*cell[9];
auto x118 = -x92;
auto x119 = x116 - x117 + x118 + x94;
auto x120 = -x97 + x99;
auto x121 = x77*(x110 - x111 + x115 + x119 + x120 + x90);
auto x122 = x49 + V{-1};
auto x123 = -x107*x62 + x121 + x122 + x74;
auto x124 = V{3}*cell[16];
auto x125 = V{3}*cell[3];
auto x126 = -x84;
auto x127 = -x103 + x104 + x126 + x88;
auto x128 = -x116 + x117;
auto x129 = x77*(x115 + x124 - x125 + x127 + x128 + x83 + x87 + x96);
auto x130 = -x107*x73 + x122 + x129 + x63;
auto x131 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x132 = V{4.5}*x32;
auto x133 = x37 + cell[20];
auto x134 = x133 + x43 + x69;
auto x135 = x50 + cell[21];
auto x136 = V{2}*cell[10];
auto x137 = V{2}*cell[23];
auto x138 = -x136 + x137;
auto x139 = x135 + x138;
auto x140 = x53 + cell[22];
auto x141 = V{2}*cell[11];
auto x142 = V{2}*cell[24];
auto x143 = -x141 + x142;
auto x144 = x140 + x143;
auto x145 = V{2}*cell[4];
auto x146 = V{2}*cell[17];
auto x147 = x57 + cell[15];
auto x148 = -x145 + x146 + x147;
auto x149 = x134 + x139 + x144 + x148;
auto x150 = x106 + x76;
auto x151 = x121 + x150;
auto x152 = -x132*x149*x149 + x151;
auto x153 = V{0.0185185185185185}*x78;
auto x154 = V{2}*cell[26];
auto x155 = -x154;
auto x156 = V{2}*cell[13];
auto x157 = x155 + x156 + x70;
auto x158 = V{2}*cell[25];
auto x159 = -x158;
auto x160 = V{2}*cell[12];
auto x161 = -cell[19] + cell[6];
auto x162 = x159 + x160 + x161;
auto x163 = -cell[14] + cell[1];
auto x164 = x135 + x163;
auto x165 = V{2}*cell[18];
auto x166 = V{2}*cell[5];
auto x167 = x147 - x165 + x166;
auto x168 = x140 + x157 + x162 + x164 + x167;
auto x169 = -x121;
auto x170 = x150 + x169;
auto x171 = -x132*x168*x168 + x170;
auto x172 = x64 + cell[16];
auto x173 = x172 + x67;
auto x174 = x158 - x160;
auto x175 = x38 + x43 + x56;
auto x176 = V{2}*cell[6];
auto x177 = V{2}*cell[19];
auto x178 = -x176 + x177;
auto x179 = x139 + x173 + x174 + x175 + x178;
auto x180 = x129 - x132*x179*x179 + x150;
auto x181 = -x129;
auto x182 = x141 - x142;
auto x183 = V{2}*cell[20];
auto x184 = V{2}*cell[7];
auto x185 = -x183 + x184;
auto x186 = -cell[17] + cell[4];
auto x187 = x186 + x58;
auto x188 = x155 + x156 + x164 + x173 + x182 + x185 + x187;
auto x189 = -x132*x188*x188 + x150 + x181;
auto x190 = V{2}*cell[8];
auto x191 = V{2}*cell[21];
auto x192 = -x190 + x191;
auto x193 = x172 + x192;
auto x194 = x138 + x157 + x193 + x36 + x59;
auto x195 = x121 + x76;
auto x196 = x129 + x195;
auto x197 = -x132*x194*x194 + x196;
auto x198 = -cell[15] + cell[2];
auto x199 = x182 + x198;
auto x200 = x186 + x38;
auto x201 = V{2}*cell[22];
auto x202 = V{2}*cell[9];
auto x203 = -x201 + x202;
auto x204 = x172 + x203;
auto x205 = x174 + x199 + x200 + x204 + x71;
auto x206 = -x132*x205*x205 + x181 + x195;
auto x207 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x208 = V{3}*cell[10];
auto x209 = V{3}*cell[23];
auto x210 = x51 + x65;
auto x211 = x148 + x43;
auto x212 = x178 + x192 - x208 + x209 + x210 + x211 + x40;
auto x213 = x129 - x132*x212*x212 + x151;
auto x214 = V{0.00462962962962963}*x78;
auto x215 = V{3}*cell[24];
auto x216 = V{3}*cell[11];
auto x217 = cell[10] - cell[23];
auto x218 = x145 - x146;
auto x219 = x163 + x185;
auto x220 = x198 + x203 + x210 - x215 + x216 + x217 + x218 + x219;
auto x221 = -x132*x220*x220 + x151 + x181;
auto x222 = V{3}*cell[25];
auto x223 = V{3}*cell[12];
auto x224 = x163 + x176 - x177;
auto x225 = -cell[16];
auto x226 = x225 + cell[3];
auto x227 = x201 - x202 + x226;
auto x228 = x217 + x40;
auto x229 = x167 - x222 + x223 + x224 + x227 + x228 + x51;
auto x230 = x129 - x132*x229*x229 + x170;
auto x231 = -x83;
auto x232 = x231 - x82 + x85 + x86;
auto x233 = -x91 + x93;
auto x234 = x77*(x100 + x114 + x118 + x120 + x127 + x232 + x233 - x80 + x81 + x94);
auto x235 = V{3}*cell[26];
auto x236 = V{3}*cell[13];
auto x237 = x54 + x66;
auto x238 = x167 + x193 + x219 - x235 + x236 + x237 + x41;
auto x239 = -x112 + x113;
auto x240 = x77*(x101 + x105 + x119 - x124 + x125 + x231 + x233 + x239 + x84 + x86 + x89 + x98);
auto x241 = -x240;
auto x242 = -cell[21] + cell[8];
auto x243 = x198 + x242;
auto x244 = x200 + x217 + x243 + x46 + x68;
auto x245 = x244*x244;
auto x246 = -x245*x33;
auto x247 = x161 + x217;
auto x248 = x225 + x242 + cell[3];
auto x249 = x133 + x247 + x248 + x40 + x45 + x55;
auto x250 = x249*x249;
auto x251 = -x250*x33 + V{1};
auto x252 = x246 + x251;
auto x253 = x77*(x102 - x110 + x111 + x126 + x128 + x232 + x239 + x88 + x92 + x95);
auto x254 = x163 + x70;
auto x255 = x187 + x237 + x247 + x254 + x51;
auto x256 = x255*x255;
auto x257 = -x256*x33;
auto x258 = -x253 + x257;
auto x259 = x241 + x252 + x258;
auto x260 = x132*(x238*x238) + x234 + x259;
auto x261 = -x234 + x252;
auto x262 = x107*x256 + x261;
auto x263 = x107*x245 + x251 + x258;
auto x264 = x241 + x257;
auto x265 = x107*x250 + x246 + x264 + V{1};
auto x266 = x136 - x137;
auto x267 = x161 + x266;
auto x268 = x199 + x218 + x242 + x254 + x267 + x67;
auto x269 = x258 + x261;
auto x270 = x132*(x268*x268) + x269;
auto x271 = -x106;
auto x272 = x154 - x156;
auto x273 = x165 - x166;
auto x274 = x134 + x174 + x243 + x272 + x273 + x67;
auto x275 = -x132*x274*x274 + x195 + x271;
auto x276 = x140 + x159 + x160 + x187 + x224 + x248 + x266;
auto x277 = x261 + x264;
auto x278 = x132*(x276*x276) + x277;
auto x279 = x183 - x184;
auto x280 = x144 + x175 + x248 + x272 + x279;
auto x281 = x129 + x76;
auto x282 = -x132*x280*x280 + x271 + x281;
auto x283 = x190 - x191 + x198 + x226;
auto x284 = x186 + x267 + x272 + x283 + x39;
auto x285 = x132*(x284*x284) + x259;
auto x286 = x133 + x143 + x162 + x227 + x60;
auto x287 = -x132*x286*x286 + x169 + x281;
auto x288 = x208 - x209 + x218 + x224 + x237 + x283 + x45;
auto x289 = x132*(x288*x288) + x241 + x269;
auto x290 = x41 + x45;
auto x291 = x211 + x215 - x216 + x227 + x279 + x290 + x54;
auto x292 = x132*(x291*x291) + x240 + x269;
auto x293 = x273 + x43;
auto x294 = x178 + x198 + x204 + x222 - x223 + x290 + x293 + x66;
auto x295 = x132*(x294*x294) + x253 + x277;
auto x296 = x228 + x235 - x236 + x279 + x283 + x293 + x44;
auto x297 = -x132*x296*x296 + x196 + x271;
cell[0] = -x27*(x76*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + cell[0] + V{0.296296296296296}) - V{0.296296296296296}*x76*x78 + V{-0.296296296296296};
cell[1] = -x108*x109 - x27*(x108*x79 + cell[1] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[2] = -x109*x123 - x27*(x123*x79 + cell[2] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[3] = -x109*x130 - x27*(x130*x79 + cell[3] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[4] = -x152*x153 - x27*(x131*x152 + cell[4] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[5] = -x153*x171 - x27*(x131*x171 + cell[5] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[6] = -x153*x180 - x27*(x131*x180 + cell[6] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[7] = -x153*x189 - x27*(x131*x189 + cell[7] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[8] = -x153*x197 - x27*(x131*x197 + cell[8] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[9] = -x153*x206 - x27*(x131*x206 + cell[9] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[10] = -x213*x214 - x27*(x207*x213 + cell[10] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[11] = -x214*x221 - x27*(x207*x221 + cell[11] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[12] = -x214*x230 - x27*(x207*x230 + cell[12] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[13] = x214*x260 - x27*(-x207*x260 + cell[13] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[14] = x109*x262 - x27*(-x262*x79 + cell[14] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[15] = x109*x263 - x27*(-x263*x79 + cell[15] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[16] = x109*x265 - x27*(-x265*x79 + cell[16] + V{0.0740740740740741}) + V{-0.0740740740740741};
cell[17] = x153*x270 - x27*(-x131*x270 + cell[17] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[18] = -x153*x275 - x27*(x131*x275 + cell[18] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[19] = x153*x278 - x27*(-x131*x278 + cell[19] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[20] = -x153*x282 - x27*(x131*x282 + cell[20] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[21] = x153*x285 - x27*(-x131*x285 + cell[21] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[22] = -x153*x287 - x27*(x131*x287 + cell[22] + V{0.0185185185185185}) + V{-0.0185185185185185};
cell[23] = x214*x289 - x27*(-x207*x289 + cell[23] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[24] = x214*x292 - x27*(-x207*x292 + cell[24] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[25] = x214*x295 - x27*(-x207*x295 + cell[25] + V{0.00462962962962963}) + V{-0.00462962962962963};
cell[26] = -x214*x297 - x27*(x207*x297 + cell[26] + V{0.00462962962962963}) + V{-0.00462962962962963};
return { x28 - x31 + V{2}, V{1}*x32*(x245 + x250 + x256) };
}

};


template <typename... FIELDS>
struct RLB::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x5 = x7 + V{-1};
auto x6 = V{0.333333333333333}*cell[0];
auto x8 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + V{1};
auto x9 = V{1} / (x8);
auto x10 = V{0.5}*x9;
auto x11 = -cell[1] + cell[3];
auto x12 = x11*x11;
auto x13 = -cell[2] + cell[4];
auto x14 = x13*x13;
auto x15 = x10*x14;
auto x16 = V{1} / ((x8)*(x8));
auto x17 = V{1.5}*x16;
auto x18 = x12*x17 + V{-1};
auto x19 = V{0.166666666666667}*cell[0] + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667};
auto x20 = x9*(V{3}*cell[1] - V{3}*cell[3]);
auto x21 = V{3}*x16;
auto x22 = cell[1] - cell[3];
auto x23 = x22*x22;
auto x24 = cell[2] - cell[4];
auto x25 = x24*x24;
auto x26 = -x17*x25 + x21*x23 + V{1};
auto x27 = V{0.0833333333333333}*cell[0];
auto x28 = V{0.25}*x9;
auto x29 = x5*(x10*x23 - x25*x28 + x27 - V{0.416666666666667}*cell[1] + V{0.333333333333333}*cell[2] - V{0.416666666666667}*cell[3] + V{0.333333333333333}*cell[4]) + V{-0.166666666666667};
auto x30 = x27 + V{0.333333333333333}*cell[1] - V{0.416666666666667}*cell[2] + V{0.333333333333333}*cell[3] - V{0.416666666666667}*cell[4];
auto x31 = V{3}*cell[4];
auto x32 = V{3}*cell[2];
cell[0] = x5*(-x10*x12 - x15 - x6 + V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[4]) - (x14*x17 + x18)*(x6 + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}) + V{-0.333333333333333};
cell[1] = x19*(x20 + x26) + x29;
cell[2] = -x19*(-x14*x21 + x18 + x9*(x31 - x32)) + x5*(-x12*x28 + x15 + x30) + V{-0.166666666666667};
cell[3] = x19*(-x20 + x26) + x29;
cell[4] = -x19*(x17*x23 - x21*x25 + x9*(-x31 + x32) + V{-1}) + x5*(x10*x25 - x23*x28 + x30) + V{-0.166666666666667};
return { x8, V{1}*x16*(x23 + x25) };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = x11 + V{-1};
auto x10 = V{0.444444444444444}*cell[0];
auto x12 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + V{1};
auto x13 = V{1} / (x12);
auto x14 = V{0.666666666666667}*x13;
auto x15 = -cell[3] + cell[7];
auto x16 = -cell[2] + cell[6];
auto x17 = x15 + x16 - cell[1] + cell[5];
auto x18 = x17*x17;
auto x19 = cell[1] - cell[5];
auto x20 = -cell[4] + cell[8];
auto x21 = x15 + x19 + x20;
auto x22 = x21*x21;
auto x23 = V{1} / ((x12)*(x12));
auto x24 = V{1.5}*x23;
auto x25 = x22*x24;
auto x26 = x18*x24 + V{-1};
auto x27 = x25 + x26;
auto x28 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778};
auto x29 = V{3}*cell[2];
auto x30 = V{3}*cell[3];
auto x31 = V{3}*cell[6];
auto x32 = V{3}*cell[7];
auto x33 = V{3}*cell[1];
auto x34 = V{3}*cell[5];
auto x35 = x33 - x34;
auto x36 = x13*(x29 + x30 - x31 - x32 + x35);
auto x37 = V{4.5}*x23;
auto x38 = V{2}*cell[1];
auto x39 = V{2}*cell[5];
auto x40 = cell[4] - cell[8];
auto x41 = x16 - x38 + x39 + x40;
auto x42 = V{1} - x25;
auto x43 = -x30 + x32;
auto x44 = x13*(x35 + x43 - V{3}*cell[4] + V{3}*cell[8]);
auto x45 = cell[2] - cell[6];
auto x46 = x19 + x45 + cell[3] - cell[7];
auto x47 = x46*x46;
auto x48 = -x24*x47;
auto x49 = x44 + x48;
auto x50 = x42 + x49;
auto x51 = V{0.0277777777777778}*cell[2];
auto x52 = V{0.0277777777777778}*cell[4];
auto x53 = V{0.0277777777777778}*cell[6];
auto x54 = V{0.0277777777777778}*cell[8];
auto x55 = V{0.0555555555555556}*cell[0];
auto x56 = V{0.0833333333333333}*x13;
auto x57 = x22*x56;
auto x58 = x47*x56;
auto x59 = V{0.25}*x13*x21;
auto x60 = -x46*x59;
auto x61 = -x9*(x51 + x52 + x53 + x54 - x55 - x57 - x58 + x60 + V{0.361111111111111}*cell[1] - V{0.138888888888889}*cell[3] + V{0.361111111111111}*cell[5] - V{0.138888888888889}*cell[7]) + V{-0.0277777777777778};
auto x62 = V{0.111111111111111}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7] + V{0.111111111111111}*cell[8] + V{0.111111111111111};
auto x63 = V{3}*x23;
auto x64 = x42 + x47*x63;
auto x65 = V{0.166666666666667}*x13;
auto x66 = V{0.333333333333333}*x13;
auto x67 = -V{0.0555555555555556}*cell[0] + V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[5] + V{0.111111111111111}*cell[7];
auto x68 = -x9*(x22*x65 - x47*x66 + x67 + V{0.277777777777778}*cell[2] - V{0.222222222222222}*cell[4] + V{0.277777777777778}*cell[6] - V{0.222222222222222}*cell[8]) + V{-0.111111111111111};
auto x69 = -x51 - x52 - x53 - x54 + x55 + x57 + V{0.138888888888889}*cell[1] - V{0.361111111111111}*cell[3] + V{0.138888888888889}*cell[5] - V{0.361111111111111}*cell[7];
auto x70 = V{2}*cell[3];
auto x71 = V{2}*cell[7];
auto x72 = x16 + x20 - x70 + x71;
auto x73 = x9*(-x22*x66 + x47*x65 + x67 - V{0.222222222222222}*cell[2] + V{0.277777777777778}*cell[4] - V{0.222222222222222}*cell[6] + V{0.277777777777778}*cell[8]);
auto x74 = x22*x63;
auto x75 = -x36;
auto x76 = x20 + x38 - x39 + x45;
auto x77 = x40 + x45 + x70 - x71;
cell[0] = -x27*(x10 + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + x9*(-x10 - x14*x18 - x14*x22 + V{0.888888888888889}*cell[1] + V{0.222222222222222}*cell[2] + V{0.888888888888889}*cell[3] + V{0.222222222222222}*cell[4] + V{0.888888888888889}*cell[5] + V{0.222222222222222}*cell[6] + V{0.888888888888889}*cell[7] + V{0.222222222222222}*cell[8]) + V{-0.444444444444444};
cell[1] = x28*(x36 + x37*(x41*x41) + x50) + x61;
cell[2] = x62*(x36 + x64) + x68;
cell[3] = -x28*(x13*(-x29 + x31 - x33 + x34 + x43) + x27 - x37*x72*x72 + x44) + x9*(x17*x59 + x18*x56 + x69) + V{-0.0277777777777778};
cell[4] = -x62*(x26 + x44 - x74) - x73 + V{-0.111111111111111};
cell[5] = x28*(x37*(x76*x76) + x42 - x44 + x48 + x75) + x61;
cell[6] = x62*(x64 + x75) + x68;
cell[7] = x28*(x37*(x77*x77) + x50 + x75) + x9*(x58 + x60 + x69) + V{-0.0277777777777778};
cell[8] = x62*(x49 + x74 + V{1}) - x73 + V{-0.111111111111111};
return { x12, V{1}*x23*(x22 + x47) };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x7 = x10 + V{-1};
auto x8 = V{0.125}*cell[1];
auto x9 = V{0.125}*cell[2];
auto x11 = V{0.125}*cell[3];
auto x12 = V{0.125}*cell[4];
auto x13 = V{0.125}*cell[5];
auto x14 = V{0.125}*cell[6];
auto x15 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1};
auto x16 = V{1} / (x15);
auto x17 = V{0.5}*x16;
auto x18 = -cell[1] + cell[4];
auto x19 = x18*x18;
auto x20 = -cell[2] + cell[5];
auto x21 = x20*x20;
auto x22 = -cell[3] + cell[6];
auto x23 = x22*x22;
auto x24 = V{1} / ((x15)*(x15));
auto x25 = V{2}*x24;
auto x26 = x19*x25;
auto x27 = x21*x25;
auto x28 = x23*x25;
auto x29 = x27 + x28 + V{-1};
auto x30 = V{0.75}*x16;
auto x31 = V{0.25}*x16;
auto x32 = V{0.0625}*cell[0];
auto x33 = x32 + V{0.3125}*cell[3] + V{0.3125}*cell[6];
auto x34 = -x23*x31 + x33;
auto x35 = V{0.3125}*cell[2] + V{0.3125}*cell[5];
auto x36 = -x21*x31 + x35;
auto x37 = -V{0.6875}*cell[1] - V{0.6875}*cell[4];
auto x38 = x11 + x12 + x13 + x14 + x8 + x9 + V{0.125}*cell[0] + V{0.125};
auto x39 = V{4}*cell[4];
auto x40 = V{4}*cell[1];
auto x41 = V{6}*x24;
auto x42 = V{0.3125}*cell[1] + V{0.3125}*cell[4];
auto x43 = -x19*x31 + x42;
auto x44 = -V{0.6875}*cell[2] - V{0.6875}*cell[5];
auto x45 = V{4}*cell[5];
auto x46 = V{4}*cell[2];
auto x47 = x26 + V{-1};
auto x48 = x32 - V{0.6875}*cell[3] - V{0.6875}*cell[6];
auto x49 = V{4}*cell[6];
auto x50 = V{4}*cell[3];
auto x51 = cell[1] - cell[4];
auto x52 = x51*x51;
auto x53 = cell[3] - cell[6];
auto x54 = x53*x53;
auto x55 = -x31*x54 + x33;
auto x56 = cell[2] - cell[5];
auto x57 = x56*x56;
auto x58 = -x31*x57 + x35;
auto x59 = x25*x57;
auto x60 = x25*x54 + V{-1};
auto x61 = -x31*x52 + x42;
auto x62 = x25*x52;
cell[0] = x7*(x11 + x12 + x13 + x14 - x17*x19 - x17*x21 - x17*x23 + x8 + x9 - V{0.375}*cell[0]) - (x26 + x29)*(V{0.25}*cell[0] + V{0.25}*cell[1] + V{0.25}*cell[2] + V{0.25}*cell[3] + V{0.25}*cell[4] + V{0.25}*cell[5] + V{0.25}*cell[6] + V{0.25}) + V{-0.25};
cell[1] = -x38*(x16*(x39 - x40) - x19*x41 + x29) + x7*(x19*x30 + x34 + x36 + x37) + V{-0.125};
cell[2] = -x38*(x16*(x45 - x46) - x21*x41 + x28 + x47) + x7*(x21*x30 + x34 + x43 + x44) + V{-0.125};
cell[3] = -x38*(x16*(x49 - x50) - x23*x41 + x27 + x47) + x7*(x23*x30 + x36 + x43 + x48) + V{-0.125};
cell[4] = -x38*(x16*(-x39 + x40) - x41*x52 + x59 + x60) + x7*(x30*x52 + x37 + x55 + x58) + V{-0.125};
cell[5] = -x38*(x16*(-x45 + x46) - x41*x57 + x60 + x62) + x7*(x30*x57 + x44 + x55 + x61) + V{-0.125};
cell[6] = -x38*(x16*(-x49 + x50) - x41*x54 + x59 + x62 + V{-1}) + x7*(x30*x54 + x48 + x58 + x61) + V{-0.125};
return { x15, V{1}*x24*(x52 + x54 + x57) };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = x22 + V{-1};
auto x20 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x21 = V{1} / (x20);
auto x23 = V{0.5}*x21;
auto x24 = cell[13] - cell[4];
auto x25 = cell[15] - cell[6];
auto x26 = x24 + x25;
auto x27 = cell[14] - cell[5];
auto x28 = -cell[1];
auto x29 = cell[16] - cell[7];
auto x30 = x28 + x29 + cell[10];
auto x31 = x26 + x27 + x30;
auto x32 = x31*x31;
auto x33 = cell[17] - cell[8];
auto x34 = x24 + x33;
auto x35 = cell[18] - cell[9];
auto x36 = -cell[2];
auto x37 = -cell[14] + cell[5];
auto x38 = x36 + x37 + cell[11];
auto x39 = x34 + x35 + x38;
auto x40 = x39*x39;
auto x41 = x25 + x33;
auto x42 = -cell[16] + cell[7];
auto x43 = -cell[3];
auto x44 = -cell[18] + cell[9];
auto x45 = x43 + x44 + cell[12];
auto x46 = x41 + x42 + x45;
auto x47 = x46*x46;
auto x48 = V{1} / ((x20)*(x20));
auto x49 = V{1.5}*x48;
auto x50 = x32*x49;
auto x51 = x40*x49;
auto x52 = x47*x49;
auto x53 = x51 + x52 + V{-1};
auto x54 = x50 + x53;
auto x55 = V{0.166666666666667}*x21;
auto x56 = -V{6.93889390390723e-18}*cell[0];
auto x57 = V{0.0833333333333333}*x21;
auto x58 = -V{0.0833333333333333}*cell[12] - V{0.0833333333333333}*cell[3];
auto x59 = x47*x57 + x56 + x58 + V{0.0833333333333333}*cell[13] + V{0.0833333333333333}*cell[14] + V{0.0833333333333333}*cell[4] + V{0.0833333333333333}*cell[5];
auto x60 = -V{0.0833333333333333}*cell[11] - V{0.0833333333333333}*cell[2];
auto x61 = x40*x57 + x60 + V{0.0833333333333333}*cell[15] + V{0.0833333333333333}*cell[16] + V{0.0833333333333333}*cell[6] + V{0.0833333333333333}*cell[7];
auto x62 = x19*(-x32*x55 + x59 + x61 + V{0.166666666666667}*cell[10] - V{0.166666666666667}*cell[17] - V{0.166666666666667}*cell[18] + V{0.166666666666667}*cell[1] - V{0.166666666666667}*cell[8] - V{0.166666666666667}*cell[9]);
auto x63 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[10] + V{0.0555555555555556}*cell[11] + V{0.0555555555555556}*cell[12] + V{0.0555555555555556}*cell[13] + V{0.0555555555555556}*cell[14] + V{0.0555555555555556}*cell[15] + V{0.0555555555555556}*cell[16] + V{0.0555555555555556}*cell[17] + V{0.0555555555555556}*cell[18] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556}*cell[9] + V{0.0555555555555556};
auto x64 = V{3}*cell[14];
auto x65 = V{3}*cell[16];
auto x66 = V{3}*cell[5];
auto x67 = V{3}*cell[7];
auto x68 = V{3}*cell[13] - V{3}*cell[4];
auto x69 = V{3}*cell[15] - V{3}*cell[6];
auto x70 = x21*(x64 + x65 - x66 - x67 + x68 + x69 + V{3}*cell[10] - V{3}*cell[1]);
auto x71 = V{3}*x48;
auto x72 = x32*x71;
auto x73 = -V{0.0833333333333333}*cell[10] - V{0.0833333333333333}*cell[1];
auto x74 = x32*x57 + x73 + V{0.0833333333333333}*cell[17] + V{0.0833333333333333}*cell[18] + V{0.0833333333333333}*cell[8] + V{0.0833333333333333}*cell[9];
auto x75 = x19*(-x40*x55 + x59 + x74 + V{0.166666666666667}*cell[11] - V{0.166666666666667}*cell[15] - V{0.166666666666667}*cell[16] + V{0.166666666666667}*cell[2] - V{0.166666666666667}*cell[6] - V{0.166666666666667}*cell[7]);
auto x76 = V{3}*cell[18];
auto x77 = V{3}*cell[9];
auto x78 = V{3}*cell[17] - V{3}*cell[8];
auto x79 = x21*(-x64 + x66 + x68 + x76 - x77 + x78 + V{3}*cell[11] - V{3}*cell[2]);
auto x80 = x40*x71;
auto x81 = x50 + V{-1};
auto x82 = x19*(-x47*x55 + x56 + x61 + x74 + V{0.166666666666667}*cell[12] - V{0.166666666666667}*cell[13] - V{0.166666666666667}*cell[14] + V{0.166666666666667}*cell[3] - V{0.166666666666667}*cell[4] - V{0.166666666666667}*cell[5]);
auto x83 = x21*(-x65 + x67 + x69 - x76 + x77 + x78 + V{3}*cell[12] - V{3}*cell[3]);
auto x84 = x47*x71;
auto x85 = V{0.25}*x21*x31;
auto x86 = x39*x85;
auto x87 = V{0.0416666666666667}*x21;
auto x88 = -V{0.0416666666666667}*cell[0];
auto x89 = V{0.0833333333333333}*x21;
auto x90 = -x32*x89 + x88 + V{0.0416666666666667}*cell[10] + V{6.93889390390723e-18}*cell[17] + V{6.93889390390723e-18}*cell[18] + V{0.0416666666666667}*cell[1] + V{6.93889390390723e-18}*cell[8] + V{6.93889390390723e-18}*cell[9];
auto x91 = -x40*x89 + V{0.0416666666666667}*cell[11] + V{6.93889390390723e-18}*cell[15] + V{6.93889390390723e-18}*cell[16] + V{0.0416666666666667}*cell[2] + V{6.93889390390723e-18}*cell[6] + V{6.93889390390723e-18}*cell[7];
auto x92 = x47*x87 + x58 + x90 + x91;
auto x93 = x19*(-x86 + x92 + V{0.375}*cell[13] - V{0.125}*cell[14] + V{0.375}*cell[4] - V{0.125}*cell[5]);
auto x94 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x95 = V{4.5}*x48;
auto x96 = x35 + x36 + cell[11];
auto x97 = x30 + x41 + x96 + V{2}*cell[13] - V{2}*cell[4];
auto x98 = x95*(x97*x97);
auto x99 = x54 + x70;
auto x100 = -x79;
auto x101 = V{2}*cell[14];
auto x102 = V{2}*cell[5];
auto x103 = -cell[15] + cell[6];
auto x104 = x33 - cell[10] + cell[1];
auto x105 = -x101 + x102 + x103 + x104 + x42 + x96;
auto x106 = x19*(x86 + x92 - V{0.125}*cell[13] + V{0.375}*cell[14] - V{0.125}*cell[4] + V{0.375}*cell[5]) + V{0.0277777777777778};
auto x107 = x46*x85;
auto x108 = -x47*x89 + V{0.0416666666666667}*cell[12] + V{6.93889390390723e-18}*cell[13] + V{6.93889390390723e-18}*cell[14] + V{0.0416666666666667}*cell[3] + V{6.93889390390723e-18}*cell[4] + V{6.93889390390723e-18}*cell[5];
auto x109 = x108 + x40*x87 + x60 + x90;
auto x110 = x19*(-x107 + x109 + V{0.375}*cell[15] - V{0.125}*cell[16] + V{0.375}*cell[6] - V{0.125}*cell[7]);
auto x111 = x27 + x28 + cell[10];
auto x112 = x111 + x34 + x45 + V{2}*cell[15] - V{2}*cell[6];
auto x113 = x95*(x112*x112);
auto x114 = -x83;
auto x115 = V{2}*cell[16];
auto x116 = V{2}*cell[7];
auto x117 = -cell[13] + cell[4];
auto x118 = x104 - x115 + x116 + x117 + x37 + x45;
auto x119 = x19*(x107 + x109 - V{0.125}*cell[15] + V{0.375}*cell[16] - V{0.125}*cell[6] + V{0.375}*cell[7]) + V{0.0277777777777778};
auto x120 = V{0.25}*x21*x39*x46;
auto x121 = x108 + x32*x87 + x73 + x88 + x91;
auto x122 = x19*(-x120 + x121 + V{0.375}*cell[17] - V{0.125}*cell[18] + V{0.375}*cell[8] - V{0.125}*cell[9]);
auto x123 = x42 + x43 + cell[12];
auto x124 = x123 + x26 + x38 + V{2}*cell[17] - V{2}*cell[8];
auto x125 = x95*(x124*x124);
auto x126 = x54 + x79;
auto x127 = V{2}*cell[18];
auto x128 = V{2}*cell[9];
auto x129 = x25 - cell[11] + cell[2];
auto x130 = x117 + x123 - x127 + x128 + x129 + x27;
auto x131 = x19*(x120 + x121 - V{0.125}*cell[17] + V{0.375}*cell[18] - V{0.125}*cell[8] + V{0.375}*cell[9]) + V{0.0277777777777778};
auto x132 = -x51;
auto x133 = V{1} - x52;
auto x134 = x132 + x133;
auto x135 = x134 + x70;
auto x136 = -x50;
auto x137 = x136 + x79;
auto x138 = x136 + x83;
auto x139 = -x70;
auto x140 = -cell[17] + cell[8];
auto x141 = x101 - x102 + x129 + x140 + x30 + x44;
auto x142 = x24 - cell[12] + cell[3];
auto x143 = x111 + x115 - x116 + x140 + x142 + x35;
auto x144 = x54 + x83;
auto x145 = x103 + x127 - x128 + x142 + x29 + x38;
cell[0] = x19*(-x23*x32 - x23*x40 - x23*x47 - V{0.5}*cell[0] + V{4.16333634234434e-17}*cell[10] + V{4.16333634234434e-17}*cell[11] + V{4.16333634234434e-17}*cell[12] + V{0.5}*cell[13] + V{0.5}*cell[14] + V{0.5}*cell[15] + V{0.5}*cell[16] + V{0.5}*cell[17] + V{0.5}*cell[18] + V{4.16333634234434e-17}*cell[1] + V{4.16333634234434e-17}*cell[2] + V{4.16333634234434e-17}*cell[3] + V{0.5}*cell[4] + V{0.5}*cell[5] + V{0.5}*cell[6] + V{0.5}*cell[7] + V{0.5}*cell[8] + V{0.5}*cell[9]) - x54*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9] + V{0.333333333333333}) + V{-0.333333333333333};
cell[1] = -x62 - x63*(x53 + x70 - x72) + V{-0.0555555555555556};
cell[2] = -x63*(x52 + x79 - x80 + x81) - x75 + V{-0.0555555555555556};
cell[3] = -x63*(x51 + x81 + x83 - x84) - x82 + V{-0.0555555555555556};
cell[4] = -x93 - x94*(x79 - x98 + x99) + V{-0.0277777777777778};
cell[5] = -x106 - x94*(x100 - x95*x105*x105 + x99);
cell[6] = -x110 - x94*(-x113 + x83 + x99) + V{-0.0277777777777778};
cell[7] = -x119 - x94*(x114 - x95*x118*x118 + x99);
cell[8] = -x122 - x94*(-x125 + x126 + x83) + V{-0.0277777777777778};
cell[9] = -x131 - x94*(x114 + x126 - x95*x130*x130);
cell[10] = -x62 + x63*(x135 + x72) + V{-0.0555555555555556};
cell[11] = x63*(x133 + x137 + x80) - x75 + V{-0.0555555555555556};
cell[12] = x63*(x132 + x138 + x84 + V{1}) - x82 + V{-0.0555555555555556};
cell[13] = -x93 + x94*(x135 + x137 + x98) + V{-0.0277777777777778};
cell[14] = -x106 - x94*(x126 + x139 - x95*x141*x141);
cell[15] = -x110 + x94*(x113 + x135 + x138) + V{-0.0277777777777778};
cell[16] = -x119 - x94*(x139 + x144 - x95*x143*x143);
cell[17] = -x122 + x94*(x125 + x134 + x137 + x83) + V{-0.0277777777777778};
cell[18] = -x131 - x94*(x100 + x144 - x95*x145*x145);
return { x20, V{1}*x48*(x32 + x40 + x47) };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x27 = x30 + V{-1};
auto x28 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x29 = V{1} / (x28);
auto x31 = V{0.444444444444444}*x29;
auto x32 = -cell[4];
auto x33 = -cell[6];
auto x34 = x32 + x33 + cell[17] + cell[19];
auto x35 = -cell[7];
auto x36 = cell[18] - cell[5];
auto x37 = x35 + x36 + cell[20];
auto x38 = -cell[11] + cell[24];
auto x39 = -cell[10] + cell[23];
auto x40 = x38 + x39;
auto x41 = -cell[12] + cell[25];
auto x42 = -cell[13] + cell[26];
auto x43 = x41 + x42;
auto x44 = cell[14] - cell[1];
auto x45 = x34 + x37 + x40 + x43 + x44;
auto x46 = x45*x45;
auto x47 = -cell[8];
auto x48 = cell[13] - cell[26];
auto x49 = x47 + x48 + cell[21];
auto x50 = -cell[9];
auto x51 = cell[12] - cell[25];
auto x52 = x50 + x51 + cell[22];
auto x53 = x32 + cell[17];
auto x54 = -cell[2];
auto x55 = -cell[18] + cell[5];
auto x56 = x54 + x55 + cell[15];
auto x57 = x53 + x56;
auto x58 = x40 + x49 + x52 + x57;
auto x59 = x58*x58;
auto x60 = -cell[3];
auto x61 = x41 + x60 + cell[16];
auto x62 = -cell[22];
auto x63 = cell[11] - cell[24];
auto x64 = x62 + x63 + cell[9];
auto x65 = x33 + cell[19];
auto x66 = -cell[20] + cell[7];
auto x67 = x65 + x66;
auto x68 = x39 + x49 + x61 + x64 + x67;
auto x69 = x68*x68;
auto x70 = V{1} / ((x28)*(x28));
auto x71 = V{1.5}*x70;
auto x72 = x46*x71;
auto x73 = x59*x71;
auto x74 = x69*x71;
auto x75 = x73 + x74 + V{-1};
auto x76 = x72 + x75;
auto x77 = V{0.222222222222222}*x29;
auto x78 = -cell[17] + cell[4];
auto x79 = cell[10] - cell[23];
auto x80 = x78 + x79;
auto x81 = -cell[14];
auto x82 = x55 + x81 + cell[1];
auto x83 = -cell[19] + cell[6];
auto x84 = x66 + x83;
auto x85 = x51 + x63;
auto x86 = x48 + x80 + x82 + x84 + x85;
auto x87 = x86*x86;
auto x88 = V{1.85037170770859e-17}*cell[10];
auto x89 = V{1.85037170770859e-17}*cell[11];
auto x90 = V{1.85037170770859e-17}*cell[12];
auto x91 = V{1.85037170770859e-17}*cell[13];
auto x92 = V{1.85037170770859e-17}*cell[23];
auto x93 = V{1.85037170770859e-17}*cell[24];
auto x94 = V{1.85037170770859e-17}*cell[25];
auto x95 = V{1.85037170770859e-17}*cell[26];
auto x96 = -V{9.25185853854297e-18}*cell[0];
auto x97 = V{0.111111111111111}*x29;
auto x98 = x35 + cell[20];
auto x99 = -cell[16] + cell[3];
auto x100 = x42 + x99;
auto x101 = -cell[21];
auto x102 = x101 + x83 + cell[8];
auto x103 = x38 + x79;
auto x104 = x100 + x102 + x103 + x52 + x98;
auto x105 = x104*x104;
auto x106 = x105*x97 + x88 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 - V{0.111111111111111}*cell[16] + V{0.111111111111111}*cell[17] + V{0.111111111111111}*cell[18] - V{0.111111111111111}*cell[3] + V{0.111111111111111}*cell[4] + V{0.111111111111111}*cell[5];
auto x107 = -cell[15] + cell[2];
auto x108 = x101 + x36 + cell[8];
auto x109 = x107 + x108 + x43 + x64 + x80;
auto x110 = x109*x109;
auto x111 = x110*x97 - V{0.111111111111111}*cell[15] + V{0.111111111111111}*cell[19] + V{0.111111111111111}*cell[20] - V{0.111111111111111}*cell[2] + V{0.111111111111111}*cell[6] + V{0.111111111111111}*cell[7];
auto x112 = x27*(x106 + x111 - x77*x87 + V{0.222222222222222}*cell[14] + V{0.222222222222222}*cell[1] - V{0.222222222222222}*cell[21] - V{0.222222222222222}*cell[22] - V{0.222222222222222}*cell[8] - V{0.222222222222222}*cell[9]);
auto x113 = V{0.0740740740740741}*cell[0] + V{0.0740740740740741}*cell[10] + V{0.0740740740740741}*cell[11] + V{0.0740740740740741}*cell[12] + V{0.0740740740740741}*cell[13] + V{0.0740740740740741}*cell[14] + V{0.0740740740740741}*cell[15] + V{0.0740740740740741}*cell[16] + V{0.0740740740740741}*cell[17] + V{0.0740740740740741}*cell[18] + V{0.0740740740740741}*cell[19] + V{0.0740740740740741}*cell[1] + V{0.0740740740740741}*cell[20] + V{0.0740740740740741}*cell[21] + V{0.0740740740740741}*cell[22] + V{0.0740740740740741}*cell[23] + V{0.0740740740740741}*cell[24] + V{0.0740740740740741}*cell[25] + V{0.0740740740740741}*cell[26] + V{0.0740740740740741}*cell[2] + V{0.0740740740740741}*cell[3] + V{0.0740740740740741}*cell[4] + V{0.0740740740740741}*cell[5] + V{0.0740740740740741}*cell[6] + V{0.0740740740740741}*cell[7] + V{0.0740740740740741}*cell[8] + V{0.0740740740740741}*cell[9] + V{0.0740740740740741};
auto x114 = V{3}*cell[14];
auto x115 = V{3}*cell[1];
auto x116 = V{3}*cell[17];
auto x117 = V{3}*cell[23];
auto x118 = V{3}*cell[24];
auto x119 = V{3}*cell[4];
auto x120 = V{3}*cell[10];
auto x121 = -x120;
auto x122 = V{3}*cell[11];
auto x123 = -x122;
auto x124 = x116 + x117 + x118 - x119 + x121 + x123;
auto x125 = V{3}*cell[19];
auto x126 = V{3}*cell[25];
auto x127 = V{3}*cell[6];
auto x128 = V{3}*cell[12];
auto x129 = -x128;
auto x130 = x125 + x126 - x127 + x129;
auto x131 = V{3}*cell[18];
auto x132 = V{3}*cell[26];
auto x133 = V{3}*cell[5];
auto x134 = V{3}*cell[13];
auto x135 = -x134;
auto x136 = x131 + x132 - x133 + x135;
auto x137 = V{3}*cell[20];
auto x138 = V{3}*cell[7];
auto x139 = x137 - x138;
auto x140 = x29*(x114 - x115 + x124 + x130 + x136 + x139);
auto x141 = V{3}*x70;
auto x142 = x87*x97 - V{0.111111111111111}*cell[14] - V{0.111111111111111}*cell[1] + V{0.111111111111111}*cell[21] + V{0.111111111111111}*cell[22] + V{0.111111111111111}*cell[8] + V{0.111111111111111}*cell[9];
auto x143 = x27*(x106 - x110*x77 + x142 + V{0.222222222222222}*cell[15] - V{0.222222222222222}*cell[19] - V{0.222222222222222}*cell[20] + V{0.222222222222222}*cell[2] - V{0.222222222222222}*cell[6] - V{0.222222222222222}*cell[7]);
auto x144 = V{3}*cell[15];
auto x145 = V{3}*cell[2];
auto x146 = V{3}*cell[21];
auto x147 = V{3}*cell[8];
auto x148 = -x132;
auto x149 = x134 + x146 - x147 + x148;
auto x150 = V{3}*cell[22];
auto x151 = V{3}*cell[9];
auto x152 = -x126;
auto x153 = x128 + x150 - x151 + x152;
auto x154 = -x131 + x133;
auto x155 = x29*(x124 + x144 - x145 + x149 + x153 + x154);
auto x156 = x72 + V{-1};
auto x157 = x27*(-x105*x77 + x111 + x142 + x88 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 + V{0.222222222222222}*cell[16] - V{0.222222222222222}*cell[17] - V{0.222222222222222}*cell[18] + V{0.222222222222222}*cell[3] - V{0.222222222222222}*cell[4] - V{0.222222222222222}*cell[5]);
auto x158 = V{3}*cell[16];
auto x159 = V{3}*cell[3];
auto x160 = -x118;
auto x161 = x122 - x150 + x151 + x160;
auto x162 = -x137 + x138;
auto x163 = x29*(x117 + x121 + x130 + x149 + x158 - x159 + x161 + x162);
auto x164 = x109*x29;
auto x165 = V{0.166666666666667}*x86;
auto x166 = x164*x165;
auto x167 = V{4.62592926927149e-18}*cell[8];
auto x168 = V{4.62592926927149e-18}*cell[9];
auto x169 = V{4.62592926927149e-18}*cell[21];
auto x170 = V{4.62592926927149e-18}*cell[22];
auto x171 = V{0.0277777777777778}*cell[1];
auto x172 = V{0.0277777777777778}*cell[14];
auto x173 = V{0.222222222222222}*cell[10];
auto x174 = V{0.222222222222222}*cell[23];
auto x175 = -V{0.111111111111111}*cell[13];
auto x176 = -V{0.111111111111111}*cell[26];
auto x177 = -V{0.0277777777777778}*cell[0];
auto x178 = V{0.0555555555555556}*x29;
auto x179 = -x178*x87;
auto x180 = x167 + x168 + x169 + x170 + x171 + x172 + x173 + x174 + x175 + x176 + x177 + x179;
auto x181 = V{0.222222222222222}*cell[11];
auto x182 = V{0.222222222222222}*cell[24];
auto x183 = -V{0.111111111111111}*cell[12];
auto x184 = -V{0.111111111111111}*cell[25];
auto x185 = x181 + x182 + x183 + x184;
auto x186 = V{0.0277777777777778}*x29;
auto x187 = -x110*x178 + V{0.0277777777777778}*cell[15] + V{4.62592926927149e-18}*cell[19] + V{4.62592926927149e-18}*cell[20] + V{0.0277777777777778}*cell[2] + V{4.62592926927149e-18}*cell[6] + V{4.62592926927149e-18}*cell[7];
auto x188 = x105*x186 + x187 - V{0.0555555555555556}*cell[16] - V{0.0555555555555556}*cell[3];
auto x189 = x27*(-x166 + x180 + x185 + x188 + V{0.25}*cell[17] - V{0.0833333333333333}*cell[18] + V{0.25}*cell[4] - V{0.0833333333333333}*cell[5]);
auto x190 = V{0.0185185185185185}*cell[0] + V{0.0185185185185185}*cell[10] + V{0.0185185185185185}*cell[11] + V{0.0185185185185185}*cell[12] + V{0.0185185185185185}*cell[13] + V{0.0185185185185185}*cell[14] + V{0.0185185185185185}*cell[15] + V{0.0185185185185185}*cell[16] + V{0.0185185185185185}*cell[17] + V{0.0185185185185185}*cell[18] + V{0.0185185185185185}*cell[19] + V{0.0185185185185185}*cell[1] + V{0.0185185185185185}*cell[20] + V{0.0185185185185185}*cell[21] + V{0.0185185185185185}*cell[22] + V{0.0185185185185185}*cell[23] + V{0.0185185185185185}*cell[24] + V{0.0185185185185185}*cell[25] + V{0.0185185185185185}*cell[26] + V{0.0185185185185185}*cell[2] + V{0.0185185185185185}*cell[3] + V{0.0185185185185185}*cell[4] + V{0.0185185185185185}*cell[5] + V{0.0185185185185185}*cell[6] + V{0.0185185185185185}*cell[7] + V{0.0185185185185185}*cell[8] + V{0.0185185185185185}*cell[9] + V{0.0185185185185185};
auto x191 = V{4.5}*x70;
auto x192 = x44 + x65 + x98;
auto x193 = x47 + cell[21];
auto x194 = V{2}*cell[10];
auto x195 = V{2}*cell[23];
auto x196 = -x194 + x195;
auto x197 = x193 + x196;
auto x198 = x50 + cell[22];
auto x199 = V{2}*cell[11];
auto x200 = V{2}*cell[24];
auto x201 = -x199 + x200;
auto x202 = x198 + x201;
auto x203 = V{2}*cell[4];
auto x204 = V{2}*cell[17];
auto x205 = x54 + cell[15];
auto x206 = -x203 + x204 + x205;
auto x207 = x192 + x197 + x202 + x206;
auto x208 = x140 + x76;
auto x209 = x155 + x208;
auto x210 = V{2}*cell[26];
auto x211 = V{2}*cell[13];
auto x212 = -x210 + x211;
auto x213 = x193 + x212;
auto x214 = V{2}*cell[25];
auto x215 = V{2}*cell[12];
auto x216 = -x214 + x215;
auto x217 = x198 + x216;
auto x218 = V{2}*cell[18];
auto x219 = V{2}*cell[5];
auto x220 = x81 + cell[1];
auto x221 = x205 - x218 + x219 + x220;
auto x222 = x213 + x217 + x221 + x84;
auto x223 = -x155;
auto x224 = x208 + x223;
auto x225 = V{0.222222222222222}*cell[12];
auto x226 = V{0.222222222222222}*cell[25];
auto x227 = -V{0.111111111111111}*cell[11];
auto x228 = -V{0.111111111111111}*cell[24];
auto x229 = x225 + x226 + x227 + x228;
auto x230 = x177 + V{0.222222222222222}*cell[13] + V{0.222222222222222}*cell[26];
auto x231 = -V{0.111111111111111}*cell[10] - V{0.111111111111111}*cell[23];
auto x232 = x167 + x168 + x169 + x170 + x171 + x172 + x179 + x230 + x231;
auto x233 = x27*(x166 + x188 + x229 + x232 - V{0.0833333333333333}*cell[17] + V{0.25}*cell[18] - V{0.0833333333333333}*cell[4] + V{0.25}*cell[5]) + V{0.0185185185185185};
auto x234 = x104*x29;
auto x235 = x165*x234;
auto x236 = -x105*x178 + V{0.0277777777777778}*cell[16] + V{4.62592926927149e-18}*cell[17] + V{4.62592926927149e-18}*cell[18] + V{0.0277777777777778}*cell[3] + V{4.62592926927149e-18}*cell[4] + V{4.62592926927149e-18}*cell[5];
auto x237 = x110*x186 + x236 - V{0.0555555555555556}*cell[15] - V{0.0555555555555556}*cell[2];
auto x238 = x27*(x180 + x229 - x235 + x237 + V{0.25}*cell[19] - V{0.0833333333333333}*cell[20] + V{0.25}*cell[6] - V{0.0833333333333333}*cell[7]);
auto x239 = x44 + x53;
auto x240 = V{2}*cell[6];
auto x241 = V{2}*cell[19];
auto x242 = -x240 + x241;
auto x243 = x60 + cell[16];
auto x244 = x62 + cell[9];
auto x245 = x243 + x244;
auto x246 = x214 - x215;
auto x247 = x246 + x36;
auto x248 = x197 + x239 + x242 + x245 + x247;
auto x249 = -x163;
auto x250 = x199 - x200;
auto x251 = x78 + x82;
auto x252 = V{2}*cell[20];
auto x253 = V{2}*cell[7];
auto x254 = -x252 + x253;
auto x255 = x213 + x245 + x250 + x251 + x254;
auto x256 = x27*(x185 + x232 + x235 + x237 - V{0.0833333333333333}*cell[19] + V{0.25}*cell[20] - V{0.0833333333333333}*cell[6] + V{0.25}*cell[7]) + V{0.0185185185185185};
auto x257 = x104*x164;
auto x258 = V{0.166666666666667}*x257;
auto x259 = x186*x87 + x187 + x236 - V{0.0555555555555556}*cell[14] - V{0.0555555555555556}*cell[1];
auto x260 = x27*(x173 + x174 + x183 + x184 + x227 + x228 + x230 - x258 + x259 + V{0.25}*cell[21] - V{0.0833333333333333}*cell[22] + V{0.25}*cell[8] - V{0.0833333333333333}*cell[9]);
auto x261 = V{2}*cell[8];
auto x262 = V{2}*cell[21];
auto x263 = -x261 + x262;
auto x264 = x243 + x263;
auto x265 = x196 + x212 + x264 + x34 + x56 + x66;
auto x266 = x155 + x76;
auto x267 = x163 + x266;
auto x268 = x107 + x250;
auto x269 = V{2}*cell[22];
auto x270 = V{2}*cell[9];
auto x271 = -x269 + x270;
auto x272 = x243 + x271;
auto x273 = x247 + x268 + x272 + x67 + x78;
auto x274 = x27*(x175 + x176 + x177 + x181 + x182 + x225 + x226 + x231 + x258 + x259 - V{0.0833333333333333}*cell[21] + V{0.25}*cell[22] - V{0.0833333333333333}*cell[8] + V{0.25}*cell[9]) + V{0.0185185185185185};
auto x275 = V{0.0138888888888889}*x29;
auto x276 = x275*x46;
auto x277 = x275*x59;
auto x278 = x275*x69;
auto x279 = V{0.0416666666666667}*x29*x45;
auto x280 = x279*x58;
auto x281 = V{0.0138888888888889}*cell[13];
auto x282 = V{0.0138888888888889}*cell[26];
auto x283 = x281 + x282 - V{0.0555555555555556}*cell[17] + V{0.0277777777777778}*cell[18] - V{0.0555555555555556}*cell[4] + V{0.0277777777777778}*cell[5];
auto x284 = x276 + x277 + x278 + x280 + x283;
auto x285 = x279*x68;
auto x286 = -V{0.0555555555555556}*cell[19] + V{0.0277777777777778}*cell[20] - V{0.0555555555555556}*cell[6] + V{0.0277777777777778}*cell[7];
auto x287 = x285 + x286;
auto x288 = V{0.0416666666666667}*x29*x58*x68;
auto x289 = V{0.0138888888888889}*cell[11];
auto x290 = V{0.0138888888888889}*cell[12];
auto x291 = V{0.0138888888888889}*cell[24];
auto x292 = V{0.0138888888888889}*cell[25];
auto x293 = V{0.0138888888888889}*cell[0];
auto x294 = -V{1.15648231731787e-18}*cell[1];
auto x295 = -V{1.15648231731787e-18}*cell[2];
auto x296 = -V{1.15648231731787e-18}*cell[3];
auto x297 = -V{1.15648231731787e-18}*cell[14];
auto x298 = -V{1.15648231731787e-18}*cell[15];
auto x299 = -V{1.15648231731787e-18}*cell[16];
auto x300 = x289 + x290 + x291 + x292 + x293 + x294 + x295 + x296 + x297 + x298 + x299 - V{0.0555555555555556}*cell[21] + V{0.0277777777777778}*cell[22] - V{0.0555555555555556}*cell[8] + V{0.0277777777777778}*cell[9];
auto x301 = x288 + x300;
auto x302 = -V{0.152777777777778}*cell[10] - V{0.152777777777778}*cell[23];
auto x303 = V{0.00462962962962963}*cell[0] + V{0.00462962962962963}*cell[10] + V{0.00462962962962963}*cell[11] + V{0.00462962962962963}*cell[12] + V{0.00462962962962963}*cell[13] + V{0.00462962962962963}*cell[14] + V{0.00462962962962963}*cell[15] + V{0.00462962962962963}*cell[16] + V{0.00462962962962963}*cell[17] + V{0.00462962962962963}*cell[18] + V{0.00462962962962963}*cell[19] + V{0.00462962962962963}*cell[1] + V{0.00462962962962963}*cell[20] + V{0.00462962962962963}*cell[21] + V{0.00462962962962963}*cell[22] + V{0.00462962962962963}*cell[23] + V{0.00462962962962963}*cell[24] + V{0.00462962962962963}*cell[25] + V{0.00462962962962963}*cell[26] + V{0.00462962962962963}*cell[2] + V{0.00462962962962963}*cell[3] + V{0.00462962962962963}*cell[4] + V{0.00462962962962963}*cell[5] + V{0.00462962962962963}*cell[6] + V{0.00462962962962963}*cell[7] + V{0.00462962962962963}*cell[8] + V{0.00462962962962963}*cell[9] + V{0.00462962962962963};
auto x304 = V{3}*cell[10];
auto x305 = V{3}*cell[23];
auto x306 = x48 + x61;
auto x307 = x206 + x44;
auto x308 = x242 + x263 - x304 + x305 + x306 + x307 + x38;
auto x309 = V{0.0138888888888889}*cell[10];
auto x310 = V{0.0138888888888889}*cell[23];
auto x311 = x309 + x310 + V{0.0277777777777778}*cell[19] - V{0.0555555555555556}*cell[20] + V{0.0277777777777778}*cell[6] - V{0.0555555555555556}*cell[7];
auto x312 = -x285 + x311;
auto x313 = x293 + x294 + x295 + x296 + x297 + x298 + x299 + V{0.0277777777777778}*cell[21] - V{0.0555555555555556}*cell[22] + V{0.0277777777777778}*cell[8] - V{0.0555555555555556}*cell[9];
auto x314 = -x288 + x313;
auto x315 = x290 + x292 - V{0.152777777777778}*cell[11] - V{0.152777777777778}*cell[24];
auto x316 = V{3}*cell[24];
auto x317 = V{3}*cell[11];
auto x318 = x203 - x204 + x220;
auto x319 = x107 + x318;
auto x320 = x254 + x271 + x306 - x316 + x317 + x319 + x79;
auto x321 = V{0.0277777777777778}*cell[17] - V{0.0555555555555556}*cell[18] + V{0.0277777777777778}*cell[4] - V{0.0555555555555556}*cell[5];
auto x322 = x276 + x277 + x278 - x280 + x321;
auto x323 = x281 + x282 + x289 + x291 + x309 + x310 - V{0.152777777777778}*cell[12] - V{0.152777777777778}*cell[25];
auto x324 = V{3}*cell[25];
auto x325 = V{3}*cell[12];
auto x326 = x240 - x241;
auto x327 = x269 - x270;
auto x328 = x327 + x99;
auto x329 = x103 + x221 - x324 + x325 + x326 + x328 + x48;
auto x330 = -V{0.152777777777778}*cell[13] - V{0.152777777777778}*cell[26];
auto x331 = x110*x275;
auto x332 = x105*x275;
auto x333 = x275*x87;
auto x334 = V{0.0416666666666667}*x257;
auto x335 = x300 + x331 + x332 + x333 + x334;
auto x336 = V{0.0416666666666667}*x86;
auto x337 = x234*x336;
auto x338 = x311 - x337;
auto x339 = x164*x336;
auto x340 = x321 - x339;
auto x341 = -x117;
auto x342 = -x116 + x119;
auto x343 = -x125 + x127;
auto x344 = x29*(-x114 + x115 + x120 + x122 + x128 + x134 + x148 + x152 + x154 + x160 + x162 + x341 + x342 + x343);
auto x345 = -x344;
auto x346 = V{3}*cell[26];
auto x347 = V{3}*cell[13];
auto x348 = x221 + x254 + x264 - x346 + x347 + x39 + x85;
auto x349 = x120 - x146 + x147 + x341;
auto x350 = x29*(x118 + x123 + x132 + x135 + x139 + x153 - x158 + x159 + x343 + x349);
auto x351 = x29*(x126 + x129 + x136 - x144 + x145 + x161 + x342 + x349);
auto x352 = x110*x71;
auto x353 = x105*x71;
auto x354 = x71*x87;
auto x355 = x351 + x352 + x353 + x354 + V{-1};
auto x356 = x350 + x355;
auto x357 = -x352;
auto x358 = V{1} - x353;
auto x359 = x357 + x358;
auto x360 = x345 + x359;
auto x361 = -x351;
auto x362 = -x354;
auto x363 = x361 + x362;
auto x364 = -x350;
auto x365 = x362 + x364;
auto x366 = x194 - x195;
auto x367 = x102 + x244 + x268 + x318 + x366 + x66;
auto x368 = -x140;
auto x369 = x101 + cell[8];
auto x370 = x210 - x211;
auto x371 = x107 + x370;
auto x372 = x218 - x219;
auto x373 = x192 + x244 + x246 + x369 + x371 + x372;
auto x374 = x366 + x99;
auto x375 = x217 + x251 + x326 + x369 + x374;
auto x376 = x252 - x253;
auto x377 = x376 + x99;
auto x378 = x108 + x202 + x239 + x370 + x377;
auto x379 = x163 + x76;
auto x380 = x261 - x262;
auto x381 = x37 + x371 + x374 + x380 + x78 + x83;
auto x382 = x201 + x216 + x328 + x57 + x83 + x98;
auto x383 = x283 + x339;
auto x384 = x286 + x337;
auto x385 = x100 + x304 - x305 + x319 + x326 + x380 + x85;
auto x386 = x313 + x331 + x332 + x333 - x334;
auto x387 = x100 + x307 + x316 - x317 + x327 + x376 + x39 + x51;
auto x388 = x107 + x372 + x44;
auto x389 = x242 + x272 + x324 - x325 + x388 + x39 + x42 + x63;
auto x390 = x103 + x346 - x347 + x377 + x380 + x388 + x41;
cell[0] = x27*(-x31*x46 - x31*x59 - x31*x69 - V{0.444444444444444}*cell[0] + V{0.888888888888889}*cell[10] + V{0.888888888888889}*cell[11] + V{0.888888888888889}*cell[12] + V{0.888888888888889}*cell[13] + V{3.70074341541719e-17}*cell[14] + V{3.70074341541719e-17}*cell[15] + V{3.70074341541719e-17}*cell[16] + V{0.444444444444444}*cell[17] + V{0.444444444444444}*cell[18] + V{0.444444444444444}*cell[19] + V{3.70074341541719e-17}*cell[1] + V{0.444444444444444}*cell[20] + V{0.444444444444444}*cell[21] + V{0.444444444444444}*cell[22] + V{0.888888888888889}*cell[23] + V{0.888888888888889}*cell[24] + V{0.888888888888889}*cell[25] + V{0.888888888888889}*cell[26] + V{3.70074341541719e-17}*cell[2] + V{3.70074341541719e-17}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}*cell[9]) - x76*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{-0.296296296296296};
cell[1] = -x112 - x113*(x140 - x141*x46 + x75) + V{-0.0740740740740741};
cell[2] = -x113*(-x141*x59 + x155 + x156 + x74) - x143 + V{-0.0740740740740741};
cell[3] = -x113*(-x141*x69 + x156 + x163 + x73) - x157 + V{-0.0740740740740741};
cell[4] = -x189 - x190*(-x191*x207*x207 + x209) + V{-0.0185185185185185};
cell[5] = -x190*(-x191*x222*x222 + x224) - x233;
cell[6] = -x190*(x163 - x191*x248*x248 + x208) - x238 + V{-0.0185185185185185};
cell[7] = -x190*(-x191*x255*x255 + x208 + x249) - x256;
cell[8] = -x190*(-x191*x265*x265 + x267) - x260 + V{-0.0185185185185185};
cell[9] = -x190*(-x191*x273*x273 + x249 + x266) - x274;
cell[10] = x27*(x284 + x287 + x301 + x302) - x303*(x163 - x191*x308*x308 + x209) + V{-0.00462962962962963};
cell[11] = x27*(x284 + x312 + x314 + x315) - x303*(-x191*x320*x320 + x209 + x249) + V{-0.00462962962962963};
cell[12] = x27*(x287 + x314 + x322 + x323) - x303*(x163 - x191*x329*x329 + x224) + V{-0.00462962962962963};
cell[13] = x27*(x330 + x335 + x338 + x340) - x303*(-x191*x348*x348 + x345 + x356) + V{-0.00462962962962963};
cell[14] = -x112 + x113*(x141*x87 + x360) + V{-0.0740740740740741};
cell[15] = x113*(x110*x141 + x358 + x363) - x143 + V{-0.0740740740740741};
cell[16] = x113*(x105*x141 + x357 + x365 + V{1}) - x157 + V{-0.0740740740740741};
cell[17] = -x189 + x190*(x191*(x367*x367) + x360 + x363) + V{-0.0185185185185185};
cell[18] = -x190*(-x191*x373*x373 + x266 + x368) - x233;
cell[19] = x190*(x191*(x375*x375) + x360 + x365) - x238 + V{-0.0185185185185185};
cell[20] = -x190*(-x191*x378*x378 + x368 + x379) - x256;
cell[21] = x190*(x191*(x381*x381) + x359 + x363 + x364) - x260 + V{-0.0185185185185185};
cell[22] = -x190*(-x191*x382*x382 + x223 + x379) - x274;
cell[23] = x27*(x302 + x335 + x383 + x384) - x303*(-x191*x385*x385 + x344 + x356) + V{-0.00462962962962963};
cell[24] = x27*(x315 + x338 + x383 + x386) - x303*(-x191*x387*x387 + x344 + x355 + x364) + V{-0.00462962962962963};
cell[25] = x27*(x323 + x340 + x384 + x386) - x303*(-x191*x389*x389 + x344 + x350 + x352 + x353 + x354 + x361 + V{-1}) + V{-0.00462962962962963};
cell[26] = x27*(x301 + x312 + x322 + x330) - x303*(-x191*x390*x390 + x267 + x368) + V{-0.00462962962962963};
return { x28, V{1}*x70*(x105 + x110 + x87) };
}

};


template <typename... FIELDS>
struct PerPopulationBGK::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x8 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(1);
auto x7 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(0);
auto x9 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(2);
auto x10 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(3);
auto x11 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(4);
auto x5 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4];
auto x6 = x5 + V{1};
auto x12 = x5 + V{1};
auto x13 = V{1} / ((x12)*(x12));
auto x14 = V{1.5}*x13;
auto x15 = -cell[2] + cell[4];
auto x16 = x15*x15;
auto x17 = -cell[1] + cell[3];
auto x18 = x14*(x17*x17) + V{-1};
auto x19 = V{1} / (x12);
auto x20 = x19*(V{3}*cell[1] - V{3}*cell[3]);
auto x21 = V{3}*x13;
auto x22 = cell[1] - cell[3];
auto x23 = x22*x22;
auto x24 = cell[2] - cell[4];
auto x25 = x24*x24;
auto x26 = -x14*x25 + x21*x23 + V{1};
auto x27 = V{3}*cell[4];
auto x28 = V{3}*cell[2];
cell[0] = -V{0.333333333333333}*x7*(x6*(x14*x16 + x18) + V{1}) - (x7 + V{-1})*cell[0];
cell[1] = V{0.166666666666667}*x8*(x6*(x20 + x26) + V{-1}) - (x8 + V{-1})*cell[1];
cell[2] = -V{0.166666666666667}*x9*(x6*(-x16*x21 + x18 + x19*(x27 - x28)) + V{1}) - (x9 + V{-1})*cell[2];
cell[3] = V{0.166666666666667}*x10*(x6*(-x20 + x26) + V{-1}) - (x10 + V{-1})*cell[3];
cell[4] = -V{0.166666666666667}*x11*(x6*(x14*x23 + x19*(-x27 + x28) - x21*x25 + V{-1}) + V{1}) - (x11 + V{-1})*cell[4];
return { x12, V{1}*x13*(x23 + x25) };
}

};

template <typename... FIELDS>
struct PerPopulationBGK::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(1);
auto x15 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(4);
auto x14 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(3);
auto x17 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(6);
auto x18 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(7);
auto x19 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(8);
auto x13 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(2);
auto x11 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(0);
auto x16 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(5);
auto x9 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8];
auto x10 = x9 + V{1};
auto x20 = x9 + V{1};
auto x21 = V{1} / ((x20)*(x20));
auto x22 = V{1.5}*x21;
auto x23 = -cell[3] + cell[7];
auto x24 = -cell[4] + cell[8];
auto x25 = cell[1] - cell[5];
auto x26 = x23 + x24 + x25;
auto x27 = x26*x26;
auto x28 = x22*x27;
auto x29 = -cell[2] + cell[6];
auto x30 = x23 + x29 - cell[1] + cell[5];
auto x31 = x22*(x30*x30) + V{-1};
auto x32 = x28 + x31;
auto x33 = V{1} / (x20);
auto x34 = V{3}*cell[2];
auto x35 = V{3}*cell[3];
auto x36 = V{3}*cell[6];
auto x37 = V{3}*cell[7];
auto x38 = V{3}*cell[1];
auto x39 = V{3}*cell[5];
auto x40 = x38 - x39;
auto x41 = x33*(x34 + x35 - x36 - x37 + x40);
auto x42 = V{4.5}*x21;
auto x43 = cell[2] - cell[6];
auto x44 = x24 + x43 + V{2}*cell[1] - V{2}*cell[5];
auto x45 = x42*(x44*x44);
auto x46 = V{1} - x28;
auto x47 = -x35 + x37;
auto x48 = x33*(x40 + x47 - V{3}*cell[4] + V{3}*cell[8]);
auto x49 = x25 + x43 + cell[3] - cell[7];
auto x50 = x49*x49;
auto x51 = x22*x50;
auto x52 = x48 - x51;
auto x53 = x46 + x52;
auto x54 = V{3}*x21;
auto x55 = x46 + x50*x54;
auto x56 = V{2}*cell[3];
auto x57 = V{2}*cell[7];
auto x58 = x24 + x29 - x56 + x57;
auto x59 = x27*x54;
auto x60 = -x41;
auto x61 = x43 + x56 - x57 + cell[4] - cell[8];
cell[0] = -V{0.444444444444444}*x11*(x10*x32 + V{1}) - (x11 + V{-1})*cell[0];
cell[1] = V{0.0277777777777778}*x12*(x10*(x41 + x45 + x53) + V{-1}) - (x12 + V{-1})*cell[1];
cell[2] = V{0.111111111111111}*x13*(x10*(x41 + x55) + V{-1}) - (x13 + V{-1})*cell[2];
cell[3] = -V{0.0277777777777778}*x14*(x10*(x32 + x33*(-x34 + x36 - x38 + x39 + x47) - x42*x58*x58 + x48) + V{1}) - (x14 + V{-1})*cell[3];
cell[4] = -V{0.111111111111111}*x15*(x10*(x31 + x48 - x59) + V{1}) - (x15 + V{-1})*cell[4];
cell[5] = -V{0.0277777777777778}*x16*(x10*(x28 + x41 - x45 + x48 + x51 + V{-1}) + V{1}) - (x16 + V{-1})*cell[5];
cell[6] = V{0.111111111111111}*x17*(x10*(x55 + x60) + V{-1}) - (x17 + V{-1})*cell[6];
cell[7] = V{0.0277777777777778}*x18*(x10*(x42*(x61*x61) + x53 + x60) + V{-1}) - (x18 + V{-1})*cell[7];
cell[8] = V{0.111111111111111}*x19*(x10*(x52 + x59 + V{1}) + V{-1}) - (x19 + V{-1})*cell[8];
return { x20, V{1}*x21*(x27 + x50) };
}

};

template <typename... FIELDS>
struct PerPopulationBGK::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x15 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(5);
auto x14 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(4);
auto x10 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(0);
auto x12 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(2);
auto x13 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(3);
auto x11 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(1);
auto x16 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(6);
auto x7 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6];
auto x8 = x7 + V{1};
auto x9 = x7 + V{1};
auto x17 = V{1} / ((x9)*(x9));
auto x18 = V{2}*x17;
auto x19 = -cell[1] + cell[4];
auto x20 = x19*x19;
auto x21 = x18*x20;
auto x22 = -cell[2] + cell[5];
auto x23 = x22*x22;
auto x24 = x18*x23;
auto x25 = -cell[3] + cell[6];
auto x26 = x25*x25;
auto x27 = x18*x26;
auto x28 = x24 + x27 + V{-1};
auto x29 = V{1} / (x9);
auto x30 = V{4}*cell[4];
auto x31 = V{4}*cell[1];
auto x32 = V{6}*x17;
auto x33 = V{4}*cell[5];
auto x34 = V{4}*cell[2];
auto x35 = x21 + V{-1};
auto x36 = V{4}*cell[6];
auto x37 = V{4}*cell[3];
auto x38 = cell[2] - cell[5];
auto x39 = x38*x38;
auto x40 = x18*x39;
auto x41 = cell[1] - cell[4];
auto x42 = x41*x41;
auto x43 = cell[3] - cell[6];
auto x44 = x43*x43;
auto x45 = x18*x44 + V{-1};
auto x46 = x18*x42;
cell[0] = -V{0.25}*x10*(x8*(x21 + x28) + V{1}) - (x10 + V{-1})*cell[0];
cell[1] = -V{0.125}*x11*(x8*(-x20*x32 + x28 + x29*(x30 - x31)) + V{1}) - (x11 + V{-1})*cell[1];
cell[2] = -V{0.125}*x12*(x8*(-x23*x32 + x27 + x29*(x33 - x34) + x35) + V{1}) - (x12 + V{-1})*cell[2];
cell[3] = -V{0.125}*x13*(x8*(x24 - x26*x32 + x29*(x36 - x37) + x35) + V{1}) - (x13 + V{-1})*cell[3];
cell[4] = -V{0.125}*x14*(x8*(x29*(-x30 + x31) - x32*x42 + x40 + x45) + V{1}) - (x14 + V{-1})*cell[4];
cell[5] = -V{0.125}*x15*(x8*(x29*(-x33 + x34) - x32*x39 + x45 + x46) + V{1}) - (x15 + V{-1})*cell[5];
cell[6] = -V{0.125}*x16*(x8*(x29*(-x36 + x37) - x32*x44 + x40 + x46 + V{-1}) + V{1}) - (x16 + V{-1})*cell[6];
return { x9, V{1}*x17*(x39 + x42 + x44) };
}

};

template <typename... FIELDS>
struct PerPopulationBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x36 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(14);
auto x24 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(2);
auto x28 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(6);
auto x22 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(0);
auto x37 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(15);
auto x40 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(18);
auto x34 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(12);
auto x29 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(7);
auto x39 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(17);
auto x30 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(8);
auto x25 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(3);
auto x35 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(13);
auto x26 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(4);
auto x31 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(9);
auto x38 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(16);
auto x27 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(5);
auto x23 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(1);
auto x32 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(10);
auto x33 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(11);
auto x19 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x20 = x19 + V{1};
auto x21 = x19 + V{1};
auto x41 = V{1} / ((x21)*(x21));
auto x42 = V{1.5}*x41;
auto x43 = cell[13] - cell[4];
auto x44 = cell[15] - cell[6];
auto x45 = x43 + x44;
auto x46 = cell[14] - cell[5];
auto x47 = -cell[1];
auto x48 = cell[16] - cell[7];
auto x49 = x47 + x48 + cell[10];
auto x50 = x45 + x46 + x49;
auto x51 = x50*x50;
auto x52 = x42*x51;
auto x53 = cell[17] - cell[8];
auto x54 = x43 + x53;
auto x55 = cell[18] - cell[9];
auto x56 = -cell[2];
auto x57 = -cell[14] + cell[5];
auto x58 = x56 + x57 + cell[11];
auto x59 = x54 + x55 + x58;
auto x60 = x59*x59;
auto x61 = x42*x60;
auto x62 = x44 + x53;
auto x63 = -cell[16] + cell[7];
auto x64 = -cell[3];
auto x65 = -cell[18] + cell[9];
auto x66 = x64 + x65 + cell[12];
auto x67 = x62 + x63 + x66;
auto x68 = x67*x67;
auto x69 = x42*x68;
auto x70 = x61 + x69 + V{-1};
auto x71 = x52 + x70;
auto x72 = V{1} / (x21);
auto x73 = V{3}*cell[14];
auto x74 = V{3}*cell[16];
auto x75 = V{3}*cell[5];
auto x76 = V{3}*cell[7];
auto x77 = V{3}*cell[13] - V{3}*cell[4];
auto x78 = V{3}*cell[15] - V{3}*cell[6];
auto x79 = x72*(x73 + x74 - x75 - x76 + x77 + x78 + V{3}*cell[10] - V{3}*cell[1]);
auto x80 = V{3}*x41;
auto x81 = x51*x80;
auto x82 = V{3}*cell[18];
auto x83 = V{3}*cell[9];
auto x84 = V{3}*cell[17] - V{3}*cell[8];
auto x85 = x72*(-x73 + x75 + x77 + x82 - x83 + x84 + V{3}*cell[11] - V{3}*cell[2]);
auto x86 = x60*x80;
auto x87 = x52 + V{-1};
auto x88 = x72*(-x74 + x76 + x78 - x82 + x83 + x84 + V{3}*cell[12] - V{3}*cell[3]);
auto x89 = x68*x80;
auto x90 = V{4.5}*x41;
auto x91 = x55 + x56 + cell[11];
auto x92 = x49 + x62 + x91 + V{2}*cell[13] - V{2}*cell[4];
auto x93 = x90*(x92*x92);
auto x94 = x71 + x79;
auto x95 = -x85;
auto x96 = V{2}*cell[14];
auto x97 = V{2}*cell[5];
auto x98 = -cell[15] + cell[6];
auto x99 = x53 - cell[10] + cell[1];
auto x100 = x63 + x91 - x96 + x97 + x98 + x99;
auto x101 = x46 + x47 + cell[10];
auto x102 = x101 + x54 + x66 + V{2}*cell[15] - V{2}*cell[6];
auto x103 = x90*(x102*x102);
auto x104 = -x88;
auto x105 = V{2}*cell[16];
auto x106 = V{2}*cell[7];
auto x107 = -cell[13] + cell[4];
auto x108 = -x105 + x106 + x107 + x57 + x66 + x99;
auto x109 = x63 + x64 + cell[12];
auto x110 = x109 + x45 + x58 + V{2}*cell[17] - V{2}*cell[8];
auto x111 = x90*(x110*x110);
auto x112 = x71 + x85;
auto x113 = V{2}*cell[18];
auto x114 = V{2}*cell[9];
auto x115 = x44 - cell[11] + cell[2];
auto x116 = x107 + x109 - x113 + x114 + x115 + x46;
auto x117 = -x61;
auto x118 = V{1} - x69;
auto x119 = x117 + x118;
auto x120 = x119 + x79;
auto x121 = -x52;
auto x122 = x121 + x85;
auto x123 = x121 + x88;
auto x124 = -x79;
auto x125 = -cell[17] + cell[8];
auto x126 = x115 + x125 + x49 + x65 + x96 - x97;
auto x127 = x43 - cell[12] + cell[3];
auto x128 = x101 + x105 - x106 + x125 + x127 + x55;
auto x129 = x71 + x88;
auto x130 = x113 - x114 + x127 + x48 + x58 + x98;
cell[0] = -V{0.333333333333333}*x22*(x20*x71 + V{1}) - (x22 + V{-1})*cell[0];
cell[1] = -V{0.0555555555555556}*x23*(x20*(x70 + x79 - x81) + V{1}) - (x23 + V{-1})*cell[1];
cell[2] = -V{0.0555555555555556}*x24*(x20*(x69 + x85 - x86 + x87) + V{1}) - (x24 + V{-1})*cell[2];
cell[3] = -V{0.0555555555555556}*x25*(x20*(x61 + x87 + x88 - x89) + V{1}) - (x25 + V{-1})*cell[3];
cell[4] = -V{0.0277777777777778}*x26*(x20*(x85 - x93 + x94) + V{1}) - (x26 + V{-1})*cell[4];
cell[5] = -V{0.0277777777777778}*x27*(x20*(-x90*x100*x100 + x94 + x95) + V{1}) - (x27 + V{-1})*cell[5];
cell[6] = -V{0.0277777777777778}*x28*(x20*(-x103 + x88 + x94) + V{1}) - (x28 + V{-1})*cell[6];
cell[7] = -V{0.0277777777777778}*x29*(x20*(x104 - x90*x108*x108 + x94) + V{1}) - (x29 + V{-1})*cell[7];
cell[8] = -V{0.0277777777777778}*x30*(x20*(-x111 + x112 + x88) + V{1}) - (x30 + V{-1})*cell[8];
cell[9] = -V{0.0277777777777778}*x31*(x20*(x104 + x112 - x90*x116*x116) + V{1}) - (x31 + V{-1})*cell[9];
cell[10] = V{0.0555555555555556}*x32*(x20*(x120 + x81) + V{-1}) - (x32 + V{-1})*cell[10];
cell[11] = V{0.0555555555555556}*x33*(x20*(x118 + x122 + x86) + V{-1}) - (x33 + V{-1})*cell[11];
cell[12] = V{0.0555555555555556}*x34*(x20*(x117 + x123 + x89 + V{1}) + V{-1}) - (x34 + V{-1})*cell[12];
cell[13] = V{0.0277777777777778}*x35*(x20*(x120 + x122 + x93) + V{-1}) - (x35 + V{-1})*cell[13];
cell[14] = -V{0.0277777777777778}*x36*(x20*(x112 + x124 - x90*x126*x126) + V{1}) - (x36 + V{-1})*cell[14];
cell[15] = V{0.0277777777777778}*x37*(x20*(x103 + x120 + x123) + V{-1}) - (x37 + V{-1})*cell[15];
cell[16] = -V{0.0277777777777778}*x38*(x20*(x124 + x129 - x90*x128*x128) + V{1}) - (x38 + V{-1})*cell[16];
cell[17] = V{0.0277777777777778}*x39*(x20*(x111 + x119 + x122 + x88) + V{-1}) - (x39 + V{-1})*cell[17];
cell[18] = -V{0.0277777777777778}*x40*(x20*(x129 - x90*x130*x130 + x95) + V{1}) - (x40 + V{-1})*cell[18];
return { x21, V{1}*x41*(x51 + x60 + x68) };
}

};

template <typename... FIELDS>
struct PerPopulationBGK::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x36 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(6);
auto x49 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(19);
auto x43 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(13);
auto x47 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(17);
auto x54 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(24);
auto x41 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(11);
auto x48 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(18);
auto x51 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(21);
auto x37 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(7);
auto x40 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(10);
auto x46 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(16);
auto x34 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(4);
auto x44 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(14);
auto x39 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(9);
auto x30 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(0);
auto x52 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(22);
auto x35 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(5);
auto x55 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(25);
auto x42 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(12);
auto x53 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(23);
auto x31 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(1);
auto x38 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(8);
auto x50 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(20);
auto x32 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(2);
auto x45 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(15);
auto x56 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(26);
auto x33 = parameters.template get<olb::collision::PerPopulationBGK::OMEGA>(3);
auto x27 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9];
auto x28 = x27 + V{1};
auto x29 = x27 + V{1};
auto x57 = V{1} / ((x29)*(x29));
auto x58 = V{1.5}*x57;
auto x59 = -cell[4];
auto x60 = -cell[6];
auto x61 = x59 + x60 + cell[17] + cell[19];
auto x62 = -cell[7];
auto x63 = cell[18] - cell[5];
auto x64 = x62 + x63 + cell[20];
auto x65 = -cell[11] + cell[24];
auto x66 = -cell[10] + cell[23];
auto x67 = x65 + x66;
auto x68 = cell[14] - cell[1];
auto x69 = -cell[12] + cell[25];
auto x70 = -cell[13] + cell[26];
auto x71 = x69 + x70;
auto x72 = x61 + x64 + x67 + x68 + x71;
auto x73 = x72*x72;
auto x74 = x58*x73;
auto x75 = -cell[8];
auto x76 = cell[13] - cell[26];
auto x77 = x75 + x76 + cell[21];
auto x78 = -cell[9];
auto x79 = cell[12] - cell[25];
auto x80 = x78 + x79 + cell[22];
auto x81 = x59 + cell[17];
auto x82 = -cell[2];
auto x83 = -cell[18] + cell[5];
auto x84 = x82 + x83 + cell[15];
auto x85 = x81 + x84;
auto x86 = x67 + x77 + x80 + x85;
auto x87 = x86*x86;
auto x88 = x58*x87;
auto x89 = -cell[3];
auto x90 = x69 + x89 + cell[16];
auto x91 = cell[11] - cell[24];
auto x92 = -cell[22] + cell[9];
auto x93 = x91 + x92;
auto x94 = x60 + cell[19];
auto x95 = -cell[20] + cell[7];
auto x96 = x94 + x95;
auto x97 = x66 + x77 + x90 + x93 + x96;
auto x98 = x97*x97;
auto x99 = x58*x98;
auto x100 = x88 + x99 + V{-1};
auto x101 = x100 + x74;
auto x102 = V{1} / (x29);
auto x103 = V{3}*cell[14];
auto x104 = V{3}*cell[1];
auto x105 = V{3}*cell[17];
auto x106 = V{3}*cell[23];
auto x107 = V{3}*cell[24];
auto x108 = V{3}*cell[4];
auto x109 = V{3}*cell[10];
auto x110 = -x109;
auto x111 = V{3}*cell[11];
auto x112 = -x111;
auto x113 = x105 + x106 + x107 - x108 + x110 + x112;
auto x114 = V{3}*cell[19];
auto x115 = V{3}*cell[25];
auto x116 = V{3}*cell[6];
auto x117 = V{3}*cell[12];
auto x118 = -x117;
auto x119 = x114 + x115 - x116 + x118;
auto x120 = V{3}*cell[18];
auto x121 = V{3}*cell[26];
auto x122 = V{3}*cell[5];
auto x123 = V{3}*cell[13];
auto x124 = -x123;
auto x125 = x120 + x121 - x122 + x124;
auto x126 = V{3}*cell[20];
auto x127 = V{3}*cell[7];
auto x128 = x126 - x127;
auto x129 = x102*(x103 - x104 + x113 + x119 + x125 + x128);
auto x130 = V{3}*x57;
auto x131 = V{3}*cell[15];
auto x132 = V{3}*cell[2];
auto x133 = V{3}*cell[21];
auto x134 = V{3}*cell[8];
auto x135 = -x121;
auto x136 = x123 + x133 - x134 + x135;
auto x137 = V{3}*cell[22];
auto x138 = V{3}*cell[9];
auto x139 = -x115;
auto x140 = x117 + x137 - x138 + x139;
auto x141 = -x120 + x122;
auto x142 = x102*(x113 + x131 - x132 + x136 + x140 + x141);
auto x143 = x74 + V{-1};
auto x144 = V{3}*cell[16];
auto x145 = V{3}*cell[3];
auto x146 = -x107;
auto x147 = x111 - x137 + x138 + x146;
auto x148 = -x126 + x127;
auto x149 = x102*(x106 + x110 + x119 + x136 + x144 - x145 + x147 + x148);
auto x150 = V{4.5}*x57;
auto x151 = x62 + cell[20];
auto x152 = x151 + x68 + x94;
auto x153 = x75 + cell[21];
auto x154 = V{2}*cell[10];
auto x155 = V{2}*cell[23];
auto x156 = -x154 + x155;
auto x157 = x153 + x156;
auto x158 = x78 + cell[22];
auto x159 = V{2}*cell[11];
auto x160 = V{2}*cell[24];
auto x161 = -x159 + x160;
auto x162 = x158 + x161;
auto x163 = V{2}*cell[4];
auto x164 = V{2}*cell[17];
auto x165 = x82 + cell[15];
auto x166 = -x163 + x164 + x165;
auto x167 = x152 + x157 + x162 + x166;
auto x168 = x101 + x129;
auto x169 = x142 + x168;
auto x170 = V{2}*cell[26];
auto x171 = -x170;
auto x172 = V{2}*cell[13];
auto x173 = x171 + x172 + x95;
auto x174 = V{2}*cell[25];
auto x175 = -x174;
auto x176 = V{2}*cell[12];
auto x177 = -cell[19] + cell[6];
auto x178 = x175 + x176 + x177;
auto x179 = -cell[14] + cell[1];
auto x180 = x153 + x179;
auto x181 = V{2}*cell[18];
auto x182 = V{2}*cell[5];
auto x183 = x165 - x181 + x182;
auto x184 = x158 + x173 + x178 + x180 + x183;
auto x185 = -x142;
auto x186 = x168 + x185;
auto x187 = x89 + cell[16];
auto x188 = x187 + x92;
auto x189 = x174 - x176;
auto x190 = x63 + x68 + x81;
auto x191 = V{2}*cell[6];
auto x192 = V{2}*cell[19];
auto x193 = -x191 + x192;
auto x194 = x157 + x188 + x189 + x190 + x193;
auto x195 = -x149;
auto x196 = x159 - x160;
auto x197 = V{2}*cell[20];
auto x198 = V{2}*cell[7];
auto x199 = -x197 + x198;
auto x200 = -cell[17] + cell[4];
auto x201 = x200 + x83;
auto x202 = x171 + x172 + x180 + x188 + x196 + x199 + x201;
auto x203 = V{2}*cell[8];
auto x204 = V{2}*cell[21];
auto x205 = -x203 + x204;
auto x206 = x187 + x205;
auto x207 = x156 + x173 + x206 + x61 + x84;
auto x208 = x101 + x142;
auto x209 = x149 + x208;
auto x210 = -cell[15] + cell[2];
auto x211 = x196 + x210;
auto x212 = x200 + x63;
auto x213 = V{2}*cell[22];
auto x214 = V{2}*cell[9];
auto x215 = -x213 + x214;
auto x216 = x187 + x215;
auto x217 = x189 + x211 + x212 + x216 + x96;
auto x218 = V{3}*cell[10];
auto x219 = V{3}*cell[23];
auto x220 = x76 + x90;
auto x221 = x166 + x68;
auto x222 = x193 + x205 - x218 + x219 + x220 + x221 + x65;
auto x223 = V{3}*cell[24];
auto x224 = V{3}*cell[11];
auto x225 = cell[10] - cell[23];
auto x226 = x163 - x164;
auto x227 = x179 + x199;
auto x228 = x210 + x215 + x220 - x223 + x224 + x225 + x226 + x227;
auto x229 = V{3}*cell[25];
auto x230 = V{3}*cell[12];
auto x231 = x179 + x191 - x192;
auto x232 = -cell[16];
auto x233 = x232 + cell[3];
auto x234 = x213 - x214 + x233;
auto x235 = x225 + x65;
auto x236 = x183 - x229 + x230 + x231 + x234 + x235 + x76;
auto x237 = -x106;
auto x238 = -x105 + x108;
auto x239 = -x114 + x116;
auto x240 = x102*(-x103 + x104 + x109 + x111 + x117 + x123 + x135 + x139 + x141 + x146 + x148 + x237 + x238 + x239);
auto x241 = V{3}*cell[26];
auto x242 = V{3}*cell[13];
auto x243 = x79 + x91;
auto x244 = x183 + x206 + x227 - x241 + x242 + x243 + x66;
auto x245 = x109 - x133 + x134 + x237;
auto x246 = x102*(x107 + x112 + x121 + x124 + x128 + x140 - x144 + x145 + x239 + x245);
auto x247 = -cell[21] + cell[8];
auto x248 = x210 + x247;
auto x249 = x212 + x225 + x248 + x71 + x93;
auto x250 = x249*x249;
auto x251 = x250*x58;
auto x252 = x177 + x225;
auto x253 = x232 + x247 + cell[3];
auto x254 = x151 + x252 + x253 + x65 + x70 + x80;
auto x255 = x254*x254;
auto x256 = x255*x58 + V{-1};
auto x257 = x251 + x256;
auto x258 = x102*(x115 + x118 + x125 - x131 + x132 + x147 + x238 + x245);
auto x259 = x179 + x95;
auto x260 = x201 + x243 + x252 + x259 + x76;
auto x261 = x260*x260;
auto x262 = x261*x58;
auto x263 = x258 + x262;
auto x264 = x246 + x257 + x263;
auto x265 = x240 + x257;
auto x266 = x246 + x262;
auto x267 = x154 - x155;
auto x268 = x177 + x267;
auto x269 = x211 + x226 + x247 + x259 + x268 + x92;
auto x270 = x263 + x265;
auto x271 = -x129;
auto x272 = x170 - x172;
auto x273 = x181 - x182;
auto x274 = x152 + x189 + x248 + x272 + x273 + x92;
auto x275 = x158 + x175 + x176 + x201 + x231 + x253 + x267;
auto x276 = x265 + x266;
auto x277 = x197 - x198;
auto x278 = x162 + x190 + x253 + x272 + x277;
auto x279 = x101 + x149;
auto x280 = x203 - x204 + x210 + x233;
auto x281 = x200 + x268 + x272 + x280 + x64;
auto x282 = x151 + x161 + x178 + x234 + x85;
auto x283 = x218 - x219 + x226 + x231 + x243 + x280 + x70;
auto x284 = x66 + x70;
auto x285 = x221 + x223 - x224 + x234 + x277 + x284 + x79;
auto x286 = x273 + x68;
auto x287 = x193 + x210 + x216 + x229 - x230 + x284 + x286 + x91;
auto x288 = x235 + x241 - x242 + x277 + x280 + x286 + x69;
cell[0] = -V{0.296296296296296}*x30*(x101*x28 + V{1}) - (x30 + V{-1})*cell[0];
cell[1] = -V{0.0740740740740741}*x31*(x28*(x100 + x129 - x130*x73) + V{1}) - (x31 + V{-1})*cell[1];
cell[2] = -V{0.0740740740740741}*x32*(x28*(-x130*x87 + x142 + x143 + x99) + V{1}) - (x32 + V{-1})*cell[2];
cell[3] = -V{0.0740740740740741}*x33*(x28*(-x130*x98 + x143 + x149 + x88) + V{1}) - (x33 + V{-1})*cell[3];
cell[4] = -V{0.0185185185185185}*x34*(x28*(-x150*x167*x167 + x169) + V{1}) - (x34 + V{-1})*cell[4];
cell[5] = -V{0.0185185185185185}*x35*(x28*(-x150*x184*x184 + x186) + V{1}) - (x35 + V{-1})*cell[5];
cell[6] = -V{0.0185185185185185}*x36*(x28*(x149 - x150*x194*x194 + x168) + V{1}) - (x36 + V{-1})*cell[6];
cell[7] = -V{0.0185185185185185}*x37*(x28*(-x150*x202*x202 + x168 + x195) + V{1}) - (x37 + V{-1})*cell[7];
cell[8] = -V{0.0185185185185185}*x38*(x28*(-x150*x207*x207 + x209) + V{1}) - (x38 + V{-1})*cell[8];
cell[9] = -V{0.0185185185185185}*x39*(x28*(-x150*x217*x217 + x195 + x208) + V{1}) - (x39 + V{-1})*cell[9];
cell[10] = -V{0.00462962962962963}*x40*(x28*(x149 - x150*x222*x222 + x169) + V{1}) - (x40 + V{-1})*cell[10];
cell[11] = -V{0.00462962962962963}*x41*(x28*(-x150*x228*x228 + x169 + x195) + V{1}) - (x41 + V{-1})*cell[11];
cell[12] = -V{0.00462962962962963}*x42*(x28*(x149 - x150*x236*x236 + x186) + V{1}) - (x42 + V{-1})*cell[12];
cell[13] = -V{0.00462962962962963}*x43*(x28*(-x150*x244*x244 - x240 + x264) + V{1}) - (x43 + V{-1})*cell[13];
cell[14] = -V{0.0740740740740741}*x44*(x28*(-x130*x261 + x265) + V{1}) - (x44 + V{-1})*cell[14];
cell[15] = -V{0.0740740740740741}*x45*(x28*(-x130*x250 + x256 + x263) + V{1}) - (x45 + V{-1})*cell[15];
cell[16] = -V{0.0740740740740741}*x46*(x28*(-x130*x255 + x251 + x266 + V{-1}) + V{1}) - (x46 + V{-1})*cell[16];
cell[17] = -V{0.0185185185185185}*x47*(x28*(-x150*x269*x269 + x270) + V{1}) - (x47 + V{-1})*cell[17];
cell[18] = -V{0.0185185185185185}*x48*(x28*(-x150*x274*x274 + x208 + x271) + V{1}) - (x48 + V{-1})*cell[18];
cell[19] = -V{0.0185185185185185}*x49*(x28*(-x150*x275*x275 + x276) + V{1}) - (x49 + V{-1})*cell[19];
cell[20] = -V{0.0185185185185185}*x50*(x28*(-x150*x278*x278 + x271 + x279) + V{1}) - (x50 + V{-1})*cell[20];
cell[21] = -V{0.0185185185185185}*x51*(x28*(-x150*x281*x281 + x264) + V{1}) - (x51 + V{-1})*cell[21];
cell[22] = -V{0.0185185185185185}*x52*(x28*(-x150*x282*x282 + x185 + x279) + V{1}) - (x52 + V{-1})*cell[22];
cell[23] = -V{0.00462962962962963}*x53*(x28*(-x150*x283*x283 + x246 + x270) + V{1}) - (x53 + V{-1})*cell[23];
cell[24] = -V{0.00462962962962963}*x54*(x28*(-x150*x285*x285 - x246 + x270) + V{1}) - (x54 + V{-1})*cell[24];
cell[25] = -V{0.00462962962962963}*x55*(x28*(-x150*x287*x287 - x258 + x276) + V{1}) - (x55 + V{-1})*cell[25];
cell[26] = -V{0.00462962962962963}*x56*(x28*(-x150*x288*x288 + x209 + x271) + V{1}) - (x56 + V{-1})*cell[26];
return { x29, V{1}*x57*(x250 + x255 + x261) };
}

};


template <typename... FIELDS>
struct TRT::type<descriptors::D2Q5<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x8 = parameters.template get<olb::collision::TRT::MAGIC>();
auto x5 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + V{1};
auto x6 = V{1} / ((x5)*(x5));
auto x9 = V{1.5}*x6;
auto x10 = -cell[2] + cell[4];
auto x11 = x10*x10;
auto x12 = x11*x9;
auto x13 = -cell[1] + cell[3];
auto x14 = x13*x13;
auto x15 = x14*x9;
auto x16 = x15 + V{-1};
auto x17 = V{1} / (-x8/(V{0.5} - V{1}/x7) + V{0.5});
auto x18 = V{0.0833333333333333}*cell[0] + V{0.0833333333333333}*cell[1] + V{0.0833333333333333}*cell[2] + V{0.0833333333333333}*cell[3] + V{0.0833333333333333}*cell[4] + V{0.0833333333333333};
auto x19 = V{1} / (x5);
auto x20 = V{3}*cell[3];
auto x21 = V{3}*cell[1];
auto x22 = x19*(x20 - x21);
auto x23 = V{3}*x6;
auto x24 = -x12 + x14*x23 + V{1};
auto x25 = V{0.5}*cell[3];
auto x26 = V{0.5}*cell[1];
auto x27 = x25 - x26;
auto x28 = x19*(-x20 + x21);
auto x29 = cell[1] - cell[3];
auto x30 = x29*x29;
auto x31 = cell[2] - cell[4];
auto x32 = x31*x31;
auto x33 = x23*x30 - x32*x9 + V{1};
auto x34 = x18*(x28 + x33);
auto x35 = -x18*(-x28 + x33);
auto x36 = -x7*(x25 + x26 - x34 + x35 + V{0.166666666666667});
auto x37 = V{3}*cell[4];
auto x38 = V{3}*cell[2];
auto x39 = x19*(x37 - x38);
auto x40 = x11*x23;
auto x41 = -x15 + x40 + V{1};
auto x42 = V{0.5}*cell[4];
auto x43 = V{0.5}*cell[2];
auto x44 = x42 - x43;
auto x45 = x18*(x16 + x39 - x40);
auto x46 = -x18*(-x19*(-x37 + x38) + x23*x32 - x30*x9 + V{1});
auto x47 = -x7*(x42 + x43 + x45 + x46 + V{0.166666666666667});
cell[0] = -x7*((x12 + x16)*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}) + V{1}*cell[0] + V{0.333333333333333}) + cell[0];
cell[1] = x17*(x18*(-x22 + x24) - x18*(x22 + x24) + x27) + x36 + cell[1];
cell[2] = x17*(x18*(-x39 + x41) - x18*(x39 + x41) + x44) + x47 + cell[2];
cell[3] = -x17*(x27 + x34 + x35) + x36 + cell[3];
cell[4] = -x17*(x44 - x45 + x46) + x47 + cell[4];
return { x5, V{1}*x6*(x30 + x32) };
}

};

template <typename... FIELDS>
struct TRT::type<descriptors::D2Q9<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::collision::TRT::MAGIC>();
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + V{1};
auto x10 = V{1} / ((x9)*(x9));
auto x13 = V{1.5}*x10;
auto x14 = -cell[3] + cell[7];
auto x15 = -cell[4] + cell[8];
auto x16 = cell[1] - cell[5];
auto x17 = x14 + x15 + x16;
auto x18 = x17*x17;
auto x19 = x13*x18;
auto x20 = -cell[2] + cell[6];
auto x21 = x14 + x20 - cell[1] + cell[5];
auto x22 = x21*x21;
auto x23 = x13*x22;
auto x24 = x23 + V{-1};
auto x25 = x19 + x24;
auto x26 = V{1} / (-x12/(V{0.5} - V{1}/x11) + V{0.5});
auto x27 = V{0.0138888888888889}*cell[0] + V{0.0138888888888889}*cell[1] + V{0.0138888888888889}*cell[2] + V{0.0138888888888889}*cell[3] + V{0.0138888888888889}*cell[4] + V{0.0138888888888889}*cell[5] + V{0.0138888888888889}*cell[6] + V{0.0138888888888889}*cell[7] + V{0.0138888888888889}*cell[8] + V{0.0138888888888889};
auto x28 = V{1} / (x9);
auto x29 = V{3}*cell[5];
auto x30 = V{3}*cell[6];
auto x31 = V{3}*cell[1];
auto x32 = V{3}*cell[2];
auto x33 = V{3}*cell[7];
auto x34 = V{3}*cell[3];
auto x35 = x33 - x34;
auto x36 = x28*(x29 + x30 - x31 - x32 + x35);
auto x37 = -x36;
auto x38 = V{4.5}*x10;
auto x39 = V{2}*cell[5];
auto x40 = V{2}*cell[1];
auto x41 = cell[2] - cell[6];
auto x42 = x15 - x39 + x40 + x41;
auto x43 = x38*(x42*x42);
auto x44 = -x23;
auto x45 = -x29 + x31;
auto x46 = x28*(x35 + x45 - V{3}*cell[4] + V{3}*cell[8]);
auto x47 = V{1} - x19;
auto x48 = x46 + x47;
auto x49 = x44 + x48;
auto x50 = x20 + x39 - x40 + cell[4] - cell[8];
auto x51 = x38*(x50*x50);
auto x52 = -x46;
auto x53 = x44 + x52;
auto x54 = x47 + x53;
auto x55 = V{0.5}*cell[5];
auto x56 = V{0.5}*cell[1];
auto x57 = x55 - x56;
auto x58 = x28*(-x30 + x32 - x33 + x34 + x45);
auto x59 = x16 + x41 + cell[3] - cell[7];
auto x60 = x59*x59;
auto x61 = -x13*x60;
auto x62 = x48 + x61;
auto x63 = x27*(x51 + x58 + x62);
auto x64 = -x58;
auto x65 = -x27*(x43 + x47 + x52 + x61 + x64);
auto x66 = -x11*(x55 + x56 - x63 + x65 + V{0.0277777777777778});
auto x67 = V{0.0555555555555556}*cell[0] + V{0.0555555555555556}*cell[1] + V{0.0555555555555556}*cell[2] + V{0.0555555555555556}*cell[3] + V{0.0555555555555556}*cell[4] + V{0.0555555555555556}*cell[5] + V{0.0555555555555556}*cell[6] + V{0.0555555555555556}*cell[7] + V{0.0555555555555556}*cell[8] + V{0.0555555555555556};
auto x68 = V{3}*x10;
auto x69 = x22*x68 + x47;
auto x70 = V{0.5}*cell[6];
auto x71 = V{0.5}*cell[2];
auto x72 = x70 - x71;
auto x73 = x47 + x60*x68;
auto x74 = x67*(x58 + x73);
auto x75 = -x67*(x64 + x73);
auto x76 = -x11*(x70 + x71 - x74 + x75 + V{0.111111111111111});
auto x77 = x15 + x20 - V{2}*cell[3] + V{2}*cell[7];
auto x78 = x38*(x77*x77);
auto x79 = V{0.5}*cell[7];
auto x80 = V{0.5}*cell[3];
auto x81 = x79 - x80;
auto x82 = x27*(x25 + x36 + x46 - x78);
auto x83 = -x27*(x62 + x64 + x78);
auto x84 = -x11*(x79 + x80 + x82 + x83 + V{0.0277777777777778});
auto x85 = x18*x68;
auto x86 = x85 + V{1};
auto x87 = x46 + x86;
auto x88 = V{0.5}*cell[8];
auto x89 = V{0.5}*cell[4];
auto x90 = x88 - x89;
auto x91 = x67*(x24 + x46 - x85);
auto x92 = -x67*(x61 + x87);
auto x93 = -x11*(x88 + x89 + x91 + x92 + V{0.111111111111111});
cell[0] = -x11*(x25*(V{0.444444444444444}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8] + V{0.444444444444444}) + V{1}*cell[0] + V{0.444444444444444}) + cell[0];
cell[1] = x26*(-x27*(x36 + x51 + x54) + x27*(x37 + x43 + x49) + x57) + x66 + cell[1];
cell[2] = x26*(-x67*(x36 + x69) + x67*(x37 + x69) + x72) + x76 + cell[2];
cell[3] = x26*(-x27*(x36 + x49 + x78) + x27*(x37 + x54 + x78) + x81) + x84 + cell[3];
cell[4] = x26*(-x67*(x44 + x87) + x67*(x53 + x86) + x90) + x93 + cell[4];
cell[5] = -x26*(x57 + x63 + x65) + x66 + cell[5];
cell[6] = -x26*(x72 + x74 + x75) + x76 + cell[6];
cell[7] = -x26*(x81 - x82 + x83) + x84 + cell[7];
cell[8] = -x26*(x90 - x91 + x92) + x93 + cell[8];
return { x9, V{1}*x10*(x18 + x60) };
}

};

template <typename... FIELDS>
struct TRT::type<descriptors::D3Q7<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x11 = parameters.template get<olb::collision::TRT::MAGIC>();
auto x7 = cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1};
auto x8 = V{1} / ((x7)*(x7));
auto x9 = V{2}*x8;
auto x12 = -cell[1] + cell[4];
auto x13 = x12*x12;
auto x14 = x13*x9;
auto x15 = -cell[2] + cell[5];
auto x16 = x15*x15;
auto x17 = x16*x9;
auto x18 = -cell[3] + cell[6];
auto x19 = x18*x18;
auto x20 = x19*x9;
auto x21 = x17 + x20 + V{-1};
auto x22 = V{1} / (-x11/(V{0.5} - V{1}/x10) + V{0.5});
auto x23 = V{0.0625}*cell[0] + V{0.0625}*cell[1] + V{0.0625}*cell[2] + V{0.0625}*cell[3] + V{0.0625}*cell[4] + V{0.0625}*cell[5] + V{0.0625}*cell[6] + V{0.0625};
auto x24 = V{1} / (x7);
auto x25 = V{4}*cell[4];
auto x26 = V{4}*cell[1];
auto x27 = x24*(x25 - x26);
auto x28 = V{6}*x8;
auto x29 = x13*x28;
auto x30 = -x17;
auto x31 = V{1} - x20;
auto x32 = x29 + x30 + x31;
auto x33 = V{0.5}*cell[4];
auto x34 = V{0.5}*cell[1];
auto x35 = x33 - x34;
auto x36 = x23*(x21 + x27 - x29);
auto x37 = cell[1] - cell[4];
auto x38 = x37*x37;
auto x39 = cell[2] - cell[5];
auto x40 = x39*x39;
auto x41 = -x40*x9;
auto x42 = cell[3] - cell[6];
auto x43 = x42*x42;
auto x44 = -x43*x9 + V{1};
auto x45 = -x23*(-x24*(-x25 + x26) + x28*x38 + x41 + x44);
auto x46 = -x10*(x33 + x34 + x36 + x45 + V{0.125});
auto x47 = V{4}*cell[5];
auto x48 = V{4}*cell[2];
auto x49 = x24*(x47 - x48);
auto x50 = x16*x28;
auto x51 = -x14;
auto x52 = x31 + x50 + x51;
auto x53 = V{0.5}*cell[5];
auto x54 = V{0.5}*cell[2];
auto x55 = x53 - x54;
auto x56 = x14 + V{-1};
auto x57 = x23*(x20 + x49 - x50 + x56);
auto x58 = -x38*x9;
auto x59 = -x23*(-x24*(-x47 + x48) + x28*x40 + x44 + x58);
auto x60 = -x10*(x53 + x54 + x57 + x59 + V{0.125});
auto x61 = V{4}*cell[6];
auto x62 = V{4}*cell[3];
auto x63 = x24*(x61 - x62);
auto x64 = x19*x28;
auto x65 = x30 + x51 + x64 + V{1};
auto x66 = V{0.5}*cell[6];
auto x67 = V{0.5}*cell[3];
auto x68 = x66 - x67;
auto x69 = x23*(x17 + x56 + x63 - x64);
auto x70 = -x23*(-x24*(-x61 + x62) + x28*x43 + x41 + x58 + V{1});
auto x71 = -x10*(x66 + x67 + x69 + x70 + V{0.125});
cell[0] = -x10*((x14 + x21)*(V{0.25}*cell[0] + V{0.25}*cell[1] + V{0.25}*cell[2] + V{0.25}*cell[3] + V{0.25}*cell[4] + V{0.25}*cell[5] + V{0.25}*cell[6] + V{0.25}) + V{1}*cell[0] + V{0.25}) + cell[0];
cell[1] = x22*(x23*(-x27 + x32) - x23*(x27 + x32) + x35) + x46 + cell[1];
cell[2] = x22*(x23*(-x49 + x52) - x23*(x49 + x52) + x55) + x60 + cell[2];
cell[3] = x22*(x23*(-x63 + x65) - x23*(x63 + x65) + x68) + x71 + cell[3];
cell[4] = -x22*(x35 - x36 + x45) + x46 + cell[4];
cell[5] = -x22*(x55 - x57 + x59) + x60 + cell[5];
cell[6] = -x22*(x68 - x69 + x70) + x71 + cell[6];
return { x7, V{1}*x8*(x38 + x40 + x43) };
}

};

template <typename... FIELDS>
struct TRT::type<descriptors::D3Q19<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x23 = parameters.template get<olb::collision::TRT::MAGIC>();
auto x19 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x20 = V{1} / ((x19)*(x19));
auto x21 = V{1.5}*x20;
auto x24 = cell[13] - cell[4];
auto x25 = cell[15] - cell[6];
auto x26 = x24 + x25;
auto x27 = cell[14] - cell[5];
auto x28 = -cell[1];
auto x29 = cell[16] - cell[7];
auto x30 = x28 + x29 + cell[10];
auto x31 = x26 + x27 + x30;
auto x32 = x31*x31;
auto x33 = x21*x32;
auto x34 = cell[17] - cell[8];
auto x35 = x24 + x34;
auto x36 = cell[18] - cell[9];
auto x37 = -cell[2];
auto x38 = -cell[14] + cell[5];
auto x39 = x37 + x38 + cell[11];
auto x40 = x35 + x36 + x39;
auto x41 = x40*x40;
auto x42 = x21*x41;
auto x43 = x25 + x34;
auto x44 = -cell[16] + cell[7];
auto x45 = -cell[3];
auto x46 = -cell[18] + cell[9];
auto x47 = x45 + x46 + cell[12];
auto x48 = x43 + x44 + x47;
auto x49 = x48*x48;
auto x50 = x21*x49;
auto x51 = x42 + x50 + V{-1};
auto x52 = x33 + x51;
auto x53 = V{1} / (-x23/(V{0.5} - V{1}/x22) + V{0.5});
auto x54 = V{0.0277777777777778}*cell[0] + V{0.0277777777777778}*cell[10] + V{0.0277777777777778}*cell[11] + V{0.0277777777777778}*cell[12] + V{0.0277777777777778}*cell[13] + V{0.0277777777777778}*cell[14] + V{0.0277777777777778}*cell[15] + V{0.0277777777777778}*cell[16] + V{0.0277777777777778}*cell[17] + V{0.0277777777777778}*cell[18] + V{0.0277777777777778}*cell[1] + V{0.0277777777777778}*cell[2] + V{0.0277777777777778}*cell[3] + V{0.0277777777777778}*cell[4] + V{0.0277777777777778}*cell[5] + V{0.0277777777777778}*cell[6] + V{0.0277777777777778}*cell[7] + V{0.0277777777777778}*cell[8] + V{0.0277777777777778}*cell[9] + V{0.0277777777777778};
auto x55 = V{1} / (x19);
auto x56 = V{3}*cell[14];
auto x57 = V{3}*cell[16];
auto x58 = V{3}*cell[5];
auto x59 = V{3}*cell[7];
auto x60 = V{3}*cell[13] - V{3}*cell[4];
auto x61 = V{3}*cell[15] - V{3}*cell[6];
auto x62 = x55*(x56 + x57 - x58 - x59 + x60 + x61 + V{3}*cell[10] - V{3}*cell[1]);
auto x63 = -x62;
auto x64 = V{3}*x20;
auto x65 = x32*x64;
auto x66 = -x42;
auto x67 = V{1} - x50;
auto x68 = x66 + x67;
auto x69 = x65 + x68;
auto x70 = V{0.5}*cell[1];
auto x71 = -x54*(x62 + x69) + V{0.5}*cell[10];
auto x72 = -x70 + x71;
auto x73 = x54*(x51 + x62 - x65);
auto x74 = -x22*(x70 + x71 + x73 + V{0.0555555555555556});
auto x75 = V{3}*cell[18];
auto x76 = V{3}*cell[9];
auto x77 = V{3}*cell[17] - V{3}*cell[8];
auto x78 = x55*(-x56 + x58 + x60 + x75 - x76 + x77 + V{3}*cell[11] - V{3}*cell[2]);
auto x79 = -x78;
auto x80 = -x33;
auto x81 = x79 + x80;
auto x82 = x41*x64;
auto x83 = x67 + x82;
auto x84 = V{0.5}*cell[2];
auto x85 = x78 + x80;
auto x86 = -x54*(x83 + x85) + V{0.5}*cell[11];
auto x87 = -x84 + x86;
auto x88 = x33 + V{-1};
auto x89 = x54*(x50 + x78 - x82 + x88);
auto x90 = -x22*(x84 + x86 + x89 + V{0.0555555555555556});
auto x91 = x55*(-x57 + x59 + x61 - x75 + x76 + x77 + V{3}*cell[12] - V{3}*cell[3]);
auto x92 = -x91;
auto x93 = x80 + x92;
auto x94 = x49*x64;
auto x95 = x66 + x94 + V{1};
auto x96 = V{0.5}*cell[3];
auto x97 = x80 + x91;
auto x98 = -x54*(x95 + x97) + V{0.5}*cell[12];
auto x99 = -x96 + x98;
auto x100 = x54*(x42 + x88 + x91 - x94);
auto x101 = -x22*(x100 + x96 + x98 + V{0.0555555555555556});
auto x102 = V{0.0138888888888889}*cell[0] + V{0.0138888888888889}*cell[10] + V{0.0138888888888889}*cell[11] + V{0.0138888888888889}*cell[12] + V{0.0138888888888889}*cell[13] + V{0.0138888888888889}*cell[14] + V{0.0138888888888889}*cell[15] + V{0.0138888888888889}*cell[16] + V{0.0138888888888889}*cell[17] + V{0.0138888888888889}*cell[18] + V{0.0138888888888889}*cell[1] + V{0.0138888888888889}*cell[2] + V{0.0138888888888889}*cell[3] + V{0.0138888888888889}*cell[4] + V{0.0138888888888889}*cell[5] + V{0.0138888888888889}*cell[6] + V{0.0138888888888889}*cell[7] + V{0.0138888888888889}*cell[8] + V{0.0138888888888889}*cell[9] + V{0.0138888888888889};
auto x103 = V{4.5}*x20;
auto x104 = x36 + x37 + cell[11];
auto x105 = x104 + x30 + x43 + V{2}*cell[13] - V{2}*cell[4];
auto x106 = x103*(x105*x105);
auto x107 = x106 + x68;
auto x108 = V{0.5}*cell[4];
auto x109 = -x102*(x107 + x62 + x85) + V{0.5}*cell[13];
auto x110 = -x108 + x109;
auto x111 = x52 + x78;
auto x112 = x102*(-x106 + x111 + x62);
auto x113 = -x22*(x108 + x109 + x112 + V{0.0277777777777778});
auto x114 = V{2}*cell[14];
auto x115 = V{2}*cell[5];
auto x116 = -cell[15] + cell[6];
auto x117 = x34 - cell[10] + cell[1];
auto x118 = x104 - x114 + x115 + x116 + x117 + x44;
auto x119 = x103*(x118*x118);
auto x120 = x63 + x68;
auto x121 = -cell[17] + cell[8];
auto x122 = x25 - cell[11] + cell[2];
auto x123 = x114 - x115 + x121 + x122 + x30 + x46;
auto x124 = x103*(x123*x123);
auto x125 = x62 + x68;
auto x126 = V{0.5}*cell[14];
auto x127 = V{0.5}*cell[5];
auto x128 = x126 - x127;
auto x129 = x102*(x111 - x124 + x63);
auto x130 = x52 + x62;
auto x131 = x102*(-x119 + x130 + x79);
auto x132 = -x22*(x126 + x127 + x129 + x131 + V{0.0277777777777778});
auto x133 = x27 + x28 + cell[10];
auto x134 = x133 + x35 + x47 + V{2}*cell[15] - V{2}*cell[6];
auto x135 = x103*(x134*x134);
auto x136 = V{0.5}*cell[6];
auto x137 = -x102*(x125 + x135 + x97) + V{0.5}*cell[15];
auto x138 = -x136 + x137;
auto x139 = x102*(x130 - x135 + x91);
auto x140 = -x22*(x136 + x137 + x139 + V{0.0277777777777778});
auto x141 = V{2}*cell[16];
auto x142 = V{2}*cell[7];
auto x143 = -cell[13] + cell[4];
auto x144 = x117 - x141 + x142 + x143 + x38 + x47;
auto x145 = x103*(x144*x144);
auto x146 = x24 - cell[12] + cell[3];
auto x147 = x121 + x133 + x141 - x142 + x146 + x36;
auto x148 = x103*(x147*x147);
auto x149 = V{0.5}*cell[16];
auto x150 = V{0.5}*cell[7];
auto x151 = x149 - x150;
auto x152 = x52 + x91;
auto x153 = x102*(-x148 + x152 + x63);
auto x154 = x102*(x130 - x145 + x92);
auto x155 = -x22*(x149 + x150 + x153 + x154 + V{0.0277777777777778});
auto x156 = x44 + x45 + cell[12];
auto x157 = x156 + x26 + x39 + V{2}*cell[17] - V{2}*cell[8];
auto x158 = x103*(x157*x157);
auto x159 = x158 + x68;
auto x160 = V{0.5}*cell[8];
auto x161 = -x102*(x159 + x85 + x91) + V{0.5}*cell[17];
auto x162 = -x160 + x161;
auto x163 = x102*(x111 - x158 + x91);
auto x164 = -x22*(x160 + x161 + x163 + V{0.0277777777777778});
auto x165 = V{2}*cell[18];
auto x166 = V{2}*cell[9];
auto x167 = x122 + x143 + x156 - x165 + x166 + x27;
auto x168 = x103*(x167*x167);
auto x169 = x116 + x146 + x165 - x166 + x29 + x39;
auto x170 = x103*(x169*x169);
auto x171 = V{0.5}*cell[18];
auto x172 = V{0.5}*cell[9];
auto x173 = x171 - x172;
auto x174 = x102*(x111 - x168 + x92);
auto x175 = x102*(x152 - x170 + x79);
auto x176 = -x22*(x171 + x172 + x174 + x175 + V{0.0277777777777778});
cell[0] = -x22*(x52*(V{0.333333333333333}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9] + V{0.333333333333333}) + V{1}*cell[0] + V{0.333333333333333}) + cell[0];
cell[1] = x53*(x54*(x63 + x69) + x72) + x74 + cell[1];
cell[2] = x53*(x54*(x81 + x83) + x87) + x90 + cell[2];
cell[3] = x101 + x53*(x54*(x93 + x95) + x99) + cell[3];
cell[4] = x113 + x53*(x102*(x107 + x63 + x81) + x110) + cell[4];
cell[5] = x132 + x53*(x102*(x119 + x120 + x85) - x102*(x124 + x125 + x81) + x128) + cell[5];
cell[6] = x140 + x53*(x102*(x120 + x135 + x93) + x138) + cell[6];
cell[7] = x155 + x53*(x102*(x120 + x145 + x97) - x102*(x125 + x148 + x93) + x151) + cell[7];
cell[8] = x164 + x53*(x102*(x159 + x81 + x92) + x162) + cell[8];
cell[9] = x176 + x53*(x102*(x168 + x68 + x81 + x91) - x102*(x170 + x68 + x85 + x92) + x173) + cell[9];
cell[10] = -x53*(x72 - x73) + x74 + cell[10];
cell[11] = -x53*(x87 - x89) + x90 + cell[11];
cell[12] = x101 - x53*(-x100 + x99) + cell[12];
cell[13] = x113 - x53*(x110 - x112) + cell[13];
cell[14] = x132 - x53*(x128 + x129 - x131) + cell[14];
cell[15] = x140 - x53*(x138 - x139) + cell[15];
cell[16] = x155 - x53*(x151 + x153 - x154) + cell[16];
cell[17] = x164 - x53*(x162 - x163) + cell[17];
cell[18] = x176 - x53*(x173 - x174 + x175) + cell[18];
return { x19, V{1}*x20*(x32 + x41 + x49) };
}

};

template <typename... FIELDS>
struct TRT::type<descriptors::D3Q27<FIELDS...>,momenta::BulkTuple,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x31 = parameters.template get<olb::collision::TRT::MAGIC>();
auto x27 = cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1};
auto x28 = V{1} / ((x27)*(x27));
auto x29 = V{1.5}*x28;
auto x32 = -cell[4];
auto x33 = -cell[6];
auto x34 = x32 + x33 + cell[17] + cell[19];
auto x35 = -cell[5];
auto x36 = -cell[7];
auto x37 = x35 + x36 + cell[18] + cell[20];
auto x38 = -cell[11] + cell[24];
auto x39 = -cell[10] + cell[23];
auto x40 = x38 + x39;
auto x41 = -cell[13] + cell[26];
auto x42 = -cell[12] + cell[25];
auto x43 = x41 + x42;
auto x44 = cell[14] - cell[1];
auto x45 = x34 + x37 + x40 + x43 + x44;
auto x46 = x45*x45;
auto x47 = x29*x46;
auto x48 = -cell[8];
auto x49 = cell[13] - cell[26];
auto x50 = x48 + x49 + cell[21];
auto x51 = -cell[9];
auto x52 = cell[12] - cell[25];
auto x53 = x51 + x52 + cell[22];
auto x54 = x32 + cell[17];
auto x55 = -cell[2];
auto x56 = -cell[18] + cell[5];
auto x57 = x55 + x56 + cell[15];
auto x58 = x54 + x57;
auto x59 = x40 + x50 + x53 + x58;
auto x60 = x59*x59;
auto x61 = x29*x60;
auto x62 = -cell[3];
auto x63 = x42 + x62 + cell[16];
auto x64 = -cell[20] + cell[7];
auto x65 = cell[11] - cell[24];
auto x66 = x64 + x65;
auto x67 = x33 + cell[19];
auto x68 = -cell[22] + cell[9];
auto x69 = x67 + x68;
auto x70 = x39 + x50 + x63 + x66 + x69;
auto x71 = x70*x70;
auto x72 = x29*x71;
auto x73 = x61 + x72 + V{-1};
auto x74 = x47 + x73;
auto x75 = V{1} / (-x31/(V{0.5} - V{1}/x30) + V{0.5});
auto x76 = V{0.037037037037037}*cell[0] + V{0.037037037037037}*cell[10] + V{0.037037037037037}*cell[11] + V{0.037037037037037}*cell[12] + V{0.037037037037037}*cell[13] + V{0.037037037037037}*cell[14] + V{0.037037037037037}*cell[15] + V{0.037037037037037}*cell[16] + V{0.037037037037037}*cell[17] + V{0.037037037037037}*cell[18] + V{0.037037037037037}*cell[19] + V{0.037037037037037}*cell[1] + V{0.037037037037037}*cell[20] + V{0.037037037037037}*cell[21] + V{0.037037037037037}*cell[22] + V{0.037037037037037}*cell[23] + V{0.037037037037037}*cell[24] + V{0.037037037037037}*cell[25] + V{0.037037037037037}*cell[26] + V{0.037037037037037}*cell[2] + V{0.037037037037037}*cell[3] + V{0.037037037037037}*cell[4] + V{0.037037037037037}*cell[5] + V{0.037037037037037}*cell[6] + V{0.037037037037037}*cell[7] + V{0.037037037037037}*cell[8] + V{0.037037037037037}*cell[9] + V{0.037037037037037};
auto x77 = V{1} / (x27);
auto x78 = V{3}*cell[14];
auto x79 = V{3}*cell[1];
auto x80 = V{3}*cell[17];
auto x81 = V{3}*cell[23];
auto x82 = V{3}*cell[24];
auto x83 = V{3}*cell[4];
auto x84 = V{3}*cell[10];
auto x85 = -x84;
auto x86 = V{3}*cell[11];
auto x87 = -x86;
auto x88 = x80 + x81 + x82 - x83 + x85 + x87;
auto x89 = V{3}*cell[18];
auto x90 = V{3}*cell[25];
auto x91 = V{3}*cell[26];
auto x92 = V{3}*cell[5];
auto x93 = V{3}*cell[12];
auto x94 = -x93;
auto x95 = V{3}*cell[13];
auto x96 = -x95;
auto x97 = x89 + x90 + x91 - x92 + x94 + x96;
auto x98 = V{3}*cell[19];
auto x99 = V{3}*cell[6];
auto x100 = x98 - x99;
auto x101 = V{3}*cell[20];
auto x102 = V{3}*cell[7];
auto x103 = x101 - x102;
auto x104 = x77*(x100 + x103 + x78 - x79 + x88 + x97);
auto x105 = -x104;
auto x106 = V{3}*x28;
auto x107 = x106*x46;
auto x108 = -x61;
auto x109 = V{1} - x72;
auto x110 = x108 + x109;
auto x111 = x107 + x110;
auto x112 = V{0.5}*cell[14];
auto x113 = V{0.5}*cell[1];
auto x114 = x112 - x113;
auto x115 = x76*(x104 - x107 + x73);
auto x116 = -cell[19] + cell[6];
auto x117 = -cell[14];
auto x118 = x117 + x52 + cell[1];
auto x119 = -cell[17] + cell[4];
auto x120 = cell[10] - cell[23];
auto x121 = x119 + x120;
auto x122 = x116 + x118 + x121 + x49 + x56 + x66;
auto x123 = x122*x122;
auto x124 = -x90;
auto x125 = -x91;
auto x126 = x124 + x125 - x89 + x92 + x93 + x95;
auto x127 = -x81;
auto x128 = -x82;
auto x129 = x127 + x128 - x80 + x83 + x84 + x86;
auto x130 = -x101 + x102;
auto x131 = -x98 + x99;
auto x132 = x77*(x126 + x129 + x130 + x131 - x78 + x79);
auto x133 = -cell[21] + cell[8];
auto x134 = x35 + x68 + cell[18];
auto x135 = -cell[15] + cell[2];
auto x136 = x135 + x65;
auto x137 = x121 + x133 + x134 + x136 + x43;
auto x138 = x137*x137;
auto x139 = -x138*x29;
auto x140 = x36 + cell[20];
auto x141 = x116 + x133;
auto x142 = -cell[16] + cell[3];
auto x143 = x142 + x41;
auto x144 = x120 + x38;
auto x145 = x140 + x141 + x143 + x144 + x53;
auto x146 = x145*x145;
auto x147 = -x146*x29 + V{1};
auto x148 = x139 + x147;
auto x149 = -x132 + x148;
auto x150 = -x76*(x106*x123 + x149);
auto x151 = -x30*(x112 + x113 + x115 + x150 + V{0.0740740740740741});
auto x152 = V{3}*cell[15];
auto x153 = V{3}*cell[2];
auto x154 = V{3}*cell[21];
auto x155 = V{3}*cell[8];
auto x156 = x154 - x155;
auto x157 = V{3}*cell[22];
auto x158 = V{3}*cell[9];
auto x159 = x157 - x158;
auto x160 = x77*(x126 + x152 - x153 + x156 + x159 + x88);
auto x161 = -x160;
auto x162 = -x47;
auto x163 = x161 + x162;
auto x164 = x106*x60;
auto x165 = x109 + x164;
auto x166 = x160 + x162;
auto x167 = V{0.5}*cell[15];
auto x168 = V{0.5}*cell[2];
auto x169 = x167 - x168;
auto x170 = x47 + V{-1};
auto x171 = x76*(x160 - x164 + x170 + x72);
auto x172 = -x157 + x158;
auto x173 = -x154 + x155;
auto x174 = x77*(x129 - x152 + x153 + x172 + x173 + x97);
auto x175 = -x123*x29;
auto x176 = -x174 + x175;
auto x177 = -x76*(x106*x138 + x147 + x176);
auto x178 = -x30*(x167 + x168 + x171 + x177 + V{0.0740740740740741});
auto x179 = V{3}*cell[16];
auto x180 = V{3}*cell[3];
auto x181 = x77*(x100 + x125 + x128 + x130 + x156 + x172 + x179 - x180 + x81 + x85 + x86 + x90 + x94 + x95);
auto x182 = -x181;
auto x183 = x162 + x182;
auto x184 = x106*x71;
auto x185 = x108 + x184 + V{1};
auto x186 = x162 + x181;
auto x187 = V{0.5}*cell[16];
auto x188 = V{0.5}*cell[3];
auto x189 = x187 - x188;
auto x190 = x76*(x170 + x181 - x184 + x61);
auto x191 = x77*(x103 + x124 + x127 + x131 + x159 + x173 - x179 + x180 + x82 + x84 + x87 + x91 + x93 + x96);
auto x192 = -x191;
auto x193 = x175 + x192;
auto x194 = -x76*(x106*x146 + x139 + x193 + V{1});
auto x195 = -x30*(x187 + x188 + x190 + x194 + V{0.0740740740740741});
auto x196 = V{0.00925925925925926}*cell[0] + V{0.00925925925925926}*cell[10] + V{0.00925925925925926}*cell[11] + V{0.00925925925925926}*cell[12] + V{0.00925925925925926}*cell[13] + V{0.00925925925925926}*cell[14] + V{0.00925925925925926}*cell[15] + V{0.00925925925925926}*cell[16] + V{0.00925925925925926}*cell[17] + V{0.00925925925925926}*cell[18] + V{0.00925925925925926}*cell[19] + V{0.00925925925925926}*cell[1] + V{0.00925925925925926}*cell[20] + V{0.00925925925925926}*cell[21] + V{0.00925925925925926}*cell[22] + V{0.00925925925925926}*cell[23] + V{0.00925925925925926}*cell[24] + V{0.00925925925925926}*cell[25] + V{0.00925925925925926}*cell[26] + V{0.00925925925925926}*cell[2] + V{0.00925925925925926}*cell[3] + V{0.00925925925925926}*cell[4] + V{0.00925925925925926}*cell[5] + V{0.00925925925925926}*cell[6] + V{0.00925925925925926}*cell[7] + V{0.00925925925925926}*cell[8] + V{0.00925925925925926}*cell[9] + V{0.00925925925925926};
auto x197 = V{4.5}*x28;
auto x198 = x140 + x44;
auto x199 = x48 + cell[21];
auto x200 = V{2}*cell[10];
auto x201 = V{2}*cell[23];
auto x202 = -x200 + x201;
auto x203 = x199 + x202;
auto x204 = x51 + cell[22];
auto x205 = V{2}*cell[11];
auto x206 = V{2}*cell[24];
auto x207 = -x205 + x206;
auto x208 = x204 + x207;
auto x209 = V{2}*cell[4];
auto x210 = V{2}*cell[17];
auto x211 = x55 + cell[15];
auto x212 = -x209 + x210 + x211;
auto x213 = x198 + x203 + x208 + x212 + x67;
auto x214 = x197*(x213*x213);
auto x215 = x110 + x214;
auto x216 = x105 + x163;
auto x217 = x104 + x166;
auto x218 = V{0.5}*cell[17];
auto x219 = V{0.5}*cell[4];
auto x220 = x218 - x219;
auto x221 = x160 + x74;
auto x222 = x104 + x221;
auto x223 = x196*(-x214 + x222);
auto x224 = x209 - x210;
auto x225 = x117 + cell[1];
auto x226 = x225 + x64;
auto x227 = -x201;
auto x228 = x135 + x200 + x227;
auto x229 = x205 - x206;
auto x230 = x229 + x68;
auto x231 = x141 + x224 + x226 + x228 + x230;
auto x232 = x149 + x176;
auto x233 = -x196*(x197*(x231*x231) + x232);
auto x234 = -x30*(x218 + x219 + x223 + x233 + V{0.0185185185185185});
auto x235 = V{2}*cell[25];
auto x236 = -x235;
auto x237 = V{2}*cell[12];
auto x238 = x204 + x236 + x237;
auto x239 = V{2}*cell[26];
auto x240 = V{2}*cell[13];
auto x241 = -x239 + x240;
auto x242 = x199 + x241;
auto x243 = V{2}*cell[18];
auto x244 = V{2}*cell[5];
auto x245 = x211 - x243 + x244;
auto x246 = x116 + x226 + x238 + x242 + x245;
auto x247 = x197*(x246*x246);
auto x248 = x105 + x110;
auto x249 = x166 + x248;
auto x250 = x243 - x244;
auto x251 = x239 - x240;
auto x252 = x133 + x251;
auto x253 = x235 - x237;
auto x254 = x135 + x253;
auto x255 = x198 + x250 + x252 + x254 + x69;
auto x256 = x197*(x255*x255);
auto x257 = x104 + x110;
auto x258 = x163 + x257;
auto x259 = V{0.5}*cell[18];
auto x260 = V{0.5}*cell[5];
auto x261 = x259 - x260;
auto x262 = x105 + x221;
auto x263 = x196*(-x256 + x262);
auto x264 = x104 + x74;
auto x265 = x161 + x264;
auto x266 = x196*(-x247 + x265);
auto x267 = -x30*(x259 + x260 + x263 + x266 + V{0.0185185185185185});
auto x268 = x44 + x54;
auto x269 = x62 + cell[16];
auto x270 = V{2}*cell[6];
auto x271 = V{2}*cell[19];
auto x272 = -x270 + x271;
auto x273 = x269 + x272;
auto x274 = x134 + x203 + x253 + x268 + x273;
auto x275 = x197*(x274*x274);
auto x276 = V{0.5}*cell[19];
auto x277 = V{0.5}*cell[6];
auto x278 = x276 - x277;
auto x279 = x196*(x181 + x264 - x275);
auto x280 = x119 + x142;
auto x281 = x270 - x271;
auto x282 = x225 + x56;
auto x283 = x133 + x200 + x227 + x238 + x280 + x281 + x282;
auto x284 = x149 + x193;
auto x285 = -x196*(x197*(x283*x283) + x284);
auto x286 = -x30*(x276 + x277 + x279 + x285 + V{0.0185185185185185});
auto x287 = x119 + x269;
auto x288 = V{2}*cell[20];
auto x289 = V{2}*cell[7];
auto x290 = -x288 + x289;
auto x291 = x230 + x242 + x282 + x287 + x290;
auto x292 = x197*(x291*x291);
auto x293 = x35 + cell[18];
auto x294 = x288 - x289;
auto x295 = x142 + x294;
auto x296 = x208 + x252 + x268 + x293 + x295;
auto x297 = x197*(x296*x296);
auto x298 = V{0.5}*cell[20];
auto x299 = V{0.5}*cell[7];
auto x300 = x298 - x299;
auto x301 = x181 + x74;
auto x302 = x196*(x105 - x297 + x301);
auto x303 = x196*(x182 + x264 - x292);
auto x304 = -x30*(x298 + x299 + x302 + x303 + V{0.0185185185185185});
auto x305 = V{2}*cell[8];
auto x306 = V{2}*cell[21];
auto x307 = -x305 + x306;
auto x308 = x269 + x307;
auto x309 = x202 + x241 + x308 + x34 + x57 + x64;
auto x310 = x197*(x309*x309);
auto x311 = x110 + x310;
auto x312 = V{0.5}*cell[21];
auto x313 = V{0.5}*cell[8];
auto x314 = x312 - x313;
auto x315 = x196*(x181 + x221 - x310);
auto x316 = x305 - x306;
auto x317 = x116 + x228 + x251 + x280 + x316 + x37;
auto x318 = x148 + x176 + x192;
auto x319 = -x196*(x197*(x317*x317) + x318);
auto x320 = -x30*(x312 + x313 + x315 + x319 + V{0.0185185185185185});
auto x321 = V{2}*cell[22];
auto x322 = V{2}*cell[9];
auto x323 = -x321 + x322;
auto x324 = x229 + x254 + x287 + x293 + x323 + x64 + x67;
auto x325 = x197*(x324*x324);
auto x326 = x110 + x181;
auto x327 = x321 - x322;
auto x328 = x142 + x327;
auto x329 = x116 + x140 + x207 + x236 + x237 + x328 + x58;
auto x330 = x197*(x329*x329);
auto x331 = x110 + x182;
auto x332 = V{0.5}*cell[22];
auto x333 = V{0.5}*cell[9];
auto x334 = x332 - x333;
auto x335 = x196*(x182 + x221 - x325);
auto x336 = x196*(x161 + x301 - x330);
auto x337 = -x30*(x332 + x333 + x335 + x336 + V{0.0185185185185185});
auto x338 = V{0.00231481481481481}*cell[0] + V{0.00231481481481481}*cell[10] + V{0.00231481481481481}*cell[11] + V{0.00231481481481481}*cell[12] + V{0.00231481481481481}*cell[13] + V{0.00231481481481481}*cell[14] + V{0.00231481481481481}*cell[15] + V{0.00231481481481481}*cell[16] + V{0.00231481481481481}*cell[17] + V{0.00231481481481481}*cell[18] + V{0.00231481481481481}*cell[19] + V{0.00231481481481481}*cell[1] + V{0.00231481481481481}*cell[20] + V{0.00231481481481481}*cell[21] + V{0.00231481481481481}*cell[22] + V{0.00231481481481481}*cell[23] + V{0.00231481481481481}*cell[24] + V{0.00231481481481481}*cell[25] + V{0.00231481481481481}*cell[26] + V{0.00231481481481481}*cell[2] + V{0.00231481481481481}*cell[3] + V{0.00231481481481481}*cell[4] + V{0.00231481481481481}*cell[5] + V{0.00231481481481481}*cell[6] + V{0.00231481481481481}*cell[7] + V{0.00231481481481481}*cell[8] + V{0.00231481481481481}*cell[9] + V{0.00231481481481481};
auto x339 = V{3}*cell[10];
auto x340 = V{3}*cell[23];
auto x341 = x49 + x63;
auto x342 = x212 + x44;
auto x343 = x272 + x307 - x339 + x340 + x341 + x342 + x38;
auto x344 = x197*(x343*x343);
auto x345 = V{0.5}*cell[23];
auto x346 = V{0.5}*cell[10];
auto x347 = x345 - x346;
auto x348 = x338*(x181 + x222 - x344);
auto x349 = x118 + x136 + x143 + x224 + x281 + x316 + x339 - x340;
auto x350 = -x338*(x192 + x197*(x349*x349) + x232);
auto x351 = -x30*(x345 + x346 + x348 + x350 + V{0.00462962962962963});
auto x352 = V{3}*cell[24];
auto x353 = V{3}*cell[11];
auto x354 = x120 + x135 + x224 + x225 + x290 + x323 + x341 - x352 + x353;
auto x355 = x197*(x354*x354);
auto x356 = x143 + x294 + x327 + x342 + x352 - x353 + x39 + x52;
auto x357 = x197*(x356*x356);
auto x358 = V{0.5}*cell[24];
auto x359 = V{0.5}*cell[11];
auto x360 = x358 - x359;
auto x361 = x338*(x182 + x222 - x355);
auto x362 = -x338*(x191 + x232 + x357);
auto x363 = -x30*(x358 + x359 + x361 + x362 + V{0.00462962962962963});
auto x364 = V{3}*cell[25];
auto x365 = V{3}*cell[12];
auto x366 = x144 + x225 + x245 + x281 + x328 - x364 + x365 + x49;
auto x367 = x197*(x366*x366);
auto x368 = x250 + x44;
auto x369 = x136 + x273 + x323 + x364 - x365 + x368 + x39 + x41;
auto x370 = x197*(x369*x369);
auto x371 = V{0.5}*cell[25];
auto x372 = V{0.5}*cell[12];
auto x373 = x371 - x372;
auto x374 = x338*(x181 + x265 - x367);
auto x375 = -x338*(x174 + x284 + x370);
auto x376 = -x30*(x371 + x372 + x374 + x375 + V{0.00462962962962963});
auto x377 = V{3}*cell[26];
auto x378 = V{3}*cell[13];
auto x379 = x118 + x245 + x290 + x308 - x377 + x378 + x39 + x65;
auto x380 = x197*(x379*x379);
auto x381 = x135 + x144 + x295 + x316 + x368 + x377 - x378 + x42;
auto x382 = x197*(x381*x381);
auto x383 = V{0.5}*cell[26];
auto x384 = V{0.5}*cell[13];
auto x385 = x383 - x384;
auto x386 = x338*(x181 + x262 - x382);
auto x387 = x338*(x132 + x318 + x380);
auto x388 = -x30*(x383 + x384 + x386 - x387 + V{0.00462962962962963});
cell[0] = -x30*(x74*(V{0.296296296296296}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9] + V{0.296296296296296}) + V{1}*cell[0] + V{0.296296296296296}) + cell[0];
cell[1] = x151 + x75*(x114 - x76*(x104 + x111) + x76*(x105 + x111)) + cell[1];
cell[2] = x178 + x75*(x169 + x76*(x163 + x165) - x76*(x165 + x166)) + cell[2];
cell[3] = x195 + x75*(x189 + x76*(x183 + x185) - x76*(x185 + x186)) + cell[3];
cell[4] = x234 + x75*(x196*(x215 + x216) - x196*(x215 + x217) + x220) + cell[4];
cell[5] = x267 + x75*(x196*(x247 + x249) - x196*(x256 + x258) + x261) + cell[5];
cell[6] = x286 + x75*(x196*(x183 + x248 + x275) - x196*(x186 + x257 + x275) + x278) + cell[6];
cell[7] = x304 + x75*(-x196*(x183 + x257 + x297) + x196*(x186 + x248 + x292) + x300) + cell[7];
cell[8] = x320 + x75*(x196*(x163 + x182 + x311) - x196*(x166 + x181 + x311) + x314) + cell[8];
cell[9] = x337 + x75*(x196*(x163 + x325 + x326) - x196*(x166 + x330 + x331) + x334) + cell[9];
cell[10] = x351 + x75*(x338*(x216 + x331 + x344) - x338*(x217 + x326 + x344) + x347) + cell[10];
cell[11] = x363 + x75*(x338*(x216 + x326 + x355) - x338*(x217 + x331 + x357) + x360) + cell[11];
cell[12] = x376 + x75*(-x338*(x181 + x258 + x370) + x338*(x182 + x249 + x367) + x373) + cell[12];
cell[13] = x388 + x75*(x338*(x181 + x249 + x380) - x338*(x182 + x258 + x382) + x385) + cell[13];
cell[14] = x151 - x75*(x114 - x115 + x150) + cell[14];
cell[15] = x178 - x75*(x169 - x171 + x177) + cell[15];
cell[16] = x195 - x75*(x189 - x190 + x194) + cell[16];
cell[17] = x234 - x75*(x220 - x223 + x233) + cell[17];
cell[18] = x267 - x75*(x261 + x263 - x266) + cell[18];
cell[19] = x286 - x75*(x278 - x279 + x285) + cell[19];
cell[20] = x304 - x75*(x300 + x302 - x303) + cell[20];
cell[21] = x320 - x75*(x314 - x315 + x319) + cell[21];
cell[22] = x337 - x75*(x334 - x335 + x336) + cell[22];
cell[23] = x351 - x75*(x347 - x348 + x350) + cell[23];
cell[24] = x363 - x75*(x360 - x361 + x362) + cell[24];
cell[25] = x376 - x75*(x373 - x374 + x375) + cell[25];
cell[26] = x388 - x75*(x385 + x386 + x387) + cell[26];
return { x27, V{1}*x28*(x123 + x138 + x146) };
}

};


template <typename... FIELDS>
struct Poisson::type<descriptors::D2Q5<FIELDS...>,momenta::PoissonTuple,equilibria::ZerothOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::descriptors::OMEGA>();
auto x8 = parameters.template get<olb::collision::Poisson::SINK>();
auto x5 = V{0.166666666666667}*cell[2];
auto x6 = V{0.166666666666667}*cell[0];
auto x9 = V{0.166666666666667}*cell[3];
auto x10 = V{0.166666666666667}*cell[4];
auto x11 = x10 + x6 + x9;
auto x12 = V{0.166666666666667}*cell[1];
auto x13 = x12 + x5 + x6;
cell[0] = x7*(-V{0.666666666666667}*cell[0] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4]) - x8*(cell[0] + V{0.333333333333333}) + cell[0];
cell[1] = x7*(x11 + x5 - V{0.833333333333333}*cell[1]) - x8*(cell[1] + V{0.166666666666667}) + cell[1];
cell[2] = x7*(x11 + x12 - V{0.833333333333333}*cell[2]) - x8*(cell[2] + V{0.166666666666667}) + cell[2];
cell[3] = x7*(x10 + x13 - V{0.833333333333333}*cell[3]) - x8*(cell[3] + V{0.166666666666667}) + cell[3];
cell[4] = x7*(x13 + x9 - V{0.833333333333333}*cell[4]) - x8*(cell[4] + V{0.166666666666667}) + cell[4];
return { cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct Poisson::type<descriptors::D2Q9<FIELDS...>,momenta::PoissonTuple,equilibria::ZerothOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x12 = parameters.template get<olb::collision::Poisson::SINK>();
auto x11 = parameters.template get<olb::descriptors::OMEGA>();
auto x9 = V{0.0277777777777778}*cell[3];
auto x10 = V{0.0277777777777778}*cell[0];
auto x13 = V{0.0277777777777778}*cell[2];
auto x14 = V{0.0277777777777778}*cell[4];
auto x15 = V{0.0277777777777778}*cell[5];
auto x16 = V{0.0277777777777778}*cell[6];
auto x17 = V{0.0277777777777778}*cell[7];
auto x18 = V{0.0277777777777778}*cell[8];
auto x19 = x10 + x13 + x14 + x15 + x16 + x17 + x18;
auto x20 = V{0.111111111111111}*cell[4];
auto x21 = V{0.111111111111111}*cell[0];
auto x22 = V{0.111111111111111}*cell[1];
auto x23 = V{0.111111111111111}*cell[3];
auto x24 = V{0.111111111111111}*cell[5];
auto x25 = V{0.111111111111111}*cell[6];
auto x26 = V{0.111111111111111}*cell[7];
auto x27 = V{0.111111111111111}*cell[8];
auto x28 = x21 + x22 + x23 + x24 + x25 + x26 + x27;
auto x29 = V{0.0277777777777778}*cell[1];
auto x30 = V{0.111111111111111}*cell[2];
auto x31 = x10 + x13 + x14 + x16 + x18 + x29 + x9;
auto x32 = x20 + x21 + x22 + x23 + x24 + x26 + x30;
cell[0] = x11*(-V{0.555555555555556}*cell[0] + V{0.444444444444444}*cell[1] + V{0.444444444444444}*cell[2] + V{0.444444444444444}*cell[3] + V{0.444444444444444}*cell[4] + V{0.444444444444444}*cell[5] + V{0.444444444444444}*cell[6] + V{0.444444444444444}*cell[7] + V{0.444444444444444}*cell[8]) - x12*(cell[0] + V{0.444444444444444}) + cell[0];
cell[1] = x11*(x19 + x9 - V{0.972222222222222}*cell[1]) - x12*(cell[1] + V{0.0277777777777778}) + cell[1];
cell[2] = x11*(x20 + x28 - V{0.888888888888889}*cell[2]) - x12*(cell[2] + V{0.111111111111111}) + cell[2];
cell[3] = x11*(x19 + x29 - V{0.972222222222222}*cell[3]) - x12*(cell[3] + V{0.0277777777777778}) + cell[3];
cell[4] = x11*(x28 + x30 - V{0.888888888888889}*cell[4]) - x12*(cell[4] + V{0.111111111111111}) + cell[4];
cell[5] = x11*(x17 + x31 - V{0.972222222222222}*cell[5]) - x12*(cell[5] + V{0.0277777777777778}) + cell[5];
cell[6] = x11*(x27 + x32 - V{0.888888888888889}*cell[6]) - x12*(cell[6] + V{0.111111111111111}) + cell[6];
cell[7] = x11*(x15 + x31 - V{0.972222222222222}*cell[7]) - x12*(cell[7] + V{0.0277777777777778}) + cell[7];
cell[8] = x11*(x25 + x32 - V{0.888888888888889}*cell[8]) - x12*(cell[8] + V{0.111111111111111}) + cell[8];
return { cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct Poisson::type<descriptors::D3Q7<FIELDS...>,momenta::PoissonTuple,equilibria::ZerothOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x10 = parameters.template get<olb::descriptors::OMEGA>();
auto x11 = parameters.template get<olb::collision::Poisson::SINK>();
auto x7 = V{0.125}*cell[2];
auto x8 = V{0.125}*cell[0];
auto x9 = V{0.125}*cell[3];
auto x12 = V{0.125}*cell[4];
auto x13 = V{0.125}*cell[5];
auto x14 = V{0.125}*cell[6];
auto x15 = x12 + x13 + x14 + x8 + x9;
auto x16 = V{0.125}*cell[1];
auto x17 = x13 + x14 + x16 + x7 + x8;
auto x18 = x12 + x16 + x7 + x8 + x9;
cell[0] = x10*(-V{0.75}*cell[0] + V{0.25}*cell[1] + V{0.25}*cell[2] + V{0.25}*cell[3] + V{0.25}*cell[4] + V{0.25}*cell[5] + V{0.25}*cell[6]) - x11*(cell[0] + V{0.25}) + cell[0];
cell[1] = x10*(x15 + x7 - V{0.875}*cell[1]) - x11*(cell[1] + V{0.125}) + cell[1];
cell[2] = x10*(x15 + x16 - V{0.875}*cell[2]) - x11*(cell[2] + V{0.125}) + cell[2];
cell[3] = x10*(x12 + x17 - V{0.875}*cell[3]) - x11*(cell[3] + V{0.125}) + cell[3];
cell[4] = x10*(x17 + x9 - V{0.875}*cell[4]) - x11*(cell[4] + V{0.125}) + cell[4];
cell[5] = x10*(x14 + x18 - V{0.875}*cell[5]) - x11*(cell[5] + V{0.125}) + cell[5];
cell[6] = x10*(x13 + x18 - V{0.875}*cell[6]) - x11*(cell[6] + V{0.125}) + cell[6];
return { cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct Poisson::type<descriptors::D3Q19<FIELDS...>,momenta::PoissonTuple,equilibria::ZerothOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x23 = parameters.template get<olb::collision::Poisson::SINK>();
auto x19 = V{0.0555555555555556}*cell[2];
auto x20 = V{0.0555555555555556}*cell[0];
auto x21 = V{0.0555555555555556}*cell[3];
auto x24 = V{0.0555555555555556}*cell[4];
auto x25 = V{0.0555555555555556}*cell[5];
auto x26 = V{0.0555555555555556}*cell[6];
auto x27 = V{0.0555555555555556}*cell[7];
auto x28 = V{0.0555555555555556}*cell[8];
auto x29 = V{0.0555555555555556}*cell[9];
auto x30 = V{0.0555555555555556}*cell[10];
auto x31 = V{0.0555555555555556}*cell[11];
auto x32 = V{0.0555555555555556}*cell[12];
auto x33 = V{0.0555555555555556}*cell[13];
auto x34 = V{0.0555555555555556}*cell[14];
auto x35 = V{0.0555555555555556}*cell[15];
auto x36 = V{0.0555555555555556}*cell[16];
auto x37 = V{0.0555555555555556}*cell[17];
auto x38 = V{0.0555555555555556}*cell[18];
auto x39 = x20 + x21 + x24 + x25 + x26 + x27 + x28 + x29 + x30 + x31 + x32 + x33 + x34 + x35 + x36 + x37 + x38;
auto x40 = V{0.0555555555555556}*cell[1];
auto x41 = x19 + x20 + x24 + x25 + x26 + x27 + x28 + x29 + x31 + x32 + x33 + x34 + x35 + x36 + x37 + x38 + x40;
auto x42 = V{0.0277777777777778}*cell[5];
auto x43 = V{0.0277777777777778}*cell[0];
auto x44 = V{0.0277777777777778}*cell[1];
auto x45 = V{0.0277777777777778}*cell[2];
auto x46 = V{0.0277777777777778}*cell[3];
auto x47 = V{0.0277777777777778}*cell[6];
auto x48 = V{0.0277777777777778}*cell[7];
auto x49 = V{0.0277777777777778}*cell[8];
auto x50 = V{0.0277777777777778}*cell[9];
auto x51 = V{0.0277777777777778}*cell[10];
auto x52 = V{0.0277777777777778}*cell[11];
auto x53 = V{0.0277777777777778}*cell[12];
auto x54 = V{0.0277777777777778}*cell[13];
auto x55 = V{0.0277777777777778}*cell[14];
auto x56 = V{0.0277777777777778}*cell[15];
auto x57 = V{0.0277777777777778}*cell[16];
auto x58 = V{0.0277777777777778}*cell[17];
auto x59 = V{0.0277777777777778}*cell[18];
auto x60 = x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54 + x55 + x56 + x57 + x58 + x59;
auto x61 = V{0.0277777777777778}*cell[4];
auto x62 = x42 + x43 + x44 + x45 + x46 + x49 + x50 + x51 + x52 + x53 + x54 + x55 + x56 + x57 + x58 + x59 + x61;
auto x63 = x42 + x43 + x44 + x45 + x46 + x47 + x48 + x51 + x52 + x53 + x54 + x55 + x56 + x57 + x58 + x59 + x61;
auto x64 = x19 + x20 + x21 + x24 + x25 + x26 + x27 + x28 + x29 + x30 + x33 + x34 + x35 + x36 + x37 + x38 + x40;
auto x65 = x42 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x56 + x57 + x58 + x59 + x61;
auto x66 = x42 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54 + x55 + x58 + x59 + x61;
auto x67 = x42 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54 + x55 + x56 + x57 + x61;
cell[0] = x22*(-V{0.666666666666667}*cell[0] + V{0.333333333333333}*cell[10] + V{0.333333333333333}*cell[11] + V{0.333333333333333}*cell[12] + V{0.333333333333333}*cell[13] + V{0.333333333333333}*cell[14] + V{0.333333333333333}*cell[15] + V{0.333333333333333}*cell[16] + V{0.333333333333333}*cell[17] + V{0.333333333333333}*cell[18] + V{0.333333333333333}*cell[1] + V{0.333333333333333}*cell[2] + V{0.333333333333333}*cell[3] + V{0.333333333333333}*cell[4] + V{0.333333333333333}*cell[5] + V{0.333333333333333}*cell[6] + V{0.333333333333333}*cell[7] + V{0.333333333333333}*cell[8] + V{0.333333333333333}*cell[9]) - x23*(cell[0] + V{0.333333333333333}) + cell[0];
cell[1] = x22*(x19 + x39 - V{0.944444444444444}*cell[1]) - x23*(cell[1] + V{0.0555555555555556}) + cell[1];
cell[2] = x22*(x39 + x40 - V{0.944444444444444}*cell[2]) - x23*(cell[2] + V{0.0555555555555556}) + cell[2];
cell[3] = x22*(x30 + x41 - V{0.944444444444444}*cell[3]) - x23*(cell[3] + V{0.0555555555555556}) + cell[3];
cell[4] = x22*(x42 + x60 - V{0.972222222222222}*cell[4]) - x23*(cell[4] + V{0.0277777777777778}) + cell[4];
cell[5] = x22*(x60 + x61 - V{0.972222222222222}*cell[5]) - x23*(cell[5] + V{0.0277777777777778}) + cell[5];
cell[6] = x22*(x48 + x62 - V{0.972222222222222}*cell[6]) - x23*(cell[6] + V{0.0277777777777778}) + cell[6];
cell[7] = x22*(x47 + x62 - V{0.972222222222222}*cell[7]) - x23*(cell[7] + V{0.0277777777777778}) + cell[7];
cell[8] = x22*(x50 + x63 - V{0.972222222222222}*cell[8]) - x23*(cell[8] + V{0.0277777777777778}) + cell[8];
cell[9] = x22*(x49 + x63 - V{0.972222222222222}*cell[9]) - x23*(cell[9] + V{0.0277777777777778}) + cell[9];
cell[10] = x22*(x21 + x41 - V{0.944444444444444}*cell[10]) - x23*(cell[10] + V{0.0555555555555556}) + cell[10];
cell[11] = x22*(x32 + x64 - V{0.944444444444444}*cell[11]) - x23*(cell[11] + V{0.0555555555555556}) + cell[11];
cell[12] = x22*(x31 + x64 - V{0.944444444444444}*cell[12]) - x23*(cell[12] + V{0.0555555555555556}) + cell[12];
cell[13] = x22*(x55 + x65 - V{0.972222222222222}*cell[13]) - x23*(cell[13] + V{0.0277777777777778}) + cell[13];
cell[14] = x22*(x54 + x65 - V{0.972222222222222}*cell[14]) - x23*(cell[14] + V{0.0277777777777778}) + cell[14];
cell[15] = x22*(x57 + x66 - V{0.972222222222222}*cell[15]) - x23*(cell[15] + V{0.0277777777777778}) + cell[15];
cell[16] = x22*(x56 + x66 - V{0.972222222222222}*cell[16]) - x23*(cell[16] + V{0.0277777777777778}) + cell[16];
cell[17] = x22*(x59 + x67 - V{0.972222222222222}*cell[17]) - x23*(cell[17] + V{0.0277777777777778}) + cell[17];
cell[18] = x22*(x58 + x67 - V{0.972222222222222}*cell[18]) - x23*(cell[18] + V{0.0277777777777778}) + cell[18];
return { cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct Poisson::type<descriptors::D3Q27<FIELDS...>,momenta::PoissonTuple,equilibria::ZerothOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x30 = parameters.template get<olb::descriptors::OMEGA>();
auto x31 = parameters.template get<olb::collision::Poisson::SINK>();
auto x27 = V{0.0740740740740741}*cell[2];
auto x28 = V{0.0740740740740741}*cell[0];
auto x29 = V{0.0740740740740741}*cell[3];
auto x32 = V{0.0740740740740741}*cell[4];
auto x33 = V{0.0740740740740741}*cell[5];
auto x34 = V{0.0740740740740741}*cell[6];
auto x35 = V{0.0740740740740741}*cell[7];
auto x36 = V{0.0740740740740741}*cell[8];
auto x37 = V{0.0740740740740741}*cell[9];
auto x38 = V{0.0740740740740741}*cell[10];
auto x39 = V{0.0740740740740741}*cell[11];
auto x40 = V{0.0740740740740741}*cell[12];
auto x41 = V{0.0740740740740741}*cell[13];
auto x42 = V{0.0740740740740741}*cell[14];
auto x43 = V{0.0740740740740741}*cell[15];
auto x44 = V{0.0740740740740741}*cell[16];
auto x45 = V{0.0740740740740741}*cell[17];
auto x46 = V{0.0740740740740741}*cell[18];
auto x47 = V{0.0740740740740741}*cell[19];
auto x48 = V{0.0740740740740741}*cell[20];
auto x49 = V{0.0740740740740741}*cell[21];
auto x50 = V{0.0740740740740741}*cell[22];
auto x51 = V{0.0740740740740741}*cell[23];
auto x52 = V{0.0740740740740741}*cell[24];
auto x53 = V{0.0740740740740741}*cell[25];
auto x54 = V{0.0740740740740741}*cell[26];
auto x55 = x28 + x29 + x32 + x33 + x34 + x35 + x36 + x37 + x38 + x39 + x40 + x41 + x42 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54;
auto x56 = V{0.0740740740740741}*cell[1];
auto x57 = x27 + x28 + x32 + x33 + x34 + x35 + x36 + x37 + x38 + x39 + x40 + x41 + x43 + x44 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54 + x56;
auto x58 = V{0.0185185185185185}*cell[5];
auto x59 = V{0.0185185185185185}*cell[0];
auto x60 = V{0.0185185185185185}*cell[1];
auto x61 = V{0.0185185185185185}*cell[2];
auto x62 = V{0.0185185185185185}*cell[3];
auto x63 = V{0.0185185185185185}*cell[6];
auto x64 = V{0.0185185185185185}*cell[7];
auto x65 = V{0.0185185185185185}*cell[8];
auto x66 = V{0.0185185185185185}*cell[9];
auto x67 = V{0.0185185185185185}*cell[10];
auto x68 = V{0.0185185185185185}*cell[11];
auto x69 = V{0.0185185185185185}*cell[12];
auto x70 = V{0.0185185185185185}*cell[13];
auto x71 = V{0.0185185185185185}*cell[14];
auto x72 = V{0.0185185185185185}*cell[15];
auto x73 = V{0.0185185185185185}*cell[16];
auto x74 = V{0.0185185185185185}*cell[17];
auto x75 = V{0.0185185185185185}*cell[18];
auto x76 = V{0.0185185185185185}*cell[19];
auto x77 = V{0.0185185185185185}*cell[20];
auto x78 = V{0.0185185185185185}*cell[21];
auto x79 = V{0.0185185185185185}*cell[22];
auto x80 = V{0.0185185185185185}*cell[23];
auto x81 = V{0.0185185185185185}*cell[24];
auto x82 = V{0.0185185185185185}*cell[25];
auto x83 = V{0.0185185185185185}*cell[26];
auto x84 = x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x75 + x76 + x77 + x78 + x79 + x80 + x81 + x82 + x83;
auto x85 = V{0.0185185185185185}*cell[4];
auto x86 = x58 + x59 + x60 + x61 + x62 + x65 + x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x75 + x76 + x77 + x78 + x79 + x80 + x81 + x82 + x83 + x85;
auto x87 = x58 + x59 + x60 + x61 + x62 + x63 + x64 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x75 + x76 + x77 + x78 + x79 + x80 + x81 + x82 + x83 + x85;
auto x88 = V{0.00462962962962963}*cell[11];
auto x89 = V{0.00462962962962963}*cell[0];
auto x90 = V{0.00462962962962963}*cell[1];
auto x91 = V{0.00462962962962963}*cell[2];
auto x92 = V{0.00462962962962963}*cell[3];
auto x93 = V{0.00462962962962963}*cell[4];
auto x94 = V{0.00462962962962963}*cell[5];
auto x95 = V{0.00462962962962963}*cell[6];
auto x96 = V{0.00462962962962963}*cell[7];
auto x97 = V{0.00462962962962963}*cell[8];
auto x98 = V{0.00462962962962963}*cell[9];
auto x99 = V{0.00462962962962963}*cell[12];
auto x100 = V{0.00462962962962963}*cell[13];
auto x101 = V{0.00462962962962963}*cell[14];
auto x102 = V{0.00462962962962963}*cell[15];
auto x103 = V{0.00462962962962963}*cell[16];
auto x104 = V{0.00462962962962963}*cell[17];
auto x105 = V{0.00462962962962963}*cell[18];
auto x106 = V{0.00462962962962963}*cell[19];
auto x107 = V{0.00462962962962963}*cell[20];
auto x108 = V{0.00462962962962963}*cell[21];
auto x109 = V{0.00462962962962963}*cell[22];
auto x110 = V{0.00462962962962963}*cell[23];
auto x111 = V{0.00462962962962963}*cell[24];
auto x112 = V{0.00462962962962963}*cell[25];
auto x113 = V{0.00462962962962963}*cell[26];
auto x114 = x100 + x101 + x102 + x103 + x104 + x105 + x106 + x107 + x108 + x109 + x110 + x111 + x112 + x113 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 + x97 + x98 + x99;
auto x115 = V{0.00462962962962963}*cell[10];
auto x116 = x101 + x102 + x103 + x104 + x105 + x106 + x107 + x108 + x109 + x110 + x111 + x112 + x113 + x115 + x88 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 + x97 + x98;
auto x117 = x27 + x28 + x29 + x32 + x33 + x34 + x35 + x36 + x37 + x38 + x39 + x40 + x41 + x42 + x45 + x46 + x47 + x48 + x49 + x50 + x51 + x52 + x53 + x54 + x56;
auto x118 = x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x76 + x77 + x78 + x79 + x80 + x81 + x82 + x83 + x85;
auto x119 = x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x75 + x78 + x79 + x80 + x81 + x82 + x83 + x85;
auto x120 = x58 + x59 + x60 + x61 + x62 + x63 + x64 + x65 + x66 + x67 + x68 + x69 + x70 + x71 + x72 + x73 + x74 + x75 + x76 + x77 + x80 + x81 + x82 + x83 + x85;
auto x121 = x100 + x101 + x102 + x103 + x104 + x105 + x106 + x107 + x108 + x109 + x112 + x113 + x115 + x88 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 + x97 + x98 + x99;
auto x122 = x100 + x101 + x102 + x103 + x104 + x105 + x106 + x107 + x108 + x109 + x110 + x111 + x115 + x88 + x89 + x90 + x91 + x92 + x93 + x94 + x95 + x96 + x97 + x98 + x99;
cell[0] = x30*(-V{0.703703703703704}*cell[0] + V{0.296296296296296}*cell[10] + V{0.296296296296296}*cell[11] + V{0.296296296296296}*cell[12] + V{0.296296296296296}*cell[13] + V{0.296296296296296}*cell[14] + V{0.296296296296296}*cell[15] + V{0.296296296296296}*cell[16] + V{0.296296296296296}*cell[17] + V{0.296296296296296}*cell[18] + V{0.296296296296296}*cell[19] + V{0.296296296296296}*cell[1] + V{0.296296296296296}*cell[20] + V{0.296296296296296}*cell[21] + V{0.296296296296296}*cell[22] + V{0.296296296296296}*cell[23] + V{0.296296296296296}*cell[24] + V{0.296296296296296}*cell[25] + V{0.296296296296296}*cell[26] + V{0.296296296296296}*cell[2] + V{0.296296296296296}*cell[3] + V{0.296296296296296}*cell[4] + V{0.296296296296296}*cell[5] + V{0.296296296296296}*cell[6] + V{0.296296296296296}*cell[7] + V{0.296296296296296}*cell[8] + V{0.296296296296296}*cell[9]) - x31*(cell[0] + V{0.296296296296296}) + cell[0];
cell[1] = x30*(x27 + x55 - V{0.925925925925926}*cell[1]) - x31*(cell[1] + V{0.0740740740740741}) + cell[1];
cell[2] = x30*(x55 + x56 - V{0.925925925925926}*cell[2]) - x31*(cell[2] + V{0.0740740740740741}) + cell[2];
cell[3] = x30*(x42 + x57 - V{0.925925925925926}*cell[3]) - x31*(cell[3] + V{0.0740740740740741}) + cell[3];
cell[4] = x30*(x58 + x84 - V{0.981481481481482}*cell[4]) - x31*(cell[4] + V{0.0185185185185185}) + cell[4];
cell[5] = x30*(x84 + x85 - V{0.981481481481482}*cell[5]) - x31*(cell[5] + V{0.0185185185185185}) + cell[5];
cell[6] = x30*(x64 + x86 - V{0.981481481481482}*cell[6]) - x31*(cell[6] + V{0.0185185185185185}) + cell[6];
cell[7] = x30*(x63 + x86 - V{0.981481481481482}*cell[7]) - x31*(cell[7] + V{0.0185185185185185}) + cell[7];
cell[8] = x30*(x66 + x87 - V{0.981481481481482}*cell[8]) - x31*(cell[8] + V{0.0185185185185185}) + cell[8];
cell[9] = x30*(x65 + x87 - V{0.981481481481482}*cell[9]) - x31*(cell[9] + V{0.0185185185185185}) + cell[9];
cell[10] = x30*(x114 + x88 - V{0.99537037037037}*cell[10]) - x31*(cell[10] + V{0.00462962962962963}) + cell[10];
cell[11] = x30*(x114 + x115 - V{0.99537037037037}*cell[11]) - x31*(cell[11] + V{0.00462962962962963}) + cell[11];
cell[12] = x30*(x100 + x116 - V{0.99537037037037}*cell[12]) - x31*(cell[12] + V{0.00462962962962963}) + cell[12];
cell[13] = x30*(x116 + x99 - V{0.99537037037037}*cell[13]) - x31*(cell[13] + V{0.00462962962962963}) + cell[13];
cell[14] = x30*(x29 + x57 - V{0.925925925925926}*cell[14]) - x31*(cell[14] + V{0.0740740740740741}) + cell[14];
cell[15] = x30*(x117 + x44 - V{0.925925925925926}*cell[15]) - x31*(cell[15] + V{0.0740740740740741}) + cell[15];
cell[16] = x30*(x117 + x43 - V{0.925925925925926}*cell[16]) - x31*(cell[16] + V{0.0740740740740741}) + cell[16];
cell[17] = x30*(x118 + x75 - V{0.981481481481482}*cell[17]) - x31*(cell[17] + V{0.0185185185185185}) + cell[17];
cell[18] = x30*(x118 + x74 - V{0.981481481481482}*cell[18]) - x31*(cell[18] + V{0.0185185185185185}) + cell[18];
cell[19] = x30*(x119 + x77 - V{0.981481481481482}*cell[19]) - x31*(cell[19] + V{0.0185185185185185}) + cell[19];
cell[20] = x30*(x119 + x76 - V{0.981481481481482}*cell[20]) - x31*(cell[20] + V{0.0185185185185185}) + cell[20];
cell[21] = x30*(x120 + x79 - V{0.981481481481482}*cell[21]) - x31*(cell[21] + V{0.0185185185185185}) + cell[21];
cell[22] = x30*(x120 + x78 - V{0.981481481481482}*cell[22]) - x31*(cell[22] + V{0.0185185185185185}) + cell[22];
cell[23] = x30*(x111 + x121 - V{0.99537037037037}*cell[23]) - x31*(cell[23] + V{0.00462962962962963}) + cell[23];
cell[24] = x30*(x110 + x121 - V{0.99537037037037}*cell[24]) - x31*(cell[24] + V{0.00462962962962963}) + cell[24];
cell[25] = x30*(x113 + x122 - V{0.99537037037037}*cell[25]) - x31*(cell[25] + V{0.00462962962962963}) + cell[25];
cell[26] = x30*(x112 + x122 - V{0.99537037037037}*cell[26]) - x31*(cell[26] + V{0.00462962962962963}) + cell[26];
return { cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1}, V{0} };
}

};


template <typename... FIELDS>
struct P1::type<descriptors::D3Q7<FIELDS...>,momenta::P1Tuple,equilibria::P1> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x7 = parameters.template get<olb::collision::P1::SCATTERING>();
auto x8 = parameters.template get<olb::collision::P1::ABSORPTION>();
auto x9 = V{0.166666666666667}*cell[0];
auto x10 = x9 + V{0.166666666666667}*cell[3] + V{0.166666666666667}*cell[6];
auto x11 = V{0.166666666666667}*cell[2] + V{0.166666666666667}*cell[5];
auto x12 = x10 + x11;
auto x13 = V{1}*x7;
auto x14 = V{1}*x8;
auto x15 = V{0.166666666666667}*cell[1] + V{0.166666666666667}*cell[4];
auto x16 = x10 + x15;
auto x17 = x11 + x15 + x9;
cell[0] = cell[0];
cell[1] = x13*(x12 - V{0.666666666666667}*cell[1]) - x14*(cell[1] + V{0.166666666666667}) + cell[1];
cell[2] = x13*(x16 - V{0.666666666666667}*cell[2]) - x14*(cell[2] + V{0.166666666666667}) + cell[2];
cell[3] = x13*(x17 - V{0.666666666666667}*cell[3]) - x14*(cell[3] + V{0.166666666666667}) + cell[3];
cell[4] = x13*(x12 - V{0.666666666666667}*cell[4]) - x14*(cell[4] + V{0.166666666666667}) + cell[4];
cell[5] = x13*(x16 - V{0.666666666666667}*cell[5]) - x14*(cell[5] + V{0.166666666666667}) + cell[5];
cell[6] = x13*(x17 - V{0.666666666666667}*cell[6]) - x14*(cell[6] + V{0.166666666666667}) + cell[6];
return { cell[0] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct P1::type<descriptors::D3Q15<FIELDS...>,momenta::P1Tuple,equilibria::P1> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x16 = parameters.template get<olb::collision::P1::ABSORPTION>();
auto x15 = parameters.template get<olb::collision::P1::SCATTERING>();
auto x17 = V{0.133333333333333}*cell[7];
auto x18 = V{0.0666666666666667}*cell[0];
auto x19 = V{0.0666666666666667}*cell[3];
auto x20 = V{0.0666666666666667}*cell[10];
auto x21 = V{0.133333333333333}*cell[4];
auto x22 = V{0.133333333333333}*cell[5];
auto x23 = x18 + x19 + x20 + x21 + x22;
auto x24 = V{0.0666666666666667}*cell[2];
auto x25 = V{0.0666666666666667}*cell[9];
auto x26 = V{0.133333333333333}*cell[6];
auto x27 = x24 + x25 + x26;
auto x28 = V{1}*x15;
auto x29 = V{1}*x16;
auto x30 = V{0.133333333333333}*cell[13];
auto x31 = V{0.133333333333333}*cell[14];
auto x32 = x30 + x31;
auto x33 = V{0.0666666666666667}*cell[1] + V{0.0666666666666667}*cell[8];
auto x34 = x18 + V{0.133333333333333}*cell[12];
auto x35 = x33 + x34;
auto x36 = V{0.15}*cell[11];
auto x37 = V{0.075}*cell[0];
auto x38 = V{0.15}*cell[1];
auto x39 = V{0.15}*cell[2];
auto x40 = x37 + x38 + x39;
auto x41 = V{0.15}*cell[5];
auto x42 = V{0.15}*cell[6];
auto x43 = x41 + x42;
auto x44 = V{0.15}*cell[3];
auto x45 = V{0.15}*cell[14];
auto x46 = x44 + x45;
auto x47 = V{1.732051}*x15;
auto x48 = V{1.732051}*x16;
auto x49 = V{0.15}*cell[12];
auto x50 = V{0.15}*cell[4];
auto x51 = V{0.15}*cell[7];
auto x52 = x50 + x51;
auto x53 = V{0.15}*cell[10];
auto x54 = V{0.15}*cell[13];
auto x55 = x53 + x54;
auto x56 = x37 + V{0.15}*cell[9];
auto x57 = x38 + x56;
auto x58 = x44 + x49;
auto x59 = x36 + x53;
auto x60 = V{0.133333333333333}*cell[11];
auto x61 = x19 + x20 + x60;
auto x62 = x24 + x25;
auto x63 = V{0.15}*cell[8];
auto x64 = x56 + x63;
auto x65 = x37 + x39 + x63;
cell[0] = cell[0];
cell[1] = x28*(x17 + x23 + x27 - V{0.866666666666667}*cell[1]) - x29*(cell[1] + V{0.0666666666666667}) + cell[1];
cell[2] = x28*(x23 + x32 + x33 - V{0.866666666666667}*cell[2]) - x29*(cell[2] + V{0.0666666666666667}) + cell[2];
cell[3] = x28*(x21 + x27 + x31 + x35 - V{0.866666666666667}*cell[3]) - x29*(cell[3] + V{0.0666666666666667}) + cell[3];
cell[4] = x47*(-x36 + x40 + x43 + x46 - V{0.7}*cell[4]) - x48*(cell[4] + V{0.075}) + cell[4];
cell[5] = x47*(x40 - x49 + x52 + x55 - V{0.7}*cell[5]) - x48*(cell[5] + V{0.075}) + cell[5];
cell[6] = x47*(x52 - x54 + x57 + x58 - V{0.7}*cell[6]) - x48*(cell[6] + V{0.075}) + cell[6];
cell[7] = x47*(x43 - x45 + x57 + x59 - V{0.7}*cell[7]) - x48*(cell[7] + V{0.075}) + cell[7];
cell[8] = x28*(x32 + x34 + x61 + x62 - V{0.866666666666667}*cell[8]) - x29*(cell[8] + V{0.0666666666666667}) + cell[8];
cell[9] = x28*(x17 + x26 + x35 + x61 - V{0.866666666666667}*cell[9]) - x29*(cell[9] + V{0.0666666666666667}) + cell[9];
cell[10] = x28*(x17 + x18 + x22 + x30 + x33 + x60 + x62 - V{0.866666666666667}*cell[10]) - x29*(cell[10] + V{0.0666666666666667}) + cell[10];
cell[11] = x47*(x49 - x50 + x51 + x55 + x64 - V{0.7}*cell[11]) - x48*(cell[11] + V{0.075}) + cell[11];
cell[12] = x47*(x36 - x41 + x42 + x46 + x64 - V{0.7}*cell[12]) - x48*(cell[12] + V{0.075}) + cell[12];
cell[13] = x47*(x41 - x42 + x45 + x59 + x65 - V{0.7}*cell[13]) - x48*(cell[13] + V{0.075}) + cell[13];
cell[14] = x47*(x50 - x51 + x54 + x58 + x65 - V{0.7}*cell[14]) - x48*(cell[14] + V{0.075}) + cell[14];
return { cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[1] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1}, V{0} };
}

};

template <typename... FIELDS>
struct P1::type<descriptors::D3Q27<FIELDS...>,momenta::P1Tuple,equilibria::P1> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x27 = parameters.template get<olb::collision::P1::SCATTERING>();
auto x28 = parameters.template get<olb::collision::P1::ABSORPTION>();
auto x29 = V{0.0952380952380952}*cell[7];
auto x30 = V{0.0476190476190476}*cell[0];
auto x31 = V{0.0476190476190476}*cell[3];
auto x32 = V{0.0476190476190476}*cell[16];
auto x33 = V{0.0952380952380952}*cell[10];
auto x34 = V{0.0952380952380952}*cell[11];
auto x35 = x30 + x31 + x32 + x33 + x34 + V{0.0952380952380952}*cell[4];
auto x36 = V{0.0476190476190476}*cell[2];
auto x37 = V{0.0476190476190476}*cell[15];
auto x38 = V{0.0952380952380952}*cell[12];
auto x39 = x36 + x37 + x38 + V{0.0952380952380952}*cell[6];
auto x40 = V{0.0952380952380952}*cell[13];
auto x41 = x40 + V{0.0952380952380952}*cell[5];
auto x42 = V{0.0476190476190476}*cell[21] + V{0.0476190476190476}*cell[22] + V{0.0476190476190476}*cell[8] + V{0.0476190476190476}*cell[9];
auto x43 = V{1}*x27;
auto x44 = V{1}*x28;
auto x45 = V{0.0952380952380952}*cell[9];
auto x46 = V{0.0952380952380952}*cell[25];
auto x47 = V{0.0952380952380952}*cell[26];
auto x48 = x46 + x47 + V{0.0952380952380952}*cell[18];
auto x49 = V{0.0476190476190476}*cell[1];
auto x50 = V{0.0476190476190476}*cell[14];
auto x51 = x49 + x50 + V{0.0952380952380952}*cell[8];
auto x52 = V{0.0476190476190476}*cell[19] + V{0.0476190476190476}*cell[20] + V{0.0476190476190476}*cell[6] + V{0.0476190476190476}*cell[7];
auto x53 = V{0.0952380952380952}*cell[22];
auto x54 = V{0.0952380952380952}*cell[24];
auto x55 = x30 + x54 + V{0.0952380952380952}*cell[20];
auto x56 = V{0.0476190476190476}*cell[17] + V{0.0476190476190476}*cell[18] + V{0.0476190476190476}*cell[4] + V{0.0476190476190476}*cell[5];
auto x57 = V{0.0380952380952381}*cell[17];
auto x58 = V{0.0380952380952381}*cell[0];
auto x59 = V{0.0380952380952381}*cell[13];
auto x60 = V{0.0380952380952381}*cell[26];
auto x61 = V{0.0761904761904762}*cell[9];
auto x62 = x58 + x59 + x60 + x61;
auto x63 = V{0.0380952380952381}*cell[12];
auto x64 = V{0.0380952380952381}*cell[25];
auto x65 = V{0.0761904761904762}*cell[8];
auto x66 = x63 + x64 + x65;
auto x67 = V{0.0380952380952381}*cell[3];
auto x68 = V{0.0380952380952381}*cell[16];
auto x69 = V{0.0761904761904762}*cell[1];
auto x70 = V{0.0761904761904762}*cell[6];
auto x71 = V{0.0761904761904762}*cell[7];
auto x72 = x67 + x68 + x69 + x70 + x71;
auto x73 = V{0.0380952380952381}*cell[24];
auto x74 = -x73 + V{0.114285714285714}*cell[11];
auto x75 = V{0.0761904761904762}*cell[2];
auto x76 = V{0.0380952380952381}*cell[23];
auto x77 = -x76 + V{0.114285714285714}*cell[10];
auto x78 = x75 + x77;
auto x79 = V{0.0380952380952381}*cell[5];
auto x80 = V{0.0380952380952381}*cell[18];
auto x81 = x79 + x80;
auto x82 = V{1.414214}*x27;
auto x83 = V{1.414214}*x28;
auto x84 = V{0.0761904761904762}*cell[15];
auto x85 = V{0.0761904761904762}*cell[21];
auto x86 = V{0.0761904761904762}*cell[22];
auto x87 = x84 + x85 + x86;
auto x88 = V{0.114285714285714}*cell[12];
auto x89 = -x64;
auto x90 = V{0.0380952380952381}*cell[11];
auto x91 = x58 + x73 + x90;
auto x92 = x88 + x89 + x91;
auto x93 = V{0.114285714285714}*cell[13];
auto x94 = -x60;
auto x95 = V{0.0380952380952381}*cell[10];
auto x96 = x76 + x95;
auto x97 = x93 + x94 + x96;
auto x98 = V{0.0380952380952381}*cell[4];
auto x99 = x57 + x98;
auto x100 = V{0.0380952380952381}*cell[19];
auto x101 = V{0.0761904761904762}*cell[3];
auto x102 = V{0.0761904761904762}*cell[4];
auto x103 = x101 + x102;
auto x104 = V{0.0380952380952381}*cell[2];
auto x105 = V{0.0380952380952381}*cell[7];
auto x106 = V{0.0380952380952381}*cell[15];
auto x107 = V{0.0380952380952381}*cell[20];
auto x108 = x104 + x105 + x106 + x107;
auto x109 = V{0.0761904761904762}*cell[5];
auto x110 = x59 + x60;
auto x111 = x109 + x110;
auto x112 = V{0.0761904761904762}*cell[16];
auto x113 = x112 + x85;
auto x114 = x63 + x64;
auto x115 = x114 + x58;
auto x116 = x102 + x74;
auto x117 = V{0.0380952380952381}*cell[6];
auto x118 = x100 + x104 + x106 + x117;
auto x119 = V{0.0380952380952381}*cell[21];
auto x120 = V{0.0380952380952381}*cell[1];
auto x121 = V{0.0380952380952381}*cell[14];
auto x122 = V{0.0761904761904762}*cell[18];
auto x123 = x120 + x121 + x122;
auto x124 = V{0.0761904761904762}*cell[20];
auto x125 = -x59 + V{0.114285714285714}*cell[26];
auto x126 = x124 + x125 + x91;
auto x127 = V{0.0380952380952381}*cell[9];
auto x128 = V{0.0380952380952381}*cell[22];
auto x129 = x114 + x127 + x128;
auto x130 = V{0.0761904761904762}*cell[19];
auto x131 = x110 + x130;
auto x132 = x112 + x71;
auto x133 = V{0.0380952380952381}*cell[8];
auto x134 = x58 + x96;
auto x135 = x119 + x133 + x134;
auto x136 = -x63 + V{0.114285714285714}*cell[25];
auto x137 = x136 + x75;
auto x138 = V{0.0642857142857143}*cell[23];
auto x139 = V{0.0321428571428571}*cell[0];
auto x140 = V{0.0321428571428571}*cell[9];
auto x141 = V{0.0321428571428571}*cell[22];
auto x142 = V{0.0642857142857143}*cell[1];
auto x143 = V{0.0642857142857143}*cell[11];
auto x144 = V{0.0642857142857143}*cell[12];
auto x145 = x139 + x140 + x141 + x142 + x143 + x144;
auto x146 = V{0.0321428571428571}*cell[5];
auto x147 = V{0.0321428571428571}*cell[18];
auto x148 = V{0.0642857142857143}*cell[3];
auto x149 = V{0.0642857142857143}*cell[26];
auto x150 = x146 + x147 + x148 + x149;
auto x151 = V{0.0321428571428571}*cell[7];
auto x152 = V{0.0321428571428571}*cell[20];
auto x153 = V{0.0642857142857143}*cell[2];
auto x154 = x151 + x152 + x153;
auto x155 = V{0.0321428571428571}*cell[17];
auto x156 = -x155 + V{0.0964285714285714}*cell[4];
auto x157 = V{0.0321428571428571}*cell[19];
auto x158 = -x157 + V{0.0964285714285714}*cell[6];
auto x159 = V{0.0321428571428571}*cell[21];
auto x160 = -x159 + V{0.0964285714285714}*cell[8];
auto x161 = V{1.732051}*x27;
auto x162 = V{1.732051}*x28;
auto x163 = V{0.0642857142857143}*cell[24];
auto x164 = V{0.0321428571428571}*cell[6];
auto x165 = V{0.0642857142857143}*cell[16];
auto x166 = -x152 + x157 + x164 + x165 + V{0.0964285714285714}*cell[7];
auto x167 = V{0.0642857142857143}*cell[10];
auto x168 = V{0.0642857142857143}*cell[13];
auto x169 = V{0.0321428571428571}*cell[8];
auto x170 = x139 + x159 + x169;
auto x171 = x142 + x167 + x168 + x170;
auto x172 = V{0.0642857142857143}*cell[25];
auto x173 = x146 + x147 + x172;
auto x174 = -x141 + V{0.0964285714285714}*cell[9];
auto x175 = V{0.0642857142857143}*cell[15];
auto x176 = -x140 + x175 + V{0.0964285714285714}*cell[22];
auto x177 = x151 + x152 + x163;
auto x178 = V{0.0321428571428571}*cell[4];
auto x179 = x155 + x178;
auto x180 = x148 + x179;
auto x181 = -x147 + V{0.0964285714285714}*cell[5];
auto x182 = x138 + x179;
auto x183 = -x169 + x175 + V{0.0964285714285714}*cell[21];
auto x184 = V{0.0952380952380952}*cell[23];
auto x185 = x184 + x31 + x32 + V{0.0952380952380952}*cell[17];
auto x186 = x36 + x37 + V{0.0952380952380952}*cell[19];
auto x187 = x30 + x49 + x50 + V{0.0952380952380952}*cell[21];
auto x188 = -x95 + V{0.114285714285714}*cell[23];
auto x189 = V{0.0761904761904762}*cell[14];
auto x190 = x189 + x67 + x68;
auto x191 = -x90 + V{0.114285714285714}*cell[24];
auto x192 = x124 + x191;
auto x193 = V{0.0761904761904762}*cell[17];
auto x194 = x188 + x193;
auto x195 = x122 + x189;
auto x196 = x101 + x193;
auto x197 = x120 + x121 + x84;
auto x198 = V{0.0642857142857143}*cell[14];
auto x199 = -x178 + x198 + V{0.0964285714285714}*cell[17];
auto x200 = -x164 + x165 + V{0.0964285714285714}*cell[19];
auto x201 = x139 + x140 + x141;
auto x202 = -x151 + x157 + x164 + V{0.0964285714285714}*cell[20];
auto x203 = -x146 + x198 + V{0.0964285714285714}*cell[18];
cell[0] = cell[0];
cell[1] = x43*(x29 + x35 + x39 + x41 + x42 - V{0.904761904761905}*cell[1]) - x44*(cell[1] + V{0.0476190476190476}) + cell[1];
cell[2] = x43*(x35 + x45 + x48 + x51 + x52 - V{0.904761904761905}*cell[2]) - x44*(cell[2] + V{0.0476190476190476}) + cell[2];
cell[3] = x43*(x33 + x39 + x47 + x51 + x53 + x55 + x56 - V{0.904761904761905}*cell[3]) - x44*(cell[3] + V{0.0476190476190476}) + cell[3];
cell[4] = x82*(-x57 + x62 + x66 + x72 + x74 + x78 + x81 - V{0.885714285714286}*cell[4]) - x83*(cell[4] + V{0.0380952380952381}) + cell[4];
cell[5] = x82*(x72 - x80 + x87 + x92 + x97 + x99 - V{0.885714285714286}*cell[5]) - x83*(cell[5] + V{0.0380952380952381}) + cell[5];
cell[6] = x82*(-x100 + x103 + x108 + x111 + x65 + x69 + x77 + x86 + x92 - V{0.885714285714286}*cell[6]) - x83*(cell[6] + V{0.0380952380952381}) + cell[6];
cell[7] = x82*(-x107 + x109 + x113 + x115 + x116 + x118 + x61 + x69 + x97 - V{0.885714285714286}*cell[7]) - x83*(cell[7] + V{0.0380952380952381}) + cell[7];
cell[8] = x82*(x103 - x119 + x123 + x126 + x129 + x70 + x78 - V{0.885714285714286}*cell[8]) - x83*(cell[8] + V{0.0380952380952381}) + cell[8];
cell[9] = x82*(x116 + x123 - x128 + x131 + x132 + x135 + x137 - V{0.885714285714286}*cell[9]) - x83*(cell[9] + V{0.0380952380952381}) + cell[9];
cell[10] = x161*(-x138 + x145 + x150 + x154 + x156 + x158 + x160 - V{0.871428571428571}*cell[10]) - x162*(cell[10] + V{0.0321428571428571}) + cell[10];
cell[11] = x161*(x153 + x156 - x163 + x166 + x171 + x173 + x174 - V{0.871428571428571}*cell[11]) - x162*(cell[11] + V{0.0321428571428571}) + cell[11];
cell[12] = x161*(x158 + x171 - x172 + x176 + x177 + x180 + x181 - V{0.871428571428571}*cell[12]) - x162*(cell[12] + V{0.0321428571428571}) + cell[12];
cell[13] = x161*(x145 - x149 + x166 + x181 + x182 + x183 - V{0.871428571428571}*cell[13]) - x162*(cell[13] + V{0.0321428571428571}) + cell[13];
cell[14] = x43*(x185 + x186 + x42 + x48 + x55 - V{0.904761904761905}*cell[14]) - x44*(cell[14] + V{0.0476190476190476}) + cell[14];
cell[15] = x43*(x185 + x187 + x38 + x41 + x52 + x53 + x54 - V{0.904761904761905}*cell[15]) - x44*(cell[15] + V{0.0476190476190476}) + cell[15];
cell[16] = x43*(x184 + x186 + x187 + x29 + x34 + x40 + x45 + x46 + x56 - V{0.904761904761905}*cell[16]) - x44*(cell[16] + V{0.0476190476190476}) + cell[16];
cell[17] = x82*(x115 + x131 + x188 + x190 + x192 + x81 + x87 - x98 - V{0.885714285714286}*cell[17]) - x83*(cell[17] + V{0.0380952380952381}) + cell[17];
cell[18] = x82*(x126 + x130 + x137 + x190 + x61 + x65 - x79 + x96 + x99 - V{0.885714285714286}*cell[18]) - x83*(cell[18] + V{0.0380952380952381}) + cell[18];
cell[19] = x82*(x108 + x113 - x117 + x136 + x194 + x195 + x62 + x73 + x90 - V{0.885714285714286}*cell[19]) - x83*(cell[19] + V{0.0380952380952381}) + cell[19];
cell[20] = x82*(-x105 + x118 + x125 + x134 + x191 + x195 + x196 + x66 + x86 - V{0.885714285714286}*cell[20]) - x83*(cell[20] + V{0.0380952380952381}) + cell[20];
cell[21] = x82*(x109 + x129 + x130 + x132 - x133 + x194 + x197 + x91 + x93 + x94 - V{0.885714285714286}*cell[21]) - x83*(cell[21] + V{0.0380952380952381}) + cell[21];
cell[22] = x82*(x111 - x127 + x135 + x192 + x196 + x197 + x70 + x88 + x89 - V{0.885714285714286}*cell[22]) - x83*(cell[22] + V{0.0380952380952381}) + cell[22];
cell[23] = x161*(-x167 + x168 + x173 + x177 + x183 + x199 + x200 + x201 - V{0.871428571428571}*cell[23]) - x162*(cell[23] + V{0.0321428571428571}) + cell[23];
cell[24] = x161*(x138 - x143 + x144 + x150 + x170 + x176 + x199 + x202 - V{0.871428571428571}*cell[24]) - x162*(cell[24] + V{0.0321428571428571}) + cell[24];
cell[25] = x161*(x143 - x144 + x149 + x154 + x170 + x174 + x182 + x200 + x203 - V{0.871428571428571}*cell[25]) - x162*(cell[25] + V{0.0321428571428571}) + cell[25];
cell[26] = x161*(x153 + x160 + x163 + x167 - x168 + x172 + x180 + x201 + x202 + x203 - V{0.871428571428571}*cell[26]) - x162*(cell[26] + V{0.0321428571428571}) + cell[26];
return { cell[0] + cell[10] + cell[11] + cell[12] + cell[13] + cell[14] + cell[15] + cell[16] + cell[17] + cell[18] + cell[19] + cell[1] + cell[20] + cell[21] + cell[22] + cell[23] + cell[24] + cell[25] + cell[26] + cell[2] + cell[3] + cell[4] + cell[5] + cell[6] + cell[7] + cell[8] + cell[9] + V{1}, V{0} };
}

};


template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<0,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = -x19;
auto x25 = cell[0] + cell[11] + cell[12] + cell[17] + cell[18] + V{2}*cell[1] + cell[2] + cell[3] + V{2}*cell[4] + V{2}*cell[5] + V{2}*cell[6] + V{2}*cell[7] + cell[8] + cell[9] + V{1};
auto x26 = x25/(x24 + V{1});
auto x27 = x19*x19;
auto x28 = -V{1.5}*x27;
auto x29 = x20*x20;
auto x30 = -V{1.5}*x29;
auto x31 = x21*x21;
auto x32 = -V{1.5}*x31;
auto x33 = x30 + x32 + V{1};
auto x34 = x28 + x33;
auto x35 = V{0.0555555555555556}*x22;
auto x36 = V{3}*x19;
auto x37 = -x36;
auto x38 = V{3}*x27 + x33;
auto x39 = V{3}*x20;
auto x40 = -x39;
auto x41 = x28 + V{1};
auto x42 = V{3}*x29 + x32 + x41;
auto x43 = V{3}*x21;
auto x44 = -x43;
auto x45 = x30 + V{3}*x31 + x41;
auto x46 = V{0.0277777777777778}*x22;
auto x47 = x19 + x20;
auto x48 = V{4.5}*(x47*x47);
auto x49 = x34 + x37;
auto x50 = x20 + x24;
auto x51 = x19 + x21;
auto x52 = V{4.5}*(x51*x51);
auto x53 = x21 + x24;
auto x54 = x20 + x21;
auto x55 = V{4.5}*(x54*x54);
auto x56 = x34 + x40;
auto x57 = -x20;
auto x58 = x21 + x57;
auto x59 = x34 + x36;
auto x60 = x19 + x57;
auto x61 = -x21;
auto x62 = x19 + x61;
auto x63 = x34 + x39;
auto x64 = x20 + x61;
cell[0] = -V{0.333333333333333}*x22*(-x26*x34 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x35*(-x26*(x37 + x38) + V{1});
cell[2] = -x23*cell[2] - x35*(-x26*(x40 + x42) + V{1});
cell[3] = -x23*cell[3] - x35*(-x26*(x44 + x45) + V{1});
cell[4] = -x23*cell[4] - x46*(-x26*(x40 + x48 + x49) + V{1});
cell[5] = -x23*cell[5] - x46*(-x26*(x39 + x49 + V{4.5}*(x50*x50)) + V{1});
cell[6] = -x23*cell[6] - x46*(-x26*(x44 + x49 + x52) + V{1});
cell[7] = -x23*cell[7] - x46*(-x26*(x43 + x49 + V{4.5}*(x53*x53)) + V{1});
cell[8] = -x23*cell[8] - x46*(-x26*(x44 + x55 + x56) + V{1});
cell[9] = -x23*cell[9] - x46*(-x26*(x43 + x56 + V{4.5}*(x58*x58)) + V{1});
cell[10] = -x23*cell[10] - x35*(-x26*(x36 + x38) + V{1});
cell[11] = -x23*cell[11] - x35*(-x26*(x39 + x42) + V{1});
cell[12] = -x23*cell[12] - x35*(-x26*(x43 + x45) + V{1});
cell[13] = -x23*cell[13] - x46*(-x26*(x39 + x48 + x59) + V{1});
cell[14] = -x23*cell[14] - x46*(-x26*(x36 + x56 + V{4.5}*(x60*x60)) + V{1});
cell[15] = -x23*cell[15] - x46*(-x26*(x43 + x52 + x59) + V{1});
cell[16] = -x23*cell[16] - x46*(-x26*(x44 + x59 + V{4.5}*(x62*x62)) + V{1});
cell[17] = -x23*cell[17] - x46*(-x26*(x43 + x55 + x63) + V{1});
cell[18] = -x23*cell[18] - x46*(-x26*(x44 + x63 + V{4.5}*(x64*x64)) + V{1});
return { -V{1}*x25/(x19 - 1), x27 + x29 + x31 };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<0,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = (cell[0] + V{2}*cell[10] + cell[11] + cell[12] + V{2}*cell[13] + V{2}*cell[14] + V{2}*cell[15] + V{2}*cell[16] + cell[17] + cell[18] + cell[2] + cell[3] + cell[8] + cell[9] + V{1})/(x19 + V{1});
auto x25 = x19*x19;
auto x26 = -V{1.5}*x25;
auto x27 = x20*x20;
auto x28 = -V{1.5}*x27;
auto x29 = x21*x21;
auto x30 = -V{1.5}*x29;
auto x31 = x28 + x30 + V{1};
auto x32 = x26 + x31;
auto x33 = V{0.0555555555555556}*x22;
auto x34 = V{3}*x19;
auto x35 = -x34;
auto x36 = V{3}*x25 + x31;
auto x37 = V{3}*x20;
auto x38 = -x37;
auto x39 = x26 + V{1};
auto x40 = V{3}*x27 + x30 + x39;
auto x41 = V{3}*x21;
auto x42 = -x41;
auto x43 = x28 + V{3}*x29 + x39;
auto x44 = V{0.0277777777777778}*x22;
auto x45 = x19 + x20;
auto x46 = V{4.5}*(x45*x45);
auto x47 = x32 + x35;
auto x48 = -x19;
auto x49 = x20 + x48;
auto x50 = x19 + x21;
auto x51 = V{4.5}*(x50*x50);
auto x52 = x21 + x48;
auto x53 = x20 + x21;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x32 + x38;
auto x56 = -x20;
auto x57 = x21 + x56;
auto x58 = x32 + x34;
auto x59 = x19 + x56;
auto x60 = -x21;
auto x61 = x19 + x60;
auto x62 = x32 + x37;
auto x63 = x20 + x60;
cell[0] = -V{0.333333333333333}*x22*(-x24*x32 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x33*(-x24*(x35 + x36) + V{1});
cell[2] = -x23*cell[2] - x33*(-x24*(x38 + x40) + V{1});
cell[3] = -x23*cell[3] - x33*(-x24*(x42 + x43) + V{1});
cell[4] = -x23*cell[4] - x44*(-x24*(x38 + x46 + x47) + V{1});
cell[5] = -x23*cell[5] - x44*(-x24*(x37 + x47 + V{4.5}*(x49*x49)) + V{1});
cell[6] = -x23*cell[6] - x44*(-x24*(x42 + x47 + x51) + V{1});
cell[7] = -x23*cell[7] - x44*(-x24*(x41 + x47 + V{4.5}*(x52*x52)) + V{1});
cell[8] = -x23*cell[8] - x44*(-x24*(x42 + x54 + x55) + V{1});
cell[9] = -x23*cell[9] - x44*(-x24*(x41 + x55 + V{4.5}*(x57*x57)) + V{1});
cell[10] = -x23*cell[10] - x33*(-x24*(x34 + x36) + V{1});
cell[11] = -x23*cell[11] - x33*(-x24*(x37 + x40) + V{1});
cell[12] = -x23*cell[12] - x33*(-x24*(x41 + x43) + V{1});
cell[13] = -x23*cell[13] - x44*(-x24*(x37 + x46 + x58) + V{1});
cell[14] = -x23*cell[14] - x44*(-x24*(x34 + x55 + V{4.5}*(x59*x59)) + V{1});
cell[15] = -x23*cell[15] - x44*(-x24*(x41 + x51 + x58) + V{1});
cell[16] = -x23*cell[16] - x44*(-x24*(x42 + x58 + V{4.5}*(x61*x61)) + V{1});
cell[17] = -x23*cell[17] - x44*(-x24*(x41 + x54 + x62) + V{1});
cell[18] = -x23*cell[18] - x44*(-x24*(x42 + x62 + V{4.5}*(x63*x63)) + V{1});
return { V{1}*x24, x25 + x27 + x29 };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<1,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = -x20;
auto x25 = cell[0] + cell[10] + cell[12] + V{2}*cell[14] + cell[15] + cell[16] + cell[1] + V{2}*cell[2] + cell[3] + V{2}*cell[4] + cell[6] + cell[7] + V{2}*cell[8] + V{2}*cell[9] + V{1};
auto x26 = x25/(x24 + V{1});
auto x27 = x19*x19;
auto x28 = -V{1.5}*x27;
auto x29 = x20*x20;
auto x30 = -V{1.5}*x29;
auto x31 = x21*x21;
auto x32 = -V{1.5}*x31;
auto x33 = x30 + x32 + V{1};
auto x34 = x28 + x33;
auto x35 = V{0.0555555555555556}*x22;
auto x36 = V{3}*x19;
auto x37 = -x36;
auto x38 = V{3}*x27 + x33;
auto x39 = V{3}*x20;
auto x40 = -x39;
auto x41 = x28 + V{1};
auto x42 = V{3}*x29 + x32 + x41;
auto x43 = V{3}*x21;
auto x44 = -x43;
auto x45 = x30 + V{3}*x31 + x41;
auto x46 = V{0.0277777777777778}*x22;
auto x47 = x19 + x20;
auto x48 = V{4.5}*(x47*x47);
auto x49 = x34 + x37;
auto x50 = -x19;
auto x51 = x20 + x50;
auto x52 = x19 + x21;
auto x53 = V{4.5}*(x52*x52);
auto x54 = x21 + x50;
auto x55 = x20 + x21;
auto x56 = V{4.5}*(x55*x55);
auto x57 = x34 + x40;
auto x58 = x21 + x24;
auto x59 = x34 + x36;
auto x60 = x19 + x24;
auto x61 = -x21;
auto x62 = x19 + x61;
auto x63 = x34 + x39;
auto x64 = x20 + x61;
cell[0] = -V{0.333333333333333}*x22*(-x26*x34 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x35*(-x26*(x37 + x38) + V{1});
cell[2] = -x23*cell[2] - x35*(-x26*(x40 + x42) + V{1});
cell[3] = -x23*cell[3] - x35*(-x26*(x44 + x45) + V{1});
cell[4] = -x23*cell[4] - x46*(-x26*(x40 + x48 + x49) + V{1});
cell[5] = -x23*cell[5] - x46*(-x26*(x39 + x49 + V{4.5}*(x51*x51)) + V{1});
cell[6] = -x23*cell[6] - x46*(-x26*(x44 + x49 + x53) + V{1});
cell[7] = -x23*cell[7] - x46*(-x26*(x43 + x49 + V{4.5}*(x54*x54)) + V{1});
cell[8] = -x23*cell[8] - x46*(-x26*(x44 + x56 + x57) + V{1});
cell[9] = -x23*cell[9] - x46*(-x26*(x43 + x57 + V{4.5}*(x58*x58)) + V{1});
cell[10] = -x23*cell[10] - x35*(-x26*(x36 + x38) + V{1});
cell[11] = -x23*cell[11] - x35*(-x26*(x39 + x42) + V{1});
cell[12] = -x23*cell[12] - x35*(-x26*(x43 + x45) + V{1});
cell[13] = -x23*cell[13] - x46*(-x26*(x39 + x48 + x59) + V{1});
cell[14] = -x23*cell[14] - x46*(-x26*(x36 + x57 + V{4.5}*(x60*x60)) + V{1});
cell[15] = -x23*cell[15] - x46*(-x26*(x43 + x53 + x59) + V{1});
cell[16] = -x23*cell[16] - x46*(-x26*(x44 + x59 + V{4.5}*(x62*x62)) + V{1});
cell[17] = -x23*cell[17] - x46*(-x26*(x43 + x56 + x63) + V{1});
cell[18] = -x23*cell[18] - x46*(-x26*(x44 + x63 + V{4.5}*(x64*x64)) + V{1});
return { -V{1}*x25/(x20 - 1), x27 + x29 + x31 };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<1,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = (cell[0] + cell[10] + V{2}*cell[11] + cell[12] + V{2}*cell[13] + cell[15] + cell[16] + V{2}*cell[17] + V{2}*cell[18] + cell[1] + cell[3] + V{2}*cell[5] + cell[6] + cell[7] + V{1})/(x20 + V{1});
auto x25 = x19*x19;
auto x26 = -V{1.5}*x25;
auto x27 = x20*x20;
auto x28 = -V{1.5}*x27;
auto x29 = x21*x21;
auto x30 = -V{1.5}*x29;
auto x31 = x28 + x30 + V{1};
auto x32 = x26 + x31;
auto x33 = V{0.0555555555555556}*x22;
auto x34 = V{3}*x19;
auto x35 = -x34;
auto x36 = V{3}*x25 + x31;
auto x37 = V{3}*x20;
auto x38 = -x37;
auto x39 = x26 + V{1};
auto x40 = V{3}*x27 + x30 + x39;
auto x41 = V{3}*x21;
auto x42 = -x41;
auto x43 = x28 + V{3}*x29 + x39;
auto x44 = V{0.0277777777777778}*x22;
auto x45 = x19 + x20;
auto x46 = V{4.5}*(x45*x45);
auto x47 = x32 + x35;
auto x48 = -x19;
auto x49 = x20 + x48;
auto x50 = x19 + x21;
auto x51 = V{4.5}*(x50*x50);
auto x52 = x21 + x48;
auto x53 = x20 + x21;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x32 + x38;
auto x56 = -x20;
auto x57 = x21 + x56;
auto x58 = x32 + x34;
auto x59 = x19 + x56;
auto x60 = -x21;
auto x61 = x19 + x60;
auto x62 = x32 + x37;
auto x63 = x20 + x60;
cell[0] = -V{0.333333333333333}*x22*(-x24*x32 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x33*(-x24*(x35 + x36) + V{1});
cell[2] = -x23*cell[2] - x33*(-x24*(x38 + x40) + V{1});
cell[3] = -x23*cell[3] - x33*(-x24*(x42 + x43) + V{1});
cell[4] = -x23*cell[4] - x44*(-x24*(x38 + x46 + x47) + V{1});
cell[5] = -x23*cell[5] - x44*(-x24*(x37 + x47 + V{4.5}*(x49*x49)) + V{1});
cell[6] = -x23*cell[6] - x44*(-x24*(x42 + x47 + x51) + V{1});
cell[7] = -x23*cell[7] - x44*(-x24*(x41 + x47 + V{4.5}*(x52*x52)) + V{1});
cell[8] = -x23*cell[8] - x44*(-x24*(x42 + x54 + x55) + V{1});
cell[9] = -x23*cell[9] - x44*(-x24*(x41 + x55 + V{4.5}*(x57*x57)) + V{1});
cell[10] = -x23*cell[10] - x33*(-x24*(x34 + x36) + V{1});
cell[11] = -x23*cell[11] - x33*(-x24*(x37 + x40) + V{1});
cell[12] = -x23*cell[12] - x33*(-x24*(x41 + x43) + V{1});
cell[13] = -x23*cell[13] - x44*(-x24*(x37 + x46 + x58) + V{1});
cell[14] = -x23*cell[14] - x44*(-x24*(x34 + x55 + V{4.5}*(x59*x59)) + V{1});
cell[15] = -x23*cell[15] - x44*(-x24*(x41 + x51 + x58) + V{1});
cell[16] = -x23*cell[16] - x44*(-x24*(x42 + x58 + V{4.5}*(x61*x61)) + V{1});
cell[17] = -x23*cell[17] - x44*(-x24*(x41 + x54 + x62) + V{1});
cell[18] = -x23*cell[18] - x44*(-x24*(x42 + x62 + V{4.5}*(x63*x63)) + V{1});
return { V{1}*x24, x25 + x27 + x29 };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<2,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = -x21;
auto x25 = cell[0] + cell[10] + cell[11] + cell[13] + cell[14] + V{2}*cell[16] + V{2}*cell[18] + cell[1] + cell[2] + V{2}*cell[3] + cell[4] + cell[5] + V{2}*cell[6] + V{2}*cell[8] + V{1};
auto x26 = x25/(x24 + V{1});
auto x27 = x19*x19;
auto x28 = -V{1.5}*x27;
auto x29 = x20*x20;
auto x30 = -V{1.5}*x29;
auto x31 = x21*x21;
auto x32 = -V{1.5}*x31;
auto x33 = x30 + x32 + V{1};
auto x34 = x28 + x33;
auto x35 = V{0.0555555555555556}*x22;
auto x36 = V{3}*x19;
auto x37 = -x36;
auto x38 = V{3}*x27 + x33;
auto x39 = V{3}*x20;
auto x40 = -x39;
auto x41 = x28 + V{1};
auto x42 = V{3}*x29 + x32 + x41;
auto x43 = V{3}*x21;
auto x44 = -x43;
auto x45 = x30 + V{3}*x31 + x41;
auto x46 = V{0.0277777777777778}*x22;
auto x47 = x19 + x20;
auto x48 = V{4.5}*(x47*x47);
auto x49 = x34 + x37;
auto x50 = -x19;
auto x51 = x20 + x50;
auto x52 = x19 + x21;
auto x53 = V{4.5}*(x52*x52);
auto x54 = x21 + x50;
auto x55 = x20 + x21;
auto x56 = V{4.5}*(x55*x55);
auto x57 = x34 + x40;
auto x58 = -x20;
auto x59 = x21 + x58;
auto x60 = x34 + x36;
auto x61 = x19 + x58;
auto x62 = x19 + x24;
auto x63 = x34 + x39;
auto x64 = x20 + x24;
cell[0] = -V{0.333333333333333}*x22*(-x26*x34 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x35*(-x26*(x37 + x38) + V{1});
cell[2] = -x23*cell[2] - x35*(-x26*(x40 + x42) + V{1});
cell[3] = -x23*cell[3] - x35*(-x26*(x44 + x45) + V{1});
cell[4] = -x23*cell[4] - x46*(-x26*(x40 + x48 + x49) + V{1});
cell[5] = -x23*cell[5] - x46*(-x26*(x39 + x49 + V{4.5}*(x51*x51)) + V{1});
cell[6] = -x23*cell[6] - x46*(-x26*(x44 + x49 + x53) + V{1});
cell[7] = -x23*cell[7] - x46*(-x26*(x43 + x49 + V{4.5}*(x54*x54)) + V{1});
cell[8] = -x23*cell[8] - x46*(-x26*(x44 + x56 + x57) + V{1});
cell[9] = -x23*cell[9] - x46*(-x26*(x43 + x57 + V{4.5}*(x59*x59)) + V{1});
cell[10] = -x23*cell[10] - x35*(-x26*(x36 + x38) + V{1});
cell[11] = -x23*cell[11] - x35*(-x26*(x39 + x42) + V{1});
cell[12] = -x23*cell[12] - x35*(-x26*(x43 + x45) + V{1});
cell[13] = -x23*cell[13] - x46*(-x26*(x39 + x48 + x60) + V{1});
cell[14] = -x23*cell[14] - x46*(-x26*(x36 + x57 + V{4.5}*(x61*x61)) + V{1});
cell[15] = -x23*cell[15] - x46*(-x26*(x43 + x53 + x60) + V{1});
cell[16] = -x23*cell[16] - x46*(-x26*(x44 + x60 + V{4.5}*(x62*x62)) + V{1});
cell[17] = -x23*cell[17] - x46*(-x26*(x43 + x56 + x63) + V{1});
cell[18] = -x23*cell[18] - x46*(-x26*(x44 + x63 + V{4.5}*(x64*x64)) + V{1});
return { -V{1}*x25/(x21 - 1), x27 + x29 + x31 };
}

};

template <typename... FIELDS>
struct BGK::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<2,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = (cell[0] + cell[10] + cell[11] + V{2}*cell[12] + cell[13] + cell[14] + V{2}*cell[15] + V{2}*cell[17] + cell[1] + cell[2] + cell[4] + cell[5] + V{2}*cell[7] + V{2}*cell[9] + V{1})/(x21 + V{1});
auto x25 = x19*x19;
auto x26 = -V{1.5}*x25;
auto x27 = x20*x20;
auto x28 = -V{1.5}*x27;
auto x29 = x21*x21;
auto x30 = -V{1.5}*x29;
auto x31 = x28 + x30 + V{1};
auto x32 = x26 + x31;
auto x33 = V{0.0555555555555556}*x22;
auto x34 = V{3}*x19;
auto x35 = -x34;
auto x36 = V{3}*x25 + x31;
auto x37 = V{3}*x20;
auto x38 = -x37;
auto x39 = x26 + V{1};
auto x40 = V{3}*x27 + x30 + x39;
auto x41 = V{3}*x21;
auto x42 = -x41;
auto x43 = x28 + V{3}*x29 + x39;
auto x44 = V{0.0277777777777778}*x22;
auto x45 = x19 + x20;
auto x46 = V{4.5}*(x45*x45);
auto x47 = x32 + x35;
auto x48 = -x19;
auto x49 = x20 + x48;
auto x50 = x19 + x21;
auto x51 = V{4.5}*(x50*x50);
auto x52 = x21 + x48;
auto x53 = x20 + x21;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x32 + x38;
auto x56 = -x20;
auto x57 = x21 + x56;
auto x58 = x32 + x34;
auto x59 = x19 + x56;
auto x60 = -x21;
auto x61 = x19 + x60;
auto x62 = x32 + x37;
auto x63 = x20 + x60;
cell[0] = -V{0.333333333333333}*x22*(-x24*x32 + V{1}) - x23*cell[0];
cell[1] = -x23*cell[1] - x33*(-x24*(x35 + x36) + V{1});
cell[2] = -x23*cell[2] - x33*(-x24*(x38 + x40) + V{1});
cell[3] = -x23*cell[3] - x33*(-x24*(x42 + x43) + V{1});
cell[4] = -x23*cell[4] - x44*(-x24*(x38 + x46 + x47) + V{1});
cell[5] = -x23*cell[5] - x44*(-x24*(x37 + x47 + V{4.5}*(x49*x49)) + V{1});
cell[6] = -x23*cell[6] - x44*(-x24*(x42 + x47 + x51) + V{1});
cell[7] = -x23*cell[7] - x44*(-x24*(x41 + x47 + V{4.5}*(x52*x52)) + V{1});
cell[8] = -x23*cell[8] - x44*(-x24*(x42 + x54 + x55) + V{1});
cell[9] = -x23*cell[9] - x44*(-x24*(x41 + x55 + V{4.5}*(x57*x57)) + V{1});
cell[10] = -x23*cell[10] - x33*(-x24*(x34 + x36) + V{1});
cell[11] = -x23*cell[11] - x33*(-x24*(x37 + x40) + V{1});
cell[12] = -x23*cell[12] - x33*(-x24*(x41 + x43) + V{1});
cell[13] = -x23*cell[13] - x44*(-x24*(x37 + x46 + x58) + V{1});
cell[14] = -x23*cell[14] - x44*(-x24*(x34 + x55 + V{4.5}*(x59*x59)) + V{1});
cell[15] = -x23*cell[15] - x44*(-x24*(x41 + x51 + x58) + V{1});
cell[16] = -x23*cell[16] - x44*(-x24*(x42 + x58 + V{4.5}*(x61*x61)) + V{1});
cell[17] = -x23*cell[17] - x44*(-x24*(x41 + x54 + x62) + V{1});
cell[18] = -x23*cell[18] - x44*(-x24*(x42 + x62 + V{4.5}*(x63*x63)) + V{1});
return { V{1}*x24, x25 + x27 + x29 };
}

};


template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<0,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[4] + V{2}*cell[5] + V{2}*cell[6] + V{2}*cell[7];
auto x25 = (x24 + cell[0] + cell[11] + cell[12] + cell[17] + cell[18] + V{2}*cell[1] + cell[2] + cell[3] + cell[8] + cell[9] + V{1})/(x19 + V{-1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = x20 + x21;
auto x28 = V{4.5}*(x27*x27);
auto x29 = V{3}*x20;
auto x30 = x21*x21;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x19*x19;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = V{3}*x21;
auto x39 = x20*x20;
auto x40 = V{1.5}*x39;
auto x41 = -x40;
auto x42 = x38 + x41;
auto x43 = x28 + x37 + x42;
auto x44 = x26*x43;
auto x45 = V{3}*x39;
auto x46 = x37 + x45;
auto x47 = V{3}*x30;
auto x48 = x35 + x42 + x47;
auto x49 = x34 + x40 + V{-1};
auto x50 = x38 - x47 + x49;
auto x51 = x31 + V{-1};
auto x52 = x29 + x34 - x45 + x51;
auto x53 = x31 + x49;
auto x54 = x29 + x53;
auto x55 = -x28 + x38 + x54;
auto x56 = x26*x55;
auto x57 = -x38;
auto x58 = -x20;
auto x59 = x21 + x58;
auto x60 = x54 + x57 - V{4.5}*x59*x59;
auto x61 = x26*x60;
auto x62 = -x29;
auto x63 = -x21;
auto x64 = x20 + x63;
auto x65 = x38 + x53;
auto x66 = x62 + x65 - V{4.5}*x64*x64;
auto x67 = x26*x66;
auto x68 = V{0.0555555555555556}*x25;
auto x69 = V{3}*x19;
auto x70 = V{3}*x33;
auto x71 = x40 + x51 + x69 - x70;
auto x72 = x68*x71;
auto x73 = x19 + x20;
auto x74 = V{4.5}*(x73*x73);
auto x75 = x54 + x69 - x74;
auto x76 = x19 + x21;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x65 + x69 - x77;
auto x79 = -x19;
auto x80 = x20 + x79;
auto x81 = x53 + x69;
auto x82 = x62 + x81 - V{4.5}*x80*x80;
auto x83 = x21 + x79;
auto x84 = x57 + x81 - V{4.5}*x83*x83;
auto x85 = V{0.00462962962962963}*x25;
auto x86 = V{0.00462962962962963}*x25;
auto x87 = -x48*x85 + x50*x85 - x75*x86 - x82*x86 - V{0.0833333333333333}*cell[12] - V{0.0833333333333333}*cell[3] + V{0.166666666666667}*cell[4] + V{0.166666666666667}*cell[5] + V{6.93889390390723e-18};
auto x88 = -x46*x85 + x52*x85 - x78*x86 - x84*x86 - V{0.0833333333333333}*cell[11] - V{0.0833333333333333}*cell[2] + V{0.166666666666667}*cell[6] + V{0.166666666666667}*cell[7];
auto x89 = x23*(-V{0.0185185185185185}*x25*x71 - x43*x85 + x55*x85 + x60*x85 + x66*x85 + x87 + x88 - V{0.166666666666667}*cell[17] - V{0.166666666666667}*cell[18] + V{0.333333333333333}*cell[1] - V{0.166666666666667}*cell[8] - V{0.166666666666667}*cell[9]);
auto x90 = V{0.00925925925925926}*x25;
auto x91 = V{0.00925925925925926}*x25;
auto x92 = V{0.00231481481481482}*x25;
auto x93 = x43*x92 - x55*x92 - x60*x92 - x66*x92 + x71*x90 + V{0.0833333333333334}*cell[17] + V{0.0833333333333334}*cell[18] - V{0.166666666666667}*cell[1] + V{0.0833333333333334}*cell[8] + V{0.0833333333333334}*cell[9];
auto x94 = x23*(x46*x91 - x52*x91 + x78*x90 + x84*x90 + x87 + x93 + V{0.166666666666667}*cell[11] + V{0.166666666666667}*cell[2] - V{0.333333333333333}*cell[6] - V{0.333333333333333}*cell[7]);
auto x95 = x23*(x48*x91 - x50*x91 + x75*x90 + x82*x90 + x88 + x93 + V{0.166666666666667}*cell[12] + V{0.166666666666667}*cell[3] - V{0.333333333333333}*cell[4] - V{0.333333333333333}*cell[5] + V{6.93889390390723e-18});
auto x96 = V{0.00462962962962963}*x25;
auto x97 = V{0.0231481481481481}*x25;
auto x98 = V{0.00231481481481481}*x25;
auto x99 = V{0.00462962962962963}*x25;
auto x100 = x46*x99 - x52*x99 - x78*x92 - x84*x92 + V{0.0833333333333333}*cell[11] + V{0.0833333333333333}*cell[2] + V{0.0833333333333334}*cell[6] + V{0.0833333333333334}*cell[7] + V{0.0416666666666667};
auto x101 = V{0.00115740740740741}*x25;
auto x102 = x101*x43 - x101*x55 - x101*x60 - x101*x66 - x71*x91 + V{0.0416666666666667}*cell[17] + V{0.0416666666666667}*cell[18] + V{0.166666666666667}*cell[1] + V{0.0416666666666667}*cell[8] + V{0.0416666666666667}*cell[9];
auto x103 = x100 + x102 - x48*x98 + x50*x98 - V{0.0416666666666667}*cell[12] - V{0.0416666666666667}*cell[3];
auto x104 = x23*(x103 - x75*x97 + x82*x96 + V{0.833333333333333}*cell[4] - V{0.166666666666667}*cell[5]);
auto x105 = -x23*(x103 + x75*x96 - x82*x97 - V{0.166666666666667}*cell[4] + V{0.833333333333333}*cell[5]) + V{-0.0277777777777778};
auto x106 = x48*x99 - x50*x99 - x75*x92 - x82*x92 + V{0.0833333333333333}*cell[12] + V{0.0833333333333333}*cell[3] + V{0.0833333333333334}*cell[4] + V{0.0833333333333334}*cell[5];
auto x107 = x102 + x106 - x46*x98 + x52*x98 - V{0.0416666666666667}*cell[11] - V{0.0416666666666667}*cell[2] + V{0.0416666666666667};
auto x108 = x23*(x107 - x78*x97 + x84*x96 + V{0.833333333333333}*cell[6] - V{0.166666666666667}*cell[7]);
auto x109 = -x23*(x107 + x78*x96 - x84*x97 - V{0.166666666666667}*cell[6] + V{0.833333333333333}*cell[7]) + V{-0.0277777777777778};
auto x110 = V{0.0115740740740741}*x25;
auto x111 = V{0.00231481481481481}*x25;
auto x112 = x100 + x106 + x71*x85 - V{0.0833333333333333}*cell[1];
auto x113 = x23*(x110*x43 - x110*x55 + x111*x60 + x111*x66 + x112 + V{0.416666666666667}*cell[17] - V{0.0833333333333333}*cell[18] + V{0.416666666666667}*cell[8] - V{0.0833333333333333}*cell[9]);
auto x114 = -x23*(-x110*x60 - x110*x66 - x111*x43 + x111*x55 + x112 - V{0.0833333333333333}*cell[17] + V{0.416666666666667}*cell[18] - V{0.0833333333333333}*cell[8] + V{0.416666666666667}*cell[9]) + V{-0.0277777777777778};
auto x115 = x41 + x69;
auto x116 = -x69;
auto x117 = x19 + x58;
auto x118 = x19 + x63;
cell[0] = x23*(x24 + x26*x46 + x26*x48 - x26*x50 - x26*x52 + x44 - x56 - x61 - x67 - x68*x75 - x68*x78 - x68*x82 - x68*x84 - x72 + V{0.5}*cell[11] + V{0.5}*cell[12] + V{1}*cell[17] + V{1}*cell[18] + V{1}*cell[1] + V{0.5}*cell[2] + V{0.5}*cell[3] + V{1}*cell[8] + V{1}*cell[9] + V{0.5}) + V{0.333333333333333}*x25*x53 + V{-0.333333333333333};
cell[1] = x72 - x89 + V{-0.0555555555555556};
cell[2] = x52*x68 - x94 + V{-0.0555555555555556};
cell[3] = x50*x68 - x95 + V{-0.0555555555555556};
cell[4] = -x104 + x26*x75 + V{-0.0277777777777778};
cell[5] = x105 + x26*x82;
cell[6] = -x108 + x26*x78 + V{-0.0277777777777778};
cell[7] = x109 + x26*x84;
cell[8] = -x113 + x56 + V{-0.0277777777777778};
cell[9] = x114 + x61;
cell[10] = -x68*(x115 + x32 + x70 + V{1}) - x89 + V{-0.0555555555555556};
cell[11] = -x46*x68 - x94 + V{-0.0555555555555556};
cell[12] = -x48*x68 - x95 + V{-0.0555555555555556};
cell[13] = -x104 - x26*(x115 + x37 + x74) + V{-0.0277777777777778};
cell[14] = x105 + x26*(x116 + x54 - V{4.5}*x117*x117);
cell[15] = -x108 - x26*(x36 + x42 + x69 + x77) + V{-0.0277777777777778};
cell[16] = x109 + x26*(x116 + x65 - V{4.5}*x118*x118);
cell[17] = -x113 - x44 + V{-0.0277777777777778};
cell[18] = x114 + x67;
return { -V{1}*x25, x30 + x33 + x39 };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<0,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[13] + V{2}*cell[14] + V{2}*cell[15] + V{2}*cell[16];
auto x25 = (x24 + cell[0] + V{2}*cell[10] + cell[11] + cell[12] + cell[17] + cell[18] + cell[2] + cell[3] + cell[8] + cell[9] + V{1})/(x19 + V{1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = V{3}*x20;
auto x28 = x20*x20;
auto x29 = V{3}*x28;
auto x30 = x21*x21;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x19*x19;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = x27 + x37;
auto x39 = V{3}*x21;
auto x40 = V{1.5}*x28;
auto x41 = -x40;
auto x42 = x39 + x41;
auto x43 = V{3}*x30;
auto x44 = x35 + x43;
auto x45 = x42 + x44;
auto x46 = -x27;
auto x47 = -x39;
auto x48 = x41 + x47;
auto x49 = x20 + x21;
auto x50 = V{4.5}*(x49*x49);
auto x51 = x27 + x36;
auto x52 = x42 + x50 + x51;
auto x53 = x26*x52;
auto x54 = -x21;
auto x55 = x20 + x54;
auto x56 = V{4.5}*(x55*x55);
auto x57 = -x20;
auto x58 = x21 + x57;
auto x59 = V{4.5}*(x58*x58);
auto x60 = x36 + x46;
auto x61 = V{0.0555555555555556}*x25;
auto x62 = V{3}*x33;
auto x63 = V{3}*x19;
auto x64 = x41 + x63;
auto x65 = x32 + x62 + x64 + V{1};
auto x66 = x61*x65;
auto x67 = x19 + x20;
auto x68 = V{4.5}*(x67*x67);
auto x69 = x51 + x64 + x68;
auto x70 = x19 + x21;
auto x71 = V{4.5}*(x70*x70);
auto x72 = x36 + x63;
auto x73 = x42 + x71 + x72;
auto x74 = x19 + x57;
auto x75 = V{4.5}*(x74*x74);
auto x76 = x19 + x54;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x34 + x40 + V{-1};
auto x79 = x31 + x78;
auto x80 = V{0.00462962962962963}*x25;
auto x81 = x27 + x79;
auto x82 = x39 - x50 + x81;
auto x83 = x47 - x59 + x81;
auto x84 = x46 + x79;
auto x85 = x39 - x56 + x84;
auto x86 = V{0.00462962962962963}*x25;
auto x87 = -x63 + x79;
auto x88 = x27 - x75 + x87;
auto x89 = x39 - x43 + x78;
auto x90 = x45*x80 - x69*x86 - x80*x89 + x86*x88 - V{0.0833333333333333}*cell[12] + V{0.166666666666667}*cell[13] + V{0.166666666666667}*cell[14] - V{0.0833333333333333}*cell[3] + V{6.93889390390723e-18};
auto x91 = x39 - x77 + x87;
auto x92 = x31 + V{-1};
auto x93 = x27 - x29 + x34 + x92;
auto x94 = x38*x80 - x73*x86 - x80*x93 + x86*x91 - V{0.0833333333333333}*cell[11] + V{0.166666666666667}*cell[15] + V{0.166666666666667}*cell[16] - V{0.0833333333333333}*cell[2];
auto x95 = x23*(-V{0.0185185185185185}*x25*x65 + x52*x80 - x80*x82 - x80*x83 - x80*x85 + x90 + x94 + V{0.333333333333333}*cell[10] - V{0.166666666666667}*cell[17] - V{0.166666666666667}*cell[18] - V{0.166666666666667}*cell[8] - V{0.166666666666667}*cell[9]);
auto x96 = V{0.00925925925925926}*x25;
auto x97 = V{0.00925925925925926}*x25;
auto x98 = V{0.00231481481481482}*x25;
auto x99 = -x52*x98 + x65*x96 + x82*x98 + x83*x98 + x85*x98 - V{0.166666666666667}*cell[10] + V{0.0833333333333334}*cell[17] + V{0.0833333333333334}*cell[18] + V{0.0833333333333334}*cell[8] + V{0.0833333333333334}*cell[9];
auto x100 = x23*(-x38*x97 + x73*x96 + x90 - x91*x96 + x93*x97 + x99 + V{0.166666666666667}*cell[11] - V{0.333333333333333}*cell[15] - V{0.333333333333333}*cell[16] + V{0.166666666666667}*cell[2]);
auto x101 = x23*(-x45*x97 + x69*x96 - x88*x96 + x89*x97 + x94 + x99 + V{0.166666666666667}*cell[12] - V{0.333333333333333}*cell[13] - V{0.333333333333333}*cell[14] + V{0.166666666666667}*cell[3] + V{6.93889390390723e-18});
auto x102 = V{0.0231481481481481}*x25;
auto x103 = V{0.00462962962962963}*x25;
auto x104 = V{0.00231481481481481}*x25;
auto x105 = V{0.00462962962962963}*x25;
auto x106 = -x105*x38 + x105*x93 - x73*x98 + x91*x98 + V{0.0833333333333333}*cell[11] + V{0.0833333333333334}*cell[15] + V{0.0833333333333334}*cell[16] + V{0.0833333333333333}*cell[2] + V{0.0416666666666667};
auto x107 = V{0.00115740740740741}*x25;
auto x108 = -x107*x52 + x107*x82 + x107*x83 + x107*x85 - x65*x97 + V{0.166666666666667}*cell[10] + V{0.0416666666666667}*cell[17] + V{0.0416666666666667}*cell[18] + V{0.0416666666666667}*cell[8] + V{0.0416666666666667}*cell[9];
auto x109 = x104*x45 - x104*x89 + x106 + x108 - V{0.0416666666666667}*cell[12] - V{0.0416666666666667}*cell[3];
auto x110 = x23*(-x102*x69 - x103*x88 + x109 + V{0.833333333333333}*cell[13] - V{0.166666666666667}*cell[14]);
auto x111 = -x19;
auto x112 = x111 + x20;
auto x113 = x23*(x102*x88 + x103*x69 + x109 - V{0.166666666666667}*cell[13] + V{0.833333333333333}*cell[14]) + V{0.0277777777777778};
auto x114 = -x105*x45 + x105*x89 - x69*x98 + x88*x98 + V{0.0833333333333333}*cell[12] + V{0.0833333333333334}*cell[13] + V{0.0833333333333334}*cell[14] + V{0.0833333333333333}*cell[3];
auto x115 = x104*x38 - x104*x93 + x108 + x114 - V{0.0416666666666667}*cell[11] - V{0.0416666666666667}*cell[2] + V{0.0416666666666667};
auto x116 = x23*(-x102*x73 - x103*x91 + x115 + V{0.833333333333333}*cell[15] - V{0.166666666666667}*cell[16]);
auto x117 = x63 + x79;
auto x118 = x111 + x21;
auto x119 = x23*(x102*x91 + x103*x73 + x115 - V{0.166666666666667}*cell[15] + V{0.833333333333333}*cell[16]) + V{0.0277777777777778};
auto x120 = V{0.0115740740740741}*x25;
auto x121 = V{0.00231481481481481}*x25;
auto x122 = x106 + x114 + x65*x80 - V{0.0833333333333333}*cell[10];
auto x123 = x23*(-x120*x52 + x120*x82 - x121*x83 - x121*x85 + x122 + V{0.416666666666667}*cell[17] - V{0.0833333333333333}*cell[18] + V{0.416666666666667}*cell[8] - V{0.0833333333333333}*cell[9]);
auto x124 = x23*(x120*x83 + x120*x85 + x121*x52 - x121*x82 + x122 - V{0.0833333333333333}*cell[17] + V{0.416666666666667}*cell[18] - V{0.0833333333333333}*cell[8] + V{0.416666666666667}*cell[9]) + V{0.0277777777777778};
cell[0] = x23*(x24 - x26*x38 - x26*x45 - x26*(x37 + x46) - x26*(x44 + x48) - x26*(x42 + x59 + x60) - x26*(x48 + x50 + x60) - x26*(x48 + x51 + x56) - x53 - x61*x69 - x61*x73 - x61*(x48 + x72 + x77) - x61*(x60 + x64 + x75) - x66 + V{1}*cell[10] + V{0.5}*cell[11] + V{0.5}*cell[12] + V{1}*cell[17] + V{1}*cell[18] + V{0.5}*cell[2] + V{0.5}*cell[3] + V{1}*cell[8] + V{1}*cell[9] + V{0.5}) - V{0.333333333333333}*x25*x79 + V{-0.333333333333333};
cell[1] = -x61*(x40 - x62 + x63 + x92) - x95 + V{-0.0555555555555556};
cell[2] = -x100 - x61*x93 + V{-0.0555555555555556};
cell[3] = -x101 - x61*x89 + V{-0.0555555555555556};
cell[4] = -x110 - x26*(x63 - x68 + x81) + V{-0.0277777777777778};
cell[5] = -x113 - x26*(x63 + x84 - V{4.5}*x112*x112);
cell[6] = -x116 - x26*(x117 + x39 - x71) + V{-0.0277777777777778};
cell[7] = -x119 - x26*(x117 + x47 - V{4.5}*x118*x118);
cell[8] = -x123 - x26*x82 + V{-0.0277777777777778};
cell[9] = -x124 - x26*x83;
cell[10] = x66 - x95 + V{-0.0555555555555556};
cell[11] = -x100 + x38*x61 + V{-0.0555555555555556};
cell[12] = -x101 + x45*x61 + V{-0.0555555555555556};
cell[13] = -x110 + x26*x69 + V{-0.0277777777777778};
cell[14] = -x113 - x26*x88;
cell[15] = -x116 + x26*x73 + V{-0.0277777777777778};
cell[16] = -x119 - x26*x91;
cell[17] = -x123 + x53 + V{-0.0277777777777778};
cell[18] = -x124 - x26*x85;
return { V{1}*x25, x28 + x30 + x33 };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<1,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[14] + V{2}*cell[4] + V{2}*cell[8] + V{2}*cell[9];
auto x25 = (x24 + cell[0] + cell[10] + cell[12] + cell[15] + cell[16] + cell[1] + V{2}*cell[2] + cell[3] + cell[6] + cell[7] + V{1})/(x20 + V{-1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = x19 + x21;
auto x28 = V{4.5}*(x27*x27);
auto x29 = V{3}*x19;
auto x30 = x21*x21;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = V{3}*x21;
auto x39 = x19*x19;
auto x40 = V{1.5}*x39;
auto x41 = -x40;
auto x42 = x38 + x41;
auto x43 = x28 + x37 + x42;
auto x44 = x26*x43;
auto x45 = V{3}*x39;
auto x46 = x37 + x45;
auto x47 = V{3}*x30;
auto x48 = x35 + x42 + x47;
auto x49 = x34 + x40 + V{-1};
auto x50 = x38 - x47 + x49;
auto x51 = x31 + V{-1};
auto x52 = x29 + x34 - x45 + x51;
auto x53 = x31 + x49;
auto x54 = x29 + x53;
auto x55 = -x28 + x38 + x54;
auto x56 = x26*x55;
auto x57 = -x38;
auto x58 = -x19;
auto x59 = x21 + x58;
auto x60 = x54 + x57 - V{4.5}*x59*x59;
auto x61 = x26*x60;
auto x62 = -x29;
auto x63 = -x21;
auto x64 = x19 + x63;
auto x65 = x38 + x53;
auto x66 = x62 + x65 - V{4.5}*x64*x64;
auto x67 = x26*x66;
auto x68 = V{0.0555555555555556}*x25;
auto x69 = V{3}*x20;
auto x70 = V{3}*x33;
auto x71 = x40 + x51 + x69 - x70;
auto x72 = x68*x71;
auto x73 = x19 + x20;
auto x74 = V{4.5}*(x73*x73);
auto x75 = x54 + x69 - x74;
auto x76 = x20 + x21;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x65 + x69 - x77;
auto x79 = -x20;
auto x80 = x19 + x79;
auto x81 = x53 + x69;
auto x82 = x62 + x81 - V{4.5}*x80*x80;
auto x83 = x21 + x79;
auto x84 = x57 + x81 - V{4.5}*x83*x83;
auto x85 = V{0.00925925925925926}*x25;
auto x86 = V{0.00925925925925926}*x25;
auto x87 = V{0.00462962962962963}*x25;
auto x88 = V{0.00462962962962963}*x25;
auto x89 = -x48*x87 + x50*x87 - x75*x88 - x82*x88 - V{0.0833333333333333}*cell[12] + V{0.166666666666667}*cell[14] - V{0.0833333333333333}*cell[3] + V{0.166666666666667}*cell[4] + V{6.93889390390723e-18};
auto x90 = V{0.00231481481481482}*x25;
auto x91 = x43*x90 - x55*x90 - x60*x90 - x66*x90 + x71*x85 + V{0.0833333333333334}*cell[15] + V{0.0833333333333334}*cell[16] - V{0.166666666666667}*cell[2] + V{0.0833333333333334}*cell[6] + V{0.0833333333333334}*cell[7];
auto x92 = x23*(x46*x86 - x52*x86 + x78*x85 + x84*x85 + x89 + x91 + V{0.166666666666667}*cell[10] + V{0.166666666666667}*cell[1] - V{0.333333333333333}*cell[8] - V{0.333333333333333}*cell[9]);
auto x93 = -x46*x87 + x52*x87 - x78*x88 - x84*x88 - V{0.0833333333333333}*cell[10] - V{0.0833333333333333}*cell[1] + V{0.166666666666667}*cell[8] + V{0.166666666666667}*cell[9];
auto x94 = x23*(-V{0.0185185185185185}*x25*x71 - x43*x87 + x55*x87 + x60*x87 + x66*x87 + x89 + x93 - V{0.166666666666667}*cell[15] - V{0.166666666666667}*cell[16] + V{0.333333333333333}*cell[2] - V{0.166666666666667}*cell[6] - V{0.166666666666667}*cell[7]);
auto x95 = x23*(x48*x86 - x50*x86 + x75*x85 + x82*x85 + x91 + x93 + V{0.166666666666667}*cell[12] - V{0.333333333333333}*cell[14] + V{0.166666666666667}*cell[3] - V{0.333333333333333}*cell[4] + V{6.93889390390723e-18});
auto x96 = V{0.00462962962962963}*x25;
auto x97 = V{0.0231481481481481}*x25;
auto x98 = V{0.00231481481481481}*x25;
auto x99 = V{0.00462962962962963}*x25;
auto x100 = x46*x99 - x52*x99 - x78*x90 - x84*x90 + V{0.0833333333333333}*cell[10] + V{0.0833333333333333}*cell[1] + V{0.0833333333333334}*cell[8] + V{0.0833333333333334}*cell[9] + V{0.0416666666666667};
auto x101 = V{0.00115740740740741}*x25;
auto x102 = x101*x43 - x101*x55 - x101*x60 - x101*x66 - x71*x86 + V{0.0416666666666667}*cell[15] + V{0.0416666666666667}*cell[16] + V{0.166666666666667}*cell[2] + V{0.0416666666666667}*cell[6] + V{0.0416666666666667}*cell[7];
auto x103 = x100 + x102 - x48*x98 + x50*x98 - V{0.0416666666666667}*cell[12] - V{0.0416666666666667}*cell[3];
auto x104 = x23*(x103 - x75*x97 + x82*x96 - V{0.166666666666667}*cell[14] + V{0.833333333333333}*cell[4]);
auto x105 = -x69;
auto x106 = x20 + x58;
auto x107 = -x23*(x103 + x75*x96 - x82*x97 + V{0.833333333333333}*cell[14] - V{0.166666666666667}*cell[4]) + V{-0.0277777777777778};
auto x108 = V{0.0115740740740741}*x25;
auto x109 = V{0.00231481481481481}*x25;
auto x110 = x48*x99 - x50*x99 - x75*x90 - x82*x90 + V{0.0833333333333333}*cell[12] + V{0.0833333333333334}*cell[14] + V{0.0833333333333333}*cell[3] + V{0.0833333333333334}*cell[4];
auto x111 = x100 + x110 + x71*x87 - V{0.0833333333333333}*cell[2];
auto x112 = x23*(x108*x43 - x108*x55 + x109*x60 + x109*x66 + x111 + V{0.416666666666667}*cell[15] - V{0.0833333333333333}*cell[16] + V{0.416666666666667}*cell[6] - V{0.0833333333333333}*cell[7]);
auto x113 = -x23*(-x108*x60 - x108*x66 - x109*x43 + x109*x55 + x111 - V{0.0833333333333333}*cell[15] + V{0.416666666666667}*cell[16] - V{0.0833333333333333}*cell[6] + V{0.416666666666667}*cell[7]) + V{-0.0277777777777778};
auto x114 = x102 + x110 - x46*x98 + x52*x98 - V{0.0416666666666667}*cell[10] - V{0.0416666666666667}*cell[1] + V{0.0416666666666667};
auto x115 = x23*(x114 - x78*x97 + x84*x96 + V{0.833333333333333}*cell[8] - V{0.166666666666667}*cell[9]);
auto x116 = -x23*(x114 + x78*x96 - x84*x97 - V{0.166666666666667}*cell[8] + V{0.833333333333333}*cell[9]) + V{-0.0277777777777778};
auto x117 = x41 + x69;
auto x118 = x20 + x63;
cell[0] = x23*(x24 + x26*x46 + x26*x48 - x26*x50 - x26*x52 + x44 - x56 - x61 - x67 - x68*x75 - x68*x78 - x68*x82 - x68*x84 - x72 + V{0.5}*cell[10] + V{0.5}*cell[12] + V{1}*cell[15] + V{1}*cell[16] + V{0.5}*cell[1] + V{1}*cell[2] + V{0.5}*cell[3] + V{1}*cell[6] + V{1}*cell[7] + V{0.5}) + V{0.333333333333333}*x25*x53 + V{-0.333333333333333};
cell[1] = x52*x68 - x92 + V{-0.0555555555555556};
cell[2] = x72 - x94 + V{-0.0555555555555556};
cell[3] = x50*x68 - x95 + V{-0.0555555555555556};
cell[4] = -x104 + x26*x75 + V{-0.0277777777777778};
cell[5] = x107 + x26*(x105 + x54 - V{4.5}*x106*x106);
cell[6] = -x112 + x56 + V{-0.0277777777777778};
cell[7] = x113 + x61;
cell[8] = -x115 + x26*x78 + V{-0.0277777777777778};
cell[9] = x116 + x26*x84;
cell[10] = -x46*x68 - x92 + V{-0.0555555555555556};
cell[11] = -x68*(x117 + x32 + x70 + V{1}) - x94 + V{-0.0555555555555556};
cell[12] = -x48*x68 - x95 + V{-0.0555555555555556};
cell[13] = -x104 - x26*(x117 + x37 + x74) + V{-0.0277777777777778};
cell[14] = x107 + x26*x82;
cell[15] = -x112 - x44 + V{-0.0277777777777778};
cell[16] = x113 + x67;
cell[17] = -x115 - x26*(x36 + x42 + x69 + x77) + V{-0.0277777777777778};
cell[18] = x116 + x26*(x105 + x65 - V{4.5}*x118*x118);
return { -V{1}*x25, x30 + x33 + x39 };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<1,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[13] + V{2}*cell[17] + V{2}*cell[18] + V{2}*cell[5];
auto x25 = (x24 + cell[0] + cell[10] + V{2}*cell[11] + cell[12] + cell[15] + cell[16] + cell[1] + cell[3] + cell[6] + cell[7] + V{1})/(x20 + V{1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = V{3}*x19;
auto x28 = x19*x19;
auto x29 = V{3}*x28;
auto x30 = x21*x21;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = x27 + x37;
auto x39 = V{3}*x21;
auto x40 = V{1.5}*x28;
auto x41 = -x40;
auto x42 = x39 + x41;
auto x43 = V{3}*x30;
auto x44 = x35 + x43;
auto x45 = x42 + x44;
auto x46 = -x27;
auto x47 = -x39;
auto x48 = x41 + x47;
auto x49 = x19 + x21;
auto x50 = V{4.5}*(x49*x49);
auto x51 = x27 + x36;
auto x52 = x42 + x50 + x51;
auto x53 = x26*x52;
auto x54 = -x21;
auto x55 = x19 + x54;
auto x56 = V{4.5}*(x55*x55);
auto x57 = -x19;
auto x58 = x21 + x57;
auto x59 = V{4.5}*(x58*x58);
auto x60 = x36 + x46;
auto x61 = V{0.0555555555555556}*x25;
auto x62 = V{3}*x33;
auto x63 = V{3}*x20;
auto x64 = x41 + x63;
auto x65 = x32 + x62 + x64 + V{1};
auto x66 = x61*x65;
auto x67 = x19 + x20;
auto x68 = V{4.5}*(x67*x67);
auto x69 = x51 + x64 + x68;
auto x70 = x20 + x21;
auto x71 = V{4.5}*(x70*x70);
auto x72 = x36 + x63;
auto x73 = x42 + x71 + x72;
auto x74 = x20 + x57;
auto x75 = V{4.5}*(x74*x74);
auto x76 = x20 + x54;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x31 + x34 + V{-1};
auto x79 = x40 + x78;
auto x80 = V{0.00925925925925926}*x25;
auto x81 = V{0.00925925925925926}*x25;
auto x82 = x27 - x29 + x78;
auto x83 = -x63;
auto x84 = x39 + x79;
auto x85 = -x77 + x83 + x84;
auto x86 = V{0.00462962962962963}*x25;
auto x87 = V{0.00462962962962963}*x25;
auto x88 = x27 + x79;
auto x89 = -x75 + x83 + x88;
auto x90 = x40 + V{-1};
auto x91 = x34 + x39 - x43 + x90;
auto x92 = x45*x86 - x69*x87 - x86*x91 + x87*x89 - V{0.0833333333333333}*cell[12] + V{0.166666666666667}*cell[13] - V{0.0833333333333333}*cell[3] + V{0.166666666666667}*cell[5] + V{6.93889390390723e-18};
auto x93 = V{0.00231481481481482}*x25;
auto x94 = x39 - x50 + x88;
auto x95 = x47 - x59 + x88;
auto x96 = x46 - x56 + x84;
auto x97 = -x52*x93 + x65*x80 + x93*x94 + x93*x95 + x93*x96 - V{0.166666666666667}*cell[11] + V{0.0833333333333334}*cell[15] + V{0.0833333333333334}*cell[16] + V{0.0833333333333334}*cell[6] + V{0.0833333333333334}*cell[7];
auto x98 = x23*(-x38*x81 + x73*x80 - x80*x85 + x81*x82 + x92 + x97 + V{0.166666666666667}*cell[10] - V{0.333333333333333}*cell[17] - V{0.333333333333333}*cell[18] + V{0.166666666666667}*cell[1]);
auto x99 = x38*x86 - x73*x87 - x82*x86 + x85*x87 - V{0.0833333333333333}*cell[10] + V{0.166666666666667}*cell[17] + V{0.166666666666667}*cell[18] - V{0.0833333333333333}*cell[1];
auto x100 = x23*(-V{0.0185185185185185}*x25*x65 + x52*x86 - x86*x94 - x86*x95 - x86*x96 + x92 + x99 + V{0.333333333333333}*cell[11] - V{0.166666666666667}*cell[15] - V{0.166666666666667}*cell[16] - V{0.166666666666667}*cell[6] - V{0.166666666666667}*cell[7]);
auto x101 = x23*(-x45*x81 + x69*x80 - x80*x89 + x81*x91 + x97 + x99 + V{0.166666666666667}*cell[12] - V{0.333333333333333}*cell[13] + V{0.166666666666667}*cell[3] - V{0.333333333333333}*cell[5] + V{6.93889390390723e-18});
auto x102 = V{0.0231481481481481}*x25;
auto x103 = V{0.00462962962962963}*x25;
auto x104 = V{0.00231481481481481}*x25;
auto x105 = V{0.00462962962962963}*x25;
auto x106 = -x105*x38 + x105*x82 - x73*x93 + x85*x93 + V{0.0833333333333333}*cell[10] + V{0.0833333333333334}*cell[17] + V{0.0833333333333334}*cell[18] + V{0.0833333333333333}*cell[1] + V{0.0416666666666667};
auto x107 = V{0.00115740740740741}*x25;
auto x108 = -x107*x52 + x107*x94 + x107*x95 + x107*x96 - x65*x81 + V{0.166666666666667}*cell[11] + V{0.0416666666666667}*cell[15] + V{0.0416666666666667}*cell[16] + V{0.0416666666666667}*cell[6] + V{0.0416666666666667}*cell[7];
auto x109 = x104*x45 - x104*x91 + x106 + x108 - V{0.0416666666666667}*cell[12] - V{0.0416666666666667}*cell[3];
auto x110 = x23*(-x102*x69 - x103*x89 + x109 + V{0.833333333333333}*cell[13] - V{0.166666666666667}*cell[5]);
auto x111 = x23*(x102*x89 + x103*x69 + x109 - V{0.166666666666667}*cell[13] + V{0.833333333333333}*cell[5]) + V{0.0277777777777778};
auto x112 = V{0.0115740740740741}*x25;
auto x113 = V{0.00231481481481481}*x25;
auto x114 = -x105*x45 + x105*x91 - x69*x93 + x89*x93 + V{0.0833333333333333}*cell[12] + V{0.0833333333333334}*cell[13] + V{0.0833333333333333}*cell[3] + V{0.0833333333333334}*cell[5];
auto x115 = x106 + x114 + x65*x86 - V{0.0833333333333333}*cell[11];
auto x116 = x23*(-x112*x52 + x112*x94 - x113*x95 - x113*x96 + x115 + V{0.416666666666667}*cell[15] - V{0.0833333333333333}*cell[16] + V{0.416666666666667}*cell[6] - V{0.0833333333333333}*cell[7]);
auto x117 = x23*(x112*x95 + x112*x96 + x113*x52 - x113*x94 + x115 - V{0.0833333333333333}*cell[15] + V{0.416666666666667}*cell[16] - V{0.0833333333333333}*cell[6] + V{0.416666666666667}*cell[7]) + V{0.0277777777777778};
auto x118 = x104*x38 - x104*x82 + x108 + x114 - V{0.0416666666666667}*cell[10] - V{0.0416666666666667}*cell[1] + V{0.0416666666666667};
auto x119 = x23*(-x102*x73 - x103*x85 + x118 + V{0.833333333333333}*cell[17] - V{0.166666666666667}*cell[18]);
auto x120 = -x20;
auto x121 = x120 + x21;
auto x122 = x63 + x79;
auto x123 = x23*(x102*x85 + x103*x73 + x118 - V{0.166666666666667}*cell[17] + V{0.833333333333333}*cell[18]) + V{0.0277777777777778};
auto x124 = x120 + x19;
cell[0] = x23*(x24 - x26*x38 - x26*x45 - x26*(x37 + x46) - x26*(x44 + x48) - x26*(x42 + x59 + x60) - x26*(x48 + x50 + x60) - x26*(x48 + x51 + x56) - x53 - x61*x69 - x61*x73 - x61*(x48 + x72 + x77) - x61*(x60 + x64 + x75) - x66 + V{0.5}*cell[10] + V{1}*cell[11] + V{0.5}*cell[12] + V{1}*cell[15] + V{1}*cell[16] + V{0.5}*cell[1] + V{0.5}*cell[3] + V{1}*cell[6] + V{1}*cell[7] + V{0.5}) - V{0.333333333333333}*x25*x79 + V{-0.333333333333333};
cell[1] = -x61*x82 - x98 + V{-0.0555555555555556};
cell[2] = -x100 - x61*(x31 - x62 + x63 + x90) + V{-0.0555555555555556};
cell[3] = -x101 - x61*x91 + V{-0.0555555555555556};
cell[4] = -x110 - x26*(x63 - x68 + x88) + V{-0.0277777777777778};
cell[5] = -x111 - x26*x89;
cell[6] = -x116 - x26*x94 + V{-0.0277777777777778};
cell[7] = -x117 - x26*x95;
cell[8] = -x119 - x26*(x63 - x71 + x84) + V{-0.0277777777777778};
cell[9] = -x123 - x26*(x122 + x47 - V{4.5}*x121*x121);
cell[10] = x38*x61 - x98 + V{-0.0555555555555556};
cell[11] = -x100 + x66 + V{-0.0555555555555556};
cell[12] = -x101 + x45*x61 + V{-0.0555555555555556};
cell[13] = -x110 + x26*x69 + V{-0.0277777777777778};
cell[14] = -x111 - x26*(x122 + x46 - V{4.5}*x124*x124);
cell[15] = -x116 + x53 + V{-0.0277777777777778};
cell[16] = -x117 - x26*x96;
cell[17] = -x119 + x26*x73 + V{-0.0277777777777778};
cell[18] = -x123 - x26*x85;
return { V{1}*x25, x28 + x30 + x33 };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<2,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[16] + V{2}*cell[18] + V{2}*cell[6] + V{2}*cell[8];
auto x25 = (x24 + cell[0] + cell[10] + cell[11] + cell[13] + cell[14] + cell[1] + cell[2] + V{2}*cell[3] + cell[4] + cell[5] + V{1})/(x21 + V{-1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = x19 + x20;
auto x28 = V{4.5}*(x27*x27);
auto x29 = V{3}*x19;
auto x30 = x20*x20;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x21*x21;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = V{3}*x20;
auto x39 = x19*x19;
auto x40 = V{1.5}*x39;
auto x41 = -x40;
auto x42 = x38 + x41;
auto x43 = x28 + x37 + x42;
auto x44 = x26*x43;
auto x45 = V{3}*x39;
auto x46 = x37 + x45;
auto x47 = V{3}*x30;
auto x48 = x35 + x42 + x47;
auto x49 = x34 + x40 + V{-1};
auto x50 = x38 - x47 + x49;
auto x51 = x31 + V{-1};
auto x52 = x29 + x34 - x45 + x51;
auto x53 = x31 + x49;
auto x54 = x29 + x53;
auto x55 = -x28 + x38 + x54;
auto x56 = x26*x55;
auto x57 = -x38;
auto x58 = -x19;
auto x59 = x20 + x58;
auto x60 = x54 + x57 - V{4.5}*x59*x59;
auto x61 = x26*x60;
auto x62 = -x29;
auto x63 = -x20;
auto x64 = x19 + x63;
auto x65 = x38 + x53;
auto x66 = x62 + x65 - V{4.5}*x64*x64;
auto x67 = x26*x66;
auto x68 = V{0.0555555555555556}*x25;
auto x69 = V{3}*x21;
auto x70 = V{3}*x33;
auto x71 = x40 + x51 + x69 - x70;
auto x72 = x68*x71;
auto x73 = x19 + x21;
auto x74 = V{4.5}*(x73*x73);
auto x75 = x54 + x69 - x74;
auto x76 = x20 + x21;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x65 + x69 - x77;
auto x79 = -x21;
auto x80 = x19 + x79;
auto x81 = x53 + x69;
auto x82 = x62 + x81 - V{4.5}*x80*x80;
auto x83 = x20 + x79;
auto x84 = x57 + x81 - V{4.5}*x83*x83;
auto x85 = V{0.00925925925925926}*x25;
auto x86 = V{0.00925925925925926}*x25;
auto x87 = V{0.00462962962962963}*x25;
auto x88 = V{0.00462962962962963}*x25;
auto x89 = -x48*x87 + x50*x87 - x75*x88 - x82*x88 - V{0.0833333333333333}*cell[11] + V{0.166666666666667}*cell[16] - V{0.0833333333333333}*cell[2] + V{0.166666666666667}*cell[6] + V{6.93889390390723e-18};
auto x90 = V{0.00231481481481482}*x25;
auto x91 = x43*x90 - x55*x90 - x60*x90 - x66*x90 + x71*x85 + V{0.0833333333333334}*cell[13] + V{0.0833333333333334}*cell[14] - V{0.166666666666667}*cell[3] + V{0.0833333333333334}*cell[4] + V{0.0833333333333334}*cell[5];
auto x92 = x23*(x46*x86 - x52*x86 + x78*x85 + x84*x85 + x89 + x91 + V{0.166666666666667}*cell[10] - V{0.333333333333333}*cell[18] + V{0.166666666666667}*cell[1] - V{0.333333333333333}*cell[8]);
auto x93 = -x46*x87 + x52*x87 - x78*x88 - x84*x88 - V{0.0833333333333333}*cell[10] + V{0.166666666666667}*cell[18] - V{0.0833333333333333}*cell[1] + V{0.166666666666667}*cell[8];
auto x94 = x23*(x48*x86 - x50*x86 + x75*x85 + x82*x85 + x91 + x93 + V{0.166666666666667}*cell[11] - V{0.333333333333333}*cell[16] + V{0.166666666666667}*cell[2] - V{0.333333333333333}*cell[6] + V{6.93889390390723e-18});
auto x95 = x23*(-V{0.0185185185185185}*x25*x71 - x43*x87 + x55*x87 + x60*x87 + x66*x87 + x89 + x93 - V{0.166666666666667}*cell[13] - V{0.166666666666667}*cell[14] + V{0.333333333333333}*cell[3] - V{0.166666666666667}*cell[4] - V{0.166666666666667}*cell[5]);
auto x96 = V{0.0115740740740741}*x25;
auto x97 = V{0.00231481481481481}*x25;
auto x98 = V{0.00462962962962963}*x25;
auto x99 = x46*x98 - x52*x98 - x78*x90 - x84*x90 + V{0.0833333333333333}*cell[10] + V{0.0833333333333334}*cell[18] + V{0.0833333333333333}*cell[1] + V{0.0833333333333334}*cell[8] + V{0.0416666666666667};
auto x100 = x48*x98 - x50*x98 - x75*x90 - x82*x90 + V{0.0833333333333333}*cell[11] + V{0.0833333333333334}*cell[16] + V{0.0833333333333333}*cell[2] + V{0.0833333333333334}*cell[6];
auto x101 = x100 + x71*x87 + x99 - V{0.0833333333333333}*cell[3];
auto x102 = x23*(x101 + x43*x96 - x55*x96 + x60*x97 + x66*x97 + V{0.416666666666667}*cell[13] - V{0.0833333333333333}*cell[14] + V{0.416666666666667}*cell[4] - V{0.0833333333333333}*cell[5]);
auto x103 = -x23*(x101 - x43*x97 + x55*x97 - x60*x96 - x66*x96 - V{0.0833333333333333}*cell[13] + V{0.416666666666667}*cell[14] - V{0.0833333333333333}*cell[4] + V{0.416666666666667}*cell[5]) + V{-0.0277777777777778};
auto x104 = V{0.00462962962962963}*x25;
auto x105 = V{0.0231481481481481}*x25;
auto x106 = V{0.00231481481481481}*x25;
auto x107 = V{0.00115740740740741}*x25;
auto x108 = x107*x43 - x107*x55 - x107*x60 - x107*x66 - x71*x86 + V{0.0416666666666667}*cell[13] + V{0.0416666666666667}*cell[14] + V{0.166666666666667}*cell[3] + V{0.0416666666666667}*cell[4] + V{0.0416666666666667}*cell[5];
auto x109 = -x106*x48 + x106*x50 + x108 + x99 - V{0.0416666666666667}*cell[11] - V{0.0416666666666667}*cell[2];
auto x110 = x23*(x104*x82 - x105*x75 + x109 - V{0.166666666666667}*cell[16] + V{0.833333333333333}*cell[6]);
auto x111 = -x69;
auto x112 = x21 + x58;
auto x113 = -x23*(x104*x75 - x105*x82 + x109 + V{0.833333333333333}*cell[16] - V{0.166666666666667}*cell[6]) + V{-0.0277777777777778};
auto x114 = x100 - x106*x46 + x106*x52 + x108 - V{0.0416666666666667}*cell[10] - V{0.0416666666666667}*cell[1] + V{0.0416666666666667};
auto x115 = x23*(x104*x84 - x105*x78 + x114 - V{0.166666666666667}*cell[18] + V{0.833333333333333}*cell[8]);
auto x116 = x21 + x63;
auto x117 = -x23*(x104*x78 - x105*x84 + x114 + V{0.833333333333333}*cell[18] - V{0.166666666666667}*cell[8]) + V{-0.0277777777777778};
auto x118 = x41 + x69;
cell[0] = x23*(x24 + x26*x46 + x26*x48 - x26*x50 - x26*x52 + x44 - x56 - x61 - x67 - x68*x75 - x68*x78 - x68*x82 - x68*x84 - x72 + V{0.5}*cell[10] + V{0.5}*cell[11] + V{1}*cell[13] + V{1}*cell[14] + V{0.5}*cell[1] + V{0.5}*cell[2] + V{1}*cell[3] + V{1}*cell[4] + V{1}*cell[5] + V{0.5}) + V{0.333333333333333}*x25*x53 + V{-0.333333333333333};
cell[1] = x52*x68 - x92 + V{-0.0555555555555556};
cell[2] = x50*x68 - x94 + V{-0.0555555555555556};
cell[3] = x72 - x95 + V{-0.0555555555555556};
cell[4] = -x102 + x56 + V{-0.0277777777777778};
cell[5] = x103 + x61;
cell[6] = -x110 + x26*x75 + V{-0.0277777777777778};
cell[7] = x113 + x26*(x111 + x54 - V{4.5}*x112*x112);
cell[8] = -x115 + x26*x78 + V{-0.0277777777777778};
cell[9] = x117 + x26*(x111 + x65 - V{4.5}*x116*x116);
cell[10] = -x46*x68 - x92 + V{-0.0555555555555556};
cell[11] = -x48*x68 - x94 + V{-0.0555555555555556};
cell[12] = -x68*(x118 + x32 + x70 + V{1}) - x95 + V{-0.0555555555555556};
cell[13] = -x102 - x44 + V{-0.0277777777777778};
cell[14] = x103 + x67;
cell[15] = -x110 - x26*(x118 + x37 + x74) + V{-0.0277777777777778};
cell[16] = x113 + x26*x82;
cell[17] = -x115 - x26*(x36 + x42 + x69 + x77) + V{-0.0277777777777778};
cell[18] = x117 + x26*x84;
return { -V{1}*x25, x30 + x33 + x39 };
}

};

template <typename... FIELDS>
struct RLB::type<descriptors::D3Q19<FIELDS...>,momenta::RegularizedVelocityBoundaryTuple<2,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x23 = x22 + V{-1};
auto x24 = V{2}*cell[15] + V{2}*cell[17] + V{2}*cell[7] + V{2}*cell[9];
auto x25 = (x24 + cell[0] + cell[10] + cell[11] + V{2}*cell[12] + cell[13] + cell[14] + cell[1] + cell[2] + cell[4] + cell[5] + V{1})/(x21 + V{1});
auto x26 = V{0.0277777777777778}*x25;
auto x27 = V{3}*x19;
auto x28 = x19*x19;
auto x29 = V{3}*x28;
auto x30 = x20*x20;
auto x31 = V{1.5}*x30;
auto x32 = -x31;
auto x33 = x21*x21;
auto x34 = V{1.5}*x33;
auto x35 = V{1} - x34;
auto x36 = x32 + x35;
auto x37 = x29 + x36;
auto x38 = x27 + x37;
auto x39 = V{3}*x20;
auto x40 = V{1.5}*x28;
auto x41 = -x40;
auto x42 = x39 + x41;
auto x43 = V{3}*x30;
auto x44 = x35 + x43;
auto x45 = x42 + x44;
auto x46 = -x27;
auto x47 = -x39;
auto x48 = x41 + x47;
auto x49 = x19 + x20;
auto x50 = V{4.5}*(x49*x49);
auto x51 = x27 + x36;
auto x52 = x42 + x50 + x51;
auto x53 = x26*x52;
auto x54 = -x20;
auto x55 = x19 + x54;
auto x56 = V{4.5}*(x55*x55);
auto x57 = -x19;
auto x58 = x20 + x57;
auto x59 = V{4.5}*(x58*x58);
auto x60 = x36 + x46;
auto x61 = V{0.0555555555555556}*x25;
auto x62 = V{3}*x33;
auto x63 = V{3}*x21;
auto x64 = x41 + x63;
auto x65 = x32 + x62 + x64 + V{1};
auto x66 = x61*x65;
auto x67 = x19 + x21;
auto x68 = V{4.5}*(x67*x67);
auto x69 = x51 + x64 + x68;
auto x70 = x20 + x21;
auto x71 = V{4.5}*(x70*x70);
auto x72 = x36 + x63;
auto x73 = x42 + x71 + x72;
auto x74 = x21 + x57;
auto x75 = V{4.5}*(x74*x74);
auto x76 = x21 + x54;
auto x77 = V{4.5}*(x76*x76);
auto x78 = x31 + x34 + V{-1};
auto x79 = x40 + x78;
auto x80 = V{0.00925925925925926}*x25;
auto x81 = V{0.00925925925925926}*x25;
auto x82 = x27 - x29 + x78;
auto x83 = -x63;
auto x84 = x39 + x79;
auto x85 = -x77 + x83 + x84;
auto x86 = V{0.00462962962962963}*x25;
auto x87 = V{0.00462962962962963}*x25;
auto x88 = x27 + x79;
auto x89 = -x75 + x83 + x88;
auto x90 = x40 + V{-1};
auto x91 = x34 + x39 - x43 + x90;
auto x92 = x45*x86 - x69*x87 - x86*x91 + x87*x89 - V{0.0833333333333333}*cell[11] + V{0.166666666666667}*cell[15] - V{0.0833333333333333}*cell[2] + V{0.166666666666667}*cell[7] + V{6.93889390390723e-18};
auto x93 = V{0.00231481481481482}*x25;
auto x94 = x39 - x50 + x88;
auto x95 = x47 - x59 + x88;
auto x96 = x46 - x56 + x84;
auto x97 = -x52*x93 + x65*x80 + x93*x94 + x93*x95 + x93*x96 - V{0.166666666666667}*cell[12] + V{0.0833333333333334}*cell[13] + V{0.0833333333333334}*cell[14] + V{0.0833333333333334}*cell[4] + V{0.0833333333333334}*cell[5];
auto x98 = x23*(-x38*x81 + x73*x80 - x80*x85 + x81*x82 + x92 + x97 + V{0.166666666666667}*cell[10] - V{0.333333333333333}*cell[17] + V{0.166666666666667}*cell[1] - V{0.333333333333333}*cell[9]);
auto x99 = x38*x86 - x73*x87 - x82*x86 + x85*x87 - V{0.0833333333333333}*cell[10] + V{0.166666666666667}*cell[17] - V{0.0833333333333333}*cell[1] + V{0.166666666666667}*cell[9];
auto x100 = x23*(-x45*x81 + x69*x80 - x80*x89 + x81*x91 + x97 + x99 + V{0.166666666666667}*cell[11] - V{0.333333333333333}*cell[15] + V{0.166666666666667}*cell[2] - V{0.333333333333333}*cell[7] + V{6.93889390390723e-18});
auto x101 = x23*(-V{0.0185185185185185}*x25*x65 + x52*x86 - x86*x94 - x86*x95 - x86*x96 + x92 + x99 + V{0.333333333333333}*cell[12] - V{0.166666666666667}*cell[13] - V{0.166666666666667}*cell[14] - V{0.166666666666667}*cell[4] - V{0.166666666666667}*cell[5]);
auto x102 = V{0.0115740740740741}*x25;
auto x103 = V{0.00231481481481481}*x25;
auto x104 = V{0.00462962962962963}*x25;
auto x105 = -x104*x38 + x104*x82 - x73*x93 + x85*x93 + V{0.0833333333333333}*cell[10] + V{0.0833333333333334}*cell[17] + V{0.0833333333333333}*cell[1] + V{0.0833333333333334}*cell[9] + V{0.0416666666666667};
auto x106 = -x104*x45 + x104*x91 - x69*x93 + x89*x93 + V{0.0833333333333333}*cell[11] + V{0.0833333333333334}*cell[15] + V{0.0833333333333333}*cell[2] + V{0.0833333333333334}*cell[7];
auto x107 = x105 + x106 + x65*x86 - V{0.0833333333333333}*cell[12];
auto x108 = x23*(-x102*x52 + x102*x94 - x103*x95 - x103*x96 + x107 + V{0.416666666666667}*cell[13] - V{0.0833333333333333}*cell[14] + V{0.416666666666667}*cell[4] - V{0.0833333333333333}*cell[5]);
auto x109 = x23*(x102*x95 + x102*x96 + x103*x52 - x103*x94 + x107 - V{0.0833333333333333}*cell[13] + V{0.416666666666667}*cell[14] - V{0.0833333333333333}*cell[4] + V{0.416666666666667}*cell[5]) + V{0.0277777777777778};
auto x110 = V{0.0231481481481481}*x25;
auto x111 = V{0.00462962962962963}*x25;
auto x112 = V{0.00231481481481481}*x25;
auto x113 = V{0.00115740740740741}*x25;
auto x114 = -x113*x52 + x113*x94 + x113*x95 + x113*x96 - x65*x81 + V{0.166666666666667}*cell[12] + V{0.0416666666666667}*cell[13] + V{0.0416666666666667}*cell[14] + V{0.0416666666666667}*cell[4] + V{0.0416666666666667}*cell[5];
auto x115 = x105 + x112*x45 - x112*x91 + x114 - V{0.0416666666666667}*cell[11] - V{0.0416666666666667}*cell[2];
auto x116 = x23*(-x110*x69 - x111*x89 + x115 + V{0.833333333333333}*cell[15] - V{0.166666666666667}*cell[7]);
auto x117 = x23*(x110*x89 + x111*x69 + x115 - V{0.166666666666667}*cell[15] + V{0.833333333333333}*cell[7]) + V{0.0277777777777778};
auto x118 = x106 + x112*x38 - x112*x82 + x114 - V{0.0416666666666667}*cell[10] - V{0.0416666666666667}*cell[1] + V{0.0416666666666667};
auto x119 = x23*(-x110*x73 - x111*x85 + x118 + V{0.833333333333333}*cell[17] - V{0.166666666666667}*cell[9]);
auto x120 = x23*(x110*x85 + x111*x73 + x118 - V{0.166666666666667}*cell[17] + V{0.833333333333333}*cell[9]) + V{0.0277777777777778};
auto x121 = -x21;
auto x122 = x121 + x19;
auto x123 = x63 + x79;
auto x124 = x121 + x20;
cell[0] = x23*(x24 - x26*x38 - x26*x45 - x26*(x37 + x46) - x26*(x44 + x48) - x26*(x42 + x59 + x60) - x26*(x48 + x50 + x60) - x26*(x48 + x51 + x56) - x53 - x61*x69 - x61*x73 - x61*(x48 + x72 + x77) - x61*(x60 + x64 + x75) - x66 + V{0.5}*cell[10] + V{0.5}*cell[11] + V{1}*cell[12] + V{1}*cell[13] + V{1}*cell[14] + V{0.5}*cell[1] + V{0.5}*cell[2] + V{1}*cell[4] + V{1}*cell[5] + V{0.5}) - V{0.333333333333333}*x25*x79 + V{-0.333333333333333};
cell[1] = -x61*x82 - x98 + V{-0.0555555555555556};
cell[2] = -x100 - x61*x91 + V{-0.0555555555555556};
cell[3] = -x101 - x61*(x31 - x62 + x63 + x90) + V{-0.0555555555555556};
cell[4] = -x108 - x26*x94 + V{-0.0277777777777778};
cell[5] = -x109 - x26*x95;
cell[6] = -x116 - x26*(x63 - x68 + x88) + V{-0.0277777777777778};
cell[7] = -x117 - x26*x89;
cell[8] = -x119 - x26*(x63 - x71 + x84) + V{-0.0277777777777778};
cell[9] = -x120 - x26*x85;
cell[10] = x38*x61 - x98 + V{-0.0555555555555556};
cell[11] = -x100 + x45*x61 + V{-0.0555555555555556};
cell[12] = -x101 + x66 + V{-0.0555555555555556};
cell[13] = -x108 + x53 + V{-0.0277777777777778};
cell[14] = -x109 - x26*x96;
cell[15] = -x116 + x26*x69 + V{-0.0277777777777778};
cell[16] = -x117 - x26*(x123 + x46 - V{4.5}*x122*x122);
cell[17] = -x119 + x26*x73 + V{-0.0277777777777778};
cell[18] = -x120 - x26*(x123 + x47 - V{4.5}*x124*x124);
return { V{1}*x25, x28 + x30 + x33 };
}

};


template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<0,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x19 + V{-1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[1] + V{2}*cell[4] + V{2}*cell[5] + V{2}*cell[6] + V{2}*cell[7] + V{1};
auto x28 = x27 + cell[0] + cell[11] + cell[12] + cell[17] + cell[18] + cell[2] + cell[3] + cell[8] + cell[9];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(-x30*x38 + cell[0] + V{0.333333333333333}) + x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(-x40*x43 + cell[1] + V{0.0555555555555556}) + x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(-x40*x48 + cell[2] + V{0.0555555555555556}) + x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(-x40*x51 + cell[3] + V{0.0555555555555556}) + x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(-x52*x56 + cell[4] + V{0.0277777777777778}) + x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(-x52*x61 + cell[5] + V{0.0277777777777778}) + x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(-x52*x64 + cell[6] + V{0.0277777777777778}) + x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(-x52*x67 + cell[7] + V{0.0277777777777778}) + x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(-x52*x71 + cell[8] + V{0.0277777777777778}) + x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(-x52*x74 + cell[9] + V{0.0277777777777778}) + x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(x40*x79 + cell[10] + V{0.0555555555555556}) - x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(x40*x82 + cell[11] + V{0.0555555555555556}) - x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(x40*x84 + cell[12] + V{0.0555555555555556}) - x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(x52*x85 + cell[13] + V{0.0277777777777778}) - x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(-x52*x88 + cell[14] + V{0.0277777777777778}) + x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(x52*x89 + cell[15] + V{0.0277777777777778}) - x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(-x52*x93 + cell[16] + V{0.0277777777777778}) + x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(x52*x94 + cell[17] + V{0.0277777777777778}) - x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(-x52*x96 + cell[18] + V{0.0277777777777778}) + x57*x96 + V{-0.0277777777777778};
return { -x23 - x26*(x27 + V{1}*cell[0] + V{1}*cell[11] + V{1}*cell[12] + V{1}*cell[17] + V{1}*cell[18] + V{1}*cell[2] + V{1}*cell[3] + V{1}*cell[8] + V{1}*cell[9]) + V{1}, x31 + x33 + x35 };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<0,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x19 + V{1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[10] + V{2}*cell[13] + V{2}*cell[14] + V{2}*cell[15] + V{2}*cell[16] + V{1};
auto x28 = x27 + cell[0] + cell[11] + cell[12] + cell[17] + cell[18] + cell[2] + cell[3] + cell[8] + cell[9];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = -x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(x30*x38 + cell[0] + V{0.333333333333333}) - x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(x40*x43 + cell[1] + V{0.0555555555555556}) - x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(x40*x48 + cell[2] + V{0.0555555555555556}) - x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(x40*x51 + cell[3] + V{0.0555555555555556}) - x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(x52*x56 + cell[4] + V{0.0277777777777778}) - x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(x52*x61 + cell[5] + V{0.0277777777777778}) - x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(x52*x64 + cell[6] + V{0.0277777777777778}) - x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(x52*x67 + cell[7] + V{0.0277777777777778}) - x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(x52*x71 + cell[8] + V{0.0277777777777778}) - x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(x52*x74 + cell[9] + V{0.0277777777777778}) - x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(-x40*x79 + cell[10] + V{0.0555555555555556}) + x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(-x40*x82 + cell[11] + V{0.0555555555555556}) + x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(-x40*x84 + cell[12] + V{0.0555555555555556}) + x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(-x52*x85 + cell[13] + V{0.0277777777777778}) + x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(x52*x88 + cell[14] + V{0.0277777777777778}) - x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(-x52*x89 + cell[15] + V{0.0277777777777778}) + x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(x52*x93 + cell[16] + V{0.0277777777777778}) - x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(-x52*x94 + cell[17] + V{0.0277777777777778}) + x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(x52*x96 + cell[18] + V{0.0277777777777778}) - x57*x96 + V{-0.0277777777777778};
return { -x23 + x26*(x27 + V{1}*cell[0] + V{1}*cell[11] + V{1}*cell[12] + V{1}*cell[17] + V{1}*cell[18] + V{1}*cell[2] + V{1}*cell[3] + V{1}*cell[8] + V{1}*cell[9]) + V{1}, x31 + x33 + x35 };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<1,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x20 + V{-1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[14] + V{2}*cell[2] + V{2}*cell[4] + V{2}*cell[8] + V{2}*cell[9] + V{1};
auto x28 = x27 + cell[0] + cell[10] + cell[12] + cell[15] + cell[16] + cell[1] + cell[3] + cell[6] + cell[7];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(-x30*x38 + cell[0] + V{0.333333333333333}) + x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(-x40*x43 + cell[1] + V{0.0555555555555556}) + x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(-x40*x48 + cell[2] + V{0.0555555555555556}) + x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(-x40*x51 + cell[3] + V{0.0555555555555556}) + x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(-x52*x56 + cell[4] + V{0.0277777777777778}) + x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(-x52*x61 + cell[5] + V{0.0277777777777778}) + x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(-x52*x64 + cell[6] + V{0.0277777777777778}) + x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(-x52*x67 + cell[7] + V{0.0277777777777778}) + x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(-x52*x71 + cell[8] + V{0.0277777777777778}) + x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(-x52*x74 + cell[9] + V{0.0277777777777778}) + x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(x40*x79 + cell[10] + V{0.0555555555555556}) - x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(x40*x82 + cell[11] + V{0.0555555555555556}) - x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(x40*x84 + cell[12] + V{0.0555555555555556}) - x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(x52*x85 + cell[13] + V{0.0277777777777778}) - x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(-x52*x88 + cell[14] + V{0.0277777777777778}) + x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(x52*x89 + cell[15] + V{0.0277777777777778}) - x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(-x52*x93 + cell[16] + V{0.0277777777777778}) + x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(x52*x94 + cell[17] + V{0.0277777777777778}) - x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(-x52*x96 + cell[18] + V{0.0277777777777778}) + x57*x96 + V{-0.0277777777777778};
return { -x23 - x26*(x27 + V{1}*cell[0] + V{1}*cell[10] + V{1}*cell[12] + V{1}*cell[15] + V{1}*cell[16] + V{1}*cell[1] + V{1}*cell[3] + V{1}*cell[6] + V{1}*cell[7]) + V{1}, x31 + x33 + x35 };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<1,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x20 + V{1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[11] + V{2}*cell[13] + V{2}*cell[17] + V{2}*cell[18] + V{2}*cell[5] + V{1};
auto x28 = x27 + cell[0] + cell[10] + cell[12] + cell[15] + cell[16] + cell[1] + cell[3] + cell[6] + cell[7];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = -x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(x30*x38 + cell[0] + V{0.333333333333333}) - x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(x40*x43 + cell[1] + V{0.0555555555555556}) - x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(x40*x48 + cell[2] + V{0.0555555555555556}) - x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(x40*x51 + cell[3] + V{0.0555555555555556}) - x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(x52*x56 + cell[4] + V{0.0277777777777778}) - x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(x52*x61 + cell[5] + V{0.0277777777777778}) - x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(x52*x64 + cell[6] + V{0.0277777777777778}) - x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(x52*x67 + cell[7] + V{0.0277777777777778}) - x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(x52*x71 + cell[8] + V{0.0277777777777778}) - x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(x52*x74 + cell[9] + V{0.0277777777777778}) - x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(-x40*x79 + cell[10] + V{0.0555555555555556}) + x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(-x40*x82 + cell[11] + V{0.0555555555555556}) + x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(-x40*x84 + cell[12] + V{0.0555555555555556}) + x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(-x52*x85 + cell[13] + V{0.0277777777777778}) + x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(x52*x88 + cell[14] + V{0.0277777777777778}) - x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(-x52*x89 + cell[15] + V{0.0277777777777778}) + x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(x52*x93 + cell[16] + V{0.0277777777777778}) - x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(-x52*x94 + cell[17] + V{0.0277777777777778}) + x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(x52*x96 + cell[18] + V{0.0277777777777778}) - x57*x96 + V{-0.0277777777777778};
return { -x23 + x26*(x27 + V{1}*cell[0] + V{1}*cell[10] + V{1}*cell[12] + V{1}*cell[15] + V{1}*cell[16] + V{1}*cell[1] + V{1}*cell[3] + V{1}*cell[6] + V{1}*cell[7]) + V{1}, x31 + x33 + x35 };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<2,-1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x21 + V{-1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[16] + V{2}*cell[18] + V{2}*cell[3] + V{2}*cell[6] + V{2}*cell[8] + V{1};
auto x28 = x27 + cell[0] + cell[10] + cell[11] + cell[13] + cell[14] + cell[1] + cell[2] + cell[4] + cell[5];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(-x30*x38 + cell[0] + V{0.333333333333333}) + x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(-x40*x43 + cell[1] + V{0.0555555555555556}) + x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(-x40*x48 + cell[2] + V{0.0555555555555556}) + x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(-x40*x51 + cell[3] + V{0.0555555555555556}) + x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(-x52*x56 + cell[4] + V{0.0277777777777778}) + x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(-x52*x61 + cell[5] + V{0.0277777777777778}) + x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(-x52*x64 + cell[6] + V{0.0277777777777778}) + x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(-x52*x67 + cell[7] + V{0.0277777777777778}) + x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(-x52*x71 + cell[8] + V{0.0277777777777778}) + x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(-x52*x74 + cell[9] + V{0.0277777777777778}) + x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(x40*x79 + cell[10] + V{0.0555555555555556}) - x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(x40*x82 + cell[11] + V{0.0555555555555556}) - x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(x40*x84 + cell[12] + V{0.0555555555555556}) - x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(x52*x85 + cell[13] + V{0.0277777777777778}) - x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(-x52*x88 + cell[14] + V{0.0277777777777778}) + x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(x52*x89 + cell[15] + V{0.0277777777777778}) - x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(-x52*x93 + cell[16] + V{0.0277777777777778}) + x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(x52*x94 + cell[17] + V{0.0277777777777778}) - x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(-x52*x96 + cell[18] + V{0.0277777777777778}) + x57*x96 + V{-0.0277777777777778};
return { -x23 - x26*(x27 + V{1}*cell[0] + V{1}*cell[10] + V{1}*cell[11] + V{1}*cell[13] + V{1}*cell[14] + V{1}*cell[1] + V{1}*cell[2] + V{1}*cell[4] + V{1}*cell[5]) + V{1}, x31 + x33 + x35 };
}

};

template <typename... FIELDS>
struct ConstRhoBGK::type<descriptors::D3Q19<FIELDS...>,momenta::BasicDirichletVelocityBoundaryTuple<2,1>,equilibria::SecondOrder> {

template <typename CELL, typename PARAMETERS, typename V=typename CELL::value_t>
CellStatistic<V> apply(CELL& cell, PARAMETERS& parameters) any_platform
{
auto x23 = parameters.template get<olb::statistics::AVERAGE_RHO>();
auto x21 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(2);
auto x22 = parameters.template get<olb::descriptors::OMEGA>();
auto x19 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(0);
auto x20 = cell.template getFieldComponent<olb::momenta::FixedVelocityMomentumGeneric::VELOCITY>(1);
auto x24 = x22 + V{-1};
auto x25 = x21 + V{1};
auto x26 = V{1} / (x25);
auto x27 = V{2}*cell[12] + V{2}*cell[15] + V{2}*cell[17] + V{2}*cell[7] + V{2}*cell[9] + V{1};
auto x28 = x27 + cell[0] + cell[10] + cell[11] + cell[13] + cell[14] + cell[1] + cell[2] + cell[4] + cell[5];
auto x29 = x26*x28;
auto x30 = V{0.333333333333333}*x29;
auto x31 = x19*x19;
auto x32 = V{1.5}*x31;
auto x33 = x20*x20;
auto x34 = V{1.5}*x33;
auto x35 = x21*x21;
auto x36 = V{1.5}*x35;
auto x37 = x34 + x36 + V{-1};
auto x38 = x32 + x37;
auto x39 = -x25*(x23 + V{-1})/x28 + V{1};
auto x40 = V{0.0555555555555556}*x29;
auto x41 = V{3}*x19;
auto x42 = V{3}*x31;
auto x43 = x37 + x41 - x42;
auto x44 = x39*x40;
auto x45 = V{3}*x20;
auto x46 = V{3}*x33;
auto x47 = x32 + V{-1};
auto x48 = x36 + x45 - x46 + x47;
auto x49 = V{3}*x21;
auto x50 = V{3}*x35;
auto x51 = x34 + x47 + x49 - x50;
auto x52 = V{0.0277777777777778}*x29;
auto x53 = x19 + x20;
auto x54 = V{4.5}*(x53*x53);
auto x55 = x38 + x41;
auto x56 = x45 - x54 + x55;
auto x57 = x39*x52;
auto x58 = -x45;
auto x59 = -x19;
auto x60 = x20 + x59;
auto x61 = x55 + x58 - V{4.5}*x60*x60;
auto x62 = x19 + x21;
auto x63 = V{4.5}*(x62*x62);
auto x64 = x49 + x55 - x63;
auto x65 = -x49;
auto x66 = x21 + x59;
auto x67 = x55 + x65 - V{4.5}*x66*x66;
auto x68 = x20 + x21;
auto x69 = V{4.5}*(x68*x68);
auto x70 = x38 + x45;
auto x71 = x49 - x69 + x70;
auto x72 = -x20;
auto x73 = x21 + x72;
auto x74 = x65 + x70 - V{4.5}*x73*x73;
auto x75 = -x34;
auto x76 = V{1} - x36;
auto x77 = x75 + x76;
auto x78 = x41 + x77;
auto x79 = x42 + x78;
auto x80 = -x32;
auto x81 = x45 + x80;
auto x82 = x46 + x76 + x81;
auto x83 = x49 + x80;
auto x84 = x50 + x75 + x83 + V{1};
auto x85 = x54 + x78 + x81;
auto x86 = -x41;
auto x87 = x19 + x72;
auto x88 = x70 + x86 - V{4.5}*x87*x87;
auto x89 = x63 + x78 + x83;
auto x90 = -x21;
auto x91 = x19 + x90;
auto x92 = x38 + x49;
auto x93 = x86 + x92 - V{4.5}*x91*x91;
auto x94 = x49 + x69 + x77 + x81;
auto x95 = x20 + x90;
auto x96 = x58 + x92 - V{4.5}*x95*x95;
cell[0] = -x24*(x30*x38 + cell[0] + V{0.333333333333333}) - x30*x38*x39 + V{-0.333333333333333};
cell[1] = -x24*(x40*x43 + cell[1] + V{0.0555555555555556}) - x43*x44 + V{-0.0555555555555556};
cell[2] = -x24*(x40*x48 + cell[2] + V{0.0555555555555556}) - x44*x48 + V{-0.0555555555555556};
cell[3] = -x24*(x40*x51 + cell[3] + V{0.0555555555555556}) - x44*x51 + V{-0.0555555555555556};
cell[4] = -x24*(x52*x56 + cell[4] + V{0.0277777777777778}) - x56*x57 + V{-0.0277777777777778};
cell[5] = -x24*(x52*x61 + cell[5] + V{0.0277777777777778}) - x57*x61 + V{-0.0277777777777778};
cell[6] = -x24*(x52*x64 + cell[6] + V{0.0277777777777778}) - x57*x64 + V{-0.0277777777777778};
cell[7] = -x24*(x52*x67 + cell[7] + V{0.0277777777777778}) - x57*x67 + V{-0.0277777777777778};
cell[8] = -x24*(x52*x71 + cell[8] + V{0.0277777777777778}) - x57*x71 + V{-0.0277777777777778};
cell[9] = -x24*(x52*x74 + cell[9] + V{0.0277777777777778}) - x57*x74 + V{-0.0277777777777778};
cell[10] = -x24*(-x40*x79 + cell[10] + V{0.0555555555555556}) + x44*x79 + V{-0.0555555555555556};
cell[11] = -x24*(-x40*x82 + cell[11] + V{0.0555555555555556}) + x44*x82 + V{-0.0555555555555556};
cell[12] = -x24*(-x40*x84 + cell[12] + V{0.0555555555555556}) + x44*x84 + V{-0.0555555555555556};
cell[13] = -x24*(-x52*x85 + cell[13] + V{0.0277777777777778}) + x57*x85 + V{-0.0277777777777778};
cell[14] = -x24*(x52*x88 + cell[14] + V{0.0277777777777778}) - x57*x88 + V{-0.0277777777777778};
cell[15] = -x24*(-x52*x89 + cell[15] + V{0.0277777777777778}) + x57*x89 + V{-0.0277777777777778};
cell[16] = -x24*(x52*x93 + cell[16] + V{0.0277777777777778}) - x57*x93 + V{-0.0277777777777778};
cell[17] = -x24*(-x52*x94 + cell[17] + V{0.0277777777777778}) + x57*x94 + V{-0.0277777777777778};
cell[18] = -x24*(x52*x96 + cell[18] + V{0.0277777777777778}) - x57*x96 + V{-0.0277777777777778};
return { -x23 + x26*(x27 + V{1}*cell[0] + V{1}*cell[10] + V{1}*cell[11] + V{1}*cell[13] + V{1}*cell[14] + V{1}*cell[1] + V{1}*cell[2] + V{1}*cell[4] + V{1}*cell[5]) + V{1}, x31 + x33 + x35 };
}

};




}

}

#endif

#endif
