/**********************************************************************
 *                                                                    *
 * tgt - Tiny Graphics Toolbox                                        *
 *                                                                    *
 * Copyright (C) 2005-2024 University of Muenster, Germany,           *
 * Department of Computer Science.                                    *
 *                                                                    *
 * This file is part of the tgt library. This library is free         *
 * software; you can redistribute it and/or modify it under the terms *
 * of the GNU Lesser General Public License version 2.1 as published  *
 * by the Free Software Foundation.                                   *
 *                                                                    *
 * This library is distributed in the hope that it will be useful,    *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the       *
 * GNU Lesser General Public License for more details.                *
 *                                                                    *
 * You should have received a copy of the GNU Lesser General Public   *
 * License in the file "LICENSE.txt" along with this library.         *
 * If not, see <http://www.gnu.org/licenses/>.                        *
 *                                                                    *
 **********************************************************************/

#include "tgt/painter.h"
#include "tgt/glcanvas.h"
#include "tgt/assert.h"

namespace tgt {

Painter::Painter(GLCanvas* canvas)
    : canvas_(canvas)
    , initialized_(false)
{
    tgtAssert(canvas,"no canvas");
    canvas->setPainter(this);
}


void Painter::initialize(){
    tgtAssert(!initialized_,"painter has been initialized already");
    initialized_ = true;
    sizeChanged(canvas_->getSize());
}

} // namespace tgt
