/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2021 University of Muenster, Germany,                        *
 * Department of Computer Science.                                                 *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

// Automatically generated by genTemplates.py

#ifndef VRN_VOLUMETHINNING_TEMPLATES_H
#define VRN_VOLUMETHINNING_TEMPLATES_H

#include "tgt/vector.h"
#include "volumemask.h"

namespace { // anonymous name space
const int8_t deleteTemplates[][3][3][3] = {
{ //a1
{{-1, 0, 0,},{-1, 0, 0,},{-1, 0, 0,},},
{{-1, 0, 0,},{-1, 1, 1,},{-1, 0, 0,},},
{{-1, 0, 0,},{-1, 0, 0,},{-1, 0, 0,},},
},

{ //a2
{{ 0, 0,-1,},{ 0, 0,-1,},{ 0, 0,-1,},},
{{ 0, 0,-1,},{ 1, 1,-1,},{ 0, 0,-1,},},
{{ 0, 0,-1,},{ 0, 0,-1,},{ 0, 0,-1,},},
},

{ //a3
{{-1,-1,-1,},{ 0, 0, 0,},{ 0, 0, 0,},},
{{-1,-1,-1,},{ 0, 1, 0,},{ 0, 1, 0,},},
{{-1,-1,-1,},{ 0, 0, 0,},{ 0, 0, 0,},},
},

{ //a4
{{ 0, 0, 0,},{ 0, 0, 0,},{-1,-1,-1,},},
{{ 0, 1, 0,},{ 0, 1, 0,},{-1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 0, 0,},{-1,-1,-1,},},
},

{ //a5
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //a6
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //b1 
{{ 0,-1,-1,},{ 0, 0,-1,},{ 0, 0, 0,},},
{{ 0,-1,-1,},{ 1, 1,-1,},{ 0, 1, 0,},},
{{ 0,-1,-1,},{ 0, 0,-1,},{ 0, 0, 0,},},
},

{ //b2 
{{-1,-1, 0,},{-1, 0, 0,},{ 0, 0, 0,},},
{{-1,-1, 0,},{-1, 1, 1,},{ 0, 1, 0,},},
{{-1,-1, 0,},{-1, 0, 0,},{ 0, 0, 0,},},
},

{ //b3 
{{ 0, 0, 0,},{-1, 0, 0,},{-1,-1, 0,},},
{{ 0, 1, 0,},{-1, 1, 1,},{-1,-1, 0,},},
{{ 0, 0, 0,},{-1, 0, 0,},{-1,-1, 0,},},
},

{ //b4 
{{ 0, 0, 0,},{ 0, 0,-1,},{ 0,-1,-1,},},
{{ 0, 1, 0,},{ 1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0, 0,},{ 0, 0,-1,},{ 0,-1,-1,},},
},

{ //b9 
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
{{ 0, 0,-1,},{ 1, 1,-1,},{ 0, 0,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //b6 
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
{{-1,-1,-1,},{ 0, 1, 0,},{ 0, 1, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //b10
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
{{-1, 0, 0,},{-1, 1, 1,},{-1, 0, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //b5 
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0, 1, 0,},{ 0, 1, 0,},{-1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //b11
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 0,-1,},{ 1, 1,-1,},{ 0, 0,-1,},},
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
},

{ //b8 
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1,-1,},{ 0, 1, 0,},{ 0, 1, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
},

{ //b12
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1, 0, 0,},{-1, 1, 1,},{-1, 0, 0,},},
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
},

{ //b7 
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 1, 0,},{ 0, 1, 0,},{-1,-1,-1,},},
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //c4
{{ 0, 0, 0,},{ 0,-1,-1,},{ 0,-1,-1,},},
{{ 0, 1, 0,},{ 1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //c1
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0, 0, 0,},},
{{ 0,-1,-1,},{ 1, 1,-1,},{ 0, 1, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //c2
{{-1,-1, 0,},{-1,-1, 0,},{ 0, 0, 0,},},
{{-1,-1, 0,},{-1, 1, 1,},{ 0, 1, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //c3
{{ 0, 0, 0,},{-1,-1, 0,},{-1,-1, 0,},},
{{ 0, 1, 0,},{-1, 1, 1,},{-1,-1, 0,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //c8
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 1, 0,},{ 1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0, 0,},{ 0,-1,-1,},{ 0,-1,-1,},},
},

{ //c5
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0,-1,-1,},{ 1, 1,-1,},{ 0, 1, 0,},},
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0, 0, 0,},},
},

{ //c6
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1, 0,},{-1, 1, 1,},{ 0, 1, 0,},},
{{-1,-1, 0,},{-1,-1, 0,},{ 0, 0, 0,},},
},

{ //c7
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 0, 1, 0,},{-1, 1, 1,},{-1,-1, 0,},},
{{ 0, 0, 0,},{-1,-1, 0,},{-1,-1, 0,},},
},

{ //d2 -1
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0,-1, 0,},{-1, 1,-1,},{-1,-1,-1,},},
{{ 0, 1, 0,},{ 0,-1, 0,},{-1,-1,-1,},},
},

{ //d2 -1
{{ 0, 1, 0,},{ 0,-1, 0,},{-1,-1,-1,},},
{{ 0,-1, 0,},{-1, 1,-1,},{-1,-1,-1,},},
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d10-1
{{-1,-1,-1,},{ 0,-1, 0,},{ 0, 1, 0,},},
{{-1,-1,-1,},{-1, 1,-1,},{ 0,-1, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d9 -1
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
{{-1,-1,-1,},{-1, 1,-1,},{ 0,-1, 0,},},
{{-1,-1,-1,},{ 0,-1, 0,},{ 0, 1, 0,},},
},

{ //d3 -1
{{ 0, 0,-1,},{ 0,-1,-1,},{-1,-1,-1,},},
{{ 1,-1,-1,},{-1, 1,-1,},{-1,-1,-1,},},
{{ 0, 0,-1,},{ 0,-1,-1,},{-1,-1,-1,},},
},

{ //d4 -1
{{-1, 0, 0,},{-1,-1, 0,},{-1,-1,-1,},},
{{-1,-1, 1,},{-1, 1,-1,},{-1,-1,-1,},},
{{-1, 0, 0,},{-1,-1, 0,},{-1,-1,-1,},},
},

{ //d7 -1
{{-1,-1,-1,},{-1,-1, 0,},{-1, 0, 0,},},
{{-1,-1,-1,},{-1, 1,-1,},{-1,-1, 1,},},
{{-1,-1,-1,},{-1,-1, 0,},{-1, 0, 0,},},
},

{ //d8 -1
{{-1,-1,-1,},{ 0,-1,-1,},{ 0, 0,-1,},},
{{-1,-1,-1,},{-1, 1,-1,},{ 1,-1,-1,},},
{{-1,-1,-1,},{ 0,-1,-1,},{ 0, 0,-1,},},
},

{ //d5 -1
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0,-1,-1,},{-1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0,-1,},{ 1,-1,-1,},{ 0, 0,-1,},},
},

{ //d6 -1
{{ 0, 0,-1,},{ 1,-1,-1,},{ 0, 0,-1,},},
{{ 0,-1,-1,},{-1, 1,-1,},{ 0,-1,-1,},},
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d11-1
{{-1, 0, 0,},{-1,-1, 1,},{-1, 0, 0,},},
{{-1,-1, 0,},{-1, 1,-1,},{-1,-1, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d12-1
{{-1,-1,-1,},{-1,-1,-1,},{-1,-1,-1,},},
{{-1,-1, 0,},{-1, 1,-1,},{-1,-1, 0,},},
{{-1, 0, 0,},{-1,-1, 1,},{-1, 0, 0,},},
},

{ //d1 -2
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
{{ 0,-1, 0,},{-1, 1, 1,},{-1,-1, 0,},},
{{ 0, 1, 0,},{ 0,-1, 0,},{-1,-1, 0,},},
},

{ //d2 -2
{{ 0, 1, 0,},{ 0,-1, 0,},{-1,-1, 0,},},
{{ 0,-1, 0,},{-1, 1, 1,},{-1,-1, 0,},},
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
},

{ //d10-2
{{-1,-1, 0,},{ 0,-1, 0,},{ 0, 1, 0,},},
{{-1,-1, 0,},{-1, 1, 1,},{ 0,-1, 0,},},
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
},

{ //d9 -2
{{-1,-1, 0,},{-1,-1, 0,},{-1,-1, 0,},},
{{-1,-1, 0,},{-1, 1, 1,},{ 0,-1, 0,},},
{{-1,-1, 0,},{ 0,-1, 0,},{ 0, 1, 0,},},
},

{ //d3 -2
{{ 0, 0,-1,},{ 0,-1,-1,},{-1,-1,-1,},},
{{ 1,-1,-1,},{-1, 1,-1,},{-1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //d4 -2
{{-1, 0, 0,},{-1,-1, 0,},{-1,-1,-1,},},
{{-1,-1, 1,},{-1, 1,-1,},{-1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //d7 -2
{{-1,-1,-1,},{-1,-1, 0,},{-1, 0, 0,},},
{{-1,-1,-1,},{-1, 1,-1,},{-1,-1, 1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //d8 -2
{{-1,-1,-1,},{ 0,-1,-1,},{ 0, 0,-1,},},
{{-1,-1,-1,},{-1, 1,-1,},{ 1,-1,-1,},},
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
},

{ //d5 -2
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0, 1, 0,},{-1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0, 0,},{ 1,-1,-1,},{ 0, 0,-1,},},
},

{ //d6 -2
{{ 0, 0, 0,},{ 1,-1,-1,},{ 0, 0,-1,},},
{{ 0, 1, 0,},{-1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d11-2
{{ 0, 0, 0,},{-1,-1, 1,},{-1, 0, 0,},},
{{ 0, 1, 0,},{-1, 1,-1,},{-1,-1, 0,},},
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
},

{ //d12-2
{{ 0, 0, 0,},{-1,-1,-1,},{-1,-1,-1,},},
{{ 0, 1, 0,},{-1, 1,-1,},{-1,-1, 0,},},
{{ 0, 0, 0,},{-1,-1, 1,},{-1, 0, 0,},},
},

{ //d1 -3
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
{{ 0,-1, 0,},{ 1, 1,-1,},{ 0,-1,-1,},},
{{ 0, 1, 0,},{ 0,-1, 0,},{ 0,-1,-1,},},
},

{ //d2 -3
{{ 0, 1, 0,},{ 0,-1, 0,},{ 0,-1,-1,},},
{{ 0,-1, 0,},{ 1, 1,-1,},{ 0,-1,-1,},},
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
},

{ //d10-3
{{ 0,-1,-1,},{ 0,-1, 0,},{ 0, 1, 0,},},
{{ 0,-1,-1,},{ 1, 1,-1,},{ 0,-1, 0,},},
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
},

{ //d9 -3
{{ 0,-1,-1,},{ 0,-1,-1,},{ 0,-1,-1,},},
{{ 0,-1,-1,},{ 1, 1,-1,},{ 0,-1, 0,},},
{{ 0,-1,-1,},{ 0,-1, 0,},{ 0, 1, 0,},},
},

{ //d3 -3
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{ 1,-1,-1,},{-1, 1,-1,},{-1,-1,-1,},},
{{ 0, 0,-1,},{ 0,-1,-1,},{-1,-1,-1,},},
},

{ //d4 -3
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1, 1,},{-1, 1,-1,},{-1,-1,-1,},},
{{-1, 0, 0,},{-1,-1, 0,},{-1,-1,-1,},},
},

{ //d7 -3
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1,-1,},{-1, 1,-1,},{-1,-1, 1,},},
{{-1,-1,-1,},{-1,-1, 0,},{-1, 0, 0,},},
},

{ //d8 -3
{{ 0, 0, 0,},{ 0, 1, 0,},{ 0, 0, 0,},},
{{-1,-1,-1,},{-1, 1,-1,},{ 1,-1,-1,},},
{{-1,-1,-1,},{ 0,-1,-1,},{ 0, 0,-1,},},
},

{ //d5 -3
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
{{ 0,-1,-1,},{-1, 1,-1,},{ 0, 1, 0,},},
{{ 0, 0,-1,},{ 1,-1,-1,},{ 0, 0, 0,},},
},

{ //d6 -3
{{ 0, 0,-1,},{ 1,-1,-1,},{ 0, 0, 0,},},
{{ 0,-1,-1,},{-1, 1,-1,},{ 0, 1, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
},

{ //d11-3
{{-1, 0, 0,},{-1,-1, 1,},{ 0, 0, 0,},},
{{-1,-1, 0,},{-1, 1,-1,},{ 0, 1, 0,},},
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
},

{ //d12-3
{{-1,-1,-1,},{-1,-1,-1,},{ 0, 0, 0,},},
{{-1,-1, 0,},{-1, 1,-1,},{ 0, 1, 0,},},
{{-1, 0, 0,},{-1,-1, 1,},{ 0, 0, 0,},},
},

};
const std::string templateNames[] = {
"a1",
"a2",
"a3",
"a4",
"a5",
"a6",
"b1 ",
"b2 ",
"b3 ",
"b4 ",
"b9 ",
"b6 ",
"b10",
"b5 ",
"b11",
"b8 ",
"b12",
"b7 ",
"c4",
"c1",
"c2",
"c3",
"c8",
"c5",
"c6",
"c7",
"d2 -1",
"d2 -1",
"d10-1",
"d9 -1",
"d3 -1",
"d4 -1",
"d7 -1",
"d8 -1",
"d5 -1",
"d6 -1",
"d11-1",
"d12-1",
"d1 -2",
"d2 -2",
"d10-2",
"d9 -2",
"d3 -2",
"d4 -2",
"d7 -2",
"d8 -2",
"d5 -2",
"d6 -2",
"d11-2",
"d12-2",
"d1 -3",
"d2 -3",
"d10-3",
"d9 -3",
"d3 -3",
"d4 -3",
"d7 -3",
"d8 -3",
"d5 -3",
"d6 -3",
"d11-3",
"d12-3",
};
int8_t readRelative(const voreen::VolumeMask* vol, const tgt::svec3& p, int dx, int dy, int dz);

bool fitsExpandedTemplate(const voreen::VolumeMask* vol, tgt::svec3 p, size_t templateNum) {
    switch(templateNum) {
       case 1: // a2
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 3: // a4
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 5: // a6
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        break;
       case 6: // b1 
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 8: // b3 
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 9: // b4 
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 10: // b9 
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 13: // b5 
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 14: // b11
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 15: // b8 
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        break;
       case 16: // b12
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        break;
       case 17: // b7 
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 18: // c4
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 19: // c1
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 21: // c3
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 22: // c8
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 23: // c5
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,-2,0,0) == -1) {
                return false;
            }
        break;
       case 24: // c6
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        break;
       case 25: // c7
            if(readRelative(vol,p,0,0,-2) == -1) {
                return false;
            }
        
            if(readRelative(vol,p,0,-2,0) == -1) {
                return false;
            }
        break;
       case 26: // d2 -1
            if(   readRelative(vol,p,0,-1*0,1*2) == -1
               && readRelative(vol,p,0,-1*1,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*1) == -1
               && readRelative(vol,p,0,-1*2,1*0) == -1)
            {
                return false;
            }
            break;
       case 27: // d2 -1
            if(   readRelative(vol,p,0,-1*0,-1*2) == -1
               && readRelative(vol,p,0,-1*1,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*1) == -1
               && readRelative(vol,p,0,-1*2,-1*0) == -1)
            {
                return false;
            }
            break;
       case 30: // d3 -1
            if(   readRelative(vol,p,-1*0,-1*2,0) == -1
               && readRelative(vol,p,-1*1,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*1,0) == -1
               && readRelative(vol,p,-1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 31: // d4 -1
            if(   readRelative(vol,p,1*0,-1*2,0) == -1
               && readRelative(vol,p,1*1,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*1,0) == -1
               && readRelative(vol,p,1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 34: // d5 -1
            if(   readRelative(vol,p,-1*0,0,1*2) == -1
               && readRelative(vol,p,-1*1,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*1) == -1
               && readRelative(vol,p,-1*2,0,1*0) == -1)
            {
                return false;
            }
            break;
       case 35: // d6 -1
            if(   readRelative(vol,p,-1*0,0,-1*2) == -1
               && readRelative(vol,p,-1*1,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*1) == -1
               && readRelative(vol,p,-1*2,0,-1*0) == -1)
            {
                return false;
            }
            break;
       case 38: // d1 -2
            if(   readRelative(vol,p,0,-1*0,1*2) == -1
               && readRelative(vol,p,0,-1*1,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*1) == -1
               && readRelative(vol,p,0,-1*2,1*0) == -1)
            {
                return false;
            }
            break;
       case 39: // d2 -2
            if(   readRelative(vol,p,0,-1*0,-1*2) == -1
               && readRelative(vol,p,0,-1*1,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*1) == -1
               && readRelative(vol,p,0,-1*2,-1*0) == -1)
            {
                return false;
            }
            break;
       case 42: // d3 -2
            if(   readRelative(vol,p,-1*0,-1*2,0) == -1
               && readRelative(vol,p,-1*1,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*1,0) == -1
               && readRelative(vol,p,-1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 43: // d4 -2
            if(   readRelative(vol,p,1*0,-1*2,0) == -1
               && readRelative(vol,p,1*1,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*1,0) == -1
               && readRelative(vol,p,1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 46: // d5 -2
            if(   readRelative(vol,p,-1*0,0,1*2) == -1
               && readRelative(vol,p,-1*1,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*1) == -1
               && readRelative(vol,p,-1*2,0,1*0) == -1)
            {
                return false;
            }
            break;
       case 47: // d6 -2
            if(   readRelative(vol,p,-1*0,0,-1*2) == -1
               && readRelative(vol,p,-1*1,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*1) == -1
               && readRelative(vol,p,-1*2,0,-1*0) == -1)
            {
                return false;
            }
            break;
       case 50: // d1 -3
            if(   readRelative(vol,p,0,-1*0,1*2) == -1
               && readRelative(vol,p,0,-1*1,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*2) == -1
               && readRelative(vol,p,0,-1*2,1*1) == -1
               && readRelative(vol,p,0,-1*2,1*0) == -1)
            {
                return false;
            }
            break;
       case 51: // d2 -3
            if(   readRelative(vol,p,0,-1*0,-1*2) == -1
               && readRelative(vol,p,0,-1*1,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*2) == -1
               && readRelative(vol,p,0,-1*2,-1*1) == -1
               && readRelative(vol,p,0,-1*2,-1*0) == -1)
            {
                return false;
            }
            break;
       case 54: // d3 -3
            if(   readRelative(vol,p,-1*0,-1*2,0) == -1
               && readRelative(vol,p,-1*1,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*2,0) == -1
               && readRelative(vol,p,-1*2,-1*1,0) == -1
               && readRelative(vol,p,-1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 55: // d4 -3
            if(   readRelative(vol,p,1*0,-1*2,0) == -1
               && readRelative(vol,p,1*1,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*2,0) == -1
               && readRelative(vol,p,1*2,-1*1,0) == -1
               && readRelative(vol,p,1*2,-1*0,0) == -1)
            {
                return false;
            }
            break;
       case 58: // d5 -3
            if(   readRelative(vol,p,-1*0,0,1*2) == -1
               && readRelative(vol,p,-1*1,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*2) == -1
               && readRelative(vol,p,-1*2,0,1*1) == -1
               && readRelative(vol,p,-1*2,0,1*0) == -1)
            {
                return false;
            }
            break;
       case 59: // d6 -3
            if(   readRelative(vol,p,-1*0,0,-1*2) == -1
               && readRelative(vol,p,-1*1,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*2) == -1
               && readRelative(vol,p,-1*2,0,-1*1) == -1
               && readRelative(vol,p,-1*2,0,-1*0) == -1)
            {
                return false;
            }
            break;

    }
    return true;

}
} // end of anonymous name space
#endif  // VRN_VOLUMETHINNING_TEMPLATES_H
