/**********************************************************************
 *                                                                    *
 * tgt - Tiny Graphics Toolbox                                        *
 *                                                                    *
 * Copyright (C) 2005-2021 University of Muenster, Germany,           *
 * Department of Computer Science.                                    *
 *                                                                    *
 * This file is part of the tgt library. This library is free         *
 * software; you can redistribute it and/or modify it under the terms *
 * of the GNU Lesser General Public License version 2.1 as published  *
 * by the Free Software Foundation.                                   *
 *                                                                    *
 * This library is distributed in the hope that it will be useful,    *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the       *
 * GNU Lesser General Public License for more details.                *
 *                                                                    *
 * You should have received a copy of the GNU Lesser General Public   *
 * License in the file "LICENSE.txt" along with this library.         *
 * If not, see <http://www.gnu.org/licenses/>.                        *
 *                                                                    *
 **********************************************************************/

#ifndef TGT_TEXTUREREADERTGA_H
#define TGT_TEXTUREREADERTGA_H

#include "tgt/texturereader.h"

namespace tgt {

    /**
     * Texture reader to read compressed and uncompressed RGB and RGBA tga files.
     * No external dependencies!
     */
class TextureReaderTga : public TextureReader {
public:
    /** Constructor. Sets readerName_ and supportedEndings_. */
    TextureReaderTga();
    /** @override */
    virtual Texture* loadTexture(const std::string& filename, Texture::Filter filter, Texture::Wrapping wrapping, bool compress = false,
                                 bool keepPixels = false, bool uploadTexture = true, bool extend3To4Channels = false) override;
protected:
    static const std::string loggerCat_;    ///< used for logging
};

} // namespace tgt

#endif // TGT_TEXTUREREADERTGA_H
