/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2013 University of Muenster, Germany.                        *
 * Visualization and Computer Graphics Group <http://viscg.uni-muenster.de>        *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

//incude header file
#include "samplemodule.h"

// include classes to be registered
#include "processors/sampleprocessor.h"
#include "processors/samplerenderprocessor.h"

//use voreen namespace
namespace voreen {

SampleModule::SampleModule(const std::string& modulePath) 
    : VoreenModule(modulePath)
{
    // module name to be used internally
    setID("Sample Module");

    // module name to be used in the GUI
    setGuiName("Sample Module");

    // each module processor needs to be registered
    registerProcessor(new SampleProcessor());
    registerProcessor(new SampleRenderProcessor());

    // adds the module glsl dir to the shader search path (if shaders are needed in the module)
    addShaderPath(getModulePath("glsl"));
}

std::string SampleModule::getDescription() const { 
    return "My first sample module.";
}

} // namespace
