/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2012 University of Muenster, Germany.                        *
 * Visualization and Computer Graphics Group <http://viscg.uni-muenster.de>        *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

#ifndef VRN_GEOMETRYCLIPPING_H
#define VRN_GEOMETRYCLIPPING_H

#include "voreen/core/processors/processor.h"
#include "voreen/core/ports/allports.h"

#include "voreen/core/properties/vectorproperty.h"
#include "voreen/core/properties/floatproperty.h"
#include "voreen/core/properties/boolproperty.h"

namespace voreen {

/**
 * Clips the input geometry against an arbitrarily oriented clipping plane.
 */
class GeometryClipping : public Processor {
public:
    GeometryClipping();
    virtual ~GeometryClipping();
    virtual Processor* create() const;

    virtual std::string getClassName() const { return "GeometryClipping"; }
    virtual std::string getCategory() const  { return "Geometry";         }
    virtual CodeState getCodeState() const   { return CODE_STATE_STABLE;  }

protected:
    virtual void setDescriptions() {
        setDescription("Clips the input geometry against an arbitrarily oriented clipping plane.\
<p>See GeometryClippingWidget for a convenient manipulation of the plane.</p>");
    }

    virtual void process();

    GeometryPort inport_;        ///< Inport for a list of mesh geometries to clip.
    GeometryPort outport_;       ///< Outport for a list of mesh geometries that were clipped.

    BoolProperty enabled_;       ///< Determines whether the clipping is performed.
    BoolProperty invert_;        ///< Determines whether the normal should be inverted.
    FloatVec3Property normal_;   ///< Clipping plane normal
    FloatProperty position_;     ///< Clipping plane position (distance to the world origin)

    /// category used in logging
    static const std::string loggerCat_;
};

} //namespace

#endif // VRN_MESHCLIPPING_H
