/***********************************************************************************
 *                                                                                 *
 * Voreen - The Volume Rendering Engine                                            *
 *                                                                                 *
 * Copyright (C) 2005-2012 University of Muenster, Germany.                        *
 * Visualization and Computer Graphics Group <http://viscg.uni-muenster.de>        *
 * For a list of authors please refer to the file "CREDITS.txt".                   *
 *                                                                                 *
 * This file is part of the Voreen software package. Voreen is free software:      *
 * you can redistribute it and/or modify it under the terms of the GNU General     *
 * Public License version 2 as published by the Free Software Foundation.          *
 *                                                                                 *
 * Voreen is distributed in the hope that it will be useful, but WITHOUT ANY       *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR   *
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.      *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License in the file   *
 * "LICENSE.txt" along with this file. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                                 *
 * For non-commercial academic use see the license exception specified in the file *
 * "LICENSE-academic.txt". To get information about commercial licensing please    *
 * contact the authors.                                                            *
 *                                                                                 *
 ***********************************************************************************/

#ifndef VRN_PROGRESSBARGRAPHICSITEM_H
#define VRN_PROGRESSBARGRAPHICSITEM_H

#include <QGraphicsItem>
#include "voreen/core/io/progressbar.h"

#include "networkeditor_common.h"

#include <QTime>

namespace voreen {

class ProgressBarGraphicsItem : public QGraphicsItem, public ProgressBar {
public:
    ProgressBarGraphicsItem(QGraphicsItem* parent, const QPointF& center, qreal width, qreal height);

    /// The type of this QGraphicsItem subclass
    enum {Type = UserType + UserTypesProgressBarGraphicsItem};

    /**
     * Returns the type of this class. Necessary for all QGraphicsItem subclasses.
     * \return The type of this class
     */
    int type() const;

    QRectF boundingRect() const;

    void show();
    void hide();
    void forceUpdate();
    void update();

    void resize(const QPointF& center, qreal width, qreal height);

    void setProgressTier(int tier);

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget);

    QRectF boundingRect_;
    QTime time_;

    QColor backgroundColor1_;
    QColor backgroundColor2_;
    QColor upperForegroundColor1_;
    QColor upperForegroundColor2_;
    QColor lowerForegroundColor_;
};

} // namespace

#endif // VRN_PROGRESSBARGRAPHICSITEM_H
