%% test_dpe tests the dpe toolbox with a string dataset

%% set parameters (see dpe_embedding and dpe_reconstruction for more options)
embedding_method = 'sammon';
reconstruction_method = 'best_recursive';
dimension = 40;



%% load a dataset
string_sets = load('darwin.mat');
length = 2;
line = 2;
string_set = string_sets.stringClusters{length,2}{line,2};

% set distance function and weighted mean function
dist_func = @dpe_string_dist_func_mex;
weighted_mean_func = @dpe_string_weighted_mean_func;
%uncomment for distance function without mex:
%dist_func = @dpe_string_dist_func;


%% Calculate the generalized median using distance preserving embedding methods
% 1: calculate the embedding
embedding = dpe_embedding(string_set,embedding_method,round(numel(string_set)*dimension/100),dist_func);

% 2: calculate the median in vector space
median_vector = dpe_median_vector(embedding);

% 3: reconstruct the median in object space
[gen_median, SOD_gen_median] = dpe_reconstruction(median_vector,embedding,string_set,dist_func,weighted_mean_func,reconstruction_method);



%% print results:
[set_median, set_index, SOD_set_median] = dpe_set_median(string_set,dist_func);
SOD_lower_bound = dpe_find_lower_bound(dpe_pdist(string_set,dist_func));

fprintf('<strong>Sum of Distances:</strong>\n');
fprintf('Lower Bound: \t\t%d\n',SOD_lower_bound);
fprintf('Generalized Median: \t%d\n',SOD_gen_median);
fprintf('Set Median: \t\t%d\n',SOD_set_median);
 
