%DPE_SET_MEDIAN calculates the set median of a set of objects
%
% set:			items
% dist_func:	distance function ((set x, set x) -> R)
% med:			median item of the set
% index:		index of the median in the set
% SOD:			sum of distance of the median
function [med, index, SOD] = dpe_set_median(set, dist_func)
	% get the number of items
    stringCount = length(set);
	% create a quadratic matrix
    D = zeros(stringCount);
	% for all cells of the upper triangle
    for index = 2:stringCount
        for j = 1:index-1
			% calculate the distance
            D(index,j) = dist_func(set{index}, set{j});
            D(j,index) = D(index,j);
        end
    end
	% get the minimum distance
    [SOD, index] = min(sum(D,2));
	% get the element with minimum distance
    med = set{index};
end

