function [ percentage ] = dpe_project_point_on_line( v1, v2, p )
%DPE_PROJECT_POINT_ON_LINE Projects Point p on line v1 v2 and returns the percentage position on vector v1 v2
% percentage = 0 -> projection = v1
% percentage = 1 -> projection = v2
% percentage = 0.5 -> projection is in the middle between v1 and v2
%
% see: https://en.wikibooks.org/wiki/Linear_Algebra/Orthogonal_Projection_Onto_a_Line

     % transform to origin
     v = p - v1;
     s = v2 - v1;
     
    % calculate projection
    percentage = v * s' / (s * s');
    
    
    % handle borders
    if (percentage < 0)
        percentage = 0;
    end
        
    if (percentage > 1)
        percentage = 1;
    end
end

