function D = dpe_pdist( set, varargin)% dist_func )
%dpe_pdist implementation of pdist that does not require the distance
%function to work with vectors
%Parameters:
%     set         - Set of objects
%     cell array  - Only calculates distances between set and objects in this array
%     function    - Uses this function as distance function. Default: euclidean distance between vectors

% use euclidean distance if no other distance is used
dist_func = @(x,y) sqrt(norm(x - y));
subset = NaN;

for args = 1:nargin-1
    if (iscell(varargin{args}))
        subset = varargin{args};
    end

    if (isa(varargin{args},'function_handle'))
        dist_func = varargin{args};
    end
end

if (~iscell(subset));
    % calculate the pairwise distances with the set itself
    n = length(set);
    D = zeros(n);

    for x = 2:n
        for y = 1:x-1
            D(x,y) = dist_func(set{x}, set{y});
            D(y,x) = D(x,y);
        end
    end
else
    
    % calculate the pairwise distances between the set and the subset
    n = length(set);
    m = length(subset);
    D = zeros(n,m);

    for x = 1:n
        for y = 1:m
            D(x,y) = dist_func(set{x}, subset{y});
        end
    end

end

