%DPE_GROUP_ELEMENTS removes duplicates from a set and its embedding
% Points with the same embedding are replaced by a single point
%
% E:        embedding of the set with points as rows
% set:      list of cells which contains the items
% func:     function to handle points with same embedding-points
function [unique_embedding, unique_set] = dpe_group_elements(embedding, set, func)
    % reduce percision, to group very close points too
    embedding = round(embedding * 1000) / 1000;
    % create a unique embedding
    unique_embedding = unique(embedding, 'rows');
    % get length for the unique embedding
    n_new = size(unique_embedding, 1);
    
    % if the embedding E is not unique
    if n_new < length(embedding)
        % create a new set for the unique embedding
        unique_set = cell(1, n_new);

        % for all values in the embedding
        for i = 1 : n_new
            % get all values of the current row
            row = unique_embedding(i, 1:size(unique_embedding, 2));
            % get all ids with the same row values
            group_ids = all(bsxfun(@eq, row, embedding), 2);
            % if there are more than one which belongs to the value
            if sum(group_ids) > 1
                % calculate one representative object for this group
                unique_set(i) = {func(set(group_ids))};
            else
                % get the only element in this group
                unique_set(i) = set(group_ids);
            end
        end
    else
        % E is unique
        unique_embedding = embedding;
        % so there is nothing to do for the set
        unique_set = set;
    end
end

