function [ weighted_mean, best_value ] = dpe_get_best_weighted_mean( point1, point2, percentage, ...
                             weighted_mean_func, set, best_crit)
%dpe_get_best_weighted_mean returns the weightest mean

%checks, which one of the two following approaches produces
%the weighted mean of the passed pair of strings, that represents the set
%in a better way (in this case the set is itself represented by a
%comparison-set). For this reason the edit path between the pair of objects
%is examined in both directions. At the end it passes the better weighted
%mean.

    mean1 = NaN;
    mean2 = NaN;
    
    % calculate the weighted means from both directions
    if (isnan(percentage))
        mean1 = point1;
        mean2 = point2;
    else
        mean1 = weighted_mean_func(point1, point2, percentage);
        mean2 = weighted_mean_func(point2, point1,1 - percentage);
    end
        
    %select the better mean (the one with the smaller SOD)
    best_value1 = best_crit(set, mean1);
    best_value2 = best_crit(set, mean2);
    if (best_value1 < best_value2)
        weighted_mean = mean1;
        best_value = best_value1;
    else
        weighted_mean = mean2;
        best_value = best_value2;
    end

    
end


