function percentage = dpe_distance_percentage( p1, p2, med)
%DPE_DISTANCE_PERCENTAGE Calcualtes the distance percentage between p1-med
%and p1-p2

     %distance between point 1 and median point
    d_med = norm(p1 - med);
    
    %distance between point 1 and point 2
    d = norm(p1 - p2);

   
    if (d == 0 || isnan(d))
        % if p1 == p2, the percentage can be anything between 0 and 1
        percentage = 0;     
    else
        %the percentage
        percentage = d_med / d;
    end;
    
end

