%% DPE_LINEAR calculates an object of a set 
%  given its embedding and weighted median function
%Parameters:
%   median_vector      - the object to be reconstructed, in vector space
%   unique_embedding   - embedding consisting of only unique vectors (use dpe_group_elements)
%   unique_set         - set only consisting of unique objects
%   weighted_mean_func - weighted mean function @(a,b,alpha) between objects a and b with ratio alpha
%   best_crit          - minimizing criterium for best object (e.g. sum of distance)
%Returns:
%   gen_median   - reconstructed object
%   best_value   - value of best_crit for the reconstructed object

function [ gen_median, best_value ] = dpe_linear(median_vector, unique_embedding, unique_set, weighted_mean_func, best_crit)
    %% get the two nearest neighbours of the euclidean median
    closest_points = knnsearch(unique_embedding, median_vector, 'k', 2);

    %% if there are two nearest neighbours
    if length(closest_points) == 2
        % get the nearest neighbours as row vectors
        closest_vectors = unique_embedding(closest_points, :);

        % Calculate projection and generalized median
        percentage = dpe_project_point_on_line(closest_vectors(1,:), closest_vectors(2,:), median_vector);
        [gen_median, best_value] = dpe_get_best_weighted_mean(unique_set{closest_points(1)}, unique_set{closest_points(2)}, percentage, ...
            weighted_mean_func, unique_set,best_crit);
    else
        %% get the object representation of the only nearest neighbour
        gen_median = unique_set{closest_points};
        best_value = best_crit(unique_set,gen_median);
    end
end
