function [ gen_median ] = dpe_best_points(median_vector, unique_embedding, unique_set, dist_func, weighted_mean_func)
%DPE_BEST_POINTS Removes Points with suboptimal embeddings before doing the reconstruction

    if (isnan(unique_embedding))
        gen_median = dpe_set_median(unique_set,dist_func);
        return;
    end
% Compare Embedding with Original distances
    D_set = dpe_pdist(unique_set,unique_set);
    D_emb = squareform(pdist(unique_embedding));
    
    alpha = nanmedian(nanmedian(D_emb ./ D_set));

    D_diff = sum(abs(D_emb - D_set .* alpha));
    [~, ind] = sort(D_diff,'ascend');
    
    
% Remove outiles
    percentage = 0.8;
    n = numel(unique_set);
    
    num_points = floor(n * percentage);
    ind = ind(1:num_points);
    
    unique_set = unique_set(ind);
    unique_embedding = unique_embedding(ind,:);
    
% do reconstruction
    gen_median = dpe_triangular_recursive(median_vector, unique_embedding, unique_set, dist_func, weighted_mean_func);
    
end

