function [ med ] = dpe_median_vector( vector_matrix, threshold, max_iter)
%DPE_MEDIAN_VECTOR caluclates the geometric median between points in euclidean vector space
% using the Weiszfeld algorithm.
% threshold = termination threshold of the weiszfeld algorithm

if (nargin < 3)
    max_iter = 10000;
end

if (nargin < 2)
    threshold = 1e-10;
end

if (isnan(vector_matrix))
    med = NaN;
    return;
end


%% Weizfeld algorithm        
% non-vectorized version:
% [m,n] = size(vector_matrix);
% y_old = zeros(1,n);
% y_new = ones(1,n);
% y_new = sum(vector_matrix)/n;
% iter = 0;
% 
% while (sqrt(sum((y_new - y_old).^2)) > threshold && iter < max_iter)
%     iter = iter + 1;
%     y_old = y_new;
%     numerator = 0;
%     denominator = 0;
%     for j=1:m
%         x = vector_matrix(j,:);
%         eukl_dist = sqrt(sum((x - y_old).^2));
%         numerator = numerator + (x ./ eukl_dist);
%         denominator = denominator + (1 ./ eukl_dist);
%     end
%     y_new = numerator / denominator;
% end
% med = y_new;

% vectorized version:
[m,n] = size(vector_matrix);
y_old = zeros(1,n);
y_new = ones(1,n);
y_new = sum(vector_matrix)/n;
iter = 0;

while (sqrt(sum((y_new - y_old).^2)) > threshold && iter < max_iter)
    iter = iter + 1;
    y_old = y_new;
    eukl_dist = sqrt(sum((vector_matrix - repmat(y_old,m,1)).^2,2));
    numerator = sum(vector_matrix ./ repmat(eukl_dist,1,n),1);
    denominator = sum(1 ./ eukl_dist);
    y_new = numerator ./ denominator;
end
med = y_new;
 


end
