function [ lower_bound ] = dpe_find_lower_bound( D )
% DPE_FIND_LOWER_BOUND calculates the approximative lower bound of the generalized median
% using the distance matrix D between objects and the method published in:
%
%  On median graphs: properties, algorithms, and applications
%  Xiaoyi Jiang, Andreas Münger and Horst Bunke 
%  IEEE Transactions on Pattern Analysis and Machine Intelligence (2001)
%
%  Modified using graph matching, since one would have to test n! partitions otherwise
    
    n = size(D,1);
    
    % find pairs with graph matiching
    % calculate edges
    edges(:,3) = squareform(D,'tovector'); %pdist(unique_embedding);
    [edges(:,1), edges(:,2)] = find(tril(ones(n),-1));
    
    index = zeros(n,2);
    index(:,1) = 1:n;
    index(:,2) = maxWeightMatching(edges, false);
    
    % remove duplicates
    index = unique(sort(index,2),'rows')';
    
    % remove if first index is -1 -> this one is not in a pair
    if (index(1,1) == -1)
        index = index (:,2:end);
    end
    
    % calculate sum
    index = sub2ind(size(D),index(1,:),index(2,:));

    lower_bound = sum(D(index));

end

