function [ X ] = spring( D_orig, k )
%SPRING Point embedding by Spring simulation.
% Each Pair of Objects o_i and o_j is assigned to points p_i and p_j that are considered to be connected by a spring with length d(o_i,o_j).
% The influence of the springs is simulated. At the end, the position of the points is the embedding of the objects.


% Calculate the distance Matrix
% D_orig = [0 548 289 576 586; 548 0 493 195 392; 289 493 0 427 776; 576 195 427 0 577; 586 392 776 577 0];
% k = 2;
n = length(D_orig);

% Embed random (or cmdscale?)
%X = mdscale(D_orig,k);
%X = cmdscale(D_orig);
%X = X(:,1:k);
X = rand(n,k);

% Calculate Difference
D = squareform(pdist(X));

% set parameters
spring_constant = 1;
mass = 1;
delta_t = 0.1;
max_iter = 1000;

iter = 0;
% f = figure;

        
% while there are changes
while (max(D_orig(:) - D(:)) > 2*eps && iter < max_iter)   
    
    
    % calculate displacements
    D = squareform(pdist(X));
    P = D - D_orig;    
    
    
    % compute spring vectors and force
%     for i = 1:n    
%         spring_vectors = normr(repmat(X(i,:),[n 1]) - X);
%         spring_vectors(i,:) = 0;    
%         spring_force(i,:) = sum(spring_vectors .* -repmat(P(i,:)',[1 k]),1)  * spring_constant;
%         % force = spring vector * displacement * spring_constant
%     end
    spring_vectors = arrayfun(@(i) spring_vector_function(X,n,i),1:n,'UniformOutput',0);
    spring_force = arrayfun(@(i) spring_force_function(spring_vectors{i},P,i,k,spring_constant),1:n,'UniformOutput',0);
    
    
    
    %update positions
    X = X + cell2mat(spring_force') / mass * delta_t;
    
    iter = iter + 1;
end

end

function spring_vector = spring_vector_function(X,n,i)
    spring_vector = normr(repmat(X(i,:),[n 1]) - X); 
    spring_vector(i,:) = 0;
end

function spring_force = spring_force_function(spring_vector, P, i, k, spring_constant)
 spring_force = sum(spring_vector .* -repmat(P(i,:)',[1 k]),1)  * spring_constant;
end
    