function sompak_train_gui()

%SOMPAK_TRAIN_GUI A GUI for using SOM_PAK training program from Matlab.
%
%  sompak_train_gui
%
% Launches a GUI which allows the use of SOM_PAK training program
% (vsom) from Matlab. Notice that to use this function, the SOM_PAK
% programs must be in your search path, or the variable 'SOM_PAKDIR'
% which is a string containing the program path, must be defined in
% the workspace. SOM_PAK programs can be found from:
% http://www.cis.hut.fi/research/som_lvq_pak.shtml
%
% See also SOMPAK_TRAIN, SOMPAK_GUI, SOMPAK_INIT_GUI,
%          SOMPAK_SAMMON_GUI, SOM_GUI.

% Contributed to SOM Toolbox vs2, February 2nd, 2000 by Juha Parhankangas
% Copyright (c) by Juha Parhankangas
% http://www.cis.hut.fi/projects/somtoolbox/

% Juha Parhankangas 050100

h=findobj(get(0,'Children'),'Tag','TrainGUI');

if ~isempty(h)
  figure(h);
  return;
end

a = figure('Color',[0.8 0.8 0.8],... 
	'PaperType','a4letter', ...
	'Position',[558 207 173 445], ...
	'Tag','TrainGUI');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','close gcf', ...
	'FontWeight','demi', ...
	'Position',[8 20 50 20], ...
	'String','CLOSE', ...
	'Tag','Pushbutton1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','sompak_rb_control train_ok',...
	'FontWeight','demi', ...
	'Position',[86 20 50 20], ...
	'String','OK', ...
	'Tag','Pushbutton2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[8 50 130 300], ...
	'Style','frame', ...
	'Tag','Frame1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 54 122 40], ...
	'Style','frame', ...
	'Tag','Frame2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[18 78 110 12], ...
	'String','NEIGHBORHOOD RADIUS', ...
	'Style','text', ...
	'Tag','StaticText1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control radius', ...
	'Position',[48 56 50 20], ...
	'Style','edit', ...
	'Tag','RADIUS');

udata.radius=[];	

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 96 122 40], ...
	'Style','frame', ...
	'Tag','Frame3');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[22 120 101 12], ...
	'String','INITIAL ALPHA VALUE', ...
	'Style','text', ...
	'Tag','StaticText2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control alpha',...
	'Position',[48 99 50 20], ...
	'Style','edit', ...
	'Tag','ALPHA');


udata.alpha=[];


b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 138 122 40], ...
	'Style','frame', ...
	'Tag','Frame4');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[30 163 90 12], ...
	'String','RUNNING LENGTH', ...
	'Style','text', ...
	'Tag','StaticText3');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control rlen',...
	'Position',[48 141 50 20], ...
	'Style','edit', ...
	'Tag','RLEN');

udata.rlen=[];

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 180 122 40], ...
	'Style','frame', ...
	'Tag','Frame5');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[30 204 90 11], ...
	'String','OUTPUT VARIABLE', ...
	'Style','text', ...
	'Tag','StaticText4');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control out_var',...
	'Position',[48 183 50 20], ...
	'String','''ans''',...
	'Style','edit', ...
	'Tag','OUT_VAR');

udata.out_var='ans';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 222 122 40], ...
	'Style','frame', ...
	'Tag','Frame6');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[42 245 65 12], ...
	'String','OUTPUT FILE', ...
	'Style','text', ...
	'Tag','StaticText5');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control out_file',...
	'Position',[15 225 50 20], ...
	'Style','edit', ...
	'Tag','OUT_FILE');

udata.out_file=[];

b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control out_ft',...
	'Units','points', ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Max',3, ...
	'Min',1, ...
	'Position',[70 230 62 15], ...
	'String',{'No File';'mat-file';'cod-file'}, ...
	'Style','popupmenu', ...
	'Tag','OUT_FILE_TYPE', ...
	'Value',1);

udata.out_file_type='';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 264 122 40], ...
	'Style','frame', ...
	'Tag','Frame7');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[34 288 85 12], ...
	'String','TEACHING DATA', ...
	'Style','text', ...
	'Tag','StaticText6');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control data',...
	'Position',[15 267 50 20], ...
	'Style','edit', ...
	'Tag','DATA');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','sompak_rb_control input_ft',...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Max',3, ...
	'Min',1, ...
	'Position',[70 272 62 15], ...
	'String',{'Variable';'mat-file';'dat-file'}, ...
	'Style','popupmenu', ...
	'Tag','INPUT_FILE_TYPE', ...
	'Value',1);

udata.input_file_type='';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 306 122 40], ...
	'Style','frame', ...
	'Tag','Frame8');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[60 331 25 12], ...
	'String','MAP', ...
	'Style','text', ...
	'Tag','StaticText7');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control map',...
	'Position',[15 309 50 20], ...
	'Style','edit', ...
	'Tag','MAP');

udata.map=[];

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','sompak_rb_control map_ft',...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Max',3, ...
	'Min',1, ...
	'Position',[70 314 62 15], ...
	'String',{'Variable','mat-file','cod-file'}, ...
	'Style','popupmenu', ...
	'Tag','MAP_TYPE', ...
	'Value',1);

udata.map_type='';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontSize',12, ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[50 359 48 12], ...
	'String','TRAIN', ...
	'Style','text', ...
	'Tag','StaticText8');

set(gcf,'UserData',udata);

