% DPE calculates the generalized median
% obtained with distance preserving embedding for a given set
% this is a wrapper for easier use of the different functions

function [ gen_median ] = dpe( set, dist_func, weighted_mean_func, embedding_method, target_dim, reconstruction_method)

% calculate the embedding
embedding = dpe_embedding(set,embedding_method,target_dim,dist_func);

% calculate the median point in vector space
median_vector = dpe_median_vector(embedding);

% reconstruct the median vector
gen_median = dpe_reconstruction(median_vector,embedding,set,dist_func,weighted_mean_func,reconstruction_method);

end

