function [ weighetd_mean ] = dpe_string_weighted_mean_func(string1, string2, percentage, string_cost_func)
%DPE_STRING_WEIGHTED_MEAN_FUNC calculates the weighted mean between two strings. 
% For this reason the edit path in the Levenshtein's distance matrix 
% is used, which shows what edit operations has to be done.




    if (nargin < 4)
        string_cost_func = @dpe_string_cost_func;
    end

%% calculate the distance and pointer matrix
    word_lengths = [length(string1) length(string2)];

    %initialization of the distance-matrix
    distance_matrix = zeros(word_lengths(1)+1, word_lengths(2)+1);
    for i = 2:word_lengths(1)+1
        distance_matrix(i,1) = distance_matrix(i-1,1) + string_cost_func('del',string1(i-1));
    end
    for j = 2:word_lengths(2)+1
        distance_matrix(1,j) = distance_matrix(1,j-1) + string_cost_func('ins', string2(j-1));
    end
    
    %initialization of the pointer-matrix
    pointer_matrix = zeros(word_lengths(1)+1, word_lengths(2)+1, 2);
    pointer_matrix(:,1,1) = 0:word_lengths(1);
    pointer_matrix(2:end,1,2) = 1;
    pointer_matrix(1,2:end,1) = 1;
    pointer_matrix(1,:,2) = 0:word_lengths(2);

    %fill the distance-matrix and the pointer-matrix
    for i = 2:word_lengths(1)+1
        for j = 2:word_lengths(2)+1                  
            %check whether nothing has to be done
            if (string1(i-1) == string2(j-1))
                %new entry in the distance-matrix
                distance_matrix(i,j) = distance_matrix(i-1,j-1);
                %new entry in the pointer-matrix
                pointer_matrix(i,j,1) = i-1;
                pointer_matrix(i,j,2) = j-1;      
            else
                left_top = distance_matrix(i-1,j-1) + string_cost_func('sub', string1(i-1), string2(j-1));
                top = distance_matrix(i-1, j) + string_cost_func('del', string1(i-1));
                left = distance_matrix(i, j-1) + string_cost_func('ins', string2(j-1));
            
                %new entry in the distance-matrix
                distance_matrix(i,j) = min([left_top left top]);
            
                %new entry in the pointer-matrix
                if (distance_matrix(i,j) == left_top)
                    %corresponding to a substitution
                    pointer_matrix(i,j,1) = i-1;
                    pointer_matrix(i,j,2) = j-1;
                elseif (distance_matrix(i,j) == top)
                    %corresponding to a deletion
                    pointer_matrix(i,j,1) = i-1;
                    pointer_matrix(i,j,2) = j;
                else %(D(i,j) == LeftWay)
                    %corresponding to an insertion
                    pointer_matrix(i,j,1) = i;
                    pointer_matrix(i,j,2) = j-1;
                end
            end
        end
    end
    distance = distance_matrix(word_lengths(1)+1, word_lengths(2)+1);







%% calculate the weighted mean

    num_edit_steps = round(percentage * distance);
    current_letter = [length(string1) length(string2)];
    cur_edit_steps = 0;
    weighetd_mean = string1;
    direction_top = false;
    direction_left = false;
    
    while ((cur_edit_steps < num_edit_steps) ...
        ... %ATTENTION: THIS IS JUST A BREAK CONDITION TO AVOID A
        ... %PROGRAM-CRASH ARISED BY NEARLY SINGULAR MVM-MATRICES
            && (current_letter(1) > 0) ...
            && (current_letter(2) > 0))
        %Checks whether the pointer has a top-direction
        if (pointer_matrix(current_letter(1) + 1, current_letter(2) + 1, 1) == ...
            current_letter(1))
            direction_top = true;
        end
        %Checks whether the pointer has a left-direction
        if (pointer_matrix(current_letter(1) + 1, current_letter(2) + 1, 2) == ...
            current_letter(2))
            direction_left = true;
        end
        
        %First case: a substitution or nothing has to be done
        if (direction_top && direction_left)
            %Checks whether a substitution has to be done
            if (distance_matrix(current_letter(1), current_letter(2)) < ...
                distance_matrix(current_letter(1)+1, current_letter(2)+1))
                weighetd_mean(current_letter(1)) = ...
                    string2(current_letter(2));
                cur_edit_steps = cur_edit_steps + string_cost_func('sub', ...
                    string1(current_letter(1)), string2(current_letter(2)));
            end
            current_letter(1) = current_letter(1) - 1;
            current_letter(2) = current_letter(2) - 1;
            direction_top = false;
            direction_left = false;
        elseif (direction_top)
            %Second case: a deletion has to be done
            weighetd_mean(current_letter(1)) = '';
            cur_edit_steps = cur_edit_steps + string_cost_func('del', string1(current_letter(1)));
            current_letter(1) = current_letter(1) - 1;
            direction_top = false;
        else
            %Third case: an insertion has to be done
            gMWLength = length(weighetd_mean);
            if (current_letter(1) < gMWLength)
                saveWord = weighetd_mean(current_letter(1)+1:gMWLength);
                weighetd_mean(current_letter(1)+1:gMWLength) = '';
                weighetd_mean = ...
                    strcat(weighetd_mean, string2(current_letter(2)));
                weighetd_mean = ...
                    strcat(weighetd_mean, saveWord);
            else
                weighetd_mean = ...
                    strcat(weighetd_mean, string2(current_letter(2)));
            end
            cur_edit_steps = cur_edit_steps + string_cost_func('ins', string2(current_letter(2)));
            current_letter(2) = current_letter(2) - 1;
            direction_left = false;
        end
        
    end
end

