% DPE_STRING_DIST_FUNC calculates the edit distance between two strings
% 
%
% t1 =                  the first string
% t2 =                  the second string
% string_cost_func = 	function to get the cost for the operations on the
%                       string (operation,char1,char2) 

function [ d ] = dpe_string_dist_func(t1,t2,string_cost_func) 

    if (nargin < 3)
        string_cost_func = @dpe_string_cost_func;
    end
    
	% create the edit matrix
    D = zeros(length(t1)+1, length(t2)+1);
	% fill the first column with constants
    for i = 2:size(D,1)
        D(i,1) = D(i-1,1) + string_cost_func('del', t1(i-1));
    end
	% fill the first row with constants
    for j = 2:size(D,2)
        D(1,j) = D(1,j-1) + string_cost_func('ins', t2(j-1));
    end
	% for all columns
    for i = 2:size(D,1)
		% for all rows
        for j = 2:size(D,2)
			% calculate the costs in the current cell
            D(i,j) = min([D(i-1, j)  + string_cost_func('del', t1(i-1)), ...
                          D(i, j-1)  + string_cost_func('ins', t2(j-1)), ...
                          D(i-1,j-1) + string_cost_func('sub', t1(i-1),t2(j-1))]);
        end
    end
	% the last cell contains the resulting cost
    d = D(end, end);
end

