% DPE_STRING_COST_FUNC returns constant edit costs of 1 for every operation on 
% every pair of characters.
%
% op:       edit operation ('ins' or 'del', else 'sub')
% c1:       first character
% c2:       second character only used if op is 'sub'
function cost = dpe_string_cost_func(op, c1, c2)
    if strcmp(op, 'ins') || strcmp(op, 'del')
        cost = 1;
    else
        cost = c1 ~= c2;
    end
end

