%% generates new string datasets

% structure:
% stringClusters{size,{original,set}}


text_files = {'darwin1','darwin2'};

stringClusters = cell(length(text_files),2);

%% generate set for each string

for i = 1:length(text_files)
   
    % open file
    file = fopen(text_files{i});
      
    stringClusters{i,1} = text_files{i};
     
    set = cell(1,2);
    line = 1;    
    while ~feof(file)
        
                
        % read line
        set{line,1} = fgetl(file);
        
        % generate set, values taken fro König
        set{line,2} = getSynthSet(set{line,1},40,0,true,12,[87 9 4]);
        line = line + 1;
    end
    
    stringClusters{i,2} = set;
end

fclose(file);