/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.appearance;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDAppearanceString;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public class AppearanceGenerator {
    private static final Log LOG = LogFactory.getLog(AppearanceGenerator.class);

    private AppearanceGenerator() {
    }

    public static void generateFieldAppearances(PDField field) {
        if (field instanceof PDVariableText) {
            PDAppearanceString pdAppearance = new PDAppearanceString(field.getAcroForm(), (PDVariableText)field);
            Object fieldValue = field.getValue();
            if (fieldValue == null) {
                fieldValue = "";
            }
            if (fieldValue instanceof COSString) {
                try {
                    pdAppearance.setAppearanceValue(((COSString)fieldValue).getString());
                }
                catch (IOException e) {
                    LOG.debug((Object)"Unable to generate the field appearance.", (Throwable)e);
                }
            } else {
                LOG.debug((Object)("Can't generate the appearance for values typed " + fieldValue.getClass().getName() + "."));
            }
        }
    }
}

