/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class Splitter {
    private PDDocument sourceDocument;
    private PDDocument currentDestinationDocument;
    private int splitLength = 1;
    private int startPage = Integer.MIN_VALUE;
    private int endPage = Integer.MAX_VALUE;
    private List<PDDocument> destinationDocuments;
    private int pageNumber = 0;

    public List<PDDocument> split(PDDocument document) throws IOException {
        this.destinationDocuments = new ArrayList<PDDocument>();
        this.sourceDocument = document;
        this.processPages();
        return this.destinationDocuments;
    }

    public void setSplitAtPage(int split) {
        if (split <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.splitLength = split;
    }

    public void setStartPage(int start) {
        if (start <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.startPage = start;
    }

    public void setEndPage(int end) {
        if (end <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.endPage = end;
    }

    private void processPages() throws IOException {
        for (int i = 0; i < this.sourceDocument.getNumberOfPages(); ++i) {
            PDPage page = this.sourceDocument.getPage(i);
            if (this.pageNumber + 1 >= this.startPage && this.pageNumber + 1 <= this.endPage) {
                this.processPage(page);
                ++this.pageNumber;
                continue;
            }
            if (this.pageNumber > this.endPage) break;
            ++this.pageNumber;
        }
    }

    private void createNewDocumentIfNecessary() throws IOException {
        if (this.splitAtPage(this.pageNumber) || this.currentDestinationDocument == null) {
            this.currentDestinationDocument = this.createNewDocument();
            this.destinationDocuments.add(this.currentDestinationDocument);
        }
    }

    protected boolean splitAtPage(int pageNumber) {
        return pageNumber % this.splitLength == 0;
    }

    protected PDDocument createNewDocument() throws IOException {
        PDDocument document = new PDDocument();
        document.setDocumentInformation(this.getSourceDocument().getDocumentInformation());
        document.getDocumentCatalog().setViewerPreferences(this.getSourceDocument().getDocumentCatalog().getViewerPreferences());
        return document;
    }

    protected void processPage(PDPage page) throws IOException {
        this.createNewDocumentIfNecessary();
        PDPage imported = this.getDestinationDocument().importPage(page);
        imported.setCropBox(page.getCropBox());
        imported.setMediaBox(page.getMediaBox());
        imported.setResources(page.getResources());
        imported.setRotation(page.getRotation());
    }

    protected final PDDocument getSourceDocument() {
        return this.sourceDocument;
    }

    protected final PDDocument getDestinationDocument() {
        return this.currentDestinationDocument;
    }
}

