/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;

public class Overlay {
    private LayoutPage defaultOverlayPage;
    private LayoutPage firstPageOverlayPage;
    private LayoutPage lastPageOverlayPage;
    private LayoutPage oddPageOverlayPage;
    private LayoutPage evenPageOverlayPage;
    private Map<Integer, PDDocument> specificPageOverlay = new HashMap<Integer, PDDocument>();
    private Map<Integer, LayoutPage> specificPageOverlayPage = new HashMap<Integer, LayoutPage>();
    private Position position = Position.BACKGROUND;
    private String inputFileName = null;
    private String outputFilename = null;
    private String defaultOverlayFilename = null;
    private String firstPageOverlayFilename = null;
    private String lastPageOverlayFilename = null;
    private String allPagesOverlayFilename = null;
    private String oddPageOverlayFilename = null;
    private String evenPageOverlayFilename = null;
    private int numberOfOverlayPages = 0;
    private boolean useAllOverlayPages = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlay(Map<Integer, String> specificPageOverlayFile) throws IOException {
        PDDocument evenPageOverlay;
        PDDocument oddPageOverlay;
        PDDocument allPagesOverlay;
        PDDocument lastPageOverlay;
        PDDocument firstPageOverlay;
        PDDocument defaultOverlay;
        block24: {
            PDDocument sourcePDFDocument = null;
            defaultOverlay = null;
            firstPageOverlay = null;
            lastPageOverlay = null;
            allPagesOverlay = null;
            oddPageOverlay = null;
            evenPageOverlay = null;
            try {
                sourcePDFDocument = this.loadPDF(this.inputFileName);
                if (this.defaultOverlayFilename != null) {
                    defaultOverlay = this.loadPDF(this.defaultOverlayFilename);
                    this.defaultOverlayPage = this.getLayoutPage(defaultOverlay);
                }
                if (this.firstPageOverlayFilename != null) {
                    firstPageOverlay = this.loadPDF(this.firstPageOverlayFilename);
                    this.firstPageOverlayPage = this.getLayoutPage(firstPageOverlay);
                }
                if (this.lastPageOverlayFilename != null) {
                    lastPageOverlay = this.loadPDF(this.lastPageOverlayFilename);
                    this.lastPageOverlayPage = this.getLayoutPage(lastPageOverlay);
                }
                if (this.oddPageOverlayFilename != null) {
                    oddPageOverlay = this.loadPDF(this.oddPageOverlayFilename);
                    this.oddPageOverlayPage = this.getLayoutPage(oddPageOverlay);
                }
                if (this.evenPageOverlayFilename != null) {
                    evenPageOverlay = this.loadPDF(this.evenPageOverlayFilename);
                    this.evenPageOverlayPage = this.getLayoutPage(evenPageOverlay);
                }
                if (this.allPagesOverlayFilename != null) {
                    allPagesOverlay = this.loadPDF(this.allPagesOverlayFilename);
                    this.specificPageOverlayPage = this.getLayoutPages(allPagesOverlay);
                    this.useAllOverlayPages = true;
                    this.numberOfOverlayPages = this.specificPageOverlayPage.size();
                }
                for (Map.Entry<Integer, String> entry : specificPageOverlayFile.entrySet()) {
                    PDDocument doc = this.loadPDF(entry.getValue());
                    this.specificPageOverlay.put(entry.getKey(), doc);
                    this.specificPageOverlayPage.put(entry.getKey(), this.getLayoutPage(doc));
                }
                this.processPages(sourcePDFDocument);
                sourcePDFDocument.save(this.outputFilename);
                if (sourcePDFDocument == null) break block24;
            }
            catch (Throwable throwable) {
                if (sourcePDFDocument != null) {
                    sourcePDFDocument.close();
                }
                if (defaultOverlay != null) {
                    defaultOverlay.close();
                }
                if (firstPageOverlay != null) {
                    firstPageOverlay.close();
                }
                if (lastPageOverlay != null) {
                    lastPageOverlay.close();
                }
                if (allPagesOverlay != null) {
                    allPagesOverlay.close();
                }
                if (oddPageOverlay != null) {
                    oddPageOverlay.close();
                }
                if (evenPageOverlay != null) {
                    evenPageOverlay.close();
                }
                for (Map.Entry<Integer, PDDocument> e : this.specificPageOverlay.entrySet()) {
                    e.getValue().close();
                }
                this.specificPageOverlay.clear();
                this.specificPageOverlayPage.clear();
                throw throwable;
            }
            sourcePDFDocument.close();
        }
        if (defaultOverlay != null) {
            defaultOverlay.close();
        }
        if (firstPageOverlay != null) {
            firstPageOverlay.close();
        }
        if (lastPageOverlay != null) {
            lastPageOverlay.close();
        }
        if (allPagesOverlay != null) {
            allPagesOverlay.close();
        }
        if (oddPageOverlay != null) {
            oddPageOverlay.close();
        }
        if (evenPageOverlay != null) {
            evenPageOverlay.close();
        }
        for (Map.Entry<Integer, Object> entry : this.specificPageOverlay.entrySet()) {
            ((PDDocument)entry.getValue()).close();
        }
        this.specificPageOverlay.clear();
        this.specificPageOverlayPage.clear();
    }

    private PDDocument loadPDF(String pdfName) throws IOException {
        return PDDocument.load(new File(pdfName));
    }

    private LayoutPage getLayoutPage(PDDocument doc) throws IOException {
        PDPage page = doc.getPage(0);
        COSBase contents = page.getCOSObject().getDictionaryObject(COSName.CONTENTS);
        PDResources resources = page.getResources();
        if (resources == null) {
            resources = new PDResources();
        }
        return new LayoutPage(page.getMediaBox(), this.createContentStream(contents), resources.getCOSObject());
    }

    private HashMap<Integer, LayoutPage> getLayoutPages(PDDocument doc) throws IOException {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        int numberOfPages = doc.getNumberOfPages();
        HashMap<Integer, LayoutPage> layoutPages = new HashMap<Integer, LayoutPage>(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            PDPage page = doc.getPage(i);
            COSBase contents = page.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            PDResources resources = page.getResources();
            if (resources == null) {
                resources = new PDResources();
            }
            layoutPages.put(i, new LayoutPage(page.getMediaBox(), this.createContentStream(contents), resources.getCOSObject()));
        }
        return layoutPages;
    }

    private COSStream createContentStream(COSBase contents) throws IOException {
        List<COSStream> contentStreams = this.createContentStreamList(contents);
        COSStream concatStream = new COSStream();
        OutputStream out = concatStream.createUnfilteredStream();
        for (COSStream contentStream : contentStreams) {
            int n;
            InputStream in = contentStream.getUnfilteredStream();
            byte[] buf = new byte[2048];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            out.flush();
        }
        out.close();
        concatStream.setFilters(COSName.FLATE_DECODE);
        return concatStream;
    }

    private List<COSStream> createContentStreamList(COSBase contents) throws IOException {
        ArrayList<COSStream> contentStreams = new ArrayList<COSStream>();
        if (contents instanceof COSStream) {
            contentStreams.add((COSStream)contents);
        } else if (contents instanceof COSArray) {
            for (COSBase item : (COSArray)contents) {
                contentStreams.addAll(this.createContentStreamList(item));
            }
        } else if (contents instanceof COSObject) {
            contentStreams.addAll(this.createContentStreamList(((COSObject)contents).getObject()));
        } else {
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
        return contentStreams;
    }

    private void processPages(PDDocument document) throws IOException {
        int pageCount = 0;
        for (PDPage page : document.getPages()) {
            COSDictionary pageDictionary = page.getCOSObject();
            COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            COSArray contentArray = new COSArray();
            switch (this.position) {
                case FOREGROUND: {
                    contentArray.add(this.createStream("q\n"));
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                    } else if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                    } else {
                        throw new IOException("Unknown content type:" + contents.getClass().getName());
                    }
                    contentArray.add(this.createStream("Q\n"));
                    this.overlayPage(contentArray, page, pageCount + 1, document.getNumberOfPages());
                    break;
                }
                case BACKGROUND: {
                    this.overlayPage(contentArray, page, pageCount + 1, document.getNumberOfPages());
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                        break;
                    }
                    if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                        break;
                    }
                    throw new IOException("Unknown content type:" + contents.getClass().getName());
                }
                default: {
                    throw new IOException("Unknown type of position:" + (Object)((Object)this.position));
                }
            }
            pageDictionary.setItem(COSName.CONTENTS, (COSBase)contentArray);
            ++pageCount;
        }
    }

    private void overlayPage(COSArray array, PDPage page, int pageNumber, int numberOfPages) throws IOException {
        LayoutPage layoutPage = null;
        if (!this.useAllOverlayPages && this.specificPageOverlayPage.containsKey(pageNumber)) {
            layoutPage = this.specificPageOverlayPage.get(pageNumber);
        } else if (pageNumber == 1 && this.firstPageOverlayPage != null) {
            layoutPage = this.firstPageOverlayPage;
        } else if (pageNumber == numberOfPages && this.lastPageOverlayPage != null) {
            layoutPage = this.lastPageOverlayPage;
        } else if (pageNumber % 2 == 1 && this.oddPageOverlayPage != null) {
            layoutPage = this.oddPageOverlayPage;
        } else if (pageNumber % 2 == 0 && this.evenPageOverlayPage != null) {
            layoutPage = this.evenPageOverlayPage;
        } else if (this.defaultOverlayPage != null) {
            layoutPage = this.defaultOverlayPage;
        } else if (this.useAllOverlayPages) {
            int usePageNum = (pageNumber - 1) % this.numberOfOverlayPages;
            layoutPage = this.specificPageOverlayPage.get(usePageNum);
        }
        if (layoutPage != null) {
            PDResources resources = page.getResources();
            if (resources == null) {
                resources = new PDResources();
                page.setResources(resources);
            }
            COSName xObjectId = this.createOverlayXObject(page, layoutPage, layoutPage.overlayContentStream);
            array.add(this.createOverlayStream(page, layoutPage, xObjectId));
        }
    }

    private COSName createOverlayXObject(PDPage page, LayoutPage layoutPage, COSStream contentStream) {
        PDFormXObject xobjForm = new PDFormXObject(new PDStream(contentStream));
        xobjForm.setResources(new PDResources(layoutPage.overlayResources));
        xobjForm.setFormType(1);
        xobjForm.setBBox(layoutPage.overlayMediaBox.createRetranslatedRectangle());
        xobjForm.setMatrix(new AffineTransform());
        PDResources resources = page.getResources();
        return resources.add(xobjForm, "OL");
    }

    private COSStream createOverlayStream(PDPage page, LayoutPage layoutPage, COSName xObjectId) throws IOException {
        PDRectangle pageMediaBox = page.getMediaBox();
        float scale = 1.0f;
        float hShift = (pageMediaBox.getWidth() - layoutPage.overlayMediaBox.getWidth()) / 2.0f;
        float vShift = (pageMediaBox.getHeight() - layoutPage.overlayMediaBox.getHeight()) / 2.0f;
        return this.createStream("q\nq " + scale + " 0 0 " + scale + " " + hShift + " " + vShift + " cm /" + xObjectId.getName() + " Do Q\nQ\n");
    }

    private COSStream createStream(String content) throws IOException {
        COSStream stream = new COSStream();
        OutputStream out = stream.createUnfilteredStream();
        out.write(content.getBytes("ISO-8859-1"));
        out.close();
        stream.setFilters(COSName.FLATE_DECODE);
        return stream;
    }

    public void setOverlayPosition(Position overlayPosition) {
        this.position = overlayPosition;
    }

    public void setInputFile(String inputFile) {
        this.inputFileName = inputFile;
    }

    public String getInputFile() {
        return this.inputFileName;
    }

    public void setOutputFile(String outputFile) {
        this.outputFilename = outputFile;
    }

    public String getOutputFile() {
        return this.outputFilename;
    }

    public void setDefaultOverlayFile(String defaultOverlayFile) {
        this.defaultOverlayFilename = defaultOverlayFile;
    }

    public String getDefaultOverlayFile() {
        return this.defaultOverlayFilename;
    }

    public void setFirstPageOverlayFile(String firstPageOverlayFile) {
        this.firstPageOverlayFilename = firstPageOverlayFile;
    }

    public void setLastPageOverlayFile(String lastPageOverlayFile) {
        this.lastPageOverlayFilename = lastPageOverlayFile;
    }

    public void setAllPagesOverlayFile(String allPagesOverlayFile) {
        this.allPagesOverlayFilename = allPagesOverlayFile;
    }

    public void setOddPageOverlayFile(String oddPageOverlayFile) {
        this.oddPageOverlayFilename = oddPageOverlayFile;
    }

    public void setEvenPageOverlayFile(String evenPageOverlayFile) {
        this.evenPageOverlayFilename = evenPageOverlayFile;
    }

    private static class LayoutPage {
        private final PDRectangle overlayMediaBox;
        private final COSStream overlayContentStream;
        private final COSDictionary overlayResources;

        private LayoutPage(PDRectangle mediaBox, COSStream contentStream, COSDictionary resources) {
            this.overlayMediaBox = mediaBox;
            this.overlayContentStream = contentStream;
            this.overlayResources = resources;
        }
    }

    public static enum Position {
        FOREGROUND,
        BACKGROUND;

    }
}

