/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.util.Vector;

public class Matrix
implements Cloneable {
    static final float[] DEFAULT_SINGLE = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private float[] single = new float[DEFAULT_SINGLE.length];

    public Matrix() {
        this.reset();
    }

    public Matrix(COSArray array) {
        this.single[0] = ((COSNumber)array.get(0)).floatValue();
        this.single[1] = ((COSNumber)array.get(1)).floatValue();
        this.single[3] = ((COSNumber)array.get(2)).floatValue();
        this.single[4] = ((COSNumber)array.get(3)).floatValue();
        this.single[6] = ((COSNumber)array.get(4)).floatValue();
        this.single[7] = ((COSNumber)array.get(5)).floatValue();
        this.single[8] = 1.0f;
    }

    public Matrix(float a, float b, float c, float d, float e, float f) {
        this.single[0] = a;
        this.single[1] = b;
        this.single[3] = c;
        this.single[4] = d;
        this.single[6] = e;
        this.single[7] = f;
        this.single[8] = 1.0f;
    }

    public void reset() {
        System.arraycopy(DEFAULT_SINGLE, 0, this.single, 0, DEFAULT_SINGLE.length);
    }

    public AffineTransform createAffineTransform() {
        AffineTransform retval = new AffineTransform(this.single[0], this.single[1], this.single[3], this.single[4], this.single[6], this.single[7]);
        return retval;
    }

    public void setFromAffineTransform(AffineTransform af) {
        this.single[0] = (float)af.getScaleX();
        this.single[1] = (float)af.getShearY();
        this.single[3] = (float)af.getShearX();
        this.single[4] = (float)af.getScaleY();
        this.single[6] = (float)af.getTranslateX();
        this.single[7] = (float)af.getTranslateY();
    }

    public float getValue(int row, int column) {
        return this.single[row * 3 + column];
    }

    public void setValue(int row, int column, float value) {
        this.single[row * 3 + column] = value;
    }

    public float[][] getValues() {
        float[][] retval = new float[3][3];
        retval[0][0] = this.single[0];
        retval[0][1] = this.single[1];
        retval[0][2] = this.single[2];
        retval[1][0] = this.single[3];
        retval[1][1] = this.single[4];
        retval[1][2] = this.single[5];
        retval[2][0] = this.single[6];
        retval[2][1] = this.single[7];
        retval[2][2] = this.single[8];
        return retval;
    }

    public double[][] getValuesAsDouble() {
        double[][] retval = new double[3][3];
        retval[0][0] = this.single[0];
        retval[0][1] = this.single[1];
        retval[0][2] = this.single[2];
        retval[1][0] = this.single[3];
        retval[1][1] = this.single[4];
        retval[1][2] = this.single[5];
        retval[2][0] = this.single[6];
        retval[2][1] = this.single[7];
        retval[2][2] = this.single[8];
        return retval;
    }

    public void concatenate(Matrix matrix) {
        matrix.multiply(this, this);
    }

    public void translate(Vector vector) {
        Matrix m = Matrix.getTranslatingInstance(vector.getX(), vector.getY());
        this.concatenate(m);
    }

    public Matrix multiply(Matrix b) {
        return this.multiply(b, new Matrix());
    }

    public Matrix multiply(Matrix other, Matrix result) {
        if (result == null) {
            result = new Matrix();
        }
        if (other != null && other.single != null) {
            float[] thisOperand = this.single;
            float[] otherOperand = other.single;
            if (this == result) {
                float[] thisOrigVals = new float[this.single.length];
                System.arraycopy(this.single, 0, thisOrigVals, 0, this.single.length);
                thisOperand = thisOrigVals;
            }
            if (other == result) {
                float[] otherOrigVals = new float[other.single.length];
                System.arraycopy(other.single, 0, otherOrigVals, 0, other.single.length);
                otherOperand = otherOrigVals;
            }
            result.single[0] = thisOperand[0] * otherOperand[0] + thisOperand[1] * otherOperand[3] + thisOperand[2] * otherOperand[6];
            result.single[1] = thisOperand[0] * otherOperand[1] + thisOperand[1] * otherOperand[4] + thisOperand[2] * otherOperand[7];
            result.single[2] = thisOperand[0] * otherOperand[2] + thisOperand[1] * otherOperand[5] + thisOperand[2] * otherOperand[8];
            result.single[3] = thisOperand[3] * otherOperand[0] + thisOperand[4] * otherOperand[3] + thisOperand[5] * otherOperand[6];
            result.single[4] = thisOperand[3] * otherOperand[1] + thisOperand[4] * otherOperand[4] + thisOperand[5] * otherOperand[7];
            result.single[5] = thisOperand[3] * otherOperand[2] + thisOperand[4] * otherOperand[5] + thisOperand[5] * otherOperand[8];
            result.single[6] = thisOperand[6] * otherOperand[0] + thisOperand[7] * otherOperand[3] + thisOperand[8] * otherOperand[6];
            result.single[7] = thisOperand[6] * otherOperand[1] + thisOperand[7] * otherOperand[4] + thisOperand[8] * otherOperand[7];
            result.single[8] = thisOperand[6] * otherOperand[2] + thisOperand[7] * otherOperand[5] + thisOperand[8] * otherOperand[8];
        }
        return result;
    }

    public void transform(Point2D point) {
        float x = (float)point.getX();
        float y = (float)point.getY();
        float a = this.single[0];
        float b = this.single[1];
        float c = this.single[3];
        float d = this.single[4];
        float e = this.single[6];
        float f = this.single[7];
        point.setLocation(x * a + y * c + e, x * b + y * d + f);
    }

    public Point2D.Float transformPoint(float x, float y) {
        float a = this.single[0];
        float b = this.single[1];
        float c = this.single[3];
        float d = this.single[4];
        float e = this.single[6];
        float f = this.single[7];
        return new Point2D.Float(x * a + y * c + e, x * b + y * d + f);
    }

    public Vector transform(Vector vector) {
        float a = this.single[0];
        float b = this.single[1];
        float c = this.single[3];
        float d = this.single[4];
        float e = this.single[6];
        float f = this.single[7];
        float x = vector.getX();
        float y = vector.getY();
        return new Vector(x * a + y * c + e, x * b + y * d + f);
    }

    public Matrix extractScaling() {
        Matrix retval = new Matrix();
        retval.single[0] = this.single[0];
        retval.single[4] = this.single[4];
        return retval;
    }

    public static Matrix getScaleInstance(float x, float y) {
        Matrix retval = new Matrix();
        retval.single[0] = x;
        retval.single[4] = y;
        return retval;
    }

    public Matrix extractTranslating() {
        Matrix retval = new Matrix();
        retval.single[6] = this.single[6];
        retval.single[7] = this.single[7];
        return retval;
    }

    public static Matrix getTranslatingInstance(float x, float y) {
        Matrix retval = new Matrix();
        retval.single[6] = x;
        retval.single[7] = y;
        return retval;
    }

    public static Matrix concatenate(Matrix a, Matrix b) {
        Matrix copy = a.clone();
        copy.concatenate(b);
        return copy;
    }

    public Matrix clone() {
        Matrix clone = new Matrix();
        System.arraycopy(this.single, 0, clone.single, 0, 9);
        return clone;
    }

    public float getXScale() {
        float xScale = this.single[0];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            xScale = (float)Math.sqrt(Math.pow(this.single[0], 2.0) + Math.pow(this.single[1], 2.0));
        }
        return xScale;
    }

    public float getYScale() {
        float yScale = this.single[4];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            yScale = (float)Math.sqrt(Math.pow(this.single[3], 2.0) + Math.pow(this.single[4], 2.0));
        }
        return yScale;
    }

    public float getXPosition() {
        return this.single[6];
    }

    public float getYPosition() {
        return this.single[7];
    }

    public COSArray toCOSArray() {
        COSArray array = new COSArray();
        array.add(new COSFloat(0.0f));
        array.add(new COSFloat(1.0f));
        array.add(new COSFloat(3.0f));
        array.add(new COSFloat(4.0f));
        array.add(new COSFloat(6.0f));
        array.add(new COSFloat(7.0f));
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("[");
        sb.append(this.single[0] + ",");
        sb.append(this.single[1] + ",");
        sb.append(this.single[3] + ",");
        sb.append(this.single[4] + ",");
        sb.append(this.single[6] + ",");
        sb.append(this.single[7] + "]");
        return sb.toString();
    }
}

