/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.rendering.font.Glyph2D;

public class CIDType0Glyph2D
implements Glyph2D {
    private static final Log LOG = LogFactory.getLog(CIDType0Glyph2D.class);
    private final HashMap<Integer, GeneralPath> cache = new HashMap();
    private final PDCIDFontType0 font;
    private final String fontName;

    public CIDType0Glyph2D(PDCIDFontType0 font) {
        this.font = font;
        this.fontName = font.getBaseFont();
    }

    @Override
    public GeneralPath getPathForCharacterCode(int code) {
        int cid = this.font.getParent().codeToCID(code);
        if (this.cache.containsKey(code)) {
            return this.cache.get(code);
        }
        try {
            Type2CharString charString = this.font.getType2CharString(cid);
            if (charString.getGID() == 0) {
                String cidHex = String.format("%04x", cid);
                LOG.warn((Object)("No glyph for " + code + " (CID " + cidHex + ") in font " + this.fontName));
            }
            GeneralPath path = charString.getPath();
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            LOG.error((Object)"Glyph rendering failed", (Throwable)e);
            return new GeneralPath();
        }
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

