/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PageDrawer;

public class PDFRenderer {
    protected final PDDocument document;

    public PDFRenderer(PDDocument document) {
        this.document = document;
    }

    public BufferedImage renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f);
    }

    public BufferedImage renderImage(int pageIndex, float scale) throws IOException {
        return this.renderImage(pageIndex, scale, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, imageType);
    }

    public BufferedImage renderImage(int pageIndex, float scale, ImageType imageType) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle cropbBox = page.getCropBox();
        float widthPt = cropbBox.getWidth();
        float heightPt = cropbBox.getHeight();
        int widthPx = Math.round(widthPt * scale);
        int heightPx = Math.round(heightPt * scale);
        int rotationAngle = page.getRotation();
        if (rotationAngle < 0) {
            rotationAngle += 360;
        } else if (rotationAngle >= 360) {
            rotationAngle -= 360;
        }
        BufferedImage image = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, imageType.toBufferedImageType()) : new BufferedImage(widthPx, heightPx, imageType.toBufferedImageType());
        Graphics2D g = image.createGraphics();
        if (imageType != ImageType.ARGB) {
            g.setBackground(Color.WHITE);
        }
        this.renderPage(page, g, image.getWidth(), image.getHeight(), scale, scale);
        g.dispose();
        return image;
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, 1.0f);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scale) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle adjustedCropBox = page.getCropBox();
        this.renderPage(page, graphics, (int)adjustedCropBox.getWidth(), (int)adjustedCropBox.getHeight(), scale, scale);
    }

    private void renderPage(PDPage page, Graphics2D graphics, int width, int height, float scaleX, float scaleY) throws IOException {
        graphics.clearRect(0, 0, width, height);
        graphics.scale(scaleX, scaleY);
        PDRectangle cropBox = page.getCropBox();
        int rotationAngle = page.getRotation();
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
        PageDrawer drawer = new PageDrawer(this, page);
        drawer.drawPage(graphics, cropBox);
    }
}

