/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public abstract class PDVariableText
extends PDField {
    private static final int FLAG_MULTILINE = 4096;
    private static final int FLAG_PASSWORD = 8192;
    private static final int FLAG_FILE_SELECT = 0x100000;
    private static final int FLAG_DO_NOT_SPELL_CHECK = 0x400000;
    private static final int FLAG_DO_NOT_SCROLL = 0x800000;
    private static final int FLAG_COMB = 0x1000000;
    private static final int FLAG_RICH_TEXT = 0x2000000;
    private COSString defaultAppearance;
    public static final int QUADDING_LEFT = 0;
    public static final int QUADDING_CENTERED = 1;
    public static final int QUADDING_RIGHT = 2;

    PDVariableText(PDAcroForm theAcroForm) {
        super(theAcroForm);
    }

    protected PDVariableText(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public boolean isMultiline() {
        return this.getDictionary().getFlag(COSName.FF, 4096);
    }

    public void setMultiline(boolean multiline) {
        this.getDictionary().setFlag(COSName.FF, 4096, multiline);
    }

    public boolean isPassword() {
        return this.getDictionary().getFlag(COSName.FF, 8192);
    }

    public void setPassword(boolean password) {
        this.getDictionary().setFlag(COSName.FF, 8192, password);
    }

    public boolean isFileSelect() {
        return this.getDictionary().getFlag(COSName.FF, 0x100000);
    }

    public void setFileSelect(boolean fileSelect) {
        this.getDictionary().setFlag(COSName.FF, 0x100000, fileSelect);
    }

    public boolean doNotSpellCheck() {
        return this.getDictionary().getFlag(COSName.FF, 0x400000);
    }

    public void setDoNotSpellCheck(boolean doNotSpellCheck) {
        this.getDictionary().setFlag(COSName.FF, 0x400000, doNotSpellCheck);
    }

    public boolean doNotScroll() {
        return this.getDictionary().getFlag(COSName.FF, 0x800000);
    }

    public void setDoNotScroll(boolean doNotScroll) {
        this.getDictionary().setFlag(COSName.FF, 0x800000, doNotScroll);
    }

    public boolean isComb() {
        return this.getDictionary().getFlag(COSName.FF, 0x1000000);
    }

    public void setComb(boolean comb) {
        this.getDictionary().setFlag(COSName.FF, 0x1000000, comb);
    }

    public boolean isRichText() {
        return this.getDictionary().getFlag(COSName.FF, 0x2000000);
    }

    public void setRichText(boolean richText) {
        this.getDictionary().setFlag(COSName.FF, 0x2000000, richText);
    }

    public COSString getDefaultAppearance() {
        PDFieldTreeNode parent;
        COSBase daValue;
        if (this.defaultAppearance == null && (daValue = this.getDictionary().getItem(COSName.DA)) != null) {
            this.defaultAppearance = (COSString)daValue;
        }
        if (this.defaultAppearance == null && (parent = this.getParent()) instanceof PDVariableText) {
            this.defaultAppearance = ((PDVariableText)parent).getDefaultAppearance();
        }
        if (this.defaultAppearance == null) {
            this.defaultAppearance = this.getAcroForm().getDefaultAppearance();
        }
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(String daValue) {
        if (daValue != null) {
            this.defaultAppearance = new COSString(daValue);
            this.getDictionary().setItem(COSName.DA, (COSBase)this.defaultAppearance);
        } else {
            this.defaultAppearance = null;
            this.getDictionary().removeItem(COSName.DA);
        }
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getDictionary().getDictionaryObject(COSName.Q);
        retval = number != null ? number.intValue() : this.getAcroForm().getQ();
        return retval;
    }

    public void setQ(int q) {
        this.getDictionary().setInt(COSName.Q, q);
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object value) {
        throw new RuntimeException("Text fields don't support the \"DV\" entry.");
    }
}

