/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public class PDSignatureField
extends PDField {
    public PDSignatureField(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
        this.getDictionary().setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
        this.getDictionary().setName(COSName.SUBTYPE, "Widget");
    }

    public PDSignatureField(PDAcroForm theAcroForm) throws IOException {
        super(theAcroForm);
        this.getDictionary().setItem(COSName.FT, (COSBase)COSName.SIG);
        this.getWidget().setLocked(true);
        this.getWidget().setPrinted(true);
        this.setPartialName(this.generatePartialName());
        this.getDictionary().setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
        this.getDictionary().setName(COSName.SUBTYPE, "Widget");
    }

    private String generatePartialName() {
        PDAcroForm acroForm = this.getAcroForm();
        List<PDFieldTreeNode> fields = acroForm.getFields();
        String fieldName = "Signature";
        HashSet<String> sigNames = new HashSet<String>();
        for (PDFieldTreeNode field : fields) {
            if (!(field instanceof PDSignatureField)) continue;
            sigNames.add(field.getPartialName());
        }
        int i = 1;
        while (sigNames.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    @Override
    public String toString() {
        return "PDSignatureField";
    }

    public void setSignature(PDSignature value) {
        this.setValue(value);
    }

    public PDSignature getSignature() {
        return this.getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.getDictionary().removeItem(COSName.V);
        } else if (value instanceof PDSignature) {
            this.getDictionary().setItem(COSName.V, (COSObjectable)((PDSignature)value));
        }
    }

    @Override
    public PDSignature getValue() {
        COSBase dictionary = this.getDictionary().getDictionaryObject(COSName.V);
        if (dictionary == null) {
            return null;
        }
        return new PDSignature((COSDictionary)dictionary);
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.SV);
        PDSeedValue sv = null;
        if (dict != null) {
            sv = new PDSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.getDictionary().setItem(COSName.SV, sv.getCOSObject());
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object value) {
        throw new RuntimeException("Signature fields don't support the \"DV\" entry.");
    }
}

