/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public final class PDRadioButton
extends PDButton {
    public PDRadioButton(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        this.getDictionary().setFlag(COSName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return this.getDictionary().getFlag(COSName.FF, 0x2000000);
    }

    @Override
    public COSName getValue() {
        return this.getDictionary().getCOSName(COSName.V);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.getDictionary().removeItem(COSName.V);
        } else if (value instanceof COSName) {
            this.getDictionary().setItem(COSName.V, (COSBase)((COSName)value));
            List<COSObjectable> kids = this.getKids();
            for (COSObjectable kid : kids) {
                if (!(kid instanceof PDCheckbox)) continue;
                PDCheckbox btn = (PDCheckbox)kid;
                if (btn.getOnValue().equals(value)) {
                    btn.check();
                    continue;
                }
                btn.unCheck();
            }
        } else {
            throw new RuntimeException("The value of a redio button has to be a name object.");
        }
    }
}

