/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDComboBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDListBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public abstract class PDFieldTreeNode
implements COSObjectable {
    private static final int FLAG_READ_ONLY = 1;
    private static final int FLAG_REQUIRED = 2;
    private static final int FLAG_NO_EXPORT = 4;
    private static final String FIELD_TYPE_TEXT = "Tx";
    private static final String FIELD_TYPE_BUTTON = "Btn";
    private static final String FIELD_TYPE_CHOICE = "Ch";
    private static final String FIELD_TYPE_SIGNATURE = "Sig";
    private PDAcroForm acroForm;
    private COSDictionary dictionary;
    private PDFieldTreeNode parent = null;

    protected PDFieldTreeNode(PDAcroForm theAcroForm) {
        this(theAcroForm, new COSDictionary(), null);
    }

    protected PDFieldTreeNode(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
        this.parent = parentNode;
    }

    public abstract String getFieldType();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract Object getDefaultValue();

    public abstract void setDefaultValue(Object var1);

    public void setReadonly(boolean readonly) {
        this.getDictionary().setFlag(COSName.FF, 1, readonly);
    }

    public boolean isReadonly() {
        return this.getDictionary().getFlag(COSName.FF, 1);
    }

    public void setRequired(boolean required) {
        this.getDictionary().setFlag(COSName.FF, 2, required);
    }

    public boolean isRequired() {
        return this.getDictionary().getFlag(COSName.FF, 2);
    }

    public void setNoExport(boolean noExport) {
        this.getDictionary().setFlag(COSName.FF, 4, noExport);
    }

    public boolean isNoExport() {
        return this.getDictionary().getFlag(COSName.FF, 4);
    }

    public abstract int getFieldFlags();

    public void setFieldFlags(int flags) {
        this.getDictionary().setInt(COSName.FF, flags);
    }

    public PDFormFieldAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.AA);
        PDFormFieldAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDFormFieldAdditionalActions(aa);
        }
        return retval;
    }

    public void importFDF(FDFField fdfField) throws IOException {
        Integer ff;
        Object fieldValue = fdfField.getValue();
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.setValue((String)fieldValue);
            } else if (fieldValue instanceof PDTextStream) {
                this.setValue(((PDTextStream)fieldValue).getAsString());
            } else {
                throw new IOException("Unknown field type:" + fieldValue.getClass().getName());
            }
        }
        if ((ff = fdfField.getFieldFlags()) != null) {
            this.setFieldFlags(ff);
        } else {
            Integer clrFf;
            Integer setFf = fdfField.getSetFieldFlags();
            if (setFf != null) {
                int setFfInt = setFf;
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = fdfField.getClearFieldFlags()) != null) {
                int clrFfValue = clrFf;
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        PDAnnotationWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
        List<FDFField> fdfKids = fdfField.getKids();
        List<COSObjectable> pdKids = this.getKids();
        for (int i = 0; fdfKids != null && i < fdfKids.size(); ++i) {
            FDFField fdfChild = fdfKids.get(i);
            String fdfName = fdfChild.getPartialFieldName();
            for (COSObjectable pdKid : pdKids) {
                if (!(pdKid instanceof PDFieldTreeNode)) continue;
                PDFieldTreeNode pdChild = (PDFieldTreeNode)pdKid;
                if (fdfName == null || !fdfName.equals(pdChild.getPartialName())) continue;
                pdChild.importFDF(fdfChild);
            }
        }
    }

    public PDAnnotationWidget getWidget() {
        PDAnnotationWidget retval = null;
        List<COSObjectable> kids = this.getKids();
        if (kids == null) {
            retval = new PDAnnotationWidget(this.getDictionary());
        } else if (kids.size() > 0) {
            COSObjectable firstKid = kids.get(0);
            retval = firstKid instanceof PDAnnotationWidget ? (PDAnnotationWidget)firstKid : ((PDFieldTreeNode)firstKid).getWidget();
        }
        return retval;
    }

    public PDFieldTreeNode getParent() {
        return this.parent;
    }

    public void setParent(PDFieldTreeNode parentNode) {
        this.parent = parentNode;
        if (parentNode != null) {
            this.getDictionary().setItem(COSName.PARENT, (COSBase)this.parent.getDictionary());
        } else {
            this.getDictionary().removeItem(COSName.PARENT);
        }
    }

    public PDFieldTreeNode findKid(String[] name, int nameIndex) {
        PDFieldTreeNode retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            for (int i = 0; retval == null && i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (!name[nameIndex].equals(kidDictionary.getString(COSName.T))) continue;
                retval = PDFieldTreeNode.createField(this.acroForm, kidDictionary, this);
                if (name.length <= nameIndex + 1) continue;
                retval = retval.findKid(name, nameIndex + 1);
            }
        }
        return retval;
    }

    public List<COSObjectable> getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.dictionary.getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<COSObjectable> kidsList = new ArrayList<COSObjectable>();
            for (int i = 0; i < kids.size(); ++i) {
                PDFieldTreeNode field;
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (kidDictionary == null) continue;
                COSDictionary parent = (COSDictionary)kidDictionary.getDictionaryObject(COSName.PARENT, COSName.P);
                if (kidDictionary.getDictionaryObject(COSName.FT) != null || parent != null && parent.getDictionaryObject(COSName.FT) != null) {
                    field = PDFieldTreeNode.createField(this.acroForm, kidDictionary, this);
                    if (field == null) continue;
                    kidsList.add(field);
                    continue;
                }
                if ("Widget".equals(kidDictionary.getNameAsString(COSName.SUBTYPE))) {
                    kidsList.add(new PDAnnotationWidget(kidDictionary));
                    continue;
                }
                field = PDFieldTreeNode.createField(this.acroForm, kidDictionary, this);
                if (field == null) continue;
                kidsList.add(field);
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List<COSObjectable> kids) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(kids);
        this.getDictionary().setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(COSName.V);
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm value) {
        this.acroForm = value;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public String getPartialName() {
        return this.getDictionary().getString(COSName.T);
    }

    public void setPartialName(String name) {
        this.getDictionary().setString(COSName.T, name);
    }

    public String getFullyQualifiedName() throws IOException {
        String parentName;
        String finalName = this.getPartialName();
        String string = parentName = this.getParent() != null ? this.getParent().getFullyQualifiedName() : null;
        if (parentName != null) {
            finalName = finalName != null ? parentName + "." + finalName : parentName;
        }
        return finalName;
    }

    public String getAlternateFieldName() {
        return this.getDictionary().getString(COSName.TU);
    }

    public void setAlternateFieldName(String alternateFieldName) {
        this.getDictionary().setString(COSName.TU, alternateFieldName);
    }

    public static PDFieldTreeNode createField(PDAcroForm form, COSDictionary field, PDFieldTreeNode parentNode) {
        String fieldType = PDFieldTreeNode.findFieldType(field);
        if (FIELD_TYPE_CHOICE.equals(fieldType)) {
            int flags = field.getInt(COSName.FF, 0);
            if ((flags & 0x20000) != 0) {
                return new PDComboBox(form, field, parentNode);
            }
            return new PDListBox(form, field, parentNode);
        }
        if (FIELD_TYPE_TEXT.equals(fieldType)) {
            return new PDTextField(form, field, parentNode);
        }
        if (FIELD_TYPE_SIGNATURE.equals(fieldType)) {
            return new PDSignatureField(form, field, parentNode);
        }
        if (FIELD_TYPE_BUTTON.equals(fieldType)) {
            int flags = field.getInt(COSName.FF, 0);
            if ((flags & 0x8000) != 0 || field.getDictionaryObject(COSName.KIDS) != null) {
                return new PDRadioButton(form, field, parentNode);
            }
            if ((flags & 0x10000) != 0) {
                return new PDPushButton(form, field, parentNode);
            }
            return new PDCheckbox(form, field, parentNode);
        }
        return new PDNonTerminalField(form, field, parentNode);
    }

    private static String findFieldType(COSDictionary dic) {
        COSDictionary parent;
        String retval = dic.getNameAsString(COSName.FT);
        if (retval == null && (parent = (COSDictionary)dic.getDictionaryObject(COSName.PARENT, COSName.P)) != null) {
            retval = PDFieldTreeNode.findFieldType(parent);
        }
        return retval;
    }
}

