/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public abstract class PDChoice
extends PDVariableText {
    public static final int FLAG_COMBO = 131072;
    private static final int FLAG_SORT = 524288;
    private static final int FLAG_MULTI_SELECT = 0x200000;
    private static final int FLAG_DO_NOT_SPELL_CHECK = 0x400000;
    private static final int FLAG_COMMIT_ON_SEL_CHANGE = 0x4000000;

    protected PDChoice(PDAcroForm acroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(acroForm, field, parentNode);
    }

    public COSArray getOptions() {
        return (COSArray)this.getDictionary().getDictionaryObject(COSName.OPT);
    }

    public void setOptions(COSArray values) {
        if (values != null) {
            this.getDictionary().setItem(COSName.OPT, (COSBase)values);
        } else {
            this.getDictionary().removeItem(COSName.OPT);
        }
    }

    public COSArray getSelectedOptions() {
        return (COSArray)this.getDictionary().getDictionaryObject(COSName.I);
    }

    public void setSelectedOptions(COSArray values) {
        if (values != null) {
            this.getDictionary().setItem(COSName.I, (COSBase)values);
        } else {
            this.getDictionary().removeItem(COSName.I);
        }
    }

    public boolean isSort() {
        return this.getDictionary().getFlag(COSName.FF, 524288);
    }

    public void setSort(boolean sort) {
        this.getDictionary().setFlag(COSName.FF, 524288, sort);
    }

    public boolean isMultiSelect() {
        return this.getDictionary().getFlag(COSName.FF, 0x200000);
    }

    public void setMultiSelect(boolean multiSelect) {
        this.getDictionary().setFlag(COSName.FF, 0x200000, multiSelect);
    }

    public boolean isDoNotSpellCheck() {
        return this.getDictionary().getFlag(COSName.FF, 0x400000);
    }

    @Override
    public void setDoNotSpellCheck(boolean doNotSpellCheck) {
        this.getDictionary().setFlag(COSName.FF, 0x400000, doNotSpellCheck);
    }

    public boolean isCommitOnSelChange() {
        return this.getDictionary().getFlag(COSName.FF, 0x4000000);
    }

    public void setCommitOnSelChange(boolean commitOnSelChange) {
        this.getDictionary().setFlag(COSName.FF, 0x4000000, commitOnSelChange);
    }

    public boolean isCombo() {
        return this.getDictionary().getFlag(COSName.FF, 131072);
    }

    public void setCombo(boolean combo) {
        this.getDictionary().setFlag(COSName.FF, 131072, combo);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (value instanceof String) {
                this.getDictionary().setString(COSName.V, (String)value);
                int index = this.getSelectedIndex((String)value);
                if (index == -1) {
                    throw new IllegalArgumentException("The list box does not contain the given value.");
                }
                this.selectMultiple(index);
            }
            if (value instanceof String[]) {
                if (!this.isMultiSelect()) {
                    throw new IllegalArgumentException("The list box does allow multiple selection.");
                }
                String[] stringValues = (String[])value;
                COSArray stringArray = new COSArray();
                for (int i = 0; i < stringValues.length; ++i) {
                    stringArray.add(new COSString(stringValues[i]));
                }
                this.getDictionary().setItem(COSName.V, (COSBase)stringArray);
            }
        } else {
            this.getDictionary().removeItem(COSName.V);
        }
    }

    @Override
    public COSArray getValue() {
        COSBase value = this.getDictionary().getDictionaryObject(COSName.V);
        if (value instanceof COSString) {
            COSArray array = new COSArray();
            array.add(value);
            return array;
        }
        if (value instanceof COSArray) {
            return (COSArray)value;
        }
        return null;
    }

    private int getSelectedIndex(String optionValue) {
        int indexSelected = -1;
        COSArray options = this.getOptions();
        for (int i = 0; i < options.size() && indexSelected == -1; ++i) {
            COSBase option = options.getObject(i);
            if (option instanceof COSArray) {
                COSArray keyValuePair = (COSArray)option;
                COSString key = (COSString)keyValuePair.getObject(0);
                COSString value = (COSString)keyValuePair.getObject(1);
                if (!optionValue.equals(key.getString()) && !optionValue.equals(value.getString())) continue;
                indexSelected = i;
                continue;
            }
            COSString value = (COSString)option;
            if (!optionValue.equals(value.getString())) continue;
            indexSelected = i;
        }
        return indexSelected;
    }

    private void selectMultiple(int selectedIndex) {
        COSArray indexArray = this.getSelectedOptions();
        if (indexArray != null) {
            indexArray.clear();
            indexArray.add(COSInteger.get(selectedIndex));
        }
    }
}

