/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public final class PDCheckbox
extends PDButton {
    private COSName value;

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
        COSDictionary ap = (COSDictionary)field.getDictionaryObject(COSName.AP);
        if (ap != null) {
            COSBase n = ap.getDictionaryObject(COSName.N);
            if (n instanceof COSDictionary) {
                for (COSName name : ((COSDictionary)n).keySet()) {
                    if (name.equals(COSName.OFF)) continue;
                    this.value = name;
                }
            }
        } else {
            this.value = (COSName)this.getDictionary().getDictionaryObject(COSName.V);
        }
    }

    public boolean isChecked() {
        boolean retval = false;
        String onValue = this.getOnValue();
        COSName radioValue = (COSName)this.getDictionary().getDictionaryObject(COSName.AS);
        if (radioValue != null && this.value != null && radioValue.getName().equals(onValue)) {
            retval = true;
        }
        return retval;
    }

    public void check() {
        this.getDictionary().setItem(COSName.AS, (COSBase)this.value);
    }

    public void unCheck() {
        this.getDictionary().setItem(COSName.AS, (COSBase)COSName.OFF);
    }

    public String getOffValue() {
        return COSName.OFF.getName();
    }

    public String getOnValue() {
        String retval = null;
        COSDictionary ap = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.AP);
        COSBase n = ap.getDictionaryObject(COSName.N);
        if (n instanceof COSDictionary) {
            for (COSName key : ((COSDictionary)n).keySet()) {
                if (key.equals(COSName.OFF)) continue;
                retval = key.getName();
            }
        }
        return retval;
    }

    @Override
    public COSName getValue() {
        return this.getDictionary().getCOSName(COSName.V);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.getDictionary().removeItem(COSName.V);
            this.getDictionary().setItem(COSName.AS, (COSBase)COSName.OFF);
        } else if (value instanceof COSName) {
            this.getDictionary().setItem(COSName.V, (COSBase)((COSName)value));
            this.getDictionary().setItem(COSName.AS, (COSBase)((COSName)value));
        } else {
            throw new RuntimeException("The value of a checkbox has to be a name object.");
        }
    }
}

