/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public abstract class PDButton
extends PDField {
    public static final int FLAG_NO_TOGGLE_TO_OFF = 16384;
    public static final int FLAG_RADIO = 32768;
    public static final int FLAG_PUSHBUTTON = 65536;
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    protected PDButton(PDAcroForm acroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(acroForm, field, parentNode);
    }

    public List<String> getOptions() {
        COSArrayList retval = null;
        COSArray array = (COSArray)this.getDictionary().getDictionaryObject(COSName.OPT);
        if (array != null) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                strings.add(((COSString)array.getObject(i)).getString());
            }
            retval = new COSArrayList(strings, array);
        }
        return retval;
    }

    public void setOptions(List<String> options) {
        this.getDictionary().setItem(COSName.OPT, (COSBase)COSArrayList.converterToCOSArray(options));
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object value) {
        throw new RuntimeException("Button fields don't support the \"DV\" entry.");
    }
}

