/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public final class PDAppearanceString {
    private static final Log LOG = LogFactory.getLog(PDAppearanceString.class);
    private final PDVariableText parent;
    private String value;
    private final COSString defaultAppearance;
    private final PDAcroForm acroForm;
    private List<COSObjectable> widgets = new ArrayList<COSObjectable>();

    public PDAppearanceString(PDAcroForm theAcroForm, PDVariableText field) {
        this.acroForm = theAcroForm;
        this.parent = field;
        this.widgets = field.getKids();
        if (this.widgets == null) {
            this.widgets = new ArrayList<COSObjectable>();
            this.widgets.add(field.getWidget());
        }
        this.defaultAppearance = this.getDefaultAppearance();
    }

    private COSString getDefaultAppearance() {
        COSString dap = this.parent.getDefaultAppearance();
        if (dap == null) {
            COSArray kids = (COSArray)this.parent.getDictionary().getDictionaryObject(COSName.KIDS);
            if (kids != null && kids.size() > 0) {
                COSDictionary firstKid = (COSDictionary)kids.getObject(0);
                dap = (COSString)firstKid.getDictionaryObject(COSName.DA);
            }
            if (dap == null) {
                dap = (COSString)this.acroForm.getDictionary().getDictionaryObject(COSName.DA);
            }
        }
        return dap;
    }

    private int getQ() {
        COSDictionary firstKid;
        COSNumber qNum;
        COSArray kids;
        int q = this.parent.getQ();
        if (this.parent.getDictionary().getDictionaryObject(COSName.Q) == null && (kids = (COSArray)this.parent.getDictionary().getDictionaryObject(COSName.KIDS)) != null && kids.size() > 0 && (qNum = (COSNumber)(firstKid = (COSDictionary)kids.getObject(0)).getDictionaryObject(COSName.Q)) != null) {
            q = qNum.intValue();
        }
        return q;
    }

    private List<Object> getStreamTokens(PDAppearanceStream appearanceStream) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (appearanceStream != null) {
            tokens = this.getStreamTokens(appearanceStream.getCOSStream());
        }
        return tokens;
    }

    private List<Object> getStreamTokens(COSString string) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (string != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private List<Object> getStreamTokens(COSStream stream) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (stream != null) {
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private boolean containsMarkedContent(List<Object> streamTokens) {
        return streamTokens.contains(Operator.getOperator("BMC"));
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        for (COSObjectable next : this.widgets) {
            ContentStreamWriter writer;
            ByteArrayOutputStream output;
            PDAppearanceEntry normalAppearance;
            PDAppearanceStream appearanceStream;
            PDAnnotationWidget widget;
            PDField field = null;
            if (next instanceof PDField) {
                field = (PDField)next;
                widget = field.getWidget();
            } else {
                widget = (PDAnnotationWidget)next;
            }
            PDFormFieldAdditionalActions actions = null;
            if (field != null) {
                actions = field.getActions();
            }
            if (actions != null && actions.getF() != null && widget.getDictionary().getDictionaryObject(COSName.AP) == null) continue;
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new PDAppearanceDictionary();
                widget.setAppearance(appearance);
            }
            PDAppearanceStream pDAppearanceStream = appearanceStream = (normalAppearance = appearance.getNormalAppearance()).isStream() ? normalAppearance.getAppearanceStream() : null;
            if (appearanceStream == null) {
                COSStream cosStream = this.acroForm.getDocument().getDocument().createCOSStream();
                appearanceStream = new PDAppearanceStream(cosStream);
                appearanceStream.setBBox(widget.getRectangle().createRetranslatedRectangle());
                appearance.setNormalAppearance(appearanceStream);
            }
            List<Object> tokens = this.getStreamTokens(appearanceStream);
            List<Object> daTokens = this.getStreamTokens(this.getDefaultAppearance());
            PDFont pdFont = this.getFontAndUpdateResources(tokens, appearanceStream);
            if (!this.containsMarkedContent(tokens)) {
                output = new ByteArrayOutputStream();
                writer = new ContentStreamWriter(output);
                writer.writeTokens(tokens);
                output.write(" /Tx BMC\n".getBytes("ISO-8859-1"));
                this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                output.write(" EMC".getBytes("ISO-8859-1"));
                this.writeToStream(output.toByteArray(), appearanceStream);
                continue;
            }
            if (tokens == null) continue;
            if (daTokens != null) {
                int bmcIndex = tokens.indexOf(Operator.getOperator("BMC"));
                int emcIndex = tokens.indexOf(Operator.getOperator("EMC"));
                if (bmcIndex != -1 && emcIndex != -1 && emcIndex == bmcIndex + 1) {
                    tokens.addAll(emcIndex, daTokens);
                }
            }
            output = new ByteArrayOutputStream();
            writer = new ContentStreamWriter(output);
            float fontSize = this.calculateFontSize(pdFont, appearanceStream.getBBox(), tokens, daTokens);
            int setFontIndex = tokens.indexOf(Operator.getOperator("Tf"));
            tokens.set(setFontIndex - 1, new COSFloat(fontSize));
            int bmcIndex = tokens.indexOf(Operator.getOperator("BMC"));
            int emcIndex = tokens.indexOf(Operator.getOperator("EMC"));
            if (bmcIndex != -1) {
                writer.writeTokens(tokens, 0, bmcIndex + 1);
            } else {
                writer.writeTokens(tokens);
            }
            output.write("\n".getBytes("ISO-8859-1"));
            this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
            if (emcIndex != -1) {
                writer.writeTokens(tokens, emcIndex, tokens.size());
            }
            this.writeToStream(output.toByteArray(), appearanceStream);
        }
    }

    private void insertGeneratedAppearance(PDAnnotationWidget fieldWidget, OutputStream output, PDFont pdFont, List<Object> tokens, PDAppearanceStream appearanceStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(output, true);
        float fontSize = 0.0f;
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        printWriter.println("BT");
        if (this.defaultAppearance != null) {
            String daString = this.defaultAppearance.getString();
            PDFStreamParser daParser = new PDFStreamParser(new ByteArrayInputStream(daString.getBytes("ISO-8859-1")));
            daParser.parse();
            List<Object> daTokens = daParser.getTokens();
            fontSize = this.calculateFontSize(pdFont, boundingBox, tokens, daTokens);
            int fontIndex = daTokens.indexOf(Operator.getOperator("Tf"));
            if (fontIndex != -1) {
                daTokens.set(fontIndex - 1, new COSFloat(fontSize));
            }
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            daWriter.writeTokens(daTokens);
        }
        PDRectangle borderEdge = this.getSmallestDrawnRectangle(boundingBox, tokens);
        float paddingLeft = Math.max(2, Math.round(4.0f * borderEdge.getLowerLeftX()));
        float paddingRight = Math.max(2, Math.round(4.0f * (boundingBox.getUpperRightX() - borderEdge.getUpperRightX())));
        float verticalOffset = this.getVerticalOffset(boundingBox, pdFont, fontSize, tokens);
        float fontHeight = boundingBox.getHeight() - verticalOffset * 2.0f;
        if (fontHeight + 2.0f * borderEdge.getLowerLeftX() > borderEdge.getHeight()) {
            verticalOffset = pdFont.getBoundingBox().getHeight() / 1000.0f * fontSize - borderEdge.getHeight();
        }
        float leftOffset = 0.0f;
        float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
        int q = this.getQ();
        if (q == 0 || stringWidth > borderEdge.getWidth() - paddingLeft - paddingRight) {
            leftOffset = paddingLeft;
        } else if (q == 1) {
            leftOffset = (boundingBox.getWidth() - stringWidth) / 2.0f;
        } else if (q == 2) {
            leftOffset = boundingBox.getWidth() - stringWidth - paddingRight;
        } else {
            printWriter.println(paddingLeft + " " + verticalOffset + " Td");
            LOG.debug((Object)("Unknown justification value, defaulting to left: " + q));
        }
        printWriter.println(leftOffset + " " + verticalOffset + " Td");
        if (!this.isMultiLineValue(this.value) || stringWidth > borderEdge.getWidth() - paddingLeft - paddingRight) {
            printWriter.println("<" + new COSString(this.value).getHexString() + "> Tj");
        } else {
            String[] paragraphs = this.value.split("\n");
            for (int i = 0; i < paragraphs.length; ++i) {
                boolean lastLine = i == paragraphs.length - 1;
                String endingTag = lastLine ? "> Tj\n" : "> Tj 0 -13 Td";
                printWriter.print("<" + new COSString(paragraphs[i]).getHexString() + endingTag);
            }
        }
        printWriter.println("ET");
        printWriter.flush();
    }

    private PDFont getFontAndUpdateResources(List<Object> tokens, PDAppearanceStream appearanceStream) throws IOException {
        PDFont retval = null;
        PDResources streamResources = appearanceStream.getResources();
        PDResources formResources = this.acroForm.getDefaultResources();
        if (formResources != null) {
            int setFontIndex;
            COSName cosFontName;
            COSString da;
            if (streamResources == null) {
                streamResources = new PDResources();
                appearanceStream.setResources(streamResources);
            }
            if ((da = this.getDefaultAppearance()) != null) {
                String data = da.getString();
                PDFStreamParser streamParser = new PDFStreamParser(new ByteArrayInputStream(data.getBytes("ISO-8859-1")));
                streamParser.parse();
                tokens = streamParser.getTokens();
            }
            if ((retval = streamResources.getFont(cosFontName = (COSName)tokens.get((setFontIndex = tokens.indexOf(Operator.getOperator("Tf"))) - 2))) == null) {
                retval = formResources.getFont(cosFontName);
                streamResources.put(cosFontName, retval);
            }
        }
        return retval;
    }

    private boolean isMultiLineValue(String multiLineValue) {
        return this.parent.isMultiline() && multiLineValue.contains("\n");
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getCOSStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float getLineWidth(List<Object> tokens) {
        float retval = 1.0f;
        if (tokens != null) {
            int btIndex = tokens.indexOf(Operator.getOperator("BT"));
            int wIndex = tokens.indexOf(Operator.getOperator("w"));
            if (wIndex > 0 && wIndex < btIndex) {
                retval = ((COSNumber)tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    private PDRectangle getSmallestDrawnRectangle(PDRectangle boundingBox, List<Object> tokens) {
        PDRectangle smallest = boundingBox;
        for (int i = 0; i < tokens.size(); ++i) {
            Object next = tokens.get(i);
            if (next != Operator.getOperator("re")) continue;
            COSNumber x = (COSNumber)tokens.get(i - 4);
            COSNumber y = (COSNumber)tokens.get(i - 3);
            COSNumber width = (COSNumber)tokens.get(i - 2);
            COSNumber height = (COSNumber)tokens.get(i - 1);
            PDRectangle potentialSmallest = new PDRectangle();
            potentialSmallest.setLowerLeftX(x.floatValue());
            potentialSmallest.setLowerLeftY(y.floatValue());
            potentialSmallest.setUpperRightX(x.floatValue() + width.floatValue());
            potentialSmallest.setUpperRightY(y.floatValue() + height.floatValue());
            if (smallest != null && !(smallest.getLowerLeftX() < potentialSmallest.getLowerLeftX()) && !(smallest.getUpperRightY() > potentialSmallest.getUpperRightY())) continue;
            smallest = potentialSmallest;
        }
        return smallest;
    }

    private float calculateFontSize(PDFont pdFont, PDRectangle boundingBox, List<Object> tokens, List<Object> daTokens) throws IOException {
        int fontIndex;
        float fontSize = 0.0f;
        if (daTokens != null && (fontIndex = daTokens.indexOf(Operator.getOperator("Tf"))) != -1) {
            fontSize = ((COSNumber)daTokens.get(fontIndex - 1)).floatValue();
        }
        float widthBasedFontSize = Float.MAX_VALUE;
        if (this.parent.doNotScroll()) {
            float widthAtFontSize1 = pdFont.getStringWidth(this.value) / 1000.0f;
            float availableWidth = this.getAvailableWidth(boundingBox, this.getLineWidth(tokens));
            widthBasedFontSize = availableWidth / widthAtFontSize1;
        } else if (fontSize == 0.0f) {
            float lineWidth = this.getLineWidth(tokens);
            float height = pdFont.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
            float availHeight = this.getAvailableHeight(boundingBox, lineWidth);
            fontSize = Math.min(availHeight / height, widthBasedFontSize);
        }
        return fontSize;
    }

    private float getVerticalOffset(PDRectangle boundingBox, PDFont pdFont, float fontSize, List<Object> tokens) throws IOException {
        float lineWidth = this.getLineWidth(tokens);
        float verticalOffset = 0.0f;
        if (this.parent.isMultiline()) {
            int rows = (int)(this.getAvailableHeight(boundingBox, lineWidth) / (float)((int)fontSize));
            verticalOffset = (float)rows * fontSize - fontSize;
        } else {
            PDFontDescriptor fd = pdFont.getFontDescriptor();
            float bBoxHeight = boundingBox.getHeight();
            float fontHeight = fd.getFontBoundingBox().getHeight() + 2.0f * fd.getDescent();
            fontHeight = fontHeight / 1000.0f * fontSize;
            verticalOffset = (bBoxHeight - fontHeight) / 2.0f;
        }
        return verticalOffset;
    }

    private float getAvailableWidth(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getWidth() - 2.0f * lineWidth;
    }

    private float getAvailableHeight(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getHeight() - 2.0f * lineWidth;
    }
}

