/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class PDOutlineNode
implements COSObjectable {
    protected COSDictionary node;

    public PDOutlineNode() {
        this.node = new COSDictionary();
    }

    public PDOutlineNode(COSDictionary dict) {
        this.node = dict;
    }

    @Override
    public COSBase getCOSObject() {
        return this.node;
    }

    public COSDictionary getCOSDictionary() {
        return this.node;
    }

    protected PDOutlineNode getParent() {
        PDOutlineNode retval = null;
        COSDictionary parent = (COSDictionary)this.node.getDictionaryObject(COSName.PARENT, COSName.P);
        if (parent != null) {
            retval = parent.getDictionaryObject(COSName.PARENT, COSName.P) == null ? new PDDocumentOutline(parent) : new PDOutlineItem(parent);
        }
        return retval;
    }

    protected void setParent(PDOutlineNode parent) {
        this.node.setItem("Parent", (COSObjectable)parent);
    }

    public void appendChild(PDOutlineItem outlineNode) {
        outlineNode.setParent(this);
        if (this.getFirstChild() == null) {
            int currentOpenCount = this.getOpenCount();
            this.setFirstChild(outlineNode);
            int numberOfOpenNodesWeAreAdding = 1;
            if (outlineNode.isNodeOpen()) {
                numberOfOpenNodesWeAreAdding += outlineNode.getOpenCount();
            }
            if (this.isNodeOpen()) {
                this.setOpenCount(currentOpenCount + numberOfOpenNodesWeAreAdding);
            } else {
                this.setOpenCount(currentOpenCount - numberOfOpenNodesWeAreAdding);
            }
            this.updateParentOpenCount(numberOfOpenNodesWeAreAdding);
        } else {
            PDOutlineItem previousLastChild = this.getLastChild();
            previousLastChild.insertSiblingAfter(outlineNode);
        }
        PDOutlineItem lastNode = outlineNode;
        while (lastNode.getNextSibling() != null) {
            lastNode = lastNode.getNextSibling();
        }
        this.setLastChild(lastNode);
    }

    public PDOutlineItem getFirstChild() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject("First");
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setFirstChild(PDOutlineNode outlineNode) {
        this.node.setItem("First", (COSObjectable)outlineNode);
    }

    public PDOutlineItem getLastChild() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject("Last");
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setLastChild(PDOutlineNode outlineNode) {
        this.node.setItem("Last", (COSObjectable)outlineNode);
    }

    public int getOpenCount() {
        return this.node.getInt("Count", 0);
    }

    protected void setOpenCount(int openCount) {
        this.node.setInt("Count", openCount);
    }

    public void openNode() {
        if (!this.isNodeOpen()) {
            int openChildrenCount = 0;
            for (PDOutlineItem currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                ++openChildrenCount;
                if (!currentChild.isNodeOpen()) continue;
                openChildrenCount += currentChild.getOpenCount();
            }
            this.setOpenCount(openChildrenCount);
            this.updateParentOpenCount(openChildrenCount);
        }
    }

    public void closeNode() {
        if (this.isNodeOpen()) {
            int openCount = this.getOpenCount();
            this.updateParentOpenCount(-openCount);
            this.setOpenCount(-openCount);
        }
    }

    public boolean isNodeOpen() {
        return this.getOpenCount() > 0;
    }

    protected void updateParentOpenCount(int amount) {
        PDOutlineNode parent = this.getParent();
        if (parent != null) {
            int currentCount = parent.getOpenCount();
            boolean negative = currentCount < 0 || parent.getCOSDictionary().getDictionaryObject("Count") == null;
            currentCount = Math.abs(currentCount);
            currentCount += amount;
            if (negative) {
                currentCount = -currentCount;
            }
            parent.setOpenCount(currentCount);
            if (!negative) {
                parent.updateParentOpenCount(amount);
            }
        }
    }
}

