/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDestinationNameTreeNode;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PDOutlineItem
extends PDOutlineNode {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public PDOutlineItem() {
    }

    public PDOutlineItem(COSDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(PDOutlineItem item) {
        item.setParent(this.getParent());
        PDOutlineItem next = this.getNextSibling();
        this.setNextSibling(item);
        item.setPreviousSibling(this);
        if (next != null) {
            item.setNextSibling(next);
            next.setPreviousSibling(item);
        }
        this.updateParentOpenCount(1);
    }

    @Override
    public PDOutlineNode getParent() {
        return super.getParent();
    }

    public PDOutlineItem getPreviousSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject(COSName.PREV);
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setPreviousSibling(PDOutlineNode outlineNode) {
        this.node.setItem(COSName.PREV, (COSObjectable)outlineNode);
    }

    public PDOutlineItem getNextSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject(COSName.NEXT);
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setNextSibling(PDOutlineNode outlineNode) {
        this.node.setItem(COSName.NEXT, (COSObjectable)outlineNode);
    }

    public String getTitle() {
        return this.node.getString(COSName.TITLE);
    }

    public void setTitle(String title) {
        this.node.setString(COSName.TITLE, title);
    }

    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.node.getDictionaryObject(COSName.DEST));
    }

    public void setDestination(PDDestination dest) {
        this.node.setItem(COSName.DEST, (COSObjectable)dest);
    }

    public void setDestination(PDPage page) {
        PDPageXYZDestination dest = null;
        if (page != null) {
            dest = new PDPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PDPage findDestinationPage(PDDocument doc) throws IOException {
        PDPageDestination pageDestination;
        PDDestination dest = this.getDestination();
        if (dest == null) {
            PDAction outlineAction = this.getAction();
            if (!(outlineAction instanceof PDActionGoTo)) return null;
            dest = ((PDActionGoTo)outlineAction).getDestination();
        }
        if (dest instanceof PDNamedDestination) {
            PDNamedDestination namedDest = (PDNamedDestination)dest;
            PDDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
            if (namesDict == null) return null;
            PDDestinationNameTreeNode destsTree = namesDict.getDests();
            if (destsTree == null) return null;
            pageDestination = (PDPageDestination)destsTree.getValue(namedDest.getNamedDestination());
        } else if (dest instanceof PDPageDestination) {
            pageDestination = (PDPageDestination)dest;
        } else {
            if (dest != null) throw new IOException("Error: Unknown destination type " + dest);
            return null;
        }
        PDPage page = pageDestination.getPage();
        if (page != null) return page;
        int pageNumber = pageDestination.getPageNumber();
        if (pageNumber == -1) return page;
        return doc.getPage(pageNumber - 1);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.node.getDictionaryObject(COSName.A));
    }

    public void setAction(PDAction action) {
        this.node.setItem(COSName.A, (COSObjectable)action);
    }

    public PDStructureElement getStructureElement() {
        PDStructureElement se = null;
        COSDictionary dic = (COSDictionary)this.node.getDictionaryObject(COSName.SE);
        if (dic != null) {
            se = new PDStructureElement(dic);
        }
        return se;
    }

    public void setStructuredElement(PDStructureElement structureElement) {
        this.node.setItem(COSName.SE, (COSObjectable)structureElement);
    }

    public PDColor getTextColor() {
        PDColor retval = null;
        COSArray csValues = (COSArray)this.node.getDictionaryObject(COSName.C);
        if (csValues == null) {
            csValues = new COSArray();
            csValues.growToSize(3, new COSFloat(0.0f));
            this.node.setItem(COSName.C, (COSBase)csValues);
        }
        retval = new PDColor(csValues.toFloatArray(), (PDColorSpace)PDDeviceRGB.INSTANCE);
        return retval;
    }

    public void setTextColor(PDColor textColor) {
        this.node.setItem(COSName.C, (COSBase)textColor.toCOSArray());
    }

    public void setTextColor(Color textColor) {
        COSArray array = new COSArray();
        array.add(new COSFloat((float)textColor.getRed() / 255.0f));
        array.add(new COSFloat((float)textColor.getGreen() / 255.0f));
        array.add(new COSFloat((float)textColor.getBlue() / 255.0f));
        this.node.setItem(COSName.C, (COSBase)array);
    }

    public boolean isItalic() {
        return this.node.getFlag(COSName.F, 1);
    }

    public void setItalic(boolean italic) {
        this.node.setFlag(COSName.F, 1, italic);
    }

    public boolean isBold() {
        return this.node.getFlag(COSName.F, 2);
    }

    public void setBold(boolean bold) {
        this.node.setFlag(COSName.F, 2, bold);
    }
}

