/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.action;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;

public class PDActionFactory {
    private PDActionFactory() {
    }

    public static PDAction createAction(COSDictionary action) {
        PDAction retval = null;
        if (action != null) {
            String type = action.getNameAsString("S");
            if ("JavaScript".equals(type)) {
                retval = new PDActionJavaScript(action);
            } else if ("GoTo".equals(type)) {
                retval = new PDActionGoTo(action);
            } else if ("Launch".equals(type)) {
                retval = new PDActionLaunch(action);
            } else if ("GoToR".equals(type)) {
                retval = new PDActionRemoteGoTo(action);
            } else if ("URI".equals(type)) {
                retval = new PDActionURI(action);
            }
        }
        return retval;
    }
}

