/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.CoonsPatch;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.apache.pdfbox.pdmodel.graphics.shading.PatchMeshesShadingContext;
import org.apache.pdfbox.util.Matrix;

class Type6ShadingContext
extends PatchMeshesShadingContext {
    public Type6ShadingContext(PDShadingType6 shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, dBounds);
        this.patchList = this.getCoonsPatchList(xform, ctm);
        this.pixelTable = this.calcPixelTable();
    }

    private ArrayList<Patch> getCoonsPatchList(AffineTransform xform, Matrix ctm) throws IOException {
        PDShadingType6 coonsShadingType = (PDShadingType6)this.patchMeshesShadingType;
        COSDictionary cosDictionary = coonsShadingType.getCOSDictionary();
        PDRange rangeX = coonsShadingType.getDecodeForParameter(0);
        PDRange rangeY = coonsShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = coonsShadingType.getDecodeForParameter(2 + i);
        }
        return this.getPatchList(xform, ctm, cosDictionary, rangeX, rangeY, colRange, 12);
    }

    @Override
    protected Patch generatePatch(Point2D[] points, float[][] color) {
        return new CoonsPatch(points, color);
    }
}

