/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType1;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadingContext;
import org.apache.pdfbox.util.Matrix;

class Type1ShadingContext
extends ShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(Type1ShadingContext.class);
    private PDShadingType1 type1ShadingType;
    private AffineTransform rat;
    private final float[] domain;
    private Matrix matrix;
    private float[] background;

    public Type1ShadingContext(PDShadingType1 shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, dBounds);
        this.type1ShadingType = shading;
        this.domain = shading.getDomain() != null ? shading.getDomain().toFloatArray() : new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        this.matrix = shading.getMatrix();
        if (this.matrix == null) {
            this.matrix = new Matrix();
        }
        try {
            this.rat = this.matrix.createAffineTransform().createInverse();
            this.rat.concatenate(ctm.createAffineTransform().createInverse());
            this.rat.concatenate(xform.createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        COSArray bg = shading.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
        }
    }

    @Override
    public void dispose() {
        this.outputColorModel = null;
        this.shadingColorSpace = null;
        this.type1ShadingType = null;
    }

    @Override
    public ColorModel getColorModel() {
        return this.outputColorModel;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            int currentY = y + j;
            if (this.bboxRect != null && ((float)currentY < this.minBBoxY || (float)currentY > this.maxBBoxY)) continue;
            for (int i = 0; i < w; ++i) {
                int currentX = x + i;
                if (this.bboxRect != null && ((float)currentX < this.minBBoxX || (float)currentX > this.maxBBoxX)) continue;
                int index = (j * w + i) * 4;
                boolean useBackground = false;
                float[] values = new float[]{x + i, y + j};
                this.rat.transform(values, 0, values, 0, 1);
                if (values[0] < this.domain[0] || values[0] > this.domain[1] || values[1] < this.domain[2] || values[1] > this.domain[3]) {
                    if (this.background == null) continue;
                    useBackground = true;
                }
                if (useBackground) {
                    values = this.background;
                } else {
                    try {
                        values = this.type1ShadingType.evalFunction(values);
                    }
                    catch (IOException exception) {
                        LOG.error((Object)"error while processing a function", (Throwable)exception);
                    }
                }
                if (this.shadingColorSpace != null) {
                    try {
                        values = this.shadingColorSpace.toRGB(values);
                    }
                    catch (IOException exception) {
                        LOG.error((Object)"error processing color space", (Throwable)exception);
                    }
                }
                data[index] = (int)(values[0] * 255.0f);
                data[index + 1] = (int)(values[1] * 255.0f);
                data[index + 2] = (int)(values[2] * 255.0f);
                data[index + 3] = 255;
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    public float[] getDomain() {
        return this.domain;
    }
}

