/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.util.Matrix;

public abstract class ShadingContext {
    private static final Log LOG = LogFactory.getLog(ShadingContext.class);
    protected final PDShading shading;
    protected final Rectangle deviceBounds;
    protected PDColorSpace shadingColorSpace;
    protected PDRectangle bboxRect;
    protected float minBBoxX;
    protected float minBBoxY;
    protected float maxBBoxX;
    protected float maxBBoxY;
    protected ColorModel outputColorModel;

    public ShadingContext(PDShading shading, ColorModel cm, AffineTransform xform, Matrix ctm, Rectangle dBounds) throws IOException {
        this.shading = shading;
        this.deviceBounds = dBounds;
        this.shadingColorSpace = shading.getColorSpace();
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        this.bboxRect = shading.getBBox();
        if (this.bboxRect != null) {
            this.transformBBox(ctm, xform);
        }
    }

    private void transformBBox(Matrix ctm, AffineTransform xform) {
        float[] bboxTab = new float[]{this.bboxRect.getLowerLeftX(), this.bboxRect.getLowerLeftY(), this.bboxRect.getUpperRightX(), this.bboxRect.getUpperRightY()};
        if (ctm != null) {
            ctm.createAffineTransform().transform(bboxTab, 0, bboxTab, 0, 2);
        }
        xform.transform(bboxTab, 0, bboxTab, 0, 2);
        this.minBBoxX = Math.min(bboxTab[0], bboxTab[2]);
        this.minBBoxY = Math.min(bboxTab[1], bboxTab[3]);
        this.maxBBoxX = Math.max(bboxTab[0], bboxTab[2]);
        this.maxBBoxY = Math.max(bboxTab[1], bboxTab[3]);
        if (this.minBBoxX >= this.maxBBoxX || this.minBBoxY >= this.maxBBoxY) {
            LOG.warn((Object)"empty BBox is ignored");
            this.bboxRect = null;
        }
    }

    protected int convertToRGB(float[] values) {
        int normRGBValues = 0;
        try {
            float[] rgbValues = this.shadingColorSpace.toRGB(values);
            normRGBValues = (int)(rgbValues[0] * 255.0f);
            normRGBValues |= (int)(rgbValues[1] * 255.0f) << 8;
            normRGBValues |= (int)(rgbValues[2] * 255.0f) << 16;
        }
        catch (IOException exception) {
            LOG.error((Object)"error processing color space", (Throwable)exception);
        }
        return normRGBValues;
    }
}

