/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.rendering.PageDrawer;

public class TilingPaint
implements Paint {
    private final PDTilingPattern pattern;
    private final TexturePaint paint;

    public TilingPaint(PageDrawer drawer, PDTilingPattern pattern, AffineTransform xform) throws IOException {
        this.paint = new TexturePaint(TilingPaint.getImage(drawer, pattern, null, null, xform), TilingPaint.getAnchorRect(pattern));
        this.pattern = pattern;
    }

    public TilingPaint(PageDrawer drawer, PDTilingPattern pattern, PDColorSpace colorSpace, PDColor color, AffineTransform xform) throws IOException {
        this.paint = new TexturePaint(TilingPaint.getImage(drawer, pattern, colorSpace, color, xform), TilingPaint.getAnchorRect(pattern));
        this.pattern = pattern;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        AffineTransform xformPattern = (AffineTransform)xform.clone();
        xformPattern.concatenate(this.pattern.getMatrix().createAffineTransform());
        return this.paint.createContext(cm, deviceBounds, userBounds, xformPattern, hints);
    }

    private static BufferedImage getImage(PageDrawer drawer, PDTilingPattern pattern, PDColorSpace colorSpace, PDColor color, AffineTransform xform) throws IOException {
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(outputCS, true, false, 3, 0);
        Rectangle2D anchor = TilingPaint.getAnchorRect(pattern);
        float width = (float)Math.abs(anchor.getWidth());
        float height = (float)Math.abs(anchor.getHeight());
        int rasterWidth = Math.max(1, TilingPaint.ceiling(width *= (float)xform.getScaleX()));
        int rasterHeight = Math.max(1, TilingPaint.ceiling(height *= (float)xform.getScaleY()));
        WritableRaster raster = ((ColorModel)cm).createCompatibleWritableRaster(rasterWidth, rasterHeight);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        Graphics2D graphics = image.createGraphics();
        graphics.transform(xform);
        drawer.drawTilingPattern(graphics, pattern, colorSpace, color);
        graphics.dispose();
        return image;
    }

    private static int ceiling(double num) {
        BigDecimal decimal = new BigDecimal(num);
        decimal.setScale(5, RoundingMode.CEILING);
        return decimal.intValue();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public static Rectangle2D getAnchorRect(PDTilingPattern pattern) {
        float yStep;
        float xStep = pattern.getXStep();
        if (xStep == 0.0f) {
            xStep = pattern.getBBox().getWidth();
        }
        if ((yStep = pattern.getYStep()) == 0.0f) {
            yStep = pattern.getBBox().getHeight();
        }
        PDRectangle anchor = pattern.getBBox();
        return new Rectangle2D.Float(anchor.getLowerLeftX(), anchor.getLowerLeftY(), xStep, yStep);
    }
}

